/* This file has been automatically generated by builder part of the ferite distribution */
/* file:  sys_Sys_Stream.c */
/* class: Stream */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( sys_Sys_Stream_Stream_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 223 "std.fec"

       
           struct Stream *Stream = fcalloc( 1, sizeof( struct Stream ) );
           Stream->lock = aphex_mutex_recursive_create();
           Stream->endofline = fstrdup("\n");
           Stream->input_buffer.data = fmalloc( STREAM_READ_BUFFER );
           Stream->input_buffer.length = 0;
           Stream->output_buffer = ferite_buffer_new( 0 );
           Stream->read = ferite_find_function_in_object( script, self, "__read__" );
           Stream->write = ferite_find_function_in_object( script, self, "__write__" );
           Stream->errmsg = NULL;
           Stream->eos = 1;
           self->odata = Stream;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_writeln_s )
{
   FeriteString *s;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &s, &super, &self );

   { /* Main function body. */
#line 369 "std.fec"

       
           struct Stream *Stream = self->odata;
           int length = strlen( Stream->endofline );

           lock_object;
           ferite_buffer_add( Stream->output_buffer, s->data, s->length );
           ferite_buffer_add( Stream->output_buffer, Stream->endofline, length );
           if( !Stream->aggressive )
             stream_flush( script, self );
           unlock_object;
           FE_RETURN_LONG( s->length + length );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_getError_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 268 "std.fec"

       
           FeriteVariable *v;
           struct Stream *Stream = self->odata;
           v = fe_new_str_static("StreamError", Stream->errmsg, 0, FE_CHARSET_DEFAULT );
           if( Stream->errmsg )
             ffree( Stream->errmsg );
           Stream->errmsg = NULL;
           FE_RETURN_VAR( v );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_flush_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 438 "std.fec"

       
           lock_object;
           stream_flush( script, self );
           unlock_object;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_putc_s )
{
   FeriteString *c;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &c, &super, &self );

   { /* Main function body. */
#line 323 "std.fec"

       
           struct Stream *Stream = self->odata;
           if( c->length != 1 )
             FE_RETURN_FALSE;
           lock_object;
           ferite_buffer_add_char( Stream->output_buffer, c->data[0] );
           unlock_object;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_setEndofline_s )
{
   FeriteString *s;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &s, &super, &self );

   { /* Main function body. */
#line 284 "std.fec"

       
           struct Stream *Stream = self->odata;
           lock_object;
           if( Stream->endofline )
             ffree( Stream->endofline );
           Stream->endofline = fstrdup( s->data );
           unlock_object;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream___read___n )
{
   double count;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &count, &super, &self );

   { /* Main function body. */
#line 629 "std.fec"

       
           FE_RETURN_VAR( fe_new_str_static( "read", NULL, 0, FE_CHARSET_DEFAULT ) );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_read_n )
{
   double c;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &c, &super, &self );

   { /* Main function body. */
#line 550 "std.fec"

       
           FeriteVariable *retval,*v;
           FeriteVariable **parms;
           long count = (long)c, offset,left,length,i=0;
           char *str;
           struct Stream *Stream = self->odata;

           v = fe_new_str_static( "read", NULL, count, FE_CHARSET_DEFAULT );
           FE_STRLEN(v) = 0;
           left = count;
           lock_object;
           while( left &&  Stream->read != NULL )
           {
               length = 0;

                /* Check buffer and copy from here in first place */
               if( Stream->input_buffer.length )
               {
                   length = (Stream->input_buffer.length > count) ? count : Stream->input_buffer.length;
                   memcpy( FE_STR2PTR(v), Stream->input_buffer.data, length );
                   memcpy( Stream->input_buffer.data, Stream->input_buffer.data + length, Stream->input_buffer.length - length );
                   Stream->input_buffer.length -= length;
                   left -= length;
                   continue;
               }
                /* Call __read__ to fill up buffer (the buffer wasn't filled enough) */
               i = VAI(params[0]);
               VAI(params[0]) = (left > STREAM_READ_BUFFER) ? left : STREAM_READ_BUFFER;
               retval = ferite_call_function( script, Stream->read, params );
               VAI(params[0]) = i;
               if( FE_STRLEN(retval) == 0 )
               {
                   ferite_variable_destroy( script, retval );
                   break;
               }
                /* If we have got to much, copy the rest to the buffer */
               if( FE_STRLEN(retval) > left )
               {
                   Stream->input_buffer.length = FE_STRLEN(retval) - left;
                   memcpy( Stream->input_buffer.data, FE_STR2PTR(retval) + left , Stream->input_buffer.length );
                   FE_STRLEN(retval) -= Stream->input_buffer.length;
               }
               memcpy( FE_STR2PTR(v) + (count - left), FE_STR2PTR(retval), FE_STRLEN(retval) );
               left -= FE_STRLEN(retval);
               ferite_variable_destroy( script, retval );

           }
           FE_STRLEN( v ) = count - left;
           unlock_object;
           FE_RETURN_VAR( v );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_ungetc_s )
{
   FeriteString *c;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &c, &super, &self );

   { /* Main function body. */
#line 462 "std.fec"

       
           struct Stream *Stream = self->odata;
           if( c->length != 1 )
             FE_RETURN_FALSE;
           lock_object;
           Stream->input_buffer.length++;
           Stream->input_buffer.data[Stream->input_buffer.length] = c->data[0];
           unlock_object;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_setAggressive_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 301 "std.fec"

       
           struct Stream *Stream = self->odata;
           Stream->aggressive = 1;
           FE_RETURN_TRUE;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_readln_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 481 "std.fec"

       
           FeriteVariable *v, *retval, *count;
           struct Stream *Stream = self->odata;
           int i, len, eoflen = strlen(Stream->endofline);
           FeriteVariable **args;

           args = ferite_create_parameter_list_from_data( script, "noo", (double)0, self, self );
           args[0]->type = F_VAR_LONG;

           i = 0;
           lock_object;
           while( FE_TRUE /* i < STREAM_READ_BUFFER */ )
           {
	       /* Search buffer for EOL, if found we create a string and move buffer up */
               for(; i < Stream->input_buffer.length ; i++ )
               {
                   if( Stream->input_buffer.data[i] == Stream->endofline[0] &&
                       memcmp( Stream->input_buffer.data + i, Stream->endofline, eoflen) == 0 )
                   {
                       if( i == 0)
                         Stream->input_buffer.data[0] = '\0';
                       v = fe_new_str_static( "read", Stream->input_buffer.data, i + eoflen, FE_CHARSET_DEFAULT );
                       memmove( Stream->input_buffer.data,
                                Stream->input_buffer.data + i + eoflen,
                                Stream->input_buffer.length - i - eoflen );
                       Stream->input_buffer.length -= i + eoflen;
                       ferite_delete_parameter_list( script, args );
                       unlock_object;
		       
		       /* We have enough data within the buffer */
                       FE_RETURN_VAR( v );
                   }
               }
                /* Fill up the buffer by calling __read__ */
               VAI(args[0]) = STREAM_READ_BUFFER - Stream->input_buffer.length;
               retval = ferite_call_function( script, Stream->read, args );
               len = FE_STRLEN(retval);
               if( len > 0 )
               {
                   memcpy( Stream->input_buffer.data + Stream->input_buffer.length,
                           FE_STR2PTR( retval ), FE_STRLEN( retval ) );
                   Stream->input_buffer.length += len;
               }
               ferite_variable_destroy( script, retval );
               if( len == 0 )
                 break;
           }
           ferite_delete_parameter_list( script, args );

            /* Right, we didn't find a newline. We have either filled up the buffer or we have gotten the EOF */
            /* Let's get it out of here anyway */
           if( Stream->input_buffer.length == 0 )
             Stream->input_buffer.data[0] = '\0';

           v = fe_new_str_static( "read", Stream->input_buffer.data, Stream->input_buffer.length, FE_CHARSET_DEFAULT );
           Stream->input_buffer.data[0] = '\0';
           Stream->input_buffer.length = 0;
           unlock_object;
           FE_RETURN_VAR( v );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_eos_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 659 "std.fec"

       
           struct Stream *Stream = self->odata;
           if( Stream->eos == 0 )
           {
               FE_RETURN_TRUE;
           }
           FE_RETURN_FALSE;
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_printf_sE )
{
   FeriteString *fmt;
   FeriteObject *self = VAO(params[ferite_get_parameter_count(params) - 1]);

   ferite_get_parameters( params, 1, &fmt );

   { /* Main function body. */
#line 395 "std.fec"

       
	   int paramcnt, pi;
	   FeriteFunction *func;
	   FeriteNamespaceBucket *nsb;
           FeriteVariable *str, *len, **args;

           /* Call String.sprintf() to generate the formatted string: */
           if(!(nsb = ferite_find_namespace(script, script->mainns,
	   					"String.sprintf", FENS_FNC))) {
               FE_RETURN_LONG(-1);
           }
	   func = (FeriteFunction *)nsb->data;
	   paramcnt = ferite_get_parameter_count(params) - 2;
           args = ferite_create_parameter_list(paramcnt + 1);
           for(pi = 0; pi < paramcnt; pi++) 
	     args[pi] = params[pi];
	   str = ferite_call_function(script, func, args);
	   ffree( args ); /* normally we would delete the parameter list,
                             but because the caller of the function owns the
                             parameters passed to us, we can't go deleting 
			     them by mistake. This just frees the list but not
			     it's contents. We need not worry about the contents
			     as whatever called us will clear them up. */

           /* Call self.write() to output the string: */
	   func = ferite_find_function_in_object(script, self, "write");
           args = ferite_create_parameter_list(4);
	   args[0] = str;
	   MARK_VARIABLE_AS_DISPOSABLE( str ); /* Just so that we get this cleared up */
	   ferite_object_add_self_variable_to_params(script, args, self);
	   len = ferite_call_function(script, func, args);
	   ferite_delete_parameter_list(script, args);

           /* Return the number of bytes written to the stream: */
	   FE_RETURN_VAR(len);
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_Destructor_ )
{
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 2, &super, &self );

   { /* Main function body. */
#line 237 "std.fec"

       
           FeriteFunction *close;
           FeriteVariable *retval, **args;
           struct Stream *Stream = self->odata;

           aphex_mutex_destroy( Stream->lock );
           stream_flush( script, self );
           ferite_buffer_delete( Stream->output_buffer );
           close = ferite_find_function_in_object( script, self, "__close__" );
           if( close != NULL )
           {
               args = ferite_create_parameter_list_from_data( script, "oo", self, self );
               retval = ferite_call_function( script, close, args );
               ferite_variable_destroy( script, retval );
               ferite_delete_parameter_list( script, args );
           }
           ffree( Stream->input_buffer.data );
           ffree( Stream->endofline );
           if( Stream->errmsg != NULL )
           {
               ffree( Stream->errmsg );
           }
           ffree( Stream );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_scan_sE )
{
   FeriteString *fmt;
   FeriteObject *self = VAO(params[ferite_get_parameter_count(params) - 1]);

   ferite_get_parameters( params, 1, &fmt );

   { /* Main function body. */
#line 603 "std.fec"

       
            /* Will have to do this to, someday */
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream___write___s )
{
   FeriteString *s;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &s, &super, &self );

   { /* Main function body. */
#line 616 "std.fec"

       
           FE_RETURN_LONG( 0 );
       
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_Stream_write_s )
{
   FeriteString *s;
   FeriteObject *super;
   FeriteObject *self;

   ferite_get_parameters( params, 3, &s, &super, &self );

   { /* Main function body. */
#line 339 "std.fec"

       
           struct Stream *Stream = self->odata;
           int eoflen = strlen( Stream->endofline );

           lock_object;
           ferite_buffer_add( Stream->output_buffer, s->data, s->length );
           if( !Stream->aggressive && memcmp( s->data + s->length - eoflen, Stream->endofline, eoflen ) == 0 )
           {
               stream_flush( script, self );
           }
           unlock_object;
           FE_RETURN_LONG( s->length );
       
   }
   FE_RETURN_VOID;
}

