/* This file has been automatically generated by builder part of the ferite distribution */
/* file: sys_Sys_env.c */
/* namespace: env */

#include <ferite.h>       /* we need this without a doubt */
#include "sys_header.h"  /* this is the module header */

FE_NATIVE_FUNCTION( sys_Sys_env_del_s )
{
   FeriteString *key;

   ferite_get_parameters( params, 1, &key );

   { /* Main function body. */
#line 92 "env.fec"

        
#ifdef USING_SOLARIS
            ferite_warning( script, "WARNING: Environment::del('%s') does not work under Solaris\n", key );
#else
            unsetenv( key->data );
#endif
        
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_env_read_s )
{
   FeriteString *key;

   ferite_get_parameters( params, 1, &key );

   { /* Main function body. */
#line 54 "env.fec"

        
            char *ev_value = NULL;
            FeriteVariable *returnValue = NULL;

            if( (ev_value = getenv(key->data)) != NULL )
              returnValue = fe_new_str_static( "Environment::read-return", ev_value, 0, FE_CHARSET_DEFAULT );
            else
              returnValue = fe_new_str_static( "Environment::read-return", "", 0, FE_CHARSET_DEFAULT );
            FE_RETURN_VAR( returnValue );
        
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_env_toArray_ )
{

   { /* Main function body. */
#line 21 "env.fec"

        
            FeriteVariable *var = NULL, *val = NULL;
            char *currentValue = NULL;
            char *name, *value;
            int i = 0;
#ifdef USING_DARWIN
            char **environ = *_NSGetEnviron();
#endif
            var = ferite_create_uarray_variable( script, "Environment::toArray-element", 50, FE_STATIC );
            while( (currentValue = environ[i++]) != NULL )
            {
                name = memset( fmalloc( strlen(currentValue)+1 ), '\0', strlen(currentValue)+1 );
                value = memset( fmalloc( strlen(currentValue)+1 ), '\0', strlen(currentValue)+1 );

                strncpy( name, currentValue, ferite_find_string( currentValue, "=" ) );
                strcpy( value, currentValue + ferite_find_string( currentValue, "=" ) + 1 );
                val = fe_new_str( name, value, 0, FE_CHARSET_DEFAULT );
                ferite_uarray_add( script, VAUA(var), val, name, FE_ARRAY_ADD_AT_END );

                ffree( name );
                ffree( value );
            }
            FE_RETURN_VAR( var );
        
   }
   FE_RETURN_VOID;
}

FE_NATIVE_FUNCTION( sys_Sys_env_write_ss )
{
   FeriteString *key;
   FeriteString *value;

   ferite_get_parameters( params, 2, &key, &value );

   { /* Main function body. */
#line 73 "env.fec"

        
       /* Solaris is a PITA - it doesn't seem to have a setenv this is the work around */
#ifdef USING_SOLARIS
            char *buf = memset( fmalloc( key->length + value->length + 2 ), '\0', key->length + value->length + 2 );
            sprintf( buf, "%s=%s", key->data, value->data );
            putenv( buf );
            ffree( buf );
#else
            setenv( key->data, value->data, 1 );
#endif
        
   }
   FE_RETURN_VOID;
}

