#include "util_posix.h"
#include "util_stream.h"

FeriteVariable *system_call_stat( FeriteScript *script, struct stat *in )
{
    FeriteVariable *object, *pointer, **args;
    FeriteClass *cls;

    pointer = system_create_pointer_var( script, "struct::stat", in );
    if((cls = ferite_find_class( script, script->mainns, "Sys.Stat" )) != NULL)
    {
	   args = ferite_create_parameter_list( 4 );
	   args = ferite_add_to_parameter_list( args, pointer );
	   object = ferite_new_object( script, cls, args );
	   ferite_delete_parameter_list( script, args );
	   FE_RETURN_VAR( object );
    }
    FE_RETURN_NULL_OBJECT;
}
FeriteVariable *system_call_tm( FeriteScript *script, struct tm *tm )
{
    FeriteVariable *object = NULL, *pointer = NULL, **args = NULL;
    FeriteClass *cls = NULL;
    FeriteFunction *function = NULL;

    if((cls = ferite_find_class( script, script->mainns, "Sys.Tm" )) != NULL)
    {
	   pointer = system_create_pointer_var( script, "struct::tm", tm );
	   object = ferite_new_object( script, cls, NULL );
	   function = ferite_find_function_in_object( script, VAO(object), "__RegisterFromPointer__" );
	   args = ferite_create_parameter_list_from_data( script, "ooo", VAO(pointer), VAO(object), VAO(object) );
	   ferite_variable_destroy( script, ferite_call_function( script, function, args ) );
	   ferite_variable_destroy( script, pointer );
	   ferite_delete_parameter_list( script, args );
	   FE_RETURN_VAR( object );
    }
    FE_RETURN_NULL_OBJECT;
}
int system_sync_to_tm( struct FeTm *Tm, struct tm *tm )
{
    memset( tm, '\0', sizeof(struct tm) );
    tm->tm_sec   = VAI(Tm->tm_sec);
    tm->tm_min   = VAI(Tm->tm_min);
    tm->tm_hour  = VAI(Tm->tm_hour);
    tm->tm_mday  = VAI(Tm->tm_mday);
    tm->tm_mon   = VAI(Tm->tm_mon) - 1;
    tm->tm_year  = VAI(Tm->tm_year) - 1900;
    tm->tm_wday  = VAI(Tm->tm_wday);
    tm->tm_yday  = VAI(Tm->tm_yday);
    tm->tm_isdst = VAI(Tm->tm_isdst);
#ifndef USING_SOLARIS
    tm->tm_zone  = VAS(Tm->tm_zone)->data;
    tm->tm_gmtoff = VAI(Tm->tm_gmtoff);
#endif
    return 0;
}

int system_sync_to_FeTm( struct FeTm *Tm, struct tm *tm )
{
    VAI(Tm->tm_sec)   = tm->tm_sec;
    VAI(Tm->tm_min)   = tm->tm_min;
    VAI(Tm->tm_hour)  = tm->tm_hour;
    VAI(Tm->tm_mday)  = tm->tm_mday;
    VAI(Tm->tm_mon)   = tm->tm_mon + 1;
    VAI(Tm->tm_year)  = tm->tm_year + 1900;
    VAI(Tm->tm_wday)  = tm->tm_wday;
    VAI(Tm->tm_yday)  = tm->tm_yday;
    VAI(Tm->tm_isdst) = tm->tm_isdst;    
#ifndef USING_SOLARIS
    VAI(Tm->tm_gmtoff) = tm->tm_gmtoff;    
    ferite_str_destroy( VAS(Tm->tm_zone) );
    VAS(Tm->tm_zone) = ferite_str_new( tm->tm_zone, 0, FE_CHARSET_DEFAULT );    
#endif    
    return 0;
}

#define FE_SYS_ALARM_OWNER 1
AlarmData *currentAlarm;
void timer_sig_alarm( int signum )
{
    if( currentAlarm != NULL )
    {
        ferite_script_function_execute( currentAlarm->script, currentAlarm->function, NULL );
        if( currentAlarm->recurring )
            alarm( currentAlarm->interval );
    }
}

int make_fd_set(FeriteScript *script, FeriteUnifiedArray *array, fd_set *f)
{
    int i;
    int cnt = 0;
    FeriteVariable *fv, **args = NULL;
    FeriteFunction *func = NULL;

    FD_ZERO(f);

    for(i = 0; i < array->size; i++) {
        fv = ferite_uarray_get_index(script, array, i);
        if(fv->type != F_VAR_OBJ || VAO(fv) == NULL) {
            ferite_set_error(script, 0, "Wrong variable type in array");
            return -1;
        }
        func = ferite_find_function_in_object(script, VAO(fv), "getDescriptor");
        if(!func) {
            ferite_set_error(script, 0, "Object in array doesn't have "
                                                        "getDescriptor()");
            return -1;
        }
        args = ferite_create_parameter_list(3);
        ferite_object_add_self_variable_to_params(script, args, VAO(fv) );
        fv = ferite_call_function(script, func, args);
        ferite_delete_parameter_list(script, args);
        if(!fv) {
            ferite_set_error(script, 0, "Failed to get file descriptor from "
                                                                     "object");
            return -1;
        }
        if(fv->type != F_VAR_LONG) {
            ferite_set_error(script, 0, "Object returned wrong type for "
                                                        "getDescriptor()");
            return -1;
        }
        FD_SET(VAI(fv), f);
        cnt++;
    }

    return cnt;
}

int update_SelectResult(FeriteScript *script, FeriteObject *obj,
			FeriteUnifiedArray *inarray, char *vname, fd_set *f)
{
    int i;
    FeriteFunction *func = NULL;
    FeriteVariable *dup, *fv, *fo, **args = NULL, *outarray;

    if(!(outarray = ferite_create_uarray_variable(script, vname, 0,
                                                        FE_STATIC))) {
        return -1;
    }

    for(i = 0; i < inarray->size; i++) {
        fo = ferite_uarray_get_index(script, inarray, i);
        func = ferite_find_function_in_object(script, VAO(fo), "getDescriptor");
        args = ferite_create_parameter_list(3);
        ferite_object_add_self_variable_to_params(script, args, VAO(fo));
        fv = ferite_call_function(script, func, args);
        ferite_delete_parameter_list(script, args);
        if(FD_ISSET(VAI(fv), f)) {
            dup = ferite_duplicate_variable(script, fo, NULL);
            ferite_uarray_add(script, VAUA(outarray), dup, NULL,
                                             FE_ARRAY_ADD_AT_END);
        }
    }

    ferite_object_set_var(script, obj, vname, outarray);

    return 0;
}

int set_signal_action(FeriteScript *script, int sig, void *action)
{
    int ret;
    struct sigaction act;

    memset(&act, 0, sizeof(act));
    act.sa_handler = action;

    while((ret = sigaction(sig, &act, NULL)) == -1 && errno == EINTR);

    if(ret == -1) {
        ferite_set_error(script, errno, "%s", strerror(errno));
	return -1;
    }

    return 0;
}
