#include "ferite.h"
#include "thread_header.h"

FeriteScript *ferite_thread_create_script( FeriteScript *script )
{
    FeriteScript *new_script = NULL;
    
    FE_ENTER_FUNCTION;
    
    new_script = fmalloc( sizeof( FeriteScript ) );
    memcpy( new_script, script, sizeof( FeriteScript ) );
    
    /* Create new cache for this thread */
    ferite_init_cache( new_script );
    
    /* Create new GC for this thread */
    new_script->gc = NULL;
    ferite_init_gc( new_script );
    
    /* If we are here then we have not got any errors or warnings reset! :) */
    new_script->error = NULL;
    new_script->warning = NULL;
        
    /* Hook up the parent */
    new_script->parent = script;
    
    FE_LEAVE_FUNCTION(new_script);
}

void ferite_thread_destroy_script( FeriteScript *parent, FeriteThread *ctx )
{
    FE_ENTER_FUNCTION;
    
    /* If you want exceptions to be passed on */
    if( ctx->script->error != NULL )
	ferite_reset_errors( ctx->script );
    
    if( ctx->script->warning != NULL )
      ferite_reset_warnings( ctx->script );
    
    ferite_free_cache( ctx->script );
    ferite_merge_gc( parent, ctx->script->gc );
    ffree( ctx->script );
    
    FE_LEAVE_FUNCTION(NOWT);
}

void *ferite_thread_execute( void *ptr )
{
    FeriteThread *thread = (FeriteThread*)ptr;
    FeriteObject *obj = thread->obj;
    FeriteScript *script = thread->script;
    FeriteFunction *function = NULL;
    FeriteVariable **params = NULL;

    FE_ENTER_FUNCTION;

    function = ferite_object_get_function( script, obj, "run" );
    if( function == NULL )
    {
        ferite_error( script, 0, "No run method found in Thread class!\n" );
        FE_LEAVE_FUNCTION( NULL );
    }

    ferite_thread_group_attach( script, script->thread_group, thread );
    thread->running = FE_TRUE;
    obj->refcount++;
    
    params = ferite_create_parameter_list_from_data( script, "oo", obj, obj );
    ferite_variable_destroy( script, ferite_call_function( script, function, params ) );
    ferite_delete_parameter_list( script, params );
    
    obj->refcount--;
    thread->running = FE_FALSE;
    ferite_thread_group_dettach( script, script->thread_group, thread );

    /* If you want exceptions to be passed on */
    if( script->error != NULL )
    {
	if( thread->pass_exceptions )
	{
	    char *value = ferite_get_error_string( script );
	    ferite_error( script->parent, 0, "Exception in thread: (errors will follow this message)\n%s", value );
	    ffree( value );
	}
	ferite_reset_errors( script );
    }

    FE_LEAVE_FUNCTION( NULL );
}
