/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.mcidas;

import java.io.IOException;
import ucar.unidata.io.RandomAccessFile;
import visad.data.BadFormException;

public class V5DStruct {
    private static final int MBS = 32;
    private static final String TOPOFILE = "EARTH.TOPO";
    private static final String WORLDFILE = "OUTLSUPW";
    private static final String USAFILE = "OUTLUSAM";
    private static final String TCL_STARTUP_FILE = "vis5d.tcl";
    private static final String FUNCTION_PATH = "userfuncs";
    private static final int ANIMRATE = 100;
    private static final double DEFAULT_LOG_SCALE = 1012.5;
    private static final double DEFAULT_LOG_EXP = -7.2;
    private static final boolean BIG_GFX = true;
    private static final int MAX_LABEL = 1000;
    private static final int MAX_FUNCS = 100;
    private static final int V5D_VERSION = 42;
    private static final float MISSING = Float.NaN;
    private static final int MAXVARS = 200;
    private static final int MAXTIMES = 400;
    private static final int MAXROWS = 400;
    private static final int MAXCOLUMNS = 400;
    private static final int MAXLEVELS = 400;
    private static final int MAXPROJARGS = 801;
    private static final int MAXVERTARGS = 401;
    private static final String FILE_VERSION = "4.3";
    private static final int DEFAULT_FILE_BUFFER = 204800;
    private static final int DEFAULT_HTTP_BUFFER = 204800;
    public static final int TAG_ID = 1446331402;
    public static final int TAG_VERSION = 1000;
    public static final int TAG_NUMTIMES = 1001;
    public static final int TAG_NUMVARS = 1002;
    public static final int TAG_VARNAME = 1003;
    public static final int TAG_NR = 1004;
    public static final int TAG_NC = 1005;
    public static final int TAG_NL = 1006;
    public static final int TAG_NL_VAR = 1007;
    public static final int TAG_LOWLEV_VAR = 1008;
    public static final int TAG_TIME = 1010;
    public static final int TAG_DATE = 1011;
    public static final int TAG_MINVAL = 1012;
    public static final int TAG_MAXVAL = 1013;
    public static final int TAG_COMPRESS = 1014;
    public static final int TAG_UNITS = 1015;
    public static final int TAG_VERTICAL_SYSTEM = 2000;
    public static final int TAG_VERT_ARGS = 2100;
    public static final int TAG_BOTTOMBOUND = 2001;
    public static final int TAG_LEVINC = 2002;
    public static final int TAG_HEIGHT = 2003;
    public static final int TAG_PROJECTION = 3000;
    public static final int TAG_PROJ_ARGS = 3100;
    public static final int TAG_NORTHBOUND = 3001;
    public static final int TAG_WESTBOUND = 3002;
    public static final int TAG_ROWINC = 3003;
    public static final int TAG_COLINC = 3004;
    public static final int TAG_LAT1 = 3005;
    public static final int TAG_LAT2 = 3006;
    public static final int TAG_POLE_ROW = 3007;
    public static final int TAG_POLE_COL = 3008;
    public static final int TAG_CENTLON = 3009;
    public static final int TAG_CENTLAT = 3010;
    public static final int TAG_CENTROW = 3011;
    public static final int TAG_CENTCOL = 3012;
    public static final int TAG_ROTATION = 3013;
    public static final int TAG_END = 9999;
    public int NumTimes;
    public int NumVars;
    public int Nr;
    public int Nc;
    public int[] Nl = new int[200];
    public int[] LowLev = new int[200];
    public char[][] VarName = new char[200][10];
    public char[][] Units = new char[200][20];
    public int[] TimeStamp = new int[400];
    public int[] DateStamp = new int[400];
    public float[] MinVal = new float[200];
    public float[] MaxVal = new float[200];
    public short[][] McFile = new short[400][200];
    public short[][] McGrid = new short[400][200];
    public int VerticalSystem = -1;
    public float[] VertArgs = new float[401];
    public int Projection = -1;
    public float[] ProjArgs = new float[801];
    public int CompressMode;
    public String FileVersion;
    private int FileFormat;
    private RandomAccessFile FileDesc;
    char Mode;
    int CurPos;
    int FirstGridPos;
    int[] GridSize = new int[200];
    int SumGridSizes;
    private static boolean SIMPLE_COMPRESSION = false;
    private static boolean KLUDGE = false;
    private static boolean ORIGINAL = false;

    private static boolean IS_MISSING(float x) {
        return Float.isNaN(x) || (double)x >= 1.0E30;
    }

    public static V5DStruct v5d_open(RandomAccessFile raf, int[] sizes, int[] n_levels, String[] var_names, String[] var_units, int[] map_proj, float[] projargs, int[] vert_sys, float[] vert_args, double[] times) throws IOException, BadFormException {
        byte[] varnames = new byte[2000];
        byte[] varunits = new byte[4000];
        V5DStruct v = V5DStruct.v5dOpenFile(raf);
        if (v != null) {
            int kk;
            int i;
            int k;
            int j;
            sizes[0] = v.Nr;
            sizes[1] = v.Nc;
            sizes[3] = v.NumTimes;
            sizes[4] = v.NumVars;
            block0: for (j = 0; j < v.NumVars; ++j) {
                k = 10 * j;
                for (i = 0; i < 10; ++i) {
                    if (v.VarName[j][i] == '\u0000' || i >= 9) {
                        varnames[k + i] = 0;
                        continue block0;
                    }
                    varnames[k + i] = (byte)v.VarName[j][i];
                }
            }
            block2: for (j = 0; j < v.NumVars; ++j) {
                k = 20 * j;
                for (i = 0; i < 20; ++i) {
                    if (v.Units[j][i] == '\u0000' || i >= 19) {
                        varunits[k + i] = 0;
                        continue block2;
                    }
                    varunits[k + i] = (byte)v.Units[j][i];
                }
            }
            for (i = 0; i < v.NumVars; ++i) {
                k = 10 * i;
                int k2 = 20 * i;
                int m = k;
                int m2 = k2;
                while (varnames[m] != 0) {
                    ++m;
                }
                while (varunits[m2] != 0) {
                    ++m2;
                }
                var_names[i] = new String(varnames, k, m - k);
                var_units[i] = new String(varunits, k2, m2 - k2);
            }
            int maxNl = v.Nl[0];
            for (i = 0; i < v.NumVars; ++i) {
                if (v.Nl[i] <= maxNl) continue;
                maxNl = v.Nl[i];
            }
            sizes[2] = maxNl;
            for (i = 0; i < v.NumVars; ++i) {
                n_levels[i] = v.Nl[i];
            }
            vert_sys[0] = v.VerticalSystem;
            for (kk = 0; kk < maxNl; ++kk) {
                vert_args[kk] = v.VertArgs[kk];
            }
            int first_day = V5DStruct.v5dYYDDDtoDays(v.DateStamp[0]);
            int first_time = V5DStruct.v5dHHMMSStoSeconds(v.TimeStamp[0]);
            for (i = 0; i < v.NumTimes; ++i) {
                double ff;
                int day = V5DStruct.v5dYYDDDtoDays(v.DateStamp[i]);
                int time = V5DStruct.v5dHHMMSStoSeconds(v.TimeStamp[i]);
                times[i] = ff = (double)day * 24.0 * 60.0 * 60.0 + (double)time;
            }
            map_proj[0] = v.Projection;
            for (kk = 0; kk < 801; ++kk) {
                projargs[kk] = v.ProjArgs[kk];
            }
        } else {
            sizes[0] = -1;
        }
        return v;
    }

    public void v5d_read(int time, int vr, float[] ranges, float[] data) throws IOException, BadFormException {
        ranges[0] = this.MinVal[vr];
        ranges[1] = this.MaxVal[vr];
        boolean status = this.v5dReadGrid(time, vr, data);
        if (!status) {
            ranges[0] = 1.0f;
            ranges[1] = -1.0f;
        }
    }

    public static int getUnsignedByte(byte b) {
        int i = b >= 0 ? b : b + 256;
        return i;
    }

    public static int getUnsignedShort(byte b1, byte b2) {
        int i1 = V5DStruct.getUnsignedByte(b1);
        int i2 = V5DStruct.getUnsignedByte(b2);
        return 256 * i1 + i2;
    }

    public static int getUnsignedInt(byte b1, byte b2, byte b3, byte b4) {
        int i1 = V5DStruct.getUnsignedByte(b1);
        int i2 = V5DStruct.getUnsignedByte(b2);
        int i3 = V5DStruct.getUnsignedByte(b3);
        int i4 = V5DStruct.getUnsignedByte(b4);
        return 0x1000000 * i1 + 65536 * i2 + 256 * i3 + i4;
    }

    private static float pressure_to_height(float pressure) {
        return (float)(-7.2 * Math.log((double)pressure / 1012.5));
    }

    private static float height_to_pressure(float height) {
        return (float)(1012.5 * Math.exp((double)height / -7.2));
    }

    private static int copy_string2(char[] dst, char[] src, int maxlen) {
        int i;
        for (i = 0; i < maxlen; ++i) {
            dst[i] = src[i];
        }
        for (i = maxlen - 1; i >= 0 && (dst[i] == ' ' || i == maxlen - 1); --i) {
            dst[i] = '\u0000';
        }
        return new String(dst).length();
    }

    private static int copy_string(char[] dst, char[] src, int maxlen) {
        int i;
        for (i = 0; i < maxlen; ++i) {
            if (src[i] == ' ' || i == maxlen - 1) {
                dst[i] = '\u0000';
                break;
            }
            dst[i] = src[i];
        }
        return i;
    }

    private static int v5dYYDDDtoDays(int yyddd) {
        int iy = yyddd / 1000;
        int id = yyddd - 1000 * iy;
        if (iy >= 1900) {
            iy -= 1900;
        } else if (iy < 50) {
            iy += 100;
        }
        int idays = 365 * iy + (iy - 1) / 4 - (iy - 1) / 100 + (iy + 299) / 400 + id - 1;
        return idays;
    }

    private static int v5dHHMMSStoSeconds(int hhmmss) {
        int h = hhmmss / 10000;
        int m = hhmmss / 100 % 100;
        int s = hhmmss % 100;
        return s + m * 60 + h * 60 * 60;
    }

    private static int v5dDaysToYYDDD(int days) {
        int iy = 4 * days / 1461;
        int id = days - (365 * iy + (iy - 1) / 4);
        if (iy > 99) {
            iy -= 100;
        }
        int iyyddd = iy * 1000 + id;
        return iyyddd;
    }

    private static int v5dSecondsToHHMMSS(int seconds) {
        int hh = seconds / 3600;
        int mm = seconds / 60 % 60;
        int ss = seconds % 60;
        return hh * 10000 + mm * 100 + ss;
    }

    public static V5DStruct v5dOpenFile(RandomAccessFile fd) throws IOException, BadFormException {
        if (fd == null) {
            System.out.println("null file");
            return null;
        }
        V5DStruct v = new V5DStruct();
        v.FileDesc = fd;
        v.Mode = (char)114;
        return v.read_v5d_header() ? v : null;
    }

    private static void compute_ga_gb(int nr, int nc, int nl, float[] data, int compressmode, float[] ga, float[] gb, float[] minval, float[] maxval) throws BadFormException {
        if (SIMPLE_COMPRESSION) {
            float b;
            float a;
            int i;
            float min = 1.0E30f;
            float max = -1.0E30f;
            int num = nr * nc * nl;
            boolean allmissing = true;
            for (i = 0; i < num; ++i) {
                if (V5DStruct.IS_MISSING(data[i])) continue;
                if (data[i] < min) {
                    min = data[i];
                }
                if (data[i] > max) {
                    max = data[i];
                }
                allmissing = false;
            }
            if (allmissing) {
                a = 1.0f;
                b = 0.0f;
            } else {
                a = (float)((double)(max - min) / 254.0);
                b = min;
            }
            for (i = 0; i < nl; ++i) {
                ga[i] = a;
                gb[i] = b;
            }
            minval[0] = min;
            maxval[0] = max;
        } else {
            int lev;
            float SMALLVALUE = -1.0E30f;
            float BIGVALUE = 1.0E30f;
            float[] levmin = new float[400];
            float[] levmax = new float[400];
            float[] d = new float[400];
            int nrnc = nr * nc;
            float gridmin = 1.0E30f;
            float gridmax = -1.0E30f;
            int j = 0;
            for (lev = 0; lev < nl; ++lev) {
                float min = 1.0E30f;
                float max = -1.0E30f;
                for (int k = 0; k < nrnc; ++k) {
                    if (!V5DStruct.IS_MISSING(data[j]) && data[j] < min) {
                        min = data[j];
                    }
                    if (!V5DStruct.IS_MISSING(data[j]) && data[j] > max) {
                        max = data[j];
                    }
                    ++j;
                }
                if (min < gridmin) {
                    gridmin = min;
                }
                if (max > gridmax) {
                    gridmax = max;
                }
                levmin[lev] = min;
                levmax[lev] = max;
            }
            if (KLUDGE) {
                int nrncnl = nrnc * nl;
                float delt = (float)((double)(gridmax - gridmin) / 100000.0);
                if (Math.abs(gridmin) < delt && (double)gridmin != 0.0 && compressmode != 4) {
                    for (j = 0; j < nrncnl; ++j) {
                        if (V5DStruct.IS_MISSING(data[j]) || !(data[j] < delt)) continue;
                        data[j] = delt;
                    }
                    gridmin = delt;
                    for (lev = 0; lev < nl; ++lev) {
                        if (Math.abs(levmin[lev]) < delt) {
                            levmin[lev] = delt;
                        }
                        if (!(Math.abs(levmax[lev]) < delt)) continue;
                        levmax[lev] = delt;
                    }
                }
            }
            float dmax = 0.0f;
            for (lev = 0; lev < nl; ++lev) {
                d[lev] = levmin[lev] >= 1.0E30f && levmax[lev] <= -1.0E30f ? 0.0f : levmax[lev] - levmin[lev];
                if (!(d[lev] > dmax)) continue;
                dmax = d[lev];
            }
            if ((double)dmax == 0.0) {
                if (gridmin == gridmax) {
                    for (lev = 0; lev < nl; ++lev) {
                        ga[lev] = gridmin;
                        gb[lev] = 0.0f;
                    }
                } else {
                    for (lev = 0; lev < nl; ++lev) {
                        ga[lev] = levmin[lev];
                        gb[lev] = 0.0f;
                    }
                }
            } else if (compressmode == 1) {
                ORIGINAL = true;
                if (ORIGINAL) {
                    float ival = dmax / 254.0f;
                    float mval = gridmin;
                    for (lev = 0; lev < nl; ++lev) {
                        ga[lev] = ival;
                        gb[lev] = mval + ival * (float)((int)((levmin[lev] - mval) / ival));
                    }
                } else {
                    for (lev = 0; lev < nl; ++lev) {
                        float ival = (double)d[lev] == 0.0 ? 1.0f : d[lev] / 254.0f;
                        ga[lev] = ival;
                        gb[lev] = levmin[lev];
                    }
                }
            } else if (compressmode == 2) {
                float ival = dmax / 65534.0f;
                float mval = gridmin;
                for (lev = 0; lev < nl; ++lev) {
                    ga[lev] = ival;
                    gb[lev] = mval + ival * (float)((int)((levmin[lev] - mval) / ival));
                }
            } else {
                V5DStruct.V5Dassert(compressmode == 4);
                for (lev = 0; lev < nl; ++lev) {
                    ga[lev] = 1.0f;
                    gb[lev] = 0.0f;
                }
            }
            minval[0] = gridmin;
            maxval[0] = gridmax;
        }
    }

    private void v5dDecompressGrid(int nr, int nc, int nl, int compressmode, byte[] compdata1, float[] ga, float[] gb, float[] data) {
        int nrnc = nr * nc;
        int nrncnl = nr * nc * nl;
        if (compressmode == 1) {
            int p = 0;
            for (int lev = 0; lev < nl; ++lev) {
                int cd1p;
                int i;
                int id;
                float a = ga[lev];
                float b = gb[lev];
                float d = 0.0f;
                float aa = 0.0f;
                if ((double)a > 1.0E-10) {
                    d = b / a;
                    id = (int)Math.floor(d);
                    d -= (float)id;
                    aa = (float)((double)a * 1.0E-6);
                } else {
                    id = 1;
                }
                if (-254 <= id && id <= 0 && d < aa) {
                    i = 0;
                    while (i < nrnc) {
                        cd1p = V5DStruct.getUnsignedByte(compdata1[p]);
                        if (cd1p == 255) {
                            data[p] = Float.NaN;
                        } else {
                            data[p] = (float)cd1p * a + b;
                            if (Math.abs(data[p]) < aa) {
                                data[p] = aa;
                            }
                        }
                        ++i;
                        ++p;
                    }
                    continue;
                }
                i = 0;
                while (i < nrnc) {
                    cd1p = V5DStruct.getUnsignedByte(compdata1[p]);
                    data[p] = cd1p == 255 ? Float.NaN : (float)cd1p * a + b;
                    ++i;
                    ++p;
                }
            }
        } else if (compressmode == 2) {
            int p = 0;
            for (int lev = 0; lev < nl; ++lev) {
                float a = ga[lev];
                float b = gb[lev];
                int i = 0;
                while (i < nrnc) {
                    int cd1p = V5DStruct.getUnsignedShort(compdata1[2 * p], compdata1[2 * p + 1]);
                    data[p] = cd1p == 65535 ? Float.NaN : (float)cd1p * a + b;
                    ++i;
                    ++p;
                }
            }
        } else {
            for (int i = 0; i < nrncnl; ++i) {
                int a = V5DStruct.getUnsignedInt(compdata1[i * 4], compdata1[i * 4 + 1], compdata1[i * 4 + 2], compdata1[i * 4 + 3]);
                data[i] = Float.intBitsToFloat(a);
            }
        }
    }

    private static final void V5Dassert(boolean b) throws BadFormException {
        if (!b) {
            throw new BadFormException("Warning: assert failed");
        }
    }

    private static int read_block(RandomAccessFile f, byte[] data, int elements, int elsize) throws IOException {
        int n;
        if (elsize == 1) {
            n = f.read(data, 0, elements);
        } else if (elsize == 2) {
            n = f.read(data, 0, elements * 2) / 2;
        } else if (elsize == 4) {
            n = f.read(data, 0, elements * 4) / 4;
        } else {
            throw new IOException("Fatal error in read_block(): bad elsize (" + elsize + ")");
        }
        return n;
    }

    private static int read_float4_array(RandomAccessFile f, float[] x, int n) throws IOException {
        for (int i = 0; i < n; ++i) {
            x[i] = f.readFloat();
        }
        return n;
    }

    private static void v5dCompressGrid(int nr, int nc, int nl, int compressmode, float[] data, byte[] compdata1, float[] ga, float[] gb, float[] minval, float[] maxval) throws BadFormException {
        int nrnc = nr * nc;
        int nrncnl = nr * nc * nl;
        V5DStruct.compute_ga_gb(nr, nc, nl, data, compressmode, ga, gb, minval, maxval);
        if (compressmode == 1) {
            int p = 0;
            for (int lev = 0; lev < nl; ++lev) {
                float b = gb[lev] - 1.0E-4f;
                float one_over_a = ga[lev] == 0.0f ? 1.0f : 1.0f / ga[lev];
                int i = 0;
                while (i < nrnc) {
                    compdata1[p] = V5DStruct.IS_MISSING(data[p]) ? -1 : (byte)((data[p] - b) * one_over_a);
                    ++i;
                    ++p;
                }
            }
        } else if (compressmode == 2) {
            int p = 0;
            for (int lev = 0; lev < nl; ++lev) {
                float b = gb[lev] - 1.0E-4f;
                float one_over_a = ga[lev] == 0.0f ? 1.0f : 1.0f / ga[lev];
                int i = 0;
                while (i < nrnc) {
                    if (V5DStruct.IS_MISSING(data[p])) {
                        compdata1[2 * p] = -1;
                        compdata1[2 * p + 1] = -1;
                    } else {
                        short s = (short)((data[p] - b) * one_over_a);
                        compdata1[2 * p] = (byte)(s / 256);
                        compdata1[2 * p + 1] = (byte)(s % 256);
                    }
                    ++i;
                    ++p;
                }
            }
        } else {
            System.arraycopy(compdata1, 0, data, 0, nrncnl * 4);
        }
    }

    private static int write_block(RandomAccessFile f, byte[] data, int elements, int elsize) throws IOException {
        if (elsize == 1) {
            f.write(data, 0, elements);
        } else if (elsize == 2) {
            f.write(data, 0, elements * 2);
        } else if (elsize == 4) {
            f.write(data, 0, elements * 4);
        } else {
            throw new IOException("Fatal error in write_block(): bad elsize (" + elsize + ")");
        }
        return elements;
    }

    V5DStruct() {
        for (int i = 0; i < 200; ++i) {
            this.MinVal[i] = Float.NaN;
            this.MaxVal[i] = Float.NaN;
        }
        this.FileVersion = FILE_VERSION;
        this.CompressMode = 1;
        this.FileDesc = null;
    }

    int v5dSizeofGrid(int time, int vr) {
        return this.Nr * this.Nc * this.Nl[vr] * this.CompressMode;
    }

    int grid_position(int time, int vr) throws BadFormException {
        V5DStruct.V5Dassert(time >= 0);
        V5DStruct.V5Dassert(vr >= 0);
        V5DStruct.V5Dassert(time < this.NumTimes);
        V5DStruct.V5Dassert(vr < this.NumVars);
        int pos = this.FirstGridPos + time * this.SumGridSizes;
        for (int i = 0; i < vr; ++i) {
            pos += this.GridSize[i];
        }
        return pos;
    }

    boolean v5dVerifyStruct() {
        int i;
        boolean valid = true;
        if (this.NumVars < 0) {
            System.err.println("Invalid number of variables: " + this.NumVars);
            valid = false;
        } else if (this.NumVars > 200) {
            System.err.println("Too many variables: " + this.NumVars + "  (Maximum is " + 200 + ")");
            valid = false;
        }
        for (i = 0; i < this.NumVars; ++i) {
            if (this.VarName[i][0] != '\u0000') continue;
            System.err.println("Missing variable name: VarName[" + i + "]=\"\"");
            valid = false;
        }
        if (this.NumTimes < 0) {
            System.err.println("Invalid number of timesteps: " + this.NumTimes);
            valid = false;
        } else if (this.NumTimes > 400) {
            System.err.println("Too many timesteps: " + this.NumTimes + "  (Maximum is " + 400 + ")");
            valid = false;
        }
        for (i = 1; i < this.NumTimes; ++i) {
            int j;
            int date0 = V5DStruct.v5dYYDDDtoDays(this.DateStamp[i - 1]);
            int date1 = V5DStruct.v5dYYDDDtoDays(this.DateStamp[i]);
            int time0 = V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[i - 1]);
            int time1 = V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[i]);
            if (date1 >= date0 && (date1 != date0 || time1 > time0)) continue;
            int inc = 1;
            if (i > 1 && (j = V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[i - 1]) - V5DStruct.v5dHHMMSStoSeconds(this.TimeStamp[i - 2]) + 86400 * (V5DStruct.v5dYYDDDtoDays(this.DateStamp[i - 1]) - V5DStruct.v5dYYDDDtoDays(this.DateStamp[i - 2]))) > 0) {
                inc = j;
            }
            time1 = time0 + inc;
            date1 = date0;
            if (time1 >= 86400) {
                time1 = 0;
                ++date1;
            }
            this.DateStamp[i] = V5DStruct.v5dDaysToYYDDD(date1);
            this.TimeStamp[i] = V5DStruct.v5dSecondsToHHMMSS(time1);
        }
        if (this.Nr < 2) {
            System.err.println("Too few rows: " + this.Nr + " (2 is minimum)");
            valid = false;
        }
        if (this.Nc < 2) {
            System.err.println("Too few columns: " + this.Nc + " (2 is minimum)");
            valid = false;
        }
        int maxnl = 0;
        for (int vr = 0; vr < this.NumVars; ++vr) {
            if (this.LowLev[vr] < 0) {
                System.err.println("Low level cannot be negative for var " + this.VarName[vr] + ": " + this.LowLev[vr]);
                valid = false;
            }
            if (this.Nl[vr] < 1) {
                System.err.println("Too few levels for var " + this.VarName[vr] + ": " + this.Nl[vr] + " (1 is minimum)");
                valid = false;
            }
            if (this.Nl[vr] + this.LowLev[vr] > 400) {
                System.err.println("Too many levels for var " + this.VarName[vr] + ": " + (this.Nl[vr] + this.LowLev[vr]) + " (" + 400 + " is maximum)");
                valid = false;
            }
            if (this.Nl[vr] + this.LowLev[vr] <= maxnl) continue;
            maxnl = this.Nl[vr] + this.LowLev[vr];
        }
        if (this.CompressMode != 1 && this.CompressMode != 2 && this.CompressMode != 4) {
            System.err.println("Bad CompressMode: " + this.CompressMode + " (must be 1, 2 or 4)");
            valid = false;
        }
        block0 : switch (this.VerticalSystem) {
            case 0: 
            case 1: {
                if ((double)this.VertArgs[1] != 0.0) break;
                System.err.println("Vertical level increment is zero, must be non-zero");
                valid = false;
                break;
            }
            case 2: {
                for (i = 1; i < maxnl; ++i) {
                    if (!(this.VertArgs[i] <= this.VertArgs[i - 1])) continue;
                    System.err.println("Height[" + i + "]=" + this.VertArgs[i] + " <= Height[" + (i - 1) + "]=" + this.VertArgs[i - 1] + ", level heights must increase");
                    valid = false;
                    break block0;
                }
                break;
            }
            case 3: {
                for (i = 1; i < maxnl; ++i) {
                    if (!(this.VertArgs[i] <= this.VertArgs[i - 1])) continue;
                    System.err.println("Pressure[" + i + "]=" + V5DStruct.height_to_pressure(this.VertArgs[i]) + " >= Pressure[" + (i - 1) + "]=" + V5DStruct.height_to_pressure(this.VertArgs[i - 1]) + ", level pressures must decrease");
                    valid = false;
                    break block0;
                }
                break;
            }
            default: {
                System.err.println("VerticalSystem = " + this.VerticalSystem + ", must be in 0..3");
                valid = false;
            }
        }
        switch (this.Projection) {
            case 0: {
                if ((double)this.ProjArgs[2] == 0.0) {
                    System.err.println("Row Increment (ProjArgs[2]) can't be zero");
                    valid = false;
                }
                if ((double)this.ProjArgs[3] != 0.0) break;
                System.err.println("Column increment (ProjArgs[3]) can't be zero");
                valid = false;
                break;
            }
            case 1: {
                if ((double)this.ProjArgs[2] < 0.0) {
                    System.err.println("Row Increment (ProjArgs[2]) = " + this.ProjArgs[2] + "  (must be >=0.0)");
                    valid = false;
                }
                if (!((double)this.ProjArgs[3] <= 0.0)) break;
                System.err.println("Column Increment (ProjArgs[3]) = " + this.ProjArgs[3] + "  (must be >=0.0)");
                valid = false;
                break;
            }
            case 2: {
                if ((double)this.ProjArgs[0] < -90.0 || (double)this.ProjArgs[0] > 90.0) {
                    System.err.println("Lat1 (ProjArgs[0]) out of range: " + this.ProjArgs[0]);
                    valid = false;
                }
                if ((double)this.ProjArgs[1] < -90.0 || (double)this.ProjArgs[1] > 90.0) {
                    System.err.println("Lat2 (ProjArgs[1] out of range: " + this.ProjArgs[1]);
                    valid = false;
                }
                if (!((double)this.ProjArgs[5] <= 0.0)) break;
                System.err.println("ColInc (ProjArgs[5]) = " + this.ProjArgs[5] + "  (must be >=0.0)");
                valid = false;
                break;
            }
            case 3: {
                if ((double)this.ProjArgs[0] < -90.0 || (double)this.ProjArgs[0] > 90.0) {
                    System.err.println("Central Latitude (ProjArgs[0]) out of range: " + this.ProjArgs[0] + "  (must be in +/-90)");
                    valid = false;
                }
                if ((double)this.ProjArgs[1] < -180.0 || (double)this.ProjArgs[1] > 180.0) {
                    System.err.println("Central Longitude (ProjArgs[1]) out of range: " + this.ProjArgs[1] + "  (must be in +/-180)");
                    valid = false;
                }
                if (!(this.ProjArgs[4] < 0.0f)) break;
                System.err.println("Column spacing (ProjArgs[4]) = " + this.ProjArgs[4] + "  (must be positive)");
                valid = false;
                break;
            }
            case 4: {
                if ((double)this.ProjArgs[2] <= 0.0) {
                    System.err.println("Row Increment (ProjArgs[2]) = " + this.ProjArgs[2] + "  (must be >=0.0)");
                    valid = false;
                }
                if ((double)this.ProjArgs[3] <= 0.0) {
                    System.err.println("Column Increment = (ProjArgs[3]) " + this.ProjArgs[3] + "  (must be >=0.0)");
                    valid = false;
                }
                if ((double)this.ProjArgs[4] < -90.0 || (double)this.ProjArgs[4] > 90.0) {
                    System.err.println("Central Latitude (ProjArgs[4]) out of range: " + this.ProjArgs[4] + "  (must be in +/-90)");
                    valid = false;
                }
                if ((double)this.ProjArgs[5] < -180.0 || (double)this.ProjArgs[5] > 180.0) {
                    System.err.println("Central Longitude (ProjArgs[5]) out of range: " + this.ProjArgs[5] + "  (must be in +/-180)");
                    valid = false;
                }
                if (!((double)this.ProjArgs[6] < -180.0) && !((double)this.ProjArgs[6] > 180.0)) break;
                System.err.println("Central Longitude (ProjArgs[6]) out of range: " + this.ProjArgs[6] + "  (must be in +/-180)");
                valid = false;
                break;
            }
            default: {
                System.err.println("Projection = " + this.Projection + ", must be in 0..4");
                valid = false;
            }
        }
        return valid;
    }

    boolean v5dGetMcIDASgrid(int time, int vr, int[] mcfile, int[] mcgrid) {
        if (time < 0 || time >= this.NumTimes) {
            System.err.println("Bad time argument to v5dGetMcIDASgrid: " + time);
            return false;
        }
        if (vr < 0 || vr >= this.NumVars) {
            System.err.println("Bad var argument to v5dGetMcIDASgrid: " + vr);
            return false;
        }
        mcfile[0] = this.McFile[time][vr];
        mcgrid[0] = this.McGrid[time][vr];
        return true;
    }

    boolean v5dSetMcIDASgrid(int time, int vr, int mcfile, int mcgrid) {
        if (time < 0 || time >= this.NumTimes) {
            System.err.println("Bad time argument to v5dSetMcIDASgrid: " + time);
            return false;
        }
        if (vr < 0 || vr >= this.NumVars) {
            System.err.println("Bad var argument to v5dSetMcIDASgrid: " + vr);
            return false;
        }
        this.McFile[time][vr] = (short)mcfile;
        this.McGrid[time][vr] = (short)mcgrid;
        return true;
    }

    boolean read_comp_header() throws IOException {
        RandomAccessFile f = this.FileDesc;
        f.seek(0L);
        int id = f.readInt();
        if (id == -2139062144 || id == -2139062143) {
            int j;
            int i;
            int gridparms;
            int gridtimes;
            if (id == -2139062144) {
                gridtimes = 300;
                gridparms = 20;
            } else {
                gridtimes = 400;
                gridparms = 30;
            }
            this.FirstGridPos = 48 + 8 * gridtimes + 4 * gridparms;
            this.NumTimes = f.readInt();
            this.NumVars = f.readInt();
            this.Nr = f.readInt();
            this.Nc = f.readInt();
            int nl = f.readInt();
            for (i = 0; i < this.NumVars; ++i) {
                this.Nl[i] = nl;
                this.LowLev[i] = 0;
            }
            this.ProjArgs[0] = f.readFloat();
            this.ProjArgs[1] = f.readFloat();
            float hgttop = f.readFloat();
            this.ProjArgs[2] = f.readFloat();
            this.ProjArgs[3] = f.readFloat();
            float hgtinc = f.readFloat();
            this.VerticalSystem = 1;
            this.VertArgs[0] = hgttop - hgtinc * (float)(nl - 1);
            this.VertArgs[1] = hgtinc;
            for (i = 0; i < gridtimes; ++i) {
                j = f.readInt();
                this.DateStamp[i] = V5DStruct.v5dDaysToYYDDD(j);
            }
            for (i = 0; i < gridtimes; ++i) {
                j = f.readInt();
                this.TimeStamp[i] = V5DStruct.v5dSecondsToHHMMSS(j);
            }
            for (i = 0; i < gridparms; ++i) {
                char[] name = new char[4];
                for (int q = 0; q < 4; ++q) {
                    name[q] = (char)f.readByte();
                }
                for (j = 3; j > 0 && (name[j] == ' ' || name[j] == '\u0000'); --j) {
                    name[j] = '\u0000';
                }
                System.arraycopy(name, 0, this.VarName[i], 0, 4);
                this.VarName[i][4] = '\u0000';
            }
            int gridsize = (this.Nr * this.Nc * nl + 3) / 4 * 4;
            for (i = 0; i < this.NumVars; ++i) {
                this.GridSize[i] = 8 + gridsize;
            }
            this.SumGridSizes = (8 + gridsize) * this.NumVars;
            for (i = 0; i < this.NumVars; ++i) {
                this.MinVal[i] = 999999.9f;
                this.MaxVal[i] = -999999.9f;
            }
            for (int it = 0; it < this.NumTimes; ++it) {
                for (int iv = 0; iv < this.NumVars; ++iv) {
                    float ga = f.readFloat();
                    float gb = f.readFloat();
                    f.skipBytes(gridsize);
                    float min = -(125.0f + gb) / ga;
                    float max = (125.0f - gb) / ga;
                    if (min < this.MinVal[iv]) {
                        this.MinVal[iv] = min;
                    }
                    if (!(max > this.MaxVal[iv])) continue;
                    this.MaxVal[iv] = max;
                }
            }
        } else if (id == -2139062142 || id == -2139062141) {
            int it;
            int j;
            int iv;
            int i;
            float delta = 0.0f;
            int gridtimes = f.readInt();
            this.NumVars = f.readInt();
            this.NumTimes = f.readInt();
            this.Nr = f.readInt();
            this.Nc = f.readInt();
            int nl = f.readInt();
            for (i = 0; i < this.NumVars; ++i) {
                this.Nl[i] = nl;
            }
            this.ProjArgs[2] = f.readFloat();
            this.ProjArgs[3] = f.readFloat();
            this.VerticalSystem = 1;
            for (i = 0; i < nl; ++i) {
                this.VertArgs[i] = f.readFloat();
                if (i == 1) {
                    delta = this.VertArgs[1] - this.VertArgs[0];
                    continue;
                }
                if (i <= 1 || delta == this.VertArgs[i] - this.VertArgs[i - 1]) continue;
                this.VerticalSystem = 2;
            }
            if (this.VerticalSystem == 1) {
                this.VertArgs[1] = delta;
            }
            for (iv = 0; iv < this.NumVars; ++iv) {
                char[] name = new char[8];
                for (int q = 0; q < 8; ++q) {
                    name[q] = (char)f.readByte();
                }
                for (j = 7; j > 0 && (name[j] == ' ' || name[j] == '\u0000'); --j) {
                    name[j] = '\u0000';
                }
                System.arraycopy(name, 0, this.VarName[iv], 0, 8);
                this.VarName[iv][8] = '\u0000';
            }
            for (iv = 0; iv < this.NumVars; ++iv) {
                this.MinVal[iv] = f.readFloat();
            }
            for (iv = 0; iv < this.NumVars; ++iv) {
                this.MaxVal[iv] = f.readFloat();
            }
            for (it = 0; it < gridtimes; ++it) {
                j = f.readInt();
                this.TimeStamp[it] = V5DStruct.v5dSecondsToHHMMSS(j);
            }
            for (it = 0; it < gridtimes; ++it) {
                j = f.readInt();
                this.DateStamp[it] = V5DStruct.v5dDaysToYYDDD(j);
            }
            for (it = 0; it < gridtimes; ++it) {
                float nlat = f.readFloat();
                if (it != 0) continue;
                this.ProjArgs[0] = nlat;
            }
            for (it = 0; it < gridtimes; ++it) {
                float wlon = f.readFloat();
                if (it != 0) continue;
                this.ProjArgs[1] = wlon;
            }
            int gridsize = id == -2139062142 ? nl * 2 * 4 + (this.Nr * this.Nc * nl + 3) / 4 * 4 : 8 + nl * 2 * 4 + (this.Nr * this.Nc * nl + 3) / 4 * 4;
            for (i = 0; i < this.NumVars; ++i) {
                this.GridSize[i] = gridsize;
            }
            this.SumGridSizes = gridsize * this.NumVars;
            this.FirstGridPos = 36 + this.Nl[0] * 4 + this.NumVars * 16 + gridtimes * 16;
        }
        this.CompressMode = 1;
        this.Projection = 1;
        this.FileVersion = "";
        return true;
    }

    boolean read_comp_grid(int time, int vr, float[] ga, float[] gb, byte[] compdata1) throws IOException, BadFormException {
        int bias;
        int i;
        RandomAccessFile f = this.FileDesc;
        long pos = this.grid_position(time, vr);
        f.seek(pos);
        if (this.FileFormat == -2139062141) {
            int mcfile = f.readInt();
            int mcgrid = f.readInt();
            this.McFile[time][vr] = (short)mcfile;
            this.McGrid[time][vr] = (short)mcgrid;
        }
        int nl = this.Nl[vr];
        if (this.FileFormat == -2139062144 || this.FileFormat == -2139062143) {
            float a = f.readFloat();
            float b = f.readFloat();
            for (i = 0; i < nl; ++i) {
                if ((double)a == 0.0) {
                    gb[i] = 0.0f;
                    ga[i] = 0.0f;
                    continue;
                }
                gb[i] = (b + 128.0f) / -a;
                ga[i] = 1.0f / a;
            }
            bias = 128;
        } else {
            V5DStruct.read_float4_array(f, ga, this.Nl[vr]);
            V5DStruct.read_float4_array(f, gb, this.Nl[vr]);
            for (i = 0; i < nl; ++i) {
                if ((double)ga[i] == 0.0) {
                    gb[i] = 0.0f;
                    ga[i] = 0.0f;
                    continue;
                }
                gb[i] = (gb[i] + 128.0f) / -ga[i];
                ga[i] = 1.0f / ga[i];
            }
            bias = 128;
        }
        int n = this.Nr * this.Nc * this.Nl[vr];
        if (f.read(compdata1, 0, n) != n) {
            return false;
        }
        n = this.Nr * this.Nc * this.Nl[vr];
        i = 0;
        while (i < n) {
            int n2 = i++;
            compdata1[n2] = (byte)(compdata1[n2] + bias);
        }
        return true;
    }

    boolean read_v5d_header() throws IOException, BadFormException {
        int vr;
        RandomAccessFile f;
        boolean end_of_header;
        block66: {
            end_of_header = false;
            f = this.FileDesc;
            int order = 0;
            while (true) {
                f.seek(0L);
                f.order(order);
                int id = f.readInt();
                int idlen = f.readInt();
                if (id == 1446331402 && idlen == 0) break block66;
                if (id >= -2139062144 && id <= -2139062141) {
                    this.FileFormat = id;
                    return this.read_comp_header();
                }
                if (order != 0) break;
                order = 1;
            }
            System.out.println("unknown file type");
            return false;
        }
        this.FileFormat = 0;
        this.CompressMode = 1;
        block39: while (!end_of_header) {
            int tag = f.readInt();
            int length = f.readInt();
            switch (tag) {
                case 1000: {
                    int q;
                    V5DStruct.V5Dassert(length == 10);
                    byte[] b = new byte[10];
                    f.read(b, 0, 10);
                    int index = 10;
                    for (q = 0; q < 10; ++q) {
                        if (b[q] != 0) continue;
                        index = q;
                        break;
                    }
                    this.FileVersion = new String(b, 0, index);
                    if (this.FileVersion.compareTo(FILE_VERSION) <= 0) continue block39;
                    System.err.println("Warning: Trying to read a version " + this.FileVersion + " file, you should upgrade Vis5D.");
                    break;
                }
                case 1001: {
                    V5DStruct.V5Dassert(length == 4);
                    this.NumTimes = f.readInt();
                    break;
                }
                case 1002: {
                    V5DStruct.V5Dassert(length == 4);
                    this.NumVars = f.readInt();
                    break;
                }
                case 1003: {
                    int q;
                    V5DStruct.V5Dassert(length == 14);
                    vr = f.readInt();
                    for (q = 0; q < 10; ++q) {
                        this.VarName[vr][q] = (char)f.readByte();
                    }
                    continue block39;
                }
                case 1004: {
                    V5DStruct.V5Dassert(length == 4);
                    this.Nr = f.readInt();
                    break;
                }
                case 1005: {
                    V5DStruct.V5Dassert(length == 4);
                    this.Nc = f.readInt();
                    break;
                }
                case 1006: {
                    V5DStruct.V5Dassert(length == 4);
                    int nl = f.readInt();
                    for (int i = 0; i < this.NumVars; ++i) {
                        this.Nl[i] = nl;
                    }
                    continue block39;
                }
                case 1007: {
                    V5DStruct.V5Dassert(length == 8);
                    vr = f.readInt();
                    this.Nl[vr] = f.readInt();
                    break;
                }
                case 1008: {
                    V5DStruct.V5Dassert(length == 8);
                    vr = f.readInt();
                    this.LowLev[vr] = f.readInt();
                    break;
                }
                case 1010: {
                    V5DStruct.V5Dassert(length == 8);
                    int time = f.readInt();
                    this.TimeStamp[time] = f.readInt();
                    break;
                }
                case 1011: {
                    V5DStruct.V5Dassert(length == 8);
                    int time = f.readInt();
                    this.DateStamp[time] = f.readInt();
                    break;
                }
                case 1012: {
                    V5DStruct.V5Dassert(length == 8);
                    vr = f.readInt();
                    this.MinVal[vr] = f.readFloat();
                    break;
                }
                case 1013: {
                    V5DStruct.V5Dassert(length == 8);
                    vr = f.readInt();
                    this.MaxVal[vr] = f.readFloat();
                    break;
                }
                case 1014: {
                    V5DStruct.V5Dassert(length == 4);
                    this.CompressMode = f.readInt();
                    break;
                }
                case 1015: {
                    int q;
                    V5DStruct.V5Dassert(length == 24);
                    vr = f.readInt();
                    for (q = 0; q < 20; ++q) {
                        this.Units[vr][q] = (char)f.readByte();
                    }
                    continue block39;
                }
                case 2000: {
                    V5DStruct.V5Dassert(length == 4);
                    this.VerticalSystem = f.readInt();
                    if (this.VerticalSystem >= 0 && this.VerticalSystem <= 3) continue block39;
                    System.err.println("Error: bad vertical coordinate system: " + this.VerticalSystem);
                    break;
                }
                case 2100: {
                    int q;
                    int numargs = f.readInt();
                    V5DStruct.V5Dassert(numargs <= 401);
                    for (q = 0; q < numargs; ++q) {
                        this.VertArgs[q] = f.readFloat();
                    }
                    V5DStruct.V5Dassert(length == numargs * 4 + 4);
                    break;
                }
                case 2003: {
                    V5DStruct.V5Dassert(length == 8);
                    int lev = f.readInt();
                    this.VertArgs[lev] = f.readFloat();
                    break;
                }
                case 2001: {
                    V5DStruct.V5Dassert(length == 4);
                    this.VertArgs[0] = f.readFloat();
                    break;
                }
                case 2002: {
                    V5DStruct.V5Dassert(length == 4);
                    this.VertArgs[1] = f.readFloat();
                    break;
                }
                case 3000: {
                    V5DStruct.V5Dassert(length == 4);
                    this.Projection = f.readInt();
                    if (this.Projection >= 0 && this.Projection <= 4) continue block39;
                    System.err.println("Error while reading header, bad projection (" + this.Projection + ")");
                    return false;
                }
                case 3100: {
                    int q;
                    int numargs = f.readInt();
                    V5DStruct.V5Dassert(numargs <= 801);
                    for (q = 0; q < numargs; ++q) {
                        this.ProjArgs[q] = f.readFloat();
                    }
                    V5DStruct.V5Dassert(length == 4 * numargs + 4);
                    break;
                }
                case 3001: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[0] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3002: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[1] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3003: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[2] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3004: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 0 || this.Projection == 1 || this.Projection == 4) {
                        this.ProjArgs[3] = f.readFloat();
                        break;
                    }
                    if (this.Projection == 2) {
                        this.ProjArgs[5] = f.readFloat();
                        break;
                    }
                    if (this.Projection == 3) {
                        this.ProjArgs[4] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3005: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[0] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3006: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[1] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3007: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[2] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3008: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[3] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3009: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 2) {
                        this.ProjArgs[4] = f.readFloat();
                        break;
                    }
                    if (this.Projection == 3) {
                        this.ProjArgs[1] = f.readFloat();
                        break;
                    }
                    if (this.Projection == 4) {
                        this.ProjArgs[5] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3010: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 3) {
                        this.ProjArgs[0] = f.readFloat();
                        break;
                    }
                    if (this.Projection == 4) {
                        this.ProjArgs[4] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3011: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 3) {
                        this.ProjArgs[2] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3012: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 3) {
                        this.ProjArgs[3] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 3013: {
                    V5DStruct.V5Dassert(length == 4);
                    if (this.Projection == 4) {
                        this.ProjArgs[6] = f.readFloat();
                        break;
                    }
                    f.skipBytes(4);
                    break;
                }
                case 9999: {
                    end_of_header = true;
                    f.skipBytes(length);
                    break;
                }
                default: {
                    System.err.println("Unknown tag: " + tag + "  length=" + length);
                    f.skipBytes(length);
                }
            }
        }
        this.v5dVerifyStruct();
        this.FirstGridPos = (int)f.getFilePointer();
        this.SumGridSizes = 0;
        for (vr = 0; vr < this.NumVars; ++vr) {
            this.GridSize[vr] = 8 * this.Nl[vr] + this.v5dSizeofGrid(0, vr);
            this.SumGridSizes += this.GridSize[vr];
        }
        return true;
    }

    boolean v5dReadCompressedGrid(int time, int vr, float[] ga, float[] gb, byte[] compdata) throws IOException, BadFormException {
        boolean k = false;
        if (time < 0 || time >= this.NumTimes) {
            throw new IOException("Error in v5dReadCompressedGrid: bad timestep argument (" + time + ")");
        }
        if (vr < 0 || vr >= this.NumVars) {
            throw new IOException("Error in v5dReadCompressedGrid: bad var argument (" + vr + ")");
        }
        if (this.FileFormat != 0) {
            return this.read_comp_grid(time, vr, ga, gb, compdata);
        }
        int pos = this.grid_position(time, vr);
        this.FileDesc.seek(pos);
        V5DStruct.read_float4_array(this.FileDesc, ga, this.Nl[vr]);
        V5DStruct.read_float4_array(this.FileDesc, gb, this.Nl[vr]);
        int n = this.Nr * this.Nc * this.Nl[vr];
        if (this.CompressMode == 1) {
            k = V5DStruct.read_block(this.FileDesc, compdata, n, 1) == n;
        } else if (this.CompressMode == 2) {
            k = V5DStruct.read_block(this.FileDesc, compdata, n, 2) == n;
        } else if (this.CompressMode == 4) {
            boolean bl = k = V5DStruct.read_block(this.FileDesc, compdata, n, 4) == n;
        }
        if (!k) {
            System.err.println("Error in v5dReadCompressedGrid: read failed, bad file?");
        }
        return k;
    }

    boolean v5dReadGrid(int time, int vr, float[] data) throws IOException, BadFormException {
        int bytes;
        float[] ga = new float[400];
        float[] gb = new float[400];
        if (time < 0 || time >= this.NumTimes) {
            System.err.println("Error in v5dReadGrid: bad timestep argument (" + time + ")");
            return false;
        }
        if (vr < 0 || vr >= this.NumVars) {
            System.err.println("Error in v5dReadGrid: bad variable argument (" + vr + ")");
            return false;
        }
        if (this.CompressMode == 1) {
            bytes = this.Nr * this.Nc * this.Nl[vr] * 1;
        } else if (this.CompressMode == 2) {
            bytes = this.Nr * this.Nc * this.Nl[vr] * 2;
        } else if (this.CompressMode == 4) {
            bytes = this.Nr * this.Nc * this.Nl[vr] * 4;
        } else {
            System.err.println("Error in v5dReadGrid: bad compression mode (" + this.CompressMode + ")");
            return false;
        }
        byte[] compdata = new byte[bytes];
        if (!this.v5dReadCompressedGrid(time, vr, ga, gb, compdata)) {
            return false;
        }
        this.v5dDecompressGrid(this.Nr, this.Nc, this.Nl[vr], this.CompressMode, compdata, ga, gb, data);
        return true;
    }

    boolean write_tag(int tag, int length, boolean newfile) throws IOException {
        if (!newfile && this.CurPos + 8 + length > this.FirstGridPos) {
            System.err.println("Error: out of header space!");
            return false;
        }
        this.FileDesc.writeInt(tag);
        this.FileDesc.writeInt(length);
        this.CurPos += 8 + length;
        return true;
    }

    boolean write_v5d_header() throws IOException {
        int q;
        int vr;
        if (this.FileFormat != 0) {
            System.err.println("Error: v5d library can't write comp5d format files.");
            return false;
        }
        RandomAccessFile f = this.FileDesc;
        if (!this.v5dVerifyStruct()) {
            return false;
        }
        boolean newfile = this.FirstGridPos == 0;
        this.SumGridSizes = 0;
        for (vr = 0; vr < this.NumVars; ++vr) {
            this.GridSize[vr] = 8 * this.Nl[vr] + this.v5dSizeofGrid(0, vr);
            this.SumGridSizes += this.GridSize[vr];
        }
        f.seek(0L);
        this.CurPos = 0;
        if (!this.write_tag(1446331402, 0, newfile)) {
            return false;
        }
        if (!this.write_tag(1000, 10, newfile)) {
            return false;
        }
        f.write(FILE_VERSION.getBytes(), 0, 10);
        if (!this.write_tag(1001, 4, newfile)) {
            return false;
        }
        f.writeInt(this.NumTimes);
        if (!this.write_tag(1002, 4, newfile)) {
            return false;
        }
        f.writeInt(this.NumVars);
        for (vr = 0; vr < this.NumVars; ++vr) {
            if (!this.write_tag(1003, 14, newfile)) {
                return false;
            }
            f.writeInt(vr);
            for (q = 0; q < 10; ++q) {
                f.writeByte((byte)this.VarName[vr][q]);
            }
        }
        for (vr = 0; vr < this.NumVars; ++vr) {
            if (!this.write_tag(1015, 24, newfile)) {
                return false;
            }
            f.writeInt(vr);
            for (q = 0; q < 20; ++q) {
                f.writeByte((byte)this.Units[vr][q]);
            }
        }
        for (int time = 0; time < this.NumTimes; ++time) {
            if (!this.write_tag(1010, 8, newfile)) {
                return false;
            }
            f.writeInt(time);
            f.writeInt(this.TimeStamp[time]);
            if (!this.write_tag(1011, 8, newfile)) {
                return false;
            }
            f.writeInt(time);
            f.writeInt(this.DateStamp[time]);
        }
        if (!this.write_tag(1004, 4, newfile)) {
            return false;
        }
        f.writeInt(this.Nr);
        if (!this.write_tag(1005, 4, newfile)) {
            return false;
        }
        f.writeInt(this.Nc);
        int maxnl = 0;
        for (vr = 0; vr < this.NumVars; ++vr) {
            if (!this.write_tag(1007, 8, newfile)) {
                return false;
            }
            f.writeInt(vr);
            f.writeInt(this.Nl[vr]);
            if (!this.write_tag(1008, 8, newfile)) {
                return false;
            }
            f.writeInt(vr);
            f.writeInt(this.LowLev[vr]);
            if (this.Nl[vr] + this.LowLev[vr] <= maxnl) continue;
            maxnl = this.Nl[vr] + this.LowLev[vr];
        }
        for (vr = 0; vr < this.NumVars; ++vr) {
            if (!this.write_tag(1012, 8, newfile)) {
                return false;
            }
            f.writeInt(vr);
            f.writeFloat(this.MinVal[vr]);
            if (!this.write_tag(1013, 8, newfile)) {
                return false;
            }
            f.writeInt(vr);
            f.writeFloat(this.MaxVal[vr]);
        }
        if (!this.write_tag(1014, 4, newfile)) {
            return false;
        }
        f.writeInt(this.CompressMode);
        if (!this.write_tag(2000, 4, newfile)) {
            return false;
        }
        f.writeInt(this.VerticalSystem);
        if (!this.write_tag(2100, 1608, newfile)) {
            return false;
        }
        f.writeInt(401);
        for (q = 0; q < 401; ++q) {
            f.writeFloat(this.VertArgs[q]);
        }
        if (!this.write_tag(3000, 4, newfile)) {
            return false;
        }
        f.writeInt(this.Projection);
        if (!this.write_tag(3100, 3208, newfile)) {
            return false;
        }
        f.writeInt(801);
        for (q = 0; q < 801; ++q) {
            f.writeFloat(this.ProjArgs[q]);
        }
        if (newfile) {
            if (!this.write_tag(9999, 10000, newfile)) {
                return false;
            }
            f.skipBytes(10000);
            this.FirstGridPos = (int)f.getFilePointer();
        } else {
            int filler = this.FirstGridPos - (int)f.getFilePointer();
            if (!this.write_tag(9999, filler - 8, newfile)) {
                return false;
            }
        }
        return true;
    }

    boolean v5dCreateFile(String filename) throws IOException {
        RandomAccessFile fd = new RandomAccessFile(filename, "rw");
        if (fd == null) {
            System.err.println("Error in v5dCreateFile: open failed");
            this.FileDesc = null;
            this.Mode = '\u0000';
            return false;
        }
        this.FileDesc = fd;
        this.Mode = (char)119;
        return this.write_v5d_header();
    }

    boolean v5dWriteCompressedGrid(int time, int vr, float[] ga, float[] gb, byte[] compdata) throws IOException, BadFormException {
        int q;
        if (this.Mode != 'w') {
            System.err.println("Error in v5dWriteCompressedGrid: file opened for reading, not writing.");
            return false;
        }
        if (time < 0 || time >= this.NumTimes) {
            System.err.println("Error in v5dWriteCompressedGrid: bad timestep argument (" + time + ")");
            return false;
        }
        if (vr < 0 || vr >= this.NumVars) {
            System.err.println("Error in v5dWriteCompressedGrid: bad variable argument (" + vr + ")");
            return false;
        }
        int pos = this.grid_position(time, vr);
        this.FileDesc.seek(pos);
        boolean k = false;
        for (q = 0; q < this.Nl[vr]; ++q) {
            this.FileDesc.writeFloat(ga[q]);
        }
        for (q = 0; q < this.Nl[vr]; ++q) {
            this.FileDesc.writeFloat(gb[q]);
        }
        int n = this.Nr * this.Nc * this.Nl[vr];
        if (this.CompressMode == 1) {
            k = V5DStruct.write_block(this.FileDesc, compdata, n, 1) == n;
        } else if (this.CompressMode == 2) {
            k = V5DStruct.write_block(this.FileDesc, compdata, n, 2) == n;
        } else if (this.CompressMode == 4) {
            boolean bl = k = V5DStruct.write_block(this.FileDesc, compdata, n, 4) == n;
        }
        if (!k) {
            System.err.println("Error in v5dWrite[Compressed]Grid: write failed, disk full?");
        }
        return k;
    }

    boolean v5dWriteGrid(int time, int vr, float[] data) throws IOException, BadFormException {
        int bytes;
        float[] ga = new float[400];
        float[] gb = new float[400];
        if (this.Mode != 'w') {
            System.err.println("Error in v5dWriteGrid: file opened for reading, not writing.");
            return false;
        }
        if (time < 0 || time >= this.NumTimes) {
            System.err.println("Error in v5dWriteGrid: bad timestep argument (" + time + ")");
            return false;
        }
        if (vr < 0 || vr >= this.NumVars) {
            System.err.println("Error in v5dWriteGrid: bad variable argument (" + vr + ")");
            return false;
        }
        if (this.CompressMode == 1) {
            bytes = this.Nr * this.Nc * this.Nl[vr] * 2;
        } else if (this.CompressMode == 2) {
            bytes = this.Nr * this.Nc * this.Nl[vr] * 2;
        } else if (this.CompressMode == 4) {
            bytes = this.Nr * this.Nc * this.Nl[vr] * 4;
        } else {
            System.err.println("Error in v5dWriteGrid: bad compression mode (" + this.CompressMode + ")");
            return false;
        }
        byte[] compdata = new byte[bytes];
        float[] min1 = new float[1];
        float[] max1 = new float[1];
        V5DStruct.v5dCompressGrid(this.Nr, this.Nc, this.Nl[vr], this.CompressMode, data, compdata, ga, gb, min1, max1);
        float min = min1[0];
        float max = max1[0];
        if (min < this.MinVal[vr]) {
            this.MinVal[vr] = min;
        }
        if (max > this.MaxVal[vr]) {
            this.MaxVal[vr] = max;
        }
        return this.v5dWriteCompressedGrid(time, vr, ga, gb, compdata);
    }

    boolean v5dCloseFile() throws IOException {
        boolean status = true;
        if (this.Mode == 'w') {
            this.FileDesc.seek(0L);
            status = this.write_v5d_header();
            this.FileDesc.seek(this.FileDesc.length());
            this.FileDesc.close();
        } else if (this.Mode == 'r') {
            this.FileDesc.close();
        } else {
            System.err.println("Error in v5dCloseFile: bad V5DStruct argument");
            return false;
        }
        this.FileDesc = null;
        this.Mode = '\u0000';
        return status;
    }
}

