/*
 * Decompiled with CFR 0.152.
 */
package visad.bom;

import java.rmi.RemoteException;
import java.util.Enumeration;
import java.util.Vector;
import visad.ControlEvent;
import visad.ControlListener;
import visad.Data;
import visad.DataDisplayLink;
import visad.DataRenderer;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.DisplayTupleType;
import visad.ProjectionControl;
import visad.Real;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.Tuple;
import visad.VisADException;
import visad.java3d.MouseBehaviorJ3D;

public class DiscoverableZoom
implements ControlListener {
    private boolean pfirst = true;
    private double base_scale = 1.0;
    private float last_cscale = 1.0f;
    private float latmul;
    private float lonmul;
    private DataRenderer[] renderers = null;
    private boolean[] enabled = null;
    private int nrenderers = -1;
    private float[] lons = null;
    private float[] lats = null;

    public void setRenderers(DataRenderer[] rs, float distance) throws VisADException, RemoteException {
        this.renderers = rs;
        if (this.renderers != null) {
            this.nrenderers = this.renderers.length;
            if (this.nrenderers == 0) {
                this.nrenderers = -1;
                return;
            }
            this.lons = new float[this.nrenderers];
            this.lats = new float[this.nrenderers];
            this.enabled = new boolean[this.nrenderers];
            for (int i = 0; i < this.nrenderers; ++i) {
                Real[] reals;
                Data data;
                this.lons[i] = Float.NaN;
                this.lats[i] = Float.NaN;
                this.enabled[i] = true;
                DataDisplayLink[] links = this.renderers[i].getLinks();
                if (links == null || links.length == 0 || (data = links[0].getData()) == null || !(data instanceof Tuple) || (reals = ((Tuple)data).getRealComponents()) == null || reals.length == 0) continue;
                for (int j = 0; j < reals.length; ++j) {
                    if (RealType.Latitude.equals(reals[j].getType())) {
                        this.lats[i] = (float)reals[j].getValue();
                        continue;
                    }
                    if (!RealType.Longitude.equals(reals[j].getType())) continue;
                    this.lons[i] = (float)reals[j].getValue();
                }
                if (this.lats[i] == this.lats[i] && this.lons[i] == this.lons[i]) continue;
                this.lons[i] = Float.NaN;
                this.lats[i] = Float.NaN;
            }
            DisplayImpl display = this.renderers[0].getDisplay();
            if (display == null) {
                this.nrenderers = -1;
                return;
            }
            ScalarMap latmap = null;
            ScalarMap lonmap = null;
            Vector mapVector = display.getMapVector();
            Enumeration maps = mapVector.elements();
            while (maps.hasMoreElements()) {
                ScalarMap map = (ScalarMap)maps.nextElement();
                ScalarType real = map.getScalar();
                DisplayRealType dreal = map.getDisplayScalar();
                DisplayTupleType rtuple = dreal.getTuple();
                if (rtuple == null || !rtuple.equals(Display.DisplaySpatialCartesianTuple) && (rtuple.getCoordinateSystem() == null || !rtuple.getCoordinateSystem().getReference().equals(Display.DisplaySpatialCartesianTuple))) continue;
                if (RealType.Latitude.equals(real)) {
                    latmap = map;
                    continue;
                }
                if (!RealType.Longitude.equals(real)) continue;
                lonmap = map;
            }
            if (latmap == null || lonmap == null) {
                this.nrenderers = -1;
                return;
            }
            double[] latrange = latmap.getRange();
            double[] lonrange = lonmap.getRange();
            this.latmul = (float)(1.0 / (Math.abs(latrange[1] - latrange[0]) * (double)distance));
            this.lonmul = (float)(1.0 / (Math.abs(lonrange[1] - lonrange[0]) * (double)distance));
            if (this.latmul != this.latmul || this.lonmul != this.lonmul) {
                this.nrenderers = -1;
                return;
            }
        } else {
            this.nrenderers = -1;
            return;
        }
    }

    public void controlChanged(ControlEvent e) throws VisADException, RemoteException {
        ProjectionControl pcontrol = (ProjectionControl)e.getControl();
        double[] matrix = pcontrol.getMatrix();
        double[] rot = new double[3];
        double[] scale = new double[1];
        double[] trans = new double[3];
        MouseBehaviorJ3D.unmake_matrix(rot, scale, trans, matrix);
        if (this.pfirst) {
            this.pfirst = false;
            this.base_scale = scale[0];
            this.last_cscale = 1.0f;
        } else {
            if (this.nrenderers < 0) {
                return;
            }
            float cscale = (float)(this.base_scale / scale[0]);
            float ratio = cscale / this.last_cscale;
            if (ratio < 0.95f || 1.05f < ratio) {
                this.last_cscale = cscale;
                for (int i = 0; i < this.nrenderers; ++i) {
                    boolean enable = true;
                    if (this.lats[i] == this.lats[i] && this.lons[i] == this.lons[i]) {
                        for (int j = 0; j < i; ++j) {
                            float lond;
                            float latd;
                            float distsq;
                            if (!this.enabled[j] || this.lats[j] != this.lats[j] || this.lons[j] != this.lons[j] || !((distsq = (latd = this.latmul * (this.lats[j] - this.lats[i]) / cscale) * latd + (lond = this.lonmul * (this.lons[j] - this.lons[i]) / cscale) * lond) < 1.0f)) continue;
                            enable = false;
                            break;
                        }
                    }
                    this.enabled[i] = enable;
                    this.renderers[i].toggle(enable);
                }
            }
        }
    }
}

