/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Vector;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.TermFreqVector;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.OutputStream;
import org.apache.lucene.util.StringHelper;

final class TermVectorsWriter {
    public static final int FORMAT_VERSION = 1;
    public static final int FORMAT_SIZE = 4;
    public static final String TVX_EXTENSION = ".tvx";
    public static final String TVD_EXTENSION = ".tvd";
    public static final String TVF_EXTENSION = ".tvf";
    private OutputStream tvx = null;
    private OutputStream tvd = null;
    private OutputStream tvf = null;
    private Vector fields = null;
    private Vector terms = null;
    private FieldInfos fieldInfos;
    private TVField currentField = null;
    private long currentDocPointer = -1L;

    public TermVectorsWriter(Directory directory, String segment, FieldInfos fieldInfos) throws IOException {
        this.tvx = directory.createFile(segment + TVX_EXTENSION);
        this.tvx.writeInt(1);
        this.tvd = directory.createFile(segment + TVD_EXTENSION);
        this.tvd.writeInt(1);
        this.tvf = directory.createFile(segment + TVF_EXTENSION);
        this.tvf.writeInt(1);
        this.fieldInfos = fieldInfos;
        this.fields = new Vector(fieldInfos.size());
        this.terms = new Vector();
    }

    public final void openDocument() throws IOException {
        this.closeDocument();
        this.currentDocPointer = this.tvd.getFilePointer();
    }

    public final void closeDocument() throws IOException {
        if (this.isDocumentOpen()) {
            this.closeField();
            this.writeDoc();
            this.fields.clear();
            this.currentDocPointer = -1L;
        }
    }

    public final boolean isDocumentOpen() {
        return this.currentDocPointer != -1L;
    }

    public final void openField(String field) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot open field when no document is open.");
        }
        this.closeField();
        this.currentField = new TVField(this.fieldInfos.fieldNumber(field));
    }

    public final void closeField() throws IOException {
        if (this.isFieldOpen()) {
            this.writeField();
            this.fields.add(this.currentField);
            this.terms.clear();
            this.currentField = null;
        }
    }

    public final boolean isFieldOpen() {
        return this.currentField != null;
    }

    public final void addTerm(String termText, int freq) {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add terms when document is not open");
        }
        if (!this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add terms when field is not open");
        }
        this.addTermInternal(termText, freq);
    }

    private final void addTermInternal(String termText, int freq) {
        this.currentField.length += freq;
        TVTerm term = new TVTerm();
        term.termText = termText;
        term.freq = freq;
        this.terms.add(term);
    }

    public final void addVectors(TermFreqVector[] vectors) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add term vectors when document is not open");
        }
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add term vectors when field is open");
        }
        for (int i = 0; i < vectors.length; ++i) {
            this.addTermFreqVector(vectors[i]);
        }
    }

    public final void addTermFreqVector(TermFreqVector vector) throws IOException {
        if (!this.isDocumentOpen()) {
            throw new IllegalStateException("Cannot add term vector when document is not open");
        }
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Cannot add term vector when field is open");
        }
        this.addTermFreqVectorInternal(vector);
    }

    private final void addTermFreqVectorInternal(TermFreqVector vector) throws IOException {
        this.openField(vector.getField());
        for (int i = 0; i < vector.size(); ++i) {
            this.addTermInternal(vector.getTerms()[i], vector.getTermFrequencies()[i]);
        }
        this.closeField();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void close() throws IOException {
        IOException keep2;
        block20: {
            IOException e22;
            block19: {
                block18: {
                    try {
                        this.closeDocument();
                        Object var2_1 = null;
                        keep2 = null;
                        if (this.tvx == null) break block18;
                    }
                    catch (Throwable throwable) {
                        IOException keep2;
                        block23: {
                            IOException e22;
                            block22: {
                                block21: {
                                    Object var2_2 = null;
                                    keep2 = null;
                                    if (this.tvx != null) {
                                        try {
                                            this.tvx.close();
                                        }
                                        catch (IOException e22) {
                                            if (keep2 != null) break block21;
                                            keep2 = e22;
                                        }
                                    }
                                }
                                if (this.tvd != null) {
                                    try {
                                        this.tvd.close();
                                    }
                                    catch (IOException e22) {
                                        if (keep2 != null) break block22;
                                        keep2 = e22;
                                    }
                                }
                            }
                            if (this.tvf != null) {
                                try {
                                    this.tvf.close();
                                }
                                catch (IOException e22) {
                                    if (keep2 != null) break block23;
                                    keep2 = e22;
                                }
                            }
                        }
                        if (keep2 != null) {
                            throw (IOException)keep2.fillInStackTrace();
                        }
                        throw throwable;
                    }
                    try {
                        this.tvx.close();
                    }
                    catch (IOException e22) {
                        if (keep2 != null) break block18;
                        keep2 = e22;
                    }
                }
                if (this.tvd != null) {
                    try {
                        this.tvd.close();
                    }
                    catch (IOException e22) {
                        if (keep2 != null) break block19;
                        keep2 = e22;
                    }
                }
            }
            if (this.tvf != null) {
                try {
                    this.tvf.close();
                }
                catch (IOException e22) {
                    if (keep2 != null) break block20;
                    keep2 = e22;
                }
            }
        }
        if (keep2 != null) {
            throw (IOException)keep2.fillInStackTrace();
        }
    }

    private void writeField() throws IOException {
        this.currentField.tvfPointer = this.tvf.getFilePointer();
        int size = this.terms.size();
        this.tvf.writeVInt(size);
        this.tvf.writeVInt(this.currentField.length - size);
        String lastTermText = "";
        for (int i = 0; i < size; ++i) {
            TVTerm term = (TVTerm)this.terms.elementAt(i);
            int start = StringHelper.stringDifference(lastTermText, term.termText);
            int length = term.termText.length() - start;
            this.tvf.writeVInt(start);
            this.tvf.writeVInt(length);
            this.tvf.writeChars(term.termText, start, length);
            this.tvf.writeVInt(term.freq);
            lastTermText = term.termText;
        }
    }

    private void writeDoc() throws IOException {
        if (this.isFieldOpen()) {
            throw new IllegalStateException("Field is still open while writing document");
        }
        this.tvx.writeLong(this.currentDocPointer);
        int size = this.fields.size();
        this.tvd.writeVInt(size);
        int lastFieldNumber = 0;
        for (int i = 0; i < size; ++i) {
            TVField field = (TVField)this.fields.elementAt(i);
            this.tvd.writeVInt(field.number - lastFieldNumber);
            lastFieldNumber = field.number;
        }
        long lastFieldPointer = 0L;
        for (int i = 0; i < size; ++i) {
            TVField field = (TVField)this.fields.elementAt(i);
            this.tvd.writeVLong(field.tvfPointer - lastFieldPointer);
            lastFieldPointer = field.tvfPointer;
        }
    }

    private static class TVTerm {
        String termText;
        int freq = 0;

        private TVTerm() {
        }
    }

    private static class TVField {
        int number;
        long tvfPointer = 0L;
        int length = 0;

        TVField(int number) {
            this.number = number;
        }
    }
}

