/***************************************************************************
                          addconstrainttwosetsofactivitiesorderedform.h  -  description
                             -------------------
    begin                : 2021
    copyright            : (C) 2021 by Lalescu Liviu
    email                : Please see https://lalescu.ro/liviu/ for details about contacting Liviu Lalescu (in particular, you can find here the e-mail address)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software: you can redistribute it and/or modify  *
 *   it under the terms of the GNU Affero General Public License as        *
 *   published by the Free Software Foundation, either version 3 of the    *
 *   License, or (at your option) any later version.                       *
 *                                                                         *
 ***************************************************************************/

#ifndef ADDCONSTRAINTTWOSETSOFACTIVITIESORDEREDFORM_H
#define ADDCONSTRAINTTWOSETSOFACTIVITIESORDEREDFORM_H

#include "ui_addconstrainttwosetsofactivitiesorderedform_template.h"
#include "timetable_defs.h"
#include "timetable.h"
#include "fet.h"

#include <QList>

class AddConstraintTwoSetsOfActivitiesOrderedForm : public QDialog, Ui::AddConstraintTwoSetsOfActivitiesOrderedForm_template  {
	Q_OBJECT

public:
	AddConstraintTwoSetsOfActivitiesOrderedForm(QWidget* parent);
	~AddConstraintTwoSetsOfActivitiesOrderedForm();

	bool filterOk(Activity* a);

public slots:
	void filterChanged();

	void firstAddActivity();
	void firstAddAllActivities();
	void firstRemoveActivity();
	void firstClear();

	void secondAddActivity();
	void secondAddAllActivities();
	void secondRemoveActivity();
	void secondClear();

	void addConstraint();
	
	void swap();
	
private:
	//the id's of the activities listed in the first activities list
	QList<int> firstActivitiesList;
	//the id-s of the activities listed in the list of first selected activities
	QList<int> firstSelectedActivitiesList;

	//the id's of the activities listed in the second activities list
	QList<int> secondActivitiesList;
	//the id-s of the activities listed in the list of second selected activities
	QList<int> secondSelectedActivitiesList;
};

#endif
