package fix;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.FontMetrics;
import java.awt.GridBagConstraints;
import java.awt.GridLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.text.NumberFormat;

import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.RepaintManager;

/**
 * The JFrame showing the GUI for F*EX.
 * 
 * $Date: 2010-02-04 12:01:01 +0100 (Thu, 04 Feb 2010) $
 * $Revision: 30 $
 * $Author: roth $
 * 
 * @author Dominik Greibl
 * 
 * Copyright (C) 2008 Dominik Greibl
 * Copyright (C) 2009 Sebastian Roth
 * 
 * All Rights Reserved
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public class AppletFrame extends JFrame implements ActionListener {

	private static final long serialVersionUID = 1L;
	private JPanel jContentPane = null;
	private JPanel dataPanel = null;
	private JPanel bottomPanel = null;
	private JPanel recPanel = null;
	private JPanel filePanel = null;
	private JLabel recLabel = null;
	private JTextField recField = null;
	private JLabel fileLabel = null;
	private JTextField fileField = null;
	private JButton fileButton = null;
	private JMenuBar mainMenuBar = null;
	private JMenu fileMenu = null;
	private JMenuItem resetItem = null;
	private JMenuItem exitItem = null;
	private JPanel commentPanel = null;
	private JLabel commentLabel = null;
	private JTextField commentField = null;
	private JMenu optionMenu = null;
	private JPanel buttonPanel = null;
	private JButton sendButton = null;
	private JPanel statusBarPanel = null;
	private JLabel statusLabel = null;
	private ImageIcon sendImg = null;
	private ImageIcon exitImg = null;
	private ImageIcon infoImg = null;
	private ImageIcon reseImg = null;
	private JFileChooser browser = null;
	private Sender s = null;
	private JMenuItem infoItem = null;
	private JFrame infoFrame = null;
	private JPanel infoPanel = null;
	private JButton infoCloseButton = null;
	private JPanel sizePanel = null;
	private JLabel sizeLabel = null;
	private JRadioButtonMenuItem downCheck = null;
	private JRadioButtonMenuItem viewCheck = null;
	public JProgressBar progressBar = null;
	private String sizeUnit = "";
	private String host = "";
	private String use = "";
	private String auth = "";
	private String touser = "";
	private String akey = "";
	private String skey = "";
	private ErrorWindow er = null;
	private boolean debug = false;
	private String versionNumber = "$Revision: 30 $";
	private File homeDir;
	private File tempFile = null;

	/**
	 * Sole constructor, sets the Trustmanager, the version number and the given values.
	 * 
	 * @param server	address of the server to connect to
	 * @param user		email address of the user who is logged in
	 * @param id		auth-id of the user mentioned above
	 * @param e			the ErrorWindow for showing error messages
	 * @param d			flag to set debugging
	 */
	public AppletFrame(String server, String user, String id, String to, String akey, String skey, ErrorWindow e, boolean d) {
		super();
		host = server;
		use = user;
		auth = id;
		touser = to;
		this.akey = akey;
		this.skey = skey;
		er = e;
		debug = d;
		versionNumber = "Revision " + versionNumber.split("\\$")[1].split(": ")[1];
		System.setProperty("javax.net.ssl.trustStore ", "fix.NaiveTrustManager");
		initialize();
	}

	/**
	 * initializes this
	 */
	private void initialize() {
		this.setSize(500, 260);
		int x = (int) Toolkit.getDefaultToolkit().getScreenSize().getWidth() / 2;
		int y = (int) Toolkit.getDefaultToolkit().getScreenSize().getHeight() / 2;
		x = x - this.getWidth() / 2;
		y = y - this.getHeight() / 2;
		this.setBounds(x, y, this.getWidth(), this.getHeight());
		this.setJMenuBar(getMainMenuBar());
		browser = new JFileChooser();
		homeDir = browser.getCurrentDirectory();
		this.setContentPane(getJContentPane());
		this.setTitle("F*IX");
		this.setVisible(true);
		this.setResizable(false);
		if (!host.startsWith("http://") && !host.startsWith("https://")) {
			er.setMess("Server protocol has to be http or https.", null);
		}
		resetAllGUIElements();
		//this.setDefaultCloseOperation(EXIT_ON_CLOSE);
		
		this.addWindowListener(new WindowAdapter() {
	        public void windowClosing(WindowEvent evt) {
				if ((tempFile != null) && (tempFile.exists())) {
					tempFile.delete();
				}
	        }
	    });
	}

	/**
	 * Initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		if (jContentPane == null) {
			jContentPane = new JPanel();
			jContentPane.setLayout(new BorderLayout());
			jContentPane.add(getDataPanel(), java.awt.BorderLayout.NORTH);
			jContentPane.add(getBottomPanel(), java.awt.BorderLayout.CENTER);
			jContentPane.add(getStatusPanel(), BorderLayout.SOUTH);
		}
		return jContentPane;
	}

	/**
	 * Called by button click or shortcuts.
	 */
	public void actionPerformed(ActionEvent arg0) {
		String c = arg0.getActionCommand();
		if (c.equals("reset")) { //ResetItem pressed
			resetAllGUIElements();
			if ((tempFile != null) && (tempFile.exists())) {
				tempFile.delete();
			}
		} else if (c.equals("exit")) { //ExitItem pressed
			if ((tempFile != null) && (tempFile.exists())) {
				tempFile.delete();
			}
			this.dispose();
		} else if (c.equals("browse")) { //fileButton pressed
			browser.setDialogTitle("Open - Use Ctrl/Strg key to select multiple files/dirs");
			browser.setFileSelectionMode(JFileChooser.FILES_AND_DIRECTORIES);
			browser.setMultiSelectionEnabled(true);
			browser.setCurrentDirectory(homeDir);
			browser.setSelectedFile(new File(""));
			int returnVal = browser.showOpenDialog(this);
			if (returnVal == JFileChooser.APPROVE_OPTION) {
				if ((tempFile != null) && tempFile.exists()) {
					tempFile.delete();
				}
				homeDir = browser.getCurrentDirectory();
				File []selectedFiles = browser.getSelectedFiles();
				if (selectedFiles.length == 1 && selectedFiles[0].isFile()) { 
					setFileText(selectedFiles[0].getAbsolutePath());
					setStatusLabel("ready to send");
					sendButton.setEnabled(true);
				}
				else {
					if (tempFile == null) {
						tempFile = new File(System.getProperty("user.home") 
							+ File.separator + "fex.zip");
						tempFile.deleteOnExit();
					}
					browser.setDialogTitle("Multiple files selected, where shall I save the ZIP archive?");
					browser.setFileSelectionMode(JFileChooser.FILES_ONLY);
					browser.setMultiSelectionEnabled(false);
					browser.setSelectedFile(tempFile);
					while (browser.showDialog(this, "Save & Send") == JFileChooser.APPROVE_OPTION) {
						tempFile = browser.getSelectedFile();
						int overwriteReturnValue = JOptionPane.YES_OPTION;
						if (tempFile.exists()) {
							overwriteReturnValue = JOptionPane.NO_OPTION;
							overwriteReturnValue = JOptionPane.showConfirmDialog(null,
									tempFile.toString() + " already exists." + System.getProperty("line.separator")
							        + "Do you want to replace it?", "File Already Exists",
							        JOptionPane.YES_NO_OPTION, JOptionPane.WARNING_MESSAGE);
						}
						if (overwriteReturnValue == JOptionPane.YES_OPTION) {
							setStatusLabel("creating ZIP file, please wait");
							setFileText("...");
							RepaintManager.currentManager(this).markCompletelyDirty(jContentPane);
							RepaintManager.currentManager(this).markCompletelyDirty(mainMenuBar);
							RepaintManager.currentManager(this).paintDirtyRegions();
							try {
								ZipFactory zip = new ZipFactory(progressBar);
								for (int i = 0; i < selectedFiles.length; i++) {
									zip.add(selectedFiles[i]);
								}
								if (zip.updateSum(selectedFiles) >= ((long)4096 * 1024 * 1024)) {  // ZIP files larger than 4 GB are not supported yet
									resetAllGUIElements();
									er.setMess("Sorry ZIP files larger than 4 GB cannot be created. " + 
											"We have to wait for Java 1.7...", null);
									break;
								}
								progressBar.setValue(0);
								progressBar.setVisible(true);
								zip.create(new FileOutputStream(tempFile));
								progressBar.setVisible(false);
								progressBar.setValue(0);
								setFileText(tempFile.getAbsolutePath());
								setStatusLabel("ZIP created, ready to send");
								RepaintManager.currentManager(dataPanel).paintDirtyRegions();
								sendButton.setEnabled(true);
								sendButton.doClick(2);
							} catch (FileNotFoundException e) {
								er.setMess("Unable to add a file to the temporary ZIP archive.", null);
								if ((tempFile != null) && (tempFile.exists())) {
									tempFile.delete();
								}
							} catch (IOException e) {
								er.setMess("Unable to create temporary ZIP file: " + e.getMessage(), null);
								if ((tempFile != null) && (tempFile.exists())) {
									tempFile.delete();
								}
							}
							break;
						}
					}
				}
			}
		} else if (c.equals("send")) { //sendButton pressed
			if (isFieldSet(recField)) {
				if (isFieldSet(fileField)) {
					if (new File(fileField.getText()).length() > 0) {
						setStatusLabel("sending");
						s = new Sender(recField.getText(), fileField.getText(),
								commentField.getText(), viewCheck.isSelected(),
								host, use, auth, akey, skey, er, debug);
						if (s.send(progressBar, statusLabel)) {
							if (tempFile != null && tempFile.exists()) {
								tempFile.delete();
							}
							resetAllGUIElements();
						}
						else {
							setStatusLabel("error...");
						}
					} else {
						er.setMess("Your file is empty.", null);
					}
				} else {
					er.setMess("Enter or choose file please.", null);
				}
			} else {
				er.setMess("Enter recipients E-Mail please.", null);
			}
		} else if (c.equals("info")) { //infoItem pressed
			getInfoFrame();
		} else if (c.equals("change")) { //fileField changed
			File f = new File(fileField.getText());
			updateFileSize(f.length());
		} else if (c.equals("closeinfo")) { // InfoFrame closing
			infoFrame.dispose();
		} else {
			System.out.println(c);
		}

	}

	/**
	 * Initializes dataPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getDataPanel() {
		if (dataPanel == null) {
			dataPanel = new JPanel();
			dataPanel.setLayout(new BorderLayout());
			dataPanel.add(getRecPanel(), java.awt.BorderLayout.NORTH);
			dataPanel.add(getFilePanel(), java.awt.BorderLayout.CENTER);
			dataPanel.add(getSizePanel(), BorderLayout.SOUTH);
		}
		return dataPanel;
	}

	/**
	 * Initializes filePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getFilePanel() {
		if (filePanel == null) {
			fileLabel = new JLabel();
			fileLabel.setText("File");
			filePanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			filePanel.add(getFileButton(), null);
			filePanel.add(fileLabel, null);
			filePanel.add(getFileField(), null);
			filePanel.add(getFileButton(), null);
		}
		return filePanel;
	}

	/**
	 * Initializes recPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getRecPanel() {
		if (recPanel == null) {
			recPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			recLabel = new JLabel("Recipient");
			recPanel.add(recLabel);
			recPanel.add(getRecField());
		}
		return recPanel;
	}

	/**
	 * Initializes bottomPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getBottomPanel() {
		if (bottomPanel == null) {
			bottomPanel = new JPanel();
			bottomPanel.setLayout(new BorderLayout());
			bottomPanel.add(getButtonPanel(), BorderLayout.CENTER);
			bottomPanel.add(getProgressBar(), BorderLayout.SOUTH);
			bottomPanel.add(getCommentPanel(), java.awt.BorderLayout.NORTH);
		}
		return bottomPanel;
	}

	/**
	 * Initializes recField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	public JTextField getRecField() {
		if (recField == null) {
			recField = new JTextField();
			recField.setColumns(35);
		}
		return recField;

	}

	/**
	 * Initializes fileField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	public JTextField getFileField() {
		if (fileField == null) {
			fileField = new JTextField();
			fileField.setColumns(30);
			fileField.setActionCommand("change");
			fileField.addActionListener(this);
		}
		return fileField;
	}

	/**
	 * Initializes fileButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getFileButton() {
		if (fileButton == null) {
			fileButton = new JButton();
			fileButton.setText("Browse...");
			fileButton.setActionCommand("browse");
			fileButton.addActionListener(this);
			fileButton.setMnemonic('B');
		}
		return fileButton;
	}

	/**
	 * Initializes mainMenuBar	
	 * 	
	 * @return javax.swing.JMenuBar	
	 */
	private JMenuBar getMainMenuBar() {
		if (mainMenuBar == null) {
			exitImg = createImageIcon("/icons/exit.png", "Exit Icon");
			reseImg = createImageIcon("/icons/rese.png", "Reset Icon");
			infoImg = createImageIcon("/icons/info.png", "Info Icon");
			mainMenuBar = new JMenuBar();
			mainMenuBar.add(getFileMenu());
			mainMenuBar.add(getOptionMenu());
			mainMenuBar.add(getFileMenu());
			mainMenuBar.add(getOptionMenu());
		}
		return mainMenuBar;
	}

	/**
	 * Initializes fileMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getFileMenu() {
		if (fileMenu == null) {
			fileMenu = new JMenu();
			fileMenu.setText("File");
			fileMenu.setMnemonic('F');
			fileMenu.add(getResetItem());
			fileMenu.add(getExitItem());
		}
		return fileMenu;
	}

	/**
	 * Initializes resetItem	
	 * 	
	 * 	@return javax.swing.JMenuItem	
	 */
	private JMenuItem getResetItem() {
		if (resetItem == null) {
			resetItem = new JMenuItem();
			resetItem.setText("Reset");
			resetItem.setMnemonic('R');
			resetItem.setIcon(reseImg);
			resetItem.setActionCommand("reset");
			resetItem.addActionListener(this);
		}
		return resetItem;
	}

	/**
	 * Initializes exitItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getExitItem() {
		if (exitItem == null) {
			exitItem = new JMenuItem();
			exitItem.setText("Quit");
			exitItem.setMnemonic('Q');
			exitItem.setIcon(exitImg);
			exitItem.setActionCommand("exit");
			exitItem.addActionListener(this);
		}
		return exitItem;
	}

	/**
	 * Initializes commentPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getCommentPanel() {
		if (commentPanel == null) {
			commentLabel = new JLabel();
			commentLabel.setText("Comment (optional)");
			commentPanel = new JPanel(new FlowLayout(FlowLayout.RIGHT));
			commentPanel.add(commentLabel, commentLabel.getName());
			commentPanel.add(getCommentField(), null);
		}
		return commentPanel;
	}

	/**
	 * Initializes commentField	
	 * 	
	 * @return javax.swing.JTextField	
	 */
	private JTextField getCommentField() {
		if (commentField == null) {
			commentField = new JTextField();
			commentField.setColumns(30);
		}
		return commentField;
	}

	/**
	 * Initializes optionMenu	
	 * 	
	 * @return javax.swing.JMenu	
	 */
	private JMenu getOptionMenu() {
		if (optionMenu == null) {
			optionMenu = new JMenu();
			optionMenu.setText("Options");
			optionMenu.setMnemonic('O');
			optionMenu.add("Send File for...");
			ButtonGroup mimeGroup = new ButtonGroup();
			mimeGroup.add(getDownCheck());
			mimeGroup.add(getViewCheck());
			optionMenu.add(getDownCheck());
			optionMenu.add(getViewCheck());
			optionMenu.addSeparator();
			optionMenu.add(getInfoItem());
		}
		return optionMenu;
	}

	/**
	 * Initializes buttonPanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getButtonPanel() {
		if (buttonPanel == null) {
			buttonPanel = new JPanel();
			buttonPanel.setLayout(new FlowLayout(FlowLayout.CENTER));
			buttonPanel.add(getSendButton(), null);
		}
		return buttonPanel;
	}
	
	/**
	 * Initializes sendButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getSendButton() {
		if (sendButton == null) {
			sendButton = new JButton();
			sendImg = createImageIcon("/icons/send.png", "Preference Icon");
			sendButton.setText("Send");
			sendButton.setIcon(sendImg);
			sendButton.setMnemonic('S');
			sendButton.setActionCommand("send");
			sendButton.addActionListener(this);
		}
		return sendButton;
	}

	/**
	 * Initializes Progressbar	
	 * 	
	 * @return javax.swing.JButton	
	 */
	public JProgressBar getProgressBar() {
		if (progressBar == null) {
			progressBar = new JProgressBar(0, 200);
			progressBar.setValue(0);
			progressBar.setStringPainted(true);
		}
		return progressBar;
	}

	/**
	 * Initializes the statusbar	
	 * 	
	 * @return javax.swing.JPanel
	 */
	public JPanel getStatusPanel() {
		if (statusBarPanel == null) {
			statusBarPanel = new JPanel(new GridLayout());
			statusBarPanel.setBorder(BorderFactory.createEtchedBorder());
			statusBarPanel.add(getStatusLabel());
			statusBarPanel.add(getProgressBar());
		}
		return statusBarPanel;
		
	}
	
	/**
	 * Initializes the statusbar label	
	 * 	
	 * @return javax.swing.JLabel
	 */
	public JLabel getStatusLabel() {
		if (statusLabel == null) {
			statusLabel = new JLabel();
		}
		return statusLabel;
	}
	
	/**
	 * Creates an instance of ImageIcon using the path and a description.
	 * 
	 * @param path			The path where the image is located.
	 * @param description	The image description.
	 * @return Icon 		loaded from path.
	 */
	private ImageIcon createImageIcon(String path, String description) {
		URL imgURL = getClass().getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL, description);
		} else {
			er.setMess("Couldn't find file: " + path, null);
			return null;
		}
	}

	/**
	 * Initializes infoItem	
	 * 	
	 * @return javax.swing.JMenuItem	
	 */
	private JMenuItem getInfoItem() {
		if (infoItem == null) {
			infoItem = new JMenuItem();
			infoItem.setText("Info...");
			infoItem.setActionCommand("info");
			infoItem.addActionListener(this);
			infoItem.setIcon(infoImg);
		}
		return infoItem;
	}

	/**
	 * Initializes infoFrame	
	 * 	
	 * @return javax.swing.JFrame	
	 */
	private JFrame getInfoFrame() {
		if (infoFrame == null || !infoFrame.isVisible()) {
			infoFrame = new JFrame();
			infoFrame.setContentPane(getInfoPanel());
			infoFrame.setTitle("Info");
			infoFrame.setResizable(false);
			infoFrame.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);
			infoFrame.setVisible(true);
			int width = 350;
			int height = 173;
			int x = this.getBounds().x + this.getWidth() / 2 - width / 2;
			int y = this.getBounds().y + this.getHeight() / 2 - height / 2;
			infoFrame.setBounds(x, y, width, height);
			infoFrame.setResizable(false);

		}
		return infoFrame;
	}

	/**
	 * Initializes infoCloseButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getInfoCloseButton() {
		if (infoCloseButton == null) {
			infoCloseButton = new JButton();
			infoCloseButton.setText("Close");
			infoCloseButton.setActionCommand("closeinfo");
			infoCloseButton.addActionListener(this);
			infoCloseButton.setMnemonic('C');
		}
		return infoCloseButton;
	}

	/**
	 * Initializes infoPane	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getInfoPanel() {
		JTextPane info = new JTextPane();
		String s = "F*IX (F*EX Interface Xtra) - " + versionNumber + "\r\n\r\n"
				+ "Author: \u00A9 2009 Dominik Greibl <dgreibl@gmx.de>"
				+ "\r\n\r\n"
				+ "Maintainer: Sebastian Roth <fix@fex.rus.uni-stuttgart.de>"
				+ "\r\n\r\n" + "Current User: " + use;
		info.setText(s);
		info.setEditable(false);

		if (infoPanel == null) {
			infoPanel = new JPanel();
			infoPanel.setLayout(new FlowLayout());
			infoPanel.add(info);
			infoPanel.add(getInfoCloseButton());
		}
		return infoPanel;
	}

	/**
	 * Initializes sizePanel	
	 * 	
	 * @return javax.swing.JPanel	
	 */
	private JPanel getSizePanel() {
		if (sizePanel == null) {
			sizeLabel = new JLabel();
			sizePanel = new JPanel();
			sizePanel.setLayout(new FlowLayout());
			sizePanel.add(sizeLabel, new GridBagConstraints());
		}
		return sizePanel;
	}

	/**
	 * Resets all GUI elements to its (startup) dafault.
	 */
	public void resetAllGUIElements() {
		setFileText("");
		setStatusLabel("please select a file");
		commentField.setText("");
		if (touser.equals("") || touser == null) {
			recField.setEnabled(true);
			recField.requestFocus();
		}
		else {
			recField.setText(touser);
			recField.setEnabled(false);
			fileField.requestFocus();
		}
		sendButton.setText("Send");
		sendButton.setEnabled(false);
		sendButton.setActionCommand("send");
		progressBar.setVisible(false);
		progressBar.setValue(0);
	}

	/**
	 * Updates the sizeLabel using the size of the chosen file.
	 * 
	 * @param size	Size of the chosen file.
	 */
	public void updateFileSize(double size) {
		sizeUnit = " B";
		if (size > 1024 * 1024 * 2) {
			size = size / (1024 * 1024.);
			sizeUnit = " MB";
		} else if (size > 1024 * 2) {
			size = size / 1024.;
			sizeUnit = " kB";
		}
		NumberFormat n = NumberFormat.getInstance();
		n.setMaximumFractionDigits(0);
		String sizeText = "Size: " + n.format(size) + sizeUnit;
		FontMetrics fm = getFontMetrics(sizeLabel.getFont());
		sizeLabel.setText(sizeText);
		sizeLabel.setSize(fm.stringWidth(sizeText), sizeLabel.getHeight());
		RepaintManager.currentManager(dataPanel).paintDirtyRegions();
	}

	/**
	 * Writes the file's path into the fileField and updates the filesize.
	 * 
	 * @param text
	 */
	public void setFileText(String text) {
		fileField.setText(text);
		updateFileSize(new File(text).length());
	}
	
	/**
	 * Writes the file's path into the fileField and updates the filesize.
	 * 
	 * @param text
	 */
	public void setStatusLabel(String text) {
		statusLabel.setText(text);
	}
	
	/**
	 * Checks if the text of JTextField jtf is valid.
	 * 
	 * @param jtf the JTextField
	 * @return true if text is valid, false else.
	 */
	public boolean isFieldSet(JTextField jtf) {
		return (jtf.getText() != null && jtf.getText().length() > 0);
	}

	/**
	 * Initializes downCheck	
	 * 	
	 * @return javax.swing.JRadioButtonMenuItem	
	 */
	private JRadioButtonMenuItem getDownCheck() {
		if (downCheck == null) {
			downCheck = new JRadioButtonMenuItem("Download", true);
		}
		return downCheck;
	}

	/**
	 * Initializes viewCheck	
	 * 	
	 * @return javax.swing.JRadioButtonMenuItem	
	 */
	private JRadioButtonMenuItem getViewCheck() {
		if (viewCheck == null) {
			viewCheck = new JRadioButtonMenuItem("View in Browser");
		}
		return viewCheck;
	}

}
