package fix;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;

import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JPanel;

/**
 * The Main-Class for the Applet version.
 * 
 * $Date: 2010-02-04 12:01:01 +0100 (Do, 04. Feb 2010) $
 * $Revision: 30 $
 * $Author: roth $
 * 
 * @author Dominik Greibl
 *
 * Copyright (C) 2008 Dominik Greibl
 * Copyright (C) 2009 Sebastian Roth
 * 
 * All Rights Reserved
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

public class Client extends JApplet implements ActionListener {

	private static final long serialVersionUID = 8512995562079830102L;
	private JPanel jContentPane = null;
	private JButton startButton = null;
	private String server = "";
	private String user = "";
	private String id = "";
	private String to = "";
	private String akey = "";
	private String skey = "";
	private ErrorWindow er = null;
	private boolean debug = false;

	public void actionPerformed(ActionEvent e) {
		new AppletFrame(server, user, id, to, akey, skey, er, debug);
	}

	/**
	 * Initializes startButton	
	 * 	
	 * @return javax.swing.JButton	
	 */
	private JButton getStartButton() {
		if (startButton == null) {
			ImageIcon img = createImageIcon("/icons/start.png", "Start Icon");
			startButton = new JButton("Start F*IX");
			startButton.setIcon(img);
			startButton.addActionListener(this);
		}
		return startButton;
	}

	/**
	 * @param args
	 */
	public static void main(String[] args) {
		Client m = new Client();
		if (m.getParameterInfo().length < 3) {
			System.out.println("Too few arguments.");
			m.stop();
		}

	}

	/**
	 * This is the default constructor
	 */
	public Client() {
		super();
	}

	/**
	 * Initializes this
	 * 
	 */
	public void init() {
		try {
			er = new ErrorWindow("", null, debug);
			this.setSize(150, 50);
			this.setContentPane(getJContentPane());
		} catch (Exception e) {
			this.stop();
			this.destroy();
		}
	}

	/**
	 * Initializes jContentPane
	 * 
	 * @return javax.swing.JPanel
	 */
	private JPanel getJContentPane() {
		String tmp = "";
		if (jContentPane == null) {
			server = ((tmp = getParameter("server")) != null) ? tmp : "";
			System.out.println(server);
			user = ((tmp = getParameter("user")) != null) ? tmp : "";
			System.out.println(user);
			id = ((tmp = getParameter("id")) != null) ? tmp : "";
			System.out.println(id);
			to = ((tmp = getParameter("to")) != null) ? tmp : "";
			System.out.println(to);
			akey = ((tmp = getParameter("akey")) != null) ? tmp : "";
			System.out.println(akey);
			skey = ((tmp = getParameter("skey")) != null) ? tmp : "";
			System.out.println(skey);
			//debug = (getParameter("debug") != null && getParameter("debug").equals("true"));
			debug = true;
			jContentPane = new JPanel();
			BorderLayout b = new BorderLayout();
			b.setHgap(20);
			b.setVgap(20);
			jContentPane.setLayout(b);
			jContentPane.add(getStartButton(), BorderLayout.CENTER);
		}
		return jContentPane;
	}

	/**
	 * Creates an ImageIcon from the given image at path
	 * 
	 * @param path			The path where the image is located.
	 * @param description	The image description.
	 * @return Icon 		loaded from path.
	 */
	private ImageIcon createImageIcon(String path, String description) {
		URL imgURL = getClass().getResource(path);
		if (imgURL != null) {
			return new ImageIcon(imgURL, description);
		} else {
			er.setMess("Couldn't find file: " + path, null);
			return null;
		}
	}

}
