// This code conforms with the UFC specification version 2.0.0
// and was automatically generated by FFC version 0.9.10.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      10
//   log_prefix:                     ''
//   optimize:                       False
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'auto'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __P5TET_H
#define __P5TET_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class p5tet_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  p5tet_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~p5tet_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Cell('tetrahedron', Space(3)), 5, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual unsigned int topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual unsigned int geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual unsigned int space_dimension() const
  {
    return 56;
  }

  /// Return the rank of the value space
  virtual unsigned int value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual unsigned int value_dimension(unsigned int i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point in cell
  virtual void evaluate_basis(unsigned int i,
                              double* values,
                              const double* coordinates,
                              const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Reset values.
    *values = 0.00000000;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, 0.00609788, 0.00352061, 0.00248945, 0.00705946, 0.00546824, 0.00446480, 0.00315709, 0.00257775, 0.00182275, -0.00298267, -0.00252082, -0.00218309, -0.00195262, -0.00169102, -0.00138071, -0.00112734, -0.00097631, -0.00079715, -0.00056367, 0.00278687, 0.00245779, 0.00219831, 0.00207721, 0.00185791, 0.00160900, 0.00160900, 0.00143913, 0.00124633, 0.00101762, 0.00092896, 0.00083088, 0.00071957, 0.00058752, 0.00041544, -0.00705594, -0.00638233, -0.00582625, -0.00562869, -0.00513827, -0.00459581, -0.00475711, -0.00434263, -0.00388416, -0.00336379, -0.00368484, -0.00336379, -0.00300866, -0.00260558, -0.00212744, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, -0.00609788, 0.00352061, 0.00248945, 0.00705946, -0.00546824, -0.00446480, 0.00315709, 0.00257775, 0.00182275, 0.00298267, -0.00252082, -0.00218309, 0.00195262, 0.00169102, 0.00138071, -0.00112734, -0.00097631, -0.00079715, -0.00056367, 0.00278687, -0.00245779, -0.00219831, 0.00207721, 0.00185791, 0.00160900, -0.00160900, -0.00143913, -0.00124633, -0.00101762, 0.00092896, 0.00083088, 0.00071957, 0.00058752, 0.00041544, 0.00705594, -0.00638233, -0.00582625, 0.00562869, 0.00513827, 0.00459581, -0.00475711, -0.00434263, -0.00388416, -0.00336379, 0.00368484, 0.00336379, 0.00300866, 0.00260558, 0.00212744, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, 0.00000000, -0.00704123, 0.00248945, 0.00000000, 0.00000000, 0.00000000, 0.00947126, -0.00515550, 0.00182275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00450938, -0.00292893, 0.00159431, -0.00056367, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00464479, -0.00332354, 0.00215870, -0.00117505, 0.00041544, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01276467, -0.00971041, 0.00694820, -0.00451299, 0.00245656, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, 0.00000000, 0.00000000, -0.00746835, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01093647, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00563672, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00623163, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, 0.00000000, 0.03747187, -0.02896142, 0.00000000, 0.00000000, 0.00000000, 0.02841379, 0.00515550, -0.00619733, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03156566, -0.01139028, 0.00265718, -0.00018789, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02322393, -0.00166177, -0.00647610, 0.00646276, -0.00290810, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02136290, -0.02779282, 0.02437015, -0.01572199, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, 0.00000000, -0.02875749, 0.05360943, 0.00000000, 0.00000000, 0.00000000, -0.01894253, 0.01546651, 0.01531106, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.00450938, 0.03709975, -0.02816608, 0.01089767, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02991184, -0.00431740, -0.01233800, 0.00872429, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03126692, -0.04874031, 0.04127023, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, 0.00000000, 0.04095763, -0.04498263, 0.00000000, 0.00000000, 0.00000000, 0.01894253, -0.00515550, -0.02114385, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00455611, 0.03560618, -0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03022182, 0.00411267, -0.01454048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03790913, -0.05502697, 0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, 0.00000000, -0.01481446, 0.04498263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02062201, 0.02114385, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01062871, 0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02056334, 0.01454048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03439186, -0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, 0.03245160, -0.01873594, -0.02896142, 0.02117839, -0.01640471, 0.00446480, 0.00947126, -0.00257775, -0.00619733, 0.02087872, -0.01764574, -0.00848981, 0.01366833, 0.00657618, 0.00230118, -0.00789141, -0.00379676, -0.00132859, -0.00018789, 0.01393436, -0.01228895, -0.00109916, 0.01038606, 0.00092896, -0.00482700, -0.00804500, -0.00071957, 0.00373898, 0.00559692, 0.00464479, 0.00041544, -0.00215870, -0.00323138, -0.00290810, 0.00000000, 0.00000000, 0.01281774, 0.00000000, -0.01130419, -0.01838322, 0.00000000, 0.00955378, 0.01553666, 0.01816444, 0.00000000, -0.00740033, -0.01203464, -0.01407011, -0.01361564, 0.00000000, 0.00427258, 0.00694820, 0.00812338, 0.00786100, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, -0.02490471, 0.01437874, 0.05360943, -0.01411892, 0.01093647, 0.01339439, -0.00631418, -0.00773325, 0.01531106, -0.00298267, 0.00252082, 0.02765252, -0.00195262, -0.02141955, -0.02439254, 0.00112734, 0.01236658, 0.01408304, 0.01089767, 0.00000000, 0.00000000, 0.01978482, 0.00000000, -0.01672123, -0.00321800, 0.00000000, 0.01295221, 0.00249265, -0.01068503, 0.00000000, -0.00747796, -0.00143913, 0.00616900, 0.00872429, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02068112, 0.00000000, 0.00000000, -0.01747874, -0.03632888, 0.00000000, 0.00000000, 0.01353897, 0.02814023, 0.03574107, 0.00000000, 0.00000000, -0.00781673, -0.01624677, -0.02063512, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, 0.03547035, -0.02047882, -0.04498263, 0.01411892, -0.01093647, -0.00446480, 0.00631418, 0.00257775, -0.02114385, 0.00000000, 0.00000000, 0.00339592, 0.00000000, -0.00263047, 0.03083585, 0.00000000, 0.00151870, -0.01780309, -0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02252601, 0.00000000, 0.00000000, -0.01744857, 0.00356168, 0.00000000, 0.00000000, 0.01007394, -0.00205633, -0.01454048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02825580, 0.00000000, 0.00000000, 0.00000000, -0.02188684, -0.04765476, 0.00000000, 0.00000000, 0.00000000, 0.01263638, 0.02751349, 0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, -0.01282970, 0.00740723, 0.04498263, 0.00000000, 0.00000000, 0.01785918, 0.00000000, -0.01031100, 0.02114385, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00920473, 0.00000000, 0.00000000, -0.00531435, 0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01780838, 0.00000000, 0.00000000, 0.00000000, -0.01028167, 0.01454048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02978422, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.01719593, -0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 12:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, 0.03245160, -0.03355040, -0.00801061, 0.02117839, 0.00109365, -0.01696622, -0.00568276, 0.00567105, 0.00838463, 0.02087872, -0.01092355, -0.01625192, 0.00499003, 0.00958243, 0.01089227, -0.00187891, -0.00466459, -0.00558007, -0.00469727, 0.01393436, -0.00245779, -0.01209072, -0.00415442, 0.00464479, 0.00965400, 0.00643600, -0.00071957, -0.00498531, -0.00661454, -0.00464479, -0.00041544, 0.00215870, 0.00323138, 0.00290810, 0.00000000, 0.01276467, -0.00116525, -0.02026328, -0.00719357, 0.00183832, 0.02283413, 0.01129083, 0.00310733, -0.00201827, -0.02063512, -0.01143687, -0.00481386, -0.00052112, 0.00170196, 0.01276467, 0.00737991, 0.00347410, 0.00090260, -0.00049131, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 13:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, -0.02490471, 0.05533637, -0.00431340, -0.01411892, 0.01531106, 0.00803663, 0.00883985, -0.01598206, 0.00072910, -0.00298267, 0.02772902, -0.00145540, -0.03015711, -0.01164923, 0.00352848, 0.01916486, 0.00976309, 0.00132859, -0.00263047, 0.00000000, 0.01966231, -0.00219831, -0.00727024, -0.01486331, 0.00402250, -0.00724050, 0.01295221, 0.00685480, -0.00457930, 0.00928957, -0.00664708, -0.00575654, -0.00029376, 0.00290810, 0.00000000, 0.00000000, 0.00000000, 0.02026328, -0.00411061, 0.00045958, -0.03995973, -0.00303984, 0.00427258, -0.00100914, 0.04642901, 0.00908222, -0.00270779, -0.00234502, 0.00127647, -0.03191167, -0.00776833, 0.00086853, 0.00180520, 0.00024566, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 14:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, 0.03547035, -0.04923630, -0.00431340, 0.01411892, -0.00656188, -0.00982255, -0.01641686, 0.01495096, 0.00072910, 0.00000000, 0.00336109, -0.00048513, 0.02820449, -0.01240079, 0.00291483, -0.03532347, 0.00889526, 0.00239146, -0.00263047, 0.00000000, 0.00000000, 0.00000000, 0.02181072, -0.00557374, 0.00080450, -0.00402250, -0.01439134, 0.00934745, -0.00254405, -0.00928957, 0.01412504, -0.00287827, -0.00381891, 0.00290810, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02663982, -0.00911952, 0.00233050, -0.00033638, -0.05158779, 0.00840946, 0.00300866, -0.00286613, 0.00085098, 0.04254889, -0.00388416, -0.00347410, 0.00120346, 0.00098262, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 15:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, -0.01282970, 0.04487911, -0.00801061, 0.00000000, 0.01749836, -0.00357184, 0.01325977, -0.01752871, 0.00838463, 0.00000000, 0.00000000, 0.00000000, 0.00867830, -0.00300625, 0.00061365, 0.02254690, -0.01920075, 0.01222302, -0.00469727, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01609001, -0.00719567, 0.00249265, -0.00050881, 0.00464479, -0.01080150, 0.01079351, -0.00734405, 0.00290810, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02579389, -0.01345514, 0.00601732, -0.00208446, 0.00042549, -0.03191167, 0.01359458, -0.00347410, -0.00090260, 0.00171959, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 16:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, -0.03245160, -0.01873594, -0.02896142, 0.02117839, 0.01640471, -0.00446480, 0.00947126, -0.00257775, -0.00619733, -0.02087872, -0.01764574, -0.00848981, -0.01366833, -0.00657618, -0.00230118, -0.00789141, -0.00379676, -0.00132859, -0.00018789, 0.01393436, 0.01228895, 0.00109916, 0.01038606, 0.00092896, -0.00482700, 0.00804500, 0.00071957, -0.00373898, -0.00559692, 0.00464479, 0.00041544, -0.00215870, -0.00323138, -0.00290810, 0.00000000, 0.00000000, 0.01281774, 0.00000000, 0.01130419, 0.01838322, 0.00000000, 0.00955378, 0.01553666, 0.01816444, 0.00000000, 0.00740033, 0.01203464, 0.01407011, 0.01361564, 0.00000000, 0.00427258, 0.00694820, 0.00812338, 0.00786100, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 17:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, 0.02490471, 0.01437874, 0.05360943, -0.01411892, -0.01093647, -0.01339439, -0.00631418, -0.00773325, 0.01531106, 0.00298267, 0.00252082, 0.02765252, 0.00195262, 0.02141955, 0.02439254, 0.00112734, 0.01236658, 0.01408304, 0.01089767, 0.00000000, 0.00000000, -0.01978482, 0.00000000, -0.01672123, -0.00321800, 0.00000000, -0.01295221, -0.00249265, 0.01068503, 0.00000000, -0.00747796, -0.00143913, 0.00616900, 0.00872429, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.02068112, 0.00000000, 0.00000000, -0.01747874, -0.03632888, 0.00000000, 0.00000000, -0.01353897, -0.02814023, -0.03574107, 0.00000000, 0.00000000, -0.00781673, -0.01624677, -0.02063512, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 18:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, -0.03547035, -0.02047882, -0.04498263, 0.01411892, 0.01093647, 0.00446480, 0.00631418, 0.00257775, -0.02114385, 0.00000000, 0.00000000, 0.00339592, 0.00000000, 0.00263047, -0.03083585, 0.00000000, 0.00151870, -0.01780309, -0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02252601, 0.00000000, 0.00000000, 0.01744857, -0.00356168, 0.00000000, 0.00000000, 0.01007394, -0.00205633, -0.01454048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02825580, 0.00000000, 0.00000000, 0.00000000, 0.02188684, 0.04765476, 0.00000000, 0.00000000, 0.00000000, 0.01263638, 0.02751349, 0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 19:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, 0.01282970, 0.00740723, 0.04498263, 0.00000000, 0.00000000, -0.01785918, 0.00000000, -0.01031100, 0.02114385, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.00920473, 0.00000000, 0.00000000, -0.00531435, 0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.01780838, 0.00000000, 0.00000000, 0.00000000, -0.01028167, 0.01454048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.02978422, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.01719593, -0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 20:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, -0.03245160, -0.03355040, -0.00801061, 0.02117839, -0.00109365, 0.01696622, -0.00568276, 0.00567105, 0.00838463, -0.02087872, -0.01092355, -0.01625192, -0.00499003, -0.00958243, -0.01089227, -0.00187891, -0.00466459, -0.00558007, -0.00469727, 0.01393436, 0.00245779, 0.01209072, -0.00415442, 0.00464479, 0.00965400, -0.00643600, 0.00071957, 0.00498531, 0.00661454, -0.00464479, -0.00041544, 0.00215870, 0.00323138, 0.00290810, 0.00000000, 0.01276467, -0.00116525, 0.02026328, 0.00719357, -0.00183832, 0.02283413, 0.01129083, 0.00310733, -0.00201827, 0.02063512, 0.01143687, 0.00481386, 0.00052112, -0.00170196, 0.01276467, 0.00737991, 0.00347410, 0.00090260, -0.00049131, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 21:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, 0.02490471, 0.05533637, -0.00431340, -0.01411892, -0.01531106, -0.00803663, 0.00883985, -0.01598206, 0.00072910, 0.00298267, 0.02772902, -0.00145540, 0.03015711, 0.01164923, -0.00352848, 0.01916486, 0.00976309, 0.00132859, -0.00263047, 0.00000000, -0.01966231, 0.00219831, -0.00727024, -0.01486331, 0.00402250, 0.00724050, -0.01295221, -0.00685480, 0.00457930, 0.00928957, -0.00664708, -0.00575654, -0.00029376, 0.00290810, 0.00000000, 0.00000000, 0.00000000, -0.02026328, 0.00411061, -0.00045958, -0.03995973, -0.00303984, 0.00427258, -0.00100914, -0.04642901, -0.00908222, 0.00270779, 0.00234502, -0.00127647, -0.03191167, -0.00776833, 0.00086853, 0.00180520, 0.00024566, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 22:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, -0.03547035, -0.04923630, -0.00431340, 0.01411892, 0.00656188, 0.00982255, -0.01641686, 0.01495096, 0.00072910, 0.00000000, 0.00336109, -0.00048513, -0.02820449, 0.01240079, -0.00291483, -0.03532347, 0.00889526, 0.00239146, -0.00263047, 0.00000000, 0.00000000, 0.00000000, 0.02181072, -0.00557374, 0.00080450, 0.00402250, 0.01439134, -0.00934745, 0.00254405, -0.00928957, 0.01412504, -0.00287827, -0.00381891, 0.00290810, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02663982, -0.00911952, 0.00233050, -0.00033638, 0.05158779, -0.00840946, -0.00300866, 0.00286613, -0.00085098, 0.04254889, -0.00388416, -0.00347410, 0.00120346, 0.00098262, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 23:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, 0.01282970, 0.04487911, -0.00801061, 0.00000000, -0.01749836, 0.00357184, 0.01325977, -0.01752871, 0.00838463, 0.00000000, 0.00000000, 0.00000000, -0.00867830, 0.00300625, -0.00061365, 0.02254690, -0.01920075, 0.01222302, -0.00469727, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.01609001, 0.00719567, -0.00249265, 0.00050881, 0.00464479, -0.01080150, 0.01079351, -0.00734405, 0.00290810, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.02579389, 0.01345514, -0.00601732, 0.00208446, -0.00042549, -0.03191167, 0.01359458, -0.00347410, -0.00090260, 0.00171959, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 24:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, -0.04528130, -0.01132871, -0.00801061, -0.00141189, 0.01640471, 0.01339439, 0.01452260, 0.01185766, 0.00838463, -0.00894802, -0.01428465, -0.01237087, -0.01453616, -0.01258868, -0.01027862, -0.00939454, -0.00813591, -0.00664294, -0.00469727, -0.00836061, 0.00245779, 0.00219831, 0.00830884, 0.00743166, 0.00643600, 0.00965400, 0.00863480, 0.00747796, 0.00610573, 0.00650270, 0.00581619, 0.00503697, 0.00411267, 0.00290810, 0.03527968, 0.01914700, 0.01747874, 0.00788016, 0.00719357, 0.00643413, 0.00095142, 0.00086853, 0.00077683, 0.00067276, -0.00221091, -0.00201827, -0.00180520, -0.00156335, -0.00127647, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 25:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, 0.06037506, -0.00610007, -0.00431340, -0.00564757, -0.02187294, -0.01785918, 0.00126284, 0.00103110, 0.00072910, 0.04175744, 0.01680547, 0.01455396, -0.00086783, -0.00075156, -0.00061365, -0.00526094, -0.00455611, -0.00372005, -0.00263047, 0.00557374, -0.01966231, -0.01758651, -0.01038606, -0.00928957, -0.00804500, 0.00321800, 0.00287827, 0.00249265, 0.00203524, 0.00650270, 0.00581619, 0.00503697, 0.00411267, 0.00290810, -0.07055935, -0.01276467, -0.01165249, 0.00450295, 0.00411061, 0.00367664, 0.00380569, 0.00347410, 0.00310733, 0.00269103, -0.00073697, -0.00067276, -0.00060173, -0.00052112, -0.00042549, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 26:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.01002344, -0.06037506, -0.00610007, -0.00431340, -0.00564757, 0.02187294, 0.01785918, 0.00126284, 0.00103110, 0.00072910, -0.04175744, 0.01680547, 0.01455396, 0.00086783, 0.00075156, 0.00061365, -0.00526094, -0.00455611, -0.00372005, -0.00263047, 0.00557374, 0.01966231, 0.01758651, -0.01038606, -0.00928957, -0.00804500, -0.00321800, -0.00287827, -0.00249265, -0.00203524, 0.00650270, 0.00581619, 0.00503697, 0.00411267, 0.00290810, 0.07055935, -0.01276467, -0.01165249, -0.00450295, -0.00411061, -0.00367664, 0.00380569, 0.00347410, 0.00310733, 0.00269103, 0.00073697, 0.00067276, 0.00060173, 0.00052112, 0.00042549, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 27:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.01002344, 0.04528130, -0.01132871, -0.00801061, -0.00141189, -0.01640471, -0.01339439, 0.01452260, 0.01185766, 0.00838463, 0.00894802, -0.01428465, -0.01237087, 0.01453616, 0.01258868, 0.01027862, -0.00939454, -0.00813591, -0.00664294, -0.00469727, -0.00836061, -0.00245779, -0.00219831, 0.00830884, 0.00743166, 0.00643600, -0.00965400, -0.00863480, -0.00747796, -0.00610573, 0.00650270, 0.00581619, 0.00503697, 0.00411267, 0.00290810, -0.03527968, 0.01914700, 0.01747874, -0.00788016, -0.00719357, -0.00643413, 0.00095142, 0.00086853, 0.00077683, 0.00067276, 0.00221091, 0.00201827, 0.00180520, 0.00156335, 0.00127647, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 28:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, 0.06792194, -0.00435719, -0.00308100, 0.07059462, -0.03280942, -0.02678878, 0.01262835, 0.03608852, -0.00729098, 0.02982674, 0.01512492, 0.01309856, -0.03254364, -0.02292268, -0.02485278, 0.02480159, 0.01692269, 0.01647450, 0.01427970, 0.00000000, 0.02457789, 0.02198314, -0.03635119, -0.00743166, -0.03459352, 0.03620252, 0.00000000, 0.01308643, 0.03358151, -0.02322393, 0.00166177, -0.00359784, -0.01468810, -0.01786402, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02260837, -0.00459581, 0.00000000, -0.03343824, -0.01942082, 0.00908222, 0.00000000, 0.03330147, 0.02707795, 0.00703506, -0.01021173, 0.00000000, -0.02136290, -0.01910756, -0.00812338, 0.00196525, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 29:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, 0.00377344, 0.00217860, -0.02156701, 0.00000000, 0.09842825, -0.03125357, -0.08524136, -0.01804426, 0.03098667, 0.00000000, 0.04537476, -0.01164317, 0.00000000, 0.02367424, -0.00138071, -0.02029221, -0.03351995, -0.00079715, 0.00394571, 0.00000000, 0.00000000, 0.00000000, 0.03635119, 0.02415288, -0.00724050, -0.06033753, 0.00000000, -0.03925929, 0.01882600, 0.04644785, -0.01080150, 0.02590441, 0.01086919, -0.01786402, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03343824, -0.01553666, 0.00302741, 0.00000000, -0.05550245, 0.00000000, 0.01641513, -0.00680782, 0.00000000, 0.04272581, 0.00694820, -0.01083118, -0.00393050, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 30:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, 0.03018753, 0.06100073, -0.00308100, 0.00000000, 0.02187294, 0.01785918, 0.07577010, -0.04124402, -0.00729098, 0.00000000, 0.00000000, 0.00000000, 0.05206983, -0.01277658, 0.00184095, -0.00901876, 0.02863841, -0.02976039, 0.01427970, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04022502, 0.01439134, -0.01370959, 0.00407049, -0.04644785, 0.01827946, -0.03453922, 0.03642649, -0.01786402, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03700164, -0.03008661, 0.01407011, -0.00340391, 0.00000000, -0.04272581, 0.02431872, 0.00000000, -0.00982625, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 31:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, 0.00377344, -0.01960738, 0.00924301, 0.00000000, -0.01093647, 0.10269031, 0.00947126, -0.06959928, -0.06015060, 0.00000000, -0.00504164, 0.04657267, 0.00650873, 0.02141955, -0.00782402, -0.00450938, -0.02896384, -0.02630606, 0.00056367, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03344245, 0.02896201, 0.00000000, -0.04317402, -0.00249265, -0.06054848, 0.00000000, 0.02991184, -0.00431740, 0.01850701, 0.04611409, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03495748, -0.01210963, 0.00000000, 0.00000000, -0.04512991, -0.02814023, 0.02382738, 0.00000000, 0.00000000, 0.03126692, 0.02707795, 0.00000000, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 32:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, -0.01509377, 0.01307158, 0.00924301, 0.00000000, -0.01093647, -0.00892959, 0.00947126, 0.12373206, -0.06015060, 0.00000000, 0.00000000, 0.00000000, -0.00650873, 0.05749459, -0.02669372, 0.00676407, 0.01269202, 0.00637723, 0.00056367, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04317402, 0.01994123, -0.01424670, 0.00000000, -0.04486776, 0.02158701, -0.06169002, 0.04611409, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04512991, -0.03752031, 0.01191369, 0.00000000, 0.00000000, -0.04690038, 0.01624677, 0.02063512, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 33:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, 0.03018753, 0.01742878, 0.05853904, 0.00000000, 0.02187294, 0.01785918, -0.01894253, 0.01031100, 0.08384629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00526094, 0.05338745, 0.00000000, -0.00455611, 0.03082326, -0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03489715, 0.02849340, 0.00000000, 0.00000000, -0.03022182, 0.01645067, -0.06439354, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04377369, -0.02382738, 0.00000000, 0.00000000, 0.00000000, -0.03790913, -0.01375674, 0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 34:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, -0.06792194, -0.00435719, -0.00308100, 0.07059462, 0.03280942, 0.02678878, 0.01262835, 0.03608852, -0.00729098, -0.02982674, 0.01512492, 0.01309856, 0.03254364, 0.02292268, 0.02485278, 0.02480159, 0.01692269, 0.01647450, 0.01427970, 0.00000000, -0.02457789, -0.02198314, -0.03635119, -0.00743166, -0.03459352, -0.03620252, 0.00000000, -0.01308643, -0.03358151, -0.02322393, 0.00166177, -0.00359784, -0.01468810, -0.01786402, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.02260837, 0.00459581, 0.00000000, -0.03343824, -0.01942082, 0.00908222, 0.00000000, -0.03330147, -0.02707795, -0.00703506, 0.01021173, 0.00000000, -0.02136290, -0.01910756, -0.00812338, 0.00196525, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 35:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, -0.00377344, 0.00217860, -0.02156701, 0.00000000, -0.09842825, 0.03125357, -0.08524136, -0.01804426, 0.03098667, 0.00000000, 0.04537476, -0.01164317, 0.00000000, -0.02367424, 0.00138071, -0.02029221, -0.03351995, -0.00079715, 0.00394571, 0.00000000, 0.00000000, 0.00000000, 0.03635119, 0.02415288, -0.00724050, 0.06033753, 0.00000000, 0.03925929, -0.01882600, 0.04644785, -0.01080150, 0.02590441, 0.01086919, -0.01786402, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03343824, -0.01553666, 0.00302741, 0.00000000, 0.05550245, 0.00000000, -0.01641513, 0.00680782, 0.00000000, 0.04272581, 0.00694820, -0.01083118, -0.00393050, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 36:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, -0.03018753, 0.06100073, -0.00308100, 0.00000000, -0.02187294, -0.01785918, 0.07577010, -0.04124402, -0.00729098, 0.00000000, 0.00000000, 0.00000000, -0.05206983, 0.01277658, -0.00184095, -0.00901876, 0.02863841, -0.02976039, 0.01427970, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.04022502, -0.01439134, 0.01370959, -0.00407049, -0.04644785, 0.01827946, -0.03453922, 0.03642649, -0.01786402, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.03700164, 0.03008661, -0.01407011, 0.00340391, 0.00000000, -0.04272581, 0.02431872, 0.00000000, -0.00982625, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 37:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, -0.00377344, -0.01960738, 0.00924301, 0.00000000, 0.01093647, -0.10269031, 0.00947126, -0.06959928, -0.06015060, 0.00000000, -0.00504164, 0.04657267, -0.00650873, -0.02141955, 0.00782402, -0.00450938, -0.02896384, -0.02630606, 0.00056367, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03344245, 0.02896201, 0.00000000, 0.04317402, 0.00249265, 0.06054848, 0.00000000, 0.02991184, -0.00431740, 0.01850701, 0.04611409, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03495748, -0.01210963, 0.00000000, 0.00000000, 0.04512991, 0.02814023, -0.02382738, 0.00000000, 0.00000000, 0.03126692, 0.02707795, 0.00000000, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 38:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, 0.01509377, 0.01307158, 0.00924301, 0.00000000, 0.01093647, 0.00892959, 0.00947126, 0.12373206, -0.06015060, 0.00000000, 0.00000000, 0.00000000, 0.00650873, -0.05749459, 0.02669372, 0.00676407, 0.01269202, 0.00637723, 0.00056367, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.04317402, -0.01994123, 0.01424670, 0.00000000, -0.04486776, 0.02158701, -0.06169002, 0.04611409, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.04512991, 0.03752031, -0.01191369, 0.00000000, 0.00000000, -0.04690038, 0.01624677, 0.02063512, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 39:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, -0.03018753, 0.01742878, 0.05853904, 0.00000000, -0.02187294, -0.01785918, -0.01894253, 0.01031100, 0.08384629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.00526094, -0.05338745, 0.00000000, -0.00455611, 0.03082326, -0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.03489715, -0.02849340, 0.00000000, 0.00000000, -0.03022182, 0.01645067, -0.06439354, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.04377369, 0.02382738, 0.00000000, 0.00000000, 0.00000000, -0.03790913, -0.01375674, 0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 40:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, -0.03773441, -0.05664353, -0.00308100, 0.04235677, 0.05468236, 0.04464796, 0.03788505, 0.00515550, -0.00729098, 0.04175744, -0.00504164, 0.02959305, -0.02473317, 0.01014610, 0.02669372, -0.02029221, 0.00216958, 0.01328589, 0.01427970, -0.05573742, -0.02457789, -0.00219831, -0.00519303, -0.01300540, -0.01689451, 0.00402250, -0.01583047, -0.02679602, -0.02951102, 0.00464479, -0.01080150, -0.01942831, -0.02173839, -0.01786402, 0.00000000, 0.00000000, -0.05127097, 0.00000000, -0.02260837, -0.03676644, 0.00000000, -0.00477689, -0.00776833, -0.00908222, 0.00000000, 0.00370016, 0.00601732, 0.00703506, 0.00680782, 0.00000000, 0.00427258, 0.00694820, 0.00812338, 0.00786100, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 41:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, 0.00000000, -0.00435719, -0.02156701, -0.12707032, 0.00000000, 0.00000000, 0.02841379, 0.03608852, 0.03098667, 0.00000000, 0.04537476, -0.04220648, 0.00000000, 0.00000000, 0.00000000, -0.02029221, -0.00618329, 0.00159431, 0.00394571, 0.08360613, 0.00000000, 0.00000000, -0.01038606, 0.02415288, 0.04344302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00464479, -0.01080150, -0.01942831, -0.02173839, -0.01786402, 0.00000000, 0.00000000, 0.07690646, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.00955378, -0.01553666, -0.01816444, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00427258, 0.00694820, 0.00812338, 0.00786100, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 42:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, 0.03773441, -0.05664353, -0.00308100, 0.04235677, -0.05468236, -0.04464796, 0.03788505, 0.00515550, -0.00729098, -0.04175744, -0.00504164, 0.02959305, 0.02473317, -0.01014610, -0.02669372, -0.02029221, 0.00216958, 0.01328589, 0.01427970, -0.05573742, 0.02457789, 0.00219831, -0.00519303, -0.01300540, -0.01689451, -0.00402250, 0.01583047, 0.02679602, 0.02951102, 0.00464479, -0.01080150, -0.01942831, -0.02173839, -0.01786402, 0.00000000, 0.00000000, -0.05127097, 0.00000000, 0.02260837, 0.03676644, 0.00000000, -0.00477689, -0.00776833, -0.00908222, 0.00000000, -0.00370016, -0.00601732, -0.00703506, -0.00680782, 0.00000000, 0.00427258, 0.00694820, 0.00812338, 0.00786100, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 43:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, -0.01886721, 0.00653579, 0.00924301, 0.01411892, 0.00000000, -0.11161990, -0.00315709, -0.05413277, -0.06015060, -0.00894802, -0.00252082, -0.02765252, 0.00065087, 0.03607504, -0.01886970, 0.00112734, 0.03742519, 0.01992883, 0.00056367, 0.00000000, 0.00000000, 0.05935447, 0.00000000, 0.01672123, 0.00321800, 0.00000000, -0.00431740, 0.02243388, 0.04630178, 0.00000000, -0.00747796, 0.01870874, 0.04318302, 0.04611409, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06204337, 0.00000000, 0.00000000, 0.01747874, 0.03632888, 0.00000000, 0.00000000, -0.00451299, -0.00938008, -0.01191369, 0.00000000, 0.00000000, -0.00781673, -0.01624677, -0.02063512, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 44:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, 0.01886721, 0.00653579, 0.00924301, 0.01411892, 0.00000000, 0.11161990, -0.00315709, -0.05413277, -0.06015060, 0.00894802, -0.00252082, -0.02765252, -0.00065087, -0.03607504, 0.01886970, 0.00112734, 0.03742519, 0.01992883, 0.00056367, 0.00000000, 0.00000000, -0.05935447, 0.00000000, 0.01672123, 0.00321800, 0.00000000, 0.00431740, -0.02243388, -0.04630178, 0.00000000, -0.00747796, 0.01870874, 0.04318302, 0.04611409, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06204337, 0.00000000, 0.00000000, 0.01747874, 0.03632888, 0.00000000, 0.00000000, 0.00451299, 0.00938008, 0.01191369, 0.00000000, 0.00000000, -0.00781673, -0.01624677, -0.02063512, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 45:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, 0.00000000, -0.03485756, 0.05853904, -0.02823785, 0.00000000, 0.00000000, 0.00631418, -0.02062201, 0.08384629, 0.00000000, 0.00000000, -0.00679185, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00151870, -0.06164651, -0.03194144, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.04505202, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01007394, -0.03290135, -0.06439354, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.05651159, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01263638, 0.02751349, 0.03039840};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 46:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, -0.03773441, -0.02178597, -0.05237703, 0.04235677, 0.05468236, 0.04464796, 0.00000000, 0.02577751, 0.02916393, 0.04175744, 0.02856929, -0.00921751, 0.02733666, -0.00789141, -0.02485278, 0.01878908, -0.00347132, -0.01434876, -0.01503127, -0.05573742, -0.00491558, -0.02418145, -0.01973351, -0.00928957, -0.00241350, -0.03942052, -0.01583047, -0.00062316, 0.00712335, -0.03251350, -0.01412504, -0.00215870, 0.00411267, 0.00540075, 0.00000000, -0.05105867, 0.00466100, -0.04052656, -0.01438715, 0.00367664, -0.01141707, -0.00564542, -0.00155367, 0.00100914, 0.01031756, 0.00571843, 0.00240693, 0.00026056, -0.00085098, 0.01276467, 0.00737991, 0.00347410, 0.00090260, -0.00049131, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 47:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, 0.00000000, -0.02178597, 0.00308100, -0.12707032, 0.00000000, 0.00000000, 0.04735631, 0.02577751, 0.01275922, 0.00000000, -0.03529148, 0.05093886, 0.00000000, 0.00000000, 0.00000000, 0.00225469, -0.00943766, -0.01434876, -0.01296447, 0.08360613, 0.00000000, 0.00000000, 0.04777586, 0.00928957, -0.01448101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.03251350, -0.01412504, -0.00215870, 0.00411267, 0.00540075, 0.00000000, 0.07658800, -0.00699150, 0.00000000, 0.00000000, 0.00000000, -0.02283413, -0.01129083, -0.00310733, 0.00201827, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01276467, 0.00737991, 0.00347410, 0.00090260, -0.00049131, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 48:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, 0.03773441, -0.02178597, -0.05237703, 0.04235677, -0.05468236, -0.04464796, 0.00000000, 0.02577751, 0.02916393, -0.04175744, 0.02856929, -0.00921751, -0.02733666, 0.00789141, 0.02485278, 0.01878908, -0.00347132, -0.01434876, -0.01503127, -0.05573742, 0.00491558, 0.02418145, -0.01973351, -0.00928957, -0.00241350, 0.03942052, 0.01583047, 0.00062316, -0.00712335, -0.03251350, -0.01412504, -0.00215870, 0.00411267, 0.00540075, 0.00000000, -0.05105867, 0.00466100, 0.04052656, 0.01438715, -0.00367664, -0.01141707, -0.00564542, -0.00155367, 0.00100914, -0.01031756, -0.00571843, -0.00240693, -0.00026056, 0.00085098, 0.01276467, 0.00737991, 0.00347410, 0.00090260, -0.00049131, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 49:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, -0.01886721, 0.01089299, 0.00308100, 0.01411892, -0.10936472, 0.02232398, -0.07892719, -0.01288876, 0.01275922, -0.00894802, -0.02772902, 0.00145540, -0.00585786, 0.03832973, -0.01242639, 0.01916486, 0.03482170, 0.00717438, -0.01296447, 0.00000000, 0.05898694, -0.00659494, 0.00727024, 0.01486331, -0.00402250, 0.05068353, -0.00431740, -0.00810112, 0.00356168, 0.06502699, -0.00166177, -0.01151307, -0.00205633, 0.00540075, 0.00000000, 0.00000000, 0.00000000, 0.06078984, -0.01233184, 0.00137874, 0.03995973, 0.00303984, -0.00427258, 0.00100914, -0.01547634, -0.00302741, 0.00090260, 0.00078167, -0.00042549, -0.03191167, -0.00776833, 0.00086853, 0.00180520, 0.00024566, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 50:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {-0.02147880, 0.01886721, 0.01089299, 0.00308100, 0.01411892, 0.10936472, -0.02232398, -0.07892719, -0.01288876, 0.01275922, 0.00894802, -0.02772902, 0.00145540, 0.00585786, -0.03832973, 0.01242639, 0.01916486, 0.03482170, 0.00717438, -0.01296447, 0.00000000, -0.05898694, 0.00659494, 0.00727024, 0.01486331, -0.00402250, -0.05068353, 0.00431740, 0.00810112, -0.00356168, 0.06502699, -0.00166177, -0.01151307, -0.00205633, 0.00540075, 0.00000000, 0.00000000, 0.00000000, -0.06078984, 0.01233184, -0.00137874, 0.03995973, 0.00303984, -0.00427258, 0.00100914, 0.01547634, 0.00302741, -0.00090260, -0.00078167, 0.00042549, -0.03191167, -0.00776833, 0.00086853, 0.00180520, 0.00024566, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 51:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.07875562, 0.00000000, 0.04357195, -0.05237703, -0.02823785, 0.00000000, 0.00000000, 0.06314175, -0.05155502, 0.02916393, 0.00000000, -0.00672219, 0.00097026, 0.00000000, 0.00000000, 0.00000000, -0.06012506, -0.01258354, 0.02869752, -0.01503127, 0.00000000, 0.00000000, 0.00000000, -0.04362143, 0.01114748, -0.00160900, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06502699, 0.03157361, -0.00287827, -0.00822534, 0.00540075, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.05327964, 0.01823904, -0.00466100, 0.00067276, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04254889, -0.00388416, -0.00347410, 0.00120346, 0.00098262, -0.00086853};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 52:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, -0.18867207, -0.10892987, -0.07702505, -0.07059462, -0.05468236, -0.04464796, -0.03157088, -0.02577751, -0.01822745, 0.08948023, -0.01512492, -0.01309856, 0.05857856, -0.02818362, 0.06903549, 0.07440476, 0.00976309, 0.03985766, 0.05974928, 0.00000000, 0.07373368, 0.06594941, 0.03635119, 0.00743166, 0.03459352, -0.01206751, 0.04317402, 0.01557908, -0.02544054, -0.02322393, 0.04652953, 0.02518485, -0.01468810, -0.03281994, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06782512, -0.01378742, 0.00000000, 0.03343824, 0.01942082, -0.00908222, 0.00000000, -0.01110049, -0.00902598, -0.00234502, 0.00340391, 0.00000000, -0.02136290, -0.01910756, -0.00812338, 0.00196525, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 53:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, 0.18867207, -0.10892987, -0.07702505, -0.07059462, 0.05468236, 0.04464796, -0.03157088, -0.02577751, -0.01822745, -0.08948023, -0.01512492, -0.01309856, -0.05857856, 0.02818362, -0.06903549, 0.07440476, 0.00976309, 0.03985766, 0.05974928, 0.00000000, -0.07373368, -0.06594941, 0.03635119, 0.00743166, 0.03459352, 0.01206751, -0.04317402, -0.01557908, 0.02544054, -0.02322393, 0.04652953, 0.02518485, -0.01468810, -0.03281994, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06782512, 0.01378742, 0.00000000, 0.03343824, 0.01942082, -0.00908222, 0.00000000, 0.01110049, 0.00902598, 0.00234502, -0.00340391, 0.00000000, -0.02136290, -0.01910756, -0.00812338, 0.00196525, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 54:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, 0.00000000, 0.21785974, -0.07702505, 0.00000000, 0.00000000, 0.00000000, -0.09471263, 0.05155502, -0.01822745, 0.00000000, -0.09074951, 0.02328634, 0.00000000, 0.00000000, 0.00000000, -0.09469697, -0.02278055, -0.07971532, 0.05974928, 0.00000000, 0.00000000, 0.00000000, -0.07270239, -0.04830577, 0.01448101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04644785, -0.07810314, 0.04317402, 0.02937620, -0.03281994, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06687647, 0.03107332, -0.00605481, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.04272581, 0.00694820, -0.01083118, -0.00393050, 0.00607968};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 55:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.10739402, 0.00000000, 0.00000000, 0.23107515, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.10936472, 0.00000000, 0.01008328, -0.09314534, 0.00000000, 0.00000000, 0.00000000, -0.00450938, -0.10413966, 0.00000000, -0.09244228, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06688491, -0.05792403, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.02991184, -0.06476103, 0.00000000, 0.08350389, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -0.06991496, 0.02421925, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.03126692, 0.02707795, 0.00000000, -0.01823904};
      
      // Compute value(s).
      for (unsigned int r = 0; r < 56; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* coordinates,
                                  const ufc::cell& c) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.00000000;
    
    // Loop dofs and call evaluate_basis.
    for (unsigned int r = 0; r < 56; r++)
    {
      evaluate_basis(r, &dof_values, coordinates, c);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point in cell
  virtual void evaluate_basis_derivatives(unsigned int i,
                                          unsigned int n,
                                          double* values,
                                          const double* coordinates,
                                          const ufc::cell& c) const
  {
    // Extract vertex coordinates
    const double * const * x = c.coordinates;
    
    // Compute Jacobian of affine map from reference cell
    const double J_00 = x[1][0] - x[0][0];
    const double J_01 = x[2][0] - x[0][0];
    const double J_02 = x[3][0] - x[0][0];
    const double J_10 = x[1][1] - x[0][1];
    const double J_11 = x[2][1] - x[0][1];
    const double J_12 = x[3][1] - x[0][1];
    const double J_20 = x[1][2] - x[0][2];
    const double J_21 = x[2][2] - x[0][2];
    const double J_22 = x[3][2] - x[0][2];
    
    // Compute sub determinants
    const double d_00 = J_11*J_22 - J_12*J_21;
    const double d_01 = J_12*J_20 - J_10*J_22;
    const double d_02 = J_10*J_21 - J_11*J_20;
    const double d_10 = J_02*J_21 - J_01*J_22;
    const double d_11 = J_00*J_22 - J_02*J_20;
    const double d_12 = J_01*J_20 - J_00*J_21;
    const double d_20 = J_01*J_12 - J_02*J_11;
    const double d_21 = J_02*J_10 - J_00*J_12;
    const double d_22 = J_00*J_11 - J_01*J_10;
    
    // Compute determinant of Jacobian
    double detJ = J_00*d_00 + J_10*d_10 + J_20*d_20;
    
    // Compute inverse of Jacobian
    const double K_00 = d_00 / detJ;
    const double K_01 = d_10 / detJ;
    const double K_02 = d_20 / detJ;
    const double K_10 = d_01 / detJ;
    const double K_11 = d_11 / detJ;
    const double K_12 = d_21 / detJ;
    const double K_20 = d_02 / detJ;
    const double K_21 = d_12 / detJ;
    const double K_22 = d_22 / detJ;
    
    // Compute constants
    const double C0 = x[3][0] + x[2][0] + x[1][0] - x[0][0];
    const double C1 = x[3][1] + x[2][1] + x[1][1] - x[0][1];
    const double C2 = x[3][2] + x[2][2] + x[1][2] - x[0][2];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*coordinates[0] - C0) + d_10*(2.0*coordinates[1] - C1) + d_20*(2.0*coordinates[2] - C2)) / detJ;
    double Y = (d_01*(2.0*coordinates[0] - C0) + d_11*(2.0*coordinates[1] - C1) + d_21*(2.0*coordinates[2] - C2)) / detJ;
    double Z = (d_02*(2.0*coordinates[0] - C0) + d_12*(2.0*coordinates[1] - C1) + d_22*(2.0*coordinates[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K_00, K_01, K_02}, {K_10, K_11, K_12}, {K_20, K_21, K_22}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.00000000;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, 0.00609788, 0.00352061, 0.00248945, 0.00705946, 0.00546824, 0.00446480, 0.00315709, 0.00257775, 0.00182275, -0.00298267, -0.00252082, -0.00218309, -0.00195262, -0.00169102, -0.00138071, -0.00112734, -0.00097631, -0.00079715, -0.00056367, 0.00278687, 0.00245779, 0.00219831, 0.00207721, 0.00185791, 0.00160900, 0.00160900, 0.00143913, 0.00124633, 0.00101762, 0.00092896, 0.00083088, 0.00071957, 0.00058752, 0.00041544, -0.00705594, -0.00638233, -0.00582625, -0.00562869, -0.00513827, -0.00459581, -0.00475711, -0.00434263, -0.00388416, -0.00336379, -0.00368484, -0.00336379, -0.00300866, -0.00260558, -0.00212744, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, -4.20458933, -3.43303281, 0.00000000, 0.00000000, 0.00000000, 19.62141687, 0.00000000, 0.00000000, 0.61167774, 0.52972846, 0.43252148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.53137212, 0.00000000, 3.54562104, -2.50713268, 4.78713554, 0.00000000, 0.00000000, -5.56626745, -1.04880885, 0.74161985, 0.00000000, 18.80349512, -0.60312239, 0.00000000, 0.00000000, 0.00000000, 1.68183573, 0.70128378, 0.13213749, -0.09343532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.05298244, 0.00000000, -1.58564993, 4.48489528, 4.28174419, 0.00000000, 0.00000000, 0.19148542, -3.75233261, -4.31161223, 0.00000000, 0.00000000, 18.88071719, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.84437134, 1.18187368, 1.04463862, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.59512887, 0.00000000, 0.00000000, 0.00000000, 10.02853073, -0.76764947, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.41303613, -1.26347611, 0.09671474, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.32115383, 0.00000000, 0.00000000, 0.00000000, 3.92428337, 5.49285250, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.30446314, -1.73008592, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.01017818, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.91928088, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.85585649, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.96647939, 0.00000000, 8.12403840, -1.64130361, 0.00000000, 0.00000000, 0.00000000, 11.77285012, -2.40312297, 0.48550416, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.27618606, -1.48323970, 0.30276504, -0.06116777, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.65329983, 0.00000000, 4.15220620, 2.93605316, 0.00000000, 0.00000000, 0.00000000, 2.63248932, 9.82591326, -2.82261277, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60818677, -3.09487177, 0.68387651, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29782506, 0.00000000, 1.49829835, 5.50917602, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.64803945, 4.13676893, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.56361364, -3.55352656, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87616630, 0.00000000, 0.00000000, 6.22830930, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.05415242, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.83186701, 0.00000000, -4.41087092, -3.11895674, 16.67499792, 0.00000000, 0.00000000, 2.13065308, 1.73967095, 1.23013313, 0.00000000, -4.36653944, -3.78153408, 0.00000000, 0.00000000, 0.00000000, -0.55793594, -0.48318670, -0.39452029, -0.27896797, 23.69810119, 0.00000000, 0.00000000, 0.49065338, 0.43885373, 0.38005848, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06269339, 0.05607467, 0.04856209, 0.03965078, 0.02803734, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 6.91050664, 0.00000000, 0.00000000, 0.00000000, 10.57062417, -2.72554058, 0.00000000, 0.00000000, 0.00000000, 4.67332858, 0.00000000, 0.00000000, -7.86705868, -2.39719224, 0.61809450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 23.10555489, -0.46968719, 0.00000000, 0.00000000, 0.00000000, 1.62065746, 0.79066915, 0.24092688, -0.06212084, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 6.30840062, 0.00000000, 0.00000000, 0.00000000, -1.52362350, 11.19630041, 0.00000000, 0.00000000, 0.00000000, 4.26614580, 0.00000000, 0.00000000, 0.13299276, -4.72217954, -6.67684597, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 23.15324442, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.72177888, 1.11125128, 1.19087439, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.85449645, 0.00000000, 5.98171818, -2.48806676, 1.90029238, 0.00000000, 0.00000000, -0.33993463, -2.35922147, 0.98130676, 0.00000000, 9.95226703, -0.43094580, 0.00000000, 0.00000000, 0.00000000, -6.45364423, 0.07708993, 0.53502114, -0.22253946, 0.00000000, 0.00000000, 0.00000000, 21.52732974, -1.00024047, 0.04331168, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 2.75066130, 0.64861565, -0.00774783, -0.05377165, 0.02236606, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.51865775, 0.00000000, 1.92724822, 2.72554058, 1.73472167, 0.00000000, 0.00000000, -2.01705690, 3.42052628, -4.03112887, 0.00000000, 4.08831086, 5.37643792, 0.00000000, 0.00000000, 0.00000000, 0.36566964, -6.25148194, -2.03981014, 1.80803322, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 22.18809790, -1.26521524, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.98456381, 1.47113579, 0.36381814, -0.29400945, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.14718317, 0.00000000, -0.86189161, 6.09449400, 1.55158223, 0.00000000, 0.00000000, 0.06938887, -3.05941171, 1.80277564, 0.00000000, 0.00000000, 9.03122157, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.40388851, -3.67461995, -5.49650683, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.78412606, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.97421573, 1.78974859, 1.80791909, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.54523626, 0.00000000, 0.00000000, 0.00000000, 6.71778025, -0.60944940, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.65939832, -1.52344936, 0.13821013, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.11950128, -1.47332497, 0.15311242, -0.01389064, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.41060126, 0.00000000, 0.00000000, 0.00000000, 3.63405410, 2.50356888, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 3.56857028, 11.26305541, -1.49298815, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.36735965, -2.65048896, 0.26628761, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.26168012, 0.00000000, 0.00000000, 0.00000000, 1.42204860, 4.47852016, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.27725129, 5.37909281, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.96548132, -2.61992366, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.09264704, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.38682255, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.43778180, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.90767040, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.52336025, 0.00000000, 7.37120708, -1.62882204, 0.00000000, 0.00000000, 0.00000000, 12.01713063, -2.90724328, 0.64241607, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.98588209, -2.72522907, 0.65930080, -0.14568627, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.80438309, -1.40563404, 0.27389583, -0.06626222, 0.01464202, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.30350221, 0.00000000, 4.41588043, 1.78428514, 0.00000000, 0.00000000, 0.00000000, 4.26614580, 7.83741029, -2.63899331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 2.23427841, 13.22210271, -4.67379218, 1.18363558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.12588516, -3.11150358, 0.83361207, -0.19247437, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.06031501, 0.00000000, 2.25696202, 3.98978287, 0.00000000, 0.00000000, 0.00000000, 0.95393920, 8.01142042, 1.18019369, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.55254896, 9.62241374, -3.59830837, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.39325203, -4.68666193, 1.18356087, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.78428514, 0.00000000, 0.81441102, 5.06770487, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 4.01510047, 6.58672306, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.01593119, 2.83293315, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.09294544, -4.55552790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.45686272, 0.00000000, 0.00000000, 5.07816454, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.01427552, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.87848136, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.55355873, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.56904652, 5.80288457, -2.01017818, -1.42141062, 8.14215223, -2.10229466, -1.71651641, 0.72825623, 0.59461873, 0.42045893, 9.81070844, -1.18450885, -1.02581476, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.09175166, -0.07491492, -0.05297285, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.26568606, 3.07059789, 1.77281052, -1.25356634, 2.39356777, 6.30376871, -0.90829511, -2.78313373, -0.52440442, 0.37080992, 11.12429773, 9.40174756, -0.30156119, -2.42752078, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.06606875, -0.04671766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.02649122, 2.74642625, -0.79282497, 2.24244764, 2.14087210, -0.33166248, 6.49923072, 0.09574271, -1.87616630, -2.15580611, 0.00000000, 0.00000000, 9.44035859, 0.00000000, -1.46249406, -2.04706526, 0.00000000, 0.42218567, 0.59093684, 0.52231931, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.91485422, 1.29756444, 3.74574589, -1.05945693, -8.09173594, 5.01426536, -0.38382474, 1.80936716, -1.10800658, 0.31339159, 0.00000000, 12.71348312, 1.01946290, 8.20651807, -0.63173806, 0.04835737, -2.84282125, -0.22795884, 0.13959571, -0.03948363, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.71269768, 1.16057691, 1.34011879, 1.89521417, 2.53311403, 1.96214169, 2.74642625, -0.56642152, 3.17129987, -1.82198871, 0.00000000, 0.00000000, 11.16998292, 0.00000000, 8.65223157, -0.86504296, 0.00000000, -2.49768411, -0.99886557, 0.44144039, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 1.00508909, -0.19342949, 3.55615783, 0.00000000, 0.00000000, 4.45964044, 0.00000000, -0.85825820, 2.67027286, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.42792824, 0.00000000, 0.00000000, -1.62195555, -2.29379153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 7.03562364, 4.06201920, -0.82065181, 0.00000000, -6.79705819, -2.08116554, 5.88642506, -1.20156148, 0.24275208, 0.00000000, 0.00000000, 0.00000000, 14.83239697, 0.85634884, 0.26220221, 5.13809303, -0.74161985, 0.15138252, -0.03058389, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32664992, -2.69693704, 2.07610310, 1.46802658, 0.00000000, 3.03973683, -6.38211788, 1.31624466, 4.91295663, -1.41130639, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.40397951, 2.01017818, 0.00000000, 5.80409338, -1.54743589, 0.34193825, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.14891253, 1.29756444, 0.74914918, 2.75458801, 0.00000000, 0.00000000, 5.75737105, 0.00000000, 3.32401973, 2.06838446, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.88040858, 0.00000000, 0.00000000, 6.28180682, -1.77676328, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.93808315, 0.00000000, 0.00000000, 3.11415465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.52707621, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.80288457, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.42539535, 0.00000000, 9.38083152, 1.89521417, 0.00000000, 0.00000000, 0.00000000, -3.39852909, -2.77488739, -0.56061191, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.79887637, 0.42817442, 0.34960295, 0.07063046, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.82970843, 0.00000000, -1.49829835, 4.23782771, 0.00000000, 0.00000000, 0.00000000, 3.79967104, -3.54562104, -4.07409061, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.75497439, 1.11676566, 0.98709071, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.32664992, 0.00000000, 1.73008592, -3.18072426, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.67649474, -2.38836465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.50721144, 2.05162952, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62480768, 0.00000000, 0.00000000, 5.39387408, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.57317681, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.05089091, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.41593350, 5.72988941, -2.20543546, -1.55947837, 8.33749896, -2.76779954, -2.25989886, 1.06532654, 0.86983548, 0.61506656, 10.33311828, -2.18326972, -1.89076704, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.84905059, -1.16109782, -1.03851746, 0.24532669, 0.21942686, 0.19002924, -0.08144110, -0.07284314, -0.06308401, -0.05150788, 0.03134669, 0.02803734, 0.02428105, 0.01982539, 0.01401867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.18529408, 3.45525332, 0.99744572, -1.41060126, 3.23209353, 5.28531208, -1.36277029, -2.89087233, -0.39339790, 0.55634864, 2.33666429, 9.02784807, -0.73296992, -3.93352934, -1.19859612, 0.30904725, 1.64018416, 0.65558822, 0.08921426, -0.12616801, 13.09961832, 11.55277744, -0.23484360, -2.44096975, -0.90733287, 0.07366625, 0.81032873, 0.39533457, 0.12046344, -0.03106042, -0.31189567, -0.16484471, -0.06588910, -0.00896637, 0.01268036, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.99489143, 3.15420031, -1.09264704, 1.54523626, 2.95048422, -0.76181175, 5.59815020, 0.26389933, -1.93925612, -2.28543525, 2.13307290, -0.25753938, 9.14446135, 0.06649638, -2.36108977, -3.33842299, -0.02303502, 0.81790549, 1.15646365, 1.02505849, 0.00000000, 0.00000000, 11.57662221, 0.00000000, -1.39771879, -2.15192885, 0.00000000, 0.36088944, 0.55562564, 0.59543720, 0.00000000, -0.12501577, -0.19247437, -0.20626550, -0.16668769, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.92724822, 1.82834820, 2.99085909, -1.24403338, 0.95014619, 5.74064456, -0.72111026, -0.16996732, -1.17961073, 0.49065338, -10.30372101, 4.97613352, -0.21547290, 5.78174467, -1.30185582, 0.16353243, -3.22682211, 0.03854496, 0.26751057, -0.11126973, 0.00000000, 14.55513146, 1.03556293, 10.76366487, -0.50012024, 0.02165584, -3.57321384, -0.58108720, 0.13084143, -0.01643563, 1.37533065, 0.32430782, -0.00387391, -0.02688582, 0.01118303, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.75932888, 1.66904592, 0.96362411, 1.36277029, 0.86736083, 2.28430636, 2.96226265, -1.00852845, 1.71026314, -2.01556444, 2.41867732, 2.04415543, 2.68821896, -0.52779866, 7.07977053, -1.76652740, 0.18283482, -3.12574097, -1.01990507, 0.90401661, 0.00000000, 0.00000000, 13.12665574, 0.00000000, 11.09404895, -0.63260762, 0.00000000, -2.86447112, -1.66605357, 0.31507575, 0.00000000, 0.99228190, 0.73556789, 0.18190907, -0.14700473, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.57359158, 1.49284005, -0.43094580, 3.04724700, 0.77579111, -0.12018504, 5.29905652, 0.03469443, -1.52970585, 0.90138782, 0.00000000, 0.00000000, 4.51561078, 0.00000000, -0.69955541, 6.36462844, 0.00000000, 0.20194425, -1.83730997, -2.74825341, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.89206303, 0.00000000, 0.00000000, -1.68739115, -3.09993548, 0.00000000, 0.00000000, 0.48710787, 0.89487429, 0.90395954, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62882204, 0.77261813, 3.86595114, -1.05140010, 9.15442906, 3.35889012, -0.30472470, 3.87851223, -1.52475169, 0.41467779, 0.00000000, -9.46260093, -2.07602937, 7.32969916, -0.76172468, 0.06910507, 0.56424050, -0.87956390, 0.34578118, -0.09404008, 0.00000000, 0.00000000, 0.00000000, 16.37452289, 0.95102718, 0.20864880, 9.05975064, -0.73666248, 0.07655621, -0.00694532, -3.48709965, -0.05670830, 0.08839950, -0.03475232, 0.00945138, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48690429, 0.70530063, 2.03602754, 1.15175111, -2.93221479, 1.81702705, 1.25178444, 0.65566316, 3.61359042, -1.70346286, 0.00000000, 2.76420266, -9.08783876, 1.78428514, 5.63152771, -0.74649407, -0.61809450, 2.03210252, -2.15494277, 0.76403348, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.00189227, 2.13860408, 0.00000000, 9.68367982, -1.32524448, 0.13314380, 0.00000000, -3.35452509, -0.47820641, 0.38435306, -0.12424167, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32992762, 0.63084006, 0.72843136, 2.57539377, 0.91792842, 0.71102430, 2.23926008, -0.20525504, 2.58567482, 0.76181175, 0.00000000, 0.00000000, 5.34294273, 0.00000000, 4.13862564, 2.68954640, 0.00000000, -1.19471831, 3.10562068, -2.32269807, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.88766278, 0.00000000, 0.00000000, 9.98274066, -1.30996183, 0.00000000, 0.00000000, -2.88176900, -1.51261363, 0.76398525, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.54632352, -0.10514001, 3.27118943, 0.00000000, 0.00000000, 2.69341127, 0.00000000, -0.51834724, 4.25171145, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.71889090, 0.00000000, 0.00000000, -1.29305116, 1.82865048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.45383520, 0.00000000, 0.00000000, 0.00000000, -1.81939143, -2.94058062, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, -6.78263088, 3.68560354, -0.81441102, 0.00000000, 10.02169076, 2.67510569, 6.00856531, -1.45362164, 0.32120804, 0.00000000, 0.00000000, 0.00000000, -7.57008074, -2.27270584, -0.60665695, 6.99294105, -1.36261453, 0.32965040, -0.07284314, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.71374045, 0.76082174, 0.22841553, 0.06097132, 5.40219154, -0.70281702, 0.13694791, -0.03313111, 0.00732101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 3.82426464, 2.20794022, 0.89214257, 0.00000000, -2.46306043, 6.78739641, 2.13307290, 3.91870514, -1.31949666, 0.00000000, 0.00000000, 0.00000000, 3.22490310, -7.63378456, -4.04762276, 1.11713920, 6.61105135, -2.33689609, 0.59181779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.50220765, 1.79642743, 0.72192923, 0.00000000, 6.06294258, -1.55575179, 0.41680604, -0.09623718, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03015751, -1.46593983, 1.12848101, 1.99489143, 0.00000000, 1.10151411, -5.20357020, 0.47696960, 4.00571021, 0.59009684, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.41153128, -6.24994106, 0.00000000, 2.77627448, 4.81120687, -1.79915419, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.46519533, 3.04407621, 0.00000000, 0.00000000, 6.69662602, -2.34333096, 0.59178043, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.89214257, 0.70530063, 0.40720551, 2.53385244, 0.00000000, 0.00000000, 3.47717900, 0.00000000, 2.00755023, 3.29336153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.67405085, 0.00000000, 0.00000000, 5.00796559, 1.41646657, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.20484876, 0.00000000, 0.00000000, 0.00000000, 7.04647272, -2.27776395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, 0.00000000, 0.00000000, 2.53908227, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.00713776, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.93924068, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.27677936, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.09901951, 0.00000000, -4.65474668, -3.29140294, 0.00000000, 0.00000000, 0.00000000, 13.49073756, 1.83585685, 1.29814683, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -3.53270435, -3.05941171, -0.41633320, -0.29439203, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.83269719, 0.35505015, 0.30748245, 0.04184306, 0.02958751, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.65985525, 0.00000000, 5.09901951, -2.06031501, 0.00000000, 0.00000000, 0.00000000, -1.23153021, 9.04986188, 3.04724700, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 3.86988372, -3.81689228, -5.39683035, -1.36674465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.00264918, 0.89821372, 0.96257231, 0.22225026, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.97380857, 0.00000000, -0.81441102, 5.75875553, 0.00000000, 0.00000000, 0.00000000, 1.37689264, -2.89087233, 1.70346286, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.01441410, -3.47218948, -5.19371077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.33149417, 1.69115345, 1.70832296, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.03015751, 0.00000000, 0.94040084, -2.92584077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 4.63623867, -3.80284633, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.56540113, -1.63559471, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.27313168, 2.63013526, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, 0.00000000, 0.00000000, 4.39781950, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.67261700, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.01911742, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.87170077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.56904652, 5.80288457, -2.01017818, -1.42141062, 8.14215223, -2.10229466, -1.71651641, 0.72825623, 0.59461873, 0.42045893, 9.81070844, -1.18450885, -1.02581476, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.09175166, -0.07491492, -0.05297285, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.26568606, 3.07059789, 1.77281052, -1.25356634, 2.39356777, 6.30376871, -0.90829511, -2.78313373, -0.52440442, 0.37080992, 1.23603308, 9.40174756, -0.30156119, -2.42752078, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.06606875, -0.04671766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.02649122, 2.74642625, -0.79282497, 2.24244764, 2.14087210, -0.33166248, 6.49923072, 0.09574271, -1.87616630, -2.15580611, 11.05541597, 0.00000000, 9.44035859, 0.00000000, -1.46249406, -2.04706526, 0.00000000, 0.42218567, 0.59093684, 0.52231931, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.91485422, 1.29756444, 3.74574589, -1.05945693, 0.40458680, 5.01426536, -0.38382474, 1.80936716, -1.10800658, 0.31339159, 0.00000000, 2.82521847, -0.05097315, 8.20651807, -0.63173806, 0.04835737, -2.84282125, -0.22795884, 0.13959571, -0.03948363, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.71269768, 1.16057691, 1.34011879, 1.89521417, 0.36187343, 1.96214169, 2.74642625, -0.56642152, 3.17129987, -1.82198871, 0.00000000, 11.05541597, 1.59571185, 0.00000000, 8.65223157, -0.86504296, 0.00000000, -2.49768411, -0.99886557, 0.44144039, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 1.00508909, -0.19342949, 3.55615783, -8.46157280, 0.00000000, 4.45964044, 0.00000000, -0.85825820, 2.67027286, 0.00000000, 0.00000000, 12.43734296, 0.00000000, 0.00000000, 8.42792824, 0.00000000, 0.00000000, -1.62195555, -2.29379153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 0.33502970, 4.06201920, -0.82065181, 0.00000000, 1.69926455, -0.09910312, 5.88642506, -1.20156148, 0.24275208, 0.00000000, 0.00000000, 0.00000000, 4.94413232, -0.21408721, 0.01248582, 5.13809303, -0.74161985, 0.15138252, -0.03058389, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32664992, 0.29965967, 2.07610310, 1.46802658, 0.00000000, 0.86849624, 0.70912421, 1.31624466, 4.91295663, -1.41130639, 0.00000000, 0.00000000, 0.00000000, 11.05541597, 3.82970843, -0.22335313, 0.00000000, 5.80409338, -1.54743589, 0.34193825, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.14891253, 0.25951289, 0.74914918, 2.75458801, 0.00000000, -8.46157280, 1.15147421, 0.00000000, 3.32401973, 2.06838446, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.43734296, 2.17608172, 0.00000000, 0.00000000, 6.28180682, -1.77676328, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.93808315, 7.62808987, 0.00000000, 3.11415465, 0.00000000, 0.00000000, -7.52139805, 0.00000000, 0.00000000, 5.52707621, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.21410624, 0.00000000, 0.00000000, 0.00000000, 5.80288457, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.85634884, 0.00000000, 2.68023758, -0.47380354, 0.00000000, 0.00000000, 0.00000000, 5.09779364, -0.79282497, 0.14015298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.91061172, -0.64226163, 0.09988656, -0.01765762, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.76594169, 0.00000000, 1.49829835, 0.84756554, 0.00000000, 0.00000000, 0.00000000, 1.62843045, 3.54562104, -0.81481812, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.05541597, 7.18070331, -1.11676566, 0.19741814, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.66332496, 0.00000000, 0.69203437, 1.59036213, 0.00000000, 0.00000000, 0.00000000, -8.46157280, 3.07059789, 1.19418233, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.43734296, 5.80288457, -1.02581476, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.54160256, 0.00000000, 7.62808987, 1.79795803, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -7.52139805, 3.19105894, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.21410624, 3.35029697, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-5.36159180, 0.00000000, 0.00000000, 8.89943818, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -5.26497863, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.58312395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.41593350, 5.72988941, -2.20543546, -1.55947837, 8.33749896, -2.76779954, -2.25989886, 1.06532654, 0.86983548, 0.61506656, 10.33311828, -2.18326972, -1.89076704, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.84905059, -1.16109782, -1.03851746, 0.24532669, 0.21942686, 0.19002924, -0.08144110, -0.07284314, -0.06308401, -0.05150788, 0.03134669, 0.02803734, 0.02428105, 0.01982539, 0.01401867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.18529408, 3.45525332, 0.99744572, -1.41060126, 3.23209353, 5.28531208, -1.36277029, -2.89087233, -0.39339790, 0.55634864, 2.33666429, 9.02784807, -0.73296992, -3.93352934, -1.19859612, 0.30904725, 1.64018416, 0.65558822, 0.08921426, -0.12616801, 1.19087439, 11.55277744, -0.23484360, -2.44096975, -0.90733287, 0.07366625, 0.81032873, 0.39533457, 0.12046344, -0.03106042, -0.31189567, -0.16484471, -0.06588910, -0.00896637, 0.01268036, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.99489143, 3.15420031, -1.09264704, 1.54523626, 2.95048422, -0.76181175, 5.59815020, 0.26389933, -1.93925612, -2.28543525, 2.13307290, -0.25753938, 9.14446135, 0.06649638, -2.36108977, -3.33842299, -0.02303502, 0.81790549, 1.15646365, 1.02505849, 13.04537536, 0.00000000, 11.57662221, 0.00000000, -1.39771879, -2.15192885, 0.00000000, 0.36088944, 0.55562564, 0.59543720, 0.00000000, -0.12501577, -0.19247437, -0.20626550, -0.16668769, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.92724822, 1.82834820, 2.99085909, -1.24403338, 0.95014619, 5.74064456, -0.72111026, -0.16996732, -1.17961073, 0.49065338, 0.29439203, 4.97613352, -0.21547290, 5.78174467, -1.30185582, 0.16353243, -3.22682211, 0.03854496, 0.26751057, -0.11126973, 0.00000000, 2.64638754, -0.02958751, 10.76366487, -0.50012024, 0.02165584, -3.57321384, -0.58108720, 0.13084143, -0.01643563, 1.37533065, 0.32430782, -0.00387391, -0.02688582, 0.01118303, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.75932888, 1.66904592, 0.96362411, 1.36277029, 0.86736083, 2.28430636, 2.96226265, -1.00852845, 1.71026314, -2.01556444, 0.26874192, 2.04415543, 2.68821896, -0.52779866, 7.07977053, -1.76652740, 0.18283482, -3.12574097, -1.01990507, 0.90401661, 0.00000000, 13.04537536, 1.45851730, 0.00000000, 11.09404895, -0.63260762, 0.00000000, -2.86447112, -1.66605357, 0.31507575, 0.00000000, 0.99228190, 0.73556789, 0.18190907, -0.14700473, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.57359158, 1.49284005, -0.43094580, 3.04724700, 0.77579111, -0.12018504, 5.29905652, 0.03469443, -1.52970585, 0.90138782, -10.57628374, 0.00000000, 4.51561078, 0.00000000, -0.69955541, 6.36462844, 0.00000000, 0.20194425, -1.83730997, -2.74825341, 0.00000000, 0.00000000, 14.34991289, 0.00000000, 0.00000000, 10.89206303, 0.00000000, 0.00000000, -1.68739115, -3.09993548, 0.00000000, 0.00000000, 0.48710787, 0.89487429, 0.90395954, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62882204, 0.77261813, 3.86595114, -1.05140010, 0.16060402, 3.35889012, -0.30472470, 3.87851223, -1.52475169, 0.41467779, 0.00000000, 1.13551211, -0.03642157, 7.32969916, -0.76172468, 0.06910507, 0.56424050, -0.87956390, 0.34578118, -0.09404008, 0.00000000, 0.00000000, 0.00000000, 4.46577897, -0.11412326, 0.00366051, 9.05975064, -0.73666248, 0.07655621, -0.00694532, -3.48709965, -0.05670830, 0.08839950, -0.03475232, 0.00945138, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48690429, 0.70530063, 2.03602754, 1.15175111, 0.14661074, 1.81702705, 1.25178444, 0.65566316, 3.61359042, -1.70346286, 0.00000000, 0.61426726, 0.45439194, 1.78428514, 5.63152771, -0.74649407, -0.61809450, 2.03210252, -2.15494277, 0.76403348, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 3.33375384, -0.10693020, 0.00000000, 9.68367982, -1.32524448, 0.13314380, 0.00000000, -3.35452509, -0.47820641, 0.38435306, -0.12424167, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32992762, 0.63084006, 0.72843136, 2.57539377, 0.13113263, 0.71102430, 2.23926008, -0.20525504, 2.58567482, 0.76181175, 0.00000000, -10.57628374, 0.76327753, 0.00000000, 4.13862564, 2.68954640, 0.00000000, -1.19471831, 3.10562068, -2.32269807, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 1.84109468, 0.00000000, 0.00000000, 9.98274066, -1.30996183, 0.00000000, 0.00000000, -2.88176900, -1.51261363, 0.76398525, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.54632352, -0.10514001, 3.27118943, 9.65295620, 0.00000000, 2.69341127, 0.00000000, -0.51834724, 4.25171145, 0.00000000, 0.00000000, -9.91526601, 0.00000000, 0.00000000, 6.71889090, 0.00000000, 0.00000000, -1.29305116, 1.82865048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 0.00000000, 0.00000000, 0.00000000, 9.45383520, 0.00000000, 0.00000000, 0.00000000, -1.81939143, -2.94058062, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, 0.19948914, 3.68560354, -0.81441102, 0.00000000, 1.02786572, -0.07867958, 6.00856531, -1.45362164, 0.32120804, 0.00000000, 0.00000000, 0.00000000, 3.02803230, -0.23309803, 0.01784285, 6.99294105, -1.36261453, 0.32965040, -0.07284314, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.80499653, -0.30432870, 0.02342723, -0.00179327, 5.40219154, -0.70281702, 0.13694791, -0.03313111, 0.00732101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.18210784, 2.20794022, 0.89214257, 0.00000000, 0.61576511, 0.32320935, 2.13307290, 3.91870514, -1.31949666, 0.00000000, 0.00000000, 0.00000000, 1.07496770, 1.90844614, -0.19274394, 1.11713920, 6.61105135, -2.33689609, 0.59181779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 5.83406922, -0.44910686, 0.03437758, 0.00000000, 6.06294258, -1.55575179, 0.41680604, -0.09623718, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03015751, 0.16288220, 1.12848101, 1.99489143, 0.00000000, 0.31471832, 0.57817447, 0.47696960, 4.00571021, 0.59009684, 0.00000000, 0.00000000, 0.00000000, -10.57628374, 1.83186608, 0.69443790, 0.00000000, 2.77627448, 4.81120687, -1.79915419, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 4.41862724, -0.33823069, 0.00000000, 0.00000000, 6.69662602, -2.34333096, 0.59178043, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.89214257, 0.14106013, 0.40720551, 2.53385244, 0.00000000, 9.65295620, 0.69543580, 0.00000000, 2.00755023, 3.29336153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -9.91526601, 1.73481017, 0.00000000, 0.00000000, 5.00796559, 1.41646657, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 2.44096975, 0.00000000, 0.00000000, 0.00000000, 7.04647272, -2.27776395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, -7.94708264, 0.00000000, 2.53908227, 0.00000000, 0.00000000, 10.22077716, 0.00000000, 0.00000000, 5.00713776, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -8.49879944, 0.00000000, 0.00000000, 0.00000000, 6.93924068, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.93739111, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.27677936, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, 0.00000000, 2.32737334, -0.47020042, 0.00000000, 0.00000000, 0.00000000, 4.49691252, -0.91792842, 0.18544955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.06540869, -1.01980390, 0.20816660, -0.04205600, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.92395327, -0.71010029, 0.10249415, -0.02092153, 0.00422679, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.66496381, 0.00000000, 1.45686272, 0.51507875, 0.00000000, 0.00000000, 0.00000000, 1.84729532, 2.58567482, -0.76181175, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.71994832, 5.72533842, -1.54195153, 0.34168616, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 9.33451075, -1.34732057, 0.27502066, -0.05556256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.59476171, 0.00000000, 0.81441102, 1.15175111, 0.00000000, 0.00000000, 0.00000000, 0.59009684, 2.89087233, 0.34069257, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -10.57628374, 3.43474890, 3.47218948, -1.03874215, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 8.28492607, -1.69115345, 0.34166459, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.51507875, 0.00000000, 0.37616034, 1.46292039, 0.00000000, 0.00000000, 0.00000000, 9.65295620, 1.85449547, 1.90142317, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -9.91526601, 4.62616045, 0.81779736, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 6.50925267, -1.31506763, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.42056004, 0.00000000, -7.94708264, 1.46593983, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.22077716, 2.89087233, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -8.49879944, 4.00637247, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.93739111, 3.62390026, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.54237886, 0.00000000, 0.00000000, -6.91050664, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.26493259, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -5.66586629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 20.49987556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, -0.00609788, 0.00352061, 0.00248945, 0.00705946, -0.00546824, -0.00446480, 0.00315709, 0.00257775, 0.00182275, 0.00298267, -0.00252082, -0.00218309, 0.00195262, 0.00169102, 0.00138071, -0.00112734, -0.00097631, -0.00079715, -0.00056367, 0.00278687, -0.00245779, -0.00219831, 0.00207721, 0.00185791, 0.00160900, -0.00160900, -0.00143913, -0.00124633, -0.00101762, 0.00092896, 0.00083088, 0.00071957, 0.00058752, 0.00041544, 0.00705594, -0.00638233, -0.00582625, 0.00562869, 0.00513827, 0.00459581, -0.00475711, -0.00434263, -0.00388416, -0.00336379, 0.00368484, 0.00336379, 0.00300866, 0.00260558, 0.00212744, -0.00212744, -0.00194208, -0.00173705, -0.00150433, -0.00122828, -0.00086853};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, -4.20458933, -3.43303281, 0.00000000, 0.00000000, 0.00000000, 19.62141687, 0.00000000, 0.00000000, 0.61167774, 0.52972846, 0.43252148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.53137212, 0.00000000, 3.54562104, -2.50713268, 4.78713554, 0.00000000, 0.00000000, -5.56626745, -1.04880885, 0.74161985, 0.00000000, 18.80349512, -0.60312239, 0.00000000, 0.00000000, 0.00000000, 1.68183573, 0.70128378, 0.13213749, -0.09343532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.05298244, 0.00000000, -1.58564993, 4.48489528, 4.28174419, 0.00000000, 0.00000000, 0.19148542, -3.75233261, -4.31161223, 0.00000000, 0.00000000, 18.88071719, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.84437134, 1.18187368, 1.04463862, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.59512887, 0.00000000, 0.00000000, 0.00000000, 10.02853073, -0.76764947, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.41303613, -1.26347611, 0.09671474, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.32115383, 0.00000000, 0.00000000, 0.00000000, 3.92428337, 5.49285250, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.30446314, -1.73008592, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.01017818, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.91928088, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.85585649, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.96647939, 0.00000000, 8.12403840, -1.64130361, 0.00000000, 0.00000000, 0.00000000, 11.77285012, -2.40312297, 0.48550416, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.27618606, -1.48323970, 0.30276504, -0.06116777, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.65329983, 0.00000000, 4.15220620, 2.93605316, 0.00000000, 0.00000000, 0.00000000, 2.63248932, 9.82591326, -2.82261277, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60818677, -3.09487177, 0.68387651, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29782506, 0.00000000, 1.49829835, 5.50917602, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.64803945, 4.13676893, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.56361364, -3.55352656, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87616630, 0.00000000, 0.00000000, 6.22830930, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.05415242, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.83186701, 0.00000000, -4.41087092, -3.11895674, 16.67499792, 0.00000000, 0.00000000, 2.13065308, 1.73967095, 1.23013313, 0.00000000, -4.36653944, -3.78153408, 0.00000000, 0.00000000, 0.00000000, -0.55793594, -0.48318670, -0.39452029, -0.27896797, 23.69810119, 0.00000000, 0.00000000, 0.49065338, 0.43885373, 0.38005848, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06269339, 0.05607467, 0.04856209, 0.03965078, 0.02803734, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 6.91050664, 0.00000000, 0.00000000, 0.00000000, 10.57062417, -2.72554058, 0.00000000, 0.00000000, 0.00000000, 4.67332858, 0.00000000, 0.00000000, -7.86705868, -2.39719224, 0.61809450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 23.10555489, -0.46968719, 0.00000000, 0.00000000, 0.00000000, 1.62065746, 0.79066915, 0.24092688, -0.06212084, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 6.30840062, 0.00000000, 0.00000000, 0.00000000, -1.52362350, 11.19630041, 0.00000000, 0.00000000, 0.00000000, 4.26614580, 0.00000000, 0.00000000, 0.13299276, -4.72217954, -6.67684597, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 23.15324442, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.72177888, 1.11125128, 1.19087439, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.85449645, 0.00000000, 5.98171818, -2.48806676, 1.90029238, 0.00000000, 0.00000000, -0.33993463, -2.35922147, 0.98130676, 0.00000000, 9.95226703, -0.43094580, 0.00000000, 0.00000000, 0.00000000, -6.45364423, 0.07708993, 0.53502114, -0.22253946, 0.00000000, 0.00000000, 0.00000000, 21.52732974, -1.00024047, 0.04331168, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 2.75066130, 0.64861565, -0.00774783, -0.05377165, 0.02236606, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.51865775, 0.00000000, 1.92724822, 2.72554058, 1.73472167, 0.00000000, 0.00000000, -2.01705690, 3.42052628, -4.03112887, 0.00000000, 4.08831086, 5.37643792, 0.00000000, 0.00000000, 0.00000000, 0.36566964, -6.25148194, -2.03981014, 1.80803322, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 22.18809790, -1.26521524, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.98456381, 1.47113579, 0.36381814, -0.29400945, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.14718317, 0.00000000, -0.86189161, 6.09449400, 1.55158223, 0.00000000, 0.00000000, 0.06938887, -3.05941171, 1.80277564, 0.00000000, 0.00000000, 9.03122157, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.40388851, -3.67461995, -5.49650683, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.78412606, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.97421573, 1.78974859, 1.80791909, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.54523626, 0.00000000, 0.00000000, 0.00000000, 6.71778025, -0.60944940, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.65939832, -1.52344936, 0.13821013, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.11950128, -1.47332497, 0.15311242, -0.01389064, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.41060126, 0.00000000, 0.00000000, 0.00000000, 3.63405410, 2.50356888, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 3.56857028, 11.26305541, -1.49298815, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.36735965, -2.65048896, 0.26628761, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.26168012, 0.00000000, 0.00000000, 0.00000000, 1.42204860, 4.47852016, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.27725129, 5.37909281, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.96548132, -2.61992366, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.09264704, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.38682255, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.43778180, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.90767040, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.52336025, 0.00000000, 7.37120708, -1.62882204, 0.00000000, 0.00000000, 0.00000000, 12.01713063, -2.90724328, 0.64241607, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.98588209, -2.72522907, 0.65930080, -0.14568627, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.80438309, -1.40563404, 0.27389583, -0.06626222, 0.01464202, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.30350221, 0.00000000, 4.41588043, 1.78428514, 0.00000000, 0.00000000, 0.00000000, 4.26614580, 7.83741029, -2.63899331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 2.23427841, 13.22210271, -4.67379218, 1.18363558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.12588516, -3.11150358, 0.83361207, -0.19247437, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.06031501, 0.00000000, 2.25696202, 3.98978287, 0.00000000, 0.00000000, 0.00000000, 0.95393920, 8.01142042, 1.18019369, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.55254896, 9.62241374, -3.59830837, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.39325203, -4.68666193, 1.18356087, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.78428514, 0.00000000, 0.81441102, 5.06770487, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 4.01510047, 6.58672306, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.01593119, 2.83293315, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.09294544, -4.55552790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.45686272, 0.00000000, 0.00000000, 5.07816454, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.01427552, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.87848136, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.55355873, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.56904652, 5.80288457, -2.01017818, -1.42141062, 8.14215223, -2.10229466, -1.71651641, 0.72825623, 0.59461873, 0.42045893, 9.81070844, -1.18450885, -1.02581476, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.09175166, -0.07491492, -0.05297285, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.26568606, 3.07059789, 1.77281052, -1.25356634, 2.39356777, 6.30376871, -0.90829511, -2.78313373, -0.52440442, 0.37080992, 11.12429773, 9.40174756, -0.30156119, -2.42752078, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.06606875, -0.04671766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.02649122, 2.74642625, -0.79282497, 2.24244764, 2.14087210, -0.33166248, 6.49923072, 0.09574271, -1.87616630, -2.15580611, 0.00000000, 0.00000000, 9.44035859, 0.00000000, -1.46249406, -2.04706526, 0.00000000, 0.42218567, 0.59093684, 0.52231931, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.91485422, 1.29756444, 3.74574589, -1.05945693, -8.09173594, 5.01426536, -0.38382474, 1.80936716, -1.10800658, 0.31339159, 0.00000000, 12.71348312, 1.01946290, 8.20651807, -0.63173806, 0.04835737, -2.84282125, -0.22795884, 0.13959571, -0.03948363, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.71269768, 1.16057691, 1.34011879, 1.89521417, 2.53311403, 1.96214169, 2.74642625, -0.56642152, 3.17129987, -1.82198871, 0.00000000, 0.00000000, 11.16998292, 0.00000000, 8.65223157, -0.86504296, 0.00000000, -2.49768411, -0.99886557, 0.44144039, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 1.00508909, -0.19342949, 3.55615783, 0.00000000, 0.00000000, 4.45964044, 0.00000000, -0.85825820, 2.67027286, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.42792824, 0.00000000, 0.00000000, -1.62195555, -2.29379153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 7.03562364, 4.06201920, -0.82065181, 0.00000000, -6.79705819, -2.08116554, 5.88642506, -1.20156148, 0.24275208, 0.00000000, 0.00000000, 0.00000000, 14.83239697, 0.85634884, 0.26220221, 5.13809303, -0.74161985, 0.15138252, -0.03058389, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32664992, -2.69693704, 2.07610310, 1.46802658, 0.00000000, 3.03973683, -6.38211788, 1.31624466, 4.91295663, -1.41130639, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.40397951, 2.01017818, 0.00000000, 5.80409338, -1.54743589, 0.34193825, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.14891253, 1.29756444, 0.74914918, 2.75458801, 0.00000000, 0.00000000, 5.75737105, 0.00000000, 3.32401973, 2.06838446, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.88040858, 0.00000000, 0.00000000, 6.28180682, -1.77676328, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.93808315, 0.00000000, 0.00000000, 3.11415465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.52707621, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.80288457, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.42539535, 0.00000000, 9.38083152, 1.89521417, 0.00000000, 0.00000000, 0.00000000, -3.39852909, -2.77488739, -0.56061191, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.79887637, 0.42817442, 0.34960295, 0.07063046, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.82970843, 0.00000000, -1.49829835, 4.23782771, 0.00000000, 0.00000000, 0.00000000, 3.79967104, -3.54562104, -4.07409061, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.75497439, 1.11676566, 0.98709071, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.32664992, 0.00000000, 1.73008592, -3.18072426, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.67649474, -2.38836465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.50721144, 2.05162952, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62480768, 0.00000000, 0.00000000, 5.39387408, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.57317681, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.05089091, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.41593350, 5.72988941, -2.20543546, -1.55947837, 8.33749896, -2.76779954, -2.25989886, 1.06532654, 0.86983548, 0.61506656, 10.33311828, -2.18326972, -1.89076704, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.84905059, -1.16109782, -1.03851746, 0.24532669, 0.21942686, 0.19002924, -0.08144110, -0.07284314, -0.06308401, -0.05150788, 0.03134669, 0.02803734, 0.02428105, 0.01982539, 0.01401867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.18529408, 3.45525332, 0.99744572, -1.41060126, 3.23209353, 5.28531208, -1.36277029, -2.89087233, -0.39339790, 0.55634864, 2.33666429, 9.02784807, -0.73296992, -3.93352934, -1.19859612, 0.30904725, 1.64018416, 0.65558822, 0.08921426, -0.12616801, 13.09961832, 11.55277744, -0.23484360, -2.44096975, -0.90733287, 0.07366625, 0.81032873, 0.39533457, 0.12046344, -0.03106042, -0.31189567, -0.16484471, -0.06588910, -0.00896637, 0.01268036, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.99489143, 3.15420031, -1.09264704, 1.54523626, 2.95048422, -0.76181175, 5.59815020, 0.26389933, -1.93925612, -2.28543525, 2.13307290, -0.25753938, 9.14446135, 0.06649638, -2.36108977, -3.33842299, -0.02303502, 0.81790549, 1.15646365, 1.02505849, 0.00000000, 0.00000000, 11.57662221, 0.00000000, -1.39771879, -2.15192885, 0.00000000, 0.36088944, 0.55562564, 0.59543720, 0.00000000, -0.12501577, -0.19247437, -0.20626550, -0.16668769, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.92724822, 1.82834820, 2.99085909, -1.24403338, 0.95014619, 5.74064456, -0.72111026, -0.16996732, -1.17961073, 0.49065338, -10.30372101, 4.97613352, -0.21547290, 5.78174467, -1.30185582, 0.16353243, -3.22682211, 0.03854496, 0.26751057, -0.11126973, 0.00000000, 14.55513146, 1.03556293, 10.76366487, -0.50012024, 0.02165584, -3.57321384, -0.58108720, 0.13084143, -0.01643563, 1.37533065, 0.32430782, -0.00387391, -0.02688582, 0.01118303, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.75932888, 1.66904592, 0.96362411, 1.36277029, 0.86736083, 2.28430636, 2.96226265, -1.00852845, 1.71026314, -2.01556444, 2.41867732, 2.04415543, 2.68821896, -0.52779866, 7.07977053, -1.76652740, 0.18283482, -3.12574097, -1.01990507, 0.90401661, 0.00000000, 0.00000000, 13.12665574, 0.00000000, 11.09404895, -0.63260762, 0.00000000, -2.86447112, -1.66605357, 0.31507575, 0.00000000, 0.99228190, 0.73556789, 0.18190907, -0.14700473, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.57359158, 1.49284005, -0.43094580, 3.04724700, 0.77579111, -0.12018504, 5.29905652, 0.03469443, -1.52970585, 0.90138782, 0.00000000, 0.00000000, 4.51561078, 0.00000000, -0.69955541, 6.36462844, 0.00000000, 0.20194425, -1.83730997, -2.74825341, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.89206303, 0.00000000, 0.00000000, -1.68739115, -3.09993548, 0.00000000, 0.00000000, 0.48710787, 0.89487429, 0.90395954, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62882204, 0.77261813, 3.86595114, -1.05140010, 9.15442906, 3.35889012, -0.30472470, 3.87851223, -1.52475169, 0.41467779, 0.00000000, -9.46260093, -2.07602937, 7.32969916, -0.76172468, 0.06910507, 0.56424050, -0.87956390, 0.34578118, -0.09404008, 0.00000000, 0.00000000, 0.00000000, 16.37452289, 0.95102718, 0.20864880, 9.05975064, -0.73666248, 0.07655621, -0.00694532, -3.48709965, -0.05670830, 0.08839950, -0.03475232, 0.00945138, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48690429, 0.70530063, 2.03602754, 1.15175111, -2.93221479, 1.81702705, 1.25178444, 0.65566316, 3.61359042, -1.70346286, 0.00000000, 2.76420266, -9.08783876, 1.78428514, 5.63152771, -0.74649407, -0.61809450, 2.03210252, -2.15494277, 0.76403348, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.00189227, 2.13860408, 0.00000000, 9.68367982, -1.32524448, 0.13314380, 0.00000000, -3.35452509, -0.47820641, 0.38435306, -0.12424167, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32992762, 0.63084006, 0.72843136, 2.57539377, 0.91792842, 0.71102430, 2.23926008, -0.20525504, 2.58567482, 0.76181175, 0.00000000, 0.00000000, 5.34294273, 0.00000000, 4.13862564, 2.68954640, 0.00000000, -1.19471831, 3.10562068, -2.32269807, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.88766278, 0.00000000, 0.00000000, 9.98274066, -1.30996183, 0.00000000, 0.00000000, -2.88176900, -1.51261363, 0.76398525, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.54632352, -0.10514001, 3.27118943, 0.00000000, 0.00000000, 2.69341127, 0.00000000, -0.51834724, 4.25171145, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.71889090, 0.00000000, 0.00000000, -1.29305116, 1.82865048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.45383520, 0.00000000, 0.00000000, 0.00000000, -1.81939143, -2.94058062, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, -6.78263088, 3.68560354, -0.81441102, 0.00000000, 10.02169076, 2.67510569, 6.00856531, -1.45362164, 0.32120804, 0.00000000, 0.00000000, 0.00000000, -7.57008074, -2.27270584, -0.60665695, 6.99294105, -1.36261453, 0.32965040, -0.07284314, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.71374045, 0.76082174, 0.22841553, 0.06097132, 5.40219154, -0.70281702, 0.13694791, -0.03313111, 0.00732101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 3.82426464, 2.20794022, 0.89214257, 0.00000000, -2.46306043, 6.78739641, 2.13307290, 3.91870514, -1.31949666, 0.00000000, 0.00000000, 0.00000000, 3.22490310, -7.63378456, -4.04762276, 1.11713920, 6.61105135, -2.33689609, 0.59181779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.50220765, 1.79642743, 0.72192923, 0.00000000, 6.06294258, -1.55575179, 0.41680604, -0.09623718, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03015751, -1.46593983, 1.12848101, 1.99489143, 0.00000000, 1.10151411, -5.20357020, 0.47696960, 4.00571021, 0.59009684, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.41153128, -6.24994106, 0.00000000, 2.77627448, 4.81120687, -1.79915419, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.46519533, 3.04407621, 0.00000000, 0.00000000, 6.69662602, -2.34333096, 0.59178043, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.89214257, 0.70530063, 0.40720551, 2.53385244, 0.00000000, 0.00000000, 3.47717900, 0.00000000, 2.00755023, 3.29336153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.67405085, 0.00000000, 0.00000000, 5.00796559, 1.41646657, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.20484876, 0.00000000, 0.00000000, 0.00000000, 7.04647272, -2.27776395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, 0.00000000, 0.00000000, 2.53908227, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.00713776, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.93924068, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.27677936, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.09901951, 0.00000000, -4.65474668, -3.29140294, 0.00000000, 0.00000000, 0.00000000, 13.49073756, 1.83585685, 1.29814683, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -3.53270435, -3.05941171, -0.41633320, -0.29439203, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.83269719, 0.35505015, 0.30748245, 0.04184306, 0.02958751, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.65985525, 0.00000000, 5.09901951, -2.06031501, 0.00000000, 0.00000000, 0.00000000, -1.23153021, 9.04986188, 3.04724700, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 3.86988372, -3.81689228, -5.39683035, -1.36674465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.00264918, 0.89821372, 0.96257231, 0.22225026, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.97380857, 0.00000000, -0.81441102, 5.75875553, 0.00000000, 0.00000000, 0.00000000, 1.37689264, -2.89087233, 1.70346286, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.01441410, -3.47218948, -5.19371077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.33149417, 1.69115345, 1.70832296, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.03015751, 0.00000000, 0.94040084, -2.92584077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 4.63623867, -3.80284633, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.56540113, -1.63559471, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.27313168, 2.63013526, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, 0.00000000, 0.00000000, 4.39781950, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.67261700, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.01911742, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.87170077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.56904652, 5.80288457, -2.01017818, -1.42141062, 8.14215223, -2.10229466, -1.71651641, 0.72825623, 0.59461873, 0.42045893, 9.81070844, -1.18450885, -1.02581476, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.09175166, -0.07491492, -0.05297285, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.26568606, 3.07059789, 1.77281052, -1.25356634, 2.39356777, 6.30376871, -0.90829511, -2.78313373, -0.52440442, 0.37080992, 1.23603308, 9.40174756, -0.30156119, -2.42752078, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.06606875, -0.04671766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.02649122, 2.74642625, -0.79282497, 2.24244764, 2.14087210, -0.33166248, 6.49923072, 0.09574271, -1.87616630, -2.15580611, 11.05541597, 0.00000000, 9.44035859, 0.00000000, -1.46249406, -2.04706526, 0.00000000, 0.42218567, 0.59093684, 0.52231931, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.91485422, 1.29756444, 3.74574589, -1.05945693, 0.40458680, 5.01426536, -0.38382474, 1.80936716, -1.10800658, 0.31339159, 0.00000000, 2.82521847, -0.05097315, 8.20651807, -0.63173806, 0.04835737, -2.84282125, -0.22795884, 0.13959571, -0.03948363, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.71269768, 1.16057691, 1.34011879, 1.89521417, 0.36187343, 1.96214169, 2.74642625, -0.56642152, 3.17129987, -1.82198871, 0.00000000, 11.05541597, 1.59571185, 0.00000000, 8.65223157, -0.86504296, 0.00000000, -2.49768411, -0.99886557, 0.44144039, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 1.00508909, -0.19342949, 3.55615783, -8.46157280, 0.00000000, 4.45964044, 0.00000000, -0.85825820, 2.67027286, 0.00000000, 0.00000000, 12.43734296, 0.00000000, 0.00000000, 8.42792824, 0.00000000, 0.00000000, -1.62195555, -2.29379153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 0.33502970, 4.06201920, -0.82065181, 0.00000000, 1.69926455, -0.09910312, 5.88642506, -1.20156148, 0.24275208, 0.00000000, 0.00000000, 0.00000000, 4.94413232, -0.21408721, 0.01248582, 5.13809303, -0.74161985, 0.15138252, -0.03058389, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32664992, 0.29965967, 2.07610310, 1.46802658, 0.00000000, 0.86849624, 0.70912421, 1.31624466, 4.91295663, -1.41130639, 0.00000000, 0.00000000, 0.00000000, 11.05541597, 3.82970843, -0.22335313, 0.00000000, 5.80409338, -1.54743589, 0.34193825, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.14891253, 0.25951289, 0.74914918, 2.75458801, 0.00000000, -8.46157280, 1.15147421, 0.00000000, 3.32401973, 2.06838446, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.43734296, 2.17608172, 0.00000000, 0.00000000, 6.28180682, -1.77676328, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.93808315, 7.62808987, 0.00000000, 3.11415465, 0.00000000, 0.00000000, -7.52139805, 0.00000000, 0.00000000, 5.52707621, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.21410624, 0.00000000, 0.00000000, 0.00000000, 5.80288457, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.85634884, 0.00000000, 2.68023758, -0.47380354, 0.00000000, 0.00000000, 0.00000000, 5.09779364, -0.79282497, 0.14015298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.91061172, -0.64226163, 0.09988656, -0.01765762, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.76594169, 0.00000000, 1.49829835, 0.84756554, 0.00000000, 0.00000000, 0.00000000, 1.62843045, 3.54562104, -0.81481812, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.05541597, 7.18070331, -1.11676566, 0.19741814, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.66332496, 0.00000000, 0.69203437, 1.59036213, 0.00000000, 0.00000000, 0.00000000, -8.46157280, 3.07059789, 1.19418233, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.43734296, 5.80288457, -1.02581476, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.54160256, 0.00000000, 7.62808987, 1.79795803, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -7.52139805, 3.19105894, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.21410624, 3.35029697, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-5.36159180, 0.00000000, 0.00000000, 8.89943818, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -5.26497863, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.58312395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.41593350, 5.72988941, -2.20543546, -1.55947837, 8.33749896, -2.76779954, -2.25989886, 1.06532654, 0.86983548, 0.61506656, 10.33311828, -2.18326972, -1.89076704, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.84905059, -1.16109782, -1.03851746, 0.24532669, 0.21942686, 0.19002924, -0.08144110, -0.07284314, -0.06308401, -0.05150788, 0.03134669, 0.02803734, 0.02428105, 0.01982539, 0.01401867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.18529408, 3.45525332, 0.99744572, -1.41060126, 3.23209353, 5.28531208, -1.36277029, -2.89087233, -0.39339790, 0.55634864, 2.33666429, 9.02784807, -0.73296992, -3.93352934, -1.19859612, 0.30904725, 1.64018416, 0.65558822, 0.08921426, -0.12616801, 1.19087439, 11.55277744, -0.23484360, -2.44096975, -0.90733287, 0.07366625, 0.81032873, 0.39533457, 0.12046344, -0.03106042, -0.31189567, -0.16484471, -0.06588910, -0.00896637, 0.01268036, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.99489143, 3.15420031, -1.09264704, 1.54523626, 2.95048422, -0.76181175, 5.59815020, 0.26389933, -1.93925612, -2.28543525, 2.13307290, -0.25753938, 9.14446135, 0.06649638, -2.36108977, -3.33842299, -0.02303502, 0.81790549, 1.15646365, 1.02505849, 13.04537536, 0.00000000, 11.57662221, 0.00000000, -1.39771879, -2.15192885, 0.00000000, 0.36088944, 0.55562564, 0.59543720, 0.00000000, -0.12501577, -0.19247437, -0.20626550, -0.16668769, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.92724822, 1.82834820, 2.99085909, -1.24403338, 0.95014619, 5.74064456, -0.72111026, -0.16996732, -1.17961073, 0.49065338, 0.29439203, 4.97613352, -0.21547290, 5.78174467, -1.30185582, 0.16353243, -3.22682211, 0.03854496, 0.26751057, -0.11126973, 0.00000000, 2.64638754, -0.02958751, 10.76366487, -0.50012024, 0.02165584, -3.57321384, -0.58108720, 0.13084143, -0.01643563, 1.37533065, 0.32430782, -0.00387391, -0.02688582, 0.01118303, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.75932888, 1.66904592, 0.96362411, 1.36277029, 0.86736083, 2.28430636, 2.96226265, -1.00852845, 1.71026314, -2.01556444, 0.26874192, 2.04415543, 2.68821896, -0.52779866, 7.07977053, -1.76652740, 0.18283482, -3.12574097, -1.01990507, 0.90401661, 0.00000000, 13.04537536, 1.45851730, 0.00000000, 11.09404895, -0.63260762, 0.00000000, -2.86447112, -1.66605357, 0.31507575, 0.00000000, 0.99228190, 0.73556789, 0.18190907, -0.14700473, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.57359158, 1.49284005, -0.43094580, 3.04724700, 0.77579111, -0.12018504, 5.29905652, 0.03469443, -1.52970585, 0.90138782, -10.57628374, 0.00000000, 4.51561078, 0.00000000, -0.69955541, 6.36462844, 0.00000000, 0.20194425, -1.83730997, -2.74825341, 0.00000000, 0.00000000, 14.34991289, 0.00000000, 0.00000000, 10.89206303, 0.00000000, 0.00000000, -1.68739115, -3.09993548, 0.00000000, 0.00000000, 0.48710787, 0.89487429, 0.90395954, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62882204, 0.77261813, 3.86595114, -1.05140010, 0.16060402, 3.35889012, -0.30472470, 3.87851223, -1.52475169, 0.41467779, 0.00000000, 1.13551211, -0.03642157, 7.32969916, -0.76172468, 0.06910507, 0.56424050, -0.87956390, 0.34578118, -0.09404008, 0.00000000, 0.00000000, 0.00000000, 4.46577897, -0.11412326, 0.00366051, 9.05975064, -0.73666248, 0.07655621, -0.00694532, -3.48709965, -0.05670830, 0.08839950, -0.03475232, 0.00945138, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48690429, 0.70530063, 2.03602754, 1.15175111, 0.14661074, 1.81702705, 1.25178444, 0.65566316, 3.61359042, -1.70346286, 0.00000000, 0.61426726, 0.45439194, 1.78428514, 5.63152771, -0.74649407, -0.61809450, 2.03210252, -2.15494277, 0.76403348, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 3.33375384, -0.10693020, 0.00000000, 9.68367982, -1.32524448, 0.13314380, 0.00000000, -3.35452509, -0.47820641, 0.38435306, -0.12424167, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32992762, 0.63084006, 0.72843136, 2.57539377, 0.13113263, 0.71102430, 2.23926008, -0.20525504, 2.58567482, 0.76181175, 0.00000000, -10.57628374, 0.76327753, 0.00000000, 4.13862564, 2.68954640, 0.00000000, -1.19471831, 3.10562068, -2.32269807, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 1.84109468, 0.00000000, 0.00000000, 9.98274066, -1.30996183, 0.00000000, 0.00000000, -2.88176900, -1.51261363, 0.76398525, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.54632352, -0.10514001, 3.27118943, 9.65295620, 0.00000000, 2.69341127, 0.00000000, -0.51834724, 4.25171145, 0.00000000, 0.00000000, -9.91526601, 0.00000000, 0.00000000, 6.71889090, 0.00000000, 0.00000000, -1.29305116, 1.82865048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 0.00000000, 0.00000000, 0.00000000, 9.45383520, 0.00000000, 0.00000000, 0.00000000, -1.81939143, -2.94058062, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, 0.19948914, 3.68560354, -0.81441102, 0.00000000, 1.02786572, -0.07867958, 6.00856531, -1.45362164, 0.32120804, 0.00000000, 0.00000000, 0.00000000, 3.02803230, -0.23309803, 0.01784285, 6.99294105, -1.36261453, 0.32965040, -0.07284314, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.80499653, -0.30432870, 0.02342723, -0.00179327, 5.40219154, -0.70281702, 0.13694791, -0.03313111, 0.00732101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.18210784, 2.20794022, 0.89214257, 0.00000000, 0.61576511, 0.32320935, 2.13307290, 3.91870514, -1.31949666, 0.00000000, 0.00000000, 0.00000000, 1.07496770, 1.90844614, -0.19274394, 1.11713920, 6.61105135, -2.33689609, 0.59181779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 5.83406922, -0.44910686, 0.03437758, 0.00000000, 6.06294258, -1.55575179, 0.41680604, -0.09623718, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03015751, 0.16288220, 1.12848101, 1.99489143, 0.00000000, 0.31471832, 0.57817447, 0.47696960, 4.00571021, 0.59009684, 0.00000000, 0.00000000, 0.00000000, -10.57628374, 1.83186608, 0.69443790, 0.00000000, 2.77627448, 4.81120687, -1.79915419, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 4.41862724, -0.33823069, 0.00000000, 0.00000000, 6.69662602, -2.34333096, 0.59178043, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.89214257, 0.14106013, 0.40720551, 2.53385244, 0.00000000, 9.65295620, 0.69543580, 0.00000000, 2.00755023, 3.29336153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -9.91526601, 1.73481017, 0.00000000, 0.00000000, 5.00796559, 1.41646657, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 2.44096975, 0.00000000, 0.00000000, 0.00000000, 7.04647272, -2.27776395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, -7.94708264, 0.00000000, 2.53908227, 0.00000000, 0.00000000, 10.22077716, 0.00000000, 0.00000000, 5.00713776, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -8.49879944, 0.00000000, 0.00000000, 0.00000000, 6.93924068, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.93739111, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.27677936, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, 0.00000000, 2.32737334, -0.47020042, 0.00000000, 0.00000000, 0.00000000, 4.49691252, -0.91792842, 0.18544955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.06540869, -1.01980390, 0.20816660, -0.04205600, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.92395327, -0.71010029, 0.10249415, -0.02092153, 0.00422679, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.66496381, 0.00000000, 1.45686272, 0.51507875, 0.00000000, 0.00000000, 0.00000000, 1.84729532, 2.58567482, -0.76181175, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.71994832, 5.72533842, -1.54195153, 0.34168616, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 9.33451075, -1.34732057, 0.27502066, -0.05556256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.59476171, 0.00000000, 0.81441102, 1.15175111, 0.00000000, 0.00000000, 0.00000000, 0.59009684, 2.89087233, 0.34069257, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -10.57628374, 3.43474890, 3.47218948, -1.03874215, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 8.28492607, -1.69115345, 0.34166459, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.51507875, 0.00000000, 0.37616034, 1.46292039, 0.00000000, 0.00000000, 0.00000000, 9.65295620, 1.85449547, 1.90142317, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -9.91526601, 4.62616045, 0.81779736, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 6.50925267, -1.31506763, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.42056004, 0.00000000, -7.94708264, 1.46593983, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.22077716, 2.89087233, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -8.49879944, 4.00637247, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.93739111, 3.62390026, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.54237886, 0.00000000, 0.00000000, -6.91050664, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.26493259, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -5.66586629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 20.49987556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, 0.00000000, -0.00704123, 0.00248945, 0.00000000, 0.00000000, 0.00000000, 0.00947126, -0.00515550, 0.00182275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00450938, -0.00292893, 0.00159431, -0.00056367, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00464479, -0.00332354, 0.00215870, -0.00117505, 0.00041544, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01276467, -0.00971041, 0.00694820, -0.00451299, 0.00245656, -0.00086853};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, -4.20458933, -3.43303281, 0.00000000, 0.00000000, 0.00000000, 19.62141687, 0.00000000, 0.00000000, 0.61167774, 0.52972846, 0.43252148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.53137212, 0.00000000, 3.54562104, -2.50713268, 4.78713554, 0.00000000, 0.00000000, -5.56626745, -1.04880885, 0.74161985, 0.00000000, 18.80349512, -0.60312239, 0.00000000, 0.00000000, 0.00000000, 1.68183573, 0.70128378, 0.13213749, -0.09343532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.05298244, 0.00000000, -1.58564993, 4.48489528, 4.28174419, 0.00000000, 0.00000000, 0.19148542, -3.75233261, -4.31161223, 0.00000000, 0.00000000, 18.88071719, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.84437134, 1.18187368, 1.04463862, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.59512887, 0.00000000, 0.00000000, 0.00000000, 10.02853073, -0.76764947, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.41303613, -1.26347611, 0.09671474, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.32115383, 0.00000000, 0.00000000, 0.00000000, 3.92428337, 5.49285250, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.30446314, -1.73008592, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.01017818, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.91928088, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.85585649, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.96647939, 0.00000000, 8.12403840, -1.64130361, 0.00000000, 0.00000000, 0.00000000, 11.77285012, -2.40312297, 0.48550416, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.27618606, -1.48323970, 0.30276504, -0.06116777, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.65329983, 0.00000000, 4.15220620, 2.93605316, 0.00000000, 0.00000000, 0.00000000, 2.63248932, 9.82591326, -2.82261277, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60818677, -3.09487177, 0.68387651, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29782506, 0.00000000, 1.49829835, 5.50917602, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.64803945, 4.13676893, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.56361364, -3.55352656, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87616630, 0.00000000, 0.00000000, 6.22830930, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.05415242, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.83186701, 0.00000000, -4.41087092, -3.11895674, 16.67499792, 0.00000000, 0.00000000, 2.13065308, 1.73967095, 1.23013313, 0.00000000, -4.36653944, -3.78153408, 0.00000000, 0.00000000, 0.00000000, -0.55793594, -0.48318670, -0.39452029, -0.27896797, 23.69810119, 0.00000000, 0.00000000, 0.49065338, 0.43885373, 0.38005848, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.06269339, 0.05607467, 0.04856209, 0.03965078, 0.02803734, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 6.91050664, 0.00000000, 0.00000000, 0.00000000, 10.57062417, -2.72554058, 0.00000000, 0.00000000, 0.00000000, 4.67332858, 0.00000000, 0.00000000, -7.86705868, -2.39719224, 0.61809450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 23.10555489, -0.46968719, 0.00000000, 0.00000000, 0.00000000, 1.62065746, 0.79066915, 0.24092688, -0.06212084, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 6.30840062, 0.00000000, 0.00000000, 0.00000000, -1.52362350, 11.19630041, 0.00000000, 0.00000000, 0.00000000, 4.26614580, 0.00000000, 0.00000000, 0.13299276, -4.72217954, -6.67684597, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 23.15324442, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.72177888, 1.11125128, 1.19087439, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.85449645, 0.00000000, 5.98171818, -2.48806676, 1.90029238, 0.00000000, 0.00000000, -0.33993463, -2.35922147, 0.98130676, 0.00000000, 9.95226703, -0.43094580, 0.00000000, 0.00000000, 0.00000000, -6.45364423, 0.07708993, 0.53502114, -0.22253946, 0.00000000, 0.00000000, 0.00000000, 21.52732974, -1.00024047, 0.04331168, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 2.75066130, 0.64861565, -0.00774783, -0.05377165, 0.02236606, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.51865775, 0.00000000, 1.92724822, 2.72554058, 1.73472167, 0.00000000, 0.00000000, -2.01705690, 3.42052628, -4.03112887, 0.00000000, 4.08831086, 5.37643792, 0.00000000, 0.00000000, 0.00000000, 0.36566964, -6.25148194, -2.03981014, 1.80803322, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 22.18809790, -1.26521524, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.98456381, 1.47113579, 0.36381814, -0.29400945, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.14718317, 0.00000000, -0.86189161, 6.09449400, 1.55158223, 0.00000000, 0.00000000, 0.06938887, -3.05941171, 1.80277564, 0.00000000, 0.00000000, 9.03122157, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.40388851, -3.67461995, -5.49650683, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.78412606, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.97421573, 1.78974859, 1.80791909, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.54523626, 0.00000000, 0.00000000, 0.00000000, 6.71778025, -0.60944940, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.65939832, -1.52344936, 0.13821013, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.11950128, -1.47332497, 0.15311242, -0.01389064, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.41060126, 0.00000000, 0.00000000, 0.00000000, 3.63405410, 2.50356888, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 3.56857028, 11.26305541, -1.49298815, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.36735965, -2.65048896, 0.26628761, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.26168012, 0.00000000, 0.00000000, 0.00000000, 1.42204860, 4.47852016, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.27725129, 5.37909281, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.96548132, -2.61992366, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.09264704, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.38682255, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.43778180, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.90767040, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.52336025, 0.00000000, 7.37120708, -1.62882204, 0.00000000, 0.00000000, 0.00000000, 12.01713063, -2.90724328, 0.64241607, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.98588209, -2.72522907, 0.65930080, -0.14568627, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.80438309, -1.40563404, 0.27389583, -0.06626222, 0.01464202, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.30350221, 0.00000000, 4.41588043, 1.78428514, 0.00000000, 0.00000000, 0.00000000, 4.26614580, 7.83741029, -2.63899331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 2.23427841, 13.22210271, -4.67379218, 1.18363558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.12588516, -3.11150358, 0.83361207, -0.19247437, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.06031501, 0.00000000, 2.25696202, 3.98978287, 0.00000000, 0.00000000, 0.00000000, 0.95393920, 8.01142042, 1.18019369, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.55254896, 9.62241374, -3.59830837, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.39325203, -4.68666193, 1.18356087, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.78428514, 0.00000000, 0.81441102, 5.06770487, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 4.01510047, 6.58672306, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.01593119, 2.83293315, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.09294544, -4.55552790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.45686272, 0.00000000, 0.00000000, 5.07816454, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.01427552, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.87848136, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.55355873, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats1[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.47722558, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 7.24568837, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 0.00000000, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.64575131, 0.00000000, 9.66091783, 0.68313005, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.24037035, 0.00000000, 0.00000000, 7.52994024, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 9.16515139, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 0.00000000, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, -5.69209979, 4.38178046, -0.77459667, 0.00000000, 10.99818167, 0.96214047, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 2.73861279, 1.58113883, 2.45967478, 0.00000000, 0.00000000, 9.25820100, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, 0.00000000, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.19615242, 0.00000000, -3.16227766, -2.23606798, 0.00000000, 0.00000000, 0.00000000, 13.74772708, 0.53452248, 0.37796447, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.80000000, 0.00000000, 3.65148372, -2.84018779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.34426800, 1.39659450, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.20454077, 0.00000000, 0.00000000, 6.64078309, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.97997773, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.56904652, 5.80288457, -2.01017818, -1.42141062, 8.14215223, -2.10229466, -1.71651641, 0.72825623, 0.59461873, 0.42045893, 9.81070844, -1.18450885, -1.02581476, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.09175166, -0.07491492, -0.05297285, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.26568606, 3.07059789, 1.77281052, -1.25356634, 2.39356777, 6.30376871, -0.90829511, -2.78313373, -0.52440442, 0.37080992, 11.12429773, 9.40174756, -0.30156119, -2.42752078, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.06606875, -0.04671766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.02649122, 2.74642625, -0.79282497, 2.24244764, 2.14087210, -0.33166248, 6.49923072, 0.09574271, -1.87616630, -2.15580611, 0.00000000, 0.00000000, 9.44035859, 0.00000000, -1.46249406, -2.04706526, 0.00000000, 0.42218567, 0.59093684, 0.52231931, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.91485422, 1.29756444, 3.74574589, -1.05945693, -8.09173594, 5.01426536, -0.38382474, 1.80936716, -1.10800658, 0.31339159, 0.00000000, 12.71348312, 1.01946290, 8.20651807, -0.63173806, 0.04835737, -2.84282125, -0.22795884, 0.13959571, -0.03948363, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.71269768, 1.16057691, 1.34011879, 1.89521417, 2.53311403, 1.96214169, 2.74642625, -0.56642152, 3.17129987, -1.82198871, 0.00000000, 0.00000000, 11.16998292, 0.00000000, 8.65223157, -0.86504296, 0.00000000, -2.49768411, -0.99886557, 0.44144039, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 1.00508909, -0.19342949, 3.55615783, 0.00000000, 0.00000000, 4.45964044, 0.00000000, -0.85825820, 2.67027286, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.42792824, 0.00000000, 0.00000000, -1.62195555, -2.29379153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 7.03562364, 4.06201920, -0.82065181, 0.00000000, -6.79705819, -2.08116554, 5.88642506, -1.20156148, 0.24275208, 0.00000000, 0.00000000, 0.00000000, 14.83239697, 0.85634884, 0.26220221, 5.13809303, -0.74161985, 0.15138252, -0.03058389, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32664992, -2.69693704, 2.07610310, 1.46802658, 0.00000000, 3.03973683, -6.38211788, 1.31624466, 4.91295663, -1.41130639, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.40397951, 2.01017818, 0.00000000, 5.80409338, -1.54743589, 0.34193825, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.14891253, 1.29756444, 0.74914918, 2.75458801, 0.00000000, 0.00000000, 5.75737105, 0.00000000, 3.32401973, 2.06838446, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.88040858, 0.00000000, 0.00000000, 6.28180682, -1.77676328, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.93808315, 0.00000000, 0.00000000, 3.11415465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.52707621, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.80288457, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.42539535, 0.00000000, 9.38083152, 1.89521417, 0.00000000, 0.00000000, 0.00000000, -3.39852909, -2.77488739, -0.56061191, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.79887637, 0.42817442, 0.34960295, 0.07063046, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.82970843, 0.00000000, -1.49829835, 4.23782771, 0.00000000, 0.00000000, 0.00000000, 3.79967104, -3.54562104, -4.07409061, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.75497439, 1.11676566, 0.98709071, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.32664992, 0.00000000, 1.73008592, -3.18072426, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.67649474, -2.38836465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.50721144, 2.05162952, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62480768, 0.00000000, 0.00000000, 5.39387408, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.57317681, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.05089091, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.41593350, 5.72988941, -2.20543546, -1.55947837, 8.33749896, -2.76779954, -2.25989886, 1.06532654, 0.86983548, 0.61506656, 10.33311828, -2.18326972, -1.89076704, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.84905059, -1.16109782, -1.03851746, 0.24532669, 0.21942686, 0.19002924, -0.08144110, -0.07284314, -0.06308401, -0.05150788, 0.03134669, 0.02803734, 0.02428105, 0.01982539, 0.01401867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.18529408, 3.45525332, 0.99744572, -1.41060126, 3.23209353, 5.28531208, -1.36277029, -2.89087233, -0.39339790, 0.55634864, 2.33666429, 9.02784807, -0.73296992, -3.93352934, -1.19859612, 0.30904725, 1.64018416, 0.65558822, 0.08921426, -0.12616801, 13.09961832, 11.55277744, -0.23484360, -2.44096975, -0.90733287, 0.07366625, 0.81032873, 0.39533457, 0.12046344, -0.03106042, -0.31189567, -0.16484471, -0.06588910, -0.00896637, 0.01268036, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.99489143, 3.15420031, -1.09264704, 1.54523626, 2.95048422, -0.76181175, 5.59815020, 0.26389933, -1.93925612, -2.28543525, 2.13307290, -0.25753938, 9.14446135, 0.06649638, -2.36108977, -3.33842299, -0.02303502, 0.81790549, 1.15646365, 1.02505849, 0.00000000, 0.00000000, 11.57662221, 0.00000000, -1.39771879, -2.15192885, 0.00000000, 0.36088944, 0.55562564, 0.59543720, 0.00000000, -0.12501577, -0.19247437, -0.20626550, -0.16668769, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.92724822, 1.82834820, 2.99085909, -1.24403338, 0.95014619, 5.74064456, -0.72111026, -0.16996732, -1.17961073, 0.49065338, -10.30372101, 4.97613352, -0.21547290, 5.78174467, -1.30185582, 0.16353243, -3.22682211, 0.03854496, 0.26751057, -0.11126973, 0.00000000, 14.55513146, 1.03556293, 10.76366487, -0.50012024, 0.02165584, -3.57321384, -0.58108720, 0.13084143, -0.01643563, 1.37533065, 0.32430782, -0.00387391, -0.02688582, 0.01118303, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.75932888, 1.66904592, 0.96362411, 1.36277029, 0.86736083, 2.28430636, 2.96226265, -1.00852845, 1.71026314, -2.01556444, 2.41867732, 2.04415543, 2.68821896, -0.52779866, 7.07977053, -1.76652740, 0.18283482, -3.12574097, -1.01990507, 0.90401661, 0.00000000, 0.00000000, 13.12665574, 0.00000000, 11.09404895, -0.63260762, 0.00000000, -2.86447112, -1.66605357, 0.31507575, 0.00000000, 0.99228190, 0.73556789, 0.18190907, -0.14700473, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.57359158, 1.49284005, -0.43094580, 3.04724700, 0.77579111, -0.12018504, 5.29905652, 0.03469443, -1.52970585, 0.90138782, 0.00000000, 0.00000000, 4.51561078, 0.00000000, -0.69955541, 6.36462844, 0.00000000, 0.20194425, -1.83730997, -2.74825341, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.89206303, 0.00000000, 0.00000000, -1.68739115, -3.09993548, 0.00000000, 0.00000000, 0.48710787, 0.89487429, 0.90395954, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62882204, 0.77261813, 3.86595114, -1.05140010, 9.15442906, 3.35889012, -0.30472470, 3.87851223, -1.52475169, 0.41467779, 0.00000000, -9.46260093, -2.07602937, 7.32969916, -0.76172468, 0.06910507, 0.56424050, -0.87956390, 0.34578118, -0.09404008, 0.00000000, 0.00000000, 0.00000000, 16.37452289, 0.95102718, 0.20864880, 9.05975064, -0.73666248, 0.07655621, -0.00694532, -3.48709965, -0.05670830, 0.08839950, -0.03475232, 0.00945138, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48690429, 0.70530063, 2.03602754, 1.15175111, -2.93221479, 1.81702705, 1.25178444, 0.65566316, 3.61359042, -1.70346286, 0.00000000, 2.76420266, -9.08783876, 1.78428514, 5.63152771, -0.74649407, -0.61809450, 2.03210252, -2.15494277, 0.76403348, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.00189227, 2.13860408, 0.00000000, 9.68367982, -1.32524448, 0.13314380, 0.00000000, -3.35452509, -0.47820641, 0.38435306, -0.12424167, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32992762, 0.63084006, 0.72843136, 2.57539377, 0.91792842, 0.71102430, 2.23926008, -0.20525504, 2.58567482, 0.76181175, 0.00000000, 0.00000000, 5.34294273, 0.00000000, 4.13862564, 2.68954640, 0.00000000, -1.19471831, 3.10562068, -2.32269807, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.88766278, 0.00000000, 0.00000000, 9.98274066, -1.30996183, 0.00000000, 0.00000000, -2.88176900, -1.51261363, 0.76398525, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.54632352, -0.10514001, 3.27118943, 0.00000000, 0.00000000, 2.69341127, 0.00000000, -0.51834724, 4.25171145, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.71889090, 0.00000000, 0.00000000, -1.29305116, 1.82865048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.45383520, 0.00000000, 0.00000000, 0.00000000, -1.81939143, -2.94058062, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, -6.78263088, 3.68560354, -0.81441102, 0.00000000, 10.02169076, 2.67510569, 6.00856531, -1.45362164, 0.32120804, 0.00000000, 0.00000000, 0.00000000, -7.57008074, -2.27270584, -0.60665695, 6.99294105, -1.36261453, 0.32965040, -0.07284314, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 18.71374045, 0.76082174, 0.22841553, 0.06097132, 5.40219154, -0.70281702, 0.13694791, -0.03313111, 0.00732101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 3.82426464, 2.20794022, 0.89214257, 0.00000000, -2.46306043, 6.78739641, 2.13307290, 3.91870514, -1.31949666, 0.00000000, 0.00000000, 0.00000000, 3.22490310, -7.63378456, -4.04762276, 1.11713920, 6.61105135, -2.33689609, 0.59181779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.50220765, 1.79642743, 0.72192923, 0.00000000, 6.06294258, -1.55575179, 0.41680604, -0.09623718, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03015751, -1.46593983, 1.12848101, 1.99489143, 0.00000000, 1.10151411, -5.20357020, 0.47696960, 4.00571021, 0.59009684, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.41153128, -6.24994106, 0.00000000, 2.77627448, 4.81120687, -1.79915419, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.46519533, 3.04407621, 0.00000000, 0.00000000, 6.69662602, -2.34333096, 0.59178043, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.89214257, 0.70530063, 0.40720551, 2.53385244, 0.00000000, 0.00000000, 3.47717900, 0.00000000, 2.00755023, 3.29336153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.67405085, 0.00000000, 0.00000000, 5.00796559, 1.41646657, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.20484876, 0.00000000, 0.00000000, 0.00000000, 7.04647272, -2.27776395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, 0.00000000, 0.00000000, 2.53908227, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 5.00713776, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.93924068, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.27677936, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.09901951, 0.00000000, -4.65474668, -3.29140294, 0.00000000, 0.00000000, 0.00000000, 13.49073756, 1.83585685, 1.29814683, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -3.53270435, -3.05941171, -0.41633320, -0.29439203, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.83269719, 0.35505015, 0.30748245, 0.04184306, 0.02958751, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-2.65985525, 0.00000000, 5.09901951, -2.06031501, 0.00000000, 0.00000000, 0.00000000, -1.23153021, 9.04986188, 3.04724700, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 3.86988372, -3.81689228, -5.39683035, -1.36674465, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 21.00264918, 0.89821372, 0.96257231, 0.22225026, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.97380857, 0.00000000, -0.81441102, 5.75875553, 0.00000000, 0.00000000, 0.00000000, 1.37689264, -2.89087233, 1.70346286, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.01441410, -3.47218948, -5.19371077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 19.33149417, 1.69115345, 1.70832296, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-1.03015751, 0.00000000, 0.94040084, -2.92584077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 4.63623867, -3.80284633, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.56540113, -1.63559471, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.27313168, 2.63013526, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, 0.00000000, 0.00000000, 4.39781950, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.67261700, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.01911742, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.87170077, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      static const double dmats2[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.16227766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.82574186, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.16397779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.95803989, 5.61248608, -1.08012345, -0.76376262, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29128785, 1.44913767, 4.18330013, -0.59160798, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87082869, 7.09929574, 0.00000000, 4.34741302, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32287566, 0.00000000, 3.86436713, -0.34156503, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.08012345, 0.00000000, 7.09929574, 2.50998008, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-3.81881308, 0.00000000, 0.00000000, 8.87411967, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.74954542, 5.79655070, -1.67332005, -1.18321596, 7.74596669, -1.20000000, -0.97979590, 0.34641016, 0.28284271, 0.20000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.32379001, 2.44948974, 2.82842712, -1.00000000, 1.30930734, 7.09929574, -0.41403934, -2.04939015, -0.47809144, 0.16903085, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.01246118, 2.12132034, -0.40824829, 3.17542648, 9.07114735, 0.00000000, 7.17137166, 0.00000000, -1.38013112, -1.56144012, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.80000000, 0.63245553, 4.38178046, -0.77459667, 0.00000000, 3.14233762, -0.10690450, 4.76235236, -0.74065608, 0.13093073, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.55884573, 0.54772256, 1.58113883, 2.45967478, 0.00000000, 9.07114735, 1.85164020, 0.00000000, 5.34522484, -1.20948631, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.27279221, -6.26099034, 0.00000000, 3.83405790, 0.00000000, 0.00000000, 10.58300524, 0.00000000, 0.00000000, 5.18459256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03923048, 0.00000000, 3.16227766, -0.44721360, 0.00000000, 0.00000000, 0.00000000, 5.89188304, -0.53452248, 0.07559289, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.90000000, 0.00000000, 1.46059349, 1.42009389, 0.00000000, 0.00000000, 0.00000000, 9.07114735, 4.93770720, -0.69829725, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.73484692, 0.00000000, -6.26099034, 2.21359436, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.58300524, 2.99332591, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.71576766, 0.00000000, 0.00000000, -4.69574275, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.69960629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.56904652, 5.80288457, -2.01017818, -1.42141062, 8.14215223, -2.10229466, -1.71651641, 0.72825623, 0.59461873, 0.42045893, 9.81070844, -1.18450885, -1.02581476, 0.30583887, 0.26486423, 0.21626074, -0.10594569, -0.09175166, -0.07491492, -0.05297285, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.26568606, 3.07059789, 1.77281052, -1.25356634, 2.39356777, 6.30376871, -0.90829511, -2.78313373, -0.52440442, 0.37080992, 1.23603308, 9.40174756, -0.30156119, -2.42752078, -0.79420021, 0.11443443, 0.84091787, 0.35064189, 0.06606875, -0.04671766, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.02649122, 2.74642625, -0.79282497, 2.24244764, 2.14087210, -0.33166248, 6.49923072, 0.09574271, -1.87616630, -2.15580611, 11.05541597, 0.00000000, 9.44035859, 0.00000000, -1.46249406, -2.04706526, 0.00000000, 0.42218567, 0.59093684, 0.52231931, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.91485422, 1.29756444, 3.74574589, -1.05945693, 0.40458680, 5.01426536, -0.38382474, 1.80936716, -1.10800658, 0.31339159, 0.00000000, 2.82521847, -0.05097315, 8.20651807, -0.63173806, 0.04835737, -2.84282125, -0.22795884, 0.13959571, -0.03948363, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.71269768, 1.16057691, 1.34011879, 1.89521417, 0.36187343, 1.96214169, 2.74642625, -0.56642152, 3.17129987, -1.82198871, 0.00000000, 11.05541597, 1.59571185, 0.00000000, 8.65223157, -0.86504296, 0.00000000, -2.49768411, -0.99886557, 0.44144039, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 1.00508909, -0.19342949, 3.55615783, -8.46157280, 0.00000000, 4.45964044, 0.00000000, -0.85825820, 2.67027286, 0.00000000, 0.00000000, 12.43734296, 0.00000000, 0.00000000, 8.42792824, 0.00000000, 0.00000000, -1.62195555, -2.29379153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48323970, 0.33502970, 4.06201920, -0.82065181, 0.00000000, 1.69926455, -0.09910312, 5.88642506, -1.20156148, 0.24275208, 0.00000000, 0.00000000, 0.00000000, 4.94413232, -0.21408721, 0.01248582, 5.13809303, -0.74161985, 0.15138252, -0.03058389, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32664992, 0.29965967, 2.07610310, 1.46802658, 0.00000000, 0.86849624, 0.70912421, 1.31624466, 4.91295663, -1.41130639, 0.00000000, 0.00000000, 0.00000000, 11.05541597, 3.82970843, -0.22335313, 0.00000000, 5.80409338, -1.54743589, 0.34193825, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.14891253, 0.25951289, 0.74914918, 2.75458801, 0.00000000, -8.46157280, 1.15147421, 0.00000000, 3.32401973, 2.06838446, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.43734296, 2.17608172, 0.00000000, 0.00000000, 6.28180682, -1.77676328, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.93808315, 7.62808987, 0.00000000, 3.11415465, 0.00000000, 0.00000000, -7.52139805, 0.00000000, 0.00000000, 5.52707621, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.21410624, 0.00000000, 0.00000000, 0.00000000, 5.80288457, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.85634884, 0.00000000, 2.68023758, -0.47380354, 0.00000000, 0.00000000, 0.00000000, 5.09779364, -0.79282497, 0.14015298, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.91061172, -0.64226163, 0.09988656, -0.01765762, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.76594169, 0.00000000, 1.49829835, 0.84756554, 0.00000000, 0.00000000, 0.00000000, 1.62843045, 3.54562104, -0.81481812, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.05541597, 7.18070331, -1.11676566, 0.19741814, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.66332496, 0.00000000, 0.69203437, 1.59036213, 0.00000000, 0.00000000, 0.00000000, -8.46157280, 3.07059789, 1.19418233, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.43734296, 5.80288457, -1.02581476, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.54160256, 0.00000000, 7.62808987, 1.79795803, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -7.52139805, 3.19105894, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.21410624, 3.35029697, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {-5.36159180, 0.00000000, 0.00000000, 8.89943818, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -5.26497863, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.58312395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.41593350, 5.72988941, -2.20543546, -1.55947837, 8.33749896, -2.76779954, -2.25989886, 1.06532654, 0.86983548, 0.61506656, 10.33311828, -2.18326972, -1.89076704, 0.72478005, 0.62767794, 0.51249689, -0.27896797, -0.24159335, -0.19726014, -0.13948399, 11.84905059, -1.16109782, -1.03851746, 0.24532669, 0.21942686, 0.19002924, -0.08144110, -0.07284314, -0.06308401, -0.05150788, 0.03134669, 0.02803734, 0.02428105, 0.01982539, 0.01401867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.18529408, 3.45525332, 0.99744572, -1.41060126, 3.23209353, 5.28531208, -1.36277029, -2.89087233, -0.39339790, 0.55634864, 2.33666429, 9.02784807, -0.73296992, -3.93352934, -1.19859612, 0.30904725, 1.64018416, 0.65558822, 0.08921426, -0.12616801, 1.19087439, 11.55277744, -0.23484360, -2.44096975, -0.90733287, 0.07366625, 0.81032873, 0.39533457, 0.12046344, -0.03106042, -0.31189567, -0.16484471, -0.06588910, -0.00896637, 0.01268036, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.99489143, 3.15420031, -1.09264704, 1.54523626, 2.95048422, -0.76181175, 5.59815020, 0.26389933, -1.93925612, -2.28543525, 2.13307290, -0.25753938, 9.14446135, 0.06649638, -2.36108977, -3.33842299, -0.02303502, 0.81790549, 1.15646365, 1.02505849, 13.04537536, 0.00000000, 11.57662221, 0.00000000, -1.39771879, -2.15192885, 0.00000000, 0.36088944, 0.55562564, 0.59543720, 0.00000000, -0.12501577, -0.19247437, -0.20626550, -0.16668769, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.92724822, 1.82834820, 2.99085909, -1.24403338, 0.95014619, 5.74064456, -0.72111026, -0.16996732, -1.17961073, 0.49065338, 0.29439203, 4.97613352, -0.21547290, 5.78174467, -1.30185582, 0.16353243, -3.22682211, 0.03854496, 0.26751057, -0.11126973, 0.00000000, 2.64638754, -0.02958751, 10.76366487, -0.50012024, 0.02165584, -3.57321384, -0.58108720, 0.13084143, -0.01643563, 1.37533065, 0.32430782, -0.00387391, -0.02688582, 0.01118303, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.75932888, 1.66904592, 0.96362411, 1.36277029, 0.86736083, 2.28430636, 2.96226265, -1.00852845, 1.71026314, -2.01556444, 0.26874192, 2.04415543, 2.68821896, -0.52779866, 7.07977053, -1.76652740, 0.18283482, -3.12574097, -1.01990507, 0.90401661, 0.00000000, 13.04537536, 1.45851730, 0.00000000, 11.09404895, -0.63260762, 0.00000000, -2.86447112, -1.66605357, 0.31507575, 0.00000000, 0.99228190, 0.73556789, 0.18190907, -0.14700473, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.57359158, 1.49284005, -0.43094580, 3.04724700, 0.77579111, -0.12018504, 5.29905652, 0.03469443, -1.52970585, 0.90138782, -10.57628374, 0.00000000, 4.51561078, 0.00000000, -0.69955541, 6.36462844, 0.00000000, 0.20194425, -1.83730997, -2.74825341, 0.00000000, 0.00000000, 14.34991289, 0.00000000, 0.00000000, 10.89206303, 0.00000000, 0.00000000, -1.68739115, -3.09993548, 0.00000000, 0.00000000, 0.48710787, 0.89487429, 0.90395954, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.62882204, 0.77261813, 3.86595114, -1.05140010, 0.16060402, 3.35889012, -0.30472470, 3.87851223, -1.52475169, 0.41467779, 0.00000000, 1.13551211, -0.03642157, 7.32969916, -0.76172468, 0.06910507, 0.56424050, -0.87956390, 0.34578118, -0.09404008, 0.00000000, 0.00000000, 0.00000000, 4.46577897, -0.11412326, 0.00366051, 9.05975064, -0.73666248, 0.07655621, -0.00694532, -3.48709965, -0.05670830, 0.08839950, -0.03475232, 0.00945138, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.48690429, 0.70530063, 2.03602754, 1.15175111, 0.14661074, 1.81702705, 1.25178444, 0.65566316, 3.61359042, -1.70346286, 0.00000000, 0.61426726, 0.45439194, 1.78428514, 5.63152771, -0.74649407, -0.61809450, 2.03210252, -2.15494277, 0.76403348, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 3.33375384, -0.10693020, 0.00000000, 9.68367982, -1.32524448, 0.13314380, 0.00000000, -3.35452509, -0.47820641, 0.38435306, -0.12424167, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.32992762, 0.63084006, 0.72843136, 2.57539377, 0.13113263, 0.71102430, 2.23926008, -0.20525504, 2.58567482, 0.76181175, 0.00000000, -10.57628374, 0.76327753, 0.00000000, 4.13862564, 2.68954640, 0.00000000, -1.19471831, 3.10562068, -2.32269807, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 1.84109468, 0.00000000, 0.00000000, 9.98274066, -1.30996183, 0.00000000, 0.00000000, -2.88176900, -1.51261363, 0.76398525, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.54632352, -0.10514001, 3.27118943, 9.65295620, 0.00000000, 2.69341127, 0.00000000, -0.51834724, 4.25171145, 0.00000000, 0.00000000, -9.91526601, 0.00000000, 0.00000000, 6.71889090, 0.00000000, 0.00000000, -1.29305116, 1.82865048, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 0.00000000, 0.00000000, 0.00000000, 9.45383520, 0.00000000, 0.00000000, 0.00000000, -1.81939143, -2.94058062, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.26168012, 0.19948914, 3.68560354, -0.81441102, 0.00000000, 1.02786572, -0.07867958, 6.00856531, -1.45362164, 0.32120804, 0.00000000, 0.00000000, 0.00000000, 3.02803230, -0.23309803, 0.01784285, 6.99294105, -1.36261453, 0.32965040, -0.07284314, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.80499653, -0.30432870, 0.02342723, -0.00179327, 5.40219154, -0.70281702, 0.13694791, -0.03313111, 0.00732101, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.15175111, 0.18210784, 2.20794022, 0.89214257, 0.00000000, 0.61576511, 0.32320935, 2.13307290, 3.91870514, -1.31949666, 0.00000000, 0.00000000, 0.00000000, 1.07496770, 1.90844614, -0.19274394, 1.11713920, 6.61105135, -2.33689609, 0.59181779, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 5.83406922, -0.44910686, 0.03437758, 0.00000000, 6.06294258, -1.55575179, 0.41680604, -0.09623718, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.03015751, 0.16288220, 1.12848101, 1.99489143, 0.00000000, 0.31471832, 0.57817447, 0.47696960, 4.00571021, 0.59009684, 0.00000000, 0.00000000, 0.00000000, -10.57628374, 1.83186608, 0.69443790, 0.00000000, 2.77627448, 4.81120687, -1.79915419, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 4.41862724, -0.33823069, 0.00000000, 0.00000000, 6.69662602, -2.34333096, 0.59178043, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.89214257, 0.14106013, 0.40720551, 2.53385244, 0.00000000, 9.65295620, 0.69543580, 0.00000000, 2.00755023, 3.29336153, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -9.91526601, 1.73481017, 0.00000000, 0.00000000, 5.00796559, 1.41646657, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 2.44096975, 0.00000000, 0.00000000, 0.00000000, 7.04647272, -2.27776395, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, -7.94708264, 0.00000000, 2.53908227, 0.00000000, 0.00000000, 10.22077716, 0.00000000, 0.00000000, 5.00713776, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -8.49879944, 0.00000000, 0.00000000, 0.00000000, 6.93924068, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.93739111, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.27677936, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.72843136, 0.00000000, 2.32737334, -0.47020042, 0.00000000, 0.00000000, 0.00000000, 4.49691252, -0.91792842, 0.18544955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 7.06540869, -1.01980390, 0.20816660, -0.04205600, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 9.92395327, -0.71010029, 0.10249415, -0.02092153, 0.00422679, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.66496381, 0.00000000, 1.45686272, 0.51507875, 0.00000000, 0.00000000, 0.00000000, 1.84729532, 2.58567482, -0.76181175, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.71994832, 5.72533842, -1.54195153, 0.34168616, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 13.04537536, 9.33451075, -1.34732057, 0.27502066, -0.05556256, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.59476171, 0.00000000, 0.81441102, 1.15175111, 0.00000000, 0.00000000, 0.00000000, 0.59009684, 2.89087233, 0.34069257, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -10.57628374, 3.43474890, 3.47218948, -1.03874215, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34991289, 8.28492607, -1.69115345, 0.34166459, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.51507875, 0.00000000, 0.37616034, 1.46292039, 0.00000000, 0.00000000, 0.00000000, 9.65295620, 1.85449547, 1.90142317, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -9.91526601, 4.62616045, 0.81779736, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 15.94434766, 6.50925267, -1.31506763, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.42056004, 0.00000000, -7.94708264, 1.46593983, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.22077716, 2.89087233, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -8.49879944, 4.00637247, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.93739111, 3.62390026, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.54237886, 0.00000000, 0.00000000, -6.91050664, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.26493259, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, -5.66586629, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 20.49987556, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.00000000;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[56][56] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[56][56] = \
      {{1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 1.00000000}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 56; t++)
        {
          for (unsigned int u = 0; u < 56; u++)
          {
            dmats[t][u] = 0.00000000;
            if (t == u)
            {
            dmats[t][u] = 1.00000000;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.00000000;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 56; t++)
          {
            for (unsigned int u = 0; u < 56; u++)
            {
              for (unsigned int tu = 0; tu < 56; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 56; s++)
        {
          for (unsigned int t = 0; t < 56; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues.
      double basisvalues[56] = {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000};
      
      // Declare helper variables.
      unsigned int rr = 0;
      unsigned int ss = 0;
      unsigned int tt = 0;
      double tmp5 = 0.00000000;
      double tmp6 = 0.00000000;
      double tmp7 = 0.00000000;
      double tmp0 = 0.50000000*(2.00000000 + Y + Z + 2.00000000*X);
      double tmp1 = 0.25000000*(Y + Z)*(Y + Z);
      double tmp2 = 0.50000000*(1.00000000 + Z + 2.00000000*Y);
      double tmp3 = 0.50000000*(1.00000000 - Z);
      double tmp4 = tmp3*tmp3;
      
      // Compute basisvalues.
      basisvalues[0] = 1.00000000;
      basisvalues[1] = tmp0;
      for (unsigned int r = 1; r < 5; r++)
      {
        rr = (r + 1)*((r + 1) + 1)*((r + 1) + 2)/6;
        ss = r*(r + 1)*(r + 2)/6;
        tt = (r - 1)*((r - 1) + 1)*((r - 1) + 2)/6;
        basisvalues[rr] = (basisvalues[ss]*tmp0*(1.00000000 + 2.00000000*r)/(1.00000000 + r) - basisvalues[tt]*tmp1*r/(1.00000000 + r));
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        rr = (r + 1)*(r + 1 + 1)*(r + 1 + 2)/6 + 1*(1 + 1)/2;
        ss = r*(r + 1)*(r + 2)/6;
        basisvalues[rr] = basisvalues[ss]*(r*(1.00000000 + Y) + (2.00000000 + Z + 3.00000000*Y)/2.00000000);
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 1; s < 5 - r; s++)
        {
          rr = (r + (s + 1))*(r + (s + 1) + 1)*(r + (s + 1) + 2)/6 + (s + 1)*((s + 1) + 1)/2;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          tt = (r + (s - 1))*(r + (s - 1) + 1)*(r + (s - 1) + 2)/6 + (s - 1)*((s - 1) + 1)/2;
          tmp5 = (2.00000000 + 2.00000000*r + 2.00000000*s)*(3.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp6 = (1.00000000 + 4.00000000*r*r + 4.00000000*r)*(2.00000000 + 2.00000000*r + 2.00000000*s)/(2.00000000*(1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          tmp7 = (1.00000000 + s + 2.00000000*r)*(3.00000000 + 2.00000000*r + 2.00000000*s)*s/((1.00000000 + 2.00000000*r + 2.00000000*s)*(1.00000000 + s)*(2.00000000 + s + 2.00000000*r));
          basisvalues[rr] = (basisvalues[ss]*(tmp2*tmp5 + tmp3*tmp6) - basisvalues[tt]*tmp4*tmp7);
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 5; r++)
      {
        for (unsigned int s = 0; s < 5 - r; s++)
        {
          rr = (r + s + 1)*(r + s + 1 + 1)*(r + s + 1 + 2)/6 + (s + 1)*(s + 1 + 1)/2 + 1;
          ss = (r + s)*(r + s + 1)*(r + s + 2)/6 + s*(s + 1)/2;
          basisvalues[rr] = basisvalues[ss]*(1.00000000 + r + s + Z*(2.00000000 + r + s));
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 4; r++)
      {
        for (unsigned int s = 0; s < 4 - r; s++)
        {
          for (unsigned int t = 1; t < 5 - r - s; t++)
          {
            rr = (r + s + t + 1)*(r + s + t + 1 + 1)*(r + s + t + 1 + 2)/6 + (s + t + 1)*(s + t + 1 + 1)/2 + t + 1;
            ss = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            tt = (r + s + t - 1)*(r + s + t - 1 + 1)*(r + s + t - 1 + 2)/6 + (s + t - 1)*(s + t - 1 + 1)/2 + t - 1;
            tmp5 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)/(2.00000000*(1.00000000 + t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp6 = (3.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(4.00000000 + 4.00000000*r*r + 4.00000000*s*s + 8.00000000*r*s + 8.00000000*r + 8.00000000*s)/(2.00000000*(1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            tmp7 = (2.00000000 + t + 2.00000000*r + 2.00000000*s)*(4.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*t/((1.00000000 + t)*(2.00000000 + 2.00000000*r + 2.00000000*s + 2.00000000*t)*(3.00000000 + t + 2.00000000*r + 2.00000000*s));
            basisvalues[rr] = (basisvalues[ss]*(tmp6 + Z*tmp5) - basisvalues[tt]*tmp7);
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      for (unsigned int r = 0; r < 6; r++)
      {
        for (unsigned int s = 0; s < 6 - r; s++)
        {
          for (unsigned int t = 0; t < 6 - r - s; t++)
          {
            rr = (r + s + t)*(r + s + t + 1)*(r + s + t + 2)/6 + (s + t)*(s + t + 1)/2 + t;
            basisvalues[rr] *= std::sqrt((0.50000000 + r)*(1.00000000 + r + s)*(1.50000000 + r + s + t));
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Table(s) of coefficients.
      static const double coefficients0[56] = \
      {0.00945067, 0.00000000, 0.00000000, -0.00746835, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01093647, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00563672, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00623163, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.01823904};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[56][56] = \
      {{0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {6.32455532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.22497216, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.58257569, 0.00000000, 8.36660027, -1.18321596, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.74165739, 0.00000000, 0.00000000, 8.69482605, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {5.49909083, 0.00000000, -3.34664011, -2.36643191, 15.49193338, 0.00000000, 0.00000000, 0.69282032, 0.56568542, 0.40000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.89897949, 0.00000000, 0.00000000, 0.00000000, 14.19859148, -0.82807867, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 4.24264069, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 14.34274331, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.60000000, 0.00000000, 8.76356092, -1.54919334, 0.00000000, 0.00000000, 0.00000000, 9.52470472, -1.48131216, 0.26186147, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {3.11769145, 0.00000000, 3.16227766, 4.91934955, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.69044968, -2.41897263, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.54558441, 0.00000000, 0.00000000, 7.66811581, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.36918512, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, -4.20458933, -3.43303281, 0.00000000, 0.00000000, 0.00000000, 19.62141687, 0.00000000, 0.00000000, 0.61167774, 0.52972846, 0.43252148, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.53137212, 0.00000000, 3.54562104, -2.50713268, 4.78713554, 0.00000000, 0.00000000, -5.56626745, -1.04880885, 0.74161985, 0.00000000, 18.80349512, -0.60312239, 0.00000000, 0.00000000, 0.00000000, 1.68183573, 0.70128378, 0.13213749, -0.09343532, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {4.05298244, 0.00000000, -1.58564993, 4.48489528, 4.28174419, 0.00000000, 0.00000000, 0.19148542, -3.75233261, -4.31161223, 0.00000000, 0.00000000, 18.88071719, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.84437134, 1.18187368, 1.04463862, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.59512887, 0.00000000, 0.00000000, 0.00000000, 10.02853073, -0.76764947, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.41303613, -1.26347611, 0.09671474, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.32115383, 0.00000000, 0.00000000, 0.00000000, 3.92428337, 5.49285250, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 17.30446314, -1.73008592, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 2.01017818, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 8.91928088, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 16.85585649, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.96647939, 0.00000000, 8.12403840, -1.64130361, 0.00000000, 0.00000000, 0.00000000, 11.77285012, -2.40312297, 0.48550416, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 10.27618606, -1.48323970, 0.30276504, -0.06116777, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.65329983, 0.00000000, 4.15220620, 2.93605316, 0.00000000, 0.00000000, 0.00000000, 2.63248932, 9.82591326, -2.82261277, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60818677, -3.09487177, 0.68387651, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {2.29782506, 0.00000000, 1.49829835, 5.50917602, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 6.64803945, 4.13676893, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 12.56361364, -3.55352656, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {1.87616630, 0.00000000, 0.00000000, 6.22830930, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.05415242, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 11.60576915, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000},
      {0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000000, 0.00000