// This code conforms with the UFC specification version 2.2.0
// and was automatically generated by FFC version 1.2.0.
// 
// This code was generated with the following parameters:
// 
//   cache_dir:                      ''
//   convert_exceptions_to_warnings: True
//   cpp_optimize:                   False
//   cpp_optimize_flags:             '-O2'
//   epsilon:                        1e-14
//   error_control:                  False
//   form_postfix:                   True
//   format:                         'ufc'
//   log_level:                      20
//   log_prefix:                     ''
//   optimize:                       True
//   output_dir:                     '.'
//   precision:                      '8'
//   quadrature_degree:              'auto'
//   quadrature_rule:                'auto'
//   representation:                 'quadrature'
//   split:                          False
//   swig_binary:                    'swig'
//   swig_path:                      ''

#ifndef __HYPERELASTICITY_H
#define __HYPERELASTICITY_H

#include <cmath>
#include <stdexcept>
#include <fstream>
#include <ufc.h>

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_0: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_0() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_0()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Real', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 0, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 1;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Reset values
    *values = 0.0;
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Compute value(s)
    for (unsigned int r = 0; r < 1; r++)
    {
      *values += coefficients0[r]*basisvalues[r];
    }// end loop over 'r'
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Element is constant, calling evaluate_basis.
    evaluate_basis(0, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    
    // Compute subdeterminants
    
    // Get coordinates and map to the reference (FIAT) element
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    
    // Array of basisvalues
    double basisvalues[1] = {0.0};
    
    // Declare helper variables
    
    // Compute basisvalues
    basisvalues[0] = 1.0;
    
    // Table(s) of coefficients
    static const double coefficients0[1] = \
    {1.0};
    
    // Tables of derivatives of the polynomial base (transpose).
    static const double dmats0[1][1] = \
    {{0.0}};
    
    static const double dmats1[1][1] = \
    {{0.0}};
    
    static const double dmats2[1][1] = \
    {{0.0}};
    
    // Compute reference derivatives.
    // Declare pointer to array of derivatives on FIAT element.
    double *derivatives = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      derivatives[r] = 0.0;
    }// end loop over 'r'
    
    // Declare derivative matrix (of polynomial basis).
    double dmats[1][1] = \
    {{1.0}};
    
    // Declare (auxiliary) derivative matrix (of polynomial basis).
    double dmats_old[1][1] = \
    {{1.0}};
    
    // Loop possible derivatives.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      // Resetting dmats values to compute next derivative.
      for (unsigned int t = 0; t < 1; t++)
      {
        for (unsigned int u = 0; u < 1; u++)
        {
          dmats[t][u] = 0.0;
          if (t == u)
          {
          dmats[t][u] = 1.0;
          }
          
        }// end loop over 'u'
      }// end loop over 't'
      
      // Looping derivative order to generate dmats.
      for (unsigned int s = 0; s < n; s++)
      {
        // Updating dmats_old with new values and resetting dmats.
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            dmats_old[t][u] = dmats[t][u];
            dmats[t][u] = 0.0;
          }// end loop over 'u'
        }// end loop over 't'
        
        // Update dmats using an inner product.
        if (combinations[r][s] == 0)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 1)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
        if (combinations[r][s] == 2)
        {
        for (unsigned int t = 0; t < 1; t++)
        {
          for (unsigned int u = 0; u < 1; u++)
          {
            for (unsigned int tu = 0; tu < 1; tu++)
            {
              dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
            }// end loop over 'tu'
          }// end loop over 'u'
        }// end loop over 't'
        }
        
      }// end loop over 's'
      for (unsigned int s = 0; s < 1; s++)
      {
        for (unsigned int t = 0; t < 1; t++)
        {
          derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
        }// end loop over 't'
      }// end loop over 's'
    }// end loop over 'r'
    
    // Transform derivatives back to physical element
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r] += transform[r][s]*derivatives[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer to array of derivatives on FIAT element
    delete [] derivatives;
    
    // Delete pointer to array of combinations of derivatives and transform
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] combinations[r];
    }// end loop over 'r'
    delete [] combinations;
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      delete [] transform[r];
    }// end loop over 'r'
    delete [] transform;
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Element is constant, calling evaluate_basis_derivatives.
    evaluate_basis_derivatives(0, n, values, x, vertex_coordinates, cell_orientation);
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
      y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
      y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    y[1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    y[2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[0];
    vertex_values[2] = dof_values[0];
    vertex_values[3] = dof_values[0];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_0();
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_1: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_1() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_1()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 4;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 0;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    return 1;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    *values = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        *values += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values = 0.0;
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis(r, &dof_values, x, vertex_coordinates, cell_orientation);
      values[r] = dof_values;
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[num_derivatives];
    for (unsigned int r = 0; r < num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 4; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < num_derivatives; s++)
      {
        values[r*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[1];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[1] = dof_values[1];
    vertex_values[2] = dof_values[2];
    vertex_values[3] = dof_values[3];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 0;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_1();
  }

};

/// This class defines the interface for a finite element.

class hyperelasticity_finite_element_2: public ufc::finite_element
{
public:

  /// Constructor
  hyperelasticity_finite_element_2() : ufc::finite_element()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_finite_element_2()
  {
    // Do nothing
  }

  /// Return a string identifying the finite element
  virtual const char* signature() const
  {
    return "VectorElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, 3, None)";
  }

  /// Return the cell shape
  virtual ufc::shape cell_shape() const
  {
    return ufc::tetrahedron;
  }

  /// Return the topological dimension of the cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the finite element function space
  virtual std::size_t space_dimension() const
  {
    return 12;
  }

  /// Return the rank of the value space
  virtual std::size_t value_rank() const
  {
    return 1;
  }

  /// Return the dimension of the value space for axis i
  virtual std::size_t value_dimension(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return 3;
        break;
      }
    }
    
    return 0;
  }

  /// Evaluate basis function i at given point x in cell
  virtual void evaluate_basis(std::size_t i,
                              double* values,
                              const double* x,
                              const double* vertex_coordinates,
                              int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Reset values
    values[0] = 0.0;
    values[1] = 0.0;
    values[2] = 0.0;
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[0] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[1] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Compute value(s)
      for (unsigned int r = 0; r < 4; r++)
      {
        values[2] += coefficients0[r]*basisvalues[r];
      }// end loop over 'r'
        break;
      }
    }
    
  }

  /// Evaluate all basis functions at given point x in cell
  virtual void evaluate_basis_all(double* values,
                                  const double* x,
                                  const double* vertex_coordinates,
                                  int cell_orientation) const
  {
    // Helper variable to hold values of a single dof.
    double dof_values[3] = {0.0, 0.0, 0.0};
    
    // Loop dofs and call evaluate_basis
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis(r, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3; s++)
      {
        values[r*3 + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
  }

  /// Evaluate order n derivatives of basis function i at given point x in cell
  virtual void evaluate_basis_derivatives(std::size_t i,
                                          std::size_t n,
                                          double* values,
                                          const double* x,
                                          const double* vertex_coordinates,
                                          int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    // Compute constants
    const double C0 = vertex_coordinates[9]  + vertex_coordinates[6] + vertex_coordinates[3]  - vertex_coordinates[0];
    const double C1 = vertex_coordinates[10] + vertex_coordinates[7] + vertex_coordinates[4]  - vertex_coordinates[1];
    const double C2 = vertex_coordinates[11] + vertex_coordinates[8] + vertex_coordinates[5]  - vertex_coordinates[2];
    
    // Compute subdeterminants
    const double d_00 = J[4]*J[8] - J[5]*J[7];
    const double d_01 = J[5]*J[6] - J[3]*J[8];
    const double d_02 = J[3]*J[7] - J[4]*J[6];
    const double d_10 = J[2]*J[7] - J[1]*J[8];
    const double d_11 = J[0]*J[8] - J[2]*J[6];
    const double d_12 = J[1]*J[6] - J[0]*J[7];
    const double d_20 = J[1]*J[5] - J[2]*J[4];
    const double d_21 = J[2]*J[3] - J[0]*J[5];
    const double d_22 = J[0]*J[4] - J[1]*J[3];
    
    // Get coordinates and map to the reference (FIAT) element
    double X = (d_00*(2.0*x[0] - C0) + d_10*(2.0*x[1] - C1) + d_20*(2.0*x[2] - C2)) / detJ;
    double Y = (d_01*(2.0*x[0] - C0) + d_11*(2.0*x[1] - C1) + d_21*(2.0*x[2] - C2)) / detJ;
    double Z = (d_02*(2.0*x[0] - C0) + d_12*(2.0*x[1] - C1) + d_22*(2.0*x[2] - C2)) / detJ;
    
    
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Declare pointer to two dimensional array that holds combinations of derivatives and initialise
    unsigned int **combinations = new unsigned int *[num_derivatives];
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      combinations[row] = new unsigned int [n];
      for (unsigned int col = 0; col < n; col++)
        combinations[row][col] = 0;
    }
    
    // Generate combinations of derivatives
    for (unsigned int row = 1; row < num_derivatives; row++)
    {
      for (unsigned int num = 0; num < row; num++)
      {
        for (unsigned int col = n-1; col+1 > 0; col--)
        {
          if (combinations[row][col] + 1 > 2)
            combinations[row][col] = 0;
          else
          {
            combinations[row][col] += 1;
            break;
          }
        }
      }
    }
    
    // Compute inverse of Jacobian
    const double Jinv[3][3] = {{K[0], K[1], K[2]}, {K[3], K[4], K[5]}, {K[6], K[7], K[8]}};
    
    // Declare transformation matrix
    // Declare pointer to two dimensional array and initialise
    double **transform = new double *[num_derivatives];
    
    for (unsigned int j = 0; j < num_derivatives; j++)
    {
      transform[j] = new double [num_derivatives];
      for (unsigned int k = 0; k < num_derivatives; k++)
        transform[j][k] = 1;
    }
    
    // Construct transformation matrix
    for (unsigned int row = 0; row < num_derivatives; row++)
    {
      for (unsigned int col = 0; col < num_derivatives; col++)
      {
        for (unsigned int k = 0; k < n; k++)
          transform[row][col] *= Jinv[combinations[col][k]][combinations[row][k]];
      }
    }
    
    // Reset values. Assuming that values is always an array.
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      values[r] = 0.0;
    }// end loop over 'r'
    
    switch (i)
    {
    case 0:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 1:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 2:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 3:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 4:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 5:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 6:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 7:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 8:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, -0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 9:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.18257419, -0.10540926, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 10:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.21081851, -0.074535599};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    case 11:
      {
        
      // Array of basisvalues
      double basisvalues[4] = {0.0, 0.0, 0.0, 0.0};
      
      // Declare helper variables
      double tmp0 = 0.5*(2.0 + Y + Z + 2.0*X);
      
      // Compute basisvalues
      basisvalues[0] = 1.0;
      basisvalues[1] = tmp0;
      basisvalues[2] = 0.5*(2.0 + 3.0*Y + Z)*basisvalues[0];
      basisvalues[3] = (2.0*Z + 1.0)*basisvalues[0];
      basisvalues[0] *= std::sqrt(0.75);
      basisvalues[3] *= std::sqrt(1.25);
      basisvalues[2] *= std::sqrt(2.5);
      basisvalues[1] *= std::sqrt(7.5);
      
      // Table(s) of coefficients
      static const double coefficients0[4] = \
      {0.28867513, 0.0, 0.0, 0.2236068};
      
      // Tables of derivatives of the polynomial base (transpose).
      static const double dmats0[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {6.3245553, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats1[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {5.4772256, 0.0, 0.0, 0.0},
      {0.0, 0.0, 0.0, 0.0}};
      
      static const double dmats2[4][4] = \
      {{0.0, 0.0, 0.0, 0.0},
      {3.1622777, 0.0, 0.0, 0.0},
      {1.8257419, 0.0, 0.0, 0.0},
      {5.1639778, 0.0, 0.0, 0.0}};
      
      // Compute reference derivatives.
      // Declare pointer to array of derivatives on FIAT element.
      double *derivatives = new double[num_derivatives];
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        derivatives[r] = 0.0;
      }// end loop over 'r'
      
      // Declare derivative matrix (of polynomial basis).
      double dmats[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Declare (auxiliary) derivative matrix (of polynomial basis).
      double dmats_old[4][4] = \
      {{1.0, 0.0, 0.0, 0.0},
      {0.0, 1.0, 0.0, 0.0},
      {0.0, 0.0, 1.0, 0.0},
      {0.0, 0.0, 0.0, 1.0}};
      
      // Loop possible derivatives.
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        // Resetting dmats values to compute next derivative.
        for (unsigned int t = 0; t < 4; t++)
        {
          for (unsigned int u = 0; u < 4; u++)
          {
            dmats[t][u] = 0.0;
            if (t == u)
            {
            dmats[t][u] = 1.0;
            }
            
          }// end loop over 'u'
        }// end loop over 't'
        
        // Looping derivative order to generate dmats.
        for (unsigned int s = 0; s < n; s++)
        {
          // Updating dmats_old with new values and resetting dmats.
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              dmats_old[t][u] = dmats[t][u];
              dmats[t][u] = 0.0;
            }// end loop over 'u'
          }// end loop over 't'
          
          // Update dmats using an inner product.
          if (combinations[r][s] == 0)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats0[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 1)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats1[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
          if (combinations[r][s] == 2)
          {
          for (unsigned int t = 0; t < 4; t++)
          {
            for (unsigned int u = 0; u < 4; u++)
            {
              for (unsigned int tu = 0; tu < 4; tu++)
              {
                dmats[t][u] += dmats2[t][tu]*dmats_old[tu][u];
              }// end loop over 'tu'
            }// end loop over 'u'
          }// end loop over 't'
          }
          
        }// end loop over 's'
        for (unsigned int s = 0; s < 4; s++)
        {
          for (unsigned int t = 0; t < 4; t++)
          {
            derivatives[r] += coefficients0[s]*dmats[s][t]*basisvalues[t];
          }// end loop over 't'
        }// end loop over 's'
      }// end loop over 'r'
      
      // Transform derivatives back to physical element
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        for (unsigned int s = 0; s < num_derivatives; s++)
        {
          values[2*num_derivatives + r] += transform[r][s]*derivatives[s];
        }// end loop over 's'
      }// end loop over 'r'
      
      // Delete pointer to array of derivatives on FIAT element
      delete [] derivatives;
      
      // Delete pointer to array of combinations of derivatives and transform
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] combinations[r];
      }// end loop over 'r'
      delete [] combinations;
      for (unsigned int r = 0; r < num_derivatives; r++)
      {
        delete [] transform[r];
      }// end loop over 'r'
      delete [] transform;
        break;
      }
    }
    
  }

  /// Evaluate order n derivatives of all basis functions at given point x in cell
  virtual void evaluate_basis_derivatives_all(std::size_t n,
                                              double* values,
                                              const double* x,
                                              const double* vertex_coordinates,
                                              int cell_orientation) const
  {
    // Compute number of derivatives.
    unsigned int num_derivatives = 1;
    for (unsigned int r = 0; r < n; r++)
    {
      num_derivatives *= 3;
    }// end loop over 'r'
    
    // Helper variable to hold values of a single dof.
    double *dof_values = new double[3*num_derivatives];
    for (unsigned int r = 0; r < 3*num_derivatives; r++)
    {
      dof_values[r] = 0.0;
    }// end loop over 'r'
    
    // Loop dofs and call evaluate_basis_derivatives.
    for (unsigned int r = 0; r < 12; r++)
    {
      evaluate_basis_derivatives(r, n, dof_values, x, vertex_coordinates, cell_orientation);
      for (unsigned int s = 0; s < 3*num_derivatives; s++)
      {
        values[r*3*num_derivatives + s] = dof_values[s];
      }// end loop over 's'
    }// end loop over 'r'
    
    // Delete pointer.
    delete [] dof_values;
  }

  /// Evaluate linear functional for dof i on the function f
  virtual double evaluate_dof(std::size_t i,
                              const ufc::function& f,
                              const double* vertex_coordinates,
                              int cell_orientation,
                              const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    switch (i)
    {
    case 0:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 1:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 2:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 3:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[0];
        break;
      }
    case 4:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 5:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 6:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 7:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[1];
        break;
      }
    case 8:
      {
        y[0] = vertex_coordinates[0];
      y[1] = vertex_coordinates[1];
      y[2] = vertex_coordinates[2];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 9:
      {
        y[0] = vertex_coordinates[3];
      y[1] = vertex_coordinates[4];
      y[2] = vertex_coordinates[5];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 10:
      {
        y[0] = vertex_coordinates[6];
      y[1] = vertex_coordinates[7];
      y[2] = vertex_coordinates[8];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    case 11:
      {
        y[0] = vertex_coordinates[9];
      y[1] = vertex_coordinates[10];
      y[2] = vertex_coordinates[11];
      f.evaluate(vals, y, c);
      return vals[2];
        break;
      }
    }
    
    return 0.0;
  }

  /// Evaluate linear functionals for all dofs on the function f
  virtual void evaluate_dofs(double* values,
                             const ufc::function& f,
                             const double* vertex_coordinates,
                             int cell_orientation,
                             const ufc::cell& c) const
  {
    // Declare variables for result of evaluation
    double vals[3];
    
    // Declare variable for physical coordinates
    double y[3];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[0] = vals[0];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[1] = vals[0];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[2] = vals[0];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[3] = vals[0];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[4] = vals[1];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[5] = vals[1];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[6] = vals[1];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[7] = vals[1];
    y[0] = vertex_coordinates[0];
    y[1] = vertex_coordinates[1];
    y[2] = vertex_coordinates[2];
    f.evaluate(vals, y, c);
    values[8] = vals[2];
    y[0] = vertex_coordinates[3];
    y[1] = vertex_coordinates[4];
    y[2] = vertex_coordinates[5];
    f.evaluate(vals, y, c);
    values[9] = vals[2];
    y[0] = vertex_coordinates[6];
    y[1] = vertex_coordinates[7];
    y[2] = vertex_coordinates[8];
    f.evaluate(vals, y, c);
    values[10] = vals[2];
    y[0] = vertex_coordinates[9];
    y[1] = vertex_coordinates[10];
    y[2] = vertex_coordinates[11];
    f.evaluate(vals, y, c);
    values[11] = vals[2];
  }

  /// Interpolate vertex values from dof values
  virtual void interpolate_vertex_values(double* vertex_values,
                                         const double* dof_values,
                                         const double* vertex_coordinates,
                                         int cell_orientation,
                                         const ufc::cell& c) const
  {
    // Evaluate function and change variables
    vertex_values[0] = dof_values[0];
    vertex_values[3] = dof_values[1];
    vertex_values[6] = dof_values[2];
    vertex_values[9] = dof_values[3];
    // Evaluate function and change variables
    vertex_values[1] = dof_values[4];
    vertex_values[4] = dof_values[5];
    vertex_values[7] = dof_values[6];
    vertex_values[10] = dof_values[7];
    // Evaluate function and change variables
    vertex_values[2] = dof_values[8];
    vertex_values[5] = dof_values[9];
    vertex_values[8] = dof_values[10];
    vertex_values[11] = dof_values[11];
  }

  /// Map coordinate xhat from reference cell to coordinate x in cell
  virtual void map_from_reference_cell(double* x,
                                       const double* xhat,
                                       const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_from_reference_cell not yet implemented." << std::endl;
  }

  /// Map from coordinate x in cell to coordinate xhat in reference cell
  virtual void map_to_reference_cell(double* xhat,
                                     const double* x,
                                     const ufc::cell& c) const
  {
    std::cerr << "*** FFC warning: " << "map_to_reference_cell not yet implemented." << std::endl;
  }

  /// Return the number of sub elements (for a mixed element)
  virtual std::size_t num_sub_elements() const
  {
    return 3;
  }

  /// Create a new finite element for sub element i (for a mixed element)
  virtual ufc::finite_element* create_sub_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::finite_element* create() const
  {
    return new hyperelasticity_finite_element_2();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_0: public ufc::dofmap
{
public:

  /// Constructor
  hyperelasticity_dofmap_0() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_0()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Real', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 0, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return false;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return 1;
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 1;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 1;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 0;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 0;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 1;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = 0;
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        if (i > 0)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (0)" << std::endl;
      }
      
      dofs[0] = 0;
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = 0.25*vertex_coordinates[0] + 0.25*vertex_coordinates[3] + 0.25*vertex_coordinates[6] + 0.25*vertex_coordinates[9];
    dof_coordinates[0][1] = 0.25*vertex_coordinates[1] + 0.25*vertex_coordinates[4] + 0.25*vertex_coordinates[7] + 0.25*vertex_coordinates[10];
    dof_coordinates[0][2] = 0.25*vertex_coordinates[2] + 0.25*vertex_coordinates[5] + 0.25*vertex_coordinates[8] + 0.25*vertex_coordinates[11];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_0();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_1: public ufc::dofmap
{
public:

  /// Constructor
  hyperelasticity_dofmap_1() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_1()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for FiniteElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return num_global_entities[0];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 4;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 4;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 3;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 1;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    dofs[0] = c.entity_indices[0][0];
    dofs[1] = c.entity_indices[0][1];
    dofs[2] = c.entity_indices[0][2];
    dofs[3] = c.entity_indices[0][3];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[0][2] = vertex_coordinates[2];
    dof_coordinates[1][0] = vertex_coordinates[3];
    dof_coordinates[1][1] = vertex_coordinates[4];
    dof_coordinates[1][2] = vertex_coordinates[5];
    dof_coordinates[2][0] = vertex_coordinates[6];
    dof_coordinates[2][1] = vertex_coordinates[7];
    dof_coordinates[2][2] = vertex_coordinates[8];
    dof_coordinates[3][0] = vertex_coordinates[9];
    dof_coordinates[3][1] = vertex_coordinates[10];
    dof_coordinates[3][2] = vertex_coordinates[11];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 0;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_1();
  }

};

/// This class defines the interface for a local-to-global mapping of
/// degrees of freedom (dofs).

class hyperelasticity_dofmap_2: public ufc::dofmap
{
public:

  /// Constructor
  hyperelasticity_dofmap_2() : ufc::dofmap()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_dofmap_2()
  {
    // Do nothing
  }

  /// Return a string identifying the dofmap
  virtual const char* signature() const
  {
    return "FFC dofmap for VectorElement('Lagrange', Domain(Cell('tetrahedron', 3), 'tetrahedron_multiverse', 3, 3), 1, 3, None)";
  }

  /// Return true iff mesh entities of topological dimension d are needed
  virtual bool needs_mesh_entities(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return true;
        break;
      }
    case 1:
      {
        return false;
        break;
      }
    case 2:
      {
        return false;
        break;
      }
    case 3:
      {
        return false;
        break;
      }
    }
    
    return false;
  }

  /// Return the topological dimension of the associated cell shape
  virtual std::size_t topological_dimension() const
  {
    return 3;
  }

  /// Return the geometric dimension of the associated cell shape
  virtual std::size_t geometric_dimension() const
  {
    return 3;
  }

  /// Return the dimension of the global finite element function space
  virtual std::size_t global_dimension(const std::vector<std::size_t>&
                                       num_global_entities) const
  {
    return 3*num_global_entities[0];
  }

  /// Return the dimension of the local finite element function space for a cell
  virtual std::size_t local_dimension(const ufc::cell& c) const
  {
    return 12;
  }

  /// Return the maximum dimension of the local finite element function space
  virtual std::size_t max_local_dimension() const
  {
    return 12;
  }

  /// Return the number of dofs on each cell facet
  virtual std::size_t num_facet_dofs() const
  {
    return 9;
  }

  /// Return the number of dofs associated with each cell entity of dimension d
  virtual std::size_t num_entity_dofs(std::size_t d) const
  {
    switch (d)
    {
    case 0:
      {
        return 3;
        break;
      }
    case 1:
      {
        return 0;
        break;
      }
    case 2:
      {
        return 0;
        break;
      }
    case 3:
      {
        return 0;
        break;
      }
    }
    
    return 0;
  }

  /// Tabulate the local-to-global mapping of dofs on a cell
  virtual void tabulate_dofs(std::size_t* dofs,
                             const std::vector<std::size_t>& num_global_entities,
                             const ufc::cell& c) const
  {
    unsigned int offset = 0;
    dofs[0] = offset + c.entity_indices[0][0];
    dofs[1] = offset + c.entity_indices[0][1];
    dofs[2] = offset + c.entity_indices[0][2];
    dofs[3] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[4] = offset + c.entity_indices[0][0];
    dofs[5] = offset + c.entity_indices[0][1];
    dofs[6] = offset + c.entity_indices[0][2];
    dofs[7] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
    dofs[8] = offset + c.entity_indices[0][0];
    dofs[9] = offset + c.entity_indices[0][1];
    dofs[10] = offset + c.entity_indices[0][2];
    dofs[11] = offset + c.entity_indices[0][3];
    offset += num_global_entities[0];
  }

  /// Tabulate the local-to-local mapping from facet dofs to cell dofs
  virtual void tabulate_facet_dofs(std::size_t* dofs,
                                   std::size_t facet) const
  {
    switch (facet)
    {
    case 0:
      {
        dofs[0] = 1;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 5;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 9;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 1:
      {
        dofs[0] = 0;
      dofs[1] = 2;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 6;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 10;
      dofs[8] = 11;
        break;
      }
    case 2:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 3;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 7;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 11;
        break;
      }
    case 3:
      {
        dofs[0] = 0;
      dofs[1] = 1;
      dofs[2] = 2;
      dofs[3] = 4;
      dofs[4] = 5;
      dofs[5] = 6;
      dofs[6] = 8;
      dofs[7] = 9;
      dofs[8] = 10;
        break;
      }
    }
    
  }

  /// Tabulate the local-to-local mapping of dofs on entity (d, i)
  virtual void tabulate_entity_dofs(std::size_t* dofs,
                                    std::size_t d, std::size_t i) const
  {
    if (d > 3)
    {
    std::cerr << "*** FFC warning: " << "d is larger than dimension (3)" << std::endl;
    }
    
    switch (d)
    {
    case 0:
      {
        if (i > 3)
      {
      std::cerr << "*** FFC warning: " << "i is larger than number of entities (3)" << std::endl;
      }
      
      switch (i)
      {
      case 0:
        {
          dofs[0] = 0;
        dofs[1] = 4;
        dofs[2] = 8;
          break;
        }
      case 1:
        {
          dofs[0] = 1;
        dofs[1] = 5;
        dofs[2] = 9;
          break;
        }
      case 2:
        {
          dofs[0] = 2;
        dofs[1] = 6;
        dofs[2] = 10;
          break;
        }
      case 3:
        {
          dofs[0] = 3;
        dofs[1] = 7;
        dofs[2] = 11;
          break;
        }
      }
      
        break;
      }
    case 1:
      {
        
        break;
      }
    case 2:
      {
        
        break;
      }
    case 3:
      {
        
        break;
      }
    }
    
  }

  /// Tabulate the coordinates of all dofs on a cell
  virtual void tabulate_coordinates(double** dof_coordinates,
                                    const double* vertex_coordinates) const
  {
    dof_coordinates[0][0] = vertex_coordinates[0];
    dof_coordinates[0][1] = vertex_coordinates[1];
    dof_coordinates[0][2] = vertex_coordinates[2];
    dof_coordinates[1][0] = vertex_coordinates[3];
    dof_coordinates[1][1] = vertex_coordinates[4];
    dof_coordinates[1][2] = vertex_coordinates[5];
    dof_coordinates[2][0] = vertex_coordinates[6];
    dof_coordinates[2][1] = vertex_coordinates[7];
    dof_coordinates[2][2] = vertex_coordinates[8];
    dof_coordinates[3][0] = vertex_coordinates[9];
    dof_coordinates[3][1] = vertex_coordinates[10];
    dof_coordinates[3][2] = vertex_coordinates[11];
    dof_coordinates[4][0] = vertex_coordinates[0];
    dof_coordinates[4][1] = vertex_coordinates[1];
    dof_coordinates[4][2] = vertex_coordinates[2];
    dof_coordinates[5][0] = vertex_coordinates[3];
    dof_coordinates[5][1] = vertex_coordinates[4];
    dof_coordinates[5][2] = vertex_coordinates[5];
    dof_coordinates[6][0] = vertex_coordinates[6];
    dof_coordinates[6][1] = vertex_coordinates[7];
    dof_coordinates[6][2] = vertex_coordinates[8];
    dof_coordinates[7][0] = vertex_coordinates[9];
    dof_coordinates[7][1] = vertex_coordinates[10];
    dof_coordinates[7][2] = vertex_coordinates[11];
    dof_coordinates[8][0] = vertex_coordinates[0];
    dof_coordinates[8][1] = vertex_coordinates[1];
    dof_coordinates[8][2] = vertex_coordinates[2];
    dof_coordinates[9][0] = vertex_coordinates[3];
    dof_coordinates[9][1] = vertex_coordinates[4];
    dof_coordinates[9][2] = vertex_coordinates[5];
    dof_coordinates[10][0] = vertex_coordinates[6];
    dof_coordinates[10][1] = vertex_coordinates[7];
    dof_coordinates[10][2] = vertex_coordinates[8];
    dof_coordinates[11][0] = vertex_coordinates[9];
    dof_coordinates[11][1] = vertex_coordinates[10];
    dof_coordinates[11][2] = vertex_coordinates[11];
  }

  /// Return the number of sub dofmaps (for a mixed element)
  virtual std::size_t num_sub_dofmaps() const
  {
    return 3;
  }

  /// Create a new dofmap for sub dofmap i (for a mixed element)
  virtual ufc::dofmap* create_sub_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_1();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new class instance
  virtual ufc::dofmap* create() const
  {
    return new hyperelasticity_dofmap_2();
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_0_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_0_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_0_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell volume
    
    // Compute circumradius
    
    
    // Facet area (divide by two because 'det' is scaled by area of reference triangle)
    
    // Array of quadrature weights.
    static const double W1 = 0.16666667;
    // Quadrature points on the UFC reference element: (0.25, 0.25, 0.25)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0_D001[1][2] = \
    {{-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc9[2] = {8, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc10[2] = {8, 10};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc11[2] = {8, 9};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 144; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 6123.
    double G[192];
    G[0] = W1*det*(K[5]*K[5]*w[2][0] + w[1][0]*(2.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4]));
    G[1] = W1*det*(2.0*K[3]*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[0]*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[2] = K[3]*W1*det*(2.0*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[3] = W1*det*(2.0*K[3]*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[6]*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[4] = W1*det*(2.0*K[4]*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[1]*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[5] = K[4]*W1*det*(2.0*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[6] = W1*det*(2.0*K[4]*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[7]*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[7] = W1*det*(K[2]*(K[3]*K[3]*(w[2][0] + 2.0*w[1][0]) + K[4]*K[4]*(w[2][0] + 2.0*w[1][0])) + K[5]*(w[1][0]*(4.0*(K[0]*K[3] + K[1]*K[4]) + 6.0*K[2]*K[5]) + w[2][0]*(2.0*(K[0]*K[3] + K[1]*K[4]) + 3.0*K[2]*K[5])));
    G[8] = K[5]*W1*det*(3.0*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + 6.0*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[9] = W1*det*(K[5]*(K[3]*K[6]*(2.0*w[2][0] + 4.0*w[1][0]) + K[4]*K[7]*(2.0*w[2][0] + 4.0*w[1][0])) + K[8]*(w[1][0]*(2.0*(K[3]*K[3] + K[4]*K[4]) + 6.0*K[5]*K[5]) + w[2][0]*(3.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4])));
    G[10] = W1*det*(0.5*w[2][0]*(K[3]*K[3]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])) + w[1][0]*(K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(2.0*K[0]*K[3] + K[1]*K[4]) + K[2]*K[5]*(2.0*(K[0]*K[3] + K[1]*K[4]) + K[2]*K[5])));
    G[11] = W1*det*(2.0*w[1][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[2][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[12] = W1*det*(2.0*w[1][0]*(K[0]*K[3]*K[3]*K[6] + K[4]*(K[1]*K[3]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[2][0]*(K[3]*K[3]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*K[4]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[5]*K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[13] = W1*det*(K[3]*K[3]*K[3]*K[3]*(w[1][0] + 0.5*w[2][0]) + K[4]*K[4]*(K[3]*K[3]*(w[2][0] + 2.0*w[1][0]) + K[4]*K[4]*(w[1][0] + 0.5*w[2][0])) + K[5]*K[5]*(w[1][0]*(2.0*(K[3]*K[3] + K[4]*K[4]) + K[5]*K[5]) + w[2][0]*(0.5*K[5]*K[5] + K[3]*K[3] + K[4]*K[4])));
    G[14] = W1*det*(2.0*w[1][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))) + w[2][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))));
    G[15] = W1*det*(0.5*w[2][0]*(K[6]*K[6]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5])) + w[1][0]*(K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(2.0*K[3]*K[6] + K[4]*K[7]) + K[5]*K[8]*(2.0*(K[3]*K[6] + K[4]*K[7]) + K[5]*K[8])));
    G[16] = W1*det*(w[1][0]*(4.0*K[0]*K[1]*K[3]*K[4] + K[3]*K[3]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + K[5]*(4.0*K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]))) + w[2][0]*(0.5*(K[3]*K[3]*(K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1])) + 1.5*K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(1.5*K[1]*K[4] + 2.0*K[0]*K[3]) + K[2]*K[5]*(1.5*K[2]*K[5] + 2.0*(K[0]*K[3] + K[1]*K[4]))));
    G[17] = W1*det*(3.0*w[2][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + 6.0*w[1][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[18] = W1*det*(w[1][0]*(K[3]*K[3]*(2.0*(K[1]*K[7] + K[2]*K[8]) + 6.0*K[0]*K[6]) + K[4]*(4.0*K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(2.0*(K[0]*K[6] + K[2]*K[8]) + 6.0*K[1]*K[7])) + K[5]*(4.0*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(2.0*(K[0]*K[6] + K[1]*K[7]) + 6.0*K[2]*K[8]))) + w[2][0]*(K[3]*K[3]*(3.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*(2.0*K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(3.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])) + K[5]*(2.0*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(3.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]))));
    G[19] = W1*det*(K[3]*K[3]*K[3]*K[3]*(1.5*w[2][0] + 3.0*w[1][0]) + K[4]*K[4]*(K[3]*K[3]*(3.0*w[2][0] + 6.0*w[1][0]) + K[4]*K[4]*(1.5*w[2][0] + 3.0*w[1][0])) + K[5]*K[5]*(w[1][0]*(3.0*K[5]*K[5] + 6.0*(K[3]*K[3] + K[4]*K[4])) + w[2][0]*(1.5*K[5]*K[5] + 3.0*(K[3]*K[3] + K[4]*K[4]))));
    G[20] = W1*det*(3.0*w[2][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))) + 6.0*w[1][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))));
    G[21] = W1*det*(w[1][0]*(4.0*K[3]*K[4]*K[6]*K[7] + K[6]*K[6]*(3.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(3.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5]) + K[8]*(4.0*K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(3.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4]))) + w[2][0]*(0.5*(K[6]*K[6]*(K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4])) + 1.5*K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(1.5*K[4]*K[7] + 2.0*K[3]*K[6]) + K[5]*K[8]*(1.5*K[5]*K[8] + 2.0*(K[3]*K[6] + K[4]*K[7]))));
    G[22] = W1*det*(K[2]*K[5]*w[2][0] + w[1][0]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]));
    G[23] = W1*det*(K[0]*(w[1][0]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[3]*w[1][0]*(K[1]*K[1] + K[2]*K[2]));
    G[24] = W1*det*(K[0]*w[1][0]*(K[4]*K[4] + K[5]*K[5]) + K[3]*(w[1][0]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[25] = W1*det*(K[6]*w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[1][0]*(K[0]*(K[4]*K[7] + K[5]*K[8]) + K[3]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[26] = W1*det*(K[1]*(w[1][0]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]) + w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[4]*w[1][0]*(K[0]*K[0] + K[2]*K[2]));
    G[27] = W1*det*(K[1]*w[1][0]*(K[3]*K[3] + K[5]*K[5]) + K[4]*(w[1][0]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]) + w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[28] = W1*det*(K[7]*w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[1][0]*(K[1]*(K[3]*K[6] + K[5]*K[8]) + K[4]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])));
    G[29] = W1*det*(K[2]*(K[0]*K[3]*(2.0*w[2][0] + 4.0*w[1][0]) + K[1]*K[4]*(2.0*w[2][0] + 4.0*w[1][0])) + K[5]*(w[1][0]*(2.0*(K[0]*K[0] + K[1]*K[1]) + 6.0*K[2]*K[2]) + w[2][0]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1])));
    G[30] = W1*det*(w[1][0]*(2.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + 6.0*K[2]*K[5]*K[8]) + w[2][0]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(3.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4])));
    G[31] = W1*det*(0.5*w[2][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[1][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[32] = W1*det*(w[1][0]*(2.0*(K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(K[0]*K[3] + K[1]*K[4]) + K[2]*K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[3]*K[3]*(K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1])) + w[2][0]*(K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(2.0*K[0]*K[3] + K[1]*K[4]) + K[2]*K[5]*(2.0*(K[0]*K[3] + K[1]*K[4]) + K[2]*K[5])));
    G[33] = W1*det*(w[1][0]*(K[0]*K[0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[1]*(K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8])) + K[2]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[2][0]*(K[0]*K[0]*K[3]*K[6] + K[1]*(K[0]*K[4]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[34] = W1*det*(0.5*w[2][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[1][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[35] = W1*det*(w[1][0]*(K[3]*K[3]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*(K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])) + K[5]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[2][0]*(K[0]*K[3]*K[3]*K[6] + K[4]*(K[1]*K[3]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[36] = W1*det*(0.5*w[2][0]*(K[6]*K[6]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*K[7]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[8]*K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + w[1][0]*(K[0]*K[3]*K[6]*K[6] + K[7]*(K[1]*K[4]*K[7] + K[6]*(K[0]*K[4] + K[1]*K[3])) + K[8]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[37] = W1*det*(1.5*w[2][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + 3.0*w[1][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[38] = W1*det*(w[1][0]*(2.0*(K[3]*K[3]*(K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1])) + 6.0*K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(6.0*K[1]*K[4] + 8.0*K[0]*K[3]) + K[2]*K[5]*(6.0*K[2]*K[5] + 8.0*(K[0]*K[3] + K[1]*K[4]))) + w[2][0]*(4.0*K[0]*K[1]*K[3]*K[4] + K[3]*K[3]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + K[5]*(4.0*K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]))));
    G[39] = W1*det*(w[1][0]*(K[0]*K[0]*(2.0*(K[4]*K[7] + K[5]*K[8]) + 6.0*K[3]*K[6]) + K[1]*(4.0*K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(2.0*(K[3]*K[6] + K[5]*K[8]) + 6.0*K[4]*K[7])) + K[2]*(4.0*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(2.0*(K[3]*K[6] + K[4]*K[7]) + 6.0*K[5]*K[8]))) + w[2][0]*(K[0]*K[0]*(3.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[1]*(2.0*K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(3.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8])) + K[2]*(2.0*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(3.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]))));
    G[40] = W1*det*(1.5*w[2][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + 3.0*w[1][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[41] = W1*det*(w[1][0]*(K[6]*K[6]*(3.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(2.0*K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(3.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])) + K[8]*(2.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4])) + K[8]*(3.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[2][0]*(K[6]*K[6]*(0.5*(K[1]*K[4] + K[2]*K[5]) + 1.5*K[0]*K[3]) + K[7]*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(0.5*(K[0]*K[3] + K[2]*K[5]) + 1.5*K[1]*K[4])) + K[8]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(0.5*(K[0]*K[3] + K[1]*K[4]) + 1.5*K[2]*K[5]))));
    G[42] = W1*det*(K[3]*K[8]*w[1][0] + K[5]*K[6]*w[2][0]);
    G[43] = W1*det*(K[5]*w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[1][0]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4])));
    G[44] = W1*det*(K[5]*(w[1][0]*(2.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]) + w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[8]*w[1][0]*(K[3]*K[3] + K[4]*K[4]));
    G[45] = W1*det*(2.0*K[8]*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[5]*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[46] = W1*det*(K[3]*w[1][0]*(K[7]*K[7] + K[8]*K[8]) + K[6]*(w[1][0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])));
    G[47] = W1*det*(w[1][0]*(K[6]*K[6]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])) + K[8]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[2][0]*(K[0]*K[3]*K[6]*K[6] + K[7]*(K[1]*K[4]*K[7] + K[6]*(K[0]*K[4] + K[1]*K[3])) + K[8]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[48] = W1*det*(w[1][0]*(2.0*(K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(K[3]*K[6] + K[4]*K[7]) + K[5]*K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[6]*K[6]*(K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4])) + w[2][0]*(K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(2.0*K[3]*K[6] + K[4]*K[7]) + K[5]*K[8]*(2.0*(K[3]*K[6] + K[4]*K[7]) + K[5]*K[8])));
    G[49] = W1*det*(2.0*w[1][0]*(K[0]*K[3]*K[6]*K[6] + K[7]*(K[1]*K[4]*K[7] + K[6]*(K[0]*K[4] + K[1]*K[3])) + K[8]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + w[2][0]*(K[6]*K[6]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*K[7]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[8]*K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[50] = W1*det*(w[1][0]*(2.0*K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(2.0*K[4]*K[7] + 4.0*K[3]*K[6]) + K[5]*K[8]*(2.0*K[5]*K[8] + 4.0*(K[3]*K[6] + K[4]*K[7]))) + w[2][0]*(K[6]*K[6]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5])));
    G[51] = W1*det*(2.0*w[1][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))) + w[2][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))));
    G[52] = K[3]*K[5]*W1*det*(w[1][0] + w[2][0]);
    G[53] = W1*det*(K[2]*w[1][0]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(w[1][0]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]) + w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[54] = K[5]*W1*det*(2.0*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[55] = W1*det*(K[3]*(w[1][0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[6]*w[1][0]*(K[4]*K[4] + K[5]*K[5]));
    G[56] = W1*det*(K[3]*K[3]*K[3]*K[3]*(w[2][0] + 2.0*w[1][0]) + K[4]*K[4]*(K[3]*K[3]*(2.0*w[2][0] + 4.0*w[1][0]) + K[4]*K[4]*(w[2][0] + 2.0*w[1][0])) + K[5]*K[5]*(w[1][0]*(2.0*K[5]*K[5] + 4.0*(K[3]*K[3] + K[4]*K[4])) + w[2][0]*(2.0*(K[3]*K[3] + K[4]*K[4]) + K[5]*K[5])));
    G[57] = W1*det*(K[0]*K[5]*w[2][0] + K[2]*K[3]*w[1][0]);
    G[58] = W1*det*(2.0*K[2]*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[5]*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[59] = W1*det*(K[0]*w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[1][0]*(K[3]*(K[1]*K[7] + K[2]*K[8]) + K[6]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[60] = W1*det*(2.0*w[1][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[2][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[61] = W1*det*(w[1][0]*(2.0*K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(2.0*K[1]*K[4] + 4.0*K[0]*K[3]) + K[2]*K[5]*(2.0*K[2]*K[5] + 4.0*(K[0]*K[3] + K[1]*K[4]))) + w[2][0]*(K[3]*K[3]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[62] = W1*det*(2.0*w[1][0]*(K[0]*K[0]*K[3]*K[6] + K[1]*(K[0]*K[4]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[2][0]*(K[3]*K[6]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[7]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[5]*K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[63] = W1*det*(K[4]*K[8]*w[1][0] + K[5]*K[7]*w[2][0]);
    G[64] = W1*det*(K[4]*w[1][0]*(K[6]*K[6] + K[8]*K[8]) + K[7]*(w[1][0]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8]) + w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])));
    G[65] = K[4]*K[5]*W1*det*(w[1][0] + w[2][0]);
    G[66] = W1*det*(K[4]*(w[1][0]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8]) + w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[7]*w[1][0]*(K[3]*K[3] + K[5]*K[5]));
    G[67] = W1*det*(K[1]*K[5]*w[2][0] + K[2]*K[4]*w[1][0]);
    G[68] = W1*det*(K[1]*w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[1][0]*(K[4]*(K[0]*K[6] + K[2]*K[8]) + K[7]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])));
    G[69] = W1*det*(K[5]*K[8]*w[2][0] + w[1][0]*(2.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]));
    G[70] = W1*det*(K[5]*(K[6]*K[6]*(w[2][0] + 2.0*w[1][0]) + K[7]*K[7]*(w[2][0] + 2.0*w[1][0])) + K[8]*(w[1][0]*(4.0*(K[3]*K[6] + K[4]*K[7]) + 6.0*K[5]*K[8]) + w[2][0]*(2.0*(K[3]*K[6] + K[4]*K[7]) + 3.0*K[5]*K[8])));
    G[71] = W1*det*(0.5*w[2][0]*(K[3]*K[6]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[7]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[5]*K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])) + w[1][0]*(K[0]*K[0]*K[3]*K[6] + K[1]*(K[0]*K[4]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[72] = W1*det*(0.5*w[2][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))) + w[1][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))));
    G[73] = W1*det*(0.5*w[2][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))) + w[1][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))));
    G[74] = W1*det*(w[1][0]*(K[0]*K[0]*(3.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[1]*(2.0*K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(3.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8])) + K[2]*(2.0*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(3.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]))) + w[2][0]*(K[0]*K[0]*(0.5*(K[4]*K[7] + K[5]*K[8]) + 1.5*K[3]*K[6]) + K[1]*(K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(0.5*(K[3]*K[6] + K[5]*K[8]) + 1.5*K[4]*K[7])) + K[2]*(0.5*K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(1.5*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))));
    G[75] = W1*det*(w[1][0]*(K[6]*K[6]*(2.0*(K[1]*K[4] + K[2]*K[5]) + 6.0*K[0]*K[3]) + K[7]*(4.0*K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(2.0*(K[0]*K[3] + K[2]*K[5]) + 6.0*K[1]*K[4])) + K[8]*(4.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4])) + K[8]*(2.0*(K[0]*K[3] + K[1]*K[4]) + 6.0*K[2]*K[5]))) + w[2][0]*(K[6]*K[6]*(3.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(2.0*K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(3.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])) + K[8]*(2.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4])) + K[8]*(3.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))));
    G[76] = W1*det*(1.5*w[2][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))) + 3.0*w[1][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))));
    G[77] = W1*det*(w[1][0]*(2.0*(K[6]*K[6]*(K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4])) + 6.0*K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(6.0*K[4]*K[7] + 8.0*K[3]*K[6]) + K[5]*K[8]*(6.0*K[5]*K[8] + 8.0*(K[3]*K[6] + K[4]*K[7]))) + w[2][0]*(4.0*K[3]*K[4]*K[6]*K[7] + K[6]*K[6]*(3.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(3.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5]) + K[8]*(4.0*K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(3.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4]))));
    G[78] = W1*det*(1.5*w[2][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))) + 3.0*w[1][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))));
    G[79] = W1*det*(K[2]*K[2]*w[2][0] + w[1][0]*(2.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]));
    G[80] = K[0]*W1*det*(2.0*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[81] = W1*det*(2.0*K[0]*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[3]*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[82] = W1*det*(2.0*K[0]*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[6]*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[83] = K[1]*W1*det*(2.0*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[84] = W1*det*(2.0*K[1]*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[4]*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[85] = W1*det*(2.0*K[1]*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[7]*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[86] = K[2]*W1*det*(3.0*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + 6.0*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[87] = W1*det*(K[2]*(K[0]*K[6]*(2.0*w[2][0] + 4.0*w[1][0]) + K[1]*K[7]*(2.0*w[2][0] + 4.0*w[1][0])) + K[8]*(w[1][0]*(2.0*(K[0]*K[0] + K[1]*K[1]) + 6.0*K[2]*K[2]) + w[2][0]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1])));
    G[88] = W1*det*(K[0]*K[0]*K[0]*K[0]*(w[1][0] + 0.5*w[2][0]) + K[1]*K[1]*(K[0]*K[0]*(w[2][0] + 2.0*w[1][0]) + K[1]*K[1]*(w[1][0] + 0.5*w[2][0])) + K[2]*K[2]*(w[1][0]*(2.0*(K[0]*K[0] + K[1]*K[1]) + K[2]*K[2]) + w[2][0]*(0.5*K[2]*K[2] + K[0]*K[0] + K[1]*K[1])));
    G[89] = W1*det*(2.0*w[1][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[2][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[90] = W1*det*(0.5*w[2][0]*(K[6]*K[6]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])) + w[1][0]*(K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(2.0*K[0]*K[6] + K[1]*K[7]) + K[2]*K[8]*(2.0*(K[0]*K[6] + K[1]*K[7]) + K[2]*K[8])));
    G[91] = W1*det*(K[0]*K[0]*K[0]*K[0]*(1.5*w[2][0] + 3.0*w[1][0]) + K[1]*K[1]*(K[0]*K[0]*(3.0*w[2][0] + 6.0*w[1][0]) + K[1]*K[1]*(1.5*w[2][0] + 3.0*w[1][0])) + K[2]*K[2]*(w[1][0]*(3.0*K[2]*K[2] + 6.0*(K[0]*K[0] + K[1]*K[1])) + w[2][0]*(1.5*K[2]*K[2] + 3.0*(K[0]*K[0] + K[1]*K[1]))));
    G[92] = W1*det*(3.0*w[2][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + 6.0*w[1][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[93] = W1*det*(3.0*w[2][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + 6.0*w[1][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[94] = W1*det*(w[1][0]*(4.0*K[0]*K[1]*K[6]*K[7] + K[6]*K[6]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + K[8]*(4.0*K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]))) + w[2][0]*(0.5*(K[6]*K[6]*(K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1])) + 1.5*K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(1.5*K[1]*K[7] + 2.0*K[0]*K[6]) + K[2]*K[8]*(1.5*K[2]*K[8] + 2.0*(K[0]*K[6] + K[1]*K[7]))));
    G[95] = W1*det*(K[0]*K[8]*w[1][0] + K[2]*K[6]*w[2][0]);
    G[96] = W1*det*(K[2]*(w[1][0]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]) + w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[8]*w[1][0]*(K[0]*K[0] + K[1]*K[1]));
    G[97] = W1*det*(K[2]*w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[1][0]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4])));
    G[98] = W1*det*(2.0*K[8]*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[2]*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[99] = W1*det*(K[0]*w[1][0]*(K[7]*K[7] + K[8]*K[8]) + K[6]*(w[1][0]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[100] = W1*det*(w[1][0]*(2.0*(K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(K[0]*K[6] + K[1]*K[7]) + K[2]*K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[6]*K[6]*(K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1])) + w[2][0]*(K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(2.0*K[0]*K[6] + K[1]*K[7]) + K[2]*K[8]*(2.0*(K[0]*K[6] + K[1]*K[7]) + K[2]*K[8])));
    G[101] = W1*det*(w[1][0]*(2.0*K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(2.0*K[1]*K[7] + 4.0*K[0]*K[6]) + K[2]*K[8]*(2.0*K[2]*K[8] + 4.0*(K[0]*K[6] + K[1]*K[7]))) + w[2][0]*(K[6]*K[6]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[102] = W1*det*(2.0*w[1][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + w[2][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[103] = W1*det*(K[0]*K[5]*w[1][0] + K[2]*K[3]*w[2][0]);
    G[104] = W1*det*(K[2]*(w[1][0]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]) + w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[5]*w[1][0]*(K[0]*K[0] + K[1]*K[1]));
    G[105] = W1*det*(2.0*K[5]*w[1][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[2]*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[106] = W1*det*(K[3]*w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[1][0]*(K[0]*(K[4]*K[7] + K[5]*K[8]) + K[6]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[107] = K[0]*K[2]*W1*det*(w[1][0] + w[2][0]);
    G[108] = K[2]*W1*det*(2.0*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[109] = W1*det*(K[0]*(w[1][0]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[6]*w[1][0]*(K[1]*K[1] + K[2]*K[2]));
    G[110] = W1*det*(K[0]*K[0]*K[0]*K[0]*(w[2][0] + 2.0*w[1][0]) + K[1]*K[1]*(K[0]*K[0]*(2.0*w[2][0] + 4.0*w[1][0]) + K[1]*K[1]*(w[2][0] + 2.0*w[1][0])) + K[2]*K[2]*(w[1][0]*(2.0*K[2]*K[2] + 4.0*(K[0]*K[0] + K[1]*K[1])) + w[2][0]*(2.0*(K[0]*K[0] + K[1]*K[1]) + K[2]*K[2])));
    G[111] = W1*det*(K[1]*K[8]*w[1][0] + K[2]*K[7]*w[2][0]);
    G[112] = W1*det*(K[1]*w[1][0]*(K[6]*K[6] + K[8]*K[8]) + K[7]*(w[1][0]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8]) + w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[113] = W1*det*(K[1]*K[5]*w[1][0] + K[2]*K[4]*w[2][0]);
    G[114] = W1*det*(K[4]*w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[1][0]*(K[1]*(K[3]*K[6] + K[5]*K[8]) + K[7]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])));
    G[115] = K[1]*K[2]*W1*det*(w[1][0] + w[2][0]);
    G[116] = W1*det*(K[1]*(w[1][0]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8]) + w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[7]*w[1][0]*(K[0]*K[0] + K[2]*K[2]));
    G[117] = W1*det*(K[2]*K[8]*w[2][0] + w[1][0]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]));
    G[118] = W1*det*(K[2]*(K[6]*K[6]*(w[2][0] + 2.0*w[1][0]) + K[7]*K[7]*(w[2][0] + 2.0*w[1][0])) + K[8]*(w[1][0]*(4.0*(K[0]*K[6] + K[1]*K[7]) + 6.0*K[2]*K[8]) + w[2][0]*(2.0*(K[0]*K[6] + K[1]*K[7]) + 3.0*K[2]*K[8])));
    G[119] = W1*det*(0.5*w[2][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[1][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[120] = W1*det*(0.5*w[2][0]*(K[3]*K[3]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*K[4]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[5]*K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + w[1][0]*(K[0]*K[3]*K[3]*K[6] + K[4]*(K[1]*K[3]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[121] = W1*det*(0.5*w[2][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + w[1][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[122] = W1*det*(1.5*w[2][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + 3.0*w[1][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[123] = W1*det*(w[1][0]*(2.0*(K[6]*K[6]*(K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1])) + 6.0*K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(6.0*K[1]*K[7] + 8.0*K[0]*K[6]) + K[2]*K[8]*(6.0*K[2]*K[8] + 8.0*(K[0]*K[6] + K[1]*K[7]))) + w[2][0]*(4.0*K[0]*K[1]*K[6]*K[7] + K[6]*K[6]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + K[8]*(4.0*K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]))));
    G[124] = W1*det*(w[1][0]*(K[3]*K[3]*(3.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*(2.0*K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(3.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])) + K[5]*(2.0*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(3.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]))) + w[2][0]*(K[3]*K[3]*(0.5*(K[1]*K[7] + K[2]*K[8]) + 1.5*K[0]*K[6]) + K[4]*(K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(0.5*(K[0]*K[6] + K[2]*K[8]) + 1.5*K[1]*K[7])) + K[5]*(0.5*K[5]*(K[0]*K[6] + K[1]*K[7]) + K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(1.5*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))));
    G[125] = W1*det*(1.5*w[2][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + 3.0*w[1][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[126] = W1*det*(K[6]*K[6]*w[2][0] + w[1][0]*(2.0*K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[127] = W1*det*(K[0]*(K[7]*K[7]*(w[2][0] + 2.0*w[1][0]) + K[8]*K[8]*(w[2][0] + 2.0*w[1][0])) + K[6]*(w[1][0]*(4.0*(K[1]*K[7] + K[2]*K[8]) + 6.0*K[0]*K[6]) + w[2][0]*(2.0*(K[1]*K[7] + K[2]*K[8]) + 3.0*K[0]*K[6])));
    G[128] = W1*det*(K[3]*(K[7]*K[7]*(w[2][0] + 2.0*w[1][0]) + K[8]*K[8]*(w[2][0] + 2.0*w[1][0])) + K[6]*(w[1][0]*(4.0*(K[4]*K[7] + K[5]*K[8]) + 6.0*K[3]*K[6]) + w[2][0]*(2.0*(K[4]*K[7] + K[5]*K[8]) + 3.0*K[3]*K[6])));
    G[129] = K[6]*W1*det*(3.0*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + 6.0*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[130] = W1*det*(2.0*K[7]*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[1]*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[131] = W1*det*(2.0*K[7]*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[4]*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[132] = K[7]*W1*det*(2.0*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[133] = K[8]*W1*det*(2.0*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[134] = W1*det*(3.0*w[2][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + 6.0*w[1][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[135] = W1*det*(3.0*w[2][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))) + 6.0*w[1][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))));
    G[136] = W1*det*(K[6]*K[6]*K[6]*K[6]*(1.5*w[2][0] + 3.0*w[1][0]) + K[7]*K[7]*(K[6]*K[6]*(3.0*w[2][0] + 6.0*w[1][0]) + K[7]*K[7]*(1.5*w[2][0] + 3.0*w[1][0])) + K[8]*K[8]*(w[1][0]*(3.0*K[8]*K[8] + 6.0*(K[6]*K[6] + K[7]*K[7])) + w[2][0]*(1.5*K[8]*K[8] + 3.0*(K[6]*K[6] + K[7]*K[7]))));
    G[137] = W1*det*(K[6]*K[6]*K[6]*K[6]*(w[1][0] + 0.5*w[2][0]) + K[7]*K[7]*(K[6]*K[6]*(w[2][0] + 2.0*w[1][0]) + K[7]*K[7]*(w[1][0] + 0.5*w[2][0])) + K[8]*K[8]*(w[1][0]*(2.0*(K[6]*K[6] + K[7]*K[7]) + K[8]*K[8]) + w[2][0]*(0.5*K[8]*K[8] + K[6]*K[6] + K[7]*K[7])));
    G[138] = W1*det*(K[3]*K[6]*w[2][0] + w[1][0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[139] = W1*det*(w[1][0]*(2.0*(K[6]*(K[1]*K[4] + K[2]*K[5]) + K[7]*(K[0]*K[4] + K[1]*K[3]) + K[8]*(K[0]*K[5] + K[2]*K[3])) + 6.0*K[0]*K[3]*K[6]) + w[2][0]*(K[6]*(3.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(K[0]*K[4] + K[1]*K[3]) + K[8]*(K[0]*K[5] + K[2]*K[3])));
    G[140] = W1*det*(K[3]*(K[4]*K[7]*(2.0*w[2][0] + 4.0*w[1][0]) + K[5]*K[8]*(2.0*w[2][0] + 4.0*w[1][0])) + K[6]*(w[1][0]*(2.0*(K[4]*K[4] + K[5]*K[5]) + 6.0*K[3]*K[3]) + w[2][0]*(3.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5])));
    G[141] = W1*det*(K[5]*w[1][0]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(w[1][0]*(2.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]) + w[2][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])));
    G[142] = W1*det*(K[0]*K[6]*w[2][0] + w[1][0]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[143] = W1*det*(K[0]*(K[1]*K[7]*(2.0*w[2][0] + 4.0*w[1][0]) + K[2]*K[8]*(2.0*w[2][0] + 4.0*w[1][0])) + K[6]*(w[1][0]*(2.0*(K[1]*K[1] + K[2]*K[2]) + 6.0*K[0]*K[0]) + w[2][0]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[144] = W1*det*(K[2]*w[1][0]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(w[1][0]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]) + w[2][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[145] = K[6]*K[7]*W1*det*(w[1][0] + w[2][0]);
    G[146] = K[6]*W1*det*(2.0*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[147] = W1*det*(K[6]*K[6]*K[6]*K[6]*(w[2][0] + 2.0*w[1][0]) + K[7]*K[7]*(K[6]*K[6]*(2.0*w[2][0] + 4.0*w[1][0]) + K[7]*K[7]*(w[2][0] + 2.0*w[1][0])) + K[8]*K[8]*(w[1][0]*(2.0*K[8]*K[8] + 4.0*(K[6]*K[6] + K[7]*K[7])) + w[2][0]*(2.0*(K[6]*K[6] + K[7]*K[7]) + K[8]*K[8])));
    G[148] = W1*det*(K[3]*K[7]*w[1][0] + K[4]*K[6]*w[2][0]);
    G[149] = W1*det*(K[0]*K[7]*w[1][0] + K[1]*K[6]*w[2][0]);
    G[150] = K[6]*K[8]*W1*det*(w[1][0] + w[2][0]);
    G[151] = W1*det*(K[3]*K[3]*w[2][0] + w[1][0]*(2.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[152] = W1*det*(K[0]*(K[4]*K[4]*(w[2][0] + 2.0*w[1][0]) + K[5]*K[5]*(w[2][0] + 2.0*w[1][0])) + K[3]*(w[1][0]*(4.0*(K[1]*K[4] + K[2]*K[5]) + 6.0*K[0]*K[3]) + w[2][0]*(2.0*(K[1]*K[4] + K[2]*K[5]) + 3.0*K[0]*K[3])));
    G[153] = K[3]*W1*det*(3.0*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + 6.0*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[154] = W1*det*(2.0*K[5]*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[8]*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[155] = W1*det*(K[0]*K[3]*w[2][0] + w[1][0]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[156] = W1*det*(K[0]*(K[1]*K[4]*(2.0*w[2][0] + 4.0*w[1][0]) + K[2]*K[5]*(2.0*w[2][0] + 4.0*w[1][0])) + K[3]*(w[1][0]*(2.0*(K[1]*K[1] + K[2]*K[2]) + 6.0*K[0]*K[0]) + w[2][0]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[157] = W1*det*(K[8]*w[2][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[1][0]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7])));
    G[158] = W1*det*(K[3]*K[7]*w[2][0] + K[4]*K[6]*w[1][0]);
    G[159] = W1*det*(2.0*K[6]*w[1][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[3]*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[160] = K[3]*K[4]*W1*det*(w[1][0] + w[2][0]);
    G[161] = W1*det*(K[0]*K[4]*w[1][0] + K[1]*K[3]*w[2][0]);
    G[162] = W1*det*(K[3]*K[8]*w[2][0] + K[5]*K[6]*w[1][0]);
    G[163] = W1*det*(K[0]*K[0]*w[2][0] + w[1][0]*(2.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[164] = K[0]*W1*det*(3.0*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + 6.0*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[165] = W1*det*(2.0*K[2]*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[8]*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[166] = W1*det*(K[0]*K[7]*w[2][0] + K[1]*K[6]*w[1][0]);
    G[167] = W1*det*(2.0*K[6]*w[1][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[0]*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[168] = W1*det*(K[0]*K[4]*w[2][0] + K[1]*K[3]*w[1][0]);
    G[169] = K[0]*K[1]*W1*det*(w[1][0] + w[2][0]);
    G[170] = W1*det*(K[0]*K[8]*w[2][0] + K[2]*K[6]*w[1][0]);
    G[171] = W1*det*(K[7]*K[7]*w[2][0] + w[1][0]*(2.0*K[7]*K[7] + K[6]*K[6] + K[8]*K[8]));
    G[172] = W1*det*(K[1]*(K[6]*K[6]*(w[2][0] + 2.0*w[1][0]) + K[8]*K[8]*(w[2][0] + 2.0*w[1][0])) + K[7]*(w[1][0]*(4.0*(K[0]*K[6] + K[2]*K[8]) + 6.0*K[1]*K[7]) + w[2][0]*(2.0*(K[0]*K[6] + K[2]*K[8]) + 3.0*K[1]*K[7])));
    G[173] = W1*det*(K[4]*(K[6]*K[6]*(w[2][0] + 2.0*w[1][0]) + K[8]*K[8]*(w[2][0] + 2.0*w[1][0])) + K[7]*(w[1][0]*(4.0*(K[3]*K[6] + K[5]*K[8]) + 6.0*K[4]*K[7]) + w[2][0]*(2.0*(K[3]*K[6] + K[5]*K[8]) + 3.0*K[4]*K[7])));
    G[174] = K[7]*W1*det*(3.0*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + 6.0*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[175] = W1*det*(K[4]*K[7]*w[2][0] + w[1][0]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8]));
    G[176] = W1*det*(w[1][0]*(2.0*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(K[0]*K[3] + K[2]*K[5]) + K[8]*(K[1]*K[5] + K[2]*K[4])) + 6.0*K[1]*K[4]*K[7]) + w[2][0]*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(3.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]) + K[8]*(K[1]*K[5] + K[2]*K[4])));
    G[177] = W1*det*(K[4]*(K[3]*K[6]*(2.0*w[2][0] + 4.0*w[1][0]) + K[5]*K[8]*(2.0*w[2][0] + 4.0*w[1][0])) + K[7]*(w[1][0]*(2.0*(K[3]*K[3] + K[5]*K[5]) + 6.0*K[4]*K[4]) + w[2][0]*(3.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5])));
    G[178] = W1*det*(K[1]*K[7]*w[2][0] + w[1][0]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8]));
    G[179] = W1*det*(K[1]*(K[0]*K[6]*(2.0*w[2][0] + 4.0*w[1][0]) + K[2]*K[8]*(2.0*w[2][0] + 4.0*w[1][0])) + K[7]*(w[1][0]*(2.0*(K[0]*K[0] + K[2]*K[2]) + 6.0*K[1]*K[1]) + w[2][0]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2])));
    G[180] = K[7]*K[8]*W1*det*(w[1][0] + w[2][0]);
    G[181] = W1*det*(K[4]*K[4]*w[2][0] + w[1][0]*(2.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5]));
    G[182] = W1*det*(K[1]*(K[3]*K[3]*(w[2][0] + 2.0*w[1][0]) + K[5]*K[5]*(w[2][0] + 2.0*w[1][0])) + K[4]*(w[1][0]*(4.0*(K[0]*K[3] + K[2]*K[5]) + 6.0*K[1]*K[4]) + w[2][0]*(2.0*(K[0]*K[3] + K[2]*K[5]) + 3.0*K[1]*K[4])));
    G[183] = K[4]*W1*det*(3.0*w[2][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + 6.0*w[1][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[184] = W1*det*(K[1]*K[4]*w[2][0] + w[1][0]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]));
    G[185] = W1*det*(K[1]*(K[0]*K[3]*(2.0*w[2][0] + 4.0*w[1][0]) + K[2]*K[5]*(2.0*w[2][0] + 4.0*w[1][0])) + K[4]*(w[1][0]*(2.0*(K[0]*K[0] + K[2]*K[2]) + 6.0*K[1]*K[1]) + w[2][0]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2])));
    G[186] = W1*det*(K[4]*K[8]*w[2][0] + K[5]*K[7]*w[1][0]);
    G[187] = W1*det*(K[1]*K[1]*w[2][0] + w[1][0]*(2.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]));
    G[188] = K[1]*W1*det*(3.0*w[2][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + 6.0*w[1][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[189] = W1*det*(K[1]*K[8]*w[2][0] + K[2]*K[7]*w[1][0]);
    G[190] = W1*det*(K[8]*K[8]*w[2][0] + w[1][0]*(2.0*K[8]*K[8] + K[6]*K[6] + K[7]*K[7]));
    G[191] = K[8]*W1*det*(3.0*w[2][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + 6.0*w[1][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 2808
    // Only 1 integration point, omitting IP loop.
    
    // Coefficient declarations.
    double F0 = 0.0;
    double F1 = 0.0;
    double F2 = 0.0;
    double F3 = 0.0;
    double F4 = 0.0;
    double F5 = 0.0;
    double F6 = 0.0;
    double F7 = 0.0;
    double F8 = 0.0;
    
    // Total number of operations to compute function values = 36
    for (unsigned int r = 0; r < 2; r++)
    {
      F0 += FE0_C0_D001[0][r]*w[0][nzc3[r]];
      F1 += FE0_C0_D001[0][r]*w[0][nzc2[r]];
      F2 += FE0_C0_D001[0][r]*w[0][nzc1[r]];
      F3 += FE0_C0_D001[0][r]*w[0][nzc7[r]];
      F4 += FE0_C0_D001[0][r]*w[0][nzc6[r]];
      F5 += FE0_C0_D001[0][r]*w[0][nzc5[r]];
      F6 += FE0_C0_D001[0][r]*w[0][nzc11[r]];
      F7 += FE0_C0_D001[0][r]*w[0][nzc10[r]];
      F8 += FE0_C0_D001[0][r]*w[0][nzc9[r]];
    }// end loop over 'r'
    
    // Number of operations to compute ip constants: 1800
    double I[45];
    // Number of operations: 55
    I[0] = (G[0] + F0*G[1] + F1*(G[2] + F0*G[11] + F1*G[13]) + F2*(G[3] + F0*G[12] + F1*G[14] + F2*G[15]) + F3*G[4] + F4*(G[5] + F3*G[11] + F4*G[13]) + F5*(G[6] + F3*G[12] + F4*G[14] + F5*G[15]) + F6*(G[7] + F6*G[16]) + F7*(G[8] + F6*G[17] + F7*G[19]) + F8*(G[9] + F6*G[18] + F7*G[20] + F8*G[21]) + G[10]*(F0*F0 + F3*F3));
    
    // Number of operations: 55
    I[1] = (G[22] + F0*G[23] + F1*(G[24] + F0*G[32] + F1*G[34]) + F2*(G[25] + F0*G[33] + F1*G[35] + F2*G[36]) + F3*G[26] + F4*(G[27] + F3*G[32] + F4*G[34]) + F5*(G[28] + F3*G[33] + F4*G[35] + F5*G[36]) + F6*(G[29] + F6*G[37]) + F7*(G[7] + F6*G[38] + F7*G[40]) + F8*(G[30] + F6*G[39] + F7*G[18] + F8*G[41]) + G[31]*(F0*F0 + F3*F3));
    
    // Number of operations: 30
    I[2] = (G[42] + F0*G[43] + F1*G[44] + F2*G[45] + F6*(G[25] + F0*G[33] + F1*G[35] + F2*G[49]) + F7*(G[3] + F0*G[12] + F1*G[14] + F2*G[50]) + F8*(G[46] + F0*G[47] + F1*G[48] + F2*G[51]));
    
    // Number of operations: 30
    I[3] = (G[52] + F0*G[53] + F1*G[54] + F2*G[44] + F6*(G[24] + F0*G[32] + F1*G[11] + F2*G[35]) + F7*(G[2] + F0*G[11] + F1*G[56] + F2*G[14]) + F8*(G[55] + F0*G[35] + F1*G[14] + F2*G[48]));
    
    // Number of operations: 30
    I[4] = (G[57] + F0*G[58] + F1*G[53] + F2*G[43] + F6*(G[23] + F0*G[60] + F1*G[32] + F2*G[33]) + F7*(G[1] + F0*G[61] + F1*G[11] + F2*G[12]) + F8*(G[59] + F0*G[62] + F1*G[35] + F2*G[47]));
    
    // Number of operations: 30
    I[5] = (G[63] + F3*G[43] + F4*G[44] + F5*G[45] + F6*(G[28] + F3*G[33] + F4*G[35] + F5*G[49]) + F7*(G[6] + F3*G[12] + F4*G[14] + F5*G[50]) + F8*(G[64] + F3*G[47] + F4*G[48] + F5*G[51]));
    
    // Number of operations: 30
    I[6] = (G[65] + F3*G[53] + F4*G[54] + F5*G[44] + F6*(G[27] + F3*G[32] + F4*G[11] + F5*G[35]) + F7*(G[5] + F3*G[11] + F4*G[56] + F5*G[14]) + F8*(G[66] + F3*G[35] + F4*G[14] + F5*G[48]));
    
    // Number of operations: 30
    I[7] = (G[67] + F3*G[58] + F4*G[53] + F5*G[43] + F6*(G[26] + F3*G[60] + F4*G[32] + F5*G[33]) + F7*(G[4] + F3*G[61] + F4*G[11] + F5*G[12]) + F8*(G[68] + F3*G[62] + F4*G[35] + F5*G[47]));
    
    // Number of operations: 55
    I[8] = (G[69] + F0*G[59] + F1*(G[55] + F0*G[35] + F1*G[72]) + F2*(G[46] + F0*G[47] + F1*G[48] + F2*G[73]) + F3*G[68] + F4*(G[66] + F3*G[35] + F4*G[72]) + F5*(G[64] + F3*G[47] + F4*G[48] + F5*G[73]) + F6*(G[30] + F6*G[74]) + F7*(G[9] + F6*G[18] + F7*G[76]) + F8*(G[70] + F6*G[75] + F7*G[77] + F8*G[78]) + G[71]*(F0*F0 + F3*F3));
    
    // Number of operations: 55
    I[9] = (G[79] + F0*G[80] + F1*(G[81] + F0*G[60] + F1*G[10]) + F2*(G[82] + F0*G[89] + F1*G[62] + F2*G[90]) + F3*G[83] + F4*(G[84] + F3*G[60] + F4*G[10]) + F5*(G[85] + F3*G[89] + F4*G[62] + F5*G[90]) + F6*(G[86] + F6*G[91]) + F7*(G[29] + F6*G[92] + F7*G[16]) + F8*(G[87] + F6*G[93] + F7*G[39] + F8*G[94]) + G[88]*(F0*F0 + F3*F3));
    
    // Number of operations: 30
    I[10] = (G[95] + F0*G[96] + F1*G[97] + F2*G[98] + F6*(G[82] + F0*G[89] + F1*G[62] + F2*G[101]) + F7*(G[25] + F0*G[33] + F1*G[35] + F2*G[49]) + F8*(G[99] + F0*G[100] + F1*G[47] + F2*G[102]));
    
    // Number of operations: 30
    I[11] = (G[103] + F0*G[104] + F1*G[105] + F2*G[97] + F6*(G[81] + F0*G[60] + F1*G[61] + F2*G[62]) + F7*(G[24] + F0*G[32] + F1*G[11] + F2*G[35]) + F8*(G[106] + F0*G[33] + F1*G[12] + F2*G[47]));
    
    // Number of operations: 30
    I[12] = (G[107] + F0*G[108] + F1*G[104] + F2*G[96] + F6*(G[80] + F0*G[110] + F1*G[60] + F2*G[89]) + F7*(G[23] + F0*G[60] + F1*G[32] + F2*G[33]) + F8*(G[109] + F0*G[89] + F1*G[33] + F2*G[100]));
    
    // Number of operations: 30
    I[13] = (G[111] + F3*G[96] + F4*G[97] + F5*G[98] + F6*(G[85] + F3*G[89] + F4*G[62] + F5*G[101]) + F7*(G[28] + F3*G[33] + F4*G[35] + F5*G[49]) + F8*(G[112] + F3*G[100] + F4*G[47] + F5*G[102]));
    
    // Number of operations: 30
    I[14] = (G[113] + F3*G[104] + F4*G[105] + F5*G[97] + F6*(G[84] + F3*G[60] + F4*G[61] + F5*G[62]) + F7*(G[27] + F3*G[32] + F4*G[11] + F5*G[35]) + F8*(G[114] + F3*G[33] + F4*G[12] + F5*G[47]));
    
    // Number of operations: 30
    I[15] = (G[115] + F3*G[108] + F4*G[104] + F5*G[96] + F6*(G[83] + F3*G[110] + F4*G[60] + F5*G[89]) + F7*(G[26] + F3*G[60] + F4*G[32] + F5*G[33]) + F8*(G[116] + F3*G[89] + F4*G[33] + F5*G[100]));
    
    // Number of operations: 55
    I[16] = (G[117] + F0*G[109] + F1*(G[106] + F0*G[33] + F1*G[120]) + F2*(G[99] + F0*G[100] + F1*G[47] + F2*G[121]) + F3*G[116] + F4*(G[114] + F3*G[33] + F4*G[120]) + F5*(G[112] + F3*G[100] + F4*G[47] + F5*G[121]) + F6*(G[87] + F6*G[122]) + F7*(G[30] + F6*G[39] + F7*G[124]) + F8*(G[118] + F6*G[123] + F7*G[75] + F8*G[125]) + G[119]*(F0*F0 + F3*F3));
    
    // Number of operations: 55
    I[17] = (G[126] + F0*(G[127] + F0*G[94]) + F1*(G[128] + F0*G[75] + F1*G[21]) + F2*(G[129] + F0*G[134] + F1*G[135] + F2*G[136]) + F3*G[130] + F4*(G[131] + F3*G[49] + F4*G[15]) + F5*(G[132] + F3*G[102] + F4*G[51] + F5*G[137]) + F6*G[98] + F7*(G[45] + F6*G[49] + F7*G[15]) + F8*(G[133] + F6*G[102] + F7*G[51] + F8*G[137]) + G[90]*(F3*F3 + F6*F6));
    
    // Number of operations: 55
    I[18] = (G[138] + F0*(G[139] + F0*G[74]) + F1*(G[140] + F0*G[18] + F1*G[76]) + F2*(G[128] + F0*G[75] + F1*G[77] + F2*G[78]) + F3*G[68] + F4*(G[66] + F3*G[35] + F4*G[72]) + F5*(G[64] + F3*G[47] + F4*G[48] + F5*G[73]) + F6*G[97] + F7*(G[44] + F6*G[35] + F7*G[72]) + F8*(G[141] + F6*G[47] + F7*G[48] + F8*G[73]) + G[71]*(F3*F3 + F6*F6));
    
    // Number of operations: 55
    I[19] = (G[142] + F0*(G[143] + F0*G[122]) + F1*(G[139] + F0*G[39] + F1*G[124]) + F2*(G[127] + F0*G[123] + F1*G[75] + F2*G[125]) + F3*G[116] + F4*(G[114] + F3*G[33] + F4*G[120]) + F5*(G[112] + F3*G[100] + F4*G[47] + F5*G[121]) + F6*G[96] + F7*(G[43] + F6*G[33] + F7*G[120]) + F8*(G[144] + F6*G[100] + F7*G[47] + F8*G[121]) + G[119]*(F3*F3 + F6*F6));
    
    // Number of operations: 30
    I[20] = (G[145] + F0*G[112] + F1*G[64] + F2*G[132] + F3*(G[99] + F0*G[100] + F1*G[47] + F2*G[102]) + F4*(G[46] + F0*G[47] + F1*G[48] + F2*G[51]) + F5*(G[146] + F0*G[102] + F1*G[51] + F2*G[147]));
    
    // Number of operations: 30
    I[21] = (G[148] + F0*G[114] + F1*G[66] + F2*G[131] + F3*(G[25] + F0*G[33] + F1*G[35] + F2*G[49]) + F4*(G[3] + F0*G[12] + F1*G[14] + F2*G[50]) + F5*(G[46] + F0*G[47] + F1*G[48] + F2*G[51]));
    
    // Number of operations: 30
    I[22] = (G[149] + F0*G[116] + F1*G[68] + F2*G[130] + F3*(G[82] + F0*G[89] + F1*G[62] + F2*G[101]) + F4*(G[25] + F0*G[33] + F1*G[35] + F2*G[49]) + F5*(G[99] + F0*G[100] + F1*G[47] + F2*G[102]));
    
    // Number of operations: 30
    I[23] = (G[150] + F0*G[144] + F1*G[141] + F2*G[133] + F6*(G[99] + F0*G[100] + F1*G[47] + F2*G[102]) + F7*(G[46] + F0*G[47] + F1*G[48] + F2*G[51]) + F8*(G[146] + F0*G[102] + F1*G[51] + F2*G[147]));
    
    // Number of operations: 55
    I[24] = (G[151] + F0*(G[152] + F0*G[16]) + F1*(G[153] + F0*G[17] + F1*G[19]) + F2*(G[140] + F0*G[18] + F1*G[20] + F2*G[21]) + F3*G[4] + F4*(G[5] + F3*G[11] + F4*G[13]) + F5*(G[6] + F3*G[12] + F4*G[14] + F5*G[15]) + F6*G[105] + F7*(G[54] + F6*G[11] + F7*G[13]) + F8*(G[154] + F6*G[12] + F7*G[14] + F8*G[15]) + G[10]*(F3*F3 + F6*F6));
    
    // Number of operations: 55
    I[25] = (G[155] + F0*(G[156] + F0*G[37]) + F1*(G[152] + F0*G[38] + F1*G[40]) + F2*(G[139] + F0*G[39] + F1*G[18] + F2*G[41]) + F3*G[26] + F4*(G[27] + F3*G[32] + F4*G[34]) + F5*(G[28] + F3*G[33] + F4*G[35] + F5*G[36]) + F6*G[104] + F7*(G[53] + F6*G[32] + F7*G[34]) + F8*(G[157] + F6*G[33] + F7*G[35] + F8*G[36]) + G[31]*(F3*F3 + F6*F6));
    
    // Number of operations: 30
    I[26] = (G[158] + F0*G[28] + F1*G[6] + F2*G[64] + F3*(G[106] + F0*G[33] + F1*G[12] + F2*G[47]) + F4*(G[55] + F0*G[35] + F1*G[14] + F2*G[48]) + F5*(G[159] + F0*G[49] + F1*G[50] + F2*G[51]));
    
    // Number of operations: 30
    I[27] = (G[160] + F0*G[27] + F1*G[5] + F2*G[66] + F3*(G[24] + F0*G[32] + F1*G[11] + F2*G[35]) + F4*(G[2] + F0*G[11] + F1*G[56] + F2*G[14]) + F5*(G[55] + F0*G[35] + F1*G[14] + F2*G[48]));
    
    // Number of operations: 30
    I[28] = (G[161] + F0*G[26] + F1*G[4] + F2*G[68] + F3*(G[81] + F0*G[60] + F1*G[61] + F2*G[62]) + F4*(G[24] + F0*G[32] + F1*G[11] + F2*G[35]) + F5*(G[106] + F0*G[33] + F1*G[12] + F2*G[47]));
    
    // Number of operations: 30
    I[29] = (G[162] + F0*G[157] + F1*G[154] + F2*G[141] + F6*(G[106] + F0*G[33] + F1*G[12] + F2*G[47]) + F7*(G[55] + F0*G[35] + F1*G[14] + F2*G[48]) + F8*(G[159] + F0*G[49] + F1*G[50] + F2*G[51]));
    
    // Number of operations: 55
    I[30] = (G[163] + F0*(G[164] + F0*G[91]) + F1*(G[156] + F0*G[92] + F1*G[16]) + F2*(G[143] + F0*G[93] + F1*G[39] + F2*G[94]) + F3*G[83] + F4*(G[84] + F3*G[60] + F4*G[10]) + F5*(G[85] + F3*G[89] + F4*G[62] + F5*G[90]) + F6*G[108] + F7*(G[58] + F6*G[60] + F7*G[10]) + F8*(G[165] + F6*G[89] + F7*G[62] + F8*G[90]) + G[88]*(F3*F3 + F6*F6));
    
    // Number of operations: 30
    I[31] = (G[166] + F0*G[85] + F1*G[28] + F2*G[112] + F3*(G[109] + F0*G[89] + F1*G[33] + F2*G[100]) + F4*(G[59] + F0*G[62] + F1*G[35] + F2*G[47]) + F5*(G[167] + F0*G[101] + F1*G[49] + F2*G[102]));
    
    // Number of operations: 30
    I[32] = (G[168] + F0*G[84] + F1*G[27] + F2*G[114] + F3*(G[23] + F0*G[60] + F1*G[32] + F2*G[33]) + F4*(G[1] + F0*G[61] + F1*G[11] + F2*G[12]) + F5*(G[59] + F0*G[62] + F1*G[35] + F2*G[47]));
    
    // Number of operations: 30
    I[33] = (G[169] + F0*G[83] + F1*G[26] + F2*G[116] + F3*(G[80] + F0*G[110] + F1*G[60] + F2*G[89]) + F4*(G[23] + F0*G[60] + F1*G[32] + F2*G[33]) + F5*(G[109] + F0*G[89] + F1*G[33] + F2*G[100]));
    
    // Number of operations: 30
    I[34] = (G[170] + F0*G[165] + F1*G[157] + F2*G[144] + F6*(G[109] + F0*G[89] + F1*G[33] + F2*G[100]) + F7*(G[59] + F0*G[62] + F1*G[35] + F2*G[47]) + F8*(G[167] + F0*G[101] + F1*G[49] + F2*G[102]));
    
    // Number of operations: 55
    I[35] = (G[171] + F0*G[167] + F1*(G[159] + F0*G[49] + F1*G[15]) + F2*(G[146] + F0*G[102] + F1*G[51] + F2*G[137]) + F3*(G[172] + F3*G[94]) + F4*(G[173] + F3*G[75] + F4*G[21]) + F5*(G[174] + F3*G[134] + F4*G[135] + F5*G[136]) + F6*G[98] + F7*(G[45] + F6*G[49] + F7*G[15]) + F8*(G[133] + F6*G[102] + F7*G[51] + F8*G[137]) + G[90]*(F0*F0 + F6*F6));
    
    // Number of operations: 55
    I[36] = (G[175] + F0*G[59] + F1*(G[55] + F0*G[35] + F1*G[72]) + F2*(G[46] + F0*G[47] + F1*G[48] + F2*G[73]) + F3*(G[176] + F3*G[74]) + F4*(G[177] + F3*G[18] + F4*G[76]) + F5*(G[173] + F3*G[75] + F4*G[77] + F5*G[78]) + F6*G[97] + F7*(G[44] + F6*G[35] + F7*G[72]) + F8*(G[141] + F6*G[47] + F7*G[48] + F8*G[73]) + G[71]*(F0*F0 + F6*F6));
    
    // Number of operations: 55
    I[37] = (G[178] + F0*G[109] + F1*(G[106] + F0*G[33] + F1*G[120]) + F2*(G[99] + F0*G[100] + F1*G[47] + F2*G[121]) + F3*(G[179] + F3*G[122]) + F4*(G[176] + F3*G[39] + F4*G[124]) + F5*(G[172] + F3*G[123] + F4*G[75] + F5*G[125]) + F6*G[96] + F7*(G[43] + F6*G[33] + F7*G[120]) + F8*(G[144] + F6*G[100] + F7*G[47] + F8*G[121]) + G[119]*(F0*F0 + F6*F6));
    
    // Number of operations: 30
    I[38] = (G[180] + F3*G[144] + F4*G[141] + F5*G[133] + F6*(G[112] + F3*G[100] + F4*G[47] + F5*G[102]) + F7*(G[64] + F3*G[47] + F4*G[48] + F5*G[51]) + F8*(G[132] + F3*G[102] + F4*G[51] + F5*G[147]));
    
    // Number of operations: 55
    I[39] = (G[181] + F0*G[1] + F1*(G[2] + F0*G[11] + F1*G[13]) + F2*(G[3] + F0*G[12] + F1*G[14] + F2*G[15]) + F3*(G[182] + F3*G[16]) + F4*(G[183] + F3*G[17] + F4*G[19]) + F5*(G[177] + F3*G[18] + F4*G[20] + F5*G[21]) + F6*G[105] + F7*(G[54] + F6*G[11] + F7*G[13]) + F8*(G[154] + F6*G[12] + F7*G[14] + F8*G[15]) + G[10]*(F0*F0 + F6*F6));
    
    // Number of operations: 55
    I[40] = (G[184] + F0*G[23] + F1*(G[24] + F0*G[32] + F1*G[34]) + F2*(G[25] + F0*G[33] + F1*G[35] + F2*G[36]) + F3*(G[185] + F3*G[37]) + F4*(G[182] + F3*G[38] + F4*G[40]) + F5*(G[176] + F3*G[39] + F4*G[18] + F5*G[41]) + F6*G[104] + F7*(G[53] + F6*G[32] + F7*G[34]) + F8*(G[157] + F6*G[33] + F7*G[35] + F8*G[36]) + G[31]*(F0*F0 + F6*F6));
    
    // Number of operations: 30
    I[41] = (G[186] + F3*G[157] + F4*G[154] + F5*G[141] + F6*(G[114] + F3*G[33] + F4*G[12] + F5*G[47]) + F7*(G[66] + F3*G[35] + F4*G[14] + F5*G[48]) + F8*(G[131] + F3*G[49] + F4*G[50] + F5*G[51]));
    
    // Number of operations: 55
    I[42] = (G[187] + F0*G[80] + F1*(G[81] + F0*G[60] + F1*G[10]) + F2*(G[82] + F0*G[89] + F1*G[62] + F2*G[90]) + F3*(G[188] + F3*G[91]) + F4*(G[185] + F3*G[92] + F4*G[16]) + F5*(G[179] + F3*G[93] + F4*G[39] + F5*G[94]) + F6*G[108] + F7*(G[58] + F6*G[60] + F7*G[10]) + F8*(G[165] + F6*G[89] + F7*G[62] + F8*G[90]) + G[88]*(F0*F0 + F6*F6));
    
    // Number of operations: 30
    I[43] = (G[189] + F3*G[165] + F4*G[157] + F5*G[144] + F6*(G[116] + F3*G[89] + F4*G[33] + F5*G[100]) + F7*(G[68] + F3*G[62] + F4*G[35] + F5*G[47]) + F8*(G[130] + F3*G[101] + F4*G[49] + F5*G[102]));
    
    // Number of operations: 55
    I[44] = (G[190] + F0*G[167] + F1*(G[159] + F0*G[49] + F1*G[15]) + F2*(G[146] + F0*G[102] + F1*G[51] + F2*G[137]) + F3*G[130] + F4*(G[131] + F3*G[49] + F4*G[15]) + F5*(G[132] + F3*G[102] + F4*G[51] + F5*G[137]) + F6*(G[118] + F6*G[94]) + F7*(G[70] + F6*G[75] + F7*G[21]) + F8*(G[191] + F6*G[134] + F7*G[135] + F8*G[136]) + G[90]*(F0*F0 + F3*F3));
    
    
    // Number of operations for primary indices: 972
    for (unsigned int j = 0; j < 2; j++)
    {
      for (unsigned int k = 0; k < 2; k++)
      {
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[0];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[1];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[2];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[3];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[4];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[5];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[6];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[7];
        // Number of operations to compute entry: 3
        A[nzc10[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[8];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[1];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[9];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[10];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[11];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[12];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[13];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[14];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[15];
        // Number of operations to compute entry: 3
        A[nzc11[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[16];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[2];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[10];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[17];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[18];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[19];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[20];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[21];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[22];
        // Number of operations to compute entry: 3
        A[nzc1[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[23];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[3];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[11];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[18];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[24];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[25];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[26];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[27];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[28];
        // Number of operations to compute entry: 3
        A[nzc2[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[29];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[4];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[12];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[19];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[25];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[30];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[31];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[32];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[33];
        // Number of operations to compute entry: 3
        A[nzc3[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[34];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[5];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[13];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[20];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[26];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[31];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[35];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[36];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[37];
        // Number of operations to compute entry: 3
        A[nzc5[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[38];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[6];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[14];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[21];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[27];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[32];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[36];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[39];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[40];
        // Number of operations to compute entry: 3
        A[nzc6[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[41];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[7];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[15];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[22];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[28];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[33];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[37];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[40];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[42];
        // Number of operations to compute entry: 3
        A[nzc7[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[43];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc10[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[8];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc11[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[16];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc1[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[23];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc2[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[29];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc3[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[34];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc5[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[38];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc6[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[41];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc7[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[43];
        // Number of operations to compute entry: 3
        A[nzc9[j]*12 + nzc9[k]] += FE0_C0_D001[0][j]*FE0_C0_D001[0][k]*I[44];
      }// end loop over 'k'
    }// end loop over 'j'
  }

};

/// This class defines the interface for the tabulation of the cell
/// tensor corresponding to the local contribution to a form from
/// the integral over a cell.

class hyperelasticity_cell_integral_1_otherwise: public ufc::cell_integral
{
public:

  /// Constructor
  hyperelasticity_cell_integral_1_otherwise() : ufc::cell_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_cell_integral_1_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local cell
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               int cell_orientation) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    // Set scale factor
    const double det = std::abs(detJ);
    
    // Cell volume
    
    // Compute circumradius
    
    
    // Facet area (divide by two because 'det' is scaled by area of reference triangle)
    
    // Array of quadrature weights.
    static const double W4[4] = {0.041666667, 0.041666667, 0.041666667, 0.041666667};
    // Quadrature points on the UFC reference element: (0.5854102, 0.1381966, 0.1381966), (0.1381966, 0.5854102, 0.1381966), (0.1381966, 0.1381966, 0.5854102), (0.1381966, 0.1381966, 0.1381966)
    
    // Value of basis functions at quadrature points.
    static const double FE0_C0[4][4] = \
    {{0.1381966, 0.5854102, 0.1381966, 0.1381966},
    {0.1381966, 0.1381966, 0.5854102, 0.1381966},
    {0.1381966, 0.1381966, 0.1381966, 0.5854102},
    {0.5854102, 0.1381966, 0.1381966, 0.1381966}};
    
    // Array of non-zero columns
    static const unsigned int nzc8[4] = {8, 9, 10, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc4[4] = {4, 5, 6, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc0[4] = {0, 1, 2, 3};
    
    static const double FE0_C0_D001[4][2] = \
    {{-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0},
    {-1.0, 1.0}};
    
    // Array of non-zero columns
    static const unsigned int nzc9[2] = {8, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc5[2] = {4, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc6[2] = {4, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc10[2] = {8, 10};
    
    // Array of non-zero columns
    static const unsigned int nzc7[2] = {4, 5};
    
    // Array of non-zero columns
    static const unsigned int nzc3[2] = {0, 1};
    
    // Array of non-zero columns
    static const unsigned int nzc2[2] = {0, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc1[2] = {0, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc11[2] = {8, 9};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 12; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    // Number of operations to compute geometry constants: 5934.
    double G[219];
    G[0] = det*(0.5*w[4][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[3][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[1] = (0.5*det*w[4][0]*(K[3]*K[3]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])) + det*w[3][0]*(K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(2.0*K[0]*K[3] + K[1]*K[4]) + K[2]*K[5]*(2.0*(K[0]*K[3] + K[1]*K[4]) + K[2]*K[5])));
    G[2] = det*(0.5*w[4][0]*(K[3]*K[6]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[7]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[5]*K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])) + w[3][0]*(K[0]*K[0]*K[3]*K[6] + K[1]*(K[0]*K[4]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[3] = det*(0.5*K[5]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[2]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[4] = det*(w[3][0]*(2.0*(K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(K[0]*K[3] + K[1]*K[4]) + K[2]*K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[3]*K[3]*(K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1])) + w[4][0]*(K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(2.0*K[0]*K[3] + K[1]*K[4]) + K[2]*K[5]*(2.0*(K[0]*K[3] + K[1]*K[4]) + K[2]*K[5])));
    G[5] = det*(2.0*w[3][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[4][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[6] = det*(w[3][0]*(K[3]*K[3]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*(K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])) + K[5]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[4][0]*(K[0]*K[3]*K[3]*K[6] + K[4]*(K[1]*K[3]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[7] = det*(K[2]*w[3][0]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(w[3][0]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]) + w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[8] = det*(w[3][0]*(K[0]*K[0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[1]*(K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8])) + K[2]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[4][0]*(K[0]*K[0]*K[3]*K[6] + K[1]*(K[0]*K[4]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[9] = det*(2.0*w[3][0]*(K[0]*K[3]*K[3]*K[6] + K[4]*(K[1]*K[3]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[4][0]*(K[3]*K[3]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*K[4]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[5]*K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[10] = det*(w[3][0]*(K[6]*K[6]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])) + K[8]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[4][0]*(K[0]*K[3]*K[6]*K[6] + K[7]*(K[1]*K[4]*K[7] + K[6]*(K[0]*K[4] + K[1]*K[3])) + K[8]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[11] = det*(K[5]*w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[3][0]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4])));
    G[12] = det*(K[0]*(w[3][0]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[3]*w[3][0]*(K[1]*K[1] + K[2]*K[2]));
    G[13] = det*(2.0*K[3]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[0]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[14] = det*(K[0]*w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[3][0]*(K[3]*(K[1]*K[7] + K[2]*K[8]) + K[6]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[15] = det*(K[0]*K[5]*w[4][0] + K[2]*K[3]*w[3][0]);
    G[16] = det*(0.5*w[4][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[3][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[17] = det*(K[3]*K[3]*K[3]*K[3]*(w[3][0] + 0.5*w[4][0]) + K[4]*K[4]*(K[3]*K[3]*(w[4][0] + 2.0*w[3][0]) + K[4]*K[4]*(w[3][0] + 0.5*w[4][0])) + K[5]*K[5]*(w[3][0]*(2.0*(K[3]*K[3] + K[4]*K[4]) + K[5]*K[5]) + w[4][0]*(0.5*K[5]*K[5] + K[3]*K[3] + K[4]*K[4])));
    G[18] = det*(0.5*w[4][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))) + w[3][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))));
    G[19] = K[5]*det*(0.5*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[20] = det*(2.0*w[3][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))) + w[4][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))));
    G[21] = det*(w[3][0]*(2.0*(K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(K[3]*K[6] + K[4]*K[7]) + K[5]*K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[6]*K[6]*(K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4])) + w[4][0]*(K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(2.0*K[3]*K[6] + K[4]*K[7]) + K[5]*K[8]*(2.0*(K[3]*K[6] + K[4]*K[7]) + K[5]*K[8])));
    G[22] = det*(K[5]*(w[3][0]*(2.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]) + w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[8]*w[3][0]*(K[3]*K[3] + K[4]*K[4]));
    G[23] = det*(K[0]*w[3][0]*(K[4]*K[4] + K[5]*K[5]) + K[3]*(w[3][0]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[24] = K[3]*det*(2.0*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[25] = det*(K[3]*(w[3][0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[6]*w[3][0]*(K[4]*K[4] + K[5]*K[5]));
    G[26] = K[3]*K[5]*det*(w[3][0] + w[4][0]);
    G[27] = det*(0.5*w[4][0]*(K[6]*K[6]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*K[7]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[8]*K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + w[3][0]*(K[0]*K[3]*K[6]*K[6] + K[7]*(K[1]*K[4]*K[7] + K[6]*(K[0]*K[4] + K[1]*K[3])) + K[8]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[28] = (0.5*det*w[4][0]*(K[6]*K[6]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5])) + det*w[3][0]*(K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(2.0*K[3]*K[6] + K[4]*K[7]) + K[5]*K[8]*(2.0*(K[3]*K[6] + K[4]*K[7]) + K[5]*K[8])));
    G[29] = det*(0.5*w[4][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))) + w[3][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))));
    G[30] = det*(0.5*K[5]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + K[8]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[31] = det*(K[6]*w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[3][0]*(K[0]*(K[4]*K[7] + K[5]*K[8]) + K[3]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[32] = det*(2.0*K[3]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[6]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[33] = det*(K[3]*w[3][0]*(K[7]*K[7] + K[8]*K[8]) + K[6]*(w[3][0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])));
    G[34] = det*(K[3]*K[8]*w[3][0] + K[5]*K[6]*w[4][0]);
    G[35] = det*(K[1]*(w[3][0]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]) + w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[4]*w[3][0]*(K[0]*K[0] + K[2]*K[2]));
    G[36] = det*(2.0*K[4]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[1]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[37] = det*(K[1]*w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[3][0]*(K[4]*(K[0]*K[6] + K[2]*K[8]) + K[7]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])));
    G[38] = det*(K[1]*K[5]*w[4][0] + K[2]*K[4]*w[3][0]);
    G[39] = det*(K[1]*w[3][0]*(K[3]*K[3] + K[5]*K[5]) + K[4]*(w[3][0]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]) + w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[40] = K[4]*det*(2.0*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[41] = det*(K[4]*(w[3][0]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8]) + w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])) + K[7]*w[3][0]*(K[3]*K[3] + K[5]*K[5]));
    G[42] = K[4]*K[5]*det*(w[3][0] + w[4][0]);
    G[43] = det*(K[7]*w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[3][0]*(K[1]*(K[3]*K[6] + K[5]*K[8]) + K[4]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])));
    G[44] = det*(2.0*K[4]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[7]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[45] = det*(K[4]*w[3][0]*(K[6]*K[6] + K[8]*K[8]) + K[7]*(w[3][0]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8]) + w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])));
    G[46] = det*(K[4]*K[8]*w[3][0] + K[5]*K[7]*w[4][0]);
    G[47] = det*(w[3][0]*(4.0*K[0]*K[1]*K[3]*K[4] + K[3]*K[3]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + K[5]*(4.0*K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]))) + w[4][0]*(0.5*(K[3]*K[3]*(K[1]*K[1] + K[2]*K[2]) + K[4]*K[4]*(K[0]*K[0] + K[2]*K[2]) + K[5]*K[5]*(K[0]*K[0] + K[1]*K[1])) + 1.5*K[0]*K[0]*K[3]*K[3] + K[1]*K[4]*(1.5*K[1]*K[4] + 2.0*K[0]*K[3]) + K[2]*K[5]*(1.5*K[2]*K[5] + 2.0*(K[0]*K[3] + K[1]*K[4]))));
    G[48] = det*(w[3][0]*(K[0]*K[0]*(3.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[1]*(2.0*K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(3.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8])) + K[2]*(2.0*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(3.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]))) + w[4][0]*(K[0]*K[0]*(0.5*(K[4]*K[7] + K[5]*K[8]) + 1.5*K[3]*K[6]) + K[1]*(K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(0.5*(K[3]*K[6] + K[5]*K[8]) + 1.5*K[4]*K[7])) + K[2]*(0.5*K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(1.5*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))));
    G[49] = det*(K[2]*(K[0]*K[3]*(w[4][0] + 2.0*w[3][0]) + K[1]*K[4]*(w[4][0] + 2.0*w[3][0])) + K[5]*(w[3][0]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]) + w[4][0]*(0.5*(K[0]*K[0] + K[1]*K[1]) + 1.5*K[2]*K[2])));
    G[50] = det*(1.5*w[4][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + 3.0*w[3][0]*(K[0]*K[3]*K[3]*K[3] + K[4]*(K[1]*K[3]*K[3] + K[4]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[3] + K[4]*K[4]) + K[5]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[51] = det*(w[3][0]*(K[3]*K[3]*(2.0*(K[1]*K[7] + K[2]*K[8]) + 6.0*K[0]*K[6]) + K[4]*(4.0*K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(2.0*(K[0]*K[6] + K[2]*K[8]) + 6.0*K[1]*K[7])) + K[5]*(4.0*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(2.0*(K[0]*K[6] + K[1]*K[7]) + 6.0*K[2]*K[8]))) + w[4][0]*(K[3]*K[3]*(3.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*(2.0*K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(3.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])) + K[5]*(2.0*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(3.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]))));
    G[52] = det*(K[2]*(K[3]*K[3]*(w[4][0] + 2.0*w[3][0]) + K[4]*K[4]*(w[4][0] + 2.0*w[3][0])) + K[5]*(w[3][0]*(4.0*(K[0]*K[3] + K[1]*K[4]) + 6.0*K[2]*K[5]) + w[4][0]*(2.0*(K[0]*K[3] + K[1]*K[4]) + 3.0*K[2]*K[5])));
    G[53] = det*(w[3][0]*(K[6]*K[6]*(3.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(2.0*K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(3.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])) + K[8]*(2.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4])) + K[8]*(3.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))) + w[4][0]*(K[6]*K[6]*(0.5*(K[1]*K[4] + K[2]*K[5]) + 1.5*K[0]*K[3]) + K[7]*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(0.5*(K[0]*K[3] + K[2]*K[5]) + 1.5*K[1]*K[4])) + K[8]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(0.5*(K[0]*K[3] + K[1]*K[4]) + 1.5*K[2]*K[5]))));
    G[54] = det*(w[3][0]*(2.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + 6.0*K[2]*K[5]*K[8]) + w[4][0]*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4]) + K[8]*(3.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4])));
    G[55] = det*(K[2]*K[5]*w[4][0] + w[3][0]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]));
    G[56] = det*(1.5*w[4][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))) + 3.0*w[3][0]*(K[3]*K[3]*K[3]*K[6] + K[4]*(K[3]*K[4]*K[6] + K[7]*(K[3]*K[3] + K[4]*K[4])) + K[5]*(K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]))));
    G[57] = K[5]*det*(1.5*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + 3.0*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[58] = det*(w[3][0]*(4.0*K[3]*K[4]*K[6]*K[7] + K[6]*K[6]*(3.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(3.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5]) + K[8]*(4.0*K[5]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(3.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4]))) + w[4][0]*(0.5*(K[6]*K[6]*(K[4]*K[4] + K[5]*K[5]) + K[7]*K[7]*(K[3]*K[3] + K[5]*K[5]) + K[8]*K[8]*(K[3]*K[3] + K[4]*K[4])) + 1.5*K[3]*K[3]*K[6]*K[6] + K[4]*K[7]*(1.5*K[4]*K[7] + 2.0*K[3]*K[6]) + K[5]*K[8]*(1.5*K[5]*K[8] + 2.0*(K[3]*K[6] + K[4]*K[7]))));
    G[59] = det*(K[5]*(K[3]*K[6]*(2.0*w[4][0] + 4.0*w[3][0]) + K[4]*K[7]*(2.0*w[4][0] + 4.0*w[3][0])) + K[8]*(w[3][0]*(2.0*(K[3]*K[3] + K[4]*K[4]) + 6.0*K[5]*K[5]) + w[4][0]*(3.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4])));
    G[60] = det*(K[5]*K[5]*w[4][0] + w[3][0]*(2.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4]));
    G[61] = det*(K[5]*(K[6]*K[6]*(w[3][0] + 0.5*w[4][0]) + K[7]*K[7]*(w[3][0] + 0.5*w[4][0])) + K[8]*(w[3][0]*(2.0*(K[3]*K[6] + K[4]*K[7]) + 3.0*K[5]*K[8]) + w[4][0]*(1.5*K[5]*K[8] + K[3]*K[6] + K[4]*K[7])));
    G[62] = det*(K[5]*K[8]*w[4][0] + w[3][0]*(2.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]));
    G[63] = det*(K[0]*K[0]*K[0]*K[0]*(w[3][0] + 0.5*w[4][0]) + K[1]*K[1]*(K[0]*K[0]*(w[4][0] + 2.0*w[3][0]) + K[1]*K[1]*(w[3][0] + 0.5*w[4][0])) + K[2]*K[2]*(w[3][0]*(2.0*(K[0]*K[0] + K[1]*K[1]) + K[2]*K[2]) + w[4][0]*(0.5*K[2]*K[2] + K[0]*K[0] + K[1]*K[1])));
    G[64] = det*(0.5*w[4][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[3][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[65] = K[2]*det*(0.5*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[66] = det*(2.0*w[3][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[4][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[67] = det*(K[2]*(w[3][0]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]) + w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])) + K[5]*w[3][0]*(K[0]*K[0] + K[1]*K[1]));
    G[68] = det*(2.0*w[3][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + w[4][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[69] = det*(w[3][0]*(2.0*(K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(K[0]*K[6] + K[1]*K[7]) + K[2]*K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[6]*K[6]*(K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1])) + w[4][0]*(K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(2.0*K[0]*K[6] + K[1]*K[7]) + K[2]*K[8]*(2.0*(K[0]*K[6] + K[1]*K[7]) + K[2]*K[8])));
    G[70] = det*(K[2]*(w[3][0]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]) + w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[8]*w[3][0]*(K[0]*K[0] + K[1]*K[1]));
    G[71] = K[0]*det*(2.0*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[72] = det*(K[0]*(w[3][0]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[6]*w[3][0]*(K[1]*K[1] + K[2]*K[2]));
    G[73] = K[0]*K[2]*det*(w[3][0] + w[4][0]);
    G[74] = det*(0.5*w[4][0]*(K[3]*K[3]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*K[4]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[5]*K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + w[3][0]*(K[0]*K[3]*K[3]*K[6] + K[4]*(K[1]*K[3]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))));
    G[75] = det*(0.5*K[2]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[5]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[76] = det*(2.0*w[3][0]*(K[0]*K[0]*K[3]*K[6] + K[1]*(K[0]*K[4]*K[6] + K[7]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]))) + w[4][0]*(K[3]*K[6]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[4]*K[7]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[5]*K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[77] = det*(K[2]*w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + w[3][0]*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(2.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4])));
    G[78] = det*(2.0*K[0]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[3]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[79] = det*(K[3]*w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[3][0]*(K[0]*(K[4]*K[7] + K[5]*K[8]) + K[6]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[80] = det*(K[0]*K[5]*w[3][0] + K[2]*K[3]*w[4][0]);
    G[81] = (0.5*det*w[4][0]*(K[6]*K[6]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2])) + det*w[3][0]*(K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(2.0*K[0]*K[6] + K[1]*K[7]) + K[2]*K[8]*(2.0*(K[0]*K[6] + K[1]*K[7]) + K[2]*K[8])));
    G[82] = det*(0.5*w[4][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + w[3][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[83] = det*(0.5*K[2]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + K[8]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[84] = det*(2.0*K[0]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[6]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[85] = det*(K[0]*w[3][0]*(K[7]*K[7] + K[8]*K[8]) + K[6]*(w[3][0]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[86] = det*(K[0]*K[8]*w[3][0] + K[2]*K[6]*w[4][0]);
    G[87] = K[1]*det*(2.0*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[88] = det*(K[1]*(w[3][0]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8]) + w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])) + K[7]*w[3][0]*(K[0]*K[0] + K[2]*K[2]));
    G[89] = K[1]*K[2]*det*(w[3][0] + w[4][0]);
    G[90] = det*(2.0*K[1]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[4]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[91] = det*(K[4]*w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + w[3][0]*(K[1]*(K[3]*K[6] + K[5]*K[8]) + K[7]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])));
    G[92] = det*(K[1]*K[5]*w[3][0] + K[2]*K[4]*w[4][0]);
    G[93] = det*(2.0*K[1]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[7]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[94] = det*(K[1]*w[3][0]*(K[6]*K[6] + K[8]*K[8]) + K[7]*(w[3][0]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8]) + w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[95] = det*(K[1]*K[8]*w[3][0] + K[2]*K[7]*w[4][0]);
    G[96] = det*(1.5*w[4][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + 3.0*w[3][0]*(K[0]*K[0]*K[0]*K[3] + K[1]*(K[0]*K[1]*K[3] + K[4]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[3] + K[1]*K[4]) + K[5]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[97] = det*(1.5*w[4][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))) + 3.0*w[3][0]*(K[0]*K[0]*K[0]*K[6] + K[1]*(K[0]*K[1]*K[6] + K[7]*(K[0]*K[0] + K[1]*K[1])) + K[2]*(K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]))));
    G[98] = K[2]*det*(1.5*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + 3.0*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[99] = det*(w[3][0]*(K[0]*K[0]*(2.0*(K[4]*K[7] + K[5]*K[8]) + 6.0*K[3]*K[6]) + K[1]*(4.0*K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(2.0*(K[3]*K[6] + K[5]*K[8]) + 6.0*K[4]*K[7])) + K[2]*(4.0*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(2.0*(K[3]*K[6] + K[4]*K[7]) + 6.0*K[5]*K[8]))) + w[4][0]*(K[0]*K[0]*(3.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[1]*(2.0*K[0]*(K[3]*K[7] + K[4]*K[6]) + K[1]*(3.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8])) + K[2]*(2.0*(K[5]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[2]*(3.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]))));
    G[100] = det*(K[2]*(K[0]*K[3]*(2.0*w[4][0] + 4.0*w[3][0]) + K[1]*K[4]*(2.0*w[4][0] + 4.0*w[3][0])) + K[5]*(w[3][0]*(2.0*(K[0]*K[0] + K[1]*K[1]) + 6.0*K[2]*K[2]) + w[4][0]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1])));
    G[101] = det*(w[3][0]*(4.0*K[0]*K[1]*K[6]*K[7] + K[6]*K[6]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + K[8]*(4.0*K[2]*(K[0]*K[6] + K[1]*K[7]) + K[8]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]))) + w[4][0]*(0.5*(K[6]*K[6]*(K[1]*K[1] + K[2]*K[2]) + K[7]*K[7]*(K[0]*K[0] + K[2]*K[2]) + K[8]*K[8]*(K[0]*K[0] + K[1]*K[1])) + 1.5*K[0]*K[0]*K[6]*K[6] + K[1]*K[7]*(1.5*K[1]*K[7] + 2.0*K[0]*K[6]) + K[2]*K[8]*(1.5*K[2]*K[8] + 2.0*(K[0]*K[6] + K[1]*K[7]))));
    G[102] = det*(K[2]*(K[0]*K[6]*(2.0*w[4][0] + 4.0*w[3][0]) + K[1]*K[7]*(2.0*w[4][0] + 4.0*w[3][0])) + K[8]*(w[3][0]*(2.0*(K[0]*K[0] + K[1]*K[1]) + 6.0*K[2]*K[2]) + w[4][0]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1])));
    G[103] = det*(K[2]*K[2]*w[4][0] + w[3][0]*(2.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]));
    G[104] = det*(w[3][0]*(K[3]*K[3]*(3.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[4]*(2.0*K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(3.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])) + K[5]*(2.0*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(K[0]*K[3] + K[1]*K[4])) + K[5]*(3.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]))) + w[4][0]*(K[3]*K[3]*(0.5*(K[1]*K[7] + K[2]*K[8]) + 1.5*K[0]*K[6]) + K[4]*(K[3]*(K[0]*K[7] + K[1]*K[6]) + K[4]*(0.5*(K[0]*K[6] + K[2]*K[8]) + 1.5*K[1]*K[7])) + K[5]*(0.5*K[5]*(K[0]*K[6] + K[1]*K[7]) + K[2]*(K[3]*K[6] + K[4]*K[7]) + K[8]*(1.5*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))));
    G[105] = det*(K[2]*(K[3]*K[3]*(w[3][0] + 0.5*w[4][0]) + K[4]*K[4]*(w[3][0] + 0.5*w[4][0])) + K[5]*(w[3][0]*(2.0*(K[0]*K[3] + K[1]*K[4]) + 3.0*K[2]*K[5]) + w[4][0]*(1.5*K[2]*K[5] + K[0]*K[3] + K[1]*K[4])));
    G[106] = det*(K[2]*(K[6]*K[6]*(w[3][0] + 0.5*w[4][0]) + K[7]*K[7]*(w[3][0] + 0.5*w[4][0])) + K[8]*(w[3][0]*(2.0*(K[0]*K[6] + K[1]*K[7]) + 3.0*K[2]*K[8]) + w[4][0]*(1.5*K[2]*K[8] + K[0]*K[6] + K[1]*K[7])));
    G[107] = det*(K[2]*K[8]*w[4][0] + w[3][0]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]));
    G[108] = det*(K[0]*(K[1]*K[7]*(w[4][0] + 2.0*w[3][0]) + K[2]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[6]*(w[3][0]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[4][0]*(0.5*(K[1]*K[1] + K[2]*K[2]) + 1.5*K[0]*K[0])));
    G[109] = det*(w[3][0]*(K[6]*K[6]*(2.0*(K[1]*K[4] + K[2]*K[5]) + 6.0*K[0]*K[3]) + K[7]*(4.0*K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(2.0*(K[0]*K[3] + K[2]*K[5]) + 6.0*K[1]*K[4])) + K[8]*(4.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4])) + K[8]*(2.0*(K[0]*K[3] + K[1]*K[4]) + 6.0*K[2]*K[5]))) + w[4][0]*(K[6]*K[6]*(3.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(2.0*K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(3.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])) + K[8]*(2.0*(K[6]*(K[0]*K[5] + K[2]*K[3]) + K[7]*(K[1]*K[5] + K[2]*K[4])) + K[8]*(3.0*K[2]*K[5] + K[0]*K[3] + K[1]*K[4]))));
    G[110] = det*(w[3][0]*(2.0*(K[6]*(K[1]*K[4] + K[2]*K[5]) + K[7]*(K[0]*K[4] + K[1]*K[3]) + K[8]*(K[0]*K[5] + K[2]*K[3])) + 6.0*K[0]*K[3]*K[6]) + w[4][0]*(K[6]*(3.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*(K[0]*K[4] + K[1]*K[3]) + K[8]*(K[0]*K[5] + K[2]*K[3])));
    G[111] = det*(1.5*w[4][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + 3.0*w[3][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[112] = det*(K[0]*(K[7]*K[7]*(w[4][0] + 2.0*w[3][0]) + K[8]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[6]*(w[3][0]*(4.0*(K[1]*K[7] + K[2]*K[8]) + 6.0*K[0]*K[6]) + w[4][0]*(2.0*(K[1]*K[7] + K[2]*K[8]) + 3.0*K[0]*K[6])));
    G[113] = det*(K[2]*w[3][0]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(w[3][0]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7]) + w[4][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[114] = det*(K[0]*K[6]*w[4][0] + w[3][0]*(2.0*K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[115] = det*(K[3]*(K[4]*K[7]*(w[4][0] + 2.0*w[3][0]) + K[5]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[6]*(w[3][0]*(3.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[4][0]*(0.5*(K[4]*K[4] + K[5]*K[5]) + 1.5*K[3]*K[3])));
    G[116] = det*(1.5*w[4][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))) + 3.0*w[3][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))));
    G[117] = det*(K[3]*(K[7]*K[7]*(w[4][0] + 2.0*w[3][0]) + K[8]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[6]*(w[3][0]*(4.0*(K[4]*K[7] + K[5]*K[8]) + 6.0*K[3]*K[6]) + w[4][0]*(2.0*(K[4]*K[7] + K[5]*K[8]) + 3.0*K[3]*K[6])));
    G[118] = det*(K[5]*w[3][0]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(w[3][0]*(2.0*K[5]*K[8] + K[3]*K[6] + K[4]*K[7]) + w[4][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8])));
    G[119] = det*(K[3]*K[6]*w[4][0] + w[3][0]*(2.0*K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[120] = det*(K[6]*K[6]*K[6]*K[6]*(w[3][0] + 0.5*w[4][0]) + K[7]*K[7]*(K[6]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[7]*K[7]*(w[3][0] + 0.5*w[4][0])) + K[8]*K[8]*(w[3][0]*(2.0*(K[6]*K[6] + K[7]*K[7]) + K[8]*K[8]) + w[4][0]*(0.5*K[8]*K[8] + K[6]*K[6] + K[7]*K[7])));
    G[121] = K[6]*det*(1.5*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + 3.0*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[122] = det*(2.0*w[3][0]*(K[0]*K[3]*K[6]*K[6] + K[7]*(K[1]*K[4]*K[7] + K[6]*(K[0]*K[4] + K[1]*K[3])) + K[8]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + w[4][0]*(K[6]*K[6]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[7]*K[7]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[8]*K[8]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[123] = det*(2.0*w[3][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))) + w[4][0]*(K[0]*K[6]*K[6]*K[6] + K[7]*(K[1]*K[6]*K[6] + K[7]*(K[0]*K[6] + K[1]*K[7])) + K[8]*(K[2]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]))));
    G[124] = det*(2.0*K[7]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[1]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[125] = det*(2.0*w[3][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))) + w[4][0]*(K[3]*K[6]*K[6]*K[6] + K[7]*(K[4]*K[6]*K[6] + K[7]*(K[3]*K[6] + K[4]*K[7])) + K[8]*(K[5]*(K[6]*K[6] + K[7]*K[7]) + K[8]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]))));
    G[126] = det*(2.0*K[7]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[4]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[127] = K[7]*det*(2.0*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[128] = det*(2.0*K[8]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[2]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[129] = det*(2.0*K[8]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[5]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[130] = K[8]*det*(2.0*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[131] = det*(K[6]*K[6]*w[4][0] + w[3][0]*(2.0*K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[132] = det*(0.5*K[6]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[0]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[133] = det*(K[0]*K[7]*w[3][0] + K[1]*K[6]*w[4][0]);
    G[134] = det*(0.5*K[6]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[3]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[135] = det*(K[3]*K[7]*w[3][0] + K[4]*K[6]*w[4][0]);
    G[136] = K[6]*det*(0.5*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[137] = K[6]*K[7]*det*(w[3][0] + w[4][0]);
    G[138] = K[6]*K[8]*det*(w[3][0] + w[4][0]);
    G[139] = det*(K[0]*(K[1]*K[4]*(w[4][0] + 2.0*w[3][0]) + K[2]*K[5]*(w[4][0] + 2.0*w[3][0])) + K[3]*(w[3][0]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[4][0]*(0.5*(K[1]*K[1] + K[2]*K[2]) + 1.5*K[0]*K[0])));
    G[140] = det*(K[0]*(K[4]*K[4]*(w[4][0] + 2.0*w[3][0]) + K[5]*K[5]*(w[4][0] + 2.0*w[3][0])) + K[3]*(w[3][0]*(4.0*(K[1]*K[4] + K[2]*K[5]) + 6.0*K[0]*K[3]) + w[4][0]*(2.0*(K[1]*K[4] + K[2]*K[5]) + 3.0*K[0]*K[3])));
    G[141] = det*(K[8]*w[4][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + w[3][0]*(K[2]*(K[3]*K[6] + K[4]*K[7]) + K[5]*(2.0*K[2]*K[8] + K[0]*K[6] + K[1]*K[7])));
    G[142] = det*(K[0]*K[3]*w[4][0] + w[3][0]*(2.0*K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[143] = K[3]*det*(1.5*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + 3.0*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[144] = det*(K[3]*(K[4]*K[7]*(2.0*w[4][0] + 4.0*w[3][0]) + K[5]*K[8]*(2.0*w[4][0] + 4.0*w[3][0])) + K[6]*(w[3][0]*(2.0*(K[4]*K[4] + K[5]*K[5]) + 6.0*K[3]*K[3]) + w[4][0]*(3.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5])));
    G[145] = det*(2.0*K[5]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[2]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[146] = K[5]*det*(2.0*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[147] = det*(2.0*K[5]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[8]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[148] = det*(K[3]*K[3]*w[4][0] + w[3][0]*(2.0*K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[149] = det*(K[3]*(K[7]*K[7]*(w[3][0] + 0.5*w[4][0]) + K[8]*K[8]*(w[3][0] + 0.5*w[4][0])) + K[6]*(w[3][0]*(2.0*(K[4]*K[7] + K[5]*K[8]) + 3.0*K[3]*K[6]) + w[4][0]*(1.5*K[3]*K[6] + K[4]*K[7] + K[5]*K[8])));
    G[150] = det*(0.5*K[3]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[0]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[151] = det*(K[0]*K[4]*w[3][0] + K[1]*K[3]*w[4][0]);
    G[152] = K[3]*det*(0.5*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[153] = K[3]*K[4]*det*(w[3][0] + w[4][0]);
    G[154] = det*(0.5*K[3]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + K[6]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[155] = det*(K[3]*K[7]*w[4][0] + K[4]*K[6]*w[3][0]);
    G[156] = det*(K[3]*K[8]*w[4][0] + K[5]*K[6]*w[3][0]);
    G[157] = K[0]*det*(1.5*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + 3.0*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[158] = det*(K[0]*(K[1]*K[4]*(2.0*w[4][0] + 4.0*w[3][0]) + K[2]*K[5]*(2.0*w[4][0] + 4.0*w[3][0])) + K[3]*(w[3][0]*(2.0*(K[1]*K[1] + K[2]*K[2]) + 6.0*K[0]*K[0]) + w[4][0]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[159] = det*(K[0]*(K[1]*K[7]*(2.0*w[4][0] + 4.0*w[3][0]) + K[2]*K[8]*(2.0*w[4][0] + 4.0*w[3][0])) + K[6]*(w[3][0]*(2.0*(K[1]*K[1] + K[2]*K[2]) + 6.0*K[0]*K[0]) + w[4][0]*(3.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2])));
    G[160] = K[2]*det*(2.0*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[161] = det*(2.0*K[2]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]) + K[5]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[162] = det*(2.0*K[2]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[8]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[163] = det*(K[0]*K[0]*w[4][0] + w[3][0]*(2.0*K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[164] = det*(K[0]*(K[4]*K[4]*(w[3][0] + 0.5*w[4][0]) + K[5]*K[5]*(w[3][0] + 0.5*w[4][0])) + K[3]*(w[3][0]*(2.0*(K[1]*K[4] + K[2]*K[5]) + 3.0*K[0]*K[3]) + w[4][0]*(1.5*K[0]*K[3] + K[1]*K[4] + K[2]*K[5])));
    G[165] = det*(K[0]*(K[7]*K[7]*(w[3][0] + 0.5*w[4][0]) + K[8]*K[8]*(w[3][0] + 0.5*w[4][0])) + K[6]*(w[3][0]*(2.0*(K[1]*K[7] + K[2]*K[8]) + 3.0*K[0]*K[6]) + w[4][0]*(1.5*K[0]*K[6] + K[1]*K[7] + K[2]*K[8])));
    G[166] = K[0]*det*(0.5*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[167] = K[0]*K[1]*det*(w[3][0] + w[4][0]);
    G[168] = det*(0.5*K[0]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[3]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[169] = det*(K[0]*K[4]*w[4][0] + K[1]*K[3]*w[3][0]);
    G[170] = det*(0.5*K[0]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + K[6]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[171] = det*(K[0]*K[7]*w[4][0] + K[1]*K[6]*w[3][0]);
    G[172] = det*(K[0]*K[8]*w[4][0] + K[2]*K[6]*w[3][0]);
    G[173] = det*(0.5*K[7]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[1]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[174] = det*(2.0*K[6]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]) + K[0]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[175] = det*(0.5*K[7]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[4]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[176] = det*(2.0*K[6]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]) + K[3]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[177] = K[7]*det*(0.5*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[178] = K[6]*det*(2.0*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[179] = det*(K[1]*(K[0]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[2]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[7]*(w[3][0]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + w[4][0]*(0.5*(K[0]*K[0] + K[2]*K[2]) + 1.5*K[1]*K[1])));
    G[180] = det*(w[3][0]*(2.0*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(K[0]*K[3] + K[2]*K[5]) + K[8]*(K[1]*K[5] + K[2]*K[4])) + 6.0*K[1]*K[4]*K[7]) + w[4][0]*(K[6]*(K[0]*K[4] + K[1]*K[3]) + K[7]*(3.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]) + K[8]*(K[1]*K[5] + K[2]*K[4])));
    G[181] = det*(K[1]*(K[6]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[8]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[7]*(w[3][0]*(4.0*(K[0]*K[6] + K[2]*K[8]) + 6.0*K[1]*K[7]) + w[4][0]*(2.0*(K[0]*K[6] + K[2]*K[8]) + 3.0*K[1]*K[7])));
    G[182] = det*(K[1]*K[7]*w[4][0] + w[3][0]*(2.0*K[1]*K[7] + K[0]*K[6] + K[2]*K[8]));
    G[183] = det*(K[4]*(K[3]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[5]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[7]*(w[3][0]*(3.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5]) + w[4][0]*(0.5*(K[3]*K[3] + K[5]*K[5]) + 1.5*K[4]*K[4])));
    G[184] = det*(K[4]*(K[6]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[8]*K[8]*(w[4][0] + 2.0*w[3][0])) + K[7]*(w[3][0]*(4.0*(K[3]*K[6] + K[5]*K[8]) + 6.0*K[4]*K[7]) + w[4][0]*(2.0*(K[3]*K[6] + K[5]*K[8]) + 3.0*K[4]*K[7])));
    G[185] = det*(K[4]*K[7]*w[4][0] + w[3][0]*(2.0*K[4]*K[7] + K[3]*K[6] + K[5]*K[8]));
    G[186] = K[7]*det*(1.5*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + 3.0*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[187] = det*(K[7]*K[7]*w[4][0] + w[3][0]*(2.0*K[7]*K[7] + K[6]*K[6] + K[8]*K[8]));
    G[188] = K[7]*K[8]*det*(w[3][0] + w[4][0]);
    G[189] = det*(0.5*K[4]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[1]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[190] = K[4]*det*(0.5*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[191] = det*(0.5*K[4]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + K[7]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[192] = det*(K[1]*(K[0]*K[3]*(w[4][0] + 2.0*w[3][0]) + K[2]*K[5]*(w[4][0] + 2.0*w[3][0])) + K[4]*(w[3][0]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]) + w[4][0]*(0.5*(K[0]*K[0] + K[2]*K[2]) + 1.5*K[1]*K[1])));
    G[193] = det*(K[1]*(K[3]*K[3]*(w[4][0] + 2.0*w[3][0]) + K[5]*K[5]*(w[4][0] + 2.0*w[3][0])) + K[4]*(w[3][0]*(4.0*(K[0]*K[3] + K[2]*K[5]) + 6.0*K[1]*K[4]) + w[4][0]*(2.0*(K[0]*K[3] + K[2]*K[5]) + 3.0*K[1]*K[4])));
    G[194] = det*(K[1]*K[4]*w[4][0] + w[3][0]*(2.0*K[1]*K[4] + K[0]*K[3] + K[2]*K[5]));
    G[195] = K[4]*det*(1.5*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + 3.0*w[3][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]));
    G[196] = det*(K[4]*(K[3]*K[6]*(2.0*w[4][0] + 4.0*w[3][0]) + K[5]*K[8]*(2.0*w[4][0] + 4.0*w[3][0])) + K[7]*(w[3][0]*(2.0*(K[3]*K[3] + K[5]*K[5]) + 6.0*K[4]*K[4]) + w[4][0]*(3.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5])));
    G[197] = det*(K[4]*K[4]*w[4][0] + w[3][0]*(2.0*K[4]*K[4] + K[3]*K[3] + K[5]*K[5]));
    G[198] = det*(K[4]*(K[6]*K[6]*(w[3][0] + 0.5*w[4][0]) + K[8]*K[8]*(w[3][0] + 0.5*w[4][0])) + K[7]*(w[3][0]*(2.0*(K[3]*K[6] + K[5]*K[8]) + 3.0*K[4]*K[7]) + w[4][0]*(1.5*K[4]*K[7] + K[3]*K[6] + K[5]*K[8])));
    G[199] = det*(K[4]*K[8]*w[4][0] + K[5]*K[7]*w[3][0]);
    G[200] = K[1]*det*(0.5*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[201] = det*(0.5*K[1]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[4]*w[3][0]*(K[0]*K[3] + K[1]*K[4] + K[2]*K[5]));
    G[202] = det*(0.5*K[1]*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + K[7]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[203] = K[1]*det*(1.5*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + 3.0*w[3][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]));
    G[204] = det*(K[1]*(K[0]*K[3]*(2.0*w[4][0] + 4.0*w[3][0]) + K[2]*K[5]*(2.0*w[4][0] + 4.0*w[3][0])) + K[4]*(w[3][0]*(2.0*(K[0]*K[0] + K[2]*K[2]) + 6.0*K[1]*K[1]) + w[4][0]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2])));
    G[205] = det*(K[1]*(K[0]*K[6]*(2.0*w[4][0] + 4.0*w[3][0]) + K[2]*K[8]*(2.0*w[4][0] + 4.0*w[3][0])) + K[7]*(w[3][0]*(2.0*(K[0]*K[0] + K[2]*K[2]) + 6.0*K[1]*K[1]) + w[4][0]*(3.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2])));
    G[206] = det*(K[1]*K[1]*w[4][0] + w[3][0]*(2.0*K[1]*K[1] + K[0]*K[0] + K[2]*K[2]));
    G[207] = det*(K[1]*(K[3]*K[3]*(w[3][0] + 0.5*w[4][0]) + K[5]*K[5]*(w[3][0] + 0.5*w[4][0])) + K[4]*(w[3][0]*(2.0*(K[0]*K[3] + K[2]*K[5]) + 3.0*K[1]*K[4]) + w[4][0]*(1.5*K[1]*K[4] + K[0]*K[3] + K[2]*K[5])));
    G[208] = det*(K[1]*(K[6]*K[6]*(w[3][0] + 0.5*w[4][0]) + K[8]*K[8]*(w[3][0] + 0.5*w[4][0])) + K[7]*(w[3][0]*(2.0*(K[0]*K[6] + K[2]*K[8]) + 3.0*K[1]*K[7]) + w[4][0]*(1.5*K[1]*K[7] + K[0]*K[6] + K[2]*K[8])));
    G[209] = det*(K[1]*K[8]*w[4][0] + K[2]*K[7]*w[3][0]);
    G[210] = det*(0.5*K[8]*w[4][0]*(K[0]*K[0] + K[1]*K[1] + K[2]*K[2]) + K[2]*w[3][0]*(K[0]*K[6] + K[1]*K[7] + K[2]*K[8]));
    G[211] = det*(0.5*K[8]*w[4][0]*(K[3]*K[3] + K[4]*K[4] + K[5]*K[5]) + K[5]*w[3][0]*(K[3]*K[6] + K[4]*K[7] + K[5]*K[8]));
    G[212] = K[8]*det*(0.5*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[213] = det*(K[2]*(K[0]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[1]*K[7]*(w[4][0] + 2.0*w[3][0])) + K[8]*(w[3][0]*(3.0*K[2]*K[2] + K[0]*K[0] + K[1]*K[1]) + w[4][0]*(0.5*(K[0]*K[0] + K[1]*K[1]) + 1.5*K[2]*K[2])));
    G[214] = det*(K[2]*(K[6]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[7]*K[7]*(w[4][0] + 2.0*w[3][0])) + K[8]*(w[3][0]*(4.0*(K[0]*K[6] + K[1]*K[7]) + 6.0*K[2]*K[8]) + w[4][0]*(2.0*(K[0]*K[6] + K[1]*K[7]) + 3.0*K[2]*K[8])));
    G[215] = det*(K[5]*(K[3]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[4]*K[7]*(w[4][0] + 2.0*w[3][0])) + K[8]*(w[3][0]*(3.0*K[5]*K[5] + K[3]*K[3] + K[4]*K[4]) + w[4][0]*(0.5*(K[3]*K[3] + K[4]*K[4]) + 1.5*K[5]*K[5])));
    G[216] = det*(K[5]*(K[6]*K[6]*(w[4][0] + 2.0*w[3][0]) + K[7]*K[7]*(w[4][0] + 2.0*w[3][0])) + K[8]*(w[3][0]*(4.0*(K[3]*K[6] + K[4]*K[7]) + 6.0*K[5]*K[8]) + w[4][0]*(2.0*(K[3]*K[6] + K[4]*K[7]) + 3.0*K[5]*K[8])));
    G[217] = K[8]*det*(1.5*w[4][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]) + 3.0*w[3][0]*(K[6]*K[6] + K[7]*K[7] + K[8]*K[8]));
    G[218] = det*(K[8]*K[8]*w[4][0] + w[3][0]*(2.0*K[8]*K[8] + K[6]*K[6] + K[7]*K[7]));
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    
    // Loop quadrature points for integral.
    // Number of operations to compute element tensor for following IP loop = 7200
    for (unsigned int ip = 0; ip < 4; ip++)
    {
      
      // Coefficient declarations.
      double F0 = 0.0;
      double F1 = 0.0;
      double F2 = 0.0;
      double F3 = 0.0;
      double F4 = 0.0;
      double F5 = 0.0;
      double F6 = 0.0;
      double F7 = 0.0;
      double F8 = 0.0;
      double F9 = 0.0;
      double F10 = 0.0;
      double F11 = 0.0;
      
      // Total number of operations to compute function values = 36
      for (unsigned int r = 0; r < 2; r++)
      {
        F0 += FE0_C0_D001[ip][r]*w[0][nzc3[r]];
        F1 += FE0_C0_D001[ip][r]*w[0][nzc2[r]];
        F2 += FE0_C0_D001[ip][r]*w[0][nzc1[r]];
        F3 += FE0_C0_D001[ip][r]*w[0][nzc7[r]];
        F4 += FE0_C0_D001[ip][r]*w[0][nzc6[r]];
        F5 += FE0_C0_D001[ip][r]*w[0][nzc5[r]];
        F6 += FE0_C0_D001[ip][r]*w[0][nzc11[r]];
        F7 += FE0_C0_D001[ip][r]*w[0][nzc10[r]];
        F8 += FE0_C0_D001[ip][r]*w[0][nzc9[r]];
      }// end loop over 'r'
      
      // Total number of operations to compute function values = 24
      for (unsigned int r = 0; r < 4; r++)
      {
        F9 += FE0_C0[ip][r]*w[1][nzc0[r]];
        F10 += FE0_C0[ip][r]*w[1][nzc4[r]];
        F11 += FE0_C0[ip][r]*w[1][nzc8[r]];
      }// end loop over 'r'
      
      // Number of operations to compute ip constants: 1680
      double I[12];
      // Number of operations: 186
      I[0] = W4[ip]*(F0*G[15] + F1*(G[26] + F0*G[7] + F1*G[19]) + F2*(G[34] + F0*G[11] + F1*G[22] + F2*G[30]) + F3*G[38] + F4*(G[42] + F3*G[7] + F4*G[19]) + F5*(G[46] + F3*G[11] + F4*G[22] + F5*G[30]) + F6*(G[55] + F0*G[12] + F1*(G[23] + F0*G[4] + F1*G[16]) + F2*(G[31] + F0*G[8] + F1*G[6] + F2*G[27]) + F3*G[35] + F4*(G[39] + F3*G[4] + F4*G[16]) + F5*(G[43] + F3*G[8] + F4*G[6] + F5*G[27]) + F6*G[49] + G[0]*(F0*F0 + F3*F3 + F6*F6)) + F7*(G[60] + F0*(G[13] + F0*G[1] + F1*G[5]) + F1*G[24] + F2*(G[32] + F0*G[9] + F1*G[20] + F2*G[28]) + F3*(G[36] + F3*G[1] + F4*G[5]) + F4*G[40] + F5*(G[44] + F3*G[9] + F4*G[20] + F5*G[28]) + F6*(G[52] + F6*G[47] + F7*G[50]) + F7*G[57] + G[17]*(F1*F1 + F4*F4 + F7*F7)) + F8*(G[62] + F0*G[14] + F1*(G[25] + F0*G[6] + F1*G[18]) + F2*(G[33] + F0*G[10] + F1*G[21] + F2*G[29]) + F3*G[37] + F4*(G[41] + F3*G[6] + F4*G[18]) + F5*(G[45] + F3*G[10] + F4*G[21] + F5*G[29]) + F6*(G[54] + F6*G[48]) + F7*(G[59] + F6*G[51] + F7*G[56]) + F8*(G[61] + F6*G[53] + F7*G[58] + F8*G[29]) + G[2]*(F0*F0 + F3*F3)) + G[3]*(F0*F0 + F3*F3));
      
      // Number of operations: 186
      I[1] = W4[ip]*(F0*G[73] + F1*(G[80] + F0*G[67] + F1*G[75]) + F2*(G[86] + F0*G[70] + F1*G[77] + F2*G[83]) + F3*G[89] + F4*(G[92] + F3*G[67] + F4*G[75]) + F5*(G[95] + F3*G[70] + F4*G[77] + F5*G[83]) + F6*(G[103] + F0*G[71] + F1*(G[78] + F0*G[66] + F1*G[1]) + F2*(G[84] + F0*G[68] + F1*G[76] + F2*G[81]) + F3*G[87] + F4*(G[90] + F3*G[66] + F4*G[1]) + F5*(G[93] + F3*G[68] + F4*G[76] + F5*G[81]) + F6*G[98] + G[63]*(F0*F0 + F3*F3 + F6*F6)) + F7*(G[55] + F0*(G[12] + F0*G[0] + F1*G[4]) + F1*G[23] + F2*(G[31] + F0*G[8] + F1*G[6] + F2*G[27]) + F3*(G[35] + F3*G[0] + F4*G[4]) + F4*G[39] + F5*(G[43] + F3*G[8] + F4*G[6] + F5*G[27]) + F6*(G[100] + F6*G[96] + F7*G[47]) + F7*G[105] + G[16]*(F1*F1 + F4*F4 + F7*F7)) + F8*(G[107] + F0*G[72] + F1*(G[79] + F0*G[8] + F1*G[74]) + F2*(G[85] + F0*G[69] + F1*G[10] + F2*G[82]) + F3*G[88] + F4*(G[91] + F3*G[8] + F4*G[74]) + F5*(G[94] + F3*G[69] + F4*G[10] + F5*G[82]) + F6*(G[102] + F6*G[97]) + F7*(G[54] + F6*G[99] + F7*G[104]) + F8*(G[106] + F6*G[101] + F7*G[53] + F8*G[82]) + G[64]*(F0*F0 + F3*F3)) + G[65]*(F0*F0 + F3*F3));
      
      // Number of operations: 186
      I[2] = W4[ip]*(F0*(G[114] + F0*G[108] + F3*G[88] + F4*(G[91] + F3*G[8] + F4*G[74]) + F5*(G[94] + F3*G[69] + F4*G[10] + F5*G[82]) + F6*G[70] + F7*(G[11] + F6*G[8] + F7*G[74]) + F8*(G[113] + F6*G[69] + F7*G[10] + F8*G[82]) + G[64]*(F0*F0 + F3*F3 + F6*F6)) + F1*(G[119] + F0*(G[110] + F0*G[48] + F1*G[104]) + F1*G[115] + F3*(G[37] + F3*G[2] + F4*G[6]) + F4*G[41] + F5*(G[45] + F3*G[10] + F4*G[21] + F5*G[29]) + F6*(G[77] + F6*G[2] + F7*G[6]) + F7*G[22] + F8*(G[118] + F6*G[10] + F7*G[21] + F8*G[29]) + G[18]*(F1*F1 + F4*F4 + F7*F7)) + F2*(G[131] + F0*(G[112] + F0*G[101]) + F1*(G[117] + F0*G[109] + F1*G[58]) + F2*(G[121] + F0*G[111] + F1*G[116] + F2*G[120]) + F3*G[124] + F4*(G[126] + F3*G[122] + F4*G[28]) + F5*(G[127] + F3*G[123] + F4*G[125] + F5*G[120]) + F6*G[128] + F7*(G[129] + F6*G[122] + F7*G[28]) + F8*(G[130] + F6*G[123] + F7*G[125] + F8*G[120]) + G[81]*(F3*F3 + F6*F6)) + F3*G[133] + F4*(G[135] + F3*G[31] + F4*G[134]) + F5*(G[137] + F3*G[85] + F4*G[33] + F5*G[136]) + F6*G[86] + F7*(G[34] + F6*G[31] + F7*G[134]) + F8*(G[138] + F6*G[85] + F7*G[33] + F8*G[136]) + G[132]*(F3*F3 + F6*F6));
      
      // Number of operations: 186
      I[3] = W4[ip]*(F0*(G[142] + F0*G[139] + F3*G[35] + F4*(G[39] + F3*G[4] + F4*G[16]) + F5*(G[43] + F3*G[8] + F4*G[6] + F5*G[27]) + F6*G[67] + F7*(G[7] + F6*G[4] + F7*G[16]) + F8*(G[141] + F6*G[8] + F7*G[6] + F8*G[27]) + G[0]*(F0*F0 + F3*F3 + F6*F6)) + F1*(G[148] + F0*(G[140] + F0*G[47] + F1*G[50]) + F1*G[143] + F3*(G[36] + F3*G[1] + F4*G[5]) + F4*G[40] + F5*(G[44] + F3*G[9] + F4*G[20] + F5*G[28]) + F6*(G[145] + F6*G[1] + F7*G[5]) + F7*G[146] + F8*(G[147] + F6*G[9] + F7*G[20] + F8*G[28]) + G[17]*(F1*F1 + F4*F4 + F7*F7)) + F2*(G[119] + F0*(G[110] + F0*G[48]) + F1*(G[144] + F0*G[51] + F1*G[56]) + F2*(G[149] + F0*G[53] + F1*G[58] + F2*G[29]) + F3*G[37] + F4*(G[41] + F3*G[6] + F4*G[18]) + F5*(G[45] + F3*G[10] + F4*G[21] + F5*G[29]) + F6*G[77] + F7*(G[22] + F6*G[6] + F7*G[18]) + F8*(G[118] + F6*G[10] + F7*G[21] + F8*G[29]) + G[2]*(F3*F3 + F6*F6)) + F3*G[151] + F4*(G[153] + F3*G[23] + F4*G[152]) + F5*(G[155] + F3*G[79] + F4*G[25] + F5*G[154]) + F6*G[80] + F7*(G[26] + F6*G[23] + F7*G[152]) + F8*(G[156] + F6*G[79] + F7*G[25] + F8*G[154]) + G[150]*(F3*F3 + F6*F6));
      
      // Number of operations: 186
      I[4] = W4[ip]*(F0*(G[163] + F0*G[157] + F3*G[87] + F4*(G[90] + F3*G[66] + F4*G[1]) + F5*(G[93] + F3*G[68] + F4*G[76] + F5*G[81]) + F6*G[160] + F7*(G[161] + F6*G[66] + F7*G[1]) + F8*(G[162] + F6*G[68] + F7*G[76] + F8*G[81]) + G[63]*(F0*F0 + F3*F3 + F6*F6)) + F1*(G[142] + F0*(G[158] + F0*G[96] + F1*G[47]) + F1*G[164] + F3*(G[35] + F3*G[0] + F4*G[4]) + F4*G[39] + F5*(G[43] + F3*G[8] + F4*G[6] + F5*G[27]) + F6*(G[67] + F6*G[0] + F7*G[4]) + F7*G[7] + F8*(G[141] + F6*G[8] + F7*G[6] + F8*G[27]) + G[16]*(F1*F1 + F4*F4 + F7*F7)) + F2*(G[114] + F0*(G[159] + F0*G[97]) + F1*(G[110] + F0*G[99] + F1*G[104]) + F2*(G[165] + F0*G[101] + F1*G[53] + F2*G[82]) + F3*G[88] + F4*(G[91] + F3*G[8] + F4*G[74]) + F5*(G[94] + F3*G[69] + F4*G[10] + F5*G[82]) + F6*G[70] + F7*(G[11] + F6*G[8] + F7*G[74]) + F8*(G[113] + F6*G[69] + F7*G[10] + F8*G[82]) + G[64]*(F3*F3 + F6*F6)) + F3*G[167] + F4*(G[169] + F3*G[12] + F4*G[168]) + F5*(G[171] + F3*G[72] + F4*G[14] + F5*G[170]) + F6*G[73] + F7*(G[15] + F6*G[12] + F7*G[168]) + F8*(G[172] + F6*G[72] + F7*G[14] + F8*G[170]) + G[166]*(F3*F3 + F6*F6));
      
      // Number of operations: 186
      I[5] = W4[ip]*(F0*G[171] + F1*(G[155] + F0*G[43] + F1*G[175]) + F2*(G[137] + F0*G[94] + F1*G[45] + F2*G[177]) + F3*(G[182] + F0*G[72] + F1*(G[79] + F0*G[8] + F1*G[74]) + F2*(G[85] + F0*G[69] + F1*G[10] + F2*G[82]) + F3*G[179] + F6*G[70] + F7*(G[11] + F6*G[8] + F7*G[74]) + F8*(G[113] + F6*G[69] + F7*G[10] + F8*G[82]) + G[64]*(F0*F0 + F3*F3 + F6*F6)) + F4*(G[185] + F0*(G[14] + F0*G[2] + F1*G[6]) + F1*G[25] + F2*(G[33] + F0*G[10] + F1*G[21] + F2*G[29]) + F3*(G[180] + F3*G[48] + F4*G[104]) + F4*G[183] + F6*(G[77] + F6*G[2] + F7*G[6]) + F7*G[22] + F8*(G[118] + F6*G[10] + F7*G[21] + F8*G[29]) + G[18]*(F1*F1 + F4*F4 + F7*F7)) + F5*(G[187] + F0*G[174] + F1*(G[176] + F0*G[122] + F1*G[28]) + F2*(G[178] + F0*G[123] + F1*G[125] + F2*G[120]) + F3*(G[181] + F3*G[101]) + F4*(G[184] + F3*G[109] + F4*G[58]) + F5*(G[186] + F3*G[111] + F4*G[116] + F5*G[120]) + F6*G[128] + F7*(G[129] + F6*G[122] + F7*G[28]) + F8*(G[130] + F6*G[123] + F7*G[125] + F8*G[120]) + G[81]*(F0*F0 + F6*F6)) + F6*G[95] + F7*(G[46] + F6*G[43] + F7*G[175]) + F8*(G[188] + F6*G[94] + F7*G[45] + F8*G[177]) + G[173]*(F0*F0 + F6*F6));
      
      // Number of operations: 186
      I[6] = W4[ip]*(F0*G[169] + F1*(G[153] + F0*G[39] + F1*G[190]) + F2*(G[135] + F0*G[91] + F1*G[41] + F2*G[191]) + F3*(G[194] + F0*G[12] + F1*(G[23] + F0*G[4] + F1*G[16]) + F2*(G[31] + F0*G[8] + F1*G[6] + F2*G[27]) + F3*G[192] + F6*G[67] + F7*(G[7] + F6*G[4] + F7*G[16]) + F8*(G[141] + F6*G[8] + F7*G[6] + F8*G[27]) + G[0]*(F0*F0 + F3*F3 + F6*F6)) + F4*(G[197] + F0*(G[13] + F0*G[1] + F1*G[5]) + F1*G[24] + F2*(G[32] + F0*G[9] + F1*G[20] + F2*G[28]) + F3*(G[193] + F3*G[47] + F4*G[50]) + F4*G[195] + F6*(G[145] + F6*G[1] + F7*G[5]) + F7*G[146] + F8*(G[147] + F6*G[9] + F7*G[20] + F8*G[28]) + G[17]*(F1*F1 + F4*F4 + F7*F7)) + F5*(G[185] + F0*G[14] + F1*(G[25] + F0*G[6] + F1*G[18]) + F2*(G[33] + F0*G[10] + F1*G[21] + F2*G[29]) + F3*(G[180] + F3*G[48]) + F4*(G[196] + F3*G[51] + F4*G[56]) + F5*(G[198] + F3*G[53] + F4*G[58] + F5*G[29]) + F6*G[77] + F7*(G[22] + F6*G[6] + F7*G[18]) + F8*(G[118] + F6*G[10] + F7*G[21] + F8*G[29]) + G[2]*(F0*F0 + F6*F6)) + F6*G[92] + F7*(G[42] + F6*G[39] + F7*G[190]) + F8*(G[199] + F6*G[91] + F7*G[41] + F8*G[191]) + G[189]*(F0*F0 + F6*F6));
      
      // Number of operations: 186
      I[7] = W4[ip]*(F0*G[167] + F1*(G[151] + F0*G[35] + F1*G[201]) + F2*(G[133] + F0*G[88] + F1*G[37] + F2*G[202]) + F3*(G[206] + F0*G[71] + F1*(G[78] + F0*G[66] + F1*G[1]) + F2*(G[84] + F0*G[68] + F1*G[76] + F2*G[81]) + F3*G[203] + F6*G[160] + F7*(G[161] + F6*G[66] + F7*G[1]) + F8*(G[162] + F6*G[68] + F7*G[76] + F8*G[81]) + G[63]*(F0*F0 + F3*F3 + F6*F6)) + F4*(G[194] + F0*(G[12] + F0*G[0] + F1*G[4]) + F1*G[23] + F2*(G[31] + F0*G[8] + F1*G[6] + F2*G[27]) + F3*(G[204] + F3*G[96] + F4*G[47]) + F4*G[207] + F6*(G[67] + F6*G[0] + F7*G[4]) + F7*G[7] + F8*(G[141] + F6*G[8] + F7*G[6] + F8*G[27]) + G[16]*(F1*F1 + F4*F4 + F7*F7)) + F5*(G[182] + F0*G[72] + F1*(G[79] + F0*G[8] + F1*G[74]) + F2*(G[85] + F0*G[69] + F1*G[10] + F2*G[82]) + F3*(G[205] + F3*G[97]) + F4*(G[180] + F3*G[99] + F4*G[104]) + F5*(G[208] + F3*G[101] + F4*G[53] + F5*G[82]) + F6*G[70] + F7*(G[11] + F6*G[8] + F7*G[74]) + F8*(G[113] + F6*G[69] + F7*G[10] + F8*G[82]) + G[64]*(F0*F0 + F6*F6)) + F6*G[89] + F7*(G[38] + F6*G[35] + F7*G[201]) + F8*(G[209] + F6*G[88] + F7*G[37] + F8*G[202]) + G[200]*(F0*F0 + F6*F6));
      
      // Number of operations: 186
      I[8] = W4[ip]*(F0*G[172] + F1*(G[156] + F0*G[141] + F1*G[211]) + F2*(G[138] + F0*G[113] + F1*G[118] + F2*G[212]) + F3*G[209] + F4*(G[199] + F3*G[141] + F4*G[211]) + F5*(G[188] + F3*G[113] + F4*G[118] + F5*G[212]) + F6*(G[107] + F0*G[72] + F1*(G[79] + F0*G[8] + F1*G[74]) + F2*(G[85] + F0*G[69] + F1*G[10] + F2*G[82]) + F3*G[88] + F4*(G[91] + F3*G[8] + F4*G[74]) + F5*(G[94] + F3*G[69] + F4*G[10] + F5*G[82]) + F6*G[213] + G[64]*(F0*F0 + F3*F3 + F6*F6)) + F7*(G[62] + F0*(G[14] + F0*G[2] + F1*G[6]) + F1*G[25] + F2*(G[33] + F0*G[10] + F1*G[21] + F2*G[29]) + F3*(G[37] + F3*G[2] + F4*G[6]) + F4*G[41] + F5*(G[45] + F3*G[10] + F4*G[21] + F5*G[29]) + F6*(G[54] + F6*G[48] + F7*G[104]) + F7*G[215] + G[18]*(F1*F1 + F4*F4 + F7*F7)) + F8*(G[218] + F0*G[174] + F1*(G[176] + F0*G[122] + F1*G[28]) + F2*(G[178] + F0*G[123] + F1*G[125] + F2*G[120]) + F3*G[124] + F4*(G[126] + F3*G[122] + F4*G[28]) + F5*(G[127] + F3*G[123] + F4*G[125] + F5*G[120]) + F6*(G[214] + F6*G[101]) + F7*(G[216] + F6*G[109] + F7*G[58]) + F8*(G[217] + F6*G[111] + F7*G[116] + F8*G[120]) + G[81]*(F0*F0 + F3*F3)) + G[210]*(F0*F0 + F3*F3));
      
      // Number of operations: 2
      I[9] =  - F9*W4[ip]*det;
      
      // Number of operations: 2
      I[10] =  - F10*W4[ip]*det;
      
      // Number of operations: 2
      I[11] =  - F11*W4[ip]*det;
      
      
      // Number of operations for primary indices: 36
      for (unsigned int j = 0; j < 2; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc10[j]] += FE0_C0_D001[ip][j]*I[0];
        // Number of operations to compute entry: 2
        A[nzc11[j]] += FE0_C0_D001[ip][j]*I[1];
        // Number of operations to compute entry: 2
        A[nzc1[j]] += FE0_C0_D001[ip][j]*I[2];
        // Number of operations to compute entry: 2
        A[nzc2[j]] += FE0_C0_D001[ip][j]*I[3];
        // Number of operations to compute entry: 2
        A[nzc3[j]] += FE0_C0_D001[ip][j]*I[4];
        // Number of operations to compute entry: 2
        A[nzc5[j]] += FE0_C0_D001[ip][j]*I[5];
        // Number of operations to compute entry: 2
        A[nzc6[j]] += FE0_C0_D001[ip][j]*I[6];
        // Number of operations to compute entry: 2
        A[nzc7[j]] += FE0_C0_D001[ip][j]*I[7];
        // Number of operations to compute entry: 2
        A[nzc9[j]] += FE0_C0_D001[ip][j]*I[8];
      }// end loop over 'j'
      
      // Number of operations for primary indices: 24
      for (unsigned int j = 0; j < 4; j++)
      {
        // Number of operations to compute entry: 2
        A[nzc0[j]] += FE0_C0[ip][j]*I[9];
        // Number of operations to compute entry: 2
        A[nzc4[j]] += FE0_C0[ip][j]*I[10];
        // Number of operations to compute entry: 2
        A[nzc8[j]] += FE0_C0[ip][j]*I[11];
      }// end loop over 'j'
    }// end loop over 'ip'
  }

};

/// This class defines the interface for the tabulation of the
/// exterior facet tensor corresponding to the local contribution to
/// a form from the integral over an exterior facet.

class hyperelasticity_exterior_facet_integral_1_otherwise: public ufc::exterior_facet_integral
{
public:

  /// Constructor
  hyperelasticity_exterior_facet_integral_1_otherwise() : ufc::exterior_facet_integral()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_exterior_facet_integral_1_otherwise()
  {
    // Do nothing
  }

  /// Tabulate the tensor for the contribution from a local exterior facet
  virtual void tabulate_tensor(double* A,
                               const double * const * w,
                               const double* vertex_coordinates,
                               std::size_t facet) const
  {
    // Compute Jacobian
    double J[9];
    compute_jacobian_tetrahedron_3d(J, vertex_coordinates);
    
    // Compute Jacobian inverse and determinant
    double K[9];
    double detJ;
    compute_jacobian_inverse_tetrahedron_3d(K, detJ, J);
    
    
    
    // Get vertices on face
    static unsigned int face_vertices[4][3] = {{1, 2, 3}, {0, 2, 3}, {0, 1, 3}, {0, 1, 2}};
    const unsigned int v0 = face_vertices[facet][0];
    const unsigned int v1 = face_vertices[facet][1];
    const unsigned int v2 = face_vertices[facet][2];
    
    // Compute scale factor (area of face scaled by area of reference triangle)
    const double a0 = (vertex_coordinates[3*v0 + 1]*vertex_coordinates[3*v1 + 2]  +
                       vertex_coordinates[3*v0 + 2]*vertex_coordinates[3*v2 + 1]  +
                       vertex_coordinates[3*v1 + 1]*vertex_coordinates[3*v2 + 2]) -
                      (vertex_coordinates[3*v2 + 1]*vertex_coordinates[3*v1 + 2]  +
                       vertex_coordinates[3*v2 + 2]*vertex_coordinates[3*v0 + 1]  +
                       vertex_coordinates[3*v1 + 1]*vertex_coordinates[3*v0 + 2]);
    
    const double a1 = (vertex_coordinates[3*v0 + 2]*vertex_coordinates[3*v1 + 0]  +
                       vertex_coordinates[3*v0 + 0]*vertex_coordinates[3*v2 + 2]  +
                       vertex_coordinates[3*v1 + 2]*vertex_coordinates[3*v2 + 0]) -
                      (vertex_coordinates[3*v2 + 2]*vertex_coordinates[3*v1 + 0]  +
                       vertex_coordinates[3*v2 + 0]*vertex_coordinates[3*v0 + 2]  +
                       vertex_coordinates[3*v1 + 2]*vertex_coordinates[3*v0 + 0]);
    
    const double a2 = (vertex_coordinates[3*v0 + 0]*vertex_coordinates[3*v1 + 1]  +
                       vertex_coordinates[3*v0 + 1]*vertex_coordinates[3*v2 + 0]  +
                       vertex_coordinates[3*v1 + 0]*vertex_coordinates[3*v2 + 1]) -
                      (vertex_coordinates[3*v2 + 0]*vertex_coordinates[3*v1 + 1]  +
                       vertex_coordinates[3*v2 + 1]*vertex_coordinates[3*v0 + 0]  +
                       vertex_coordinates[3*v1 + 0]*vertex_coordinates[3*v0 + 1]);
    
    const double det = std::sqrt(a0*a0 + a1*a1 + a2*a2);
    
    
    
    
    // Cell volume
    
    // Compute circumradius
    
    
    // Facet area (divide by two because 'det' is scaled by area of reference triangle)
    
    // Array of quadrature weights.
    static const double W3[3] = {0.16666667, 0.16666667, 0.16666667};
    // Quadrature points on the UFC reference element: (0.16666667, 0.16666667), (0.16666667, 0.66666667), (0.66666667, 0.16666667)
    
    // Value of basis functions at quadrature points.
    static const double FE0_f0_C0[3][3] = \
    {{0.66666667, 0.16666667, 0.16666667},
    {0.16666667, 0.16666667, 0.66666667},
    {0.16666667, 0.66666667, 0.16666667}};
    
    // Array of non-zero columns
    static const unsigned int nzc1[3] = {5, 6, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc0[3] = {1, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc7[3] = {4, 5, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc2[3] = {9, 10, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc8[3] = {8, 9, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc6[3] = {0, 1, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc5[3] = {8, 10, 11};
    
    // Array of non-zero columns
    static const unsigned int nzc3[3] = {0, 2, 3};
    
    // Array of non-zero columns
    static const unsigned int nzc4[3] = {4, 6, 7};
    
    // Array of non-zero columns
    static const unsigned int nzc9[3] = {0, 1, 2};
    
    // Array of non-zero columns
    static const unsigned int nzc10[3] = {4, 5, 6};
    
    // Array of non-zero columns
    static const unsigned int nzc11[3] = {8, 9, 10};
    
    // Reset values in the element tensor.
    for (unsigned int r = 0; r < 12; r++)
    {
      A[r] = 0.0;
    }// end loop over 'r'
    
    // Compute element tensor using UFL quadrature representation
    // Optimisations: ('eliminate zeros', True), ('ignore ones', True), ('ignore zero tables', True), ('optimisation', 'simplify_expressions'), ('remove zero terms', True)
    switch (facet)
    {
    case 0:
      {
        // Total number of operations to compute element tensor (from this point): 126
      
      // Loop quadrature points for integral.
      // Number of operations to compute element tensor for following IP loop = 126
      for (unsigned int ip = 0; ip < 3; ip++)
      {
        
        // Coefficient declarations.
        double F0 = 0.0;
        double F1 = 0.0;
        double F2 = 0.0;
        
        // Total number of operations to compute function values = 18
        for (unsigned int r = 0; r < 3; r++)
        {
          F0 += FE0_f0_C0[ip][r]*w[2][nzc0[r]];
          F1 += FE0_f0_C0[ip][r]*w[2][nzc1[r]];
          F2 += FE0_f0_C0[ip][r]*w[2][nzc2[r]];
        }// end loop over 'r'
        
        // Number of operations to compute ip constants: 6
        double I[3];
        // Number of operations: 2
        I[0] =  - F0*W3[ip]*det;
        
        // Number of operations: 2
        I[1] =  - F1*W3[ip]*det;
        
        // Number of operations: 2
        I[2] =  - F2*W3[ip]*det;
        
        
        // Number of operations for primary indices: 18
        for (unsigned int j = 0; j < 3; j++)
        {
          // Number of operations to compute entry: 2
          A[nzc0[j]] += FE0_f0_C0[ip][j]*I[0];
          // Number of operations to compute entry: 2
          A[nzc1[j]] += FE0_f0_C0[ip][j]*I[1];
          // Number of operations to compute entry: 2
          A[nzc2[j]] += FE0_f0_C0[ip][j]*I[2];
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    case 1:
      {
        // Total number of operations to compute element tensor (from this point): 126
      
      // Loop quadrature points for integral.
      // Number of operations to compute element tensor for following IP loop = 126
      for (unsigned int ip = 0; ip < 3; ip++)
      {
        
        // Coefficient declarations.
        double F0 = 0.0;
        double F1 = 0.0;
        double F2 = 0.0;
        
        // Total number of operations to compute function values = 18
        for (unsigned int r = 0; r < 3; r++)
        {
          F0 += FE0_f0_C0[ip][r]*w[2][nzc3[r]];
          F1 += FE0_f0_C0[ip][r]*w[2][nzc4[r]];
          F2 += FE0_f0_C0[ip][r]*w[2][nzc5[r]];
        }// end loop over 'r'
        
        // Number of operations to compute ip constants: 6
        double I[3];
        // Number of operations: 2
        I[0] =  - F0*W3[ip]*det;
        
        // Number of operations: 2
        I[1] =  - F1*W3[ip]*det;
        
        // Number of operations: 2
        I[2] =  - F2*W3[ip]*det;
        
        
        // Number of operations for primary indices: 18
        for (unsigned int j = 0; j < 3; j++)
        {
          // Number of operations to compute entry: 2
          A[nzc3[j]] += FE0_f0_C0[ip][j]*I[0];
          // Number of operations to compute entry: 2
          A[nzc4[j]] += FE0_f0_C0[ip][j]*I[1];
          // Number of operations to compute entry: 2
          A[nzc5[j]] += FE0_f0_C0[ip][j]*I[2];
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    case 2:
      {
        // Total number of operations to compute element tensor (from this point): 126
      
      // Loop quadrature points for integral.
      // Number of operations to compute element tensor for following IP loop = 126
      for (unsigned int ip = 0; ip < 3; ip++)
      {
        
        // Coefficient declarations.
        double F0 = 0.0;
        double F1 = 0.0;
        double F2 = 0.0;
        
        // Total number of operations to compute function values = 18
        for (unsigned int r = 0; r < 3; r++)
        {
          F0 += FE0_f0_C0[ip][r]*w[2][nzc6[r]];
          F1 += FE0_f0_C0[ip][r]*w[2][nzc7[r]];
          F2 += FE0_f0_C0[ip][r]*w[2][nzc8[r]];
        }// end loop over 'r'
        
        // Number of operations to compute ip constants: 6
        double I[3];
        // Number of operations: 2
        I[0] =  - F0*W3[ip]*det;
        
        // Number of operations: 2
        I[1] =  - F1*W3[ip]*det;
        
        // Number of operations: 2
        I[2] =  - F2*W3[ip]*det;
        
        
        // Number of operations for primary indices: 18
        for (unsigned int j = 0; j < 3; j++)
        {
          // Number of operations to compute entry: 2
          A[nzc6[j]] += FE0_f0_C0[ip][j]*I[0];
          // Number of operations to compute entry: 2
          A[nzc7[j]] += FE0_f0_C0[ip][j]*I[1];
          // Number of operations to compute entry: 2
          A[nzc8[j]] += FE0_f0_C0[ip][j]*I[2];
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    case 3:
      {
        // Total number of operations to compute element tensor (from this point): 126
      
      // Loop quadrature points for integral.
      // Number of operations to compute element tensor for following IP loop = 126
      for (unsigned int ip = 0; ip < 3; ip++)
      {
        
        // Coefficient declarations.
        double F0 = 0.0;
        double F1 = 0.0;
        double F2 = 0.0;
        
        // Total number of operations to compute function values = 18
        for (unsigned int r = 0; r < 3; r++)
        {
          F0 += FE0_f0_C0[ip][r]*w[2][nzc9[r]];
          F1 += FE0_f0_C0[ip][r]*w[2][nzc10[r]];
          F2 += FE0_f0_C0[ip][r]*w[2][nzc11[r]];
        }// end loop over 'r'
        
        // Number of operations to compute ip constants: 6
        double I[3];
        // Number of operations: 2
        I[0] =  - F1*W3[ip]*det;
        
        // Number of operations: 2
        I[1] =  - F2*W3[ip]*det;
        
        // Number of operations: 2
        I[2] =  - F0*W3[ip]*det;
        
        
        // Number of operations for primary indices: 18
        for (unsigned int j = 0; j < 3; j++)
        {
          // Number of operations to compute entry: 2
          A[nzc10[j]] += FE0_f0_C0[ip][j]*I[0];
          // Number of operations to compute entry: 2
          A[nzc11[j]] += FE0_f0_C0[ip][j]*I[1];
          // Number of operations to compute entry: 2
          A[nzc9[j]] += FE0_f0_C0[ip][j]*I[2];
        }// end loop over 'j'
      }// end loop over 'ip'
        break;
      }
    }
    
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_0: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_0() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_0()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "9f7a1da74c228e1c4fa0a9a1c80ece9a3c5e2b6b94031a2e30e64a2440e9b868995f6c1e5f4019c992f78fa59729903da970a9da990a395d50e53d5e15dc8817";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 2;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 3;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new hyperelasticity_cell_integral_0_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return 0;
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

/// This class defines the interface for the assembly of the global
/// tensor corresponding to a form with r + n arguments, that is, a
/// mapping
///
///     a : V1 x V2 x ... Vr x W1 x W2 x ... x Wn -> R
///
/// with arguments v1, v2, ..., vr, w1, w2, ..., wn. The rank r
/// global tensor A is defined by
///
///     A = a(V1, V2, ..., Vr, w1, w2, ..., wn),
///
/// where each argument Vj represents the application to the
/// sequence of basis functions of Vj and w1, w2, ..., wn are given
/// fixed functions (coefficients).

class hyperelasticity_form_1: public ufc::form
{
public:

  /// Constructor
  hyperelasticity_form_1() : ufc::form()
  {
    // Do nothing
  }

  /// Destructor
  virtual ~hyperelasticity_form_1()
  {
    // Do nothing
  }

  /// Return a string identifying the form
  virtual const char* signature() const
  {
    return "0ed7acdf630975fc4fd9f075203960875c5364265c79c7cf7d7b14bcb0b4039960d7eccbd1c304df695711a49259b5f1330dd9005b5dd3619fb590591d64c1da";
  }

  /// Return the rank of the global tensor (r)
  virtual std::size_t rank() const
  {
    return 1;
  }

  /// Return the number of coefficients (n)
  virtual std::size_t num_coefficients() const
  {
    return 5;
  }

  /// Return the number of cell domains
  virtual std::size_t num_cell_domains() const
  {
    return 0;
  }

  /// Return the number of exterior facet domains
  virtual std::size_t num_exterior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of interior facet domains
  virtual std::size_t num_interior_facet_domains() const
  {
    return 0;
  }

  /// Return the number of point domains
  virtual std::size_t num_point_domains() const
  {
    return 0;
  }

  /// Return whether the form has any cell integrals
  virtual bool has_cell_integrals() const
  {
    return true;
  }

  /// Return whether the form has any exterior facet integrals
  virtual bool has_exterior_facet_integrals() const
  {
    return true;
  }

  /// Return whether the form has any interior facet integrals
  virtual bool has_interior_facet_integrals() const
  {
    return false;
  }

  /// Return whether the form has any point integrals
  virtual bool has_point_integrals() const
  {
    return false;
  }

  /// Create a new finite element for argument function i
  virtual ufc::finite_element* create_finite_element(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_finite_element_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_finite_element_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new dofmap for argument function i
  virtual ufc::dofmap* create_dofmap(std::size_t i) const
  {
    switch (i)
    {
    case 0:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 1:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 2:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 3:
      {
        return new hyperelasticity_dofmap_2();
        break;
      }
    case 4:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    case 5:
      {
        return new hyperelasticity_dofmap_0();
        break;
      }
    }
    
    return 0;
  }

  /// Create a new cell integral on sub domain i
  virtual ufc::cell_integral* create_cell_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new exterior facet integral on sub domain i
  virtual ufc::exterior_facet_integral* create_exterior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new interior facet integral on sub domain i
  virtual ufc::interior_facet_integral* create_interior_facet_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new point integral on sub domain i
  virtual ufc::point_integral* create_point_integral(std::size_t i) const
  {
    return 0;
  }

  /// Create a new cell integral on everywhere else
  virtual ufc::cell_integral* create_default_cell_integral() const
  {
    return new hyperelasticity_cell_integral_1_otherwise();
  }

  /// Create a new exterior facet integral on everywhere else
  virtual ufc::exterior_facet_integral* create_default_exterior_facet_integral() const
  {
    return new hyperelasticity_exterior_facet_integral_1_otherwise();
  }

  /// Create a new interior facet integral on everywhere else
  virtual ufc::interior_facet_integral* create_default_interior_facet_integral() const
  {
    return 0;
  }

  /// Create a new point integral on everywhere else
  virtual ufc::point_integral* create_default_point_integral() const
  {
    return 0;
  }

};

#endif
