# -*- coding: utf-8 -*-
# Copyright (C) 2011-2015 Martin Sandve Alnæs
#
# This file is part of UFLACS.
#
# UFLACS is free software: you can redistribute it and/or modify
# it under the terms of the GNU Lesser General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# UFLACS is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU Lesser General Public License for more details.
#
# You should have received a copy of the GNU Lesser General Public License
# along with UFLACS. If not, see <http://www.gnu.org/licenses/>.

"""The FFC specific backend to the UFLACS form compiler algorithms."""

def compile_tabulate_tensor_code(form, optimize=True):
    """This function is basically a mock controller which allows emulating the behaviour of ffc,
    by joining compute_ir, optimize_ir, and generate_ir.
    """
    from ufl.algorithms import compute_form_data
    from ffc.cpp import set_float_formatting
    from ffc.uflacsrepr import compute_integral_ir, optimize_integral_ir, generate_integral_code

    # Fake the initialization necessary to get this running through
    set_float_formatting(8)
    parameters = {"optimize": optimize, "restrict_keyword": ""}
    prefix = "uflacs_testing"
    form_id = 0

    # Apply ufl preprocessing
    form_data = compute_form_data(form,
                                  do_apply_function_pullbacks=True,
                                  do_apply_integral_scaling=True,
                                  do_apply_geometry_lowering=True,
                                  preserve_geometry_types=(),
                                  do_apply_restrictions=True,
                                  )

    tt_codes = []
    for itg_data in form_data.integral_data:
        # Just make a fixed choice of cubic default quadrature rule for this test code
        itg_data.metadata["quadrature_degree"] = itg_data.metadata.get("quadrature_degree", 3)
        itg_data.metadata["quadrature_rule"] = itg_data.metadata.get("quadrature_rule", "default")

        # Call uflacs representation functions from ffc, which again calls the matching uflacs functions
        element_numbers = None # FIXME
        ir = compute_integral_ir(itg_data, form_data, form_id, element_numbers, parameters)
        if optimize:
            ir = optimize_integral_ir(ir, parameters)
        code = generate_integral_code(ir, prefix, parameters)

        # Store just the tabulate tensor part generated by uflacs
        tt_codes.append(code["tabulate_tensor"])

    # Just joint the tabulate tensor bodies and return
    code = ('\n' + '/' * 60 + '\n').join(tt_codes)
    return code
