/*******************************************************************
 * Fritz Fun                                                       *
 * Created by Jan-Michael Brummer                                  *
 * All parts are distributed under the terms of GPLv2. See COPYING *
 *******************************************************************/

/**
 * \file pwd_kde4.cpp
 * \brief KDE Wallet (KDE4) plugin
 */
#include <ffgtk.h>

extern "C" {
extern int kdeReadPassword( const char *, char ** );
extern int kdeWritePassword( const char *, const char * );
extern int InitWallet( void );

static gchar *pnSecretPassword = NULL;

/**
 * \brief Get password from kwallet
 * \param psProfile profile structure
 * \return password or NULL on error
 */	
static const gchar *walletGetPassword( struct sProfile *psProfile ) {
	int nError = -1;

	if ( pnSecretPassword != NULL ) {
		return pnSecretPassword;
	}

	nError = kdeReadPassword( psProfile -> pnName, &pnSecretPassword );
	if ( nError != 0 ) {
		pnSecretPassword = NULL;
		//Debug( KERN_DEBUG, "nError: %d\n", nError );
		return pnSecretPassword;
	}

	return pnSecretPassword;
}

/**
 * \brief Set password to kwallet
 * \param psProfile profile structure
 * \param pnPassword password
 */
static void walletSetPassword( struct sProfile *psProfile, const gchar *pnPassword ) {
	int nError = -1;

	//Debug( KERN_DEBUG, "profile name %s\n", psProfile -> pnName );
	nError = kdeWritePassword( psProfile -> pnName, pnPassword );
	if ( nError != 0 ) {
		//Debug( KERN_WARNING, "Could not set password (%d)!!\n", nError );
	} else {
		if ( pnSecretPassword != NULL ) {
		    free( pnSecretPassword );
		}
		pnSecretPassword = g_strdup( pnPassword );
	}
}

/**
 * \brief Remove password from kwallet (UNSUPPORTED!)
 * \param psProfile profile structure
 */
static void walletRemovePassword( struct sProfile *psProfile ) {
	//Debug( KERN_DEBUG, "called\n" );
}

/** password definition */
struct sPassword sWallet4 = {
	walletGetPassword,
	walletSetPassword,
	walletRemovePassword
};

MODULE_INIT( PLUGIN_TYPE_PASSWORD, _( "KWallet (KDE4)" ), &sWallet4, NULL, InitWallet );
}
