##
# Returns true if the first object is an instance of the second
# (class) object.  Example: isa(someObject, props.Node)
#
isa = func {
    obj = arg[0]; class = arg[1];
    if(!contains(obj, "parents")) { return 0; }
    foreach(c; obj.parents) {
        if(c == class)     { return 1; }
        elsif(isa(obj, c)) { return 1; }
    }
    return 0;
}

##
# Invokes a FlightGear command specified by the first argument.  The
# second argument specifies the property tree to be passed to the
# command as its argument.  It may be either a props.Node object or a
# string, in which case it specifies a path in the global property
# tree.
#
fgcommand = func {
    if(isa(arg[1], props.Node)) { arg[1] = arg[1]._g }
    _fgcommand(arg[0], arg[1]);
}

##
# Returns the SGPropertyNode argument to the currently executing
# function. Wrapper for the internal _cmdarg function that retrieves
# the ghost handlet to the argument and wraps it in a
# props.Node object.
#
cmdarg = func { props.wrapNode(_cmdarg()) }

##
# Utility.  Does what it you think it does.
#
abs = func { if(arg[0] < 0) { -arg[0] } else { arg[0] } }

##
# Convenience wrapper for the _interpolate function.  Takes a
# single string or props.Node object in arg[0] indicating a target
# property, and a variable-length list of time/value pairs.  Example:
#
#  interpolate("/animations/radar/angle",
#              180, 1, 360, 1, 0, 0,
#              180, 1, 360, 1, 0, 0,
#              180, 1, 360, 1, 0, 0,
#              180, 1, 360, 1, 0, 0,
#              180, 1, 360, 1, 0, 0,
#              180, 1, 360, 1, 0, 0,
#              180, 1, 360, 1, 0, 0,
#              180, 1, 360, 1, 0, 0);
#
# This will swing the "radar dish" smoothly through 8 revolutions over
# 16 seconds.  Note the use of zero-time interpolation between 360 and
# 0 to wrap the interpolated value properly.
#
interpolate = func {
    if(isa(arg[0], props.Node)) { arg[0] = arg[0]._g; }
    elsif(typeof(arg[0]) != "scalar") { return; }
    _interpolate(arg[0], subvec(arg, 1));
}
