#include "../include/fireflier.h"
#include "ports.h"
#include <iostream>
#include <unistd.h>

using namespace std;

#define SHOWREQUESTS 0
#define ERRORDEBUG 0
// after how many packets does a not hit cache entry timeout
// this is for catching the connection closing FIN ACK packet in the
// match port to program process
#define CACHETIMEOUT 1000

// pids for a localport/localip pair are found by getting inode from /proc/net/tcp|udp
// then the proc filesystem is searched for a pid which uses this inode
// not very efficient, but I didnt find a better way

// a queue for caching. So I dont search the same program for every packet.
// packet is removed after a timeout counter reaches 0
queue *portqueue=0;
    
cacheelem::~cacheelem()
{
    if (ERRORDEBUG)
        cout << "!cacheelem" << endl;
    delete[] programname;
}

// get inode for a specific file (or fd in /proc/PID/fd)
int get_inode(char *filename)
{
    struct stat buf;
    if (ERRORDEBUG)
        cout << "+-get_inode" << endl;
    if (stat(filename, &buf)) return 0;
    return buf.st_ino;
}

// search in /proc/net/tcp|udp for the correct inode for a localport/localip pair
// filename is /proc/net/tcp|udp
int search_inode(int local_ip, int local_port, char *filename)
{
    int lip=-1, lport=-1, rip=-1, rport=-1, inode=-1;
    FILE *in;
    int result=-1;
    char line[200];

    if (ERRORDEBUG)
        cout << "+search_inode" << endl;
    
    if (!filename) return -1;
    
    if ((in=fopen(filename, "rt"))==0)
        return -1;
    while (!feof(in)) // parse file (fixed format)
    {
        fgets(line, 200, in);
        sscanf(line, "%*4d: %8X:%4X %8X:%4X %*2X %*8X:%*8X %*2X:%*8X %*8X %*5X %*8X %d ",
               &lip, &lport, &rip, &rport, &inode);
        if ((result==-1) && ((lip==local_ip) || (lip==0)) && (local_port==lport)) // lip==0 --> servers listening on "any" interface
        {
            result=inode; // inode found
        }
    }
    fclose(in);
    if (ERRORDEBUG)
        cout << "-search_inode" << endl;
    return result;
}

// look in cache if we know this program already
char* lookup_cache(int mode, int local_ip, int local_port)
{
    cacheelem *elem;

    if (ERRORDEBUG)
        cout << "+lookup_cache" << endl;
    if (!portqueue) return 0;

    portqueue->rewind(); // reset iterator
    while ((elem=(cacheelem*)portqueue->next_element())) // for each element of queue
    {
        if ((elem->mode==mode) && (elem->local_ip==local_ip) && (elem->local_port==local_port))
        {
            elem->timeout=CACHETIMEOUT; // cache item hit --> reset timeout counter
            if (ERRORDEBUG)
                cout << "-lookup_cache" << endl;
            return (strdup(elem->programname)); // return programname from cache
        }
		else if (elem->timeout--<=0) // decrease every timeout counter and delete if unused since 100 lookups
		{
			cout << "deleting " << elem->local_ip << ":" << elem->local_port << " = " << elem->programname << endl;
			portqueue->del(elem);
		}
    }
    if (ERRORDEBUG)
        cout << "-lookup_cache" << endl;
    return 0;
}

// put resolved programname into cache
void input_cache(int mode, int local_ip, int local_port, int pid, char *filename)
{
    cacheelem *c;
    
    if (ERRORDEBUG)
        cout << "+input_cache" << endl;


    if (!portqueue) // if no queue exists we create one
        portqueue=new queue();

    if (pid<=0) return;
    
    c=new cacheelem();
    c->mode=mode;
    c->local_ip=local_ip;
    c->local_port=local_port;
    c->pid=pid;
    c->timeout=CACHETIMEOUT; // timeout counter
    c->programname=strdup(filename);

    portqueue->add(c);
    if (ERRORDEBUG)
    cout << "-input_cache" << endl;

}

// search for the pid using localport/localip pair
// calling the other functions. This could be used from another program too.
// mode = PROT_TCP ---> tcp port
// mode = PROT_UDP ---> udp port
int get_pid(int mode, int local_ip, int local_port)
{
    int inode=-1;
    DIR *pids;
    DIR *fds;
    struct dirent *pid, *fd;
    char filename[270];
    int result=-1;

    if (ERRORDEBUG)
        cout << "+get_pid" << endl;

//    if (result!=-1)
//        return result;

    // first get the inode
    if (mode==ff::PROT_TCP)
        inode=search_inode(local_ip, local_port, "/proc/net/tcp");
    else if (mode==ff::PROT_UDP)
        inode=search_inode(local_ip, local_port, "/proc/net/udp");

    // search in /proc for pids
    pids=opendir("/proc");
    if (pids==0)
        return -1;
    while ((pid=readdir(pids)) && (result==-1))
    {
        if (atoi(pid->d_name)!=0) // it is a pid?
        {
            strcpy(filename, "/proc/");
            strcat(filename, pid->d_name);
            strcat(filename, "/fd");

            // search file descriptors of this pid
            if ((fds=opendir(filename)))
            {
                while ((fd=readdir(fds)) && (result==-1))
                {
                    strcpy(filename, "/proc/");
                    strcat(filename, pid->d_name);
                    strcat(filename, "/fd/");
                    strcat(filename, fd->d_name);

                    if (strcmp(fd->d_name, ".") && strcmp(fd->d_name, ".."))
                    {
                        if (get_inode(filename)==inode) // check if this inode is the one we are searching
                        {
                            result=atoi(pid->d_name); // pid found
                        }
                    }
                }
                closedir(fds);
            }
        }
    }
    closedir(pids);

    if (ERRORDEBUG)
        cout << "-get_pid" << endl;

    return result;
}

// search for the program using this localport/localip.
// first look into cache
// search the pid
// if found look onto /proc/PID/exe
// put into cache
// mode = PROT_TCP  ----> tcp
// mode = PROT_UDP  ----> udp
char *get_program_name(int mode, int local_ip, int local_port)
{
//    FILE *in;
//    char *line;
//    char *pos;
    char filename[20];
    int len;
    int pid;
    char *programname;

	if (SHOWREQUESTS)
		cout << "Program name request: " << local_ip << ":" << local_port << "...";

    if (ERRORDEBUG)
        cout << "+get_program_name" << endl;
    
    programname=lookup_cache(mode, local_ip, local_port); // check in cache
	if (programname) // if cache hit
	{
		if (SHOWREQUESTS)
			cout << "hit: " << programname << endl;
		return programname;
	}

    // search pid of program
    pid=get_pid(mode, local_ip, local_port);

	if (pid<=0) // no pid found --> abort
	{
		if (SHOWREQUESTS)
			cout << "not found" << endl;
		return 0;
	}
    sprintf(filename, "/proc/%d/exe", pid);

    // get programname from /proc/PID/exe
    programname=new char[256];
    len=readlink(filename, programname, 256);
    if ((len<=0) || (len>255)) // something went wrong on reading executable name?
    {
        delete[] programname;
		if (SHOWREQUESTS)
			cout << "failure: aborting" << endl;
        return 0;
    }
    programname[len]=0;

    // put new program into cache
    input_cache(mode, local_ip, local_port, pid, programname);

    if (ERRORDEBUG)
        cout << "-get_program_name" << endl;
	if (SHOWREQUESTS)
		cout << "new: " << programname << endl;

    return programname;
}
