%define name	firestarter
%define version 0.9.3
%define release 1

Summary:	The Firestarter firewall tool for GNOME
Name:		%{name}
Version:	%{version}
Release:	%{release}
URL:		http://firestarter.sourceforge.net
License:	GPL
Group:		Applications/Internet
Source0:	http://download.sourceforge.net/firestarter/firestarter-%{version}.tar.gz
Source1:        firestarter.desktop
Source2:        firestarter.pam
Source3:        firestarter.console
BuildRoot:	%{_tmppath}/%{name}-%{version}-%{release}-root-%(%{__id_u} -n)
Requires:       iptables
Requires:       gtk2 >= 2.0.1
Requires:	initscripts
Requires:       usermode-gtk
BuildRequires:	glib2-devel >= 2.0.1
BuildRequires:	gtk2-devel >= 2.0.1
BuildRequires:	gnome-libs-devel >= 1.2.3
BuildRequires:	libgnomeui-devel
BuildRequires:	gettext
BuildRequires:  desktop-file-utils

%description
Firestarter is an easy-to-use, yet powerful, Linux firewall tool for GNOME.
Use it to quickly set up a secure environment using the firewall creation
wizard, or use it's monitoring and administrating features with your old
firewall scripts.

#---------------------------------------------------------------------

%prep
%setup -q

#---------------------------------------------------------------------

%build
%configure
make %{?_smp_mflags}

#---------------------------------------------------------------------

%install
rm -rf ${RPM_BUILD_ROOT}
mkdir -p ${RPM_BUILD_ROOT}/%{_bindir}
mkdir -p ${RPM_BUILD_ROOT}/%{_sbindir}
mkdir -p ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter
export GCONF_DISABLE_MAKEFILE_SCHEMA_INSTALL=1
%makeinstall

mv ${RPM_BUILD_ROOT}/%{_bindir}/firestarter ${RPM_BUILD_ROOT}/%{_sbindir}
ln -s %{_bindir}/consolehelper ${RPM_BUILD_ROOT}/%{_bindir}/firestarter

touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/blocked-hosts
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/blocked-ports
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/firewall.sh
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/forward
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/open-ports
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/stealthed-ports
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/trusted-hosts
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/user-pre
touch ${RPM_BUILD_ROOT}/%{_sysconfdir}/firestarter/user-post

%find_lang %{name}

install -p -D %{SOURCE2} ${RPM_BUILD_ROOT}%{_sysconfdir}/pam.d/firestarter 
install -p -D %{SOURCE3}  ${RPM_BUILD_ROOT}%{_sysconfdir}/security/console.apps/firestarter

rm -f ${RPM_BUILD_ROOT}%{_datadir}/gnome/apps/Internet/firestarter.desktop
install -p -D -m644 %{SOURCE1} ${RPM_BUILD_ROOT}%{_datadir}/applications/%{name}.desktop

desktop-file-install --vendor firestarter --delete-original \
  --dir ${RPM_BUILD_ROOT}%{_datadir}/applications      \
  --add-category Application                           \
  --add-category System                                \
  ${RPM_BUILD_ROOT}%{_datadir}/applications/%{name}.desktop

install -p -D -m755 netfilter.init ${RPM_BUILD_ROOT}%{_initrddir}/firestarter

#---------------------------------------------------------------------
                                                                             
%clean
rm -rf ${RPM_BUILD_ROOT}

#---------------------------------------------------------------------

%post
export GCONF_CONFIG_SOURCE=`gconftool-2 --get-default-source`
gconftool-2 --makefile-install-rule \
        %{_sysconfdir}/gconf/schemas/firestarter.schemas >/dev/null
if [ "$1" -eq 1 ]; then
    /sbin/chkconfig --level 0123456 iptables off 2>/dev/null || :
    /sbin/chkconfig --add firestarter
    /sbin/chkconfig firestarter on
fi

#---------------------------------------------------------------------

%preun
if [ "$1" = 0 ]; then
    /sbin/chkconfig ipchains reset 2>/dev/null || :
    /sbin/chkconfig iptables reset 2>/dev/null || :
    /sbin/service firestarter stop >/dev/null 2>&1
    /sbin/chkconfig --del firestarter
fi

#---------------------------------------------------------------------

%postun
if [ "$1" = "0" ]; then
    if [ -e /etc/dhclient-exit-hooks ]; then
        grep -v 'sh %{_sysconfdir}/firestarter/firewall.sh' < /etc/dhclient-exit-hooks > /etc/dhclient-exit-hooks.tmp
        mv /etc/dhclient-exit-hooks.tmp /etc/dhclient-exit-hooks
    fi
fi

#---------------------------------------------------------------------

%files -f %{name}.lang
%defattr(-,root,root,-)
%doc README ChangeLog AUTHORS TODO COPYING CREDITS
%attr(755,root,root) %{_sbindir}/firestarter
%attr(770,root,root) %{_sysconfdir}/firestarter/firewall.sh
%attr(770,root,root) %{_sysconfdir}/firestarter/user-pre
%attr(770,root,root) %{_sysconfdir}/firestarter/user-post
%{_bindir}/firestarter
%config %{_initrddir}/firestarter
%{_sysconfdir}/gconf/schemas/firestarter.schemas
%{_sysconfdir}/pam.d/firestarter
%{_sysconfdir}/security/console.apps/%{name}
%dir %{_sysconfdir}/firestarter
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/blocked-hosts
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/blocked-ports
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/firewall.sh
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/forward
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/open-ports
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/stealthed-ports
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/trusted-hosts
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/user-pre
%config(missingok,noreplace) %verify(not md5 mode mtime size) %{_sysconfdir}/firestarter/user-post
%{_sysconfdir}/firestarter/non-routables
%{_datadir}/applications/firestarter.desktop
%{_datadir}/pixmaps/*

#---------------------------------------------------------------------

%changelog
* Mon May 03 2004 Tomas Junnonen
- Added user-pre and user-post to list of installed files

* Sat Apr 03 2004 Tomas Junnonen
- Corrected permissions of source files.
- Added installation of gconf schema
- Added non-routables to list of installed files

* Tue Aug 12 2003 Tomas Junnonen <majix@sci.fi>
- Switched to Fedora spec file
- Added patch to reconginze Linux 2.6 kernels
- Added patch to fix crash on KDE3 tray updates

* Wed Aug 06 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.2-0.fdr.7
- For %%{_sysconfdir}/firestarter now using verify, not ghost.

* Tue Aug 05 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.2-0.fdr.6
- Cleanup is now done in postun (rather than post, which is silly).

* Sat Aug 02 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.2-0.fdr.5
- Remove firestarter references from /etc/dhclient-exit-hooks in post.

* Mon Jul 28 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.2-0.fdr.4
- Fixed Pam typo.
- ghost config files.

* Thu Jul 24 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.2-0.fdr.3
- Req usermode-gtk.
- Wrapped post script.
- pam_xauth entry -> optional.

* Fri Jul 18 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.2-0.fdr.2
- Readded Epoch: 0.
- Split pam.d and console.apps files into separate SOURCE files.
- Removed hard-coded paths.
- Added explicit epochs.
- Added Req iptables.
- Package now owns %%{_sysconfdir}/firestarter.

* Fri Jun 13 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.2-0.fdr.1
- Updated to 0.9.2.
- Removed Epoch:0.
- buildroot -> RPM_BUILD_ROOT.

* Tue Apr 01 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.1-0.fdr.7
- Added desktop-file-utils to BuildRequires.
- Changed category to X-Fedora-Extra.
- Added Epoch:0.

* Tue Mar 25 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.1-0.fdr.6
- removed %postun.

* Tue Mar 25 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.1-0.fdr.5
- Moved menu entry to System Tools.
- removed redundant ldconfig.
- removed extra chkconfig.

* Mon Mar 24 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.1-0.fdr.4
- Made the .desktop file an external file.
- corrected BuildRequires.
- corrected %files

* Wed Mar 08 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.1-0.fdr.3
- Cleaned up spec

* Wed Mar 05 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.1-0.fdr.2
- Cleaned up spec

* Wed Feb 26 2003 Phillip Compton <pcompton[AT]proteinmedia.com> 0.9.1-1.fedora.1
- Initial Fedora release (0.9.1). 

* Tue Aug 06 2002 Tomas Junnonen <majix@sci.fi>
- Updated requirements to GNOME2 level
- Removed all requirements related to the documentation generation

* Tue Jun 25 2002 Paul Drain <pd@cipherfunk.org>
- Merged some compatible cleanups from the FreshRPMS (http://freshrpms.net)
  specfile.
  
* Wed Apr 24 2002 Paul Drain <pd@cipherfunk.org>
- build dependancy cleanups

* Mon Apr 22 2002 Paul Drain <pd@cipherfunk.org>
- gnome-doc-tools is no longer required to build the RPM

* Tue Jan 08 2002 Roy-Magne Mo <rmo@sunnmore.net>
- Clean up specfile, and use rpm4 macros
- Remove docuementation tools as requirements
- Add gnome-doc-tools and then some as buildprereq
- Add initscripts to prereq
- used %makeinstall macro instead of old make install
- no use specifying runlevels at the commandline, this
  should be specified in the initscripts itself
- Added gnome-core as requirements

* Mon Jan 07 2002 Tomas Junnonen <majix@sci.fi>
- preun now doesn't explicitly delete the init script,
  caused problem with package upgrades.
- Moved the init scripts to external files
  
* Tue Oct 23 2001 Paul Drain <pd@cipherfunk.org>
- Added sgmltools and openjade to build requirements

* Tue Oct 16 2001 Paul Drain <pd@cipherfunk.org>
- Updated build dependancies

* Mon Jul 09 2001 Paul Drain <pd@cipherfunk.org>
- Fixed documentation directory
- Added sysconfdir variable instead of hardcoding /etc

* Thu Jun 01 2000 Tomas Junnonen <majix@sci.fi>
- Significant changes to allow use of consolehelper

* Wed May 31 2000 Tomas Junnonen <majix@sci.fi>
- Fixed problem with CFLAGS and LDADD usage of " and `

* Mon May 29 2000 Tomas Junnonen <majix@sci.fi>
- First spec file
