/*---[ hitview.h ]-----------------------------------------------------
 * Copyright (C) 2002 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The Hits page and related functions
 *--------------------------------------------------------------------*/

#ifndef _FIRESTARTER_HITVIEW
#define _FIRESTARTER_HITVIEW

#include <config.h>
#include <gnome.h>

#include "firestarter.h"

void hitview_clear (void);
void hitview_reload (void);
gboolean hitview_append_hit (Hit *h);
void hitview_toggle_column_visibility (GtkWidget *widget, gint colnum);

Hit *hitview_get_selected_hit (void);
GList *hitview_get_all_hits (void);

void lookup_selected_hit (void);
void copy_selected_hit (void);
const Hit *get_last_hit (void);

GtkWidget *create_hitview_page (void);

enum
{
	HITCOL_TIME,
	HITCOL_IN,
	HITCOL_OUT,
	HITCOL_PORT,
 	HITCOL_SOURCE,
	HITCOL_DESTINATION,
	HITCOL_LENGTH,
	HITCOL_TOS,
	HITCOL_PROTOCOL,
	HITCOL_SERVICE,
	NUM_HITCOLUMNS
};

#endif
