/*---[ preferences.h ]------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The preferences header file
 *--------------------------------------------------------------------*/

#ifndef _FIRESTARTER_PREFERENCES
#define _FIRESTARTER_PREFERENCES

/* GConf keys related to the client program */
#define PREFS_FIRST_RUN "/apps/firestarter/client/first_run"

#define PREFS_START_ON_STARTUP "/apps/firestarter/client/start_firewall_on_startup"
#define PREFS_STOP_ON_EXIT "/apps/firestarter/client/stop_firewall_on_exit"
#define PREFS_AUTORESOLVE "/apps/firestarter/client/autoresolve"
#define PREFS_TRAY_MODE "/apps/firestarter/client/tray_mode"
#define PREFS_SYSLOG_FILE "/apps/firestarter/client/system_log"

#define PREFS_FILTER_REDUNDANT "/apps/firestarter/client/filter/redundant"
#define PREFS_FILTER_BROADCAST "/apps/firestarter/client/filter/broadcast"

#define PREFS_HITVIEW_TIME_COL "/apps/firestarter/client/ui/hitview_time_col"
#define PREFS_HITVIEW_IN_COL "/apps/firestarter/client/ui/hitview_in_col"
#define PREFS_HITVIEW_OUT_COL "/apps/firestarter/client/ui/hitview_out_col"
#define PREFS_HITVIEW_PORT_COL "/apps/firestarter/client/ui/hitview_port_col"
#define PREFS_HITVIEW_SOURCE_COL "/apps/firestarter/client/ui/hitview_source_col"
#define PREFS_HITVIEW_DESTINATION_COL "/apps/firestarter/client/ui/hitview_destination_col"
#define PREFS_HITVIEW_LENGTH_COL "/apps/firestarter/client/ui/hitview_length_col"
#define PREFS_HITVIEW_TOS_COL "/apps/firestarter/client/ui/hitview_tos_col"
#define PREFS_HITVIEW_PROTOCOL_COL "/apps/firestarter/client/ui/hitview_protocol_col"
#define PREFS_HITVIEW_SERVICE_COL "/apps/firestarter/client/ui/hitview_service_col"

/* GConf keys modifying the firewall */
#define PREFS_FW_DENY_PACKETS "/apps/firestarter/firewall/deny_packets"

#define PREFS_FW_EXT_IF "/apps/firestarter/firewall/ext_if"
#define PREFS_FW_EXT_PPP "/apps/firestarter/firewall/ext_ppp"
#define PREFS_FW_EXT_DHCP "/apps/firestarter/firewall/ext_dhcp"

#define PREFS_FW_NAT "/apps/firestarter/firewall/nat"
#define PREFS_FW_INT_IF "/apps/firestarter/firewall/int_if"

#define PREFS_FW_SERVICES_ENABLE "/apps/firestarter/firewall/services/enable"
#define PREFS_FW_SERVICES_FTP "/apps/firestarter/firewall/services/ftp"
#define PREFS_FW_SERVICES_SSH "/apps/firestarter/firewall/services/ssh"
#define PREFS_FW_SERVICES_TELNET "/apps/firestarter/firewall/services/telnet"
#define PREFS_FW_SERVICES_SMTP "/apps/firestarter/firewall/services/smtp"
#define PREFS_FW_SERVICES_DNS "/apps/firestarter/firewall/services/dns"
#define PREFS_FW_SERVICES_FINGER "/apps/firestarter/firewall/services/finger"
#define PREFS_FW_SERVICES_WWW "/apps/firestarter/firewall/services/www"
#define PREFS_FW_SERVICES_SSLWEB "/apps/firestarter/firewall/services/sslweb"
#define PREFS_FW_SERVICES_POP "/apps/firestarter/firewall/services/pop"
#define PREFS_FW_SERVICES_IMAP "/apps/firestarter/firewall/services/imap"
#define PREFS_FW_SERVICES_IDENT "/apps/firestarter/firewall/services/ident"
#define PREFS_FW_SERVICES_NNTP "/apps/firestarter/firewall/services/nntp"
#define PREFS_FW_SERVICES_NTP "/apps/firestarter/firewall/services/ntp"
#define PREFS_FW_SERVICES_SAMBA "/apps/firestarter/firewall/services/samba"
#define PREFS_FW_SERVICES_ROUTED "/apps/firestarter/firewall/services/routed"
#define PREFS_FW_SERVICES_NFS "/apps/firestarter/firewall/services/nfs"
#define PREFS_FW_SERVICES_X "/apps/firestarter/firewall/services/xwindows"
#define PREFS_FW_SERVICES_DHCP "/apps/firestarter/firewall/services/dhcp"
#define PREFS_FW_SERVICES_IPSEC "/apps/firestarter/firewall/services/ipsec"
#define PREFS_FW_SERVICES_UPNP "/apps/firestarter/firewall/services/upnp"
#define PREFS_FW_SERVICES_PPTP "/apps/firestarter/firewall/services/pptp"

#define PREFS_FW_FILTER_TOS "/apps/firestarter/firewall/tos/enable"
#define PREFS_FW_TOS_CLIENT "/apps/firestarter/firewall/tos/client"
#define PREFS_FW_TOS_SERVER "/apps/firestarter/firewall/tos/server"
#define PREFS_FW_TOS_X "/apps/firestarter/firewall/tos/x"
#define PREFS_FW_TOS_OPT_TROUGHPUT "/apps/firestarter/firewall/tos/optimize_troughput"
#define PREFS_FW_TOS_OPT_RELIABILITY "/apps/firestarter/firewall/tos/optimize_reliability"
#define PREFS_FW_TOS_OPT_DELAY "/apps/firestarter/firewall/tos/optimize_delay"

#define PREFS_FW_FILTER_ICMP "/apps/firestarter/firewall/icmp/enable"
#define PREFS_FW_ICMP_ECHO "/apps/firestarter/firewall/icmp/echo"
#define PREFS_FW_ICMP_TRACEROUTE "/apps/firestarter/firewall/icmp/traceroute"
#define PREFS_FW_ICMP_MSTRACEROUTE "/apps/firestarter/firewall/icmp/mstraceroute"
#define PREFS_FW_ICMP_UNREACHABLE "/apps/firestarter/firewall/icmp/unreachable"
#define PREFS_FW_ICMP_TIMESTAMPING "/apps/firestarter/firewall/icmp/timestamping"
#define PREFS_FW_ICMP_MASKING "/apps/firestarter/firewall/icmp/masking"
#define PREFS_FW_ICMP_REDIRECTION "/apps/firestarter/firewall/icmp/redirection"
#define PREFS_FW_ICMP_SOURCE_QUENCHES "/apps/firestarter/firewall/icmp/source_quenches"

#include <config.h>
#include <gnome.h>

void preferences_init (void);

void preferences_check_schema (void);

gboolean preferences_get_bool   (const gchar *gconf_key);
gchar   *preferences_get_string (const gchar *gconf_key);

void preferences_set_bool   (const gchar *gconf_key, gboolean data);
void preferences_set_string (const gchar *gconf_key, const gchar *data);

void bind_toggle_to_key (GtkToggleButton *button, const gchar *gconf_key);
void bind_entry_to_key  (GtkEntry *entry, const gchar *gconf_key);

void preferences_cb (GtkWidget *widget, gpointer data);

#endif
