/*---[ wizard.h ]------------------------------------------------------
 * Copyright (C) 2000 Tomas Junnonen (majix@sci.fi)
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * The wizard header file
 *--------------------------------------------------------------------*/

#ifndef _FIRESTARTER_WIZARD
#define _FIRESTARTER_WIZARD

#include <config.h>
#include <gnome.h>

typedef struct _Wizard Wizard;

struct _Wizard
{
	GPtrArray *pages;
	GtkWidget *notebook;

	GtkWidget *extdevice;
	GtkWidget *intdevice;
	GtkWidget *intrange;

	GtkWidget *auto_int_ip;

        GtkWidget *sysctl;
	GtkWidget *services;
	GtkWidget *icmp;
	GtkWidget *tos;
	GtkWidget *masq;
	GtkWidget *ftp, *ssh, *telnet, *smtp, *dns, *finger, *www, *sslweb,
	          *pop, *imap, *ident, *nntp, *ntp, *samba, *ipsec, *routed,
	          *nfs, *x, *dhcp, *upnp, *pptp;

	GtkWidget *icmp_echo, *icmp_traceroute, *icmp_tracert, *icmp_unreach,
	          *icmp_timestamp, *icmp_masking, *icmp_redir, *icmp_quench;
			
	GtkWidget *tos_client, *tos_server, *tos_X, *tos_option_throughput,
	          *tos_option_reliability, *tos_option_delay;

	GtkWidget *pppcheck;
	GtkWidget *dhcpcheck;
};

void run_wizard (void);
GtkWidget* create_device_page   (Wizard *data);
GtkWidget* create_masq_page     (Wizard *data);
GtkWidget* create_services_page (Wizard *data);
GtkWidget* create_icmp_page     (Wizard *data);
GtkWidget* create_tos_page      (Wizard *data);

#endif
