/*******************************************************************************
*	fische - standalone sound visualisation for linux		       *
*	Copyright (C) 2006 Marcel Ebmer					       *
*									       *
*	This program is free software; you can redistribute it and/or	       *
*	modify it under the terms of the GNU General Public License	       *
*	as published by the Free Software Foundation; either version 2	       *
*	of the License, or (at your option) any later version.		       *
*									       *
*	This program is distributed in the hope that it will be useful,	       *
*	but WITHOUT ANY WARRANTY; without even the implied warranty of	       *
*	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the	       *
*	GNU General Public License for more details.			       *
*									       *
*	You should have received a copy of the GNU General Public License      *
*	along with this program; if not, write to the Free Software	       *
*	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, 	       *
*	MA  02110-1301, USA.						       *
*******************************************************************************/
#include "fische.h"

void line ( int x1, int y1, int x2, int y2, long int color ) {
	
	int xt;
	int i, j;
	char *bp;
	
	if ( x1 > x2 ) { xt = x1; x1 = x2; x2 = xt; xt = y1; y1 = y2; y2 = xt; }

	if ( y2 >= y1 ) {
		if ( ( x2 - x1 ) >= ( y2 - y1 ) ) {
			SDL_LockSurface ( sdl_screen );
			for ( i = 0; i < ( x2 - x1 ); i++ ) {
				j = (int)floor ( (float)i * (float)( y2 - y1 ) / (float)( x2 - x1 ) );
				bp = sdl_screen->pixels;
				*( bp + ( y1 + j ) * 4 * XRes + ( x1 + i ) * 4 ) |= ( color & 0x0000ff00 ) >> 8;
				*( bp + ( y1 + j ) * 4 * XRes + ( x1 + i ) * 4 + 1 ) |= ( color & 0x00ff0000 ) >> 16;
				*( bp + ( y1 + j ) * 4 * XRes + ( x1 + i ) * 4 + 2 ) |= ( color & 0xff000000 ) >> 24;
				*( bp + ( y1 + j ) * 4 * XRes + ( x1 + i ) * 4 + 3 ) |= color & 0x000000ff;
			}
			SDL_UnlockSurface ( sdl_screen );
		}

		if ( ( y2 - y1 ) > ( x2 - x1 ) ) {
			SDL_LockSurface ( sdl_screen );
			for ( i = 0; i < ( y2 - y1 ); i++ ) {
				j = (int)floor ( (float)i * (float)( x2 - x1 ) / (float)( y2 - y1 ) );
				bp = sdl_screen->pixels;
				*( bp + ( y1 + i ) * 4 * XRes + ( x1 + j ) * 4 ) |= ( color & 0x0000ff00 ) >> 8;
				*( bp + ( y1 + i ) * 4 * XRes + ( x1 + j ) * 4 + 1 ) |= ( color & 0x00ff0000 ) >> 16;
				*( bp + ( y1 + i ) * 4 * XRes + ( x1 + j ) * 4 + 2 ) |= ( color & 0xff000000 ) >> 24;
				*( bp + ( y1 + i ) * 4 * XRes + ( x1 + j ) * 4 + 3 ) |= color & 0x000000ff;
			}
			SDL_UnlockSurface ( sdl_screen );
		}
	}
	if ( y1 > y2 ) {
		if ( ( x2 - x1 ) >= ( y1 - y2 ) ) {
			SDL_LockSurface ( sdl_screen );
			for ( i = 0; i < ( x2 - x1 ); i++ ) {
				j = (int)floor ( (float)i * (float)( y1 - y2 ) / (float)( x2 - x1 ) );
				bp = sdl_screen->pixels;
				*( bp + ( y1 - j ) * 4 * XRes + ( x1 + i ) * 4 ) |= ( color & 0x0000ff00 ) >> 8;
				*( bp + ( y1 - j ) * 4 * XRes + ( x1 + i ) * 4 + 1 ) |= ( color & 0x00ff0000 ) >> 16;
				*( bp + ( y1 - j ) * 4 * XRes + ( x1 + i ) * 4 + 2 ) |= ( color & 0xff000000 ) >> 24;
				*( bp + ( y1 - j ) * 4 * XRes + ( x1 + i ) * 4 + 3 ) |= color & 0x000000ff;
			}
			SDL_UnlockSurface ( sdl_screen );
		}

		if ( ( y1 - y2 ) > ( x2 - x1 ) ) {
			SDL_LockSurface ( sdl_screen );
			for ( i = 0; i < ( y1 - y2 ); i++ ) {
				j = (int)floor ( (float)i * (float)( x2 - x1 ) / (float)( y1 - y2 ) );
				bp = sdl_screen->pixels;
				*( bp + ( y1 - i ) * 4 * XRes + ( x1 + j ) * 4 ) |= ( color & 0x0000ff00 ) >> 8;
				*( bp + ( y1 - i ) * 4 * XRes + ( x1 + j ) * 4 + 1 ) |= ( color & 0x00ff0000 ) >> 16;
				*( bp + ( y1 - i ) * 4 * XRes + ( x1 + j ) * 4 + 2 ) |= ( color & 0xff000000 ) >> 24;
				*( bp + ( y1 - i ) * 4 * XRes + ( x1 + j ) * 4 + 3 ) |= color & 0x000000ff;
			}
			SDL_UnlockSurface ( sdl_screen );
		}
	}
}
