/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdint.h>
#include <cmath>
#include <iostream>
#include "analyst.h"
#include "ringbuffer.h"

using namespace std;

Analyst::Analyst(RingBuffer* r)
{
	ringbuffer = r;
	I = 0;
}

Analyst::~Analyst()
{
	history_E.clear();
	history_ma.clear();
}

int Analyst::analyse()
{
	int retval = 0;
	int16_t* samples = (int16_t*)ringbuffer->get();
	double E = 0;
	double ma = 0;
	double var = 0;
	for(int i = 0; i < ringbuffer->size() / 4; i ++)
	{
		E += pow((double)*(samples + 2 * i), 2);
		E += pow((double)*(samples + 1 + 2 * i), 2);
	}
	E = E * 4 / ringbuffer->size();

	history_E.push_back(E);
	if(history_E.size() > 50) history_E.erase(history_E.begin());

	for(unsigned int i = 0; i < history_E.size(); i ++)
	{
		ma += history_E.at(i);
	}
	ma /= history_E.size();

	history_ma.push_back(ma);
	if(history_ma.size() > 50) history_ma.erase(history_ma.begin());

	for(unsigned int i = 0; i < history_ma.size(); i ++)
	{
		var += fabs(history_E.at(i) - history_ma.at(i));
	}
	var /= history_ma.size();

	if(I == 0) I = E;
	else
	{
		I = 0.933 * I + 0.067 * ma;
	}

	if(E > I + var)
	{
		double bi = (E - I) / var;
		retval = (int)bi;
		I = E;
	}
	
	return retval;
}
