/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef BLURENGINE_H
#define BLURENGINE_H

class SdlScreen;
class VectorField;

class BlurEngine
{
	public:
		BlurEngine(SdlScreen*, VectorField*, bool);
		~BlurEngine();
		void blur();
	private:
		VectorField* vectorfield;
		SdlScreen* sdlscreen;
		int x0, y0, xRes, yRes;
		int cpus;
		void* buffer;
		void emptyBuffer();
		void writeBuffer();
		void blurTrad();
		void blurTrad_MT();
};

#endif // BLURENGINE_H
