/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <cstdlib>
#include <cstring>
#include <unistd.h>
#include <iostream>
#include "ringbuffer.h"
using namespace std;

RingBuffer::RingBuffer(int size)
{
	buffer = (char*)malloc(size);
	data = (char*)malloc(size);
	if((!data) || (!buffer))
	{
		cerr << "ERROR: cannot allocate memory for ringbuffer" << endl;
		exit(EXIT_FAILURE);
	}
	position = 0;
	locked = false;
	length = size;
	full = false;
	inserted = 0;
	cout << "* created ringbuffer of size " << length << endl;
}

RingBuffer::~RingBuffer()
{
	free(buffer);
	free(data);
}

void RingBuffer::insert(char* src, int n)
{
	if(n > length)
	{
		cout << "ERROR: cannot insert " << dec << n << " bytes into ringbuffer of size " << dec << length << endl;
		exit(EXIT_FAILURE);
	}
	while(locked) usleep(89);
	locked = true;
	int d = length - position;
	if(d >= n) memcpy(buffer + position, src, n);
	else
	{
		memcpy(buffer + position, src, d);
		memcpy(buffer, src + d, n - d);
	}
	position += n;
	while(position >= length) position-= length;
	inserted += n;
	if(inserted >= length) full = true;
	locked = false;
}

char* RingBuffer::get()
{
	inserted = 0;
	full = false;
	while(locked) usleep(97);
	locked = true;
	int d = length - position;
	memcpy(data, buffer + position, d);
	memcpy(data + d, buffer, length - d);
	locked = false;
	return data;
}

int RingBuffer::size()
{
	return length;
}

bool RingBuffer::ready()
{
	return full;
}
