/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifdef WIN32
	// please note that fische will not compile or run on windows
	// this is for development reasons only
	#include <SDL.h>
#else
	#include <SDL/SDL.h>
#endif // WIN32
#include <iostream>
#include "sdlscreen.h"

using namespace std;

SdlScreen::SdlScreen(int x, int y, bool fs)
{
	xRes = x;
	yRes = y;
	fullscreen = fs;

	if(SDL_Init(SDL_INIT_VIDEO) != 0)
	{
		cerr << "ERROR: could not initialize SDL" << endl;
		exit(EXIT_FAILURE);
	}
	
	int flags = SDL_SWSURFACE;
	if(fullscreen) flags |= SDL_FULLSCREEN;
	
	screen = SDL_SetVideoMode(xRes, yRes, 32, flags);
	
	if(!screen)
	{
		cerr << "ERROR: could not open requested video mode" << endl;
		exit(EXIT_FAILURE);
	}
	
	// do not show the mouse cursor
	SDL_ShowCursor(SDL_DISABLE);

	// leave cursor and keyboard available to other apps
	SDL_WM_GrabInput(SDL_GRAB_OFF);

	int bpp = screen->format->BitsPerPixel;
	if(bpp != 32)
	{
		cerr << "ERROR: could not set 32 bit pixel format" << endl;
		exit(EXIT_FAILURE);
	}
	
	xRes = screen->w;
	yRes = screen->h;
	
	cout << "* initialized " << screen->w << "x" << screen->h << "x" << bpp << " SDL surface with flags: " << hex << screen->flags << " (";
	if(screen->flags & SDL_HWSURFACE) cout << "HWSURFACE";
	else cout << "SWSURFACE";
	if(screen->flags & SDL_ASYNCBLIT) cout << "|ASYNCBLIT";
	if(screen->flags & SDL_ANYFORMAT) cout << "|ANYFORMAT";
	if(screen->flags & SDL_HWPALETTE) cout << "|HWPALETTE";
	if(screen->flags & SDL_DOUBLEBUF) cout << "|DOUBLEBUF";
	if(screen->flags & SDL_FULLSCREEN) cout << "|FULLSCREEN";
	if(screen->flags & SDL_OPENGL) cout << "|OPENGL";
	if(screen->flags & SDL_OPENGLBLIT) cout << "|OPENGLBLIT";
	if(screen->flags & SDL_RESIZABLE) cout << "|RESIZABLE";
	if(screen->flags & SDL_HWACCEL) cout << "|HWACCEL";
	if(screen->flags & SDL_SRCCOLORKEY) cout << "|SRCCOLORKEY";
	if(screen->flags & SDL_RLEACCEL) cout << "|RLEACCEL";
	if(screen->flags & SDL_SRCALPHA) cout << "|SRCALPHA";
	if(screen->flags & SDL_PREALLOC) cout << "|PREALLOC";
	cout << ")" << endl;

	SDL_WM_SetCaption ("fische 3.0", "fische 3.0");
}

SdlScreen::~SdlScreen()
{
	SDL_ShowCursor(SDL_ENABLE);
	SDL_FreeSurface(screen);
	SDL_Quit();
}

void SdlScreen::update()
{
	SDL_UpdateRect(screen, 0, 0, 0, 0);
}

int SdlScreen::height()
{
	return yRes;
}

int SdlScreen::width()
{
	return xRes;
}

void* SdlScreen::pixels()
{
	return screen->pixels;
}

void SdlScreen::lock()
{
	SDL_LockSurface(screen);
}

void SdlScreen::unlock()
{
	SDL_UnlockSurface(screen);
}

int SdlScreen::pitch()
{
	return screen->pitch;
}

void SdlScreen::toggleFullscreen()
{
	SDL_WM_ToggleFullScreen(screen);
}

int SdlScreen::checkEvents()
{
	SDL_Event event;
	int retval = CONTINUE;

	while(SDL_PollEvent(&event))
	{
		switch(event.type)
		{
			case SDL_KEYDOWN:
				switch(event.key.keysym.sym)
				{
					case SDLK_ESCAPE:
						retval |= EXIT;
						break;
					case SDLK_p:
						retval |= PAUSE;
						break;
					case SDLK_f:
						retval |= TOGGLE_FULLSCREEN;
						break;
					default:
						break;
				}
				break;
			case SDL_QUIT:
				retval |= EXIT;
				break;
			default:
				break;
		}
	}
	return ( retval );
}
