/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SDLSCREEN_H
#define SDLSCREEN_H

#define CONTINUE 0
#define EXIT 1
#define PAUSE 2
#define TOGGLE_FULLSCREEN 4

class SDL_Surface;

class SdlScreen
{
	public:
		SdlScreen(int, int, bool);
		~SdlScreen();
		int height();
		int width();
		void* pixels();
		void lock();
		void unlock();
		int pitch();
		void update();
		int checkEvents();
		void toggleFullscreen();
		
	private:
		SDL_Surface *screen;
		int xRes, yRes;
		bool fullscreen;
};


#endif // SDLSCREEN_H
