/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * fische-3.0
 * Copyright (C) Marcel Ebmer 2009 <marcel@26elf.at>
 * 
 * fische-3.0 is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 * 
 * fische-3.0 is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <unistd.h>
#include <pthread.h>
#include "traditional.h"

void *traditional(void* arg)
{
	param_t* p = (param_t*)arg;

	char* vectors = p->vectors;
	char* vp = NULL;

	const int xRes = p->xRes;
	const int yS = p->yS;
	const int yE = p->yE;

	const int pitch = p->pitch;
	
	uint32_t* pixels = (uint32_t*)p->pixels;
	uint32_t* sp;

	uint32_t* dest = (uint32_t*)p->buffer;
	uint32_t* dp;

	uint32_t s[5];
	
	const int y0 = p->y0;
	const int x0 = p->x0;

	const int d1 = 2 * pitch;
	const int d2 = 2;
	
	int x, y, i;
	char vX, vY;

	for(x = 0; x < xRes; x += 16)
	{
		for(y = yS; y < yE; y ++)
		{
			vp = vectors + (y * xRes + x) * 2;
			dp = dest + y * xRes + x;
			for(i = 0; i < 16; i ++)
			{
				if(x + i >= xRes) break;
				vX = *(vp + 2 * i + 0);
				vY = *(vp + 2 * i + 1);
				sp = pixels + (y0 + y + vY) * pitch + x0 + x + vX + i;
				s[0] = (*(sp + d1) >> 3) & 0x1f1f1f1f;
				s[1] = (*(sp - d1) >> 3) & 0x1f1f1f1f;
				s[2] = (*(sp + d2) >> 3) & 0x1f1f1f1f;
				s[3] = (*(sp - d2) >> 3) & 0x1f1f1f1f;
				s[4] = (*(sp) >> 1) & 0x7f7f7f7f;
				*(dp + i) = s[0] + s[1] + s[2] + s[3] + s[4];
			}
		}
	}
	return NULL;
}
