#
# Initializations that should only be performed when in interactive mode
#

if test -z $fish_interactive
   exit
end

#
# Print a greeting 
#

printf 'Welcome to fish, the friendly interactive shell\nType ' 
set_color green 
printf 'help ' 
set_color normal 
printf 'for instructions on how to use fish\n' 

#
# Setup the CDPATH variable
#

set -gx CDPATH . ~

#
# Set exit message
#

function fish_on_exit -d "Commands to execute when fish exits"
	echo Good bye
end

#
# Set the default prompt command
#

function fish_prompt -d "Write out the prompt"
	whoami
	echo @
	hostname|cut -d . -f 1
	echo ' '
	set_color green
	printf '\n'
	prompt_pwd
	set_color normal
	printf '\n> '
end

#
# Set INPUTRC to something nice
#
# We override INPUTRC if already set, since it may be set by a shell 
# other than fish, which may use a different file. The new value should
# be exported, since the fish inputrc file plays nice with other files 
# by including them when found.
#

for i in ~/.fish_inputrc /etc/fish_inputrc ~/.inputrc /etc/inputrc
	if test -f $i
		set -xg INPUTRC $i
		break
	end
end


#
# Set various color values
#

# Regular syntax highlighting colors
set -g fish_color_normal normal
set -g fish_color_command green
set -g fish_color_redirection normal
set -g fish_color_comment brown
set -g fish_color_error red

# Background color for matching quotes and parenthesis
set -g fish_color_match cyan

# Background color for search matches
set -g fish_color_search_match purple

# Pager colors
set -g fish_color_pager_prefix cyan
set -g fish_color_pager_completion normal
set -g fish_color_pager_description normal
set -g fish_color_pager_progress cyan

#
# Match colors for grep
#

if grep --help 1>/dev/null 2>/dev/null
	set -gx GREP_COLOR '97;45'
	set -gx -- GREP_OPTIONS '--color=auto'
end

#
# Color definitions for ls
#

if ls --help 1>/dev/null 2>/dev/null
	set -gx LS_COLORS $LS_COLORS '*.jar=01;31' '*.doc=35' '*.pdf=35' '*.ps=35' '*.xls=35' '*.swf=35' '*~=37'
end
