
/** \file wildcard.h 

    My own globbing implementation. Needed to implement this instead
    of using libs globbing to support tab-expantion of globbed
    paramaters.

*/

/*
    These constants are outside the 31 bit character space of USC4,
	thogh they may clash with WEOF. I need to use characters outside of
	the regular character space to represent wildcards and such, 
	in order to do backslash removal before wildcard matching.
*/

/** Character representing any character except '/' */
#define ANY_CHAR 0xfffffffe
/** Character representing any character string not containin '/' */
#define ANY_STRING 0xfffffffd

/**
    Expand the wildcard by matching against the filesystem. 

	New strings are allocated using malloc and should be freed by the caller.

	wildcard_expand works by dividing the wildcard into segments at
	each directory boundary. Each segment is processed separatly. All
	except the last segment are handled by matching the wildcard
	segment against all subdirectories of matching directories, and
	recursively calling wildcard_expand for matches. On the last
	segment, matching is made to any file, and all matches are
	inserted to the list.

	If wildcard_expand encounters any arrors (such as insufficient
	priviliges) during matching, error messages will be printed on
	stderr, but wildcard_expand will continue the matching process.

	\return 0 if no matches are found and one if matches are found.
	\param wc The wildcard string
	\param base_dir The base directory of the filesystem to perform the match against
	\param accept_incomplete Whether incomplete matches in the last segment are ok (for tab completion). An incomplete match is a wildcard that matches a prefix of the filename. If accept_incomplete is true, only the remainder of the string is returned.
	\param out The list in which to put the output
	\return 1 if matches where found, 0 otherwise.
   
*/
int wildcard_expand( const wchar_t *wc, 
					 const wchar_t *base_dir, 
					 int accept_incomplete, 
					 array_list_t *out );
/**
   Test whether the wildcard matches the string

   \param str The string to test
   \param wc The wildcard to test against
   \param wc_unescaped if wc_unescaped is true, \c wildcard_match uses the ANY_CHAR and ANY_STRING characters for globbing, otherwise, the '?' and '*' characters are used
   \return true if the wildcard matched

*/
int wildcard_match( const wchar_t *str, 
					const wchar_t *wc,
					int wc_unescaped );

/**
   Check if the specified string contains wildcards
*/
int wildcard_has( const wchar_t *str, int internal );

/**
   Test wildcard completion
*/
void wildcard_complete( const wchar_t *str,
						const wchar_t *wc,
						const wchar_t *desc,						
						const wchar_t *(*desc_func)(const wchar_t *),
						array_list_t *out );
