#
# Completions for the grep command
#

complete -c grep -s A -l after-context -d (_ "Print NUM lines of trailing context")
complete -c grep -s a -l text -d (_ "Process binary file as text")
complete -c grep -s B -l before-context -d (_ "Print NUM lines of leading context")
complete -c grep -s C -l context -d (_ "Print NUM lines of context")
complete -c grep -s b -l byte-offset -d (_ "Print byte offset of matches")
complete -c grep -l binary-files -d (_ "Assume data type for binary files") -x -a "binary text"
complete -c grep -l colour -x -a "never always auto"
complete -c grep -l color -x -a "never always auto"
complete -c grep -s c -l count -d (_ "Only print number of matches")
complete -c grep -s D -l devices -x -a "read skip" -d (_ "Action for devices")
complete -c grep -s d -l directories -x -a "read skip recurse" -d (_ "Action for directories")
complete -c grep -s E -l extended-regexp -d (_ "Pattern is extended regexp")
complete -xc grep -s e -l regexp -d (_ "Pattern is a regexp")
complete -c grep -s F -l fixed -d (_ "Pattern is a fixed string")
complete -c grep -s f -l file -r -d (_ "Use pattern from file")
complete -c grep -s G -l basic-regexp -d (_ "Pattern is basic regex")
complete -c grep -s H -l with-filename -d (_ "Print filename")
complete -c grep -s h -l no-filename -d (_ "Supress printing filename")
complete -c grep -l help -d (_ "Display help and exit")
complete -c grep -s I -d (_ "Skip binary files")
complete -c grep -s i -l ignore-case -d (_ "Ignore case")
complete -c grep -s L -l files-without-match -d (_ "Print first non-matching file")
complete -c grep -s l -l files-with-match -d (_ "Print first matching file")
complete -c grep -s m -l max-count -d (_ "Stop reading after NUM matches")
complete -c grep -l mmap -d (_ "Use the mmap system call to read input")
complete -c grep -s n -l line-number -d (_ "Print linenumber")
complete -c grep -s o -l only-matching -d (_ "Show only matching part")
complete -c grep -l label -d (_ "Rename stdin")
complete -c grep -l line-buffered -d (_ "Use line buffering")
complete -c grep -s q -l quiet -d (_ "Do not write anything")
complete -c grep -l silent -d (_ "Do not write anything")
complete -c grep -s R -l recursive -d (_ "Read files under each directory")
complete -c grep -s r -d (_ "Read files under each directory")
complete -c grep -l include -d (_ "Recurse, search file matching PATTERN")
complete -c grep -l exclude -d (_ "Recurse, skip file matching PATTERN")
complete -c grep -s s -l no-messages -d (_ "Suppress error messages")
complete -c grep -s U -l binary -d (_ "Treat files as binary")
complete -c grep -s u -l unix-byte-offsets -d (_ "Report Unix-style byte offsets")
complete -c grep -s V -l version -d (_ "Display version and exit")
complete -c grep -s v -l invert-match -d (_ "Invert the sense of matching")
complete -c grep -s w -l word-regexp -d (_ "Only whole matching words")
complete -c grep -s x -l line-regexp -d (_ "Only whole matching lines")
complete -c grep -s y -d (_ "Synonym for -i")
complete -c grep -s Z -l null -d (_ "Output a zero byte after filename")


