// This file is part of fityk program. Copyright (C) Marcin Wojdyr
// Licence: GNU General Public License version 2
// $Id: wx_IO.cpp 264 2007-03-01 10:10:54Z wojdyr $


// wxwindows headers, see wxwindows samples for description
#include <wx/wxprec.h>
#ifdef __BORLANDC__
#pragma hdrstop
#endif
#ifndef WX_PRECOMP
#include <wx/wx.h>
#endif

#include "../ui.h"
#include "gui.h"
#include "../cmd.h"

using namespace std;

void UserInterface::showMessage (OutputStyle style, const string& s)
{
    frame->output_text(style, s + "\n");
}

void UserInterface::doDrawPlot(bool now)
{
        frame->refresh_plots(now);
}

void UserInterface::wait (float seconds) 
{  
    wxMilliSleep(iround(seconds*1e3)); 
}

void UserInterface::refresh()
{
    wxSafeYield();
}

Commands::Status UserInterface::execCommand(const string& s)
{
    //FIXME should I limit number of displayed lines?
    //const int max_lines_in_output_win = 1000;
    //don't output plot command - it is generated by every zoom in/out etc.
    bool output = strncmp(s.c_str(), "plot", 4) != 0;
    if (output)
        frame->output_text(os_input, "=-> " + s + "\n");
    else
        frame->set_status_text(s);
    wxBusyCursor wait;
    Commands::Status r;
    try {
        r = parse_and_execute(s);
    }
    catch(ExitRequestedException) {
        frame->Close(true);
        return Commands::status_ok;
    }
    frame->after_cmd_updates();
    return r;
}

