/*
Copyright 2016 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// ************************************************************
// DO NOT EDIT.
// THIS FILE IS AUTO-GENERATED BY codecgen.
// ************************************************************

package v1

import (
	"errors"
	"fmt"
	codec1978 "github.com/ugorji/go/codec"
	pkg3_resource "k8s.io/apimachinery/pkg/api/resource"
	pkg2_v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	pkg5_runtime "k8s.io/apimachinery/pkg/runtime"
	pkg1_types "k8s.io/apimachinery/pkg/types"
	pkg4_intstr "k8s.io/apimachinery/pkg/util/intstr"
	"reflect"
	"runtime"
	time "time"
)

const (
	// ----- content types ----
	codecSelferC_UTF81234 = 1
	codecSelferC_RAW1234  = 0
	// ----- value types used ----
	codecSelferValueTypeArray1234 = 10
	codecSelferValueTypeMap1234   = 9
	// ----- containerStateValues ----
	codecSelfer_containerMapKey1234    = 2
	codecSelfer_containerMapValue1234  = 3
	codecSelfer_containerMapEnd1234    = 4
	codecSelfer_containerArrayElem1234 = 6
	codecSelfer_containerArrayEnd1234  = 7
)

var (
	codecSelferBitsize1234                         = uint8(reflect.TypeOf(uint(0)).Bits())
	codecSelferOnlyMapOrArrayEncodeToStructErr1234 = errors.New(`only encoded map or array can be decoded into a struct`)
)

type codecSelfer1234 struct{}

func init() {
	if codec1978.GenVersion != 5 {
		_, file, _, _ := runtime.Caller(0)
		err := fmt.Errorf("codecgen version mismatch: current: %v, need %v. Re-generate file: %v",
			5, codec1978.GenVersion, file)
		panic(err)
	}
	if false { // reference the types, but skip this branch at build/run time
		var v0 pkg3_resource.Quantity
		var v1 pkg2_v1.Time
		var v2 pkg5_runtime.RawExtension
		var v3 pkg1_types.UID
		var v4 pkg4_intstr.IntOrString
		var v5 time.Time
		_, _, _, _, _, _ = v0, v1, v2, v3, v4, v5
	}
}

func (x *ObjectMeta) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [15]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.GenerateName != ""
			yyq2[2] = x.Namespace != ""
			yyq2[3] = x.SelfLink != ""
			yyq2[4] = x.UID != ""
			yyq2[5] = x.ResourceVersion != ""
			yyq2[6] = x.Generation != 0
			yyq2[7] = true
			yyq2[8] = x.DeletionTimestamp != nil
			yyq2[9] = x.DeletionGracePeriodSeconds != nil
			yyq2[10] = len(x.Labels) != 0
			yyq2[11] = len(x.Annotations) != 0
			yyq2[12] = len(x.OwnerReferences) != 0
			yyq2[13] = len(x.Finalizers) != 0
			yyq2[14] = x.ClusterName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(15)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generateName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.GenerateName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespace"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Namespace))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selfLink"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SelfLink))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("uid"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(x.UID) {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.UID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ResourceVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("generation"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.Generation))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yy25 := &x.CreationTimestamp
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else if z.HasExtensions() && z.EncExt(yy25) {
					} else if yym26 {
						z.EncBinaryMarshal(yy25)
					} else if !yym26 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy25)
					} else {
						z.EncFallback(yy25)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("creationTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy27 := &x.CreationTimestamp
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else if z.HasExtensions() && z.EncExt(yy27) {
					} else if yym28 {
						z.EncBinaryMarshal(yy27)
					} else if !yym28 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy27)
					} else {
						z.EncFallback(yy27)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym30 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym30 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionTimestamp"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionTimestamp == nil {
						r.EncodeNil()
					} else {
						yym31 := z.EncBinary()
						_ = yym31
						if false {
						} else if z.HasExtensions() && z.EncExt(x.DeletionTimestamp) {
						} else if yym31 {
							z.EncBinaryMarshal(x.DeletionTimestamp)
						} else if !yym31 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.DeletionTimestamp)
						} else {
							z.EncFallback(x.DeletionTimestamp)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy33 := *x.DeletionGracePeriodSeconds
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							r.EncodeInt(int64(yy33))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deletionGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeletionGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy35 := *x.DeletionGracePeriodSeconds
						yym36 := z.EncBinary()
						_ = yym36
						if false {
						} else {
							r.EncodeInt(int64(yy35))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym38 := z.EncBinary()
						_ = yym38
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labels"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Labels == nil {
						r.EncodeNil()
					} else {
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							z.F.EncMapStringStringV(x.Labels, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("annotations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Annotations == nil {
						r.EncodeNil()
					} else {
						yym42 := z.EncBinary()
						_ = yym42
						if false {
						} else {
							z.F.EncMapStringStringV(x.Annotations, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym44 := z.EncBinary()
						_ = yym44
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg2_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ownerReferences"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.OwnerReferences == nil {
						r.EncodeNil()
					} else {
						yym45 := z.EncBinary()
						_ = yym45
						if false {
						} else {
							h.encSlicev1_OwnerReference(([]pkg2_v1.OwnerReference)(x.OwnerReferences), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym47 := z.EncBinary()
						_ = yym47
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finalizers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Finalizers == nil {
						r.EncodeNil()
					} else {
						yym48 := z.EncBinary()
						_ = yym48
						if false {
						} else {
							z.F.EncSliceStringV(x.Finalizers, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym51 := z.EncBinary()
					_ = yym51
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectMeta) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectMeta) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "generateName":
			if r.TryDecodeAsNil() {
				x.GenerateName = ""
			} else {
				yyv6 := &x.GenerateName
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "namespace":
			if r.TryDecodeAsNil() {
				x.Namespace = ""
			} else {
				yyv8 := &x.Namespace
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "selfLink":
			if r.TryDecodeAsNil() {
				x.SelfLink = ""
			} else {
				yyv10 := &x.SelfLink
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "uid":
			if r.TryDecodeAsNil() {
				x.UID = ""
			} else {
				yyv12 := &x.UID
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv12) {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		case "resourceVersion":
			if r.TryDecodeAsNil() {
				x.ResourceVersion = ""
			} else {
				yyv14 := &x.ResourceVersion
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					*((*string)(yyv14)) = r.DecodeString()
				}
			}
		case "generation":
			if r.TryDecodeAsNil() {
				x.Generation = 0
			} else {
				yyv16 := &x.Generation
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else {
					*((*int64)(yyv16)) = int64(r.DecodeInt(64))
				}
			}
		case "creationTimestamp":
			if r.TryDecodeAsNil() {
				x.CreationTimestamp = pkg2_v1.Time{}
			} else {
				yyv18 := &x.CreationTimestamp
				yym19 := z.DecBinary()
				_ = yym19
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv18) {
				} else if yym19 {
					z.DecBinaryUnmarshal(yyv18)
				} else if !yym19 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv18)
				} else {
					z.DecFallback(yyv18, false)
				}
			}
		case "deletionTimestamp":
			if r.TryDecodeAsNil() {
				if x.DeletionTimestamp != nil {
					x.DeletionTimestamp = nil
				}
			} else {
				if x.DeletionTimestamp == nil {
					x.DeletionTimestamp = new(pkg2_v1.Time)
				}
				yym21 := z.DecBinary()
				_ = yym21
				if false {
				} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
				} else if yym21 {
					z.DecBinaryUnmarshal(x.DeletionTimestamp)
				} else if !yym21 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.DeletionTimestamp)
				} else {
					z.DecFallback(x.DeletionTimestamp, false)
				}
			}
		case "deletionGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.DeletionGracePeriodSeconds != nil {
					x.DeletionGracePeriodSeconds = nil
				}
			} else {
				if x.DeletionGracePeriodSeconds == nil {
					x.DeletionGracePeriodSeconds = new(int64)
				}
				yym23 := z.DecBinary()
				_ = yym23
				if false {
				} else {
					*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "labels":
			if r.TryDecodeAsNil() {
				x.Labels = nil
			} else {
				yyv24 := &x.Labels
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else {
					z.F.DecMapStringStringX(yyv24, false, d)
				}
			}
		case "annotations":
			if r.TryDecodeAsNil() {
				x.Annotations = nil
			} else {
				yyv26 := &x.Annotations
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else {
					z.F.DecMapStringStringX(yyv26, false, d)
				}
			}
		case "ownerReferences":
			if r.TryDecodeAsNil() {
				x.OwnerReferences = nil
			} else {
				yyv28 := &x.OwnerReferences
				yym29 := z.DecBinary()
				_ = yym29
				if false {
				} else {
					h.decSlicev1_OwnerReference((*[]pkg2_v1.OwnerReference)(yyv28), d)
				}
			}
		case "finalizers":
			if r.TryDecodeAsNil() {
				x.Finalizers = nil
			} else {
				yyv30 := &x.Finalizers
				yym31 := z.DecBinary()
				_ = yym31
				if false {
				} else {
					z.F.DecSliceStringX(yyv30, false, d)
				}
			}
		case "clusterName":
			if r.TryDecodeAsNil() {
				x.ClusterName = ""
			} else {
				yyv32 := &x.ClusterName
				yym33 := z.DecBinary()
				_ = yym33
				if false {
				} else {
					*((*string)(yyv32)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectMeta) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj34 int
	var yyb34 bool
	var yyhl34 bool = l >= 0
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv35 := &x.Name
		yym36 := z.DecBinary()
		_ = yym36
		if false {
		} else {
			*((*string)(yyv35)) = r.DecodeString()
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.GenerateName = ""
	} else {
		yyv37 := &x.GenerateName
		yym38 := z.DecBinary()
		_ = yym38
		if false {
		} else {
			*((*string)(yyv37)) = r.DecodeString()
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespace = ""
	} else {
		yyv39 := &x.Namespace
		yym40 := z.DecBinary()
		_ = yym40
		if false {
		} else {
			*((*string)(yyv39)) = r.DecodeString()
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SelfLink = ""
	} else {
		yyv41 := &x.SelfLink
		yym42 := z.DecBinary()
		_ = yym42
		if false {
		} else {
			*((*string)(yyv41)) = r.DecodeString()
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.UID = ""
	} else {
		yyv43 := &x.UID
		yym44 := z.DecBinary()
		_ = yym44
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv43) {
		} else {
			*((*string)(yyv43)) = r.DecodeString()
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ResourceVersion = ""
	} else {
		yyv45 := &x.ResourceVersion
		yym46 := z.DecBinary()
		_ = yym46
		if false {
		} else {
			*((*string)(yyv45)) = r.DecodeString()
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Generation = 0
	} else {
		yyv47 := &x.Generation
		yym48 := z.DecBinary()
		_ = yym48
		if false {
		} else {
			*((*int64)(yyv47)) = int64(r.DecodeInt(64))
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CreationTimestamp = pkg2_v1.Time{}
	} else {
		yyv49 := &x.CreationTimestamp
		yym50 := z.DecBinary()
		_ = yym50
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv49) {
		} else if yym50 {
			z.DecBinaryUnmarshal(yyv49)
		} else if !yym50 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv49)
		} else {
			z.DecFallback(yyv49, false)
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionTimestamp != nil {
			x.DeletionTimestamp = nil
		}
	} else {
		if x.DeletionTimestamp == nil {
			x.DeletionTimestamp = new(pkg2_v1.Time)
		}
		yym52 := z.DecBinary()
		_ = yym52
		if false {
		} else if z.HasExtensions() && z.DecExt(x.DeletionTimestamp) {
		} else if yym52 {
			z.DecBinaryUnmarshal(x.DeletionTimestamp)
		} else if !yym52 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.DeletionTimestamp)
		} else {
			z.DecFallback(x.DeletionTimestamp, false)
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DeletionGracePeriodSeconds != nil {
			x.DeletionGracePeriodSeconds = nil
		}
	} else {
		if x.DeletionGracePeriodSeconds == nil {
			x.DeletionGracePeriodSeconds = new(int64)
		}
		yym54 := z.DecBinary()
		_ = yym54
		if false {
		} else {
			*((*int64)(x.DeletionGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Labels = nil
	} else {
		yyv55 := &x.Labels
		yym56 := z.DecBinary()
		_ = yym56
		if false {
		} else {
			z.F.DecMapStringStringX(yyv55, false, d)
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Annotations = nil
	} else {
		yyv57 := &x.Annotations
		yym58 := z.DecBinary()
		_ = yym58
		if false {
		} else {
			z.F.DecMapStringStringX(yyv57, false, d)
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.OwnerReferences = nil
	} else {
		yyv59 := &x.OwnerReferences
		yym60 := z.DecBinary()
		_ = yym60
		if false {
		} else {
			h.decSlicev1_OwnerReference((*[]pkg2_v1.OwnerReference)(yyv59), d)
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Finalizers = nil
	} else {
		yyv61 := &x.Finalizers
		yym62 := z.DecBinary()
		_ = yym62
		if false {
		} else {
			z.F.DecSliceStringX(yyv61, false, d)
		}
	}
	yyj34++
	if yyhl34 {
		yyb34 = yyj34 > l
	} else {
		yyb34 = r.CheckBreak()
	}
	if yyb34 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterName = ""
	} else {
		yyv63 := &x.ClusterName
		yym64 := z.DecBinary()
		_ = yym64
		if false {
		} else {
			*((*string)(yyv63)) = r.DecodeString()
		}
	}
	for {
		yyj34++
		if yyhl34 {
			yyb34 = yyj34 > l
		} else {
			yyb34 = r.CheckBreak()
		}
		if yyb34 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj34-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Volume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [27]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.VolumeSource.HostPath != nil && x.HostPath != nil
			yyq2[2] = x.VolumeSource.EmptyDir != nil && x.EmptyDir != nil
			yyq2[3] = x.VolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq2[4] = x.VolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq2[5] = x.VolumeSource.GitRepo != nil && x.GitRepo != nil
			yyq2[6] = x.VolumeSource.Secret != nil && x.Secret != nil
			yyq2[7] = x.VolumeSource.NFS != nil && x.NFS != nil
			yyq2[8] = x.VolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq2[9] = x.VolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq2[10] = x.VolumeSource.PersistentVolumeClaim != nil && x.PersistentVolumeClaim != nil
			yyq2[11] = x.VolumeSource.RBD != nil && x.RBD != nil
			yyq2[12] = x.VolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq2[13] = x.VolumeSource.Cinder != nil && x.Cinder != nil
			yyq2[14] = x.VolumeSource.CephFS != nil && x.CephFS != nil
			yyq2[15] = x.VolumeSource.Flocker != nil && x.Flocker != nil
			yyq2[16] = x.VolumeSource.DownwardAPI != nil && x.DownwardAPI != nil
			yyq2[17] = x.VolumeSource.FC != nil && x.FC != nil
			yyq2[18] = x.VolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq2[19] = x.VolumeSource.ConfigMap != nil && x.ConfigMap != nil
			yyq2[20] = x.VolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq2[21] = x.VolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq2[22] = x.VolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq2[23] = x.VolumeSource.PhotonPersistentDisk != nil && x.PhotonPersistentDisk != nil
			yyq2[24] = x.VolumeSource.Projected != nil && x.Projected != nil
			yyq2[25] = x.VolumeSource.PortworxVolume != nil && x.PortworxVolume != nil
			yyq2[26] = x.VolumeSource.ScaleIO != nil && x.ScaleIO != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(27)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			var yyn6 bool
			if x.VolumeSource.HostPath == nil {
				yyn6 = true
				goto LABEL6
			}
		LABEL6:
			if yyr2 || yy2arr2 {
				if yyn6 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[1] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn6 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn9 bool
			if x.VolumeSource.EmptyDir == nil {
				yyn9 = true
				goto LABEL9
			}
		LABEL9:
			if yyr2 || yy2arr2 {
				if yyn9 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[2] {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn9 {
						r.EncodeNil()
					} else {
						if x.EmptyDir == nil {
							r.EncodeNil()
						} else {
							x.EmptyDir.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn12 bool
			if x.VolumeSource.GCEPersistentDisk == nil {
				yyn12 = true
				goto LABEL12
			}
		LABEL12:
			if yyr2 || yy2arr2 {
				if yyn12 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[3] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn12 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn15 bool
			if x.VolumeSource.AWSElasticBlockStore == nil {
				yyn15 = true
				goto LABEL15
			}
		LABEL15:
			if yyr2 || yy2arr2 {
				if yyn15 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[4] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn15 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn18 bool
			if x.VolumeSource.GitRepo == nil {
				yyn18 = true
				goto LABEL18
			}
		LABEL18:
			if yyr2 || yy2arr2 {
				if yyn18 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[5] {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn18 {
						r.EncodeNil()
					} else {
						if x.GitRepo == nil {
							r.EncodeNil()
						} else {
							x.GitRepo.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn21 bool
			if x.VolumeSource.Secret == nil {
				yyn21 = true
				goto LABEL21
			}
		LABEL21:
			if yyr2 || yy2arr2 {
				if yyn21 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[6] {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn21 {
						r.EncodeNil()
					} else {
						if x.Secret == nil {
							r.EncodeNil()
						} else {
							x.Secret.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn24 bool
			if x.VolumeSource.NFS == nil {
				yyn24 = true
				goto LABEL24
			}
		LABEL24:
			if yyr2 || yy2arr2 {
				if yyn24 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[7] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn24 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn27 bool
			if x.VolumeSource.ISCSI == nil {
				yyn27 = true
				goto LABEL27
			}
		LABEL27:
			if yyr2 || yy2arr2 {
				if yyn27 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[8] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn27 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn30 bool
			if x.VolumeSource.Glusterfs == nil {
				yyn30 = true
				goto LABEL30
			}
		LABEL30:
			if yyr2 || yy2arr2 {
				if yyn30 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[9] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn30 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn33 bool
			if x.VolumeSource.PersistentVolumeClaim == nil {
				yyn33 = true
				goto LABEL33
			}
		LABEL33:
			if yyr2 || yy2arr2 {
				if yyn33 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[10] {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn33 {
						r.EncodeNil()
					} else {
						if x.PersistentVolumeClaim == nil {
							r.EncodeNil()
						} else {
							x.PersistentVolumeClaim.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn36 bool
			if x.VolumeSource.RBD == nil {
				yyn36 = true
				goto LABEL36
			}
		LABEL36:
			if yyr2 || yy2arr2 {
				if yyn36 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[11] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn36 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn39 bool
			if x.VolumeSource.FlexVolume == nil {
				yyn39 = true
				goto LABEL39
			}
		LABEL39:
			if yyr2 || yy2arr2 {
				if yyn39 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn39 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn42 bool
			if x.VolumeSource.Cinder == nil {
				yyn42 = true
				goto LABEL42
			}
		LABEL42:
			if yyr2 || yy2arr2 {
				if yyn42 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[13] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn42 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn45 bool
			if x.VolumeSource.CephFS == nil {
				yyn45 = true
				goto LABEL45
			}
		LABEL45:
			if yyr2 || yy2arr2 {
				if yyn45 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[14] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn45 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn48 bool
			if x.VolumeSource.Flocker == nil {
				yyn48 = true
				goto LABEL48
			}
		LABEL48:
			if yyr2 || yy2arr2 {
				if yyn48 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[15] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn48 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn51 bool
			if x.VolumeSource.DownwardAPI == nil {
				yyn51 = true
				goto LABEL51
			}
		LABEL51:
			if yyr2 || yy2arr2 {
				if yyn51 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[16] {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn51 {
						r.EncodeNil()
					} else {
						if x.DownwardAPI == nil {
							r.EncodeNil()
						} else {
							x.DownwardAPI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn54 bool
			if x.VolumeSource.FC == nil {
				yyn54 = true
				goto LABEL54
			}
		LABEL54:
			if yyr2 || yy2arr2 {
				if yyn54 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[17] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn54 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn57 bool
			if x.VolumeSource.AzureFile == nil {
				yyn57 = true
				goto LABEL57
			}
		LABEL57:
			if yyr2 || yy2arr2 {
				if yyn57 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[18] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn57 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn60 bool
			if x.VolumeSource.ConfigMap == nil {
				yyn60 = true
				goto LABEL60
			}
		LABEL60:
			if yyr2 || yy2arr2 {
				if yyn60 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[19] {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn60 {
						r.EncodeNil()
					} else {
						if x.ConfigMap == nil {
							r.EncodeNil()
						} else {
							x.ConfigMap.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn63 bool
			if x.VolumeSource.VsphereVolume == nil {
				yyn63 = true
				goto LABEL63
			}
		LABEL63:
			if yyr2 || yy2arr2 {
				if yyn63 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[20] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn63 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn66 bool
			if x.VolumeSource.Quobyte == nil {
				yyn66 = true
				goto LABEL66
			}
		LABEL66:
			if yyr2 || yy2arr2 {
				if yyn66 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[21] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn66 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn69 bool
			if x.VolumeSource.AzureDisk == nil {
				yyn69 = true
				goto LABEL69
			}
		LABEL69:
			if yyr2 || yy2arr2 {
				if yyn69 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[22] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn69 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn72 bool
			if x.VolumeSource.PhotonPersistentDisk == nil {
				yyn72 = true
				goto LABEL72
			}
		LABEL72:
			if yyr2 || yy2arr2 {
				if yyn72 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[23] {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[23] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn72 {
						r.EncodeNil()
					} else {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn75 bool
			if x.VolumeSource.Projected == nil {
				yyn75 = true
				goto LABEL75
			}
		LABEL75:
			if yyr2 || yy2arr2 {
				if yyn75 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[24] {
						if x.Projected == nil {
							r.EncodeNil()
						} else {
							x.Projected.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[24] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("projected"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn75 {
						r.EncodeNil()
					} else {
						if x.Projected == nil {
							r.EncodeNil()
						} else {
							x.Projected.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn78 bool
			if x.VolumeSource.PortworxVolume == nil {
				yyn78 = true
				goto LABEL78
			}
		LABEL78:
			if yyr2 || yy2arr2 {
				if yyn78 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[25] {
						if x.PortworxVolume == nil {
							r.EncodeNil()
						} else {
							x.PortworxVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[25] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("portworxVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn78 {
						r.EncodeNil()
					} else {
						if x.PortworxVolume == nil {
							r.EncodeNil()
						} else {
							x.PortworxVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn81 bool
			if x.VolumeSource.ScaleIO == nil {
				yyn81 = true
				goto LABEL81
			}
		LABEL81:
			if yyr2 || yy2arr2 {
				if yyn81 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[26] {
						if x.ScaleIO == nil {
							r.EncodeNil()
						} else {
							x.ScaleIO.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[26] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scaleIO"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn81 {
						r.EncodeNil()
					} else {
						if x.ScaleIO == nil {
							r.EncodeNil()
						} else {
							x.ScaleIO.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Volume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Volume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "hostPath":
			if x.VolumeSource.HostPath == nil {
				x.VolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if x.VolumeSource.EmptyDir == nil {
				x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.VolumeSource.GCEPersistentDisk == nil {
				x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.VolumeSource.AWSElasticBlockStore == nil {
				x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if x.VolumeSource.GitRepo == nil {
				x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if x.VolumeSource.Secret == nil {
				x.VolumeSource.Secret = new(SecretVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.VolumeSource.NFS == nil {
				x.VolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.VolumeSource.ISCSI == nil {
				x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.VolumeSource.Glusterfs == nil {
				x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if x.VolumeSource.PersistentVolumeClaim == nil {
				x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.VolumeSource.RBD == nil {
				x.VolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.VolumeSource.FlexVolume == nil {
				x.VolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.VolumeSource.Cinder == nil {
				x.VolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.VolumeSource.CephFS == nil {
				x.VolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.VolumeSource.Flocker == nil {
				x.VolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if x.VolumeSource.DownwardAPI == nil {
				x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if x.VolumeSource.FC == nil {
				x.VolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.VolumeSource.AzureFile == nil {
				x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if x.VolumeSource.ConfigMap == nil {
				x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.VolumeSource.VsphereVolume == nil {
				x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.VolumeSource.Quobyte == nil {
				x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.VolumeSource.AzureDisk == nil {
				x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if x.VolumeSource.PhotonPersistentDisk == nil {
				x.VolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		case "projected":
			if x.VolumeSource.Projected == nil {
				x.VolumeSource.Projected = new(ProjectedVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Projected != nil {
					x.Projected = nil
				}
			} else {
				if x.Projected == nil {
					x.Projected = new(ProjectedVolumeSource)
				}
				x.Projected.CodecDecodeSelf(d)
			}
		case "portworxVolume":
			if x.VolumeSource.PortworxVolume == nil {
				x.VolumeSource.PortworxVolume = new(PortworxVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PortworxVolume != nil {
					x.PortworxVolume = nil
				}
			} else {
				if x.PortworxVolume == nil {
					x.PortworxVolume = new(PortworxVolumeSource)
				}
				x.PortworxVolume.CodecDecodeSelf(d)
			}
		case "scaleIO":
			if x.VolumeSource.ScaleIO == nil {
				x.VolumeSource.ScaleIO = new(ScaleIOVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ScaleIO != nil {
					x.ScaleIO = nil
				}
			} else {
				if x.ScaleIO == nil {
					x.ScaleIO = new(ScaleIOVolumeSource)
				}
				x.ScaleIO.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Volume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj32 int
	var yyb32 bool
	var yyhl32 bool = l >= 0
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv33 := &x.Name
		yym34 := z.DecBinary()
		_ = yym34
		if false {
		} else {
			*((*string)(yyv33)) = r.DecodeString()
		}
	}
	if x.VolumeSource.HostPath == nil {
		x.VolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.VolumeSource.EmptyDir == nil {
		x.VolumeSource.EmptyDir = new(EmptyDirVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GCEPersistentDisk == nil {
		x.VolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AWSElasticBlockStore == nil {
		x.VolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.VolumeSource.GitRepo == nil {
		x.VolumeSource.GitRepo = new(GitRepoVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Secret == nil {
		x.VolumeSource.Secret = new(SecretVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	if x.VolumeSource.NFS == nil {
		x.VolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ISCSI == nil {
		x.VolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Glusterfs == nil {
		x.VolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PersistentVolumeClaim == nil {
		x.VolumeSource.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	if x.VolumeSource.RBD == nil {
		x.VolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FlexVolume == nil {
		x.VolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Cinder == nil {
		x.VolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.VolumeSource.CephFS == nil {
		x.VolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Flocker == nil {
		x.VolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.VolumeSource.DownwardAPI == nil {
		x.VolumeSource.DownwardAPI = new(DownwardAPIVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	if x.VolumeSource.FC == nil {
		x.VolumeSource.FC = new(FCVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureFile == nil {
		x.VolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ConfigMap == nil {
		x.VolumeSource.ConfigMap = new(ConfigMapVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	if x.VolumeSource.VsphereVolume == nil {
		x.VolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Quobyte == nil {
		x.VolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.VolumeSource.AzureDisk == nil {
		x.VolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PhotonPersistentDisk == nil {
		x.VolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	if x.VolumeSource.Projected == nil {
		x.VolumeSource.Projected = new(ProjectedVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Projected != nil {
			x.Projected = nil
		}
	} else {
		if x.Projected == nil {
			x.Projected = new(ProjectedVolumeSource)
		}
		x.Projected.CodecDecodeSelf(d)
	}
	if x.VolumeSource.PortworxVolume == nil {
		x.VolumeSource.PortworxVolume = new(PortworxVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PortworxVolume != nil {
			x.PortworxVolume = nil
		}
	} else {
		if x.PortworxVolume == nil {
			x.PortworxVolume = new(PortworxVolumeSource)
		}
		x.PortworxVolume.CodecDecodeSelf(d)
	}
	if x.VolumeSource.ScaleIO == nil {
		x.VolumeSource.ScaleIO = new(ScaleIOVolumeSource)
	}
	yyj32++
	if yyhl32 {
		yyb32 = yyj32 > l
	} else {
		yyb32 = r.CheckBreak()
	}
	if yyb32 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ScaleIO != nil {
			x.ScaleIO = nil
		}
	} else {
		if x.ScaleIO == nil {
			x.ScaleIO = new(ScaleIOVolumeSource)
		}
		x.ScaleIO.CodecDecodeSelf(d)
	}
	for {
		yyj32++
		if yyhl32 {
			yyb32 = yyj32 > l
		} else {
			yyb32 = r.CheckBreak()
		}
		if yyb32 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj32-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [26]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.HostPath != nil
			yyq2[1] = x.EmptyDir != nil
			yyq2[2] = x.GCEPersistentDisk != nil
			yyq2[3] = x.AWSElasticBlockStore != nil
			yyq2[4] = x.GitRepo != nil
			yyq2[5] = x.Secret != nil
			yyq2[6] = x.NFS != nil
			yyq2[7] = x.ISCSI != nil
			yyq2[8] = x.Glusterfs != nil
			yyq2[9] = x.PersistentVolumeClaim != nil
			yyq2[10] = x.RBD != nil
			yyq2[11] = x.FlexVolume != nil
			yyq2[12] = x.Cinder != nil
			yyq2[13] = x.CephFS != nil
			yyq2[14] = x.Flocker != nil
			yyq2[15] = x.DownwardAPI != nil
			yyq2[16] = x.FC != nil
			yyq2[17] = x.AzureFile != nil
			yyq2[18] = x.ConfigMap != nil
			yyq2[19] = x.VsphereVolume != nil
			yyq2[20] = x.Quobyte != nil
			yyq2[21] = x.AzureDisk != nil
			yyq2[22] = x.PhotonPersistentDisk != nil
			yyq2[23] = x.Projected != nil
			yyq2[24] = x.PortworxVolume != nil
			yyq2[25] = x.ScaleIO != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(26)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("emptyDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EmptyDir == nil {
						r.EncodeNil()
					} else {
						x.EmptyDir.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gitRepo"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GitRepo == nil {
						r.EncodeNil()
					} else {
						x.GitRepo.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeClaim"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PersistentVolumeClaim == nil {
						r.EncodeNil()
					} else {
						x.PersistentVolumeClaim.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[15] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[17] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[18] {
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[19] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[20] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[21] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[22] {
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[23] {
					if x.Projected == nil {
						r.EncodeNil()
					} else {
						x.Projected.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[23] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("projected"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Projected == nil {
						r.EncodeNil()
					} else {
						x.Projected.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[24] {
					if x.PortworxVolume == nil {
						r.EncodeNil()
					} else {
						x.PortworxVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[24] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("portworxVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PortworxVolume == nil {
						r.EncodeNil()
					} else {
						x.PortworxVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[25] {
					if x.ScaleIO == nil {
						r.EncodeNil()
					} else {
						x.ScaleIO.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[25] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scaleIO"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ScaleIO == nil {
						r.EncodeNil()
					} else {
						x.ScaleIO.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "emptyDir":
			if r.TryDecodeAsNil() {
				if x.EmptyDir != nil {
					x.EmptyDir = nil
				}
			} else {
				if x.EmptyDir == nil {
					x.EmptyDir = new(EmptyDirVolumeSource)
				}
				x.EmptyDir.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "gitRepo":
			if r.TryDecodeAsNil() {
				if x.GitRepo != nil {
					x.GitRepo = nil
				}
			} else {
				if x.GitRepo == nil {
					x.GitRepo = new(GitRepoVolumeSource)
				}
				x.GitRepo.CodecDecodeSelf(d)
			}
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretVolumeSource)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "persistentVolumeClaim":
			if r.TryDecodeAsNil() {
				if x.PersistentVolumeClaim != nil {
					x.PersistentVolumeClaim = nil
				}
			} else {
				if x.PersistentVolumeClaim == nil {
					x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
				}
				x.PersistentVolumeClaim.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIVolumeSource)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "configMap":
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapVolumeSource)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		case "projected":
			if r.TryDecodeAsNil() {
				if x.Projected != nil {
					x.Projected = nil
				}
			} else {
				if x.Projected == nil {
					x.Projected = new(ProjectedVolumeSource)
				}
				x.Projected.CodecDecodeSelf(d)
			}
		case "portworxVolume":
			if r.TryDecodeAsNil() {
				if x.PortworxVolume != nil {
					x.PortworxVolume = nil
				}
			} else {
				if x.PortworxVolume == nil {
					x.PortworxVolume = new(PortworxVolumeSource)
				}
				x.PortworxVolume.CodecDecodeSelf(d)
			}
		case "scaleIO":
			if r.TryDecodeAsNil() {
				if x.ScaleIO != nil {
					x.ScaleIO = nil
				}
			} else {
				if x.ScaleIO == nil {
					x.ScaleIO = new(ScaleIOVolumeSource)
				}
				x.ScaleIO.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj30 int
	var yyb30 bool
	var yyhl30 bool = l >= 0
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.EmptyDir != nil {
			x.EmptyDir = nil
		}
	} else {
		if x.EmptyDir == nil {
			x.EmptyDir = new(EmptyDirVolumeSource)
		}
		x.EmptyDir.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GitRepo != nil {
			x.GitRepo = nil
		}
	} else {
		if x.GitRepo == nil {
			x.GitRepo = new(GitRepoVolumeSource)
		}
		x.GitRepo.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretVolumeSource)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PersistentVolumeClaim != nil {
			x.PersistentVolumeClaim = nil
		}
	} else {
		if x.PersistentVolumeClaim == nil {
			x.PersistentVolumeClaim = new(PersistentVolumeClaimVolumeSource)
		}
		x.PersistentVolumeClaim.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIVolumeSource)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapVolumeSource)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Projected != nil {
			x.Projected = nil
		}
	} else {
		if x.Projected == nil {
			x.Projected = new(ProjectedVolumeSource)
		}
		x.Projected.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PortworxVolume != nil {
			x.PortworxVolume = nil
		}
	} else {
		if x.PortworxVolume == nil {
			x.PortworxVolume = new(PortworxVolumeSource)
		}
		x.PortworxVolume.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ScaleIO != nil {
			x.ScaleIO = nil
		}
	} else {
		if x.ScaleIO == nil {
			x.ScaleIO = new(ScaleIOVolumeSource)
		}
		x.ScaleIO.CodecDecodeSelf(d)
	}
	for {
		yyj30++
		if yyhl30 {
			yyb30 = yyj30 > l
		} else {
			yyb30 = r.CheckBreak()
		}
		if yyb30 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj30-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("claimName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ClaimName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "claimName":
			if r.TryDecodeAsNil() {
				x.ClaimName = ""
			} else {
				yyv4 := &x.ClaimName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv6 := &x.ReadOnly
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*bool)(yyv6)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClaimName = ""
	} else {
		yyv9 := &x.ClaimName
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv11 := &x.ReadOnly
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*bool)(yyv11)) = r.DecodeBool()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [19]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.GCEPersistentDisk != nil
			yyq2[1] = x.AWSElasticBlockStore != nil
			yyq2[2] = x.HostPath != nil
			yyq2[3] = x.Glusterfs != nil
			yyq2[4] = x.NFS != nil
			yyq2[5] = x.RBD != nil
			yyq2[6] = x.ISCSI != nil
			yyq2[7] = x.Cinder != nil
			yyq2[8] = x.CephFS != nil
			yyq2[9] = x.FC != nil
			yyq2[10] = x.Flocker != nil
			yyq2[11] = x.FlexVolume != nil
			yyq2[12] = x.AzureFile != nil
			yyq2[13] = x.VsphereVolume != nil
			yyq2[14] = x.Quobyte != nil
			yyq2[15] = x.AzureDisk != nil
			yyq2[16] = x.PhotonPersistentDisk != nil
			yyq2[17] = x.PortworxVolume != nil
			yyq2[18] = x.ScaleIO != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(19)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.GCEPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.GCEPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AWSElasticBlockStore == nil {
						r.EncodeNil()
					} else {
						x.AWSElasticBlockStore.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HostPath == nil {
						r.EncodeNil()
					} else {
						x.HostPath.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Glusterfs == nil {
						r.EncodeNil()
					} else {
						x.Glusterfs.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NFS == nil {
						r.EncodeNil()
					} else {
						x.NFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RBD == nil {
						r.EncodeNil()
					} else {
						x.RBD.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ISCSI == nil {
						r.EncodeNil()
					} else {
						x.ISCSI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Cinder == nil {
						r.EncodeNil()
					} else {
						x.Cinder.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CephFS == nil {
						r.EncodeNil()
					} else {
						x.CephFS.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FC == nil {
						r.EncodeNil()
					} else {
						x.FC.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Flocker == nil {
						r.EncodeNil()
					} else {
						x.Flocker.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FlexVolume == nil {
						r.EncodeNil()
					} else {
						x.FlexVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureFile == nil {
						r.EncodeNil()
					} else {
						x.AzureFile.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VsphereVolume == nil {
						r.EncodeNil()
					} else {
						x.VsphereVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Quobyte == nil {
						r.EncodeNil()
					} else {
						x.Quobyte.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[15] {
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AzureDisk == nil {
						r.EncodeNil()
					} else {
						x.AzureDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PhotonPersistentDisk == nil {
						r.EncodeNil()
					} else {
						x.PhotonPersistentDisk.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[17] {
					if x.PortworxVolume == nil {
						r.EncodeNil()
					} else {
						x.PortworxVolume.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("portworxVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PortworxVolume == nil {
						r.EncodeNil()
					} else {
						x.PortworxVolume.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[18] {
					if x.ScaleIO == nil {
						r.EncodeNil()
					} else {
						x.ScaleIO.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scaleIO"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ScaleIO == nil {
						r.EncodeNil()
					} else {
						x.ScaleIO.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "gcePersistentDisk":
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "azureFile":
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		case "portworxVolume":
			if r.TryDecodeAsNil() {
				if x.PortworxVolume != nil {
					x.PortworxVolume = nil
				}
			} else {
				if x.PortworxVolume == nil {
					x.PortworxVolume = new(PortworxVolumeSource)
				}
				x.PortworxVolume.CodecDecodeSelf(d)
			}
		case "scaleIO":
			if r.TryDecodeAsNil() {
				if x.ScaleIO != nil {
					x.ScaleIO = nil
				}
			} else {
				if x.ScaleIO == nil {
					x.ScaleIO = new(ScaleIOVolumeSource)
				}
				x.ScaleIO.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj23 int
	var yyb23 bool
	var yyhl23 bool = l >= 0
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PortworxVolume != nil {
			x.PortworxVolume = nil
		}
	} else {
		if x.PortworxVolume == nil {
			x.PortworxVolume = new(PortworxVolumeSource)
		}
		x.PortworxVolume.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ScaleIO != nil {
			x.ScaleIO = nil
		}
	} else {
		if x.ScaleIO == nil {
			x.ScaleIO = new(ScaleIOVolumeSource)
		}
		x.ScaleIO.CodecDecodeSelf(d)
	}
	for {
		yyj23++
		if yyhl23 {
			yyb23 = yyj23 > l
		} else {
			yyb23 = r.CheckBreak()
		}
		if yyb23 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj23-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolume) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.Spec
					yy15.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Spec
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy20 := &x.Status
					yy20.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy22 := &x.Status
					yy22.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolume) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolume) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv8 := &x.ObjectMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeSpec{}
			} else {
				yyv10 := &x.Spec
				yyv10.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeStatus{}
			} else {
				yyv11 := &x.Status
				yyv11.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolume) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv17 := &x.ObjectMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeSpec{}
	} else {
		yyv19 := &x.Spec
		yyv19.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeStatus{}
	} else {
		yyv20 := &x.Status
		yyv20.CodecDecodeSelf(d)
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [24]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.Capacity) != 0
			yyq2[1] = x.PersistentVolumeSource.GCEPersistentDisk != nil && x.GCEPersistentDisk != nil
			yyq2[2] = x.PersistentVolumeSource.AWSElasticBlockStore != nil && x.AWSElasticBlockStore != nil
			yyq2[3] = x.PersistentVolumeSource.HostPath != nil && x.HostPath != nil
			yyq2[4] = x.PersistentVolumeSource.Glusterfs != nil && x.Glusterfs != nil
			yyq2[5] = x.PersistentVolumeSource.NFS != nil && x.NFS != nil
			yyq2[6] = x.PersistentVolumeSource.RBD != nil && x.RBD != nil
			yyq2[7] = x.PersistentVolumeSource.ISCSI != nil && x.ISCSI != nil
			yyq2[8] = x.PersistentVolumeSource.Cinder != nil && x.Cinder != nil
			yyq2[9] = x.PersistentVolumeSource.CephFS != nil && x.CephFS != nil
			yyq2[10] = x.PersistentVolumeSource.FC != nil && x.FC != nil
			yyq2[11] = x.PersistentVolumeSource.Flocker != nil && x.Flocker != nil
			yyq2[12] = x.PersistentVolumeSource.FlexVolume != nil && x.FlexVolume != nil
			yyq2[13] = x.PersistentVolumeSource.AzureFile != nil && x.AzureFile != nil
			yyq2[14] = x.PersistentVolumeSource.VsphereVolume != nil && x.VsphereVolume != nil
			yyq2[15] = x.PersistentVolumeSource.Quobyte != nil && x.Quobyte != nil
			yyq2[16] = x.PersistentVolumeSource.AzureDisk != nil && x.AzureDisk != nil
			yyq2[17] = x.PersistentVolumeSource.PhotonPersistentDisk != nil && x.PhotonPersistentDisk != nil
			yyq2[18] = x.PersistentVolumeSource.PortworxVolume != nil && x.PortworxVolume != nil
			yyq2[19] = x.PersistentVolumeSource.ScaleIO != nil && x.ScaleIO != nil
			yyq2[20] = len(x.AccessModes) != 0
			yyq2[21] = x.ClaimRef != nil
			yyq2[22] = x.PersistentVolumeReclaimPolicy != ""
			yyq2[23] = x.StorageClassName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(24)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			var yyn6 bool
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				yyn6 = true
				goto LABEL6
			}
		LABEL6:
			if yyr2 || yy2arr2 {
				if yyn6 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[1] {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("gcePersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn6 {
						r.EncodeNil()
					} else {
						if x.GCEPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.GCEPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn9 bool
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				yyn9 = true
				goto LABEL9
			}
		LABEL9:
			if yyr2 || yy2arr2 {
				if yyn9 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[2] {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("awsElasticBlockStore"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn9 {
						r.EncodeNil()
					} else {
						if x.AWSElasticBlockStore == nil {
							r.EncodeNil()
						} else {
							x.AWSElasticBlockStore.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn12 bool
			if x.PersistentVolumeSource.HostPath == nil {
				yyn12 = true
				goto LABEL12
			}
		LABEL12:
			if yyr2 || yy2arr2 {
				if yyn12 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[3] {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn12 {
						r.EncodeNil()
					} else {
						if x.HostPath == nil {
							r.EncodeNil()
						} else {
							x.HostPath.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn15 bool
			if x.PersistentVolumeSource.Glusterfs == nil {
				yyn15 = true
				goto LABEL15
			}
		LABEL15:
			if yyr2 || yy2arr2 {
				if yyn15 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[4] {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("glusterfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn15 {
						r.EncodeNil()
					} else {
						if x.Glusterfs == nil {
							r.EncodeNil()
						} else {
							x.Glusterfs.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn18 bool
			if x.PersistentVolumeSource.NFS == nil {
				yyn18 = true
				goto LABEL18
			}
		LABEL18:
			if yyr2 || yy2arr2 {
				if yyn18 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[5] {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn18 {
						r.EncodeNil()
					} else {
						if x.NFS == nil {
							r.EncodeNil()
						} else {
							x.NFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn21 bool
			if x.PersistentVolumeSource.RBD == nil {
				yyn21 = true
				goto LABEL21
			}
		LABEL21:
			if yyr2 || yy2arr2 {
				if yyn21 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[6] {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("rbd"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn21 {
						r.EncodeNil()
					} else {
						if x.RBD == nil {
							r.EncodeNil()
						} else {
							x.RBD.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn24 bool
			if x.PersistentVolumeSource.ISCSI == nil {
				yyn24 = true
				goto LABEL24
			}
		LABEL24:
			if yyr2 || yy2arr2 {
				if yyn24 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[7] {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsi"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn24 {
						r.EncodeNil()
					} else {
						if x.ISCSI == nil {
							r.EncodeNil()
						} else {
							x.ISCSI.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn27 bool
			if x.PersistentVolumeSource.Cinder == nil {
				yyn27 = true
				goto LABEL27
			}
		LABEL27:
			if yyr2 || yy2arr2 {
				if yyn27 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[8] {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cinder"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn27 {
						r.EncodeNil()
					} else {
						if x.Cinder == nil {
							r.EncodeNil()
						} else {
							x.Cinder.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn30 bool
			if x.PersistentVolumeSource.CephFS == nil {
				yyn30 = true
				goto LABEL30
			}
		LABEL30:
			if yyr2 || yy2arr2 {
				if yyn30 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[9] {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cephfs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn30 {
						r.EncodeNil()
					} else {
						if x.CephFS == nil {
							r.EncodeNil()
						} else {
							x.CephFS.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn33 bool
			if x.PersistentVolumeSource.FC == nil {
				yyn33 = true
				goto LABEL33
			}
		LABEL33:
			if yyr2 || yy2arr2 {
				if yyn33 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[10] {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fc"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn33 {
						r.EncodeNil()
					} else {
						if x.FC == nil {
							r.EncodeNil()
						} else {
							x.FC.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn36 bool
			if x.PersistentVolumeSource.Flocker == nil {
				yyn36 = true
				goto LABEL36
			}
		LABEL36:
			if yyr2 || yy2arr2 {
				if yyn36 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[11] {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flocker"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn36 {
						r.EncodeNil()
					} else {
						if x.Flocker == nil {
							r.EncodeNil()
						} else {
							x.Flocker.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn39 bool
			if x.PersistentVolumeSource.FlexVolume == nil {
				yyn39 = true
				goto LABEL39
			}
		LABEL39:
			if yyr2 || yy2arr2 {
				if yyn39 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[12] {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("flexVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn39 {
						r.EncodeNil()
					} else {
						if x.FlexVolume == nil {
							r.EncodeNil()
						} else {
							x.FlexVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn42 bool
			if x.PersistentVolumeSource.AzureFile == nil {
				yyn42 = true
				goto LABEL42
			}
		LABEL42:
			if yyr2 || yy2arr2 {
				if yyn42 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[13] {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn42 {
						r.EncodeNil()
					} else {
						if x.AzureFile == nil {
							r.EncodeNil()
						} else {
							x.AzureFile.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn45 bool
			if x.PersistentVolumeSource.VsphereVolume == nil {
				yyn45 = true
				goto LABEL45
			}
		LABEL45:
			if yyr2 || yy2arr2 {
				if yyn45 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[14] {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("vsphereVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn45 {
						r.EncodeNil()
					} else {
						if x.VsphereVolume == nil {
							r.EncodeNil()
						} else {
							x.VsphereVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn48 bool
			if x.PersistentVolumeSource.Quobyte == nil {
				yyn48 = true
				goto LABEL48
			}
		LABEL48:
			if yyr2 || yy2arr2 {
				if yyn48 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[15] {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("quobyte"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn48 {
						r.EncodeNil()
					} else {
						if x.Quobyte == nil {
							r.EncodeNil()
						} else {
							x.Quobyte.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn51 bool
			if x.PersistentVolumeSource.AzureDisk == nil {
				yyn51 = true
				goto LABEL51
			}
		LABEL51:
			if yyr2 || yy2arr2 {
				if yyn51 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[16] {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("azureDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn51 {
						r.EncodeNil()
					} else {
						if x.AzureDisk == nil {
							r.EncodeNil()
						} else {
							x.AzureDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn54 bool
			if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
				yyn54 = true
				goto LABEL54
			}
		LABEL54:
			if yyr2 || yy2arr2 {
				if yyn54 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[17] {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("photonPersistentDisk"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn54 {
						r.EncodeNil()
					} else {
						if x.PhotonPersistentDisk == nil {
							r.EncodeNil()
						} else {
							x.PhotonPersistentDisk.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn57 bool
			if x.PersistentVolumeSource.PortworxVolume == nil {
				yyn57 = true
				goto LABEL57
			}
		LABEL57:
			if yyr2 || yy2arr2 {
				if yyn57 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[18] {
						if x.PortworxVolume == nil {
							r.EncodeNil()
						} else {
							x.PortworxVolume.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("portworxVolume"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn57 {
						r.EncodeNil()
					} else {
						if x.PortworxVolume == nil {
							r.EncodeNil()
						} else {
							x.PortworxVolume.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn60 bool
			if x.PersistentVolumeSource.ScaleIO == nil {
				yyn60 = true
				goto LABEL60
			}
		LABEL60:
			if yyr2 || yy2arr2 {
				if yyn60 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[19] {
						if x.ScaleIO == nil {
							r.EncodeNil()
						} else {
							x.ScaleIO.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scaleIO"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn60 {
						r.EncodeNil()
					} else {
						if x.ScaleIO == nil {
							r.EncodeNil()
						} else {
							x.ScaleIO.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[20] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym64 := z.EncBinary()
						_ = yym64
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym65 := z.EncBinary()
						_ = yym65
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[21] {
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("claimRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ClaimRef == nil {
						r.EncodeNil()
					} else {
						x.ClaimRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[22] {
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[22] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("persistentVolumeReclaimPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.PersistentVolumeReclaimPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[23] {
					yym73 := z.EncBinary()
					_ = yym73
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.StorageClassName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[23] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("storageClassName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym74 := z.EncBinary()
					_ = yym74
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.StorageClassName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv4 := &x.Capacity
				yyv4.CodecDecodeSelf(d)
			}
		case "gcePersistentDisk":
			if x.PersistentVolumeSource.GCEPersistentDisk == nil {
				x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.GCEPersistentDisk != nil {
					x.GCEPersistentDisk = nil
				}
			} else {
				if x.GCEPersistentDisk == nil {
					x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
				}
				x.GCEPersistentDisk.CodecDecodeSelf(d)
			}
		case "awsElasticBlockStore":
			if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
				x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AWSElasticBlockStore != nil {
					x.AWSElasticBlockStore = nil
				}
			} else {
				if x.AWSElasticBlockStore == nil {
					x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
				}
				x.AWSElasticBlockStore.CodecDecodeSelf(d)
			}
		case "hostPath":
			if x.PersistentVolumeSource.HostPath == nil {
				x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.HostPath != nil {
					x.HostPath = nil
				}
			} else {
				if x.HostPath == nil {
					x.HostPath = new(HostPathVolumeSource)
				}
				x.HostPath.CodecDecodeSelf(d)
			}
		case "glusterfs":
			if x.PersistentVolumeSource.Glusterfs == nil {
				x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Glusterfs != nil {
					x.Glusterfs = nil
				}
			} else {
				if x.Glusterfs == nil {
					x.Glusterfs = new(GlusterfsVolumeSource)
				}
				x.Glusterfs.CodecDecodeSelf(d)
			}
		case "nfs":
			if x.PersistentVolumeSource.NFS == nil {
				x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.NFS != nil {
					x.NFS = nil
				}
			} else {
				if x.NFS == nil {
					x.NFS = new(NFSVolumeSource)
				}
				x.NFS.CodecDecodeSelf(d)
			}
		case "rbd":
			if x.PersistentVolumeSource.RBD == nil {
				x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.RBD != nil {
					x.RBD = nil
				}
			} else {
				if x.RBD == nil {
					x.RBD = new(RBDVolumeSource)
				}
				x.RBD.CodecDecodeSelf(d)
			}
		case "iscsi":
			if x.PersistentVolumeSource.ISCSI == nil {
				x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ISCSI != nil {
					x.ISCSI = nil
				}
			} else {
				if x.ISCSI == nil {
					x.ISCSI = new(ISCSIVolumeSource)
				}
				x.ISCSI.CodecDecodeSelf(d)
			}
		case "cinder":
			if x.PersistentVolumeSource.Cinder == nil {
				x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Cinder != nil {
					x.Cinder = nil
				}
			} else {
				if x.Cinder == nil {
					x.Cinder = new(CinderVolumeSource)
				}
				x.Cinder.CodecDecodeSelf(d)
			}
		case "cephfs":
			if x.PersistentVolumeSource.CephFS == nil {
				x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.CephFS != nil {
					x.CephFS = nil
				}
			} else {
				if x.CephFS == nil {
					x.CephFS = new(CephFSVolumeSource)
				}
				x.CephFS.CodecDecodeSelf(d)
			}
		case "fc":
			if x.PersistentVolumeSource.FC == nil {
				x.PersistentVolumeSource.FC = new(FCVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FC != nil {
					x.FC = nil
				}
			} else {
				if x.FC == nil {
					x.FC = new(FCVolumeSource)
				}
				x.FC.CodecDecodeSelf(d)
			}
		case "flocker":
			if x.PersistentVolumeSource.Flocker == nil {
				x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Flocker != nil {
					x.Flocker = nil
				}
			} else {
				if x.Flocker == nil {
					x.Flocker = new(FlockerVolumeSource)
				}
				x.Flocker.CodecDecodeSelf(d)
			}
		case "flexVolume":
			if x.PersistentVolumeSource.FlexVolume == nil {
				x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.FlexVolume != nil {
					x.FlexVolume = nil
				}
			} else {
				if x.FlexVolume == nil {
					x.FlexVolume = new(FlexVolumeSource)
				}
				x.FlexVolume.CodecDecodeSelf(d)
			}
		case "azureFile":
			if x.PersistentVolumeSource.AzureFile == nil {
				x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureFile != nil {
					x.AzureFile = nil
				}
			} else {
				if x.AzureFile == nil {
					x.AzureFile = new(AzureFileVolumeSource)
				}
				x.AzureFile.CodecDecodeSelf(d)
			}
		case "vsphereVolume":
			if x.PersistentVolumeSource.VsphereVolume == nil {
				x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.VsphereVolume != nil {
					x.VsphereVolume = nil
				}
			} else {
				if x.VsphereVolume == nil {
					x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
				}
				x.VsphereVolume.CodecDecodeSelf(d)
			}
		case "quobyte":
			if x.PersistentVolumeSource.Quobyte == nil {
				x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.Quobyte != nil {
					x.Quobyte = nil
				}
			} else {
				if x.Quobyte == nil {
					x.Quobyte = new(QuobyteVolumeSource)
				}
				x.Quobyte.CodecDecodeSelf(d)
			}
		case "azureDisk":
			if x.PersistentVolumeSource.AzureDisk == nil {
				x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.AzureDisk != nil {
					x.AzureDisk = nil
				}
			} else {
				if x.AzureDisk == nil {
					x.AzureDisk = new(AzureDiskVolumeSource)
				}
				x.AzureDisk.CodecDecodeSelf(d)
			}
		case "photonPersistentDisk":
			if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
				x.PersistentVolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PhotonPersistentDisk != nil {
					x.PhotonPersistentDisk = nil
				}
			} else {
				if x.PhotonPersistentDisk == nil {
					x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
				}
				x.PhotonPersistentDisk.CodecDecodeSelf(d)
			}
		case "portworxVolume":
			if x.PersistentVolumeSource.PortworxVolume == nil {
				x.PersistentVolumeSource.PortworxVolume = new(PortworxVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.PortworxVolume != nil {
					x.PortworxVolume = nil
				}
			} else {
				if x.PortworxVolume == nil {
					x.PortworxVolume = new(PortworxVolumeSource)
				}
				x.PortworxVolume.CodecDecodeSelf(d)
			}
		case "scaleIO":
			if x.PersistentVolumeSource.ScaleIO == nil {
				x.PersistentVolumeSource.ScaleIO = new(ScaleIOVolumeSource)
			}
			if r.TryDecodeAsNil() {
				if x.ScaleIO != nil {
					x.ScaleIO = nil
				}
			} else {
				if x.ScaleIO == nil {
					x.ScaleIO = new(ScaleIOVolumeSource)
				}
				x.ScaleIO.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv24 := &x.AccessModes
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv24), d)
				}
			}
		case "claimRef":
			if r.TryDecodeAsNil() {
				if x.ClaimRef != nil {
					x.ClaimRef = nil
				}
			} else {
				if x.ClaimRef == nil {
					x.ClaimRef = new(ObjectReference)
				}
				x.ClaimRef.CodecDecodeSelf(d)
			}
		case "persistentVolumeReclaimPolicy":
			if r.TryDecodeAsNil() {
				x.PersistentVolumeReclaimPolicy = ""
			} else {
				yyv27 := &x.PersistentVolumeReclaimPolicy
				yyv27.CodecDecodeSelf(d)
			}
		case "storageClassName":
			if r.TryDecodeAsNil() {
				x.StorageClassName = ""
			} else {
				yyv28 := &x.StorageClassName
				yym29 := z.DecBinary()
				_ = yym29
				if false {
				} else {
					*((*string)(yyv28)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj30 int
	var yyb30 bool
	var yyhl30 bool = l >= 0
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv31 := &x.Capacity
		yyv31.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.GCEPersistentDisk == nil {
		x.PersistentVolumeSource.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.GCEPersistentDisk != nil {
			x.GCEPersistentDisk = nil
		}
	} else {
		if x.GCEPersistentDisk == nil {
			x.GCEPersistentDisk = new(GCEPersistentDiskVolumeSource)
		}
		x.GCEPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AWSElasticBlockStore == nil {
		x.PersistentVolumeSource.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AWSElasticBlockStore != nil {
			x.AWSElasticBlockStore = nil
		}
	} else {
		if x.AWSElasticBlockStore == nil {
			x.AWSElasticBlockStore = new(AWSElasticBlockStoreVolumeSource)
		}
		x.AWSElasticBlockStore.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.HostPath == nil {
		x.PersistentVolumeSource.HostPath = new(HostPathVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HostPath != nil {
			x.HostPath = nil
		}
	} else {
		if x.HostPath == nil {
			x.HostPath = new(HostPathVolumeSource)
		}
		x.HostPath.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Glusterfs == nil {
		x.PersistentVolumeSource.Glusterfs = new(GlusterfsVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Glusterfs != nil {
			x.Glusterfs = nil
		}
	} else {
		if x.Glusterfs == nil {
			x.Glusterfs = new(GlusterfsVolumeSource)
		}
		x.Glusterfs.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.NFS == nil {
		x.PersistentVolumeSource.NFS = new(NFSVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NFS != nil {
			x.NFS = nil
		}
	} else {
		if x.NFS == nil {
			x.NFS = new(NFSVolumeSource)
		}
		x.NFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.RBD == nil {
		x.PersistentVolumeSource.RBD = new(RBDVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RBD != nil {
			x.RBD = nil
		}
	} else {
		if x.RBD == nil {
			x.RBD = new(RBDVolumeSource)
		}
		x.RBD.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ISCSI == nil {
		x.PersistentVolumeSource.ISCSI = new(ISCSIVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ISCSI != nil {
			x.ISCSI = nil
		}
	} else {
		if x.ISCSI == nil {
			x.ISCSI = new(ISCSIVolumeSource)
		}
		x.ISCSI.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Cinder == nil {
		x.PersistentVolumeSource.Cinder = new(CinderVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Cinder != nil {
			x.Cinder = nil
		}
	} else {
		if x.Cinder == nil {
			x.Cinder = new(CinderVolumeSource)
		}
		x.Cinder.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.CephFS == nil {
		x.PersistentVolumeSource.CephFS = new(CephFSVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CephFS != nil {
			x.CephFS = nil
		}
	} else {
		if x.CephFS == nil {
			x.CephFS = new(CephFSVolumeSource)
		}
		x.CephFS.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FC == nil {
		x.PersistentVolumeSource.FC = new(FCVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FC != nil {
			x.FC = nil
		}
	} else {
		if x.FC == nil {
			x.FC = new(FCVolumeSource)
		}
		x.FC.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Flocker == nil {
		x.PersistentVolumeSource.Flocker = new(FlockerVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Flocker != nil {
			x.Flocker = nil
		}
	} else {
		if x.Flocker == nil {
			x.Flocker = new(FlockerVolumeSource)
		}
		x.Flocker.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.FlexVolume == nil {
		x.PersistentVolumeSource.FlexVolume = new(FlexVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FlexVolume != nil {
			x.FlexVolume = nil
		}
	} else {
		if x.FlexVolume == nil {
			x.FlexVolume = new(FlexVolumeSource)
		}
		x.FlexVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureFile == nil {
		x.PersistentVolumeSource.AzureFile = new(AzureFileVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureFile != nil {
			x.AzureFile = nil
		}
	} else {
		if x.AzureFile == nil {
			x.AzureFile = new(AzureFileVolumeSource)
		}
		x.AzureFile.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.VsphereVolume == nil {
		x.PersistentVolumeSource.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.VsphereVolume != nil {
			x.VsphereVolume = nil
		}
	} else {
		if x.VsphereVolume == nil {
			x.VsphereVolume = new(VsphereVirtualDiskVolumeSource)
		}
		x.VsphereVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.Quobyte == nil {
		x.PersistentVolumeSource.Quobyte = new(QuobyteVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Quobyte != nil {
			x.Quobyte = nil
		}
	} else {
		if x.Quobyte == nil {
			x.Quobyte = new(QuobyteVolumeSource)
		}
		x.Quobyte.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.AzureDisk == nil {
		x.PersistentVolumeSource.AzureDisk = new(AzureDiskVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AzureDisk != nil {
			x.AzureDisk = nil
		}
	} else {
		if x.AzureDisk == nil {
			x.AzureDisk = new(AzureDiskVolumeSource)
		}
		x.AzureDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.PhotonPersistentDisk == nil {
		x.PersistentVolumeSource.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PhotonPersistentDisk != nil {
			x.PhotonPersistentDisk = nil
		}
	} else {
		if x.PhotonPersistentDisk == nil {
			x.PhotonPersistentDisk = new(PhotonPersistentDiskVolumeSource)
		}
		x.PhotonPersistentDisk.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.PortworxVolume == nil {
		x.PersistentVolumeSource.PortworxVolume = new(PortworxVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PortworxVolume != nil {
			x.PortworxVolume = nil
		}
	} else {
		if x.PortworxVolume == nil {
			x.PortworxVolume = new(PortworxVolumeSource)
		}
		x.PortworxVolume.CodecDecodeSelf(d)
	}
	if x.PersistentVolumeSource.ScaleIO == nil {
		x.PersistentVolumeSource.ScaleIO = new(ScaleIOVolumeSource)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ScaleIO != nil {
			x.ScaleIO = nil
		}
	} else {
		if x.ScaleIO == nil {
			x.ScaleIO = new(ScaleIOVolumeSource)
		}
		x.ScaleIO.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv51 := &x.AccessModes
		yym52 := z.DecBinary()
		_ = yym52
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv51), d)
		}
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ClaimRef != nil {
			x.ClaimRef = nil
		}
	} else {
		if x.ClaimRef == nil {
			x.ClaimRef = new(ObjectReference)
		}
		x.ClaimRef.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PersistentVolumeReclaimPolicy = ""
	} else {
		yyv54 := &x.PersistentVolumeReclaimPolicy
		yyv54.CodecDecodeSelf(d)
	}
	yyj30++
	if yyhl30 {
		yyb30 = yyj30 > l
	} else {
		yyb30 = r.CheckBreak()
	}
	if yyb30 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StorageClassName = ""
	} else {
		yyv55 := &x.StorageClassName
		yym56 := z.DecBinary()
		_ = yym56
		if false {
		} else {
			*((*string)(yyv55)) = r.DecodeString()
		}
	}
	for {
		yyj30++
		if yyhl30 {
			yyb30 = yyj30 > l
		} else {
			yyb30 = r.CheckBreak()
		}
		if yyb30 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj30-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeReclaimPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeReclaimPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PersistentVolumeStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Phase != ""
			yyq2[1] = x.Message != ""
			yyq2[2] = x.Reason != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				yyv4 := &x.Phase
				yyv4.CodecDecodeSelf(d)
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				yyv5 := &x.Message
				yym6 := z.DecBinary()
				_ = yym6
				if false {
				} else {
					*((*string)(yyv5)) = r.DecodeString()
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				yyv7 := &x.Reason
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else {
					*((*string)(yyv7)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj9 int
	var yyb9 bool
	var yyhl9 bool = l >= 0
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		yyv10 := &x.Phase
		yyv10.CodecDecodeSelf(d)
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		yyv11 := &x.Message
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		yyv13 := &x.Reason
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	for {
		yyj9++
		if yyhl9 {
			yyb9 = yyj9 > l
		} else {
			yyb9 = r.CheckBreak()
		}
		if yyb9 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj9-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ListMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ListMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSlicePersistentVolume(([]PersistentVolume)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_v1.ListMeta{}
			} else {
				yyv8 := &x.ListMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv10 := &x.Items
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					h.decSlicePersistentVolume((*[]PersistentVolume)(yyv10), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_v1.ListMeta{}
	} else {
		yyv17 := &x.ListMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv19 := &x.Items
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			h.decSlicePersistentVolume((*[]PersistentVolume)(yyv19), d)
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaim) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.Spec
					yy15.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Spec
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy20 := &x.Status
					yy20.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy22 := &x.Status
					yy22.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaim) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv8 := &x.ObjectMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PersistentVolumeClaimSpec{}
			} else {
				yyv10 := &x.Spec
				yyv10.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PersistentVolumeClaimStatus{}
			} else {
				yyv11 := &x.Status
				yyv11.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaim) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv17 := &x.ObjectMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PersistentVolumeClaimSpec{}
	} else {
		yyv19 := &x.Spec
		yyv19.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PersistentVolumeClaimStatus{}
	} else {
		yyv20 := &x.Status
		yyv20.CodecDecodeSelf(d)
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ListMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ListMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSlicePersistentVolumeClaim(([]PersistentVolumeClaim)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_v1.ListMeta{}
			} else {
				yyv8 := &x.ListMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv10 := &x.Items
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv10), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_v1.ListMeta{}
	} else {
		yyv17 := &x.ListMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv19 := &x.Items
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			h.decSlicePersistentVolumeClaim((*[]PersistentVolumeClaim)(yyv19), d)
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.AccessModes) != 0
			yyq2[1] = x.Selector != nil
			yyq2[2] = true
			yyq2[3] = x.VolumeName != ""
			yyq2[4] = x.StorageClassName != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else if z.HasExtensions() && z.EncExt(x.Selector) {
						} else {
							z.EncFallback(x.Selector)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.Resources
					yy10.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.Resources
					yy12.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.StorageClassName == nil {
						r.EncodeNil()
					} else {
						yy18 := *x.StorageClassName
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy18))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("storageClassName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StorageClassName == nil {
						r.EncodeNil()
					} else {
						yy20 := *x.StorageClassName
						yym21 := z.EncBinary()
						_ = yym21
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy20))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv4 := &x.AccessModes
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv4), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				if x.Selector != nil {
					x.Selector = nil
				}
			} else {
				if x.Selector == nil {
					x.Selector = new(pkg2_v1.LabelSelector)
				}
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else if z.HasExtensions() && z.DecExt(x.Selector) {
				} else {
					z.DecFallback(x.Selector, false)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv8 := &x.Resources
				yyv8.CodecDecodeSelf(d)
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				yyv9 := &x.VolumeName
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else {
					*((*string)(yyv9)) = r.DecodeString()
				}
			}
		case "storageClassName":
			if r.TryDecodeAsNil() {
				if x.StorageClassName != nil {
					x.StorageClassName = nil
				}
			} else {
				if x.StorageClassName == nil {
					x.StorageClassName = new(string)
				}
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*string)(x.StorageClassName)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv14 := &x.AccessModes
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv14), d)
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Selector != nil {
			x.Selector = nil
		}
	} else {
		if x.Selector == nil {
			x.Selector = new(pkg2_v1.LabelSelector)
		}
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else if z.HasExtensions() && z.DecExt(x.Selector) {
		} else {
			z.DecFallback(x.Selector, false)
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv18 := &x.Resources
		yyv18.CodecDecodeSelf(d)
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		yyv19 := &x.VolumeName
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(yyv19)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StorageClassName != nil {
			x.StorageClassName = nil
		}
	} else {
		if x.StorageClassName == nil {
			x.StorageClassName = new(string)
		}
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*string)(x.StorageClassName)) = r.DecodeString()
		}
	}
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = r.CheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj13-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PersistentVolumeClaimStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Phase != ""
			yyq2[1] = len(x.AccessModes) != 0
			yyq2[2] = len(x.Capacity) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("accessModes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AccessModes == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSlicePersistentVolumeAccessMode(([]PersistentVolumeAccessMode)(x.AccessModes), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("capacity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Capacity == nil {
						r.EncodeNil()
					} else {
						x.Capacity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PersistentVolumeClaimStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				yyv4 := &x.Phase
				yyv4.CodecDecodeSelf(d)
			}
		case "accessModes":
			if r.TryDecodeAsNil() {
				x.AccessModes = nil
			} else {
				yyv5 := &x.AccessModes
				yym6 := z.DecBinary()
				_ = yym6
				if false {
				} else {
					h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv5), d)
				}
			}
		case "capacity":
			if r.TryDecodeAsNil() {
				x.Capacity = nil
			} else {
				yyv7 := &x.Capacity
				yyv7.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PersistentVolumeClaimStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		yyv9 := &x.Phase
		yyv9.CodecDecodeSelf(d)
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AccessModes = nil
	} else {
		yyv10 := &x.AccessModes
		yym11 := z.DecBinary()
		_ = yym11
		if false {
		} else {
			h.decSlicePersistentVolumeAccessMode((*[]PersistentVolumeAccessMode)(yyv10), d)
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Capacity = nil
	} else {
		yyv12 := &x.Capacity
		yyv12.CodecDecodeSelf(d)
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PersistentVolumeAccessMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeAccessMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumePhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumePhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PersistentVolumeClaimPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PersistentVolumeClaimPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *HostPathVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HostPathVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HostPathVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				yyv4 := &x.Path
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HostPathVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		yyv7 := &x.Path
		yym8 := z.DecBinary()
		_ = yym8
		if false {
		} else {
			*((*string)(yyv7)) = r.DecodeString()
		}
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EmptyDirVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Medium != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					x.Medium.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("medium"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Medium.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EmptyDirVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "medium":
			if r.TryDecodeAsNil() {
				x.Medium = ""
			} else {
				yyv4 := &x.Medium
				yyv4.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EmptyDirVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = r.CheckBreak()
	}
	if yyb5 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Medium = ""
	} else {
		yyv6 := &x.Medium
		yyv6.CodecDecodeSelf(d)
	}
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = r.CheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj5-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GlusterfsVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("endpoints"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.EndpointsName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GlusterfsVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "endpoints":
			if r.TryDecodeAsNil() {
				x.EndpointsName = ""
			} else {
				yyv4 := &x.EndpointsName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				yyv6 := &x.Path
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv8 := &x.ReadOnly
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(yyv8)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GlusterfsVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EndpointsName = ""
	} else {
		yyv11 := &x.EndpointsName
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		yyv13 := &x.Path
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv15 := &x.ReadOnly
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(yyv15)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *RBDVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [8]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.FSType != ""
			yyq2[3] = x.RBDPool != ""
			yyq2[4] = x.RadosUser != ""
			yyq2[5] = x.Keyring != ""
			yyq2[6] = x.SecretRef != nil
			yyq2[7] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(8)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.CephMonitors == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						z.F.EncSliceStringV(x.CephMonitors, false, e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.RBDImage))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("pool"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RBDPool))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.RadosUser))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("keyring"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Keyring))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *RBDVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *RBDVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.CephMonitors = nil
			} else {
				yyv4 := &x.CephMonitors
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					z.F.DecSliceStringX(yyv4, false, d)
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.RBDImage = ""
			} else {
				yyv6 := &x.RBDImage
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv8 := &x.FSType
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "pool":
			if r.TryDecodeAsNil() {
				x.RBDPool = ""
			} else {
				yyv10 := &x.RBDPool
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.RadosUser = ""
			} else {
				yyv12 := &x.RadosUser
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		case "keyring":
			if r.TryDecodeAsNil() {
				x.Keyring = ""
			} else {
				yyv14 := &x.Keyring
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					*((*string)(yyv14)) = r.DecodeString()
				}
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv17 := &x.ReadOnly
				yym18 := z.DecBinary()
				_ = yym18
				if false {
				} else {
					*((*bool)(yyv17)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *RBDVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj19 int
	var yyb19 bool
	var yyhl19 bool = l >= 0
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.CephMonitors = nil
	} else {
		yyv20 := &x.CephMonitors
		yym21 := z.DecBinary()
		_ = yym21
		if false {
		} else {
			z.F.DecSliceStringX(yyv20, false, d)
		}
	}
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDImage = ""
	} else {
		yyv22 := &x.RBDImage
		yym23 := z.DecBinary()
		_ = yym23
		if false {
		} else {
			*((*string)(yyv22)) = r.DecodeString()
		}
	}
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv24 := &x.FSType
		yym25 := z.DecBinary()
		_ = yym25
		if false {
		} else {
			*((*string)(yyv24)) = r.DecodeString()
		}
	}
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RBDPool = ""
	} else {
		yyv26 := &x.RBDPool
		yym27 := z.DecBinary()
		_ = yym27
		if false {
		} else {
			*((*string)(yyv26)) = r.DecodeString()
		}
	}
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RadosUser = ""
	} else {
		yyv28 := &x.RadosUser
		yym29 := z.DecBinary()
		_ = yym29
		if false {
		} else {
			*((*string)(yyv28)) = r.DecodeString()
		}
	}
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Keyring = ""
	} else {
		yyv30 := &x.Keyring
		yym31 := z.DecBinary()
		_ = yym31
		if false {
		} else {
			*((*string)(yyv30)) = r.DecodeString()
		}
	}
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj19++
	if yyhl19 {
		yyb19 = yyj19 > l
	} else {
		yyb19 = r.CheckBreak()
	}
	if yyb19 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv33 := &x.ReadOnly
		yym34 := z.DecBinary()
		_ = yym34
		if false {
		} else {
			*((*bool)(yyv33)) = r.DecodeBool()
		}
	}
	for {
		yyj19++
		if yyhl19 {
			yyb19 = yyj19 > l
		} else {
			yyb19 = r.CheckBreak()
		}
		if yyb19 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj19-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CinderVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FSType != ""
			yyq2[2] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CinderVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CinderVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				yyv4 := &x.VolumeID
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv6 := &x.FSType
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv8 := &x.ReadOnly
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(yyv8)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CinderVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		yyv11 := &x.VolumeID
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv13 := &x.FSType
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv15 := &x.ReadOnly
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(yyv15)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *CephFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [6]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.Path != ""
			yyq2[2] = x.User != ""
			yyq2[3] = x.SecretFile != ""
			yyq2[4] = x.SecretRef != nil
			yyq2[5] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(6)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("monitors"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Monitors == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						z.F.EncSliceStringV(x.Monitors, false, e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretFile"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretFile))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *CephFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *CephFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "monitors":
			if r.TryDecodeAsNil() {
				x.Monitors = nil
			} else {
				yyv4 := &x.Monitors
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					z.F.DecSliceStringX(yyv4, false, d)
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				yyv6 := &x.Path
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				yyv8 := &x.User
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "secretFile":
			if r.TryDecodeAsNil() {
				x.SecretFile = ""
			} else {
				yyv10 := &x.SecretFile
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv13 := &x.ReadOnly
				yym14 := z.DecBinary()
				_ = yym14
				if false {
				} else {
					*((*bool)(yyv13)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *CephFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj15 int
	var yyb15 bool
	var yyhl15 bool = l >= 0
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Monitors = nil
	} else {
		yyv16 := &x.Monitors
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else {
			z.F.DecSliceStringX(yyv16, false, d)
		}
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		yyv18 := &x.Path
		yym19 := z.DecBinary()
		_ = yym19
		if false {
		} else {
			*((*string)(yyv18)) = r.DecodeString()
		}
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		yyv20 := &x.User
		yym21 := z.DecBinary()
		_ = yym21
		if false {
		} else {
			*((*string)(yyv20)) = r.DecodeString()
		}
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretFile = ""
	} else {
		yyv22 := &x.SecretFile
		yym23 := z.DecBinary()
		_ = yym23
		if false {
		} else {
			*((*string)(yyv22)) = r.DecodeString()
		}
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj15++
	if yyhl15 {
		yyb15 = yyj15 > l
	} else {
		yyb15 = r.CheckBreak()
	}
	if yyb15 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv25 := &x.ReadOnly
		yym26 := z.DecBinary()
		_ = yym26
		if false {
		} else {
			*((*bool)(yyv25)) = r.DecodeBool()
		}
	}
	for {
		yyj15++
		if yyhl15 {
			yyb15 = yyj15 > l
		} else {
			yyb15 = r.CheckBreak()
		}
		if yyb15 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj15-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlockerVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.DatasetName != ""
			yyq2[1] = x.DatasetUUID != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("datasetName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetUUID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("datasetUUID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DatasetUUID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlockerVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlockerVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "datasetName":
			if r.TryDecodeAsNil() {
				x.DatasetName = ""
			} else {
				yyv4 := &x.DatasetName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "datasetUUID":
			if r.TryDecodeAsNil() {
				x.DatasetUUID = ""
			} else {
				yyv6 := &x.DatasetUUID
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlockerVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetName = ""
	} else {
		yyv9 := &x.DatasetName
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DatasetUUID = ""
	} else {
		yyv11 := &x.DatasetUUID
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x StorageMedium) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *StorageMedium) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Protocol) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Protocol) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FSType != ""
			yyq2[2] = x.Partition != 0
			yyq2[3] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PDName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "pdName":
			if r.TryDecodeAsNil() {
				x.PDName = ""
			} else {
				yyv4 := &x.PDName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv6 := &x.FSType
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				yyv8 := &x.Partition
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(yyv8)) = int32(r.DecodeInt(32))
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv10 := &x.ReadOnly
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*bool)(yyv10)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GCEPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PDName = ""
	} else {
		yyv13 := &x.PDName
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv15 := &x.FSType
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		yyv17 := &x.Partition
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*int32)(yyv17)) = int32(r.DecodeInt(32))
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv19 := &x.ReadOnly
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*bool)(yyv19)) = r.DecodeBool()
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *QuobyteVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.ReadOnly != false
			yyq2[3] = x.User != ""
			yyq2[4] = x.Group != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("registry"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Registry))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volume"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Volume))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("user"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.User))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("group"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Group))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *QuobyteVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "registry":
			if r.TryDecodeAsNil() {
				x.Registry = ""
			} else {
				yyv4 := &x.Registry
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "volume":
			if r.TryDecodeAsNil() {
				x.Volume = ""
			} else {
				yyv6 := &x.Volume
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv8 := &x.ReadOnly
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(yyv8)) = r.DecodeBool()
				}
			}
		case "user":
			if r.TryDecodeAsNil() {
				x.User = ""
			} else {
				yyv10 := &x.User
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "group":
			if r.TryDecodeAsNil() {
				x.Group = ""
			} else {
				yyv12 := &x.Group
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *QuobyteVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj14 int
	var yyb14 bool
	var yyhl14 bool = l >= 0
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Registry = ""
	} else {
		yyv15 := &x.Registry
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volume = ""
	} else {
		yyv17 := &x.Volume
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*string)(yyv17)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv19 := &x.ReadOnly
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*bool)(yyv19)) = r.DecodeBool()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.User = ""
	} else {
		yyv21 := &x.User
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*string)(yyv21)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Group = ""
	} else {
		yyv23 := &x.Group
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			*((*string)(yyv23)) = r.DecodeString()
		}
	}
	for {
		yyj14++
		if yyhl14 {
			yyb14 = yyj14 > l
		} else {
			yyb14 = r.CheckBreak()
		}
		if yyb14 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj14-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FlexVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FSType != ""
			yyq2[2] = x.SecretRef != nil
			yyq2[3] = x.ReadOnly != false
			yyq2[4] = len(x.Options) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("driver"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Driver))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("options"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Options == nil {
						r.EncodeNil()
					} else {
						yym17 := z.EncBinary()
						_ = yym17
						if false {
						} else {
							z.F.EncMapStringStringV(x.Options, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FlexVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FlexVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "driver":
			if r.TryDecodeAsNil() {
				x.Driver = ""
			} else {
				yyv4 := &x.Driver
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv6 := &x.FSType
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv9 := &x.ReadOnly
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else {
					*((*bool)(yyv9)) = r.DecodeBool()
				}
			}
		case "options":
			if r.TryDecodeAsNil() {
				x.Options = nil
			} else {
				yyv11 := &x.Options
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					z.F.DecMapStringStringX(yyv11, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FlexVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Driver = ""
	} else {
		yyv14 := &x.Driver
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv16 := &x.FSType
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else {
			*((*string)(yyv16)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv19 := &x.ReadOnly
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*bool)(yyv19)) = r.DecodeBool()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Options = nil
	} else {
		yyv21 := &x.Options
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			z.F.DecMapStringStringX(yyv21, false, d)
		}
	}
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = r.CheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj13-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FSType != ""
			yyq2[2] = x.Partition != 0
			yyq2[3] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("partition"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeInt(int64(x.Partition))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				yyv4 := &x.VolumeID
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv6 := &x.FSType
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "partition":
			if r.TryDecodeAsNil() {
				x.Partition = 0
			} else {
				yyv8 := &x.Partition
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(yyv8)) = int32(r.DecodeInt(32))
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv10 := &x.ReadOnly
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*bool)(yyv10)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AWSElasticBlockStoreVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		yyv13 := &x.VolumeID
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv15 := &x.FSType
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Partition = 0
	} else {
		yyv17 := &x.Partition
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*int32)(yyv17)) = int32(r.DecodeInt(32))
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv19 := &x.ReadOnly
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*bool)(yyv19)) = r.DecodeBool()
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *GitRepoVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.Revision != ""
			yyq2[2] = x.Directory != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("repository"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Repository))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("revision"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Revision))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("directory"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Directory))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *GitRepoVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "repository":
			if r.TryDecodeAsNil() {
				x.Repository = ""
			} else {
				yyv4 := &x.Repository
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "revision":
			if r.TryDecodeAsNil() {
				x.Revision = ""
			} else {
				yyv6 := &x.Revision
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "directory":
			if r.TryDecodeAsNil() {
				x.Directory = ""
			} else {
				yyv8 := &x.Directory
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *GitRepoVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Repository = ""
	} else {
		yyv11 := &x.Repository
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Revision = ""
	} else {
		yyv13 := &x.Revision
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Directory = ""
	} else {
		yyv15 := &x.Directory
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.SecretName != ""
			yyq2[1] = len(x.Items) != 0
			yyq2[2] = x.DefaultMode != nil
			yyq2[3] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.DefaultMode
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							r.EncodeInt(int64(yy10))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.DefaultMode
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeInt(int64(yy12))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy15 := *x.Optional
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							r.EncodeBool(bool(yy15))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy17 := *x.Optional
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							r.EncodeBool(bool(yy17))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				yyv4 := &x.SecretName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv6 := &x.Items
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv6), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		yyv13 := &x.SecretName
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv15 := &x.Items
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv15), d)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretProjection) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = len(x.Items) != 0
			yyq2[2] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.Optional
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							r.EncodeBool(bool(yy10))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.Optional
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeBool(bool(yy12))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretProjection) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretProjection) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv6 := &x.Items
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv6), d)
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretProjection) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv11 := &x.Name
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv13 := &x.Items
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv13), d)
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NFSVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("server"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Server))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NFSVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NFSVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "server":
			if r.TryDecodeAsNil() {
				x.Server = ""
			} else {
				yyv4 := &x.Server
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				yyv6 := &x.Path
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv8 := &x.ReadOnly
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(yyv8)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NFSVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Server = ""
	} else {
		yyv11 := &x.Server
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		yyv13 := &x.Path
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv15 := &x.ReadOnly
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(yyv15)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ISCSIVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [7]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[3] = x.ISCSIInterface != ""
			yyq2[4] = x.FSType != ""
			yyq2[5] = x.ReadOnly != false
			yyq2[6] = len(x.Portals) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(7)
			} else {
				yynn2 = 3
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetPortal"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.TargetPortal))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("iqn"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.IQN))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeInt(int64(x.Lun))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("iscsiInterface"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ISCSIInterface))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					if x.Portals == nil {
						r.EncodeNil()
					} else {
						yym22 := z.EncBinary()
						_ = yym22
						if false {
						} else {
							z.F.EncSliceStringV(x.Portals, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("portals"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Portals == nil {
						r.EncodeNil()
					} else {
						yym23 := z.EncBinary()
						_ = yym23
						if false {
						} else {
							z.F.EncSliceStringV(x.Portals, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ISCSIVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "targetPortal":
			if r.TryDecodeAsNil() {
				x.TargetPortal = ""
			} else {
				yyv4 := &x.TargetPortal
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "iqn":
			if r.TryDecodeAsNil() {
				x.IQN = ""
			} else {
				yyv6 := &x.IQN
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				x.Lun = 0
			} else {
				yyv8 := &x.Lun
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(yyv8)) = int32(r.DecodeInt(32))
				}
			}
		case "iscsiInterface":
			if r.TryDecodeAsNil() {
				x.ISCSIInterface = ""
			} else {
				yyv10 := &x.ISCSIInterface
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv12 := &x.FSType
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv14 := &x.ReadOnly
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					*((*bool)(yyv14)) = r.DecodeBool()
				}
			}
		case "portals":
			if r.TryDecodeAsNil() {
				x.Portals = nil
			} else {
				yyv16 := &x.Portals
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else {
					z.F.DecSliceStringX(yyv16, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ISCSIVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj18 int
	var yyb18 bool
	var yyhl18 bool = l >= 0
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPortal = ""
	} else {
		yyv19 := &x.TargetPortal
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(yyv19)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IQN = ""
	} else {
		yyv21 := &x.IQN
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*string)(yyv21)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Lun = 0
	} else {
		yyv23 := &x.Lun
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			*((*int32)(yyv23)) = int32(r.DecodeInt(32))
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ISCSIInterface = ""
	} else {
		yyv25 := &x.ISCSIInterface
		yym26 := z.DecBinary()
		_ = yym26
		if false {
		} else {
			*((*string)(yyv25)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv27 := &x.FSType
		yym28 := z.DecBinary()
		_ = yym28
		if false {
		} else {
			*((*string)(yyv27)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv29 := &x.ReadOnly
		yym30 := z.DecBinary()
		_ = yym30
		if false {
		} else {
			*((*bool)(yyv29)) = r.DecodeBool()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Portals = nil
	} else {
		yyv31 := &x.Portals
		yym32 := z.DecBinary()
		_ = yym32
		if false {
		} else {
			z.F.DecSliceStringX(yyv31, false, d)
		}
	}
	for {
		yyj18++
		if yyhl18 {
			yyb18 = yyj18 > l
		} else {
			yyb18 = r.CheckBreak()
		}
		if yyb18 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj18-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *FCVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.FSType != ""
			yyq2[3] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("targetWWNs"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.TargetWWNs == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						z.F.EncSliceStringV(x.TargetWWNs, false, e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy7 := *x.Lun
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeInt(int64(yy7))
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("lun"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Lun == nil {
					r.EncodeNil()
				} else {
					yy9 := *x.Lun
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeInt(int64(yy9))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym12 := z.EncBinary()
					_ = yym12
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *FCVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *FCVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "targetWWNs":
			if r.TryDecodeAsNil() {
				x.TargetWWNs = nil
			} else {
				yyv4 := &x.TargetWWNs
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					z.F.DecSliceStringX(yyv4, false, d)
				}
			}
		case "lun":
			if r.TryDecodeAsNil() {
				if x.Lun != nil {
					x.Lun = nil
				}
			} else {
				if x.Lun == nil {
					x.Lun = new(int32)
				}
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv8 := &x.FSType
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv10 := &x.ReadOnly
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*bool)(yyv10)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *FCVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetWWNs = nil
	} else {
		yyv13 := &x.TargetWWNs
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			z.F.DecSliceStringX(yyv13, false, d)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lun != nil {
			x.Lun = nil
		}
	} else {
		if x.Lun == nil {
			x.Lun = new(int32)
		}
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*int32)(x.Lun)) = int32(r.DecodeInt(32))
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv17 := &x.FSType
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*string)(yyv17)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv19 := &x.ReadOnly
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*bool)(yyv19)) = r.DecodeBool()
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *AzureFileVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.SecretName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("shareName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ShareName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureFileVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "secretName":
			if r.TryDecodeAsNil() {
				x.SecretName = ""
			} else {
				yyv4 := &x.SecretName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "shareName":
			if r.TryDecodeAsNil() {
				x.ShareName = ""
			} else {
				yyv6 := &x.ShareName
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv8 := &x.ReadOnly
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(yyv8)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureFileVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SecretName = ""
	} else {
		yyv11 := &x.SecretName
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ShareName = ""
	} else {
		yyv13 := &x.ShareName
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv15 := &x.ReadOnly
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(yyv15)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FSType != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumePath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumePath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "volumePath":
			if r.TryDecodeAsNil() {
				x.VolumePath = ""
			} else {
				yyv4 := &x.VolumePath
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv6 := &x.FSType
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VsphereVirtualDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumePath = ""
	} else {
		yyv9 := &x.VolumePath
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv11 := &x.FSType
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PhotonPersistentDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FSType != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PdID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("pdID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.PdID))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PhotonPersistentDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PhotonPersistentDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "pdID":
			if r.TryDecodeAsNil() {
				x.PdID = ""
			} else {
				yyv4 := &x.PdID
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv6 := &x.FSType
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PhotonPersistentDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PdID = ""
	} else {
		yyv9 := &x.PdID
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv11 := &x.FSType
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x AzureDataDiskCachingMode) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *AzureDataDiskCachingMode) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *AzureDiskVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.CachingMode != nil
			yyq2[3] = x.FSType != nil
			yyq2[4] = x.ReadOnly != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskName"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DiskName))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("diskURI"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.DataDiskURI))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.CachingMode
						yy10.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("cachingMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.CachingMode == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.CachingMode
						yy12.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy15 := *x.FSType
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy15))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSType == nil {
						r.EncodeNil()
					} else {
						yy17 := *x.FSType
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							r.EncodeString(codecSelferC_UTF81234, string(yy17))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy20 := *x.ReadOnly
						yym21 := z.EncBinary()
						_ = yym21
						if false {
						} else {
							r.EncodeBool(bool(yy20))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadOnly == nil {
						r.EncodeNil()
					} else {
						yy22 := *x.ReadOnly
						yym23 := z.EncBinary()
						_ = yym23
						if false {
						} else {
							r.EncodeBool(bool(yy22))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *AzureDiskVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "diskName":
			if r.TryDecodeAsNil() {
				x.DiskName = ""
			} else {
				yyv4 := &x.DiskName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "diskURI":
			if r.TryDecodeAsNil() {
				x.DataDiskURI = ""
			} else {
				yyv6 := &x.DataDiskURI
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "cachingMode":
			if r.TryDecodeAsNil() {
				if x.CachingMode != nil {
					x.CachingMode = nil
				}
			} else {
				if x.CachingMode == nil {
					x.CachingMode = new(AzureDataDiskCachingMode)
				}
				x.CachingMode.CodecDecodeSelf(d)
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				if x.FSType != nil {
					x.FSType = nil
				}
			} else {
				if x.FSType == nil {
					x.FSType = new(string)
				}
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else {
					*((*string)(x.FSType)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				if x.ReadOnly != nil {
					x.ReadOnly = nil
				}
			} else {
				if x.ReadOnly == nil {
					x.ReadOnly = new(bool)
				}
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*bool)(x.ReadOnly)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *AzureDiskVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DiskName = ""
	} else {
		yyv14 := &x.DiskName
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DataDiskURI = ""
	} else {
		yyv16 := &x.DataDiskURI
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else {
			*((*string)(yyv16)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.CachingMode != nil {
			x.CachingMode = nil
		}
	} else {
		if x.CachingMode == nil {
			x.CachingMode = new(AzureDataDiskCachingMode)
		}
		x.CachingMode.CodecDecodeSelf(d)
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSType != nil {
			x.FSType = nil
		}
	} else {
		if x.FSType == nil {
			x.FSType = new(string)
		}
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(x.FSType)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadOnly != nil {
			x.ReadOnly = nil
		}
	} else {
		if x.ReadOnly == nil {
			x.ReadOnly = new(bool)
		}
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*bool)(x.ReadOnly)) = r.DecodeBool()
		}
	}
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = r.CheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj13-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PortworxVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FSType != ""
			yyq2[2] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("volumeID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.VolumeID))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PortworxVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PortworxVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "volumeID":
			if r.TryDecodeAsNil() {
				x.VolumeID = ""
			} else {
				yyv4 := &x.VolumeID
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv6 := &x.FSType
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv8 := &x.ReadOnly
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(yyv8)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PortworxVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeID = ""
	} else {
		yyv11 := &x.VolumeID
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv13 := &x.FSType
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv15 := &x.ReadOnly
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(yyv15)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ScaleIOVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [10]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[3] = x.SSLEnabled != false
			yyq2[4] = x.ProtectionDomain != ""
			yyq2[5] = x.StoragePool != ""
			yyq2[6] = x.StorageMode != ""
			yyq2[7] = x.VolumeName != ""
			yyq2[8] = x.FSType != ""
			yyq2[9] = x.ReadOnly != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(10)
			} else {
				yynn2 = 3
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Gateway))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("gateway"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Gateway))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.System))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("system"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.System))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.SecretRef == nil {
					r.EncodeNil()
				} else {
					x.SecretRef.CodecEncodeSelf(e)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.SecretRef == nil {
					r.EncodeNil()
				} else {
					x.SecretRef.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeBool(bool(x.SSLEnabled))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sslEnabled"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeBool(bool(x.SSLEnabled))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProtectionDomain))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protectionDomain"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ProtectionDomain))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.StoragePool))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("storagePool"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.StoragePool))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.StorageMode))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("storageMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.StorageMode))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.VolumeName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yym28 := z.EncBinary()
					_ = yym28
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsType"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.FSType))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yym31 := z.EncBinary()
					_ = yym31
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ScaleIOVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ScaleIOVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "gateway":
			if r.TryDecodeAsNil() {
				x.Gateway = ""
			} else {
				yyv4 := &x.Gateway
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "system":
			if r.TryDecodeAsNil() {
				x.System = ""
			} else {
				yyv6 := &x.System
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(LocalObjectReference)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		case "sslEnabled":
			if r.TryDecodeAsNil() {
				x.SSLEnabled = false
			} else {
				yyv9 := &x.SSLEnabled
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else {
					*((*bool)(yyv9)) = r.DecodeBool()
				}
			}
		case "protectionDomain":
			if r.TryDecodeAsNil() {
				x.ProtectionDomain = ""
			} else {
				yyv11 := &x.ProtectionDomain
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*string)(yyv11)) = r.DecodeString()
				}
			}
		case "storagePool":
			if r.TryDecodeAsNil() {
				x.StoragePool = ""
			} else {
				yyv13 := &x.StoragePool
				yym14 := z.DecBinary()
				_ = yym14
				if false {
				} else {
					*((*string)(yyv13)) = r.DecodeString()
				}
			}
		case "storageMode":
			if r.TryDecodeAsNil() {
				x.StorageMode = ""
			} else {
				yyv15 := &x.StorageMode
				yym16 := z.DecBinary()
				_ = yym16
				if false {
				} else {
					*((*string)(yyv15)) = r.DecodeString()
				}
			}
		case "volumeName":
			if r.TryDecodeAsNil() {
				x.VolumeName = ""
			} else {
				yyv17 := &x.VolumeName
				yym18 := z.DecBinary()
				_ = yym18
				if false {
				} else {
					*((*string)(yyv17)) = r.DecodeString()
				}
			}
		case "fsType":
			if r.TryDecodeAsNil() {
				x.FSType = ""
			} else {
				yyv19 := &x.FSType
				yym20 := z.DecBinary()
				_ = yym20
				if false {
				} else {
					*((*string)(yyv19)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv21 := &x.ReadOnly
				yym22 := z.DecBinary()
				_ = yym22
				if false {
				} else {
					*((*bool)(yyv21)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ScaleIOVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj23 int
	var yyb23 bool
	var yyhl23 bool = l >= 0
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Gateway = ""
	} else {
		yyv24 := &x.Gateway
		yym25 := z.DecBinary()
		_ = yym25
		if false {
		} else {
			*((*string)(yyv24)) = r.DecodeString()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.System = ""
	} else {
		yyv26 := &x.System
		yym27 := z.DecBinary()
		_ = yym27
		if false {
		} else {
			*((*string)(yyv26)) = r.DecodeString()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(LocalObjectReference)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SSLEnabled = false
	} else {
		yyv29 := &x.SSLEnabled
		yym30 := z.DecBinary()
		_ = yym30
		if false {
		} else {
			*((*bool)(yyv29)) = r.DecodeBool()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ProtectionDomain = ""
	} else {
		yyv31 := &x.ProtectionDomain
		yym32 := z.DecBinary()
		_ = yym32
		if false {
		} else {
			*((*string)(yyv31)) = r.DecodeString()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StoragePool = ""
	} else {
		yyv33 := &x.StoragePool
		yym34 := z.DecBinary()
		_ = yym34
		if false {
		} else {
			*((*string)(yyv33)) = r.DecodeString()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StorageMode = ""
	} else {
		yyv35 := &x.StorageMode
		yym36 := z.DecBinary()
		_ = yym36
		if false {
		} else {
			*((*string)(yyv35)) = r.DecodeString()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeName = ""
	} else {
		yyv37 := &x.VolumeName
		yym38 := z.DecBinary()
		_ = yym38
		if false {
		} else {
			*((*string)(yyv37)) = r.DecodeString()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FSType = ""
	} else {
		yyv39 := &x.FSType
		yym40 := z.DecBinary()
		_ = yym40
		if false {
		} else {
			*((*string)(yyv39)) = r.DecodeString()
		}
	}
	yyj23++
	if yyhl23 {
		yyb23 = yyj23 > l
	} else {
		yyb23 = r.CheckBreak()
	}
	if yyb23 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv41 := &x.ReadOnly
		yym42 := z.DecBinary()
		_ = yym42
		if false {
		} else {
			*((*bool)(yyv41)) = r.DecodeBool()
		}
	}
	for {
		yyj23++
		if yyhl23 {
			yyb23 = yyj23 > l
		} else {
			yyb23 = r.CheckBreak()
		}
		if yyb23 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj23-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = len(x.Items) != 0
			yyq2[2] = x.DefaultMode != nil
			yyq2[3] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.DefaultMode
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							r.EncodeInt(int64(yy10))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.DefaultMode
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeInt(int64(yy12))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy15 := *x.Optional
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							r.EncodeBool(bool(yy15))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy17 := *x.Optional
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							r.EncodeBool(bool(yy17))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv6 := &x.Items
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv6), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv13 := &x.Name
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv15 := &x.Items
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv15), d)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapProjection) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = len(x.Items) != 0
			yyq2[2] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("items"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Items == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceKeyToPath(([]KeyToPath)(x.Items), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.Optional
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							r.EncodeBool(bool(yy10))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.Optional
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeBool(bool(yy12))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapProjection) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapProjection) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv6 := &x.Items
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceKeyToPath((*[]KeyToPath)(yyv6), d)
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapProjection) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv11 := &x.Name
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv13 := &x.Items
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			h.decSliceKeyToPath((*[]KeyToPath)(yyv13), d)
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ProjectedVolumeSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.DefaultMode != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Sources == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						h.encSliceVolumeProjection(([]VolumeProjection)(x.Sources), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("sources"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Sources == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						h.encSliceVolumeProjection(([]VolumeProjection)(x.Sources), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy7 := *x.DefaultMode
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							r.EncodeInt(int64(yy7))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("defaultMode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DefaultMode == nil {
						r.EncodeNil()
					} else {
						yy9 := *x.DefaultMode
						yym10 := z.EncBinary()
						_ = yym10
						if false {
						} else {
							r.EncodeInt(int64(yy9))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ProjectedVolumeSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ProjectedVolumeSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "sources":
			if r.TryDecodeAsNil() {
				x.Sources = nil
			} else {
				yyv4 := &x.Sources
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSliceVolumeProjection((*[]VolumeProjection)(yyv4), d)
				}
			}
		case "defaultMode":
			if r.TryDecodeAsNil() {
				if x.DefaultMode != nil {
					x.DefaultMode = nil
				}
			} else {
				if x.DefaultMode == nil {
					x.DefaultMode = new(int32)
				}
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ProjectedVolumeSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Sources = nil
	} else {
		yyv9 := &x.Sources
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			h.decSliceVolumeProjection((*[]VolumeProjection)(yyv9), d)
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DefaultMode != nil {
			x.DefaultMode = nil
		}
	} else {
		if x.DefaultMode == nil {
			x.DefaultMode = new(int32)
		}
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*int32)(x.DefaultMode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeProjection) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Secret != nil
			yyq2[1] = x.DownwardAPI != nil
			yyq2[2] = x.ConfigMap != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secret"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secret == nil {
						r.EncodeNil()
					} else {
						x.Secret.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("downwardAPI"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DownwardAPI == nil {
						r.EncodeNil()
					} else {
						x.DownwardAPI.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMap"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMap == nil {
						r.EncodeNil()
					} else {
						x.ConfigMap.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeProjection) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeProjection) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "secret":
			if r.TryDecodeAsNil() {
				if x.Secret != nil {
					x.Secret = nil
				}
			} else {
				if x.Secret == nil {
					x.Secret = new(SecretProjection)
				}
				x.Secret.CodecDecodeSelf(d)
			}
		case "downwardAPI":
			if r.TryDecodeAsNil() {
				if x.DownwardAPI != nil {
					x.DownwardAPI = nil
				}
			} else {
				if x.DownwardAPI == nil {
					x.DownwardAPI = new(DownwardAPIProjection)
				}
				x.DownwardAPI.CodecDecodeSelf(d)
			}
		case "configMap":
			if r.TryDecodeAsNil() {
				if x.ConfigMap != nil {
					x.ConfigMap = nil
				}
			} else {
				if x.ConfigMap == nil {
					x.ConfigMap = new(ConfigMapProjection)
				}
				x.ConfigMap.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeProjection) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Secret != nil {
			x.Secret = nil
		}
	} else {
		if x.Secret == nil {
			x.Secret = new(SecretProjection)
		}
		x.Secret.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.DownwardAPI != nil {
			x.DownwardAPI = nil
		}
	} else {
		if x.DownwardAPI == nil {
			x.DownwardAPI = new(DownwardAPIProjection)
		}
		x.DownwardAPI.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMap != nil {
			x.ConfigMap = nil
		}
	} else {
		if x.ConfigMap == nil {
			x.ConfigMap = new(ConfigMapProjection)
		}
		x.ConfigMap.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *KeyToPath) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = x.Mode != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("path"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Path))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.Mode
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							r.EncodeInt(int64(yy10))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("mode"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Mode == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.Mode
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeInt(int64(yy12))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *KeyToPath) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *KeyToPath) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				yyv4 := &x.Key
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				yyv6 := &x.Path
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "mode":
			if r.TryDecodeAsNil() {
				if x.Mode != nil {
					x.Mode = nil
				}
			} else {
				if x.Mode == nil {
					x.Mode = new(int32)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *KeyToPath) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		yyv11 := &x.Key
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		yyv13 := &x.Path
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Mode != nil {
			x.Mode = nil
		}
	} else {
		if x.Mode == nil {
			x.Mode = new(int32)
		}
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*int32)(x.Mode)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerPort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.HostPort != 0
			yyq2[3] = x.Protocol != ""
			yyq2[4] = x.HostIP != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeInt(int64(x.HostPort))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containerPort"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeInt(int64(x.ContainerPort))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerPort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerPort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "hostPort":
			if r.TryDecodeAsNil() {
				x.HostPort = 0
			} else {
				yyv6 := &x.HostPort
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*int32)(yyv6)) = int32(r.DecodeInt(32))
				}
			}
		case "containerPort":
			if r.TryDecodeAsNil() {
				x.ContainerPort = 0
			} else {
				yyv8 := &x.ContainerPort
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(yyv8)) = int32(r.DecodeInt(32))
				}
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				yyv10 := &x.Protocol
				yyv10.CodecDecodeSelf(d)
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				yyv11 := &x.HostIP
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*string)(yyv11)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerPort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv14 := &x.Name
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPort = 0
	} else {
		yyv16 := &x.HostPort
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else {
			*((*int32)(yyv16)) = int32(r.DecodeInt(32))
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerPort = 0
	} else {
		yyv18 := &x.ContainerPort
		yym19 := z.DecBinary()
		_ = yym19
		if false {
		} else {
			*((*int32)(yyv18)) = int32(r.DecodeInt(32))
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		yyv20 := &x.Protocol
		yyv20.CodecDecodeSelf(d)
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		yyv21 := &x.HostIP
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*string)(yyv21)) = r.DecodeString()
		}
	}
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = r.CheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj13-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *VolumeMount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.ReadOnly != false
			yyq2[3] = x.SubPath != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readOnly"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeBool(bool(x.ReadOnly))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("mountPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.MountPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subPath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SubPath))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *VolumeMount) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *VolumeMount) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "readOnly":
			if r.TryDecodeAsNil() {
				x.ReadOnly = false
			} else {
				yyv6 := &x.ReadOnly
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*bool)(yyv6)) = r.DecodeBool()
				}
			}
		case "mountPath":
			if r.TryDecodeAsNil() {
				x.MountPath = ""
			} else {
				yyv8 := &x.MountPath
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "subPath":
			if r.TryDecodeAsNil() {
				x.SubPath = ""
			} else {
				yyv10 := &x.SubPath
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *VolumeMount) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv13 := &x.Name
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadOnly = false
	} else {
		yyv15 := &x.ReadOnly
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(yyv15)) = r.DecodeBool()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MountPath = ""
	} else {
		yyv17 := &x.MountPath
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*string)(yyv17)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SubPath = ""
	} else {
		yyv19 := &x.SubPath
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(yyv19)) = r.DecodeString()
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVar) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.Value != ""
			yyq2[2] = x.ValueFrom != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("valueFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ValueFrom == nil {
						r.EncodeNil()
					} else {
						x.ValueFrom.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVar) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVar) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				yyv6 := &x.Value
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "valueFrom":
			if r.TryDecodeAsNil() {
				if x.ValueFrom != nil {
					x.ValueFrom = nil
				}
			} else {
				if x.ValueFrom == nil {
					x.ValueFrom = new(EnvVarSource)
				}
				x.ValueFrom.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVar) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj9 int
	var yyb9 bool
	var yyhl9 bool = l >= 0
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv10 := &x.Name
		yym11 := z.DecBinary()
		_ = yym11
		if false {
		} else {
			*((*string)(yyv10)) = r.DecodeString()
		}
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		yyv12 := &x.Value
		yym13 := z.DecBinary()
		_ = yym13
		if false {
		} else {
			*((*string)(yyv12)) = r.DecodeString()
		}
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ValueFrom != nil {
			x.ValueFrom = nil
		}
	} else {
		if x.ValueFrom == nil {
			x.ValueFrom = new(EnvVarSource)
		}
		x.ValueFrom.CodecDecodeSelf(d)
	}
	for {
		yyj9++
		if yyhl9 {
			yyb9 = yyj9 > l
		} else {
			yyb9 = r.CheckBreak()
		}
		if yyb9 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj9-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvVarSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.FieldRef != nil
			yyq2[1] = x.ResourceFieldRef != nil
			yyq2[2] = x.ConfigMapKeyRef != nil
			yyq2[3] = x.SecretKeyRef != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FieldRef == nil {
						r.EncodeNil()
					} else {
						x.FieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resourceFieldRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ResourceFieldRef == nil {
						r.EncodeNil()
					} else {
						x.ResourceFieldRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMapKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMapKeyRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretKeyRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretKeyRef == nil {
						r.EncodeNil()
					} else {
						x.SecretKeyRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvVarSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvVarSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "fieldRef":
			if r.TryDecodeAsNil() {
				if x.FieldRef != nil {
					x.FieldRef = nil
				}
			} else {
				if x.FieldRef == nil {
					x.FieldRef = new(ObjectFieldSelector)
				}
				x.FieldRef.CodecDecodeSelf(d)
			}
		case "resourceFieldRef":
			if r.TryDecodeAsNil() {
				if x.ResourceFieldRef != nil {
					x.ResourceFieldRef = nil
				}
			} else {
				if x.ResourceFieldRef == nil {
					x.ResourceFieldRef = new(ResourceFieldSelector)
				}
				x.ResourceFieldRef.CodecDecodeSelf(d)
			}
		case "configMapKeyRef":
			if r.TryDecodeAsNil() {
				if x.ConfigMapKeyRef != nil {
					x.ConfigMapKeyRef = nil
				}
			} else {
				if x.ConfigMapKeyRef == nil {
					x.ConfigMapKeyRef = new(ConfigMapKeySelector)
				}
				x.ConfigMapKeyRef.CodecDecodeSelf(d)
			}
		case "secretKeyRef":
			if r.TryDecodeAsNil() {
				if x.SecretKeyRef != nil {
					x.SecretKeyRef = nil
				}
			} else {
				if x.SecretKeyRef == nil {
					x.SecretKeyRef = new(SecretKeySelector)
				}
				x.SecretKeyRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvVarSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FieldRef != nil {
			x.FieldRef = nil
		}
	} else {
		if x.FieldRef == nil {
			x.FieldRef = new(ObjectFieldSelector)
		}
		x.FieldRef.CodecDecodeSelf(d)
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ResourceFieldRef != nil {
			x.ResourceFieldRef = nil
		}
	} else {
		if x.ResourceFieldRef == nil {
			x.ResourceFieldRef = new(ResourceFieldSelector)
		}
		x.ResourceFieldRef.CodecDecodeSelf(d)
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMapKeyRef != nil {
			x.ConfigMapKeyRef = nil
		}
	} else {
		if x.ConfigMapKeyRef == nil {
			x.ConfigMapKeyRef = new(ConfigMapKeySelector)
		}
		x.ConfigMapKeyRef.CodecDecodeSelf(d)
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretKeyRef != nil {
			x.SecretKeyRef = nil
		}
	} else {
		if x.SecretKeyRef == nil {
			x.SecretKeyRef = new(SecretKeySelector)
		}
		x.SecretKeyRef.CodecDecodeSelf(d)
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ObjectFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.APIVersion != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("fieldPath"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.FieldPath))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ObjectFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ObjectFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv4 := &x.APIVersion
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "fieldPath":
			if r.TryDecodeAsNil() {
				x.FieldPath = ""
			} else {
				yyv6 := &x.FieldPath
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ObjectFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv9 := &x.APIVersion
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FieldPath = ""
	} else {
		yyv11 := &x.FieldPath
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceFieldSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.ContainerName != ""
			yyq2[2] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("resource"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Resource))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.Divisor
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else if !yym11 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy10)
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("divisor"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.Divisor
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else if !yym13 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy12)
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceFieldSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceFieldSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "containerName":
			if r.TryDecodeAsNil() {
				x.ContainerName = ""
			} else {
				yyv4 := &x.ContainerName
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "resource":
			if r.TryDecodeAsNil() {
				x.Resource = ""
			} else {
				yyv6 := &x.Resource
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "divisor":
			if r.TryDecodeAsNil() {
				x.Divisor = pkg3_resource.Quantity{}
			} else {
				yyv8 := &x.Divisor
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else if !yym9 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv8)
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceFieldSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerName = ""
	} else {
		yyv11 := &x.ContainerName
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resource = ""
	} else {
		yyv13 := &x.Resource
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Divisor = pkg3_resource.Quantity{}
	} else {
		yyv15 := &x.Divisor
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv15) {
		} else if !yym16 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv15)
		} else {
			z.DecFallback(yyv15, false)
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[2] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.Optional
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							r.EncodeBool(bool(yy10))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.Optional
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeBool(bool(yy12))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				yyv6 := &x.Key
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv11 := &x.Name
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		yyv13 := &x.Key
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretKeySelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[2] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy10 := *x.Optional
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							r.EncodeBool(bool(yy10))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.Optional
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeBool(bool(yy12))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretKeySelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretKeySelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				yyv6 := &x.Key
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretKeySelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv11 := &x.Name
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		yyv13 := &x.Key
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *EnvFromSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Prefix != ""
			yyq2[1] = x.ConfigMapRef != nil
			yyq2[2] = x.SecretRef != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Prefix))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("prefix"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Prefix))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.ConfigMapRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("configMapRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ConfigMapRef == nil {
						r.EncodeNil()
					} else {
						x.ConfigMapRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secretRef"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecretRef == nil {
						r.EncodeNil()
					} else {
						x.SecretRef.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *EnvFromSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *EnvFromSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "prefix":
			if r.TryDecodeAsNil() {
				x.Prefix = ""
			} else {
				yyv4 := &x.Prefix
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "configMapRef":
			if r.TryDecodeAsNil() {
				if x.ConfigMapRef != nil {
					x.ConfigMapRef = nil
				}
			} else {
				if x.ConfigMapRef == nil {
					x.ConfigMapRef = new(ConfigMapEnvSource)
				}
				x.ConfigMapRef.CodecDecodeSelf(d)
			}
		case "secretRef":
			if r.TryDecodeAsNil() {
				if x.SecretRef != nil {
					x.SecretRef = nil
				}
			} else {
				if x.SecretRef == nil {
					x.SecretRef = new(SecretEnvSource)
				}
				x.SecretRef.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *EnvFromSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Prefix = ""
	} else {
		yyv9 := &x.Prefix
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ConfigMapRef != nil {
			x.ConfigMapRef = nil
		}
	} else {
		if x.ConfigMapRef == nil {
			x.ConfigMapRef = new(ConfigMapEnvSource)
		}
		x.ConfigMapRef.CodecDecodeSelf(d)
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecretRef != nil {
			x.SecretRef = nil
		}
	} else {
		if x.SecretRef == nil {
			x.SecretRef = new(SecretEnvSource)
		}
		x.SecretRef.CodecDecodeSelf(d)
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ConfigMapEnvSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy7 := *x.Optional
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							r.EncodeBool(bool(yy7))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy9 := *x.Optional
						yym10 := z.EncBinary()
						_ = yym10
						if false {
						} else {
							r.EncodeBool(bool(yy9))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ConfigMapEnvSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ConfigMapEnvSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ConfigMapEnvSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv9 := &x.Name
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *SecretEnvSource) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.Optional != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy7 := *x.Optional
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							r.EncodeBool(bool(yy7))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("optional"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Optional == nil {
						r.EncodeNil()
					} else {
						yy9 := *x.Optional
						yym10 := z.EncBinary()
						_ = yym10
						if false {
						} else {
							r.EncodeBool(bool(yy9))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *SecretEnvSource) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *SecretEnvSource) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "optional":
			if r.TryDecodeAsNil() {
				if x.Optional != nil {
					x.Optional = nil
				}
			} else {
				if x.Optional == nil {
					x.Optional = new(bool)
				}
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*bool)(x.Optional)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *SecretEnvSource) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv9 := &x.Name
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Optional != nil {
			x.Optional = nil
		}
	} else {
		if x.Optional == nil {
			x.Optional = new(bool)
		}
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*bool)(x.Optional)) = r.DecodeBool()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPHeader) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("value"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Value))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPHeader) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPHeader) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				yyv6 := &x.Value
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPHeader) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv9 := &x.Name
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		yyv11 := &x.Value
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *HTTPGetAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Path != ""
			yyq2[2] = x.Host != ""
			yyq2[3] = x.Scheme != ""
			yyq2[4] = len(x.HTTPHeaders) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("path"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Path))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy7 := &x.Port
				yym8 := z.EncBinary()
				_ = yym8
				if false {
				} else if z.HasExtensions() && z.EncExt(yy7) {
				} else if !yym8 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy7)
				} else {
					z.EncFallback(yy7)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy9 := &x.Port
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else if z.HasExtensions() && z.EncExt(yy9) {
				} else if !yym10 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy9)
				} else {
					z.EncFallback(yy9)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym12 := z.EncBinary()
					_ = yym12
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("host"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Host))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					x.Scheme.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("scheme"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Scheme.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpHeaders"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPHeaders == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							h.encSliceHTTPHeader(([]HTTPHeader)(x.HTTPHeaders), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *HTTPGetAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *HTTPGetAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "path":
			if r.TryDecodeAsNil() {
				x.Path = ""
			} else {
				yyv4 := &x.Path
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv6 := &x.Port
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv6) {
				} else if !yym7 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv6)
				} else {
					z.DecFallback(yyv6, false)
				}
			}
		case "host":
			if r.TryDecodeAsNil() {
				x.Host = ""
			} else {
				yyv8 := &x.Host
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "scheme":
			if r.TryDecodeAsNil() {
				x.Scheme = ""
			} else {
				yyv10 := &x.Scheme
				yyv10.CodecDecodeSelf(d)
			}
		case "httpHeaders":
			if r.TryDecodeAsNil() {
				x.HTTPHeaders = nil
			} else {
				yyv11 := &x.HTTPHeaders
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					h.decSliceHTTPHeader((*[]HTTPHeader)(yyv11), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *HTTPGetAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Path = ""
	} else {
		yyv14 := &x.Path
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv16 := &x.Port
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv16) {
		} else if !yym17 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv16)
		} else {
			z.DecFallback(yyv16, false)
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Host = ""
	} else {
		yyv18 := &x.Host
		yym19 := z.DecBinary()
		_ = yym19
		if false {
		} else {
			*((*string)(yyv18)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Scheme = ""
	} else {
		yyv20 := &x.Scheme
		yyv20.CodecDecodeSelf(d)
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HTTPHeaders = nil
	} else {
		yyv21 := &x.HTTPHeaders
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			h.decSliceHTTPHeader((*[]HTTPHeader)(yyv21), d)
		}
	}
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = r.CheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj13-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x URIScheme) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *URIScheme) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *TCPSocketAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy4 := &x.Port
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else if z.HasExtensions() && z.EncExt(yy4) {
				} else if !yym5 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy4)
				} else {
					z.EncFallback(yy4)
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy6 := &x.Port
				yym7 := z.EncBinary()
				_ = yym7
				if false {
				} else if z.HasExtensions() && z.EncExt(yy6) {
				} else if !yym7 && z.IsJSONHandle() {
					z.EncJSONMarshal(yy6)
				} else {
					z.EncFallback(yy6)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *TCPSocketAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *TCPSocketAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = pkg4_intstr.IntOrString{}
			} else {
				yyv4 := &x.Port
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv4) {
				} else if !yym5 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv4)
				} else {
					z.DecFallback(yyv4, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *TCPSocketAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = pkg4_intstr.IntOrString{}
	} else {
		yyv7 := &x.Port
		yym8 := z.DecBinary()
		_ = yym8
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv7) {
		} else if !yym8 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv7)
		} else {
			z.DecFallback(yyv7, false)
		}
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ExecAction) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.Command) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ExecAction) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ExecAction) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv4 := &x.Command
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					z.F.DecSliceStringX(yyv4, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ExecAction) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv7 := &x.Command
		yym8 := z.DecBinary()
		_ = yym8
		if false {
		} else {
			z.F.DecSliceStringX(yyv7, false, d)
		}
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Probe) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [8]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Handler.Exec != nil && x.Exec != nil
			yyq2[1] = x.Handler.HTTPGet != nil && x.HTTPGet != nil
			yyq2[2] = x.Handler.TCPSocket != nil && x.TCPSocket != nil
			yyq2[3] = x.InitialDelaySeconds != 0
			yyq2[4] = x.TimeoutSeconds != 0
			yyq2[5] = x.PeriodSeconds != 0
			yyq2[6] = x.SuccessThreshold != 0
			yyq2[7] = x.FailureThreshold != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(8)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			var yyn3 bool
			if x.Handler.Exec == nil {
				yyn3 = true
				goto LABEL3
			}
		LABEL3:
			if yyr2 || yy2arr2 {
				if yyn3 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[0] {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn3 {
						r.EncodeNil()
					} else {
						if x.Exec == nil {
							r.EncodeNil()
						} else {
							x.Exec.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn6 bool
			if x.Handler.HTTPGet == nil {
				yyn6 = true
				goto LABEL6
			}
		LABEL6:
			if yyr2 || yy2arr2 {
				if yyn6 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[1] {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn6 {
						r.EncodeNil()
					} else {
						if x.HTTPGet == nil {
							r.EncodeNil()
						} else {
							x.HTTPGet.CodecEncodeSelf(e)
						}
					}
				}
			}
			var yyn9 bool
			if x.Handler.TCPSocket == nil {
				yyn9 = true
				goto LABEL9
			}
		LABEL9:
			if yyr2 || yy2arr2 {
				if yyn9 {
					r.EncodeNil()
				} else {
					z.EncSendContainerState(codecSelfer_containerArrayElem1234)
					if yyq2[2] {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					} else {
						r.EncodeNil()
					}
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if yyn9 {
						r.EncodeNil()
					} else {
						if x.TCPSocket == nil {
							r.EncodeNil()
						} else {
							x.TCPSocket.CodecEncodeSelf(e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initialDelaySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeInt(int64(x.InitialDelaySeconds))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeoutSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeInt(int64(x.TimeoutSeconds))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("periodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeInt(int64(x.PeriodSeconds))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("successThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeInt(int64(x.SuccessThreshold))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("failureThreshold"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeInt(int64(x.FailureThreshold))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Probe) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Probe) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "exec":
			if x.Handler.Exec == nil {
				x.Handler.Exec = new(ExecAction)
			}
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if x.Handler.HTTPGet == nil {
				x.Handler.HTTPGet = new(HTTPGetAction)
			}
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if x.Handler.TCPSocket == nil {
				x.Handler.TCPSocket = new(TCPSocketAction)
			}
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		case "initialDelaySeconds":
			if r.TryDecodeAsNil() {
				x.InitialDelaySeconds = 0
			} else {
				yyv7 := &x.InitialDelaySeconds
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else {
					*((*int32)(yyv7)) = int32(r.DecodeInt(32))
				}
			}
		case "timeoutSeconds":
			if r.TryDecodeAsNil() {
				x.TimeoutSeconds = 0
			} else {
				yyv9 := &x.TimeoutSeconds
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else {
					*((*int32)(yyv9)) = int32(r.DecodeInt(32))
				}
			}
		case "periodSeconds":
			if r.TryDecodeAsNil() {
				x.PeriodSeconds = 0
			} else {
				yyv11 := &x.PeriodSeconds
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*int32)(yyv11)) = int32(r.DecodeInt(32))
				}
			}
		case "successThreshold":
			if r.TryDecodeAsNil() {
				x.SuccessThreshold = 0
			} else {
				yyv13 := &x.SuccessThreshold
				yym14 := z.DecBinary()
				_ = yym14
				if false {
				} else {
					*((*int32)(yyv13)) = int32(r.DecodeInt(32))
				}
			}
		case "failureThreshold":
			if r.TryDecodeAsNil() {
				x.FailureThreshold = 0
			} else {
				yyv15 := &x.FailureThreshold
				yym16 := z.DecBinary()
				_ = yym16
				if false {
				} else {
					*((*int32)(yyv15)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Probe) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj17 int
	var yyb17 bool
	var yyhl17 bool = l >= 0
	if x.Handler.Exec == nil {
		x.Handler.Exec = new(ExecAction)
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	if x.Handler.HTTPGet == nil {
		x.Handler.HTTPGet = new(HTTPGetAction)
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	if x.Handler.TCPSocket == nil {
		x.Handler.TCPSocket = new(TCPSocketAction)
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitialDelaySeconds = 0
	} else {
		yyv21 := &x.InitialDelaySeconds
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*int32)(yyv21)) = int32(r.DecodeInt(32))
		}
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeoutSeconds = 0
	} else {
		yyv23 := &x.TimeoutSeconds
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			*((*int32)(yyv23)) = int32(r.DecodeInt(32))
		}
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PeriodSeconds = 0
	} else {
		yyv25 := &x.PeriodSeconds
		yym26 := z.DecBinary()
		_ = yym26
		if false {
		} else {
			*((*int32)(yyv25)) = int32(r.DecodeInt(32))
		}
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SuccessThreshold = 0
	} else {
		yyv27 := &x.SuccessThreshold
		yym28 := z.DecBinary()
		_ = yym28
		if false {
		} else {
			*((*int32)(yyv27)) = int32(r.DecodeInt(32))
		}
	}
	yyj17++
	if yyhl17 {
		yyb17 = yyj17 > l
	} else {
		yyb17 = r.CheckBreak()
	}
	if yyb17 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FailureThreshold = 0
	} else {
		yyv29 := &x.FailureThreshold
		yym30 := z.DecBinary()
		_ = yym30
		if false {
		} else {
			*((*int32)(yyv29)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj17++
		if yyhl17 {
			yyb17 = yyj17 > l
		} else {
			yyb17 = r.CheckBreak()
		}
		if yyb17 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj17-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PullPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PullPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x TerminationMessagePolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TerminationMessagePolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x Capability) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *Capability) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Capabilities) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.Add) != 0
			yyq2[1] = len(x.Drop) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("add"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Add == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Add), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("drop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Drop == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceCapability(([]Capability)(x.Drop), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Capabilities) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Capabilities) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "add":
			if r.TryDecodeAsNil() {
				x.Add = nil
			} else {
				yyv4 := &x.Add
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv4), d)
				}
			}
		case "drop":
			if r.TryDecodeAsNil() {
				x.Drop = nil
			} else {
				yyv6 := &x.Drop
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceCapability((*[]Capability)(yyv6), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Capabilities) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Add = nil
	} else {
		yyv9 := &x.Add
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv9), d)
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Drop = nil
	} else {
		yyv11 := &x.Drop
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			h.decSliceCapability((*[]Capability)(yyv11), d)
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ResourceRequirements) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.Limits) != 0
			yyq2[1] = len(x.Requests) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("limits"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Limits == nil {
						r.EncodeNil()
					} else {
						x.Limits.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requests"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Requests == nil {
						r.EncodeNil()
					} else {
						x.Requests.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ResourceRequirements) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ResourceRequirements) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "limits":
			if r.TryDecodeAsNil() {
				x.Limits = nil
			} else {
				yyv4 := &x.Limits
				yyv4.CodecDecodeSelf(d)
			}
		case "requests":
			if r.TryDecodeAsNil() {
				x.Requests = nil
			} else {
				yyv5 := &x.Requests
				yyv5.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ResourceRequirements) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Limits = nil
	} else {
		yyv7 := &x.Limits
		yyv7.CodecDecodeSelf(d)
	}
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Requests = nil
	} else {
		yyv8 := &x.Requests
		yyv8.CodecDecodeSelf(d)
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Container) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [20]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.Image != ""
			yyq2[2] = len(x.Command) != 0
			yyq2[3] = len(x.Args) != 0
			yyq2[4] = x.WorkingDir != ""
			yyq2[5] = len(x.Ports) != 0
			yyq2[6] = len(x.EnvFrom) != 0
			yyq2[7] = len(x.Env) != 0
			yyq2[8] = true
			yyq2[9] = len(x.VolumeMounts) != 0
			yyq2[10] = x.LivenessProbe != nil
			yyq2[11] = x.ReadinessProbe != nil
			yyq2[12] = x.Lifecycle != nil
			yyq2[13] = x.TerminationMessagePath != ""
			yyq2[14] = x.TerminationMessagePolicy != ""
			yyq2[15] = x.ImagePullPolicy != ""
			yyq2[16] = x.SecurityContext != nil
			yyq2[17] = x.Stdin != false
			yyq2[18] = x.StdinOnce != false
			yyq2[19] = x.TTY != false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(20)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("image"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Image))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym10 := z.EncBinary()
						_ = yym10
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("command"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Command == nil {
						r.EncodeNil()
					} else {
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							z.F.EncSliceStringV(x.Command, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("args"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Args == nil {
						r.EncodeNil()
					} else {
						yym14 := z.EncBinary()
						_ = yym14
						if false {
						} else {
							z.F.EncSliceStringV(x.Args, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("workingDir"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.WorkingDir))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym20 := z.EncBinary()
						_ = yym20
						if false {
						} else {
							h.encSliceContainerPort(([]ContainerPort)(x.Ports), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					if x.EnvFrom == nil {
						r.EncodeNil()
					} else {
						yym22 := z.EncBinary()
						_ = yym22
						if false {
						} else {
							h.encSliceEnvFromSource(([]EnvFromSource)(x.EnvFrom), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("envFrom"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.EnvFrom == nil {
						r.EncodeNil()
					} else {
						yym23 := z.EncBinary()
						_ = yym23
						if false {
						} else {
							h.encSliceEnvFromSource(([]EnvFromSource)(x.EnvFrom), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym25 := z.EncBinary()
						_ = yym25
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("env"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Env == nil {
						r.EncodeNil()
					} else {
						yym26 := z.EncBinary()
						_ = yym26
						if false {
						} else {
							h.encSliceEnvVar(([]EnvVar)(x.Env), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yy28 := &x.Resources
					yy28.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("resources"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy30 := &x.Resources
					yy30.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym33 := z.EncBinary()
						_ = yym33
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumeMounts"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.VolumeMounts == nil {
						r.EncodeNil()
					} else {
						yym34 := z.EncBinary()
						_ = yym34
						if false {
						} else {
							h.encSliceVolumeMount(([]VolumeMount)(x.VolumeMounts), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("livenessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LivenessProbe == nil {
						r.EncodeNil()
					} else {
						x.LivenessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readinessProbe"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ReadinessProbe == nil {
						r.EncodeNil()
					} else {
						x.ReadinessProbe.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lifecycle"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Lifecycle == nil {
						r.EncodeNil()
					} else {
						x.Lifecycle.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					yym45 := z.EncBinary()
					_ = yym45
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePath"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym46 := z.EncBinary()
					_ = yym46
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TerminationMessagePath))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					x.TerminationMessagePolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationMessagePolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.TerminationMessagePolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[15] {
					x.ImagePullPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.ImagePullPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[17] {
					yym57 := z.EncBinary()
					_ = yym57
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdin"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym58 := z.EncBinary()
					_ = yym58
					if false {
					} else {
						r.EncodeBool(bool(x.Stdin))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[18] {
					yym60 := z.EncBinary()
					_ = yym60
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("stdinOnce"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym61 := z.EncBinary()
					_ = yym61
					if false {
					} else {
						r.EncodeBool(bool(x.StdinOnce))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[19] {
					yym63 := z.EncBinary()
					_ = yym63
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tty"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeBool(bool(x.TTY))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Container) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Container) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				yyv6 := &x.Image
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "command":
			if r.TryDecodeAsNil() {
				x.Command = nil
			} else {
				yyv8 := &x.Command
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					z.F.DecSliceStringX(yyv8, false, d)
				}
			}
		case "args":
			if r.TryDecodeAsNil() {
				x.Args = nil
			} else {
				yyv10 := &x.Args
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					z.F.DecSliceStringX(yyv10, false, d)
				}
			}
		case "workingDir":
			if r.TryDecodeAsNil() {
				x.WorkingDir = ""
			} else {
				yyv12 := &x.WorkingDir
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv14 := &x.Ports
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					h.decSliceContainerPort((*[]ContainerPort)(yyv14), d)
				}
			}
		case "envFrom":
			if r.TryDecodeAsNil() {
				x.EnvFrom = nil
			} else {
				yyv16 := &x.EnvFrom
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else {
					h.decSliceEnvFromSource((*[]EnvFromSource)(yyv16), d)
				}
			}
		case "env":
			if r.TryDecodeAsNil() {
				x.Env = nil
			} else {
				yyv18 := &x.Env
				yym19 := z.DecBinary()
				_ = yym19
				if false {
				} else {
					h.decSliceEnvVar((*[]EnvVar)(yyv18), d)
				}
			}
		case "resources":
			if r.TryDecodeAsNil() {
				x.Resources = ResourceRequirements{}
			} else {
				yyv20 := &x.Resources
				yyv20.CodecDecodeSelf(d)
			}
		case "volumeMounts":
			if r.TryDecodeAsNil() {
				x.VolumeMounts = nil
			} else {
				yyv21 := &x.VolumeMounts
				yym22 := z.DecBinary()
				_ = yym22
				if false {
				} else {
					h.decSliceVolumeMount((*[]VolumeMount)(yyv21), d)
				}
			}
		case "livenessProbe":
			if r.TryDecodeAsNil() {
				if x.LivenessProbe != nil {
					x.LivenessProbe = nil
				}
			} else {
				if x.LivenessProbe == nil {
					x.LivenessProbe = new(Probe)
				}
				x.LivenessProbe.CodecDecodeSelf(d)
			}
		case "readinessProbe":
			if r.TryDecodeAsNil() {
				if x.ReadinessProbe != nil {
					x.ReadinessProbe = nil
				}
			} else {
				if x.ReadinessProbe == nil {
					x.ReadinessProbe = new(Probe)
				}
				x.ReadinessProbe.CodecDecodeSelf(d)
			}
		case "lifecycle":
			if r.TryDecodeAsNil() {
				if x.Lifecycle != nil {
					x.Lifecycle = nil
				}
			} else {
				if x.Lifecycle == nil {
					x.Lifecycle = new(Lifecycle)
				}
				x.Lifecycle.CodecDecodeSelf(d)
			}
		case "terminationMessagePath":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePath = ""
			} else {
				yyv26 := &x.TerminationMessagePath
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else {
					*((*string)(yyv26)) = r.DecodeString()
				}
			}
		case "terminationMessagePolicy":
			if r.TryDecodeAsNil() {
				x.TerminationMessagePolicy = ""
			} else {
				yyv28 := &x.TerminationMessagePolicy
				yyv28.CodecDecodeSelf(d)
			}
		case "imagePullPolicy":
			if r.TryDecodeAsNil() {
				x.ImagePullPolicy = ""
			} else {
				yyv29 := &x.ImagePullPolicy
				yyv29.CodecDecodeSelf(d)
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(SecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "stdin":
			if r.TryDecodeAsNil() {
				x.Stdin = false
			} else {
				yyv31 := &x.Stdin
				yym32 := z.DecBinary()
				_ = yym32
				if false {
				} else {
					*((*bool)(yyv31)) = r.DecodeBool()
				}
			}
		case "stdinOnce":
			if r.TryDecodeAsNil() {
				x.StdinOnce = false
			} else {
				yyv33 := &x.StdinOnce
				yym34 := z.DecBinary()
				_ = yym34
				if false {
				} else {
					*((*bool)(yyv33)) = r.DecodeBool()
				}
			}
		case "tty":
			if r.TryDecodeAsNil() {
				x.TTY = false
			} else {
				yyv35 := &x.TTY
				yym36 := z.DecBinary()
				_ = yym36
				if false {
				} else {
					*((*bool)(yyv35)) = r.DecodeBool()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Container) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj37 int
	var yyb37 bool
	var yyhl37 bool = l >= 0
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv38 := &x.Name
		yym39 := z.DecBinary()
		_ = yym39
		if false {
		} else {
			*((*string)(yyv38)) = r.DecodeString()
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		yyv40 := &x.Image
		yym41 := z.DecBinary()
		_ = yym41
		if false {
		} else {
			*((*string)(yyv40)) = r.DecodeString()
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Command = nil
	} else {
		yyv42 := &x.Command
		yym43 := z.DecBinary()
		_ = yym43
		if false {
		} else {
			z.F.DecSliceStringX(yyv42, false, d)
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Args = nil
	} else {
		yyv44 := &x.Args
		yym45 := z.DecBinary()
		_ = yym45
		if false {
		} else {
			z.F.DecSliceStringX(yyv44, false, d)
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.WorkingDir = ""
	} else {
		yyv46 := &x.WorkingDir
		yym47 := z.DecBinary()
		_ = yym47
		if false {
		} else {
			*((*string)(yyv46)) = r.DecodeString()
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv48 := &x.Ports
		yym49 := z.DecBinary()
		_ = yym49
		if false {
		} else {
			h.decSliceContainerPort((*[]ContainerPort)(yyv48), d)
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.EnvFrom = nil
	} else {
		yyv50 := &x.EnvFrom
		yym51 := z.DecBinary()
		_ = yym51
		if false {
		} else {
			h.decSliceEnvFromSource((*[]EnvFromSource)(yyv50), d)
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Env = nil
	} else {
		yyv52 := &x.Env
		yym53 := z.DecBinary()
		_ = yym53
		if false {
		} else {
			h.decSliceEnvVar((*[]EnvVar)(yyv52), d)
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Resources = ResourceRequirements{}
	} else {
		yyv54 := &x.Resources
		yyv54.CodecDecodeSelf(d)
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.VolumeMounts = nil
	} else {
		yyv55 := &x.VolumeMounts
		yym56 := z.DecBinary()
		_ = yym56
		if false {
		} else {
			h.decSliceVolumeMount((*[]VolumeMount)(yyv55), d)
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LivenessProbe != nil {
			x.LivenessProbe = nil
		}
	} else {
		if x.LivenessProbe == nil {
			x.LivenessProbe = new(Probe)
		}
		x.LivenessProbe.CodecDecodeSelf(d)
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ReadinessProbe != nil {
			x.ReadinessProbe = nil
		}
	} else {
		if x.ReadinessProbe == nil {
			x.ReadinessProbe = new(Probe)
		}
		x.ReadinessProbe.CodecDecodeSelf(d)
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Lifecycle != nil {
			x.Lifecycle = nil
		}
	} else {
		if x.Lifecycle == nil {
			x.Lifecycle = new(Lifecycle)
		}
		x.Lifecycle.CodecDecodeSelf(d)
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePath = ""
	} else {
		yyv60 := &x.TerminationMessagePath
		yym61 := z.DecBinary()
		_ = yym61
		if false {
		} else {
			*((*string)(yyv60)) = r.DecodeString()
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TerminationMessagePolicy = ""
	} else {
		yyv62 := &x.TerminationMessagePolicy
		yyv62.CodecDecodeSelf(d)
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullPolicy = ""
	} else {
		yyv63 := &x.ImagePullPolicy
		yyv63.CodecDecodeSelf(d)
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(SecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Stdin = false
	} else {
		yyv65 := &x.Stdin
		yym66 := z.DecBinary()
		_ = yym66
		if false {
		} else {
			*((*bool)(yyv65)) = r.DecodeBool()
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StdinOnce = false
	} else {
		yyv67 := &x.StdinOnce
		yym68 := z.DecBinary()
		_ = yym68
		if false {
		} else {
			*((*bool)(yyv67)) = r.DecodeBool()
		}
	}
	yyj37++
	if yyhl37 {
		yyb37 = yyj37 > l
	} else {
		yyb37 = r.CheckBreak()
	}
	if yyb37 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TTY = false
	} else {
		yyv69 := &x.TTY
		yym70 := z.DecBinary()
		_ = yym70
		if false {
		} else {
			*((*bool)(yyv69)) = r.DecodeBool()
		}
	}
	for {
		yyj37++
		if yyhl37 {
			yyb37 = yyj37 > l
		} else {
			yyb37 = r.CheckBreak()
		}
		if yyb37 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj37-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Handler) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Exec != nil
			yyq2[1] = x.HTTPGet != nil
			yyq2[2] = x.TCPSocket != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("exec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Exec == nil {
						r.EncodeNil()
					} else {
						x.Exec.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("httpGet"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.HTTPGet == nil {
						r.EncodeNil()
					} else {
						x.HTTPGet.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tcpSocket"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TCPSocket == nil {
						r.EncodeNil()
					} else {
						x.TCPSocket.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Handler) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Handler) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "exec":
			if r.TryDecodeAsNil() {
				if x.Exec != nil {
					x.Exec = nil
				}
			} else {
				if x.Exec == nil {
					x.Exec = new(ExecAction)
				}
				x.Exec.CodecDecodeSelf(d)
			}
		case "httpGet":
			if r.TryDecodeAsNil() {
				if x.HTTPGet != nil {
					x.HTTPGet = nil
				}
			} else {
				if x.HTTPGet == nil {
					x.HTTPGet = new(HTTPGetAction)
				}
				x.HTTPGet.CodecDecodeSelf(d)
			}
		case "tcpSocket":
			if r.TryDecodeAsNil() {
				if x.TCPSocket != nil {
					x.TCPSocket = nil
				}
			} else {
				if x.TCPSocket == nil {
					x.TCPSocket = new(TCPSocketAction)
				}
				x.TCPSocket.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Handler) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Exec != nil {
			x.Exec = nil
		}
	} else {
		if x.Exec == nil {
			x.Exec = new(ExecAction)
		}
		x.Exec.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.HTTPGet != nil {
			x.HTTPGet = nil
		}
	} else {
		if x.HTTPGet == nil {
			x.HTTPGet = new(HTTPGetAction)
		}
		x.HTTPGet.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TCPSocket != nil {
			x.TCPSocket = nil
		}
	} else {
		if x.TCPSocket == nil {
			x.TCPSocket = new(TCPSocketAction)
		}
		x.TCPSocket.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Lifecycle) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.PostStart != nil
			yyq2[1] = x.PreStop != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("postStart"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PostStart == nil {
						r.EncodeNil()
					} else {
						x.PostStart.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preStop"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreStop == nil {
						r.EncodeNil()
					} else {
						x.PreStop.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Lifecycle) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Lifecycle) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "postStart":
			if r.TryDecodeAsNil() {
				if x.PostStart != nil {
					x.PostStart = nil
				}
			} else {
				if x.PostStart == nil {
					x.PostStart = new(Handler)
				}
				x.PostStart.CodecDecodeSelf(d)
			}
		case "preStop":
			if r.TryDecodeAsNil() {
				if x.PreStop != nil {
					x.PreStop = nil
				}
			} else {
				if x.PreStop == nil {
					x.PreStop = new(Handler)
				}
				x.PreStop.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Lifecycle) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PostStart != nil {
			x.PostStart = nil
		}
	} else {
		if x.PostStart == nil {
			x.PostStart = new(Handler)
		}
		x.PostStart.CodecDecodeSelf(d)
	}
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PreStop != nil {
			x.PreStop = nil
		}
	} else {
		if x.PreStop == nil {
			x.PreStop = new(Handler)
		}
		x.PreStop.CodecDecodeSelf(d)
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ConditionStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ConditionStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ContainerStateWaiting) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Reason != ""
			yyq2[1] = x.Message != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateWaiting) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateWaiting) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				yyv4 := &x.Reason
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				yyv6 := &x.Message
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateWaiting) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		yyv9 := &x.Reason
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		yyv11 := &x.Message
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateRunning) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yy4 := &x.StartedAt
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else if z.HasExtensions() && z.EncExt(yy4) {
					} else if yym5 {
						z.EncBinaryMarshal(yy4)
					} else if !yym5 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy4)
					} else {
						z.EncFallback(yy4)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy6 := &x.StartedAt
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else if z.HasExtensions() && z.EncExt(yy6) {
					} else if yym7 {
						z.EncBinaryMarshal(yy6)
					} else if !yym7 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy6)
					} else {
						z.EncFallback(yy6)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateRunning) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateRunning) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_v1.Time{}
			} else {
				yyv4 := &x.StartedAt
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv4) {
				} else if yym5 {
					z.DecBinaryUnmarshal(yyv4)
				} else if !yym5 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv4)
				} else {
					z.DecFallback(yyv4, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateRunning) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_v1.Time{}
	} else {
		yyv7 := &x.StartedAt
		yym8 := z.DecBinary()
		_ = yym8
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv7) {
		} else if yym8 {
			z.DecBinaryUnmarshal(yyv7)
		} else if !yym8 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv7)
		} else {
			z.DecFallback(yyv7, false)
		}
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStateTerminated) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [7]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.Signal != 0
			yyq2[2] = x.Reason != ""
			yyq2[3] = x.Message != ""
			yyq2[4] = true
			yyq2[5] = true
			yyq2[6] = x.ContainerID != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(7)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("exitCode"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeInt(int64(x.ExitCode))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("signal"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeInt(int64(x.Signal))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy16 := &x.StartedAt
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else if z.HasExtensions() && z.EncExt(yy16) {
					} else if yym17 {
						z.EncBinaryMarshal(yy16)
					} else if !yym17 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy16)
					} else {
						z.EncFallback(yy16)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy18 := &x.StartedAt
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else if z.HasExtensions() && z.EncExt(yy18) {
					} else if yym19 {
						z.EncBinaryMarshal(yy18)
					} else if !yym19 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy18)
					} else {
						z.EncFallback(yy18)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yy21 := &x.FinishedAt
					yym22 := z.EncBinary()
					_ = yym22
					if false {
					} else if z.HasExtensions() && z.EncExt(yy21) {
					} else if yym22 {
						z.EncBinaryMarshal(yy21)
					} else if !yym22 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy21)
					} else {
						z.EncFallback(yy21)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("finishedAt"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy23 := &x.FinishedAt
					yym24 := z.EncBinary()
					_ = yym24
					if false {
					} else if z.HasExtensions() && z.EncExt(yy23) {
					} else if yym24 {
						z.EncBinaryMarshal(yy23)
					} else if !yym24 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy23)
					} else {
						z.EncFallback(yy23)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym27 := z.EncBinary()
					_ = yym27
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStateTerminated) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStateTerminated) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "exitCode":
			if r.TryDecodeAsNil() {
				x.ExitCode = 0
			} else {
				yyv4 := &x.ExitCode
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*int32)(yyv4)) = int32(r.DecodeInt(32))
				}
			}
		case "signal":
			if r.TryDecodeAsNil() {
				x.Signal = 0
			} else {
				yyv6 := &x.Signal
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*int32)(yyv6)) = int32(r.DecodeInt(32))
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				yyv8 := &x.Reason
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				yyv10 := &x.Message
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "startedAt":
			if r.TryDecodeAsNil() {
				x.StartedAt = pkg2_v1.Time{}
			} else {
				yyv12 := &x.StartedAt
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv12) {
				} else if yym13 {
					z.DecBinaryUnmarshal(yyv12)
				} else if !yym13 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv12)
				} else {
					z.DecFallback(yyv12, false)
				}
			}
		case "finishedAt":
			if r.TryDecodeAsNil() {
				x.FinishedAt = pkg2_v1.Time{}
			} else {
				yyv14 := &x.FinishedAt
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv14) {
				} else if yym15 {
					z.DecBinaryUnmarshal(yyv14)
				} else if !yym15 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv14)
				} else {
					z.DecFallback(yyv14, false)
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				yyv16 := &x.ContainerID
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else {
					*((*string)(yyv16)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStateTerminated) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj18 int
	var yyb18 bool
	var yyhl18 bool = l >= 0
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExitCode = 0
	} else {
		yyv19 := &x.ExitCode
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*int32)(yyv19)) = int32(r.DecodeInt(32))
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Signal = 0
	} else {
		yyv21 := &x.Signal
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*int32)(yyv21)) = int32(r.DecodeInt(32))
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		yyv23 := &x.Reason
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			*((*string)(yyv23)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		yyv25 := &x.Message
		yym26 := z.DecBinary()
		_ = yym26
		if false {
		} else {
			*((*string)(yyv25)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.StartedAt = pkg2_v1.Time{}
	} else {
		yyv27 := &x.StartedAt
		yym28 := z.DecBinary()
		_ = yym28
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv27) {
		} else if yym28 {
			z.DecBinaryUnmarshal(yyv27)
		} else if !yym28 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv27)
		} else {
			z.DecFallback(yyv27, false)
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FinishedAt = pkg2_v1.Time{}
	} else {
		yyv29 := &x.FinishedAt
		yym30 := z.DecBinary()
		_ = yym30
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv29) {
		} else if yym30 {
			z.DecBinaryUnmarshal(yyv29)
		} else if !yym30 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv29)
		} else {
			z.DecFallback(yyv29, false)
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		yyv31 := &x.ContainerID
		yym32 := z.DecBinary()
		_ = yym32
		if false {
		} else {
			*((*string)(yyv31)) = r.DecodeString()
		}
	}
	for {
		yyj18++
		if yyhl18 {
			yyb18 = yyj18 > l
		} else {
			yyb18 = r.CheckBreak()
		}
		if yyb18 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj18-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerState) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Waiting != nil
			yyq2[1] = x.Running != nil
			yyq2[2] = x.Terminated != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("waiting"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Waiting == nil {
						r.EncodeNil()
					} else {
						x.Waiting.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("running"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Running == nil {
						r.EncodeNil()
					} else {
						x.Running.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminated"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Terminated == nil {
						r.EncodeNil()
					} else {
						x.Terminated.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerState) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerState) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "waiting":
			if r.TryDecodeAsNil() {
				if x.Waiting != nil {
					x.Waiting = nil
				}
			} else {
				if x.Waiting == nil {
					x.Waiting = new(ContainerStateWaiting)
				}
				x.Waiting.CodecDecodeSelf(d)
			}
		case "running":
			if r.TryDecodeAsNil() {
				if x.Running != nil {
					x.Running = nil
				}
			} else {
				if x.Running == nil {
					x.Running = new(ContainerStateRunning)
				}
				x.Running.CodecDecodeSelf(d)
			}
		case "terminated":
			if r.TryDecodeAsNil() {
				if x.Terminated != nil {
					x.Terminated = nil
				}
			} else {
				if x.Terminated == nil {
					x.Terminated = new(ContainerStateTerminated)
				}
				x.Terminated.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerState) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Waiting != nil {
			x.Waiting = nil
		}
	} else {
		if x.Waiting == nil {
			x.Waiting = new(ContainerStateWaiting)
		}
		x.Waiting.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Running != nil {
			x.Running = nil
		}
	} else {
		if x.Running == nil {
			x.Running = new(ContainerStateRunning)
		}
		x.Running.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Terminated != nil {
			x.Terminated = nil
		}
	} else {
		if x.Terminated == nil {
			x.Terminated = new(ContainerStateTerminated)
		}
		x.Terminated.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ContainerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [8]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = true
			yyq2[2] = true
			yyq2[7] = x.ContainerID != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(8)
			} else {
				yynn2 = 5
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("name"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Name))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yy7 := &x.State
					yy7.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("state"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy9 := &x.State
					yy9.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy12 := &x.LastTerminationState
					yy12.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastState"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy14 := &x.LastTerminationState
					yy14.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym17 := z.EncBinary()
				_ = yym17
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("ready"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym18 := z.EncBinary()
				_ = yym18
				if false {
				} else {
					r.EncodeBool(bool(x.Ready))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym20 := z.EncBinary()
				_ = yym20
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("restartCount"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym21 := z.EncBinary()
				_ = yym21
				if false {
				} else {
					r.EncodeInt(int64(x.RestartCount))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym23 := z.EncBinary()
				_ = yym23
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("image"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym24 := z.EncBinary()
				_ = yym24
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Image))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym26 := z.EncBinary()
				_ = yym26
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("imageID"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym27 := z.EncBinary()
				_ = yym27
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.ImageID))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym29 := z.EncBinary()
					_ = yym29
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym30 := z.EncBinary()
					_ = yym30
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ContainerID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ContainerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ContainerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "state":
			if r.TryDecodeAsNil() {
				x.State = ContainerState{}
			} else {
				yyv6 := &x.State
				yyv6.CodecDecodeSelf(d)
			}
		case "lastState":
			if r.TryDecodeAsNil() {
				x.LastTerminationState = ContainerState{}
			} else {
				yyv7 := &x.LastTerminationState
				yyv7.CodecDecodeSelf(d)
			}
		case "ready":
			if r.TryDecodeAsNil() {
				x.Ready = false
			} else {
				yyv8 := &x.Ready
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*bool)(yyv8)) = r.DecodeBool()
				}
			}
		case "restartCount":
			if r.TryDecodeAsNil() {
				x.RestartCount = 0
			} else {
				yyv10 := &x.RestartCount
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*int32)(yyv10)) = int32(r.DecodeInt(32))
				}
			}
		case "image":
			if r.TryDecodeAsNil() {
				x.Image = ""
			} else {
				yyv12 := &x.Image
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		case "imageID":
			if r.TryDecodeAsNil() {
				x.ImageID = ""
			} else {
				yyv14 := &x.ImageID
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					*((*string)(yyv14)) = r.DecodeString()
				}
			}
		case "containerID":
			if r.TryDecodeAsNil() {
				x.ContainerID = ""
			} else {
				yyv16 := &x.ContainerID
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else {
					*((*string)(yyv16)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ContainerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj18 int
	var yyb18 bool
	var yyhl18 bool = l >= 0
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv19 := &x.Name
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(yyv19)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.State = ContainerState{}
	} else {
		yyv21 := &x.State
		yyv21.CodecDecodeSelf(d)
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTerminationState = ContainerState{}
	} else {
		yyv22 := &x.LastTerminationState
		yyv22.CodecDecodeSelf(d)
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ready = false
	} else {
		yyv23 := &x.Ready
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			*((*bool)(yyv23)) = r.DecodeBool()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartCount = 0
	} else {
		yyv25 := &x.RestartCount
		yym26 := z.DecBinary()
		_ = yym26
		if false {
		} else {
			*((*int32)(yyv25)) = int32(r.DecodeInt(32))
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Image = ""
	} else {
		yyv27 := &x.Image
		yym28 := z.DecBinary()
		_ = yym28
		if false {
		} else {
			*((*string)(yyv27)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImageID = ""
	} else {
		yyv29 := &x.ImageID
		yym30 := z.DecBinary()
		_ = yym30
		if false {
		} else {
			*((*string)(yyv29)) = r.DecodeString()
		}
	}
	yyj18++
	if yyhl18 {
		yyb18 = yyj18 > l
	} else {
		yyb18 = r.CheckBreak()
	}
	if yyb18 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerID = ""
	} else {
		yyv31 := &x.ContainerID
		yym32 := z.DecBinary()
		_ = yym32
		if false {
		} else {
			*((*string)(yyv31)) = r.DecodeString()
		}
	}
	for {
		yyj18++
		if yyhl18 {
			yyb18 = yyj18 > l
		} else {
			yyb18 = r.CheckBreak()
		}
		if yyb18 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj18-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodPhase) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodPhase) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x PodConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [6]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = x.Reason != ""
			yyq2[5] = x.Message != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(6)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.LastProbeTime
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else if yym11 {
						z.EncBinaryMarshal(yy10)
					} else if !yym11 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy10)
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastProbeTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.LastProbeTime
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else if yym13 {
						z.EncBinaryMarshal(yy12)
					} else if !yym13 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy12)
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.LastTransitionTime
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(yy15) {
					} else if yym16 {
						z.EncBinaryMarshal(yy15)
					} else if !yym16 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy15)
					} else {
						z.EncFallback(yy15)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.LastTransitionTime
					yym18 := z.EncBinary()
					_ = yym18
					if false {
					} else if z.HasExtensions() && z.EncExt(yy17) {
					} else if yym18 {
						z.EncBinaryMarshal(yy17)
					} else if !yym18 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy17)
					} else {
						z.EncFallback(yy17)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym21 := z.EncBinary()
					_ = yym21
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym23 := z.EncBinary()
					_ = yym23
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym24 := z.EncBinary()
					_ = yym24
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				yyv4 := &x.Type
				yyv4.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				yyv5 := &x.Status
				yyv5.CodecDecodeSelf(d)
			}
		case "lastProbeTime":
			if r.TryDecodeAsNil() {
				x.LastProbeTime = pkg2_v1.Time{}
			} else {
				yyv6 := &x.LastProbeTime
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv6) {
				} else if yym7 {
					z.DecBinaryUnmarshal(yyv6)
				} else if !yym7 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv6)
				} else {
					z.DecFallback(yyv6, false)
				}
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_v1.Time{}
			} else {
				yyv8 := &x.LastTransitionTime
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else if yym9 {
					z.DecBinaryUnmarshal(yyv8)
				} else if !yym9 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv8)
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				yyv10 := &x.Reason
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				yyv12 := &x.Message
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*string)(yyv12)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj14 int
	var yyb14 bool
	var yyhl14 bool = l >= 0
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		yyv15 := &x.Type
		yyv15.CodecDecodeSelf(d)
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		yyv16 := &x.Status
		yyv16.CodecDecodeSelf(d)
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastProbeTime = pkg2_v1.Time{}
	} else {
		yyv17 := &x.LastProbeTime
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else if yym18 {
			z.DecBinaryUnmarshal(yyv17)
		} else if !yym18 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv17)
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_v1.Time{}
	} else {
		yyv19 := &x.LastTransitionTime
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv19) {
		} else if yym20 {
			z.DecBinaryUnmarshal(yyv19)
		} else if !yym20 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv19)
		} else {
			z.DecFallback(yyv19, false)
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		yyv21 := &x.Reason
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*string)(yyv21)) = r.DecodeString()
		}
	}
	yyj14++
	if yyhl14 {
		yyb14 = yyj14 > l
	} else {
		yyb14 = r.CheckBreak()
	}
	if yyb14 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		yyv23 := &x.Message
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			*((*string)(yyv23)) = r.DecodeString()
		}
	}
	for {
		yyj14++
		if yyhl14 {
			yyb14 = yyj14 > l
		} else {
			yyb14 = r.CheckBreak()
		}
		if yyb14 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj14-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x RestartPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *RestartPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x DNSPolicy) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *DNSPolicy) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *NodeSelector) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("nodeSelectorTerms"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.NodeSelectorTerms == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						h.encSliceNodeSelectorTerm(([]NodeSelectorTerm)(x.NodeSelectorTerms), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelector) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelector) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "nodeSelectorTerms":
			if r.TryDecodeAsNil() {
				x.NodeSelectorTerms = nil
			} else {
				yyv4 := &x.NodeSelectorTerms
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv4), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelector) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelectorTerms = nil
	} else {
		yyv7 := &x.NodeSelectorTerms
		yym8 := z.DecBinary()
		_ = yym8
		if false {
		} else {
			h.decSliceNodeSelectorTerm((*[]NodeSelectorTerm)(yyv7), d)
		}
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("matchExpressions"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.MatchExpressions == nil {
					r.EncodeNil()
				} else {
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						h.encSliceNodeSelectorRequirement(([]NodeSelectorRequirement)(x.MatchExpressions), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "matchExpressions":
			if r.TryDecodeAsNil() {
				x.MatchExpressions = nil
			} else {
				yyv4 := &x.MatchExpressions
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv4), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MatchExpressions = nil
	} else {
		yyv7 := &x.MatchExpressions
		yym8 := z.DecBinary()
		_ = yym8
		if false {
		} else {
			h.decSliceNodeSelectorRequirement((*[]NodeSelectorRequirement)(yyv7), d)
		}
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeSelectorRequirement) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = len(x.Values) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Operator.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("operator"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Operator.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym10 := z.EncBinary()
						_ = yym10
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("values"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Values == nil {
						r.EncodeNil()
					} else {
						yym11 := z.EncBinary()
						_ = yym11
						if false {
						} else {
							z.F.EncSliceStringV(x.Values, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeSelectorRequirement) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				yyv4 := &x.Key
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				yyv6 := &x.Operator
				yyv6.CodecDecodeSelf(d)
			}
		case "values":
			if r.TryDecodeAsNil() {
				x.Values = nil
			} else {
				yyv7 := &x.Values
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else {
					z.F.DecSliceStringX(yyv7, false, d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeSelectorRequirement) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj9 int
	var yyb9 bool
	var yyhl9 bool = l >= 0
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		yyv10 := &x.Key
		yym11 := z.DecBinary()
		_ = yym11
		if false {
		} else {
			*((*string)(yyv10)) = r.DecodeString()
		}
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		yyv12 := &x.Operator
		yyv12.CodecDecodeSelf(d)
	}
	yyj9++
	if yyhl9 {
		yyb9 = yyj9 > l
	} else {
		yyb9 = r.CheckBreak()
	}
	if yyb9 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Values = nil
	} else {
		yyv13 := &x.Values
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			z.F.DecSliceStringX(yyv13, false, d)
		}
	}
	for {
		yyj9++
		if yyhl9 {
			yyb9 = yyj9 > l
		} else {
			yyb9 = r.CheckBreak()
		}
		if yyb9 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj9-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x NodeSelectorOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *NodeSelectorOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Affinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.NodeAffinity != nil
			yyq2[1] = x.PodAffinity != nil
			yyq2[2] = x.PodAntiAffinity != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeAffinity == nil {
						r.EncodeNil()
					} else {
						x.NodeAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podAntiAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PodAntiAffinity == nil {
						r.EncodeNil()
					} else {
						x.PodAntiAffinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Affinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Affinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "nodeAffinity":
			if r.TryDecodeAsNil() {
				if x.NodeAffinity != nil {
					x.NodeAffinity = nil
				}
			} else {
				if x.NodeAffinity == nil {
					x.NodeAffinity = new(NodeAffinity)
				}
				x.NodeAffinity.CodecDecodeSelf(d)
			}
		case "podAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAffinity != nil {
					x.PodAffinity = nil
				}
			} else {
				if x.PodAffinity == nil {
					x.PodAffinity = new(PodAffinity)
				}
				x.PodAffinity.CodecDecodeSelf(d)
			}
		case "podAntiAffinity":
			if r.TryDecodeAsNil() {
				if x.PodAntiAffinity != nil {
					x.PodAntiAffinity = nil
				}
			} else {
				if x.PodAntiAffinity == nil {
					x.PodAntiAffinity = new(PodAntiAffinity)
				}
				x.PodAntiAffinity.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Affinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.NodeAffinity != nil {
			x.NodeAffinity = nil
		}
	} else {
		if x.NodeAffinity == nil {
			x.NodeAffinity = new(NodeAffinity)
		}
		x.NodeAffinity.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAffinity != nil {
			x.PodAffinity = nil
		}
	} else {
		if x.PodAffinity == nil {
			x.PodAffinity = new(PodAffinity)
		}
		x.PodAffinity.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.PodAntiAffinity != nil {
			x.PodAntiAffinity = nil
		}
	} else {
		if x.PodAntiAffinity == nil {
			x.PodAntiAffinity = new(PodAntiAffinity)
		}
		x.PodAntiAffinity.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq2[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv4 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv4), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv6 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv6), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv9 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv9), d)
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv11 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv11), d)
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAntiAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.RequiredDuringSchedulingIgnoredDuringExecution) != 0
			yyq2[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							h.encSlicePodAffinityTerm(([]PodAffinityTerm)(x.RequiredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceWeightedPodAffinityTerm(([]WeightedPodAffinityTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAntiAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAntiAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.RequiredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv4 := &x.RequiredDuringSchedulingIgnoredDuringExecution
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv4), d)
				}
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv6 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv6), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAntiAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RequiredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv9 := &x.RequiredDuringSchedulingIgnoredDuringExecution
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			h.decSlicePodAffinityTerm((*[]PodAffinityTerm)(yyv9), d)
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv11 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			h.decSliceWeightedPodAffinityTerm((*[]WeightedPodAffinityTerm)(yyv11), d)
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *WeightedPodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy7 := &x.PodAffinityTerm
				yy7.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("podAffinityTerm"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy9 := &x.PodAffinityTerm
				yy9.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *WeightedPodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				yyv4 := &x.Weight
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*int32)(yyv4)) = int32(r.DecodeInt(32))
				}
			}
		case "podAffinityTerm":
			if r.TryDecodeAsNil() {
				x.PodAffinityTerm = PodAffinityTerm{}
			} else {
				yyv6 := &x.PodAffinityTerm
				yyv6.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *WeightedPodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		yyv8 := &x.Weight
		yym9 := z.DecBinary()
		_ = yym9
		if false {
		} else {
			*((*int32)(yyv8)) = int32(r.DecodeInt(32))
		}
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodAffinityTerm = PodAffinityTerm{}
	} else {
		yyv10 := &x.PodAffinityTerm
		yyv10.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodAffinityTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [3]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.LabelSelector != nil
			yyq2[1] = len(x.Namespaces) != 0
			yyq2[2] = x.TopologyKey != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(3)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("labelSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LabelSelector == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else if z.HasExtensions() && z.EncExt(x.LabelSelector) {
						} else {
							z.EncFallback(x.LabelSelector)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Namespaces == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							z.F.EncSliceStringV(x.Namespaces, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("namespaces"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Namespaces == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							z.F.EncSliceStringV(x.Namespaces, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("topologyKey"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.TopologyKey))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodAffinityTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodAffinityTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "labelSelector":
			if r.TryDecodeAsNil() {
				if x.LabelSelector != nil {
					x.LabelSelector = nil
				}
			} else {
				if x.LabelSelector == nil {
					x.LabelSelector = new(pkg2_v1.LabelSelector)
				}
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
				} else {
					z.DecFallback(x.LabelSelector, false)
				}
			}
		case "namespaces":
			if r.TryDecodeAsNil() {
				x.Namespaces = nil
			} else {
				yyv6 := &x.Namespaces
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					z.F.DecSliceStringX(yyv6, false, d)
				}
			}
		case "topologyKey":
			if r.TryDecodeAsNil() {
				x.TopologyKey = ""
			} else {
				yyv8 := &x.TopologyKey
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodAffinityTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj10 int
	var yyb10 bool
	var yyhl10 bool = l >= 0
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.LabelSelector != nil {
			x.LabelSelector = nil
		}
	} else {
		if x.LabelSelector == nil {
			x.LabelSelector = new(pkg2_v1.LabelSelector)
		}
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else if z.HasExtensions() && z.DecExt(x.LabelSelector) {
		} else {
			z.DecFallback(x.LabelSelector, false)
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Namespaces = nil
	} else {
		yyv13 := &x.Namespaces
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			z.F.DecSliceStringX(yyv13, false, d)
		}
	}
	yyj10++
	if yyhl10 {
		yyb10 = yyj10 > l
	} else {
		yyb10 = r.CheckBreak()
	}
	if yyb10 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TopologyKey = ""
	} else {
		yyv15 := &x.TopologyKey
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	for {
		yyj10++
		if yyhl10 {
			yyb10 = yyj10 > l
		} else {
			yyb10 = r.CheckBreak()
		}
		if yyb10 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj10-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *NodeAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.RequiredDuringSchedulingIgnoredDuringExecution != nil
			yyq2[1] = len(x.PreferredDuringSchedulingIgnoredDuringExecution) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("requiredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						x.RequiredDuringSchedulingIgnoredDuringExecution.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("preferredDuringSchedulingIgnoredDuringExecution"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.PreferredDuringSchedulingIgnoredDuringExecution == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSlicePreferredSchedulingTerm(([]PreferredSchedulingTerm)(x.PreferredDuringSchedulingIgnoredDuringExecution), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *NodeAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *NodeAffinity) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "requiredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = nil
				}
			} else {
				if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
					x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
				}
				x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
			}
		case "preferredDuringSchedulingIgnoredDuringExecution":
			if r.TryDecodeAsNil() {
				x.PreferredDuringSchedulingIgnoredDuringExecution = nil
			} else {
				yyv5 := &x.PreferredDuringSchedulingIgnoredDuringExecution
				yym6 := z.DecBinary()
				_ = yym6
				if false {
				} else {
					h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv5), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *NodeAffinity) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RequiredDuringSchedulingIgnoredDuringExecution != nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = nil
		}
	} else {
		if x.RequiredDuringSchedulingIgnoredDuringExecution == nil {
			x.RequiredDuringSchedulingIgnoredDuringExecution = new(NodeSelector)
		}
		x.RequiredDuringSchedulingIgnoredDuringExecution.CodecDecodeSelf(d)
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PreferredDuringSchedulingIgnoredDuringExecution = nil
	} else {
		yyv9 := &x.PreferredDuringSchedulingIgnoredDuringExecution
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			h.decSlicePreferredSchedulingTerm((*[]PreferredSchedulingTerm)(yyv9), d)
		}
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PreferredSchedulingTerm) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("weight"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeInt(int64(x.Weight))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yy7 := &x.Preference
				yy7.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("preference"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yy9 := &x.Preference
				yy9.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PreferredSchedulingTerm) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "weight":
			if r.TryDecodeAsNil() {
				x.Weight = 0
			} else {
				yyv4 := &x.Weight
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*int32)(yyv4)) = int32(r.DecodeInt(32))
				}
			}
		case "preference":
			if r.TryDecodeAsNil() {
				x.Preference = NodeSelectorTerm{}
			} else {
				yyv6 := &x.Preference
				yyv6.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PreferredSchedulingTerm) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Weight = 0
	} else {
		yyv8 := &x.Weight
		yym9 := z.DecBinary()
		_ = yym9
		if false {
		} else {
			*((*int32)(yyv8)) = int32(r.DecodeInt(32))
		}
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Preference = NodeSelectorTerm{}
	} else {
		yyv10 := &x.Preference
		yyv10.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Taint) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.Value != ""
			yyq2[3] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("key"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeString(codecSelferC_UTF81234, string(x.Key))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Effect.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("effect"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Effect.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy13 := &x.TimeAdded
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else if z.HasExtensions() && z.EncExt(yy13) {
					} else if yym14 {
						z.EncBinaryMarshal(yy13)
					} else if !yym14 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy13)
					} else {
						z.EncFallback(yy13)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("timeAdded"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy15 := &x.TimeAdded
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(yy15) {
					} else if yym16 {
						z.EncBinaryMarshal(yy15)
					} else if !yym16 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy15)
					} else {
						z.EncFallback(yy15)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Taint) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Taint) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				yyv4 := &x.Key
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				yyv6 := &x.Value
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				yyv8 := &x.Effect
				yyv8.CodecDecodeSelf(d)
			}
		case "timeAdded":
			if r.TryDecodeAsNil() {
				x.TimeAdded = pkg2_v1.Time{}
			} else {
				yyv9 := &x.TimeAdded
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv9) {
				} else if yym10 {
					z.DecBinaryUnmarshal(yyv9)
				} else if !yym10 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv9)
				} else {
					z.DecFallback(yyv9, false)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Taint) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj11 int
	var yyb11 bool
	var yyhl11 bool = l >= 0
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		yyv12 := &x.Key
		yym13 := z.DecBinary()
		_ = yym13
		if false {
		} else {
			*((*string)(yyv12)) = r.DecodeString()
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		yyv14 := &x.Value
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		yyv16 := &x.Effect
		yyv16.CodecDecodeSelf(d)
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TimeAdded = pkg2_v1.Time{}
	} else {
		yyv17 := &x.TimeAdded
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else if yym18 {
			z.DecBinaryUnmarshal(yyv17)
		} else if !yym18 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv17)
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	for {
		yyj11++
		if yyhl11 {
			yyb11 = yyj11 > l
		} else {
			yyb11 = r.CheckBreak()
		}
		if yyb11 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj11-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TaintEffect) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TaintEffect) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *Toleration) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Key != ""
			yyq2[1] = x.Operator != ""
			yyq2[2] = x.Value != ""
			yyq2[3] = x.Effect != ""
			yyq2[4] = x.TolerationSeconds != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("key"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Key))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					x.Operator.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("operator"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Operator.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("value"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Value))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					x.Effect.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("effect"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Effect.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.TolerationSeconds == nil {
						r.EncodeNil()
					} else {
						yy16 := *x.TolerationSeconds
						yym17 := z.EncBinary()
						_ = yym17
						if false {
						} else {
							r.EncodeInt(int64(yy16))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tolerationSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TolerationSeconds == nil {
						r.EncodeNil()
					} else {
						yy18 := *x.TolerationSeconds
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							r.EncodeInt(int64(yy18))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Toleration) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Toleration) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "key":
			if r.TryDecodeAsNil() {
				x.Key = ""
			} else {
				yyv4 := &x.Key
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "operator":
			if r.TryDecodeAsNil() {
				x.Operator = ""
			} else {
				yyv6 := &x.Operator
				yyv6.CodecDecodeSelf(d)
			}
		case "value":
			if r.TryDecodeAsNil() {
				x.Value = ""
			} else {
				yyv7 := &x.Value
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else {
					*((*string)(yyv7)) = r.DecodeString()
				}
			}
		case "effect":
			if r.TryDecodeAsNil() {
				x.Effect = ""
			} else {
				yyv9 := &x.Effect
				yyv9.CodecDecodeSelf(d)
			}
		case "tolerationSeconds":
			if r.TryDecodeAsNil() {
				if x.TolerationSeconds != nil {
					x.TolerationSeconds = nil
				}
			} else {
				if x.TolerationSeconds == nil {
					x.TolerationSeconds = new(int64)
				}
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*int64)(x.TolerationSeconds)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Toleration) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Key = ""
	} else {
		yyv13 := &x.Key
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Operator = ""
	} else {
		yyv15 := &x.Operator
		yyv15.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Value = ""
	} else {
		yyv16 := &x.Value
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else {
			*((*string)(yyv16)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Effect = ""
	} else {
		yyv18 := &x.Effect
		yyv18.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TolerationSeconds != nil {
			x.TolerationSeconds = nil
		}
	} else {
		if x.TolerationSeconds == nil {
			x.TolerationSeconds = new(int64)
		}
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*int64)(x.TolerationSeconds)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x TolerationOperator) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *TolerationOperator) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [22]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.Volumes) != 0
			yyq2[1] = len(x.InitContainers) != 0
			yyq2[3] = x.RestartPolicy != ""
			yyq2[4] = x.TerminationGracePeriodSeconds != nil
			yyq2[5] = x.ActiveDeadlineSeconds != nil
			yyq2[6] = x.DNSPolicy != ""
			yyq2[7] = len(x.NodeSelector) != 0
			yyq2[8] = x.ServiceAccountName != ""
			yyq2[9] = x.DeprecatedServiceAccount != ""
			yyq2[10] = x.AutomountServiceAccountToken != nil
			yyq2[11] = x.NodeName != ""
			yyq2[12] = x.HostNetwork != false
			yyq2[13] = x.HostPID != false
			yyq2[14] = x.HostIPC != false
			yyq2[15] = x.SecurityContext != nil
			yyq2[16] = len(x.ImagePullSecrets) != 0
			yyq2[17] = x.Hostname != ""
			yyq2[18] = x.Subdomain != ""
			yyq2[19] = x.Affinity != nil
			yyq2[20] = x.SchedulerName != ""
			yyq2[21] = len(x.Tolerations) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(22)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("volumes"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Volumes == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							h.encSliceVolume(([]Volume)(x.Volumes), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.InitContainers == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSliceContainer(([]Container)(x.InitContainers), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initContainers"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.InitContainers == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSliceContainer(([]Container)(x.InitContainers), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("containers"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Containers == nil {
					r.EncodeNil()
				} else {
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						h.encSliceContainer(([]Container)(x.Containers), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					x.RestartPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("restartPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.RestartPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy16 := *x.TerminationGracePeriodSeconds
						yym17 := z.EncBinary()
						_ = yym17
						if false {
						} else {
							r.EncodeInt(int64(yy16))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("terminationGracePeriodSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.TerminationGracePeriodSeconds == nil {
						r.EncodeNil()
					} else {
						yy18 := *x.TerminationGracePeriodSeconds
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							r.EncodeInt(int64(yy18))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy21 := *x.ActiveDeadlineSeconds
						yym22 := z.EncBinary()
						_ = yym22
						if false {
						} else {
							r.EncodeInt(int64(yy21))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("activeDeadlineSeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ActiveDeadlineSeconds == nil {
						r.EncodeNil()
					} else {
						yy23 := *x.ActiveDeadlineSeconds
						yym24 := z.EncBinary()
						_ = yym24
						if false {
						} else {
							r.EncodeInt(int64(yy23))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					x.DNSPolicy.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("dnsPolicy"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.DNSPolicy.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym29 := z.EncBinary()
						_ = yym29
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeSelector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.NodeSelector == nil {
						r.EncodeNil()
					} else {
						yym30 := z.EncBinary()
						_ = yym30
						if false {
						} else {
							z.F.EncMapStringStringV(x.NodeSelector, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccountName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym33 := z.EncBinary()
					_ = yym33
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ServiceAccountName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yym35 := z.EncBinary()
					_ = yym35
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("serviceAccount"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym36 := z.EncBinary()
					_ = yym36
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.DeprecatedServiceAccount))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[10] {
					if x.AutomountServiceAccountToken == nil {
						r.EncodeNil()
					} else {
						yy38 := *x.AutomountServiceAccountToken
						yym39 := z.EncBinary()
						_ = yym39
						if false {
						} else {
							r.EncodeBool(bool(yy38))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[10] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("automountServiceAccountToken"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.AutomountServiceAccountToken == nil {
						r.EncodeNil()
					} else {
						yy40 := *x.AutomountServiceAccountToken
						yym41 := z.EncBinary()
						_ = yym41
						if false {
						} else {
							r.EncodeBool(bool(yy40))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[11] {
					yym43 := z.EncBinary()
					_ = yym43
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[11] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodeName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym44 := z.EncBinary()
					_ = yym44
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.NodeName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[12] {
					yym46 := z.EncBinary()
					_ = yym46
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[12] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostNetwork"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym47 := z.EncBinary()
					_ = yym47
					if false {
					} else {
						r.EncodeBool(bool(x.HostNetwork))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[13] {
					yym49 := z.EncBinary()
					_ = yym49
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[13] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostPID"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym50 := z.EncBinary()
					_ = yym50
					if false {
					} else {
						r.EncodeBool(bool(x.HostPID))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[14] {
					yym52 := z.EncBinary()
					_ = yym52
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				} else {
					r.EncodeBool(false)
				}
			} else {
				if yyq2[14] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIPC"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym53 := z.EncBinary()
					_ = yym53
					if false {
					} else {
						r.EncodeBool(bool(x.HostIPC))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[15] {
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[15] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("securityContext"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SecurityContext == nil {
						r.EncodeNil()
					} else {
						x.SecurityContext.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[16] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym58 := z.EncBinary()
						_ = yym58
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[16] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym59 := z.EncBinary()
						_ = yym59
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[17] {
					yym61 := z.EncBinary()
					_ = yym61
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[17] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym62 := z.EncBinary()
					_ = yym62
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[18] {
					yym64 := z.EncBinary()
					_ = yym64
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[18] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("subdomain"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym65 := z.EncBinary()
					_ = yym65
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Subdomain))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[19] {
					if x.Affinity == nil {
						r.EncodeNil()
					} else {
						x.Affinity.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[19] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("affinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Affinity == nil {
						r.EncodeNil()
					} else {
						x.Affinity.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[20] {
					yym70 := z.EncBinary()
					_ = yym70
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[20] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("schedulerName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym71 := z.EncBinary()
					_ = yym71
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.SchedulerName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[21] {
					if x.Tolerations == nil {
						r.EncodeNil()
					} else {
						yym73 := z.EncBinary()
						_ = yym73
						if false {
						} else {
							h.encSliceToleration(([]Toleration)(x.Tolerations), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[21] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("tolerations"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Tolerations == nil {
						r.EncodeNil()
					} else {
						yym74 := z.EncBinary()
						_ = yym74
						if false {
						} else {
							h.encSliceToleration(([]Toleration)(x.Tolerations), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "volumes":
			if r.TryDecodeAsNil() {
				x.Volumes = nil
			} else {
				yyv4 := &x.Volumes
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSliceVolume((*[]Volume)(yyv4), d)
				}
			}
		case "initContainers":
			if r.TryDecodeAsNil() {
				x.InitContainers = nil
			} else {
				yyv6 := &x.InitContainers
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv6), d)
				}
			}
		case "containers":
			if r.TryDecodeAsNil() {
				x.Containers = nil
			} else {
				yyv8 := &x.Containers
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					h.decSliceContainer((*[]Container)(yyv8), d)
				}
			}
		case "restartPolicy":
			if r.TryDecodeAsNil() {
				x.RestartPolicy = ""
			} else {
				yyv10 := &x.RestartPolicy
				yyv10.CodecDecodeSelf(d)
			}
		case "terminationGracePeriodSeconds":
			if r.TryDecodeAsNil() {
				if x.TerminationGracePeriodSeconds != nil {
					x.TerminationGracePeriodSeconds = nil
				}
			} else {
				if x.TerminationGracePeriodSeconds == nil {
					x.TerminationGracePeriodSeconds = new(int64)
				}
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "activeDeadlineSeconds":
			if r.TryDecodeAsNil() {
				if x.ActiveDeadlineSeconds != nil {
					x.ActiveDeadlineSeconds = nil
				}
			} else {
				if x.ActiveDeadlineSeconds == nil {
					x.ActiveDeadlineSeconds = new(int64)
				}
				yym14 := z.DecBinary()
				_ = yym14
				if false {
				} else {
					*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
				}
			}
		case "dnsPolicy":
			if r.TryDecodeAsNil() {
				x.DNSPolicy = ""
			} else {
				yyv15 := &x.DNSPolicy
				yyv15.CodecDecodeSelf(d)
			}
		case "nodeSelector":
			if r.TryDecodeAsNil() {
				x.NodeSelector = nil
			} else {
				yyv16 := &x.NodeSelector
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else {
					z.F.DecMapStringStringX(yyv16, false, d)
				}
			}
		case "serviceAccountName":
			if r.TryDecodeAsNil() {
				x.ServiceAccountName = ""
			} else {
				yyv18 := &x.ServiceAccountName
				yym19 := z.DecBinary()
				_ = yym19
				if false {
				} else {
					*((*string)(yyv18)) = r.DecodeString()
				}
			}
		case "serviceAccount":
			if r.TryDecodeAsNil() {
				x.DeprecatedServiceAccount = ""
			} else {
				yyv20 := &x.DeprecatedServiceAccount
				yym21 := z.DecBinary()
				_ = yym21
				if false {
				} else {
					*((*string)(yyv20)) = r.DecodeString()
				}
			}
		case "automountServiceAccountToken":
			if r.TryDecodeAsNil() {
				if x.AutomountServiceAccountToken != nil {
					x.AutomountServiceAccountToken = nil
				}
			} else {
				if x.AutomountServiceAccountToken == nil {
					x.AutomountServiceAccountToken = new(bool)
				}
				yym23 := z.DecBinary()
				_ = yym23
				if false {
				} else {
					*((*bool)(x.AutomountServiceAccountToken)) = r.DecodeBool()
				}
			}
		case "nodeName":
			if r.TryDecodeAsNil() {
				x.NodeName = ""
			} else {
				yyv24 := &x.NodeName
				yym25 := z.DecBinary()
				_ = yym25
				if false {
				} else {
					*((*string)(yyv24)) = r.DecodeString()
				}
			}
		case "hostNetwork":
			if r.TryDecodeAsNil() {
				x.HostNetwork = false
			} else {
				yyv26 := &x.HostNetwork
				yym27 := z.DecBinary()
				_ = yym27
				if false {
				} else {
					*((*bool)(yyv26)) = r.DecodeBool()
				}
			}
		case "hostPID":
			if r.TryDecodeAsNil() {
				x.HostPID = false
			} else {
				yyv28 := &x.HostPID
				yym29 := z.DecBinary()
				_ = yym29
				if false {
				} else {
					*((*bool)(yyv28)) = r.DecodeBool()
				}
			}
		case "hostIPC":
			if r.TryDecodeAsNil() {
				x.HostIPC = false
			} else {
				yyv30 := &x.HostIPC
				yym31 := z.DecBinary()
				_ = yym31
				if false {
				} else {
					*((*bool)(yyv30)) = r.DecodeBool()
				}
			}
		case "securityContext":
			if r.TryDecodeAsNil() {
				if x.SecurityContext != nil {
					x.SecurityContext = nil
				}
			} else {
				if x.SecurityContext == nil {
					x.SecurityContext = new(PodSecurityContext)
				}
				x.SecurityContext.CodecDecodeSelf(d)
			}
		case "imagePullSecrets":
			if r.TryDecodeAsNil() {
				x.ImagePullSecrets = nil
			} else {
				yyv33 := &x.ImagePullSecrets
				yym34 := z.DecBinary()
				_ = yym34
				if false {
				} else {
					h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv33), d)
				}
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				yyv35 := &x.Hostname
				yym36 := z.DecBinary()
				_ = yym36
				if false {
				} else {
					*((*string)(yyv35)) = r.DecodeString()
				}
			}
		case "subdomain":
			if r.TryDecodeAsNil() {
				x.Subdomain = ""
			} else {
				yyv37 := &x.Subdomain
				yym38 := z.DecBinary()
				_ = yym38
				if false {
				} else {
					*((*string)(yyv37)) = r.DecodeString()
				}
			}
		case "affinity":
			if r.TryDecodeAsNil() {
				if x.Affinity != nil {
					x.Affinity = nil
				}
			} else {
				if x.Affinity == nil {
					x.Affinity = new(Affinity)
				}
				x.Affinity.CodecDecodeSelf(d)
			}
		case "schedulerName":
			if r.TryDecodeAsNil() {
				x.SchedulerName = ""
			} else {
				yyv40 := &x.SchedulerName
				yym41 := z.DecBinary()
				_ = yym41
				if false {
				} else {
					*((*string)(yyv40)) = r.DecodeString()
				}
			}
		case "tolerations":
			if r.TryDecodeAsNil() {
				x.Tolerations = nil
			} else {
				yyv42 := &x.Tolerations
				yym43 := z.DecBinary()
				_ = yym43
				if false {
				} else {
					h.decSliceToleration((*[]Toleration)(yyv42), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj44 int
	var yyb44 bool
	var yyhl44 bool = l >= 0
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Volumes = nil
	} else {
		yyv45 := &x.Volumes
		yym46 := z.DecBinary()
		_ = yym46
		if false {
		} else {
			h.decSliceVolume((*[]Volume)(yyv45), d)
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitContainers = nil
	} else {
		yyv47 := &x.InitContainers
		yym48 := z.DecBinary()
		_ = yym48
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv47), d)
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Containers = nil
	} else {
		yyv49 := &x.Containers
		yym50 := z.DecBinary()
		_ = yym50
		if false {
		} else {
			h.decSliceContainer((*[]Container)(yyv49), d)
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.RestartPolicy = ""
	} else {
		yyv51 := &x.RestartPolicy
		yyv51.CodecDecodeSelf(d)
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.TerminationGracePeriodSeconds != nil {
			x.TerminationGracePeriodSeconds = nil
		}
	} else {
		if x.TerminationGracePeriodSeconds == nil {
			x.TerminationGracePeriodSeconds = new(int64)
		}
		yym53 := z.DecBinary()
		_ = yym53
		if false {
		} else {
			*((*int64)(x.TerminationGracePeriodSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.ActiveDeadlineSeconds != nil {
			x.ActiveDeadlineSeconds = nil
		}
	} else {
		if x.ActiveDeadlineSeconds == nil {
			x.ActiveDeadlineSeconds = new(int64)
		}
		yym55 := z.DecBinary()
		_ = yym55
		if false {
		} else {
			*((*int64)(x.ActiveDeadlineSeconds)) = int64(r.DecodeInt(64))
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DNSPolicy = ""
	} else {
		yyv56 := &x.DNSPolicy
		yyv56.CodecDecodeSelf(d)
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeSelector = nil
	} else {
		yyv57 := &x.NodeSelector
		yym58 := z.DecBinary()
		_ = yym58
		if false {
		} else {
			z.F.DecMapStringStringX(yyv57, false, d)
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ServiceAccountName = ""
	} else {
		yyv59 := &x.ServiceAccountName
		yym60 := z.DecBinary()
		_ = yym60
		if false {
		} else {
			*((*string)(yyv59)) = r.DecodeString()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedServiceAccount = ""
	} else {
		yyv61 := &x.DeprecatedServiceAccount
		yym62 := z.DecBinary()
		_ = yym62
		if false {
		} else {
			*((*string)(yyv61)) = r.DecodeString()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.AutomountServiceAccountToken != nil {
			x.AutomountServiceAccountToken = nil
		}
	} else {
		if x.AutomountServiceAccountToken == nil {
			x.AutomountServiceAccountToken = new(bool)
		}
		yym64 := z.DecBinary()
		_ = yym64
		if false {
		} else {
			*((*bool)(x.AutomountServiceAccountToken)) = r.DecodeBool()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodeName = ""
	} else {
		yyv65 := &x.NodeName
		yym66 := z.DecBinary()
		_ = yym66
		if false {
		} else {
			*((*string)(yyv65)) = r.DecodeString()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostNetwork = false
	} else {
		yyv67 := &x.HostNetwork
		yym68 := z.DecBinary()
		_ = yym68
		if false {
		} else {
			*((*bool)(yyv67)) = r.DecodeBool()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostPID = false
	} else {
		yyv69 := &x.HostPID
		yym70 := z.DecBinary()
		_ = yym70
		if false {
		} else {
			*((*bool)(yyv69)) = r.DecodeBool()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIPC = false
	} else {
		yyv71 := &x.HostIPC
		yym72 := z.DecBinary()
		_ = yym72
		if false {
		} else {
			*((*bool)(yyv71)) = r.DecodeBool()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SecurityContext != nil {
			x.SecurityContext = nil
		}
	} else {
		if x.SecurityContext == nil {
			x.SecurityContext = new(PodSecurityContext)
		}
		x.SecurityContext.CodecDecodeSelf(d)
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ImagePullSecrets = nil
	} else {
		yyv74 := &x.ImagePullSecrets
		yym75 := z.DecBinary()
		_ = yym75
		if false {
		} else {
			h.decSliceLocalObjectReference((*[]LocalObjectReference)(yyv74), d)
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		yyv76 := &x.Hostname
		yym77 := z.DecBinary()
		_ = yym77
		if false {
		} else {
			*((*string)(yyv76)) = r.DecodeString()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Subdomain = ""
	} else {
		yyv78 := &x.Subdomain
		yym79 := z.DecBinary()
		_ = yym79
		if false {
		} else {
			*((*string)(yyv78)) = r.DecodeString()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Affinity != nil {
			x.Affinity = nil
		}
	} else {
		if x.Affinity == nil {
			x.Affinity = new(Affinity)
		}
		x.Affinity.CodecDecodeSelf(d)
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SchedulerName = ""
	} else {
		yyv81 := &x.SchedulerName
		yym82 := z.DecBinary()
		_ = yym82
		if false {
		} else {
			*((*string)(yyv81)) = r.DecodeString()
		}
	}
	yyj44++
	if yyhl44 {
		yyb44 = yyj44 > l
	} else {
		yyb44 = r.CheckBreak()
	}
	if yyb44 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Tolerations = nil
	} else {
		yyv83 := &x.Tolerations
		yym84 := z.DecBinary()
		_ = yym84
		if false {
		} else {
			h.decSliceToleration((*[]Toleration)(yyv83), d)
		}
	}
	for {
		yyj44++
		if yyhl44 {
			yyb44 = yyj44 > l
		} else {
			yyb44 = r.CheckBreak()
		}
		if yyb44 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj44-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodSecurityContext) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.SELinuxOptions != nil
			yyq2[1] = x.RunAsUser != nil
			yyq2[2] = x.RunAsNonRoot != nil
			yyq2[3] = len(x.SupplementalGroups) != 0
			yyq2[4] = x.FSGroup != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("seLinuxOptions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SELinuxOptions == nil {
						r.EncodeNil()
					} else {
						x.SELinuxOptions.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy7 := *x.RunAsUser
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							r.EncodeInt(int64(yy7))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsUser"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsUser == nil {
						r.EncodeNil()
					} else {
						yy9 := *x.RunAsUser
						yym10 := z.EncBinary()
						_ = yym10
						if false {
						} else {
							r.EncodeInt(int64(yy9))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy12 := *x.RunAsNonRoot
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							r.EncodeBool(bool(yy12))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("runAsNonRoot"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.RunAsNonRoot == nil {
						r.EncodeNil()
					} else {
						yy14 := *x.RunAsNonRoot
						yym15 := z.EncBinary()
						_ = yym15
						if false {
						} else {
							r.EncodeBool(bool(yy14))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym17 := z.EncBinary()
						_ = yym17
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("supplementalGroups"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.SupplementalGroups == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							z.F.EncSliceInt64V(x.SupplementalGroups, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy20 := *x.FSGroup
						yym21 := z.EncBinary()
						_ = yym21
						if false {
						} else {
							r.EncodeInt(int64(yy20))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fsGroup"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.FSGroup == nil {
						r.EncodeNil()
					} else {
						yy22 := *x.FSGroup
						yym23 := z.EncBinary()
						_ = yym23
						if false {
						} else {
							r.EncodeInt(int64(yy22))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodSecurityContext) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodSecurityContext) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "seLinuxOptions":
			if r.TryDecodeAsNil() {
				if x.SELinuxOptions != nil {
					x.SELinuxOptions = nil
				}
			} else {
				if x.SELinuxOptions == nil {
					x.SELinuxOptions = new(SELinuxOptions)
				}
				x.SELinuxOptions.CodecDecodeSelf(d)
			}
		case "runAsUser":
			if r.TryDecodeAsNil() {
				if x.RunAsUser != nil {
					x.RunAsUser = nil
				}
			} else {
				if x.RunAsUser == nil {
					x.RunAsUser = new(int64)
				}
				yym6 := z.DecBinary()
				_ = yym6
				if false {
				} else {
					*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
				}
			}
		case "runAsNonRoot":
			if r.TryDecodeAsNil() {
				if x.RunAsNonRoot != nil {
					x.RunAsNonRoot = nil
				}
			} else {
				if x.RunAsNonRoot == nil {
					x.RunAsNonRoot = new(bool)
				}
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else {
					*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
				}
			}
		case "supplementalGroups":
			if r.TryDecodeAsNil() {
				x.SupplementalGroups = nil
			} else {
				yyv9 := &x.SupplementalGroups
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else {
					z.F.DecSliceInt64X(yyv9, false, d)
				}
			}
		case "fsGroup":
			if r.TryDecodeAsNil() {
				if x.FSGroup != nil {
					x.FSGroup = nil
				}
			} else {
				if x.FSGroup == nil {
					x.FSGroup = new(int64)
				}
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodSecurityContext) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.SELinuxOptions != nil {
			x.SELinuxOptions = nil
		}
	} else {
		if x.SELinuxOptions == nil {
			x.SELinuxOptions = new(SELinuxOptions)
		}
		x.SELinuxOptions.CodecDecodeSelf(d)
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsUser != nil {
			x.RunAsUser = nil
		}
	} else {
		if x.RunAsUser == nil {
			x.RunAsUser = new(int64)
		}
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*int64)(x.RunAsUser)) = int64(r.DecodeInt(64))
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.RunAsNonRoot != nil {
			x.RunAsNonRoot = nil
		}
	} else {
		if x.RunAsNonRoot == nil {
			x.RunAsNonRoot = new(bool)
		}
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*bool)(x.RunAsNonRoot)) = r.DecodeBool()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SupplementalGroups = nil
	} else {
		yyv19 := &x.SupplementalGroups
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			z.F.DecSliceInt64X(yyv19, false, d)
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.FSGroup != nil {
			x.FSGroup = nil
		}
	} else {
		if x.FSGroup == nil {
			x.FSGroup = new(int64)
		}
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*int64)(x.FSGroup)) = int64(r.DecodeInt(64))
		}
	}
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = r.CheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj13-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x PodQOSClass) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *PodQOSClass) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *PodStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [10]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Phase != ""
			yyq2[1] = len(x.Conditions) != 0
			yyq2[2] = x.Message != ""
			yyq2[3] = x.Reason != ""
			yyq2[4] = x.HostIP != ""
			yyq2[5] = x.PodIP != ""
			yyq2[6] = x.StartTime != nil
			yyq2[7] = len(x.InitContainerStatuses) != 0
			yyq2[8] = len(x.ContainerStatuses) != 0
			yyq2[9] = x.QOSClass != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(10)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					x.Phase.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("phase"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Phase.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							h.encSlicePodCondition(([]PodCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.HostIP))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("podIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym20 := z.EncBinary()
					_ = yym20
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.PodIP))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym22 := z.EncBinary()
						_ = yym22
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym22 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym22 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("startTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.StartTime == nil {
						r.EncodeNil()
					} else {
						yym23 := z.EncBinary()
						_ = yym23
						if false {
						} else if z.HasExtensions() && z.EncExt(x.StartTime) {
						} else if yym23 {
							z.EncBinaryMarshal(x.StartTime)
						} else if !yym23 && z.IsJSONHandle() {
							z.EncJSONMarshal(x.StartTime)
						} else {
							z.EncFallback(x.StartTime)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					if x.InitContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym25 := z.EncBinary()
						_ = yym25
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.InitContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("initContainerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.InitContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym26 := z.EncBinary()
						_ = yym26
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.InitContainerStatuses), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym28 := z.EncBinary()
						_ = yym28
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("containerStatuses"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ContainerStatuses == nil {
						r.EncodeNil()
					} else {
						yym29 := z.EncBinary()
						_ = yym29
						if false {
						} else {
							h.encSliceContainerStatus(([]ContainerStatus)(x.ContainerStatuses), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					x.QOSClass.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("qosClass"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.QOSClass.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "phase":
			if r.TryDecodeAsNil() {
				x.Phase = ""
			} else {
				yyv4 := &x.Phase
				yyv4.CodecDecodeSelf(d)
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv5 := &x.Conditions
				yym6 := z.DecBinary()
				_ = yym6
				if false {
				} else {
					h.decSlicePodCondition((*[]PodCondition)(yyv5), d)
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				yyv7 := &x.Message
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else {
					*((*string)(yyv7)) = r.DecodeString()
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				yyv9 := &x.Reason
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else {
					*((*string)(yyv9)) = r.DecodeString()
				}
			}
		case "hostIP":
			if r.TryDecodeAsNil() {
				x.HostIP = ""
			} else {
				yyv11 := &x.HostIP
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*string)(yyv11)) = r.DecodeString()
				}
			}
		case "podIP":
			if r.TryDecodeAsNil() {
				x.PodIP = ""
			} else {
				yyv13 := &x.PodIP
				yym14 := z.DecBinary()
				_ = yym14
				if false {
				} else {
					*((*string)(yyv13)) = r.DecodeString()
				}
			}
		case "startTime":
			if r.TryDecodeAsNil() {
				if x.StartTime != nil {
					x.StartTime = nil
				}
			} else {
				if x.StartTime == nil {
					x.StartTime = new(pkg2_v1.Time)
				}
				yym16 := z.DecBinary()
				_ = yym16
				if false {
				} else if z.HasExtensions() && z.DecExt(x.StartTime) {
				} else if yym16 {
					z.DecBinaryUnmarshal(x.StartTime)
				} else if !yym16 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(x.StartTime)
				} else {
					z.DecFallback(x.StartTime, false)
				}
			}
		case "initContainerStatuses":
			if r.TryDecodeAsNil() {
				x.InitContainerStatuses = nil
			} else {
				yyv17 := &x.InitContainerStatuses
				yym18 := z.DecBinary()
				_ = yym18
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv17), d)
				}
			}
		case "containerStatuses":
			if r.TryDecodeAsNil() {
				x.ContainerStatuses = nil
			} else {
				yyv19 := &x.ContainerStatuses
				yym20 := z.DecBinary()
				_ = yym20
				if false {
				} else {
					h.decSliceContainerStatus((*[]ContainerStatus)(yyv19), d)
				}
			}
		case "qosClass":
			if r.TryDecodeAsNil() {
				x.QOSClass = ""
			} else {
				yyv21 := &x.QOSClass
				yyv21.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj22 int
	var yyb22 bool
	var yyhl22 bool = l >= 0
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Phase = ""
	} else {
		yyv23 := &x.Phase
		yyv23.CodecDecodeSelf(d)
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv24 := &x.Conditions
		yym25 := z.DecBinary()
		_ = yym25
		if false {
		} else {
			h.decSlicePodCondition((*[]PodCondition)(yyv24), d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		yyv26 := &x.Message
		yym27 := z.DecBinary()
		_ = yym27
		if false {
		} else {
			*((*string)(yyv26)) = r.DecodeString()
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		yyv28 := &x.Reason
		yym29 := z.DecBinary()
		_ = yym29
		if false {
		} else {
			*((*string)(yyv28)) = r.DecodeString()
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.HostIP = ""
	} else {
		yyv30 := &x.HostIP
		yym31 := z.DecBinary()
		_ = yym31
		if false {
		} else {
			*((*string)(yyv30)) = r.DecodeString()
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.PodIP = ""
	} else {
		yyv32 := &x.PodIP
		yym33 := z.DecBinary()
		_ = yym33
		if false {
		} else {
			*((*string)(yyv32)) = r.DecodeString()
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.StartTime != nil {
			x.StartTime = nil
		}
	} else {
		if x.StartTime == nil {
			x.StartTime = new(pkg2_v1.Time)
		}
		yym35 := z.DecBinary()
		_ = yym35
		if false {
		} else if z.HasExtensions() && z.DecExt(x.StartTime) {
		} else if yym35 {
			z.DecBinaryUnmarshal(x.StartTime)
		} else if !yym35 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(x.StartTime)
		} else {
			z.DecFallback(x.StartTime, false)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.InitContainerStatuses = nil
	} else {
		yyv36 := &x.InitContainerStatuses
		yym37 := z.DecBinary()
		_ = yym37
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv36), d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ContainerStatuses = nil
	} else {
		yyv38 := &x.ContainerStatuses
		yym39 := z.DecBinary()
		_ = yym39
		if false {
		} else {
			h.decSliceContainerStatus((*[]ContainerStatus)(yyv38), d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.QOSClass = ""
	} else {
		yyv40 := &x.QOSClass
		yyv40.CodecDecodeSelf(d)
	}
	for {
		yyj22++
		if yyhl22 {
			yyb22 = yyj22 > l
		} else {
			yyb22 = r.CheckBreak()
		}
		if yyb22 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj22-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodStatusResult) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.Status
					yy15.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Status
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodStatusResult) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodStatusResult) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv8 := &x.ObjectMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv10 := &x.Status
				yyv10.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodStatusResult) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj11 int
	var yyb11 bool
	var yyhl11 bool = l >= 0
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv12 := &x.Kind
		yym13 := z.DecBinary()
		_ = yym13
		if false {
		} else {
			*((*string)(yyv12)) = r.DecodeString()
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv14 := &x.APIVersion
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv16 := &x.ObjectMeta
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv16) {
		} else {
			z.DecFallback(yyv16, false)
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv18 := &x.Status
		yyv18.CodecDecodeSelf(d)
	}
	for {
		yyj11++
		if yyhl11 {
			yyb11 = yyj11 > l
		} else {
			yyb11 = r.CheckBreak()
		}
		if yyb11 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj11-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Pod) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.Spec
					yy15.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Spec
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy20 := &x.Status
					yy20.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy22 := &x.Status
					yy22.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Pod) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Pod) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv8 := &x.ObjectMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv10 := &x.Spec
				yyv10.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = PodStatus{}
			} else {
				yyv11 := &x.Status
				yyv11.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Pod) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv17 := &x.ObjectMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv19 := &x.Spec
		yyv19.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = PodStatus{}
	} else {
		yyv20 := &x.Status
		yyv20.CodecDecodeSelf(d)
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ListMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ListMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSlicePod(([]Pod)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_v1.ListMeta{}
			} else {
				yyv8 := &x.ListMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv10 := &x.Items
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					h.decSlicePod((*[]Pod)(yyv10), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_v1.ListMeta{}
	} else {
		yyv17 := &x.ListMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv19 := &x.Items
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			h.decSlicePod((*[]Pod)(yyv19), d)
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = true
			yyq2[1] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yy4 := &x.ObjectMeta
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else if z.HasExtensions() && z.EncExt(yy4) {
					} else {
						z.EncFallback(yy4)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy6 := &x.ObjectMeta
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else if z.HasExtensions() && z.EncExt(yy6) {
					} else {
						z.EncFallback(yy6)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yy9 := &x.Spec
					yy9.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy11 := &x.Spec
					yy11.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv4 := &x.ObjectMeta
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv4) {
				} else {
					z.DecFallback(yyv4, false)
				}
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = PodSpec{}
			} else {
				yyv6 := &x.Spec
				yyv6.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj7 int
	var yyb7 bool
	var yyhl7 bool = l >= 0
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv8 := &x.ObjectMeta
		yym9 := z.DecBinary()
		_ = yym9
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv8) {
		} else {
			z.DecFallback(yyv8, false)
		}
	}
	yyj7++
	if yyhl7 {
		yyb7 = yyj7 > l
	} else {
		yyb7 = r.CheckBreak()
	}
	if yyb7 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = PodSpec{}
	} else {
		yyv10 := &x.Spec
		yyv10.CodecDecodeSelf(d)
	}
	for {
		yyj7++
		if yyhl7 {
			yyb7 = yyj7 > l
		} else {
			yyb7 = r.CheckBreak()
		}
		if yyb7 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj7-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplate) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.Template
					yy15.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Template
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplate) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplate) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv8 := &x.ObjectMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				x.Template = PodTemplateSpec{}
			} else {
				yyv10 := &x.Template
				yyv10.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplate) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj11 int
	var yyb11 bool
	var yyhl11 bool = l >= 0
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv12 := &x.Kind
		yym13 := z.DecBinary()
		_ = yym13
		if false {
		} else {
			*((*string)(yyv12)) = r.DecodeString()
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv14 := &x.APIVersion
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv16 := &x.ObjectMeta
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv16) {
		} else {
			z.DecFallback(yyv16, false)
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Template = PodTemplateSpec{}
	} else {
		yyv18 := &x.Template
		yyv18.CodecDecodeSelf(d)
	}
	for {
		yyj11++
		if yyhl11 {
			yyb11 = yyj11 > l
		} else {
			yyb11 = r.CheckBreak()
		}
		if yyb11 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj11-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *PodTemplateList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ListMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ListMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSlicePodTemplate(([]PodTemplate)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *PodTemplateList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *PodTemplateList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_v1.ListMeta{}
			} else {
				yyv8 := &x.ListMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv10 := &x.Items
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					h.decSlicePodTemplate((*[]PodTemplate)(yyv10), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *PodTemplateList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_v1.ListMeta{}
	} else {
		yyv17 := &x.ListMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv19 := &x.Items
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			h.decSlicePodTemplate((*[]PodTemplate)(yyv19), d)
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Replicas != nil
			yyq2[1] = x.MinReadySeconds != 0
			yyq2[2] = len(x.Selector) != 0
			yyq2[3] = x.Template != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy4 := *x.Replicas
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							r.EncodeInt(int64(yy4))
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("replicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Replicas == nil {
						r.EncodeNil()
					} else {
						yy6 := *x.Replicas
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							r.EncodeInt(int64(yy6))
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym9 := z.EncBinary()
					_ = yym9
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("minReadySeconds"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeInt(int64(x.MinReadySeconds))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym12 := z.EncBinary()
						_ = yym12
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym13 := z.EncBinary()
						_ = yym13
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("template"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Template == nil {
						r.EncodeNil()
					} else {
						x.Template.CodecEncodeSelf(e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "replicas":
			if r.TryDecodeAsNil() {
				if x.Replicas != nil {
					x.Replicas = nil
				}
			} else {
				if x.Replicas == nil {
					x.Replicas = new(int32)
				}
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
				}
			}
		case "minReadySeconds":
			if r.TryDecodeAsNil() {
				x.MinReadySeconds = 0
			} else {
				yyv6 := &x.MinReadySeconds
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*int32)(yyv6)) = int32(r.DecodeInt(32))
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv8 := &x.Selector
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					z.F.DecMapStringStringX(yyv8, false, d)
				}
			}
		case "template":
			if r.TryDecodeAsNil() {
				if x.Template != nil {
					x.Template = nil
				}
			} else {
				if x.Template == nil {
					x.Template = new(PodTemplateSpec)
				}
				x.Template.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj11 int
	var yyb11 bool
	var yyhl11 bool = l >= 0
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Replicas != nil {
			x.Replicas = nil
		}
	} else {
		if x.Replicas == nil {
			x.Replicas = new(int32)
		}
		yym13 := z.DecBinary()
		_ = yym13
		if false {
		} else {
			*((*int32)(x.Replicas)) = int32(r.DecodeInt(32))
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.MinReadySeconds = 0
	} else {
		yyv14 := &x.MinReadySeconds
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*int32)(yyv14)) = int32(r.DecodeInt(32))
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv16 := &x.Selector
		yym17 := z.DecBinary()
		_ = yym17
		if false {
		} else {
			z.F.DecMapStringStringX(yyv16, false, d)
		}
	}
	yyj11++
	if yyhl11 {
		yyb11 = yyj11 > l
	} else {
		yyb11 = r.CheckBreak()
	}
	if yyb11 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		if x.Template != nil {
			x.Template = nil
		}
	} else {
		if x.Template == nil {
			x.Template = new(PodTemplateSpec)
		}
		x.Template.CodecDecodeSelf(d)
	}
	for {
		yyj11++
		if yyhl11 {
			yyb11 = yyj11 > l
		} else {
			yyb11 = r.CheckBreak()
		}
		if yyb11 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj11-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [6]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[1] = x.FullyLabeledReplicas != 0
			yyq2[2] = x.ReadyReplicas != 0
			yyq2[3] = x.AvailableReplicas != 0
			yyq2[4] = x.ObservedGeneration != 0
			yyq2[5] = len(x.Conditions) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(6)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym4 := z.EncBinary()
				_ = yym4
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("replicas"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym5 := z.EncBinary()
				_ = yym5
				if false {
				} else {
					r.EncodeInt(int64(x.Replicas))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("fullyLabeledReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeInt(int64(x.FullyLabeledReplicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("readyReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeInt(int64(x.ReadyReplicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("availableReplicas"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else {
						r.EncodeInt(int64(x.AvailableReplicas))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("observedGeneration"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym17 := z.EncBinary()
					_ = yym17
					if false {
					} else {
						r.EncodeInt(int64(x.ObservedGeneration))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							h.encSliceReplicationControllerCondition(([]ReplicationControllerCondition)(x.Conditions), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("conditions"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Conditions == nil {
						r.EncodeNil()
					} else {
						yym20 := z.EncBinary()
						_ = yym20
						if false {
						} else {
							h.encSliceReplicationControllerCondition(([]ReplicationControllerCondition)(x.Conditions), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "replicas":
			if r.TryDecodeAsNil() {
				x.Replicas = 0
			} else {
				yyv4 := &x.Replicas
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*int32)(yyv4)) = int32(r.DecodeInt(32))
				}
			}
		case "fullyLabeledReplicas":
			if r.TryDecodeAsNil() {
				x.FullyLabeledReplicas = 0
			} else {
				yyv6 := &x.FullyLabeledReplicas
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*int32)(yyv6)) = int32(r.DecodeInt(32))
				}
			}
		case "readyReplicas":
			if r.TryDecodeAsNil() {
				x.ReadyReplicas = 0
			} else {
				yyv8 := &x.ReadyReplicas
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*int32)(yyv8)) = int32(r.DecodeInt(32))
				}
			}
		case "availableReplicas":
			if r.TryDecodeAsNil() {
				x.AvailableReplicas = 0
			} else {
				yyv10 := &x.AvailableReplicas
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*int32)(yyv10)) = int32(r.DecodeInt(32))
				}
			}
		case "observedGeneration":
			if r.TryDecodeAsNil() {
				x.ObservedGeneration = 0
			} else {
				yyv12 := &x.ObservedGeneration
				yym13 := z.DecBinary()
				_ = yym13
				if false {
				} else {
					*((*int64)(yyv12)) = int64(r.DecodeInt(64))
				}
			}
		case "conditions":
			if r.TryDecodeAsNil() {
				x.Conditions = nil
			} else {
				yyv14 := &x.Conditions
				yym15 := z.DecBinary()
				_ = yym15
				if false {
				} else {
					h.decSliceReplicationControllerCondition((*[]ReplicationControllerCondition)(yyv14), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj16 int
	var yyb16 bool
	var yyhl16 bool = l >= 0
	yyj16++
	if yyhl16 {
		yyb16 = yyj16 > l
	} else {
		yyb16 = r.CheckBreak()
	}
	if yyb16 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Replicas = 0
	} else {
		yyv17 := &x.Replicas
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*int32)(yyv17)) = int32(r.DecodeInt(32))
		}
	}
	yyj16++
	if yyhl16 {
		yyb16 = yyj16 > l
	} else {
		yyb16 = r.CheckBreak()
	}
	if yyb16 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.FullyLabeledReplicas = 0
	} else {
		yyv19 := &x.FullyLabeledReplicas
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*int32)(yyv19)) = int32(r.DecodeInt(32))
		}
	}
	yyj16++
	if yyhl16 {
		yyb16 = yyj16 > l
	} else {
		yyb16 = r.CheckBreak()
	}
	if yyb16 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ReadyReplicas = 0
	} else {
		yyv21 := &x.ReadyReplicas
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*int32)(yyv21)) = int32(r.DecodeInt(32))
		}
	}
	yyj16++
	if yyhl16 {
		yyb16 = yyj16 > l
	} else {
		yyb16 = r.CheckBreak()
	}
	if yyb16 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.AvailableReplicas = 0
	} else {
		yyv23 := &x.AvailableReplicas
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			*((*int32)(yyv23)) = int32(r.DecodeInt(32))
		}
	}
	yyj16++
	if yyhl16 {
		yyb16 = yyj16 > l
	} else {
		yyb16 = r.CheckBreak()
	}
	if yyb16 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObservedGeneration = 0
	} else {
		yyv25 := &x.ObservedGeneration
		yym26 := z.DecBinary()
		_ = yym26
		if false {
		} else {
			*((*int64)(yyv25)) = int64(r.DecodeInt(64))
		}
	}
	yyj16++
	if yyhl16 {
		yyb16 = yyj16 > l
	} else {
		yyb16 = r.CheckBreak()
	}
	if yyb16 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Conditions = nil
	} else {
		yyv27 := &x.Conditions
		yym28 := z.DecBinary()
		_ = yym28
		if false {
		} else {
			h.decSliceReplicationControllerCondition((*[]ReplicationControllerCondition)(yyv27), d)
		}
	}
	for {
		yyj16++
		if yyhl16 {
			yyb16 = yyj16 > l
		} else {
			yyb16 = r.CheckBreak()
		}
		if yyb16 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj16-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ReplicationControllerConditionType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ReplicationControllerConditionType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ReplicationControllerCondition) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[2] = true
			yyq2[3] = x.Reason != ""
			yyq2[4] = x.Message != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 2
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Type.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("type"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Type.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				x.Status.CodecEncodeSelf(e)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("status"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				x.Status.CodecEncodeSelf(e)
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.LastTransitionTime
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else if yym11 {
						z.EncBinaryMarshal(yy10)
					} else if !yym11 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy10)
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("lastTransitionTime"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.LastTransitionTime
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else if yym13 {
						z.EncBinaryMarshal(yy12)
					} else if !yym13 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy12)
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("reason"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Reason))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym18 := z.EncBinary()
					_ = yym18
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("message"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Message))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerCondition) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerCondition) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				yyv4 := &x.Type
				yyv4.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ""
			} else {
				yyv5 := &x.Status
				yyv5.CodecDecodeSelf(d)
			}
		case "lastTransitionTime":
			if r.TryDecodeAsNil() {
				x.LastTransitionTime = pkg2_v1.Time{}
			} else {
				yyv6 := &x.LastTransitionTime
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv6) {
				} else if yym7 {
					z.DecBinaryUnmarshal(yyv6)
				} else if !yym7 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv6)
				} else {
					z.DecFallback(yyv6, false)
				}
			}
		case "reason":
			if r.TryDecodeAsNil() {
				x.Reason = ""
			} else {
				yyv8 := &x.Reason
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "message":
			if r.TryDecodeAsNil() {
				x.Message = ""
			} else {
				yyv10 := &x.Message
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					*((*string)(yyv10)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerCondition) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		yyv13 := &x.Type
		yyv13.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ""
	} else {
		yyv14 := &x.Status
		yyv14.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LastTransitionTime = pkg2_v1.Time{}
	} else {
		yyv15 := &x.LastTransitionTime
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv15) {
		} else if yym16 {
			z.DecBinaryUnmarshal(yyv15)
		} else if !yym16 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv15)
		} else {
			z.DecFallback(yyv15, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Reason = ""
	} else {
		yyv17 := &x.Reason
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*string)(yyv17)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Message = ""
	} else {
		yyv19 := &x.Message
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			*((*string)(yyv19)) = r.DecodeString()
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationController) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.Spec
					yy15.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Spec
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy20 := &x.Status
					yy20.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy22 := &x.Status
					yy22.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationController) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationController) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv8 := &x.ObjectMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ReplicationControllerSpec{}
			} else {
				yyv10 := &x.Spec
				yyv10.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ReplicationControllerStatus{}
			} else {
				yyv11 := &x.Status
				yyv11.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationController) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv17 := &x.ObjectMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ReplicationControllerSpec{}
	} else {
		yyv19 := &x.Spec
		yyv19.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ReplicationControllerStatus{}
	} else {
		yyv20 := &x.Status
		yyv20.CodecDecodeSelf(d)
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ReplicationControllerList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ListMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ListMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSliceReplicationController(([]ReplicationController)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ReplicationControllerList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ReplicationControllerList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_v1.ListMeta{}
			} else {
				yyv8 := &x.ListMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv10 := &x.Items
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					h.decSliceReplicationController((*[]ReplicationController)(yyv10), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ReplicationControllerList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_v1.ListMeta{}
	} else {
		yyv17 := &x.ListMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv19 := &x.Items
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			h.decSliceReplicationController((*[]ReplicationController)(yyv19), d)
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x ServiceAffinity) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceAffinity) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x ServiceType) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	yym1 := z.EncBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.EncExt(x) {
	} else {
		r.EncodeString(codecSelferC_UTF81234, string(x))
	}
}

func (x *ServiceType) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		*((*string)(x)) = r.DecodeString()
	}
}

func (x *ServiceStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yy4 := &x.LoadBalancer
					yy4.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancer"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy6 := &x.LoadBalancer
					yy6.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "loadBalancer":
			if r.TryDecodeAsNil() {
				x.LoadBalancer = LoadBalancerStatus{}
			} else {
				yyv4 := &x.LoadBalancer
				yyv4.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj5 int
	var yyb5 bool
	var yyhl5 bool = l >= 0
	yyj5++
	if yyhl5 {
		yyb5 = yyj5 > l
	} else {
		yyb5 = r.CheckBreak()
	}
	if yyb5 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancer = LoadBalancerStatus{}
	} else {
		yyv6 := &x.LoadBalancer
		yyv6.CodecDecodeSelf(d)
	}
	for {
		yyj5++
		if yyhl5 {
			yyb5 = yyj5 > l
		} else {
			yyb5 = r.CheckBreak()
		}
		if yyb5 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj5-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerStatus) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [1]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.Ingress) != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(1)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ingress"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ingress == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							h.encSliceLoadBalancerIngress(([]LoadBalancerIngress)(x.Ingress), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerStatus) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerStatus) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "ingress":
			if r.TryDecodeAsNil() {
				x.Ingress = nil
			} else {
				yyv4 := &x.Ingress
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv4), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerStatus) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj6 int
	var yyb6 bool
	var yyhl6 bool = l >= 0
	yyj6++
	if yyhl6 {
		yyb6 = yyj6 > l
	} else {
		yyb6 = r.CheckBreak()
	}
	if yyb6 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ingress = nil
	} else {
		yyv7 := &x.Ingress
		yym8 := z.DecBinary()
		_ = yym8
		if false {
		} else {
			h.decSliceLoadBalancerIngress((*[]LoadBalancerIngress)(yyv7), d)
		}
	}
	for {
		yyj6++
		if yyhl6 {
			yyb6 = yyj6 > l
		} else {
			yyb6 = r.CheckBreak()
		}
		if yyb6 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj6-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *LoadBalancerIngress) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [2]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.IP != ""
			yyq2[1] = x.Hostname != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(2)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ip"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.IP))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("hostname"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Hostname))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *LoadBalancerIngress) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *LoadBalancerIngress) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "ip":
			if r.TryDecodeAsNil() {
				x.IP = ""
			} else {
				yyv4 := &x.IP
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "hostname":
			if r.TryDecodeAsNil() {
				x.Hostname = ""
			} else {
				yyv6 := &x.Hostname
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *LoadBalancerIngress) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj8 int
	var yyb8 bool
	var yyhl8 bool = l >= 0
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.IP = ""
	} else {
		yyv9 := &x.IP
		yym10 := z.DecBinary()
		_ = yym10
		if false {
		} else {
			*((*string)(yyv9)) = r.DecodeString()
		}
	}
	yyj8++
	if yyhl8 {
		yyb8 = yyj8 > l
	} else {
		yyb8 = r.CheckBreak()
	}
	if yyb8 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Hostname = ""
	} else {
		yyv11 := &x.Hostname
		yym12 := z.DecBinary()
		_ = yym12
		if false {
		} else {
			*((*string)(yyv11)) = r.DecodeString()
		}
	}
	for {
		yyj8++
		if yyhl8 {
			yyb8 = yyj8 > l
		} else {
			yyb8 = r.CheckBreak()
		}
		if yyb8 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj8-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceSpec) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [10]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = len(x.Ports) != 0
			yyq2[1] = len(x.Selector) != 0
			yyq2[2] = x.ClusterIP != ""
			yyq2[3] = x.Type != ""
			yyq2[4] = len(x.ExternalIPs) != 0
			yyq2[5] = len(x.DeprecatedPublicIPs) != 0
			yyq2[6] = x.SessionAffinity != ""
			yyq2[7] = x.LoadBalancerIP != ""
			yyq2[8] = len(x.LoadBalancerSourceRanges) != 0
			yyq2[9] = x.ExternalName != ""
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(10)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym4 := z.EncBinary()
						_ = yym4
						if false {
						} else {
							h.encSliceServicePort(([]ServicePort)(x.Ports), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("ports"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Ports == nil {
						r.EncodeNil()
					} else {
						yym5 := z.EncBinary()
						_ = yym5
						if false {
						} else {
							h.encSliceServicePort(([]ServicePort)(x.Ports), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym7 := z.EncBinary()
						_ = yym7
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("selector"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Selector == nil {
						r.EncodeNil()
					} else {
						yym8 := z.EncBinary()
						_ = yym8
						if false {
						} else {
							z.F.EncMapStringStringV(x.Selector, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yym10 := z.EncBinary()
					_ = yym10
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("clusterIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ClusterIP))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					x.Type.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("type"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Type.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ExternalIPs == nil {
						r.EncodeNil()
					} else {
						yym17 := z.EncBinary()
						_ = yym17
						if false {
						} else {
							z.F.EncSliceStringV(x.ExternalIPs, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[5] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("deprecatedPublicIPs"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.DeprecatedPublicIPs == nil {
						r.EncodeNil()
					} else {
						yym20 := z.EncBinary()
						_ = yym20
						if false {
						} else {
							z.F.EncSliceStringV(x.DeprecatedPublicIPs, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[6] {
					x.SessionAffinity.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[6] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("sessionAffinity"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.SessionAffinity.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[7] {
					yym25 := z.EncBinary()
					_ = yym25
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[7] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerIP"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym26 := z.EncBinary()
					_ = yym26
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.LoadBalancerIP))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[8] {
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym28 := z.EncBinary()
						_ = yym28
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[8] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("loadBalancerSourceRanges"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.LoadBalancerSourceRanges == nil {
						r.EncodeNil()
					} else {
						yym29 := z.EncBinary()
						_ = yym29
						if false {
						} else {
							z.F.EncSliceStringV(x.LoadBalancerSourceRanges, false, e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[9] {
					yym31 := z.EncBinary()
					_ = yym31
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[9] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("externalName"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym32 := z.EncBinary()
					_ = yym32
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.ExternalName))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceSpec) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceSpec) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "ports":
			if r.TryDecodeAsNil() {
				x.Ports = nil
			} else {
				yyv4 := &x.Ports
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					h.decSliceServicePort((*[]ServicePort)(yyv4), d)
				}
			}
		case "selector":
			if r.TryDecodeAsNil() {
				x.Selector = nil
			} else {
				yyv6 := &x.Selector
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					z.F.DecMapStringStringX(yyv6, false, d)
				}
			}
		case "clusterIP":
			if r.TryDecodeAsNil() {
				x.ClusterIP = ""
			} else {
				yyv8 := &x.ClusterIP
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else {
					*((*string)(yyv8)) = r.DecodeString()
				}
			}
		case "type":
			if r.TryDecodeAsNil() {
				x.Type = ""
			} else {
				yyv10 := &x.Type
				yyv10.CodecDecodeSelf(d)
			}
		case "externalIPs":
			if r.TryDecodeAsNil() {
				x.ExternalIPs = nil
			} else {
				yyv11 := &x.ExternalIPs
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					z.F.DecSliceStringX(yyv11, false, d)
				}
			}
		case "deprecatedPublicIPs":
			if r.TryDecodeAsNil() {
				x.DeprecatedPublicIPs = nil
			} else {
				yyv13 := &x.DeprecatedPublicIPs
				yym14 := z.DecBinary()
				_ = yym14
				if false {
				} else {
					z.F.DecSliceStringX(yyv13, false, d)
				}
			}
		case "sessionAffinity":
			if r.TryDecodeAsNil() {
				x.SessionAffinity = ""
			} else {
				yyv15 := &x.SessionAffinity
				yyv15.CodecDecodeSelf(d)
			}
		case "loadBalancerIP":
			if r.TryDecodeAsNil() {
				x.LoadBalancerIP = ""
			} else {
				yyv16 := &x.LoadBalancerIP
				yym17 := z.DecBinary()
				_ = yym17
				if false {
				} else {
					*((*string)(yyv16)) = r.DecodeString()
				}
			}
		case "loadBalancerSourceRanges":
			if r.TryDecodeAsNil() {
				x.LoadBalancerSourceRanges = nil
			} else {
				yyv18 := &x.LoadBalancerSourceRanges
				yym19 := z.DecBinary()
				_ = yym19
				if false {
				} else {
					z.F.DecSliceStringX(yyv18, false, d)
				}
			}
		case "externalName":
			if r.TryDecodeAsNil() {
				x.ExternalName = ""
			} else {
				yyv20 := &x.ExternalName
				yym21 := z.DecBinary()
				_ = yym21
				if false {
				} else {
					*((*string)(yyv20)) = r.DecodeString()
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceSpec) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj22 int
	var yyb22 bool
	var yyhl22 bool = l >= 0
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Ports = nil
	} else {
		yyv23 := &x.Ports
		yym24 := z.DecBinary()
		_ = yym24
		if false {
		} else {
			h.decSliceServicePort((*[]ServicePort)(yyv23), d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Selector = nil
	} else {
		yyv25 := &x.Selector
		yym26 := z.DecBinary()
		_ = yym26
		if false {
		} else {
			z.F.DecMapStringStringX(yyv25, false, d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ClusterIP = ""
	} else {
		yyv27 := &x.ClusterIP
		yym28 := z.DecBinary()
		_ = yym28
		if false {
		} else {
			*((*string)(yyv27)) = r.DecodeString()
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Type = ""
	} else {
		yyv29 := &x.Type
		yyv29.CodecDecodeSelf(d)
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalIPs = nil
	} else {
		yyv30 := &x.ExternalIPs
		yym31 := z.DecBinary()
		_ = yym31
		if false {
		} else {
			z.F.DecSliceStringX(yyv30, false, d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.DeprecatedPublicIPs = nil
	} else {
		yyv32 := &x.DeprecatedPublicIPs
		yym33 := z.DecBinary()
		_ = yym33
		if false {
		} else {
			z.F.DecSliceStringX(yyv32, false, d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.SessionAffinity = ""
	} else {
		yyv34 := &x.SessionAffinity
		yyv34.CodecDecodeSelf(d)
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerIP = ""
	} else {
		yyv35 := &x.LoadBalancerIP
		yym36 := z.DecBinary()
		_ = yym36
		if false {
		} else {
			*((*string)(yyv35)) = r.DecodeString()
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.LoadBalancerSourceRanges = nil
	} else {
		yyv37 := &x.LoadBalancerSourceRanges
		yym38 := z.DecBinary()
		_ = yym38
		if false {
		} else {
			z.F.DecSliceStringX(yyv37, false, d)
		}
	}
	yyj22++
	if yyhl22 {
		yyb22 = yyj22 > l
	} else {
		yyb22 = r.CheckBreak()
	}
	if yyb22 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ExternalName = ""
	} else {
		yyv39 := &x.ExternalName
		yym40 := z.DecBinary()
		_ = yym40
		if false {
		} else {
			*((*string)(yyv39)) = r.DecodeString()
		}
	}
	for {
		yyj22++
		if yyhl22 {
			yyb22 = yyj22 > l
		} else {
			yyb22 = r.CheckBreak()
		}
		if yyb22 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj22-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServicePort) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Name != ""
			yyq2[1] = x.Protocol != ""
			yyq2[3] = true
			yyq2[4] = x.NodePort != 0
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("name"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Name))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					x.Protocol.CodecEncodeSelf(e)
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("protocol"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					x.Protocol.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				yym10 := z.EncBinary()
				_ = yym10
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("port"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				yym11 := z.EncBinary()
				_ = yym11
				if false {
				} else {
					r.EncodeInt(int64(x.Port))
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy13 := &x.TargetPort
					yym14 := z.EncBinary()
					_ = yym14
					if false {
					} else if z.HasExtensions() && z.EncExt(yy13) {
					} else if !yym14 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy13)
					} else {
						z.EncFallback(yy13)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("targetPort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy15 := &x.TargetPort
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else if z.HasExtensions() && z.EncExt(yy15) {
					} else if !yym16 && z.IsJSONHandle() {
						z.EncJSONMarshal(yy15)
					} else {
						z.EncFallback(yy15)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yym18 := z.EncBinary()
					_ = yym18
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				} else {
					r.EncodeInt(0)
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("nodePort"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym19 := z.EncBinary()
					_ = yym19
					if false {
					} else {
						r.EncodeInt(int64(x.NodePort))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServicePort) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServicePort) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "name":
			if r.TryDecodeAsNil() {
				x.Name = ""
			} else {
				yyv4 := &x.Name
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "protocol":
			if r.TryDecodeAsNil() {
				x.Protocol = ""
			} else {
				yyv6 := &x.Protocol
				yyv6.CodecDecodeSelf(d)
			}
		case "port":
			if r.TryDecodeAsNil() {
				x.Port = 0
			} else {
				yyv7 := &x.Port
				yym8 := z.DecBinary()
				_ = yym8
				if false {
				} else {
					*((*int32)(yyv7)) = int32(r.DecodeInt(32))
				}
			}
		case "targetPort":
			if r.TryDecodeAsNil() {
				x.TargetPort = pkg4_intstr.IntOrString{}
			} else {
				yyv9 := &x.TargetPort
				yym10 := z.DecBinary()
				_ = yym10
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv9) {
				} else if !yym10 && z.IsJSONHandle() {
					z.DecJSONUnmarshal(yyv9)
				} else {
					z.DecFallback(yyv9, false)
				}
			}
		case "nodePort":
			if r.TryDecodeAsNil() {
				x.NodePort = 0
			} else {
				yyv11 := &x.NodePort
				yym12 := z.DecBinary()
				_ = yym12
				if false {
				} else {
					*((*int32)(yyv11)) = int32(r.DecodeInt(32))
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServicePort) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj13 int
	var yyb13 bool
	var yyhl13 bool = l >= 0
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Name = ""
	} else {
		yyv14 := &x.Name
		yym15 := z.DecBinary()
		_ = yym15
		if false {
		} else {
			*((*string)(yyv14)) = r.DecodeString()
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Protocol = ""
	} else {
		yyv16 := &x.Protocol
		yyv16.CodecDecodeSelf(d)
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Port = 0
	} else {
		yyv17 := &x.Port
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else {
			*((*int32)(yyv17)) = int32(r.DecodeInt(32))
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.TargetPort = pkg4_intstr.IntOrString{}
	} else {
		yyv19 := &x.TargetPort
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv19) {
		} else if !yym20 && z.IsJSONHandle() {
			z.DecJSONUnmarshal(yyv19)
		} else {
			z.DecFallback(yyv19, false)
		}
	}
	yyj13++
	if yyhl13 {
		yyb13 = yyj13 > l
	} else {
		yyb13 = r.CheckBreak()
	}
	if yyb13 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.NodePort = 0
	} else {
		yyv21 := &x.NodePort
		yym22 := z.DecBinary()
		_ = yym22
		if false {
		} else {
			*((*int32)(yyv21)) = int32(r.DecodeInt(32))
		}
	}
	for {
		yyj13++
		if yyhl13 {
			yyb13 = yyj13 > l
		} else {
			yyb13 = r.CheckBreak()
		}
		if yyb13 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj13-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *Service) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [5]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = true
			yyq2[4] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(5)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					yy15 := &x.Spec
					yy15.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("spec"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy17 := &x.Spec
					yy17.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					yy20 := &x.Status
					yy20.CodecEncodeSelf(e)
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("status"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy22 := &x.Status
					yy22.CodecEncodeSelf(e)
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *Service) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *Service) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ObjectMeta = pkg2_v1.ObjectMeta{}
			} else {
				yyv8 := &x.ObjectMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "spec":
			if r.TryDecodeAsNil() {
				x.Spec = ServiceSpec{}
			} else {
				yyv10 := &x.Spec
				yyv10.CodecDecodeSelf(d)
			}
		case "status":
			if r.TryDecodeAsNil() {
				x.Status = ServiceStatus{}
			} else {
				yyv11 := &x.Status
				yyv11.CodecDecodeSelf(d)
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *Service) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ObjectMeta = pkg2_v1.ObjectMeta{}
	} else {
		yyv17 := &x.ObjectMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Spec = ServiceSpec{}
	} else {
		yyv19 := &x.Spec
		yyv19.CodecDecodeSelf(d)
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Status = ServiceStatus{}
	} else {
		yyv20 := &x.Status
		yyv20.CodecDecodeSelf(d)
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceList) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [4]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(4)
			} else {
				yynn2 = 1
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ListMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ListMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym15 := z.EncBinary()
					_ = yym15
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			} else {
				z.EncSendContainerState(codecSelfer_containerMapKey1234)
				r.EncodeString(codecSelferC_UTF81234, string("items"))
				z.EncSendContainerState(codecSelfer_containerMapValue1234)
				if x.Items == nil {
					r.EncodeNil()
				} else {
					yym16 := z.EncBinary()
					_ = yym16
					if false {
					} else {
						h.encSliceService(([]Service)(x.Items), e)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				z.EncSendContainerState(codecSelfer_containerMapEnd1234)
			}
		}
	}
}

func (x *ServiceList) CodecDecodeSelf(d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	yym1 := z.DecBinary()
	_ = yym1
	if false {
	} else if z.HasExtensions() && z.DecExt(x) {
	} else {
		yyct2 := r.ContainerType()
		if yyct2 == codecSelferValueTypeMap1234 {
			yyl2 := r.ReadMapStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerMapEnd1234)
			} else {
				x.codecDecodeSelfFromMap(yyl2, d)
			}
		} else if yyct2 == codecSelferValueTypeArray1234 {
			yyl2 := r.ReadArrayStart()
			if yyl2 == 0 {
				z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
			} else {
				x.codecDecodeSelfFromArray(yyl2, d)
			}
		} else {
			panic(codecSelferOnlyMapOrArrayEncodeToStructErr1234)
		}
	}
}

func (x *ServiceList) codecDecodeSelfFromMap(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yys3Slc = z.DecScratchBuffer() // default slice to decode into
	_ = yys3Slc
	var yyhl3 bool = l >= 0
	for yyj3 := 0; ; yyj3++ {
		if yyhl3 {
			if yyj3 >= l {
				break
			}
		} else {
			if r.CheckBreak() {
				break
			}
		}
		z.DecSendContainerState(codecSelfer_containerMapKey1234)
		yys3Slc = r.DecodeBytes(yys3Slc, true, true)
		yys3 := string(yys3Slc)
		z.DecSendContainerState(codecSelfer_containerMapValue1234)
		switch yys3 {
		case "kind":
			if r.TryDecodeAsNil() {
				x.Kind = ""
			} else {
				yyv4 := &x.Kind
				yym5 := z.DecBinary()
				_ = yym5
				if false {
				} else {
					*((*string)(yyv4)) = r.DecodeString()
				}
			}
		case "apiVersion":
			if r.TryDecodeAsNil() {
				x.APIVersion = ""
			} else {
				yyv6 := &x.APIVersion
				yym7 := z.DecBinary()
				_ = yym7
				if false {
				} else {
					*((*string)(yyv6)) = r.DecodeString()
				}
			}
		case "metadata":
			if r.TryDecodeAsNil() {
				x.ListMeta = pkg2_v1.ListMeta{}
			} else {
				yyv8 := &x.ListMeta
				yym9 := z.DecBinary()
				_ = yym9
				if false {
				} else if z.HasExtensions() && z.DecExt(yyv8) {
				} else {
					z.DecFallback(yyv8, false)
				}
			}
		case "items":
			if r.TryDecodeAsNil() {
				x.Items = nil
			} else {
				yyv10 := &x.Items
				yym11 := z.DecBinary()
				_ = yym11
				if false {
				} else {
					h.decSliceService((*[]Service)(yyv10), d)
				}
			}
		default:
			z.DecStructFieldNotFound(-1, yys3)
		} // end switch yys3
	} // end for yyj3
	z.DecSendContainerState(codecSelfer_containerMapEnd1234)
}

func (x *ServiceList) codecDecodeSelfFromArray(l int, d *codec1978.Decoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperDecoder(d)
	_, _, _ = h, z, r
	var yyj12 int
	var yyb12 bool
	var yyhl12 bool = l >= 0
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Kind = ""
	} else {
		yyv13 := &x.Kind
		yym14 := z.DecBinary()
		_ = yym14
		if false {
		} else {
			*((*string)(yyv13)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.APIVersion = ""
	} else {
		yyv15 := &x.APIVersion
		yym16 := z.DecBinary()
		_ = yym16
		if false {
		} else {
			*((*string)(yyv15)) = r.DecodeString()
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.ListMeta = pkg2_v1.ListMeta{}
	} else {
		yyv17 := &x.ListMeta
		yym18 := z.DecBinary()
		_ = yym18
		if false {
		} else if z.HasExtensions() && z.DecExt(yyv17) {
		} else {
			z.DecFallback(yyv17, false)
		}
	}
	yyj12++
	if yyhl12 {
		yyb12 = yyj12 > l
	} else {
		yyb12 = r.CheckBreak()
	}
	if yyb12 {
		z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
		return
	}
	z.DecSendContainerState(codecSelfer_containerArrayElem1234)
	if r.TryDecodeAsNil() {
		x.Items = nil
	} else {
		yyv19 := &x.Items
		yym20 := z.DecBinary()
		_ = yym20
		if false {
		} else {
			h.decSliceService((*[]Service)(yyv19), d)
		}
	}
	for {
		yyj12++
		if yyhl12 {
			yyb12 = yyj12 > l
		} else {
			yyb12 = r.CheckBreak()
		}
		if yyb12 {
			break
		}
		z.DecSendContainerState(codecSelfer_containerArrayElem1234)
		z.DecStructFieldNotFound(yyj12-1, "")
	}
	z.DecSendContainerState(codecSelfer_containerArrayEnd1234)
}

func (x *ServiceAccount) CodecEncodeSelf(e *codec1978.Encoder) {
	var h codecSelfer1234
	z, r := codec1978.GenHelperEncoder(e)
	_, _, _ = h, z, r
	if x == nil {
		r.EncodeNil()
	} else {
		yym1 := z.EncBinary()
		_ = yym1
		if false {
		} else if z.HasExtensions() && z.EncExt(x) {
		} else {
			yysep2 := !z.EncBinary()
			yy2arr2 := z.EncBasicHandle().StructToArray
			var yyq2 [6]bool
			_, _, _ = yysep2, yyq2, yy2arr2
			const yyr2 bool = false
			yyq2[0] = x.Kind != ""
			yyq2[1] = x.APIVersion != ""
			yyq2[2] = true
			yyq2[3] = len(x.Secrets) != 0
			yyq2[4] = len(x.ImagePullSecrets) != 0
			yyq2[5] = x.AutomountServiceAccountToken != nil
			var yynn2 int
			if yyr2 || yy2arr2 {
				r.EncodeArrayStart(6)
			} else {
				yynn2 = 0
				for _, b := range yyq2 {
					if b {
						yynn2++
					}
				}
				r.EncodeMapStart(yynn2)
				yynn2 = 0
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[0] {
					yym4 := z.EncBinary()
					_ = yym4
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[0] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("kind"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym5 := z.EncBinary()
					_ = yym5
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.Kind))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[1] {
					yym7 := z.EncBinary()
					_ = yym7
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				} else {
					r.EncodeString(codecSelferC_UTF81234, "")
				}
			} else {
				if yyq2[1] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("apiVersion"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yym8 := z.EncBinary()
					_ = yym8
					if false {
					} else {
						r.EncodeString(codecSelferC_UTF81234, string(x.APIVersion))
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[2] {
					yy10 := &x.ObjectMeta
					yym11 := z.EncBinary()
					_ = yym11
					if false {
					} else if z.HasExtensions() && z.EncExt(yy10) {
					} else {
						z.EncFallback(yy10)
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[2] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("metadata"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					yy12 := &x.ObjectMeta
					yym13 := z.EncBinary()
					_ = yym13
					if false {
					} else if z.HasExtensions() && z.EncExt(yy12) {
					} else {
						z.EncFallback(yy12)
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[3] {
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym15 := z.EncBinary()
						_ = yym15
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[3] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("secrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.Secrets == nil {
						r.EncodeNil()
					} else {
						yym16 := z.EncBinary()
						_ = yym16
						if false {
						} else {
							h.encSliceObjectReference(([]ObjectReference)(x.Secrets), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[4] {
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym18 := z.EncBinary()
						_ = yym18
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				} else {
					r.EncodeNil()
				}
			} else {
				if yyq2[4] {
					z.EncSendContainerState(codecSelfer_containerMapKey1234)
					r.EncodeString(codecSelferC_UTF81234, string("imagePullSecrets"))
					z.EncSendContainerState(codecSelfer_containerMapValue1234)
					if x.ImagePullSecrets == nil {
						r.EncodeNil()
					} else {
						yym19 := z.EncBinary()
						_ = yym19
						if false {
						} else {
							h.encSliceLocalObjectReference(([]LocalObjectReference)(x.ImagePullSecrets), e)
						}
					}
				}
			}
			if yyr2 || yy2arr2 {
				z.EncSendContainerState(codecSelfer_containerArrayElem1234)
				if yyq2[5] {
					if x.AutomountServiceAccountToken == nil {
						r.EncodeNil()
					} else {
						yy21 := *x.AutomountServiceAccountToken
						yym22 := z.EncBina