// ----------------------------------------------------------------------------
// cw.h  --  morse code modem
//
// Copyright (C) 2006
//		Dave Freese, W1HKJ
//
// This file is part of fldigi.  Adapted from code contained in gmfsk source code 
// distribution.
//  gmfsk Copyright (C) 2001, 2002, 2003
//  Tomi Manninen (oh2bns@sral.fi)
//  Copyright (C) 2004
//  Lawrence Glaister (ve7it@shaw.ca)
//
// fldigi is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// fldigi is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with fldigi; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
// ----------------------------------------------------------------------------

#ifndef _CW_H
#define _CW_H

//#include "complex.h"
#include "modem.h"
#include "filters.h"
#include "morse.h"

#define	CWSampleRate	8000
#define	CWMaxSymLen		4096

// decimation ratio for the receiver 
//1024	// length of FIR filter
#define	DEC_RATIO	8		
#define CW_FIRLEN   128      
//#define CW_FIRLEN	  256
//#define CW_FIRLEN   512
// Limits on values of CW send and timing parameters 
#define	CW_MIN_SPEED		1	// Lowest WPM allowed 
#define	CW_MAX_SPEED		200	// Highest WPM allowed 

// CW function return status codes. 
#define	CW_SUCCESS		0
#define	CW_ERROR		-1

#define	ASC_NUL		'\0'	// End of string 
#define	ASC_SPACE	' '	// ASCII space char 

// Tone and timing magic numbers. 
#define	DOT_MAGIC	1200000	// Dot length magic number.  The Dot
//							   length is 1200000/WPM Usec 
#define	TONE_SILENT	0	// 0Hz = silent 'tone' 
#define	USECS_PER_SEC	1000000	// Microseconds in a second 

#define	INITIAL_SEND_SPEED	18	// Initial send speed in WPM 
#define	INITIAL_RECEIVE_SPEED	18	// Initial receive speed in WPM 
//#define INITIAL_GAP		0	// Initial fransworth gap setting 
//#define INITIAL_TOLERANCE	60	// Initial tolerance setting 
//#define INITIAL_ADAPTIVE	TRUE	// Initial adaptive receive setting 

// Initial adaptive speed threshold 
#define	INITIAL_THRESHOLD	((DOT_MAGIC / INITIAL_RECEIVE_SPEED) * 2)

// Initial noise filter threshold 
#define	INITIAL_NOISE_THRESHOLD	((DOT_MAGIC / CW_MAX_SPEED) / 2)


enum CW_RX_STATE {
	RS_IDLE = 0,
	RS_IN_TONE,
	RS_AFTER_TONE
};

enum CW_EVENT {
	CW_RESET_EVENT,
	CW_KEYDOWN_EVENT,
	CW_KEYUP_EVENT,
	CW_QUERY_EVENT
};

class cw : public morse, public modem {
protected:
	int				symbollen;		// length of a dot in sound samples (tx)
	double			phaseacc;		// used by NCO for rx/tx tones
	unsigned int	smpl_ctr;		// sample counter for timing cw rx 
	double			agc_peak;		// threshold for tone detection 

	C_FIR_filter	*cwfilter;
	Cmovavg			*bitfilter;

	CW_RX_STATE		cw_receive_state;	// Indicates receive state 
	CW_EVENT		cw_event;			// functions used by cw process routine 
	 
	double pipe[CWMaxSymLen];			// storage for sync scope data
	double scopedata[CWMaxSymLen];
	int pipeptr;
	int pipesize;

	
// user configurable data - local copy passed in from gui
	int cw_speed;
	int cw_bandwidth;
	int cw_squelch;
	int cw_send_speed;				// Initially 18 WPM 
	int cw_receive_speed;			// Initially 18 WPM 
	long int cw_noise_spike_threshold;	// Initially ignore any tone < 10mS 
	int cw_in_sync;					// Synchronization flag 

// Sending parameters: 
	long int cw_send_dot_length;			// Length of a send Dot, in Usec 
	long int cw_send_dash_length;		// Length of a send Dash, in Usec
	int lastsym;					// last symbol sent

// Receiving parameters: 
	long int cw_receive_dot_length;		// Length of a receive Dot, in Usec 
	long int cw_receive_dash_length;		// Length of a receive Dash, in Usec 

// Receive buffering
#define	RECEIVE_CAPACITY	256		// Way longer than any representation 
	char rx_rep_buf[RECEIVE_CAPACITY];
	int cw_rr_current;				// Receive buffer current location 
	unsigned int cw_rr_start_timestamp;	// Tone start timestamp 
	unsigned int cw_rr_end_timestamp;	// Tone end timestamp 

	long int cw_adaptive_receive_threshold;	// 2-dot threshold for adaptive speed 

// Receive adaptive speed tracking.
#define	AVERAGE_ARRAY_LENGTH	10	// Keep 10 dot/dash lengths 
	long int cw_dot_tracking_array[AVERAGE_ARRAY_LENGTH];
	long int cw_dash_tracking_array[AVERAGE_ARRAY_LENGTH];
// Dot and dash length arrays 
	long int cw_dt_dot_index;
	long int cw_dt_dash_index;			// Circular indexes into the arrays 
	long int cw_dt_dot_tracking_sum;
	long int cw_dt_dash_tracking_sum;	// Running sum of array members 
	
	inline double nco(double freq);
	void	update_syncscope();
	void	sync_parameters();
	int		handle_event(int cw_event, char **c);
	int		usec_diff(unsigned int earlier, unsigned int later);
	void	send_symbol(int symbol);
	void	send_ch(int c);
//	unsigned long tx_lookup(int c);
	bool 	tables_init();
	unsigned int tokenize_representation(char *representation);
	void	update_tracking(int dot, int dash);
	
//	void	cw_keyline(int);
//	void	cw_keyup();
//	void	cw_keydown();
	
public:
	cw();
	~cw();
	void	init();
	void	rx_init();
	void	tx_init(cSound *sc);
	void	restart() {};
	int		rx_process(double *buf, int len);
	int		tx_process();

};

#endif
