//
// "$Id: flphoto.h 412 2006-11-15 04:20:01Z mike $"
//
// flPhoto application window class.
//
// Copyright 2002-2006 by Michael Sweet.
//
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2, or (at your option)
// any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//

// generated by Fast Light User Interface Designer (fluid) version 1.0108

#ifndef flphoto_h
#define flphoto_h
#include <FL/Fl.H>
#include <FL/Fl_Double_Window.H>
#include "Fl_Print_Dialog.H"
#include <FL/Fl_Preferences.H>
#include <FL/Fl_File_Chooser.H>
#include <FL/Fl_Menu_Bar.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Box.H>
#include "Fl_Image_Display.H"
#include <FL/Fl_Menu_Button.H>
#include "Fl_Image_Browser.H"
#include <FL/Fl_Choice.H>
#include <FL/Fl_Input.H>
#include <FL/Fl_Progress.H>
#include <FL/Fl_Spinner.H>
#include <FL/Fl_Positioner.H>
#include <FL/Fl_Check_Button.H>
#include <FL/Fl_Value_Slider.H>
#include <FL/Fl_Output.H>
#include "SpringWindow.h"
#include "MenuTabs.h"
#include "SmartGroup.h"

class flphoto {
public:
  static Fl_Preferences prefs; 
private:
  static int album_count_; 
  static flphoto *album_first_; 
  static Fl_File_Chooser *file_chooser_; 
  static char history_[10][1024]; 
  flphoto *album_next_; 
  int album_changed_; 
  char album_comment_[1024]; 
  char album_filename_[1024]; 
  char album_printname_[1024]; 
  void *camera_; 
  void *context_; 
  uchar *crop_data_; 
  char crop_dimensions_label_[256]; 
  Fl_Shared_Image *crop_image_; 
  uchar gamma_data_[100*100]; 
  Fl_RGB_Image *gamma_image_; 
  Fl_Image_Browser::ITEM *image_item_; 
  char stats_label_[256]; 
  char title_[1024]; 
  static int do_file_chooser(const char *title, const char *pattern, int type, const char *value); 
  void new_album_cb(); 
  void open_album_cb(); 
  void open_prev_cb(int f); 
  void add_file_cb(); 
  void add_dir_cb(); 
  void save_album_cb(); 
  void save_album_as_cb(); 
  void close_album_cb(); 
  void export_dir_cb(); 
  void export_dir_ok_cb(); 
  void export_html_cb(); 
  void export_html_ok_cb(); 
  void print_album_cb(); 
  void slideshow_cb(); 
  void sort_album_cb(int type = 0); 
  static void slidenext_cb(); 
  void props_album_cb(); 
  void props_ok_cb(); 
  void quit_cb(); 
  void update_history(const char *f = 0); 
  void update_stats(); 
  void camera_cb(); 
  void camera_browser_cb();
  void camera_chooser_cb(); 
  void camera_close_cb(); 
  void camera_delete_cb(); 
  void camera_directory_cb(int choose = 0); 
  void camera_download_cb(); 
  void camera_select_cb();
  void camera_select_new(); 
  void open_image_cb(int number=-1); 
  void edit_image_cb(); 
  void save_image_cb(); 
  void save_image_as_cb(); 
  void save_image(const char *filename, int batch=0); 
  int save_jpeg(const char *filename, int batch); 
  int save_png(const char *filename, int batch); 
  void print_image_cb(); 
  void select_image_cb(int v); 
  void remove_image_cb(); 
  void purge_image_cb(); 
  void image_progress(const char *label, int percent); 
  void revert_image_cb(); 
  void auto_adjust_cb(); 
  void adjust_levels_cb(); 
  void redeye_cb(); 
  void blur_cb(); 
  void sharpen_cb(); 
  void crop_cb(); 
  void crop_ok_cb(); 
  void crop_update_cb(Fl_Widget *w); 
  Fl_Shared_Image *rotate_image(Fl_Shared_Image *img, int angle); 
  void rotate_cb(int angle); 
  void scale_cb(); 
  void scale_ok_cb(); 
  void scale_update_cb(Fl_Widget *w); 
  void blur_image(uchar *data, int w, int h, int d, int r, float a); 
  uchar *copy_image(Fl_Shared_Image *img); 
  void props_image_cb(); 
public:
  static void help_cb(const char *); 
private:
  void browser_cb(); 
  void edit_selected_image_cb(); 
  void save_changed_image_cb(); 
  void save_selected_image_cb(); 
  void revert_selected_image_cb(); 
  void purge_selected_image_cb(); 
  void remove_selected_image_cb(); 
  void auto_adjust_selected_cb(); 
  void adjust_levels_selected_cb(); 
  void blur_selected_cb(); 
  void sharpen_selected_cb(); 
  void crop_selected_cb(); 
  void rotate_selected_cb(int angle); 
  void scale_selected_cb(); 
  static const char *print_cb(Fl_Print_Dialog *pd, void *d); 
  void update_title(); 
  void options_cb(Fl_Group *tab); 
  void options_ok_cb(); 
  void gamma_slider_cb(); 
public:
  flphoto(const char *filename = 0);
private:
  Fl_Double_Window *window_;
  void cb_window__i(Fl_Double_Window*, void*);
  static void cb_window_(Fl_Double_Window*, void*);
  Fl_Menu_Bar *menubar_;
  static Fl_Menu_Item menu_menubar_[];
  void cb_New_i(Fl_Menu_*, void*);
  static void cb_New(Fl_Menu_*, void*);
  void cb_Open_i(Fl_Menu_*, void*);
  static void cb_Open(Fl_Menu_*, void*);
  void cb_File_i(Fl_Menu_*, void*);
  static void cb_File(Fl_Menu_*, void*);
  void cb_File1_i(Fl_Menu_*, void*);
  static void cb_File1(Fl_Menu_*, void*);
  void cb_File2_i(Fl_Menu_*, void*);
  static void cb_File2(Fl_Menu_*, void*);
  void cb_File3_i(Fl_Menu_*, void*);
  static void cb_File3(Fl_Menu_*, void*);
  void cb_File4_i(Fl_Menu_*, void*);
  static void cb_File4(Fl_Menu_*, void*);
  void cb_File5_i(Fl_Menu_*, void*);
  static void cb_File5(Fl_Menu_*, void*);
  void cb_File6_i(Fl_Menu_*, void*);
  static void cb_File6(Fl_Menu_*, void*);
  void cb_File7_i(Fl_Menu_*, void*);
  static void cb_File7(Fl_Menu_*, void*);
  void cb_File8_i(Fl_Menu_*, void*);
  static void cb_File8(Fl_Menu_*, void*);
  void cb_File9_i(Fl_Menu_*, void*);
  static void cb_File9(Fl_Menu_*, void*);
  void cb_Save_i(Fl_Menu_*, void*);
  static void cb_Save(Fl_Menu_*, void*);
  void cb_Save1_i(Fl_Menu_*, void*);
  static void cb_Save1(Fl_Menu_*, void*);
  void cb_Close_i(Fl_Menu_*, void*);
  static void cb_Close(Fl_Menu_*, void*);
  void cb_Camera_i(Fl_Menu_*, void*);
  static void cb_Camera(Fl_Menu_*, void*);
  void cb_Directory_i(Fl_Menu_*, void*);
  static void cb_Directory(Fl_Menu_*, void*);
  void cb_Image_i(Fl_Menu_*, void*);
  static void cb_Image(Fl_Menu_*, void*);
  void cb_Directory1_i(Fl_Menu_*, void*);
  static void cb_Directory1(Fl_Menu_*, void*);
  void cb_HTML_i(Fl_Menu_*, void*);
  static void cb_HTML(Fl_Menu_*, void*);
  void cb_Print_i(Fl_Menu_*, void*);
  static void cb_Print(Fl_Menu_*, void*);
  void cb_Slidesho_i(Fl_Menu_*, void*);
  static void cb_Slidesho(Fl_Menu_*, void*);
  void cb_By_i(Fl_Menu_*, void*);
  static void cb_By(Fl_Menu_*, void*);
  void cb_Reverse_i(Fl_Menu_*, void*);
  static void cb_Reverse(Fl_Menu_*, void*);
  void cb_By1_i(Fl_Menu_*, void*);
  static void cb_By1(Fl_Menu_*, void*);
  void cb_Reverse1_i(Fl_Menu_*, void*);
  static void cb_Reverse1(Fl_Menu_*, void*);
  void cb_P_i(Fl_Menu_*, void*);
  static void cb_P(Fl_Menu_*, void*);
  void cb_Quit_i(Fl_Menu_*, void*);
  static void cb_Quit(Fl_Menu_*, void*);
  void cb_Open1_i(Fl_Menu_*, void*);
  static void cb_Open1(Fl_Menu_*, void*);
  void cb_Edit_i(Fl_Menu_*, void*);
  static void cb_Edit(Fl_Menu_*, void*);
  void cb_Save2_i(Fl_Menu_*, void*);
  static void cb_Save2(Fl_Menu_*, void*);
  void cb_Save3_i(Fl_Menu_*, void*);
  static void cb_Save3(Fl_Menu_*, void*);
  void cb_Print1_i(Fl_Menu_*, void*);
  static void cb_Print1(Fl_Menu_*, void*);
  void cb_Remove_i(Fl_Menu_*, void*);
  static void cb_Remove(Fl_Menu_*, void*);
  void cb_Pur_i(Fl_Menu_*, void*);
  static void cb_Pur(Fl_Menu_*, void*);
  void cb_P1_i(Fl_Menu_*, void*);
  static void cb_P1(Fl_Menu_*, void*);
  void cb_Re_i(Fl_Menu_*, void*);
  static void cb_Re(Fl_Menu_*, void*);
  void cb_Auto_i(Fl_Menu_*, void*);
  static void cb_Auto(Fl_Menu_*, void*);
  void cb_Brightness_i(Fl_Menu_*, void*);
  static void cb_Brightness(Fl_Menu_*, void*);
  void cb_Blur_i(Fl_Menu_*, void*);
  static void cb_Blur(Fl_Menu_*, void*);
  void cb_Sharp_i(Fl_Menu_*, void*);
  static void cb_Sharp(Fl_Menu_*, void*);
  void cb_Crop_i(Fl_Menu_*, void*);
  static void cb_Crop(Fl_Menu_*, void*);
  void cb_Rotate_i(Fl_Menu_*, void*);
  static void cb_Rotate(Fl_Menu_*, void*);
  void cb_Rotate1_i(Fl_Menu_*, void*);
  static void cb_Rotate1(Fl_Menu_*, void*);
  void cb_Scale_i(Fl_Menu_*, void*);
  static void cb_Scale(Fl_Menu_*, void*);
  void cb_Auto1_i(Fl_Menu_*, void*);
  static void cb_Auto1(Fl_Menu_*, void*);
  void cb_25_i(Fl_Menu_*, void*);
  static void cb_25(Fl_Menu_*, void*);
  void cb_50_i(Fl_Menu_*, void*);
  static void cb_50(Fl_Menu_*, void*);
  void cb_100_i(Fl_Menu_*, void*);
  static void cb_100(Fl_Menu_*, void*);
  void cb_Image1_i(Fl_Menu_*, void*);
  static void cb_Image1(Fl_Menu_*, void*);
  void cb_Slideshow_i(Fl_Menu_*, void*);
  static void cb_Slideshow(Fl_Menu_*, void*);
  void cb_Memory_i(Fl_Menu_*, void*);
  static void cb_Memory(Fl_Menu_*, void*);
  void cb_About_i(Fl_Menu_*, void*);
  static void cb_About(Fl_Menu_*, void*);
  void cb_Contents_i(Fl_Menu_*, void*);
  static void cb_Contents(Fl_Menu_*, void*);
  void cb_Albums_i(Fl_Menu_*, void*);
  static void cb_Albums(Fl_Menu_*, void*);
  void cb_Images_i(Fl_Menu_*, void*);
  static void cb_Images(Fl_Menu_*, void*);
  void cb_Download_i(Fl_Menu_*, void*);
  static void cb_Download(Fl_Menu_*, void*);
  void cb_Release_i(Fl_Menu_*, void*);
  static void cb_Release(Fl_Menu_*, void*);
  void cb_mode_button__i(Fl_Button*, void*);
  static void cb_mode_button_(Fl_Button*, void*);
  void cb_mode_button_1_i(Fl_Button*, void*);
  static void cb_mode_button_1(Fl_Button*, void*);
  void cb_mode_button_2_i(Fl_Button*, void*);
  static void cb_mode_button_2(Fl_Button*, void*);
  Fl_Button *mode_button_[4];
  void cb_mode_button_3_i(Fl_Button*, void*);
  static void cb_mode_button_3(Fl_Button*, void*);
  Fl_Image_Display *display_;
  void cb_display__i(Fl_Image_Display*, void*);
  static void cb_display_(Fl_Image_Display*, void*);
  Fl_Menu_Button *context_menu_;
  static Fl_Menu_Item menu_context_menu_[];
  void cb_Edit1_i(Fl_Menu_*, void*);
  static void cb_Edit1(Fl_Menu_*, void*);
  void cb_Save4_i(Fl_Menu_*, void*);
  static void cb_Save4(Fl_Menu_*, void*);
  void cb_Print2_i(Fl_Menu_*, void*);
  static void cb_Print2(Fl_Menu_*, void*);
  void cb_Select_i(Fl_Menu_*, void*);
  static void cb_Select(Fl_Menu_*, void*);
  void cb_Select1_i(Fl_Menu_*, void*);
  static void cb_Select1(Fl_Menu_*, void*);
  void cb_Remove1_i(Fl_Menu_*, void*);
  static void cb_Remove1(Fl_Menu_*, void*);
  void cb_Pur1_i(Fl_Menu_*, void*);
  static void cb_Pur1(Fl_Menu_*, void*);
  void cb_Re1_i(Fl_Menu_*, void*);
  static void cb_Re1(Fl_Menu_*, void*);
  void cb_Auto2_i(Fl_Menu_*, void*);
  static void cb_Auto2(Fl_Menu_*, void*);
  void cb_Brightness1_i(Fl_Menu_*, void*);
  static void cb_Brightness1(Fl_Menu_*, void*);
  void cb_Blur1_i(Fl_Menu_*, void*);
  static void cb_Blur1(Fl_Menu_*, void*);
  void cb_Sharp1_i(Fl_Menu_*, void*);
  static void cb_Sharp1(Fl_Menu_*, void*);
  void cb_Crop1_i(Fl_Menu_*, void*);
  static void cb_Crop1(Fl_Menu_*, void*);
  void cb_Rotate2_i(Fl_Menu_*, void*);
  static void cb_Rotate2(Fl_Menu_*, void*);
  void cb_Rotate3_i(Fl_Menu_*, void*);
  static void cb_Rotate3(Fl_Menu_*, void*);
  void cb_Scale1_i(Fl_Menu_*, void*);
  static void cb_Scale1(Fl_Menu_*, void*);
  Fl_Box *stats_box_;
  Fl_Image_Browser *browser_;
  void cb_browser__i(Fl_Image_Browser*, void*);
  static void cb_browser_(Fl_Image_Browser*, void*);
  Fl_Double_Window *camera_window_;
  void cb_camera_window__i(Fl_Double_Window*, void*);
  static void cb_camera_window_(Fl_Double_Window*, void*);
  Fl_Group *camera_group_;
  Fl_Choice *camera_chooser_;
  void cb_camera_chooser__i(Fl_Choice*, void*);
  static void cb_camera_chooser_(Fl_Choice*, void*);
  Fl_Image_Browser *camera_browser_;
  void cb_camera_browser__i(Fl_Image_Browser*, void*);
  static void cb_camera_browser_(Fl_Image_Browser*, void*);
  Fl_Input *camera_download_field_;
  void cb_camera_download_field__i(Fl_Input*, void*);
  static void cb_camera_download_field_(Fl_Input*, void*);
  void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
  Fl_Menu_Button *camera_select_menu_;
  void cb_camera_select_menu__i(Fl_Menu_Button*, void*);
  static void cb_camera_select_menu_(Fl_Menu_Button*, void*);
  static Fl_Menu_Item menu_camera_select_menu_[];
  void cb_New1_i(Fl_Menu_*, void*);
  static void cb_New1(Fl_Menu_*, void*);
  void cb_Download1_i(Fl_Button*, void*);
  static void cb_Download1(Fl_Button*, void*);
  void cb_Delete_i(Fl_Button*, void*);
  static void cb_Delete(Fl_Button*, void*);
  Fl_Progress *camera_progress_;
  Fl_Button *camera_close_button_;
  void cb_camera_close_button__i(Fl_Button*, void*);
  static void cb_camera_close_button_(Fl_Button*, void*);
  Fl_Double_Window *crop_window_;
  Fl_Box *crop_dimensions_box_;
  Fl_Spinner *crop_top_value_;
  void cb_crop_top_value__i(Fl_Spinner*, void*);
  static void cb_crop_top_value_(Fl_Spinner*, void*);
  Fl_Positioner *crop_preview_box_;
  void cb_crop_preview_box__i(Fl_Positioner*, void*);
  static void cb_crop_preview_box_(Fl_Positioner*, void*);
  Fl_Spinner *crop_left_value_;
  void cb_crop_left_value__i(Fl_Spinner*, void*);
  static void cb_crop_left_value_(Fl_Spinner*, void*);
  Fl_Spinner *crop_right_value_;
  void cb_crop_right_value__i(Fl_Spinner*, void*);
  static void cb_crop_right_value_(Fl_Spinner*, void*);
  Fl_Spinner *crop_bottom_value_;
  void cb_crop_bottom_value__i(Fl_Spinner*, void*);
  static void cb_crop_bottom_value_(Fl_Spinner*, void*);
  Fl_Choice *crop_aspect_chooser_;
  void cb_crop_aspect_chooser__i(Fl_Choice*, void*);
  static void cb_crop_aspect_chooser_(Fl_Choice*, void*);
  static Fl_Menu_Item menu_crop_aspect_chooser_[];
  Fl_Group *crop_aspect_custom_;
  Fl_Spinner *crop_aspect_x_;
  void cb_crop_aspect_x__i(Fl_Spinner*, void*);
  static void cb_crop_aspect_x_(Fl_Spinner*, void*);
  Fl_Spinner *crop_aspect_y_;
  void cb_crop_aspect_y__i(Fl_Spinner*, void*);
  static void cb_crop_aspect_y_(Fl_Spinner*, void*);
  void cb_Crop2_i(Fl_Button*, void*);
  static void cb_Crop2(Fl_Button*, void*);
  void cb_Cancel_i(Fl_Button*, void*);
  static void cb_Cancel(Fl_Button*, void*);
  Fl_Double_Window *scale_window_;
  Fl_Spinner *scale_xsize_value_;
  void cb_scale_xsize_value__i(Fl_Spinner*, void*);
  static void cb_scale_xsize_value_(Fl_Spinner*, void*);
  Fl_Spinner *scale_ysize_value_;
  void cb_scale_ysize_value__i(Fl_Spinner*, void*);
  static void cb_scale_ysize_value_(Fl_Spinner*, void*);
  Fl_Spinner *scale_xratio_value_;
  void cb_scale_xratio_value__i(Fl_Spinner*, void*);
  static void cb_scale_xratio_value_(Fl_Spinner*, void*);
  Fl_Spinner *scale_yratio_value_;
  void cb_scale_yratio_value__i(Fl_Spinner*, void*);
  static void cb_scale_yratio_value_(Fl_Spinner*, void*);
  Fl_Check_Button *scale_aspect_button_;
  void cb_scale_aspect_button__i(Fl_Check_Button*, void*);
  static void cb_scale_aspect_button_(Fl_Check_Button*, void*);
  void cb_Scale2_i(Fl_Button*, void*);
  static void cb_Scale2(Fl_Button*, void*);
  void cb_Cancel1_i(Fl_Button*, void*);
  static void cb_Cancel1(Fl_Button*, void*);
  Fl_Double_Window *jpeg_window_;
  Fl_Box *jpeg_transform_box_;
  Fl_Group *jpeg_quality_group_;
  Fl_Value_Slider *jpeg_quality_value_;
  Fl_Check_Button *jpeg_progressive_button_;
  Fl_Check_Button *jpeg_optimize_button_;
  Fl_Check_Button *jpeg_comments_button_;
  Fl_Check_Button *jpeg_exif_button_;
  void cb_Save5_i(Fl_Button*, void*);
  static void cb_Save5(Fl_Button*, void*);
  Fl_Double_Window *props_window_;
  Fl_Input *props_comments_field_;
  void cb_Save6_i(Fl_Button*, void*);
  static void cb_Save6(Fl_Button*, void*);
  void cb_Cancel2_i(Fl_Button*, void*);
  static void cb_Cancel2(Fl_Button*, void*);
  Fl_Output *props_exif_field_;
  SpringWindow *export_html_window_;
  Fl_Group *export_group_;
  MenuTabs *export_tabs_;
  SmartGroup *export_general_tab_;
  Fl_Input *export_path_field_;
  void cb_1_i(Fl_Button*, void*);
  static void cb_1(Fl_Button*, void*);
  Fl_Input *export_header_field_;
  Fl_Input *export_footer_field_;
  Fl_Input *export_style_field_;
  void cb_2_i(Fl_Button*, void*);
  static void cb_2(Fl_Button*, void*);
  Fl_Check_Button *export_original_button_;
  SmartGroup *export_image_tab_;
  Fl_Spinner *export_imagesize_value_;
  Fl_Spinner *export_imagecols_value_;
  Fl_Spinner *export_imagerows_value_;
  Fl_Value_Slider *export_imagequal_value_;
  SmartGroup *export_thumbnail_tab_;
  Fl_Spinner *export_thumbsize_value_;
  Fl_Spinner *export_thumbcols_value_;
  Fl_Spinner *export_thumbrows_value_;
  Fl_Value_Slider *export_thumbqual_value_;
  SmartGroup *export_watermark_tab_;
  Fl_Input *export_watermark_field_;
  Fl_Choice *export_typeface_chooser_;
  static Fl_Menu_Item menu_export_typeface_chooser_[];
  Fl_Choice *export_fontstyle_chooser_;
  static Fl_Menu_Item menu_export_fontstyle_chooser_[];
  Fl_Value_Slider *export_fontsize_slider_;
  Fl_Value_Slider *export_opacity_slider_;
  Fl_Choice *export_position_chooser_;
  static Fl_Menu_Item menu_export_position_chooser_[];
  void cb_Export_i(Fl_Button*, void*);
  static void cb_Export(Fl_Button*, void*);
  void cb_Cancel3_i(Fl_Button*, void*);
  static void cb_Cancel3(Fl_Button*, void*);
  Fl_Progress *export_progress_;
  Fl_Double_Window *auth_window_;
  void cb_auth_window__i(Fl_Double_Window*, void*);
  static void cb_auth_window_(Fl_Double_Window*, void*);
  Fl_Input *auth_user_field_;
  void cb_auth_user_field__i(Fl_Input*, void*);
  static void cb_auth_user_field_(Fl_Input*, void*);
  Fl_Input *auth_pass_field_;
  void cb_auth_pass_field__i(Fl_Input*, void*);
  static void cb_auth_pass_field_(Fl_Input*, void*);
  void cb_Login_i(Fl_Button*, void*);
  static void cb_Login(Fl_Button*, void*);
  void cb_Cancel4_i(Fl_Button*, void*);
  static void cb_Cancel4(Fl_Button*, void*);
  SpringWindow *options_window_;
  MenuTabs *options_tabs_;
  SmartGroup *image_tab_;
  Fl_Check_Button *auto_open_button_;
  Fl_Check_Button *keep_zoom_button_;
  Fl_Input *image_editor_field_;
  void cb_3_i(Fl_Button*, void*);
  static void cb_3(Fl_Button*, void*);
  Fl_Value_Slider *gamma_slider_;
  void cb_gamma_slider__i(Fl_Value_Slider*, void*);
  static void cb_gamma_slider_(Fl_Value_Slider*, void*);
  Fl_Box *gamma_box_;
  SmartGroup *slideshow_tab_;
  Fl_Value_Slider *ssoptions_delay_value_;
  Fl_Check_Button *ssoptions_first_button_;
  Fl_Check_Button *ssoptions_random_button_;
  Fl_Check_Button *ssoptions_repeat_button_;
  Fl_Check_Button *ssoptions_comments_button_;
  Fl_Choice *ssoptions_screen_chooser_;
  static Fl_Menu_Item menu_ssoptions_screen_chooser_[];
  Fl_Choice *ssoptions_size_chooser_;
  void cb_ssoptions_size_chooser__i(Fl_Choice*, void*);
  static void cb_ssoptions_size_chooser_(Fl_Choice*, void*);
  static Fl_Menu_Item menu_ssoptions_size_chooser_[];
  Fl_Group *ssoptions_custom_group_;
  Fl_Spinner *ssoptions_width_value_;
  Fl_Spinner *ssoptions_height_value_;
  SmartGroup *flash_tab_;
  Fl_Input *flash_dir_field_;
  void cb_4_i(Fl_Button*, void*);
  static void cb_4(Fl_Button*, void*);
  Fl_Check_Button *flash_mount_button_;
  void cb_Save7_i(Fl_Button*, void*);
  static void cb_Save7(Fl_Button*, void*);
  void cb_Cancel5_i(Fl_Button*, void*);
  static void cb_Cancel5(Fl_Button*, void*);
  Fl_Double_Window *directory_window_;
  SmartGroup *directory_form_group_;
  Fl_Input *directory_field_;
  void cb_5_i(Fl_Button*, void*);
  static void cb_5(Fl_Button*, void*);
  Fl_Check_Button *directory_renumber_button_;
  SmartGroup *directory_button_group_;
  void cb_Export1_i(Fl_Button*, void*);
  static void cb_Export1(Fl_Button*, void*);
  void cb_Cancel6_i(Fl_Button*, void*);
  static void cb_Cancel6(Fl_Button*, void*);
  Fl_Progress *directory_progress_;
public:
  ~flphoto();
  void hide();
  void open_album(const char *filename); 
  void open_dir(const char *dirname); 
  void open_file(const char *filename, int openit=1); 
  void save_album(const char *filename); 
  void show();
  void show_camera();
  void show_last_image();
  int shown();
  int visible();
};
#endif

//
// End of "$Id: flphoto.h 412 2006-11-15 04:20:01Z mike $".
//
