# -*- Mode: Python; test-case-name: flumotion.test.test_flumotion_config -*-
# vi:si:et:sw=4:sts=4:ts=4
#
# Flumotion - a streaming media server
# Copyright (C) 2004,2005,2006 Fluendo, S.L. (www.fluendo.com).
# All rights reserved.

# This file may be distributed and/or modified under the terms of
# the GNU General Public License version 2 as published by
# the Free Software Foundation.
# This file is distributed without any warranty; without even the implied
# warranty of merchantability or fitness for a particular purpose.
# See "LICENSE.GPL" in the source distribution for more information.

# Licensees having purchased or holding a valid Flumotion Advanced
# Streaming Server license may use this file in accordance with the
# Flumotion Advanced Streaming Server Commercial License Agreement.
# See "LICENSE.Flumotion" in the source distribution for more information.

# Headers in this file shall remain intact.

import os

def get():
    try:
        homedir = os.environ['HOME']
        registrydir = os.path.join(homedir, '.flumotion')
        cachedir = os.path.join(homedir, '.flumotion')
        def ensure(path):
            try:
                os.listdir(path)
            except:
                os.makedirs(path)
        ensure(registrydir)
        ensure(cachedir)
    except KeyError:
        registrydir = os.path.join('/usr/local/var', 'cache', 'flumotion')
        cachedir = os.path.join('/usr/local/var', 'cache', 'flumotion')
    except OSError, e:
        print 'Error making dir %s: %s' % (e.filename, e.strerror)
        print 'Things are probably going to break!'

    return {
        'isinstalled':   True,
        'cachedir':      cachedir,
        'configdir':     os.path.join('/usr/local/etc', 'flumotion'),
        'gladedir':      os.path.join('/usr/local/share', 'flumotion', 'glade'),
        'imagedir':      os.path.join('/usr/local/share', 'flumotion', 'image'),
        'localedatadir': os.path.join('/usr/local/share'),
        'logdir':        os.path.join('/usr/local/var', 'log', 'flumotion'),
        'pythondir':     os.path.join('/usr/local/lib', 'flumotion', 'python'),
        'registrydir':   registrydir,
        'rundir':        os.path.join('/usr/local/var', 'run', 'flumotion'),
        'version':       '0.2.1',
    }
