#!/usr/bin/env python

# Free Open FTP Face (C)2006 Jeffrey Bakker
#
# FOFF is a graphical FTP client written in pyGTK.

# FOFF is compact, multiplatform (any system that supports GTK+ and python),
# has a simple and friendly interface, and has built-in convenience features
# including an image viewer, text viewer, one-click compress/decompress with
# gzip, and a mini console that takes both FTP commands and operating system
# commands.


# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.


import gtk
import libglade
import threading
import time

try:
	import pymedia.muxer as muxer, pymedia.audio.acodec as acodec, pymedia.audio.sound as sound
	SOUND_PLAYER=1
except:
	print "Python module pymedia missing. Disabling FOFF Audio Player.\n"
	SOUND_PLAYER=0


# playlist queue and handling =================================================
class PlayList(threading.Thread):

	def __init__(self, model, vol, iter=None):

		self.iter = iter
		self.model = model

		self.Playing = False
		self.Paused = False
		self.Skip = False
		self.back = -1

		self.vol = vol

		self.snd = None

		threading.Thread.__init__(self)

	def run(self):

		if self.iter == None:

			if self.model.get_iter_first() != None:

				self.iter = self.model.get_iter_first()
			else:
				return

		self.Playing = True
		self.play_list(self.iter)
		self.Playing = False


	def play_list(self, iter):

		if not self.model.iter_is_valid(iter):
			return

		self.iter = iter

		if self.Skip:

			self.Skip = False
			self.Playing = True

		if self.back != -1:

			if self.model.iter_is_valid(self.model.get_iter(self.back - 1)):

				gtk.threads_enter()
				self.model.set(self.iter,1,"")
				gtk.threads_leave()

				self.iter = self.model.get_iter(self.back - 1)

				self.back = -1
				self.Playing = True
				self.play_list(self.iter)

		if not self.Playing:

			gtk.threads_enter()
			self.model.set(self.iter,1,"")
			gtk.threads_leave()

			return

		print "playing: " + self.model.get_value(iter, 0) + "\n"

		gtk.threads_enter()
		self.model.set(self.iter,1,"gtk-media-play")
		gtk.threads_leave()

		self.Play(self.model.get_value(iter, 0))

		gtk.threads_enter()
		self.model.set(self.iter,1,"")
		gtk.threads_leave()

		if self.model.iter_next(self.iter) == None:
			return

		time.sleep(0.3)
		self.play_list(self.model.iter_next(self.iter))

	def Play(self, name, card=0, rate=1):

		dm = muxer.Demuxer(str.split( name, '.' )[ -1 ].lower())
		snds = sound.getODevices()

		if card not in range(len(snds)):
			raise 'Cannot play sound to non existent device %d out of %d' % (card+ 1, len(snds))

		f = open(name, 'rb')
		resampler = dec = None
		s = f.read(32000)

		while len( s ):
			frames = dm.parse(s)
			if frames:
				for fr in frames:

					if not self.Playing:

						gtk.threads_enter()
						self.model.set(self.iter,1,"")
						gtk.threads_leave()

						f.close()
						return

					while self.Paused:
						time.sleep(0.5)

					if dec == None:
						print dm.getHeaderInfo(), dm.streams
						dec = acodec.Decoder(dm.streams[ fr[0] ])
        
					r = dec.decode(fr[1])

					if r and r.data:
						if self.snd == None:
							print 'Opening sound with %d channels -> %s' % ( r.channels, snds[ card ][ 'name' ] )
							self.snd = sound.Output( int( r.sample_rate* rate ), r.channels, sound.AFMT_S16_LE, card )
							self.snd.setVolume(int(self.vol * 655))

						self.snd.play( r.data )
			s= f.read( 512 )

		while self.snd.isPlaying():
			time.sleep( .05 )

		f.close()

	def Pause(self):

		self.Paused = not self.Paused

		if self.Paused:
			self.snd.pause()

			gtk.threads_enter()
			self.model.set(self.iter,1,"gtk-media-pause")
			gtk.threads_leave()

		else:
			self.snd.unpause()

			gtk.threads_enter()
			self.model.set(self.iter,1,"gtk-media-play")
			gtk.threads_leave()

	def Stop(self):

		if self.snd.isPlaying():
			self.snd.stop()

		self.Playing = False

	def Back(self):

		path = self.model.get_path(self.iter)

		if path[0] != 0:
			self.back = path[0]
			self.Stop()

	def Next(self):

		self.Skip = True
		self.Stop()

	def Volume(self, value):

		if self.snd != None:
			self.snd.setVolume(int(value * 655))

	def isPlaying(self):

		return self.Playing


# sound player ================================================================
class sndWnd(libglade.GladeWrapper):

	def __init__(self, Filename, WindowName, TextFile=None):
		libglade.GladeWrapper.__init__(self, Filename, WindowName)

		try:
			self.tbPlayer.set_icon_size(gtk.ICON_SIZE_SMALL_TOOLBAR)
		except:
			pass

		self.playlist = gtk.ListStore(str,str)
		self.tvPlayList.set_model(self.playlist)

		files_column = gtk.TreeViewColumn("Track", gtk.CellRendererText(), text=0)
		status_column = gtk.TreeViewColumn("Status", gtk.CellRendererPixbuf(), stock_id=1)

		self.tvPlayList.append_column(status_column)
		self.tvPlayList.append_column(files_column)

		self.plthread = None

	def playlist_add(self, widget):

		chooser = gtk.FileChooserDialog("Add Sound File", None, gtk.FILE_CHOOSER_ACTION_OPEN,
						(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
						gtk.STOCK_OPEN, gtk.RESPONSE_OK))

		chooser.set_default_response(gtk.RESPONSE_OK)
		chooser.set_select_multiple(True)

		filter = gtk.FileFilter()
		filter.set_name("All supported audio files")
		filter.add_pattern("*.aac")
		filter.add_pattern("*.ac3")
		filter.add_pattern("*.mp3")
		filter.add_pattern("*.ogg")
		filter.add_pattern("*.wma")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Advanced Audio Coding (*.aac)")
		filter.add_pattern("*.aac")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Audio Coding-3 (*.ac3)")
		filter.add_pattern("*.ac3")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("MPEG Layer III (*.mp3)")
		filter.add_pattern("*.mp3")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Ogg Vorbis (*.ogg)")
		filter.add_pattern("*.ogg")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("Windows Media Audio (*.wma)")
		filter.add_pattern("*.wma")
		chooser.add_filter(filter)

		response = chooser.run()
		if response == gtk.RESPONSE_OK:

			for files in chooser.get_filenames():

				iter = self.playlist.append()
				self.playlist.set(iter,0,files)

		chooser.destroy()

	def playlist_remove(self, widget):

		sel = self.tvPlayList.get_selection()
		model, iter = sel.get_selected()
		iter = model.remove(iter)

	def playlist_new(self, widget):

		self.playlist.clear()

	def playlist_save(self, widget):

		chooser = gtk.FileChooserDialog("Save Script", None, gtk.FILE_CHOOSER_ACTION_SAVE,
						(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
						gtk.STOCK_SAVE, gtk.RESPONSE_OK))

		chooser.set_default_response(gtk.RESPONSE_OK)

		filter = gtk.FileFilter()
		filter.set_name("All files (*)")
		filter.add_pattern("*")
		chooser.add_filter(filter)

		response = chooser.run()
		if response == gtk.RESPONSE_OK:

			script = chooser.get_filename()
			plist = open(script, "w")

			if self.playlist.get_iter_first() != None:

				iter = self.playlist.get_iter_first()
				while(iter is not None):

					plist.write(self.playlist.get_value(iter, 0) + '\n')
					iter = self.playlist.iter_next(iter)

			plist.close()

		chooser.destroy()

	def playlist_open(self, widget):

		chooser = gtk.FileChooserDialog("Load Playlist", None, gtk.FILE_CHOOSER_ACTION_OPEN,
						(gtk.STOCK_CANCEL, gtk.RESPONSE_CANCEL,
						gtk.STOCK_OPEN, gtk.RESPONSE_OK))

		chooser.set_default_response(gtk.RESPONSE_OK)

		filter = gtk.FileFilter()
		filter.set_name("All files")
		filter.add_pattern("*")
		chooser.add_filter(filter)

		filter = gtk.FileFilter()
		filter.set_name("MPEG-3 URL (*.m3u)")
		filter.add_pattern("*.m3u")
		chooser.add_filter(filter)

		response = chooser.run()
		if response == gtk.RESPONSE_OK:

			plist = open(chooser.get_filename(), "r")
			files = plist.readlines()
			plist.close()

# TODO: join parents if path is relative to m3u file's directory

			for file in files:
				if file[0] != '#':
					iter = self.playlist.append()
					self.playlist.set(iter,0,file.strip())

		chooser.destroy()



	def item_play(self, view, path, col):

		self.sound_play(view)

	def sound_play(self, widget):

		sel = self.tvPlayList.get_selection()
		model, iter = sel.get_selected()

		if self.plthread != None:

			self.plthread.Stop()
			del self.plthread
			self.plthread = None

			self.plthread = PlayList(self.playlist, self.hsVolume.get_value(), iter)
			self.plthread.start()

		else:
			self.plthread = PlayList(self.playlist, self.hsVolume.get_value(), iter)
			self.plthread.start()

	def sound_pause(self, widget):

		if self.plthread != None:
			self.plthread.Pause()

	def sound_stop(self, widget):

		if self.plthread != None:
			self.plthread.Stop()
			del self.plthread
			self.plthread = None

	def sound_next(self, widget):

		if self.plthread != None:
			self.plthread.Next()

	def sound_back(self, widget):

		if self.plthread != None:
			self.plthread.Back()

	def enqueue(self, filename):

		iter = self.playlist.append()
		self.playlist.set(iter,0,filename)

		# play if list was empty
		if self.plthread == None:

			self.plthread = PlayList(self.playlist, self.hsVolume.get_value(), iter)
			self.plthread.start()

		# or not playing
		elif not self.plthread.isPlaying():

			self.plthread.Stop()
			del self.plthread
			self.plthread = None

			self.plthread = PlayList(self.playlist, self.hsVolume.get_value(), iter)
			self.plthread.start()

	def change_volume(self, range):

		if self.plthread != None:

			self.plthread.Volume(range.get_value())

	def on_close(self, widget, data=None):

		if self.plthread != None:
			self.plthread.Stop()

		self.sndWnd.destroy()

# ==============================================================================