{
    This file is part of the Free Pascal run time library.
    Copyright (c) 2001 by Free Pascal development team

    This file implements all the base types and limits required
    for a minimal POSIX compliant subset required to port the compiler
    to a new OS.

    See the file COPYING.FPC, included in this distribution,
    for details about the copyright.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.

 **********************************************************************}

var
  ProcessID: SizeUInt;

function GetProcessID:SizeUInt;
begin
 GetProcessID := ProcessID;
end;

procedure DosGetInfoBlocks (PATIB: PPThreadInfoBlock;
                            PAPIB: PPProcessInfoBlock); cdecl;
                            external 'DOSCALLS' index 312;

function DosLoadModule (ObjName: PChar; ObjLen: cardinal; DLLName: PChar;
                                        var Handle: cardinal): cardinal; cdecl;
external 'DOSCALLS' index 318;

function DosQueryProcAddr (Handle, Ordinal: cardinal; ProcName: PChar;
                                        var Address: pointer): cardinal; cdecl;
external 'DOSCALLS' index 321;

function DosSetRelMaxFH (var ReqCount: longint; var CurMaxFH: cardinal):
                                                               cardinal; cdecl;
external 'DOSCALLS' index 382;

function DosSetCurrentDir (Name:PChar): cardinal; cdecl;
external 'DOSCALLS' index 255;

procedure DosQueryCurrentDisk(var DiskNum:cardinal;var Logical:cardinal); cdecl;
external 'DOSCALLS' index 275;

function DosSetDefaultDisk (DiskNum:cardinal): cardinal; cdecl;
external 'DOSCALLS' index 220;

{ This is not real prototype, but is close enough }
{ for us (the 2nd parameter is actually a pointer }
{ to a structure).                                }
function DosCreateDir (Name: PChar; P: pointer): cardinal; cdecl;
external 'DOSCALLS' index 270;

function DosDeleteDir (Name: PChar): cardinal; cdecl;
external 'DOSCALLS' index 226;

function DosQueryCurrentDir(DiskNum:cardinal;var Buffer;
                            var BufLen:cardinal): cardinal; cdecl;
external 'DOSCALLS' index 274;

function DosMove(OldFile,NewFile:PChar):cardinal; cdecl;
    external 'DOSCALLS' index 271;

function DosDelete(FileName:PChar):cardinal; cdecl;
    external 'DOSCALLS' index 259;

procedure DosExit(Action, Result: cardinal); cdecl;
    external 'DOSCALLS' index 234;

// EAs not used in System unit
function DosOpen(FileName:PChar;var Handle: THandle;var Action:cardinal;
                 InitSize,Attrib,OpenFlags,FileMode:cardinal;
                 EA:Pointer): cardinal; cdecl;
    external 'DOSCALLS' index 273;

function DosClose(Handle: THandle): cardinal; cdecl;
    external 'DOSCALLS' index 257;

function DosRead(Handle: THandle; Buffer: Pointer; Count: cardinal;
                                      var ActCount: cardinal): cardinal; cdecl;
    external 'DOSCALLS' index 281;

function DosWrite(Handle: THandle; Buffer: Pointer;Count: cardinal;
                                      var ActCount: cardinal): cardinal; cdecl;
    external 'DOSCALLS' index 282;

function DosSetFilePtr(Handle: THandle; Pos:longint; Method:cardinal;
                                     var PosActual: cardinal): cardinal; cdecl;
    external 'DOSCALLS' index 256;

function DosSetFileSize(Handle: THandle; Size: cardinal): cardinal; cdecl;
    external 'DOSCALLS' index 272;

function DosQueryHType(Handle: THandle; var HandType: cardinal;
                                          var Attr: cardinal): cardinal; cdecl;
    external 'DOSCALLS' index 224;

function DosQueryModuleName (Handle: THandle; NameLen: cardinal; Name: PChar):
                                                               cardinal; cdecl;
    external 'DOSCALLS' index 320;


type
  TSysDateTime=packed record
    Hour,
    Minute,
    Second,
    Sec100,
    Day,
    Month: byte;
    Year: word;
    TimeZone: smallint;
    WeekDay: byte;
  end;

function DosGetDateTime(var Buf:TSysDateTime): cardinal; cdecl;
    external 'DOSCALLS' index 230;

   { converts an OS/2 error code to a TP compatible error }
   { code. Same thing exists under most other supported   }
   { systems.                                             }
   { Only call for OS/2 DLL imported routines             }
   Procedure Errno2InOutRes;
   Begin
     { errors 1..18 are the same as in DOS }
     case InOutRes of
      { simple offset to convert these error codes }
      { exactly like the error codes in Win32      }
      19..31 : InOutRes := InOutRes + 131;
      { gets a bit more complicated ... }
      32..33 : InOutRes := 5;
      38 : InOutRes := 100;
      39 : InOutRes := 101;
      112 : InOutRes := 101;
      110 : InOutRes := 5;
      114 : InOutRes := 6;
      290 : InOutRes := 290;
     end;
     { all other cases ... we keep the same error code }
   end;


{$IFDEF OS2EXCEPTIONS}
(*
The operating system defines a class of error conditions called exceptions, and specifies the default actions that are taken when these exceptions occur. The system default action in most cases is to terminate the thread that caused the exception.

Exception values have the following 32-bit format:

 3 3 2 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1
 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0 9 8 7 6 5 4 3 2 1 0
Ŀ
SevC       Facility                         Code            



Sev Severity code. Possible values are described in the following list:

00 Success
01 Informational
10 Warning
11 Error

C Customer code flag.

Facility Facility code.

Code Facility's status code.

Exceptions that are specific to OS/2 Version 2.X (for example, XCPT_SIGNAL)
have a facility code of 1.

System exceptions include both synchronous and asynchronous exceptions.
Synchronous exceptions are caused by events that are internal to a thread's
execution. For example, synchronous exceptions could be caused by invalid
parameters, or by a thread's request to end its own execution.

Asynchronous exceptions are caused by events that are external to a thread's
execution. For example, an asynchronous exception can be caused by a user's
entering a Ctrl+C or Ctrl+Break key sequence, or by a process' issuing
DosKillProcess to end the execution of another process.

The Ctrl+Break and Ctrl+C exceptions are also known as signals, or as signal
exceptions.

The following tables show the symbolic names of system exceptions, their
numerical values, and related information fields.

Portable, Non-Fatal, Software-Generated Exceptions

Ŀ
Exception Name                       Value     
Ĵ
XCPT_GUARD_PAGE_VIOLATION            0x80000001
  ExceptionInfo[0] - R/W flag                  
  ExceptionInfo[1] - FaultAddr                 
Ĵ
XCPT_UNABLE_TO_GROW_STACK            0x80010001



Portable, Fatal, Hardware-Generated Exceptions

Ŀ
Exception Name                       Value     Related Trap 
Ĵ
XCPT_ACCESS_VIOLATION                0xC00000050x09, 0x0B,  
  ExceptionInfo[0] - Flags                     0x0C, 0x0D,  
    XCPT_UNKNOWN_ACCESS  0x0                   0x0E         
    XCPT_READ_ACCESS     0x1                                
    XCPT_WRITE_ACCESS    0x2                                
    XCPT_EXECUTE_ACCESS  0x4                                
    XCPT_SPACE_ACCESS    0x8                                
    XCPT_LIMIT_ACCESS    0x10                               
  ExceptionInfo[1] - FaultAddr                              
Ĵ
XCPT_INTEGER_DIVIDE_BY_ZERO          0xC000009B0            
Ĵ
XCPT_FLOAT_DIVIDE_BY_ZERO            0xC00000950x10         
Ĵ
XCPT_FLOAT_INVALID_OPERATION         0xC00000970x10         
Ĵ
XCPT_ILLEGAL_INSTRUCTION             0xC000001C0x06         
Ĵ
XCPT_PRIVILEGED_INSTRUCTION          0xC000009D0x0D         
Ĵ
XCPT_INTEGER_OVERFLOW                0xC000009C0x04         
Ĵ
XCPT_FLOAT_OVERFLOW                  0xC00000980x10         
Ĵ
XCPT_FLOAT_UNDERFLOW                 0xC000009A0x10         
Ĵ
XCPT_FLOAT_DENORMAL_OPERAND          0xC00000940x10         
Ĵ
XCPT_FLOAT_INEXACT_RESULT            0xC00000960x10         
Ĵ
XCPT_FLOAT_STACK_CHECK               0xC00000990x10         
Ĵ
XCPT_DATATYPE_MISALIGNMENT           0xC000009E0x11         
  ExceptionInfo[0] - R/W flag                               
  ExceptionInfo[1] - Alignment                              
  ExceptionInfo[2] - FaultAddr                              
Ĵ
XCPT_BREAKPOINT                      0xC000009F0x03         
Ĵ
XCPT_SINGLE_STEP                     0xC00000A00x01         



Portable, Fatal, Software-Generated Exceptions

Ŀ
Exception Name                       Value     Related Trap 
Ĵ
XCPT_IN_PAGE_ERROR                   0xC00000060x0E         
  ExceptionInfo[0] - FaultAddr                              
Ĵ
XCPT_PROCESS_TERMINATE               0xC0010001             
Ĵ
XCPT_ASYNC_PROCESS_TERMINATE         0xC0010002             
  ExceptionInfo[0] - TID of                                 
      terminating thread                                    
Ĵ
XCPT_NONCONTINUABLE_EXCEPTION        0xC0000024             
Ĵ
XCPT_INVALID_DISPOSITION             0xC0000025             



Non-Portable, Fatal Exceptions

Ŀ
Exception Name                       Value     Related Trap 
Ĵ
XCPT_INVALID_LOCK_SEQUENCE           0xC000001D             
Ĵ
XCPT_ARRAY_BOUNDS_EXCEEDED           0xC00000930x05         



Unwind Operation Exceptions

Ŀ
Exception Name                       Value     
Ĵ
XCPT_UNWIND                          0xC0000026
Ĵ
XCPT_BAD_STACK                       0xC0000027
Ĵ
XCPT_INVALID_UNWIND_TARGET           0xC0000028



Fatal Signal Exceptions

Ŀ
Exception Name                       Value     
Ĵ
XCPT_SIGNAL                          0xC0010003
  ExceptionInfo[ 0 ] - Signal                  
      Number                                   

*)
{$ENDIF OS2EXCEPTIONS}


