/*
  Copyright 2005, 2006, 2007 David Cad, Damien Stehl.

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2 of the License, or (at your
  option) any later version.

  This program is distributed in the hope that it will be useful, but WITHOUT
  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
  FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
  more details.

  You should have received a copy of the GNU General Public License along
  with this program; see the file COPYING.  If not, write to the Free
  Software Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
  02111-1307, USA.

  This program implements ideas from the paper "Floating-point LLL Revisited", 
  by Phong Nguyen and Damien Stehl, in the Proceedings of Eurocrypt'2005, 
  Springer-Verlag; and was partly inspired by Shoup's NTL library: 
  http://www.shoup.net/ntl/

*/

#include <iostream>
#include "llldiff.h"



using namespace std;



template <class ZT> 
int llldiff (ZZ_mat<ZT>* B1, ZZ_mat<ZT>* B2, int c, int r)
{
  int test=1, i, j, sg;
  Z_NR<ZT> tmp1;
  Z_NR<ZT> tmp2;

  for (i=0; i<r; i++){
    sg = 1;
    tmp1.abs(B1->Get(i,0));
    tmp2.abs(B2->Get(i,0));
    if (tmp1.cmp(tmp2)!=0){
      cerr << r << ", 0\n";
      test = 0;
    }
    if (tmp1.cmp(B1->Get(i,0))!=0) sg *=-1;
    if (tmp1.cmp(B2->Get(i,0))!=0) sg *=-1;

    if (sg == 1){
      for (j=1; j<c; j++){
	if (B1->Get(i,j).cmp(B2->Get(i,j))!=0){
	  cerr << i << " " << j << "\n";
	  test = 0;
	}
      }
    }
    else{
      for (j=1; j<c; j++){
	tmp1.mul_si(B1->Get(i,j),-1);
	if (tmp1.cmp(B2->Get(i,j))!=0){
	  cerr << i << " " << j << "\n";
	  test = 0;
	}
      }
    }
  }

  return (test);
}


/* ********************** */
/*  MAIN **************** */
/* ********************** */

int
main (int argc, char ** argv)
{
  /*arg parsing (rewrite)*/
  int r=0;
  int c=0;


  int ac=1;
  while (ac<argc){
    if (argv[ac][0]!='-'){
      cerr<<"Parse error : option expected\n";
      abort();
    }
    else{
      /* TODO  :better bound checking, name complete check */
      switch (argv[ac][1]){
      case 'r':
	++ac;
	r=atoi(argv[ac]);
	break;
      case 'c':
	++ac;
	c=atoi(argv[ac]);
	break;
      }
      ++ac;
    }
  }

#ifdef DEBUG
  printf("Arguments read c=%d r=%d\n", c, r);
#endif

  ZZ_mat<mpz_t> * zzmat1= new ZZ_mat<mpz_t>(r,c);
  ZZ_mat<mpz_t> * zzmat2= new ZZ_mat<mpz_t>(r,c);

  if (zzmat1->read()!=0) {cerr.flush();return 1;}
#ifdef DEBUG
  printf("Premire matrice entre.\n");
  zzmat1->print();
#endif
  if (zzmat2->read()!=0) {cerr.flush();return 1;}
#ifdef DEBUG
  printf("Deuxime matrice entre.\n");
  zzmat1->print();
#endif

  llldiff<mpz_t>(zzmat1, zzmat2, c, r);

  delete zzmat1;
  delete zzmat2;

}
