/*
Copyright (c) 2006-2008 Advanced Micro Devices, Inc. All Rights Reserved.
This software is subject to the Apache v2.0 License.
*/

#ifndef	__FWSIGNAL_OPT_H__
#define	__FWSIGNAL_OPT_H__

#include "buildnum.h"
#include "fwdev.h"
#include "fwSignal.h"


OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32u				)(const Fw32u* pSrc1, const Fw32u* pSrc2, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32f				)(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_64s				)(const Fw64s* pSrc1, const Fw64s* pSrc2, Fw64s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_64f				)(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32fc			)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, Fw32fc* pDst,int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_64fc			)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, Fw64fc* pDst,int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_8u16u		)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_16s32f		)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw32f* pDst,int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_16s_I			)(const Fw16s* pSrc, Fw16s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32f_I			)(const Fw32f* pSrc, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_64f_I			)(const Fw64f* pSrc, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32fc_I		)(const Fw32fc* pSrc, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_64fc_I		)(const Fw64fc* pSrc, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_16s32s_I			)(const Fw16s* pSrc, Fw32s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_8u_Sfs		)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw8u* pDst,int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_16s_Sfs	)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw16s*pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32s_Sfs	)(const Fw32s* pSrc1, const Fw32s* pSrc2, Fw32s*pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_16sc_Sfs	)(const Fw16sc* pSrc1, const Fw16sc* pSrc2, Fw16sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32sc_Sfs	)(const Fw32sc* pSrc1, const Fw32sc* pSrc2, Fw32sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_8u_ISfs		)(const Fw8u* pSrc, Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_16s_ISfs	)(const Fw16s* pSrc, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32s_ISfs	)(const Fw32s* pSrc, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_16sc_ISfs			)(const Fw16sc* pSrc, Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAdd_32sc_ISfs			)(const Fw32sc* pSrc, Fw32sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32f			)(const Fw32f* pSrc, Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_64f			)(const Fw64f* pSrc, Fw64f val, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32fc			)(const Fw32fc* pSrc, Fw32fc val,Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_64fc			)(const Fw64fc* pSrc, Fw64fc val, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_16s_I		)(Fw16s val, Fw16s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32f_I		)(Fw32f val, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_64f_I		)(Fw64f val, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32fc_I	)(Fw32fc val, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_64fc_I	)(Fw64fc val, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_8u_Sfs	)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_16s_Sfs	)(const Fw16s* pSrc, Fw16s val, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32s_Sfs	)(const Fw32s* pSrc, Fw32s val, Fw32s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_16sc_Sfs	)(const Fw16sc* pSrc, Fw16sc val, Fw16sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32sc_Sfs		)(const Fw32sc* pSrc, Fw32sc val, Fw32sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_8u_ISfs		)(Fw8u val, Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_16s_ISfs		)(Fw16s val, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32s_ISfs		)(Fw32s val, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_16sc_ISfs		)(Fw16sc val, Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddC_32sc_ISfs		)(Fw32sc val, Fw32sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_16s				)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32f				)(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_64f				)(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32fc			)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_64fc			)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_16s32f			)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_16s_I			)(const Fw16s* pSrc, Fw16s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32f_I			)(const Fw32f* pSrc, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_64s				)(const Fw64s* pSrc1, const Fw64s* pSrc2, Fw64s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_64f_I			)(const Fw64f* pSrc, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32fc_I			)(const Fw32fc* pSrc, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_64fc_I			)(const Fw64fc* pSrc, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_8u_Sfs			)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw8u* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_16s_Sfs			)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32s_Sfs			)(const Fw32s* pSrc1, const Fw32s* pSrc2, Fw32s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_16sc_Sfs		)(const Fw16sc* pSrc1, const Fw16sc* pSrc2, Fw16sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32sc_Sfs		)(const Fw32sc* pSrc1, const Fw32sc* pSrc2, Fw32sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_8u_ISfs			)(const Fw8u* pSrc, Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_16s_ISfs		)(const Fw16s* pSrc, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32s_ISfs		)(const Fw32s* pSrc, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_16sc_ISfs		)(const Fw16sc* pSrc, Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSub_32sc_ISfs		)(const Fw32sc* pSrc, Fw32sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32f			)(const Fw32f* pSrc, Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32fc			)(const Fw32fc* pSrc, Fw32fc val, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_64f			)(const Fw64f* pSrc, Fw64f val, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_64fc			)(const Fw64fc* pSrc, Fw64fc val, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_16s_I			)(Fw16s val, Fw16s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32f_I			)(Fw32f val, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_64f_I			)(Fw64f val, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32fc_I			)(Fw32fc val, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_64fc_I			)(Fw64fc val, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_8u_Sfs			)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_16s_Sfs		)(const Fw16s* pSrc, Fw16s val, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32s_Sfs		)(const Fw32s* pSrc, Fw32s val, Fw32s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_16sc_Sfs		)(const Fw16sc* pSrc, Fw16sc val, Fw16sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32sc_Sfs		)(const Fw32sc* pSrc, Fw32sc val, Fw32sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_8u_ISfs		)(Fw8u val, Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_16s_ISfs		)(Fw16s val, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32s_ISfs		)(Fw32s val, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_16sc_ISfs		)(Fw16sc val, Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubC_32sc_ISfs		)(Fw32sc val, Fw32sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32f			)(const Fw32f* pSrc, Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_64f			)(const Fw64f* pSrc, Fw64f val, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32fc		)(const Fw32fc* pSrc, Fw32fc val, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_64fc		)(const Fw64fc* pSrc, Fw64fc val, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32f_I		)(Fw32f val, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_64f_I		)(Fw64f val, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32fc_I		)(Fw32fc val, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_64fc_I		)(Fw64fc val, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_8u_Sfs		)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_16s_Sfs		)(const Fw16s* pSrc, Fw16s val, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32s_Sfs		)(const Fw32s* pSrc, Fw32s val, Fw32s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_16sc_Sfs	)(const Fw16sc* pSrc, Fw16sc val, Fw16sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32sc_Sfs	)(const Fw32sc* pSrc, Fw32sc val, Fw32sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_8u_ISfs		)(Fw8u val, Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_16s_ISfs	)(Fw16s val, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32s_ISfs	)(Fw32s val, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_16sc_ISfs	)(Fw16sc val, Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSubCRev_32sc_ISfs	)(Fw32sc val, Fw32sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddProduct_32f		)(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddProduct_64f		)(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddProduct_32fc		)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddProduct_64fc		)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddProduct_16s_Sfs	)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddProduct_32s_Sfs	)(const Fw32s* pSrc1, const Fw32s* pSrc2, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAddProduct_16s32s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAnd_8u				)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAnd_16u				)(const Fw16u* pSrc1, const Fw16u* pSrc2, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAnd_32u				)(const Fw32u* pSrc1, const Fw32u* pSrc2, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAnd_8u_I				)(const Fw8u* pSrc, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAnd_16u_I				)(const Fw16u* pSrc, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAnd_32u_I				)(const Fw32u* pSrc, Fw32u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOr_8u					)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOr_16u				)(const Fw16u* pSrc1, const Fw16u* pSrc2, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOr_32u				)(const Fw32u* pSrc1, const Fw32u* pSrc2, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOr_8u_I				)(const Fw8u* pSrc, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOr_16u_I				)(const Fw16u* pSrc, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOr_32u_I				)(const Fw32u* pSrc, Fw32u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXor_8u				)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXor_16u				)(const Fw16u* pSrc1, const Fw16u* pSrc2, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXor_32u				)(const Fw32u* pSrc1, const Fw32u* pSrc2, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXor_8u_I				)(const Fw8u* pSrc, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXor_16u_I				)(const Fw16u* pSrc, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXor_32u_I				)(const Fw32u* pSrc, Fw32u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAndC_8u				)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAndC_16u				)(const Fw16u* pSrc, Fw16u val, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAndC_32u				)(const Fw32u* pSrc, Fw32u val, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAndC_8u_I				)(Fw8u val, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAndC_16u_I			)(Fw16u val, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAndC_32u_I			)(Fw32u val, Fw32u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOrC_8u				)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOrC_16u				)(const Fw16u* pSrc, Fw16u val, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOrC_32u				)(const Fw32u* pSrc, Fw32u val, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOrC_8u_I				)(Fw8u val, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOrC_16u_I				)(Fw16u val, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsOrC_32u_I				)(Fw32u val, Fw32u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXorC_8u				)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXorC_16u				)(const Fw16u* pSrc, Fw16u val, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXorC_32u				)(const Fw32u* pSrc, Fw32u val, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXorC_8u_I				)(Fw8u val, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXorC_16u_I			)(Fw16u val, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsXorC_32u_I			)(Fw32u val, Fw32u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNot_8u				)(const Fw8u* pSrc, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNot_16u				)(const Fw16u* pSrc, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNot_32u				)(const Fw32u* pSrc, Fw32u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNot_8u_I				)(Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNot_16u_I				)(Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNot_32u_I				)(Fw32u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_8u			)(const Fw8u* pSrc, int val, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_16s			)(const Fw16s* pSrc, int val, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_16u			)(const Fw16u* pSrc, int val, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_32s			)(const Fw32s* pSrc, int val, Fw32s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_8u_I			)(int val, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_16u_I			)(int val, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_16s_I			)(int val, Fw16s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLShiftC_32s_I			)(int val, Fw32s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_8u			)(const Fw8u* pSrc, int val, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_16s			)(const Fw16s* pSrc, int val, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_16u			)(const Fw16u* pSrc, int val, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_32s			)(const Fw32s* pSrc, int val, Fw32s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_8u_I			)(int val, Fw8u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_16u_I			)(int val, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_16s_I			)(int val, Fw16s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsRShiftC_32s_I			)(int val, Fw32s* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16s)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw16s *pDst,int len);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32f)(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f *pDst,int len);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_64f)(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f *pDst,int len);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32fc)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, Fw32fc *pDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_64fc)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, Fw64fc *pDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_8u16u)(const Fw8u* pSrc1, const Fw8u* pSrc2,Fw16u *pDst,int len);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16s32f)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw32f *pDst,int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16s_I)(const Fw16s* pSrc, Fw16s* pSrcDst, int len);						
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32f_I)(const Fw32f* pSrc, Fw32f* pSrcDst, int len);						
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_64f_I)(const Fw64f* pSrc, Fw64f* pSrcDst, int len);						
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32fc_I)(const Fw32fc* pSrc, Fw32fc* pSrcDst, int len);					
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_64fc_I)(const Fw64fc* pSrc, Fw64fc* pSrcDst, int len);					
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_8u_Sfs)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw8u* pDst, int len, int scaleFactor);				
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw16s* pDst,int len, int scaleFactor);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32s_Sfs)(const Fw32s* pSrc1, const Fw32s* pSrc2, Fw32s* pDst,int len, int scaleFactor);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16sc_Sfs)(const Fw16sc* pSrc1, const Fw16sc* pSrc2, Fw16sc *pDst, int len, int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32sc_Sfs)(const Fw32sc* pSrc1, const Fw32sc* pSrc2, Fw32sc *pDst, int len, int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16u16s_Sfs)(const Fw16u* pSrc1, const Fw16s* pSrc2, Fw16s *pDst, int len, int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16s32s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw32s *pDst, int len, int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32s32sc_Sfs)(const Fw32s* pSrc1, const Fw32sc* pSrc2, Fw32sc *pDst, int len, int scaleFactor);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_8u_ISfs)(const Fw8u* pSrc, Fw8u* pSrcDst, int len, int scaleFactor);								
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16s_ISfs)(const Fw16s* pSrc, Fw16s* pSrcDst, int len, int scaleFactor);							
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32s_ISfs)(const Fw32s* pSrc, Fw32s* pSrcDst, int len, int scaleFactor);							
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_16sc_ISfs)(const Fw16sc* pSrc, Fw16sc* pSrcDst, int len, int scaleFactor);						
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32sc_ISfs)(const Fw32sc* pSrc, Fw32sc* pSrcDst, int len, int scaleFactor);						
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMul_32s32sc_ISfs)(const Fw32s* pSrc, Fw32sc* pSrcDst, int len, int scaleFactor);						
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32f)(const Fw32f* pSrc, Fw32f val, Fw32f* pDst, int len);				
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_64f)(const Fw64f* pSrc, Fw64f val, Fw64f* pDst, int len);				
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32fc)(const Fw32fc* pSrc, Fw32fc val, Fw32fc* pDst, int len);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_64fc)(const Fw64fc* pSrc, Fw64fc val, Fw64fc* pDst, int len);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_16s_I)(Fw16s val, Fw16s* pSrcDst, int len);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32f_I)(Fw32f val, Fw32f* pSrcDst, int len);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_64f_I)(Fw64f val, Fw64f* pSrcDst, int len);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32fc_I)(Fw32fc val, Fw32fc* pSrcDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_64fc_I)(Fw64fc val, Fw64fc* pSrcDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_8u_Sfs)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len, int scaleFactor);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_16s_Sfs)(const Fw16s* pSrc, Fw16s val, Fw16s* pDst, int len,int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32s_Sfs)(const Fw32s* pSrc, Fw32s val, Fw32s* pDst, int len,int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_16sc_Sfs)(const Fw16sc* pSrc, Fw16sc val, Fw16sc* pDst, int len, int scaleFactor);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32sc_Sfs)(const Fw32sc* pSrc, Fw32sc val, Fw32sc* pDst, int len, int scaleFactor);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_8u_ISfs)(Fw8u val, Fw8u* pSrcDst, int len, int scaleFactor);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_16s_ISfs)(Fw16s val, Fw16s* pSrcDst, int len, int scaleFactor);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32s_ISfs)(Fw32s val, Fw32s* pSrcDst, int len, int scaleFactor);			
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_16sc_ISfs)(Fw16sc val, Fw16sc* pSrcDst, int len, int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32sc_ISfs)(Fw32sc val, Fw32sc* pSrcDst, int len, int scaleFactor);		
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_32f16s_Sfs)(const Fw32f* pSrc, Fw32f val, Fw16s* pDst,int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMulC_Low_32f16s)(const Fw32f* pSrc, Fw32f val, Fw16s* pDst,int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_16s)(const Fw16s* pSrc, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_32s)(const Fw32s* pSrc, Fw32s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_16s_I)(Fw16s* pSrcDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_32s_I)(Fw32s* pSrcDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_32f_I)(Fw32f* pSrcDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAbs_64f_I)(Fw64f* pSrcDst, int len);	
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32f_I)(Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64f_I)(Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_8u_Sfs)(const Fw8u* pSrc, Fw8u* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_16s_Sfs)(const Fw16s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_16u_Sfs)(const Fw16u* pSrc, Fw16u* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_8u_ISfs)(Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_16s_ISfs)(Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_16u_ISfs)(Fw16u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_32f_I)(Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_64f_I)(Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32s16s_Sfs)(const Fw32s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR			  FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64s16s_Sfs)(const Fw64s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32fc_I)(Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64fc_I)(Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_16sc_ISfs)(Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_16sc_Sfs)(const Fw16sc* pSrc, Fw16sc* pDst, int len, int scaleFactor);
OREFR			  FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64s_Sfs)(const Fw64s* pSrc, Fw64s* pDst, int len, int scaleFactor);
OREFR			  FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64s_ISfs)(Fw64s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_8u_Sfs)(const Fw8u* pSrc, Fw8u* pDst, int len,int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_16s_Sfs)(const Fw16s* pSrc, Fw16s* pDst, int len,int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_16u_Sfs)(const Fw16u* pSrc, Fw16u* pDst, int len,int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_8u_ISfs)(Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_16s_ISfs)(Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_16u_ISfs)(Fw16u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len) ;
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_32fc_I)(Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_64fc_I)(Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_16sc_Sfs)(const Fw16sc* pSrc, Fw16sc* pDst, int len,int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqr_16sc_ISfs)(Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormalize_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f vsub,Fw32f vdiv);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormalize_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f vsub,Fw64f vdiv);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormalize_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len, Fw32fc vsub, Fw32f vdiv);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormalize_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len, Fw64fc vsub, Fw64f vdiv);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormalize_16s_Sfs)(const Fw16s* pSrc, Fw16s* pDst, int len, Fw16s vsub, int vdiv, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormalize_16sc_Sfs)(const Fw16sc* pSrc, Fw16sc* pDst, int len, Fw16sc vsub, int vdiv, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32f)(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_64f)(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32fc)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, Fw32fc* pDst,int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_64fc)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, Fw64fc* pDst,int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32f_I)(const Fw32f* pSrc, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_64f_I)(const Fw64f* pSrc, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32fc_I)(const Fw32fc* pSrc, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_64fc_I)(const Fw64fc* pSrc, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_8u_Sfs)(const Fw8u* pSrc1, const Fw8u* pSrc2, Fw8u* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_16s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, Fw16s* pDst,int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32s_Sfs)(const Fw32s* pSrc1, const Fw32s* pSrc2, Fw32s* pDst,int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_16sc_Sfs)(const Fw16sc* pSrc1, const Fw16sc* pSrc2, Fw16sc* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32s16s_Sfs)(const Fw16s* pSrc1, const Fw32s* pSrc2, Fw16s* pDst,int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_8u_ISfs)(const Fw8u* pSrc, Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_16s_ISfs)(const Fw16s* pSrc, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_16sc_ISfs)(const Fw16sc* pSrc, Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32s_ISfs)(const Fw32s* pSrc, Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_32f)(const Fw32f* pSrc, Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_64f)(const Fw64f* pSrc, Fw64f val, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_32fc)(const Fw32fc* pSrc, Fw32fc val, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_64fc)(const Fw64fc* pSrc, Fw64fc val, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_32f_I)(Fw32f val, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_64f_I)(Fw64f val, Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_32fc_I)(Fw32fc val, Fw32fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_64fc_I)(Fw64fc val, Fw64fc* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_8u_Sfs)(const Fw8u* pSrc, Fw8u val, Fw8u* pDst, int len,int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_16s_Sfs)(const Fw16s* pSrc, Fw16s val, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_16sc_Sfs)(const Fw16sc* pSrc, Fw16sc val, Fw16sc* pDst,int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_8u_ISfs)(Fw8u val, Fw8u* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_16s_ISfs)(Fw16s val, Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivC_16sc_ISfs)(Fw16sc val, Fw16sc* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivCRev_16u)(const Fw16u* pSrc, Fw16u val, Fw16u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivCRev_32f)(const Fw32f* pSrc, Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivCRev_16u_I)(Fw16u val, Fw16u* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDivCRev_32f_I)(Fw32f val, Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCubrt_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCubrt_32s16s_Sfs)(const Fw32s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32f64f)(const Fw32f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32f_I)(Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_64f_I)(Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_16s_Sfs)(const Fw16s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32s_Sfs)(const Fw32s* pSrc, Fw32s* pDst, int len, int scaleFactor);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_64s_Sfs)(const Fw64s* pSrc, Fw64s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_16s_ISfs)(Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32s_ISfs)(Fw32s* pSrcDst, int len, int scaleFactor);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_64s_ISfs)(Fw64s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_64f32f)(const Fw64f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32f_I)(Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_64f_I)(Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_16s_Sfs)(const Fw16s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32s_Sfs)(const Fw32s* pSrc, Fw32s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32s16s_Sfs)(const Fw32s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_16s_ISfs)(Fw16s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32s_ISfs)(Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fws10Log10_32s_Sfs)(const Fw32s* pSrc, Fw32s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fws10Log10_32s_ISfs)(Fw32s* pSrcDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsArctan_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsArctan_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsArctan_32f_I)(Fw32f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsArctan_64f_I)(Fw64f* pSrcDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_16s)(const Fw16s* pSrc, Fw16s* pDst, int len, Fw16s level, Fw16s value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f level, Fw32f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f level, Fw64f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_16sc)(const Fw16sc* pSrc, Fw16sc* pDst, int len, Fw16s level, Fw16sc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len, Fw32f level, Fw32fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len, Fw64f level, Fw64fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_16s_I)(Fw16s* pSrcDst, int len, Fw16s level, Fw16s value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_32f_I)(Fw32f* pSrcDst, int len, Fw32f level, Fw32f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_64f_I)(Fw64f* pSrcDst, int len, Fw64f level, Fw64f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_16sc_I)(Fw16sc* pSrcDst, int len, Fw16s level, Fw16sc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_32fc_I)(Fw32fc* pSrcDst, int len, Fw32f level, Fw32fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTVal_64fc_I)(Fw64fc* pSrcDst, int len, Fw64f level, Fw64fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_16s)(const Fw16s* pSrc, Fw16s* pDst, int len, Fw16s level, Fw16s value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f level, Fw32f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f level, Fw64f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_16sc)(const Fw16sc* pSrc, Fw16sc* pDst, int len, Fw16s level, Fw16sc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len, Fw32f level, Fw32fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len, Fw64f level, Fw64fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_16s_I)(Fw16s* pSrcDst, int len, Fw16s level, Fw16s value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_32f_I)(Fw32f* pSrcDst, int len, Fw32f level, Fw32f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_64f_I)(Fw64f* pSrcDst, int len, Fw64f level, Fw64f value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_16sc_I)(Fw16sc* pSrcDst, int len, Fw16s level, Fw16sc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_32fc_I)(Fw32fc* pSrcDst, int len, Fw32f level, Fw32fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GTVal_64fc_I)(Fw64fc* pSrcDst, int len, Fw64f level, Fw64fc value);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_16s)(const Fw16s* pSrc, Fw16s* pDst, int len, Fw16s levelLT, Fw16s valueLT, Fw16s levelGT, Fw16s valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_32s)(const Fw32s* pSrc, Fw32s* pDst, int len, Fw32s levelLT, Fw32s valueLT, Fw32s levelGT, Fw32s valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f levelLT, Fw32f valueLT, Fw32f levelGT, Fw32f valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f levelLT, Fw64f valueLT, Fw64f levelGT, Fw64f valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_16s_I)(Fw16s* pSrcDst, int len, Fw16s levelLT, Fw16s valueLT, Fw16s levelGT, Fw16s valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_32s_I)(Fw32s* pSrcDst, int len, Fw32s levelLT, Fw32s valueLT, Fw32s levelGT, Fw32s valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_32f_I)(Fw32f* pSrcDst, int len, Fw32f levelLT, Fw32f valueLT, Fw32f levelGT, Fw32f valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTValGTVal_64f_I)(Fw64f* pSrcDst, int len, Fw64f levelLT, Fw64f valueLT, Fw64f levelGT, Fw64f valueGT);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_16s)(const Fw16s* pSrc, Fw16s* pDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_32s)(const Fw32s* pSrc, Fw32s* pDst, int len, Fw32s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_16sc)(const Fw16sc* pSrc, Fw16sc* pDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_16s_I)(Fw16s* pSrcDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_32s_I)(Fw32s* pSrcDst, int len, Fw32s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_32f_I)(Fw32f* pSrcDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_64f_I)(Fw64f* pSrcDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_32fc_I)(Fw32fc* pSrcDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_64fc_I)(Fw64fc* pSrcDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LT_16sc_I)(Fw16sc* pSrcDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_16s)(const Fw16s* pSrc, Fw16s* pDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_32s)(const Fw32s* pSrc, Fw32s* pDst, int len, Fw32s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_16sc)(const Fw16sc* pSrc, Fw16sc* pDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_16s_I)(Fw16s* pSrcDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_32s_I)(Fw32s* pSrcDst, int len, Fw32s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_32f_I)(Fw32f* pSrcDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_64f_I)(Fw64f* pSrcDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_32fc_I)(Fw32fc* pSrcDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_64fc_I)(Fw64fc* pSrcDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_GT_16sc_I)(Fw16sc* pSrcDst, int len, Fw16s level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_16s)(const Fw16s* pSrc, Fw16s* pDst, int len, Fw16s level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len, Fw32f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len, Fw64f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_16sc)(const Fw16sc* pSrc, Fw16sc* pDst, int len, Fw16s level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_16s_I)(Fw16s* pSrcDst, int len, Fw16s level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_32f_I)(Fw32f* pSrcDst, int len, Fw32f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_64f_I)(Fw64f* pSrcDst, int len, Fw64f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_32fc_I)(Fw32fc* pSrcDst, int len, Fw32f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_64fc_I)(Fw64fc* pSrcDst, int len, Fw64f level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_16sc_I)(Fw16sc* pSrcDst, int len, Fw16s level, FwCmpOp relOp);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_32f)(const Fw32f* pSrc, Fw32f* pDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_64f)(const Fw64f* pSrc, Fw64f* pDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_32f_I)(Fw32f* pSrcDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_64f_I)(Fw64f* pSrcDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_32fc_I)(Fw32fc* pSrcDst, int len, Fw32f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsThreshold_LTInv_64fc_I)(Fw64fc* pSrcDst, int len, Fw64f level);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_32f)(const Fw32f* pSrcRe, const Fw32f* pSrcIm, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_64f)(const Fw64f* pSrcRe, const Fw64f* pSrcIm, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_32fc)(const Fw32fc* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_64fc)(const Fw64fc* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_16s32f)(const Fw16s* pSrcRe, const Fw16s* pSrcIm, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_16sc32f)(const Fw16sc* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_16s_Sfs)(const Fw16s* pSrcRe, const Fw16s* pSrcIm, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_16sc_Sfs)(const Fw16sc* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMagnitude_32sc_Sfs)(const Fw32sc* pSrc, Fw32s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_8s16s)(const Fw8s* pSrc,Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_8s32f)(const Fw8s* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_8u32f)(const Fw8u* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_16s32s)(const Fw16s* pSrc, Fw32s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_16s32f)(const Fw16s* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_16u32f)(const Fw16u* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32s16s)(const Fw32s* pSrc, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32s32f)(const Fw32s* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32s64f)(const Fw32s* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32f64f)(const Fw32f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_64f32f)(const Fw64f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_16s32f_Sfs)(const Fw16s* pSrc, Fw32f* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_16s64f_Sfs)(const Fw16s* pSrc, Fw64f* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32s16s_Sfs)(const Fw32s* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32s32f_Sfs)(const Fw32s* pSrc, Fw32f* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32s64f_Sfs)(const Fw32s* pSrc, Fw64f* pDst, int len, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32f8s_Sfs)(const Fw32f* pSrc, Fw8s* pDst, int len, FwRoundMode rndMode, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32f8u_Sfs)(const Fw32f* pSrc, Fw8u* pDst, int len, FwRoundMode rndMode, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32f16s_Sfs)(const Fw32f* pSrc, Fw16s* pDst, int len, FwRoundMode rndMode, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32f16u_Sfs)(const Fw32f* pSrc, Fw16u* pDst, int len, FwRoundMode rndMode, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_32f32s_Sfs)(const Fw32f* pSrc, Fw32s* pDst, int len, FwRoundMode rndMode, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_64s32s_Sfs)(const Fw64s* pSrc, Fw32s* pDst, int len, FwRoundMode rndMode, int scaleFactor);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsConvert_64f32s_Sfs)(const Fw64f* pSrc, Fw32s* pDst, int len, FwRoundMode rndMode, int scaleFactor);

#if BUILD_NUM_AT_LEAST( 9999 )
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_64fc)(const Fw64fc* pSrc, Fw64f* pDst, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_32fc)(const Fw32fc* pSrc, Fw32f* pDst, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_16sc32f)(const Fw16sc* pSrc, Fw32f* pDst, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_16sc_Sfs)(const Fw16sc* pSrc, Fw16s* pDst, int len, int scaleFactor);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_32sc_Sfs)(const Fw32sc* pSrc, Fw32s* pDst, int len, int scaleFactor);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_64f)(const Fw64f* pSrcRe, const Fw64f* pSrcIm, Fw64f* pDst, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_32f)(const Fw32f* pSrcRe, const Fw32f* pSrcIm, Fw32f* pDst, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_16s32f)(const Fw16s* pSrcRe, const Fw16s* pSrcIm, Fw32f* pDst, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPhase_16s_Sfs)(const Fw16s* pSrcRe, const Fw16s* pSrcIm, Fw16s* pDst, int len, int scaleFactor);
#endif

OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMax_16s)(const Fw16s* pSrc, int len, Fw16s* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMax_32s)(const Fw32s* pSrc, int len, Fw32s* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMax_32f)(const Fw32f* pSrc, int len, Fw32f* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMax_64f)(const Fw64f* pSrc, int len, Fw64f* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxIndx_16s)(const Fw16s* pSrc, int len, Fw16s* pMax, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxIndx_32s)(const Fw32s* pSrc, int len, Fw32s* pMax, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxIndx_32f)(const Fw32f* pSrc, int len, Fw32f* pMax, int* pIndx);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxIndx_64f)(const Fw64f* pSrc, int len, Fw64f* pMax, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxAbs_16s)(const Fw16s* pSrc, int len, Fw16s* pMaxAbs);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxAbs_32s)(const Fw32s* pSrc, int len, Fw32s* pMaxAbs);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxAbsIndx_16s)(const Fw16s* pSrc, int len, Fw16s* pMaxAbs, int* pIndx);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxAbsIndx_32s)(const Fw32s* pSrc, int len, Fw32s* pMaxAbs, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMin_16s)(const Fw16s* pSrc, int len, Fw16s* pMin);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMin_32s)(const Fw32s* pSrc, int len, Fw32s* pMin);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMin_32f)(const Fw32f* pSrc, int len, Fw32f* pMin);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMin_64f)(const Fw64f* pSrc, int len, Fw64f* pMin);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinIndx_16s)(const Fw16s* pSrc, int len, Fw16s* pMin, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinIndx_32s)(const Fw32s* pSrc, int len, Fw32s* pMin, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinIndx_32f)(const Fw32f* pSrc, int len, Fw32f* pMin, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinIndx_64f)(const Fw64f* pSrc, int len, Fw64f* pMin, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinAbs_16s)(const Fw16s* pSrc, int len, Fw16s* pMinAbs);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinAbs_32s)(const Fw32s* pSrc, int len, Fw32s* pMinAbs);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinAbsIndx_16s)(const Fw16s* pSrc, int len, Fw16s* pMinAbs, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinAbsIndx_32s)(const Fw32s* pSrc, int len, Fw32s* pMinAbs, int* pIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMax_8u)(const Fw8u* pSrc, int len, Fw8u* pMin, Fw8u* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMax_16u)(const Fw16u* pSrc, int len, Fw16u* pMin, Fw16u* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMax_16s)(const Fw16s* pSrc, int len, Fw16s* pMin, Fw16s* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMax_32u)(const Fw32u* pSrc, int len, Fw32u* pMin, Fw32u* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMax_32s)(const Fw32s* pSrc, int len, Fw32s* pMin, Fw32s* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMax_32f)(const Fw32f* pSrc, int len, Fw32f* pMin, Fw32f* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMax_64f)(const Fw64f* pSrc, int len, Fw64f* pMin, Fw64f* pMax);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMaxIndx_8u)(const Fw8u* pSrc, int len, Fw8u* pMin, int* pMinIndx, Fw8u* pMax, int* pMaxIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMaxIndx_16u)(const Fw16u* pSrc, int len, Fw16u* pMin, int* pMinIndx, Fw16u* pMax, int* pMaxIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMaxIndx_16s)(const Fw16s* pSrc, int len, Fw16s* pMin, int* pMinIndx, Fw16s* pMax, int* pMaxIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMaxIndx_32u)(const Fw32u* pSrc, int len, Fw32u* pMin, int* pMinIndx, Fw32u* pMax, int* pMaxIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMaxIndx_32s)(const Fw32s* pSrc, int len, Fw32s* pMin, int* pMinIndx, Fw32s* pMax, int* pMaxIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMaxIndx_32f)(const Fw32f* pSrc, int len, Fw32f* pMin, int* pMinIndx, Fw32f* pMax, int* pMaxIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinMaxIndx_64f)(const Fw64f* pSrc, int len, Fw64f* pMin, int* pMinIndx, Fw64f* pMax, int* pMaxIndx);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_Inf_32f)(const Fw32f* pSrc, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_Inf_64f)(const Fw64f* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_Inf_16s32f)(const Fw16s* pSrc, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_Inf_32fc32f)(const Fw32fc* pSrc, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_Inf_64fc64f)(const Fw64fc* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_Inf_16s32s_Sfs)(const Fw16s* pSrc, int len, Fw32s* pNorm,int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L1_32f)(const Fw32f* pSrc, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L1_64f)(const Fw64f* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L1_16s32f)(const Fw16s* pSrc, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L1_32fc64f)(const Fw32fc* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L1_64fc64f)(const Fw64fc* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L1_16s32s_Sfs)(const Fw16s* pSrc, int len, Fw32s* pNorm,int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L2_32f)(const Fw32f* pSrc, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L2_64f)(const Fw64f* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L2_16s32f)(const Fw16s* pSrc, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L2_32fc64f)(const Fw32fc* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L2_64fc64f)(const Fw64fc* pSrc, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNorm_L2_16s32s_Sfs)(const Fw16s* pSrc, int len, Fw32s* pNorm, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_Inf_32f)(const Fw32f* pSrc1, const Fw32f* pSrc2, int len,Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_Inf_64f)(const Fw64f* pSrc1, const Fw64f* pSrc2, int len,Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_Inf_16s32f)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_Inf_32fc32f)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, int len, Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_Inf_64fc64f)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_Inf_16s32s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2,int len, Fw32s* pNorm, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L1_32f)(const Fw32f* pSrc1, const Fw32f* pSrc2, int len,Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L1_64f)(const Fw64f* pSrc1, const Fw64f* pSrc2, int len,Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L1_16s32f)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len,Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L1_32fc64f)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L1_64fc64f)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L1_16s32s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len, Fw32s* pNorm, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L2_32f)(const Fw32f* pSrc1, const Fw32f* pSrc2, int len,Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L2_64f)(const Fw64f* pSrc1, const Fw64f* pSrc2, int len,Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L2_16s32f)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len,Fw32f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L2_32fc64f)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L2_64fc64f)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, int len, Fw64f* pNorm);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsNormDiff_L2_16s32s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len, Fw32s* pNorm, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMean_32f)(const Fw32f* pSrc, int len, Fw32f* pMean,FwHintAlgorithm hint);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMean_32fc)(const Fw32fc* pSrc, int len, Fw32fc* pMean,FwHintAlgorithm hint);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMean_64f)(const Fw64f* pSrc, int len, Fw64f* pMean);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMean_64fc)(const Fw64fc* pSrc, int len, Fw64fc* pMean);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMean_16s_Sfs)(const Fw16s* pSrc, int len, Fw16s* pMean, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMean_16sc_Sfs)(const Fw16sc* pSrc, int len, Fw16sc* pMean, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxEvery_16s_I)(const Fw16s* pSrc, Fw16s* pSrcDst, int len);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxEvery_32s_I)(const Fw32s* pSrc, Fw32s* pSrcDst, int len);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMaxEvery_32f_I)(const Fw32f* pSrc, Fw32f* pSrcDst, int len);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinEvery_16s_I)(const Fw16s* pSrc, Fw16s* pSrcDst, int len);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinEvery_32s_I)(const Fw32s* pSrc, Fw32s* pSrcDst, int len);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMinEvery_32f_I)(const Fw32f* pSrc, Fw32f* pSrcDst, int len);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32f)(const Fw32f* pSrc1, const Fw32f* pSrc2, int len,Fw32f* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32fc)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, int len,Fw32fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32f32fc)(const Fw32f* pSrc1, const Fw32fc* pSrc2, int len, Fw32fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32f64f)(const Fw32f* pSrc1, const Fw32f* pSrc2, int len,Fw64f* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32fc64fc)(const Fw32fc* pSrc1, const Fw32fc* pSrc2, int len, Fw64fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32f32fc64fc)(const Fw32f* pSrc1, const Fw32fc* pSrc2,int len, Fw64fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_64f)(const Fw64f* pSrc1, const Fw64f* pSrc2, int len,Fw64f* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_64fc)(const Fw64fc* pSrc1, const Fw64fc* pSrc2, int len,Fw64fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_64f64fc)(const Fw64f* pSrc1, const Fw64fc* pSrc2, int len, Fw64fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s64s)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len,Fw64s* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16sc64sc)(const Fw16sc* pSrc1, const Fw16sc* pSrc2, int len, Fw64sc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s16sc64sc)(const Fw16s* pSrc1, const Fw16sc* pSrc2,int len, Fw64sc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s32f)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len,Fw32f* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16sc32fc)(const Fw16sc* pSrc1, const Fw16sc* pSrc2, int len, Fw32fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s16sc32fc)(const Fw16s* pSrc1, const Fw16sc* pSrc2,int len, Fw32fc* pDp);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len, Fw16s* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16sc_Sfs)(const Fw16sc* pSrc1, const Fw16sc* pSrc2, int len, Fw16sc* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32s_Sfs)(const Fw32s* pSrc1, const Fw32s* pSrc2, int len, Fw32s* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32sc_Sfs)(const Fw32sc* pSrc1, const Fw32sc* pSrc2, int len, Fw32sc* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s32s_Sfs)(const Fw16s* pSrc1, const Fw16s* pSrc2, int len, Fw32s* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s16sc32sc_Sfs)(const Fw16s* pSrc1, const Fw16sc* pSrc2, int len, Fw32sc* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s32s32s_Sfs)(const Fw16s* pSrc1, const Fw32s* pSrc2,int len, Fw32s* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16s16sc_Sfs)(const Fw16s* pSrc1, const Fw16sc* pSrc2,int len, Fw16sc* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_16sc32sc_Sfs)(const Fw16sc* pSrc1, const Fw16sc* pSrc2,int len, Fw32sc* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDotProd_32s32sc_Sfs)(const Fw32s* pSrc1, const Fw32sc* pSrc2,int len, Fw32sc* pDp, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_32f)(const Fw32f* pSrc, int len, Fw32f* pSum, FwHintAlgorithm hint);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_32fc)(const Fw32fc* pSrc, int len, Fw32fc* pSum, FwHintAlgorithm hint);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_64f)(const Fw64f* pSrc, int len, Fw64f* pSum);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_64fc)(const Fw64fc* pSrc, int len, Fw64fc* pSum);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_16s_Sfs)(const Fw16s* pSrc, int len, Fw16s* pSum, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_32s_Sfs)(const Fw32s* pSrc, int len, Fw32s* pSum, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_16s32s_Sfs)(const Fw16s* pSrc, int len, Fw32s* pSum, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_16sc_Sfs)(const Fw16sc* pSrc, int len, Fw16sc* pSum, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSum_16sc32sc_Sfs)(const Fw16sc* pSrc, int len, Fw32sc* pSum, int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsStdDev_32f)(const Fw32f* pSrc, int len, Fw32f* pStdDev,FwHintAlgorithm hint);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsStdDev_64f)(const Fw64f* pSrc, int len, Fw64f* pStdDev);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsStdDev_16s32s_Sfs)(const Fw16s* pSrc, int len, Fw32s* pStdDev,int scaleFactor);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsStdDev_16s_Sfs)(const Fw16s* pSrc, int len, Fw16s* pStdDev, int scaleFactor);

OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInv_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInv_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInv_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInv_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInv_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32f_A11 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32f_A21 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_32f_A24 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_64f_A50 )(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsDiv_64f_A53 )(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32f_A11 )( const Fw32f* pSrc, Fw32f* pDst, int len );
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32f_A21 )( const Fw32f* pSrc, Fw32f* pDst, int len );
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_32f_A24 )( const Fw32f* pSrc, Fw32f* pDst, int len );
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64f_A50 )( const Fw64f* pSrc, Fw64f* pDst, int len );
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSqrt_64f_A53 )( const Fw64f* pSrc, Fw64f* pDst, int len );
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvSqrt_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvSqrt_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvSqrt_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvSqrt_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvSqrt_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCbrt_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCbrt_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCbrt_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCbrt_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCbrt_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvCbrt_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvCbrt_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvCbrt_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvCbrt_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsInvCbrt_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPow_32f_A11 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPow_32f_A21 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPow_32f_A24 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPow_64f_A50 )(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPow_64f_A53 )(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPowx_32f_A11 )(const Fw32f* pSrc1, const Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPowx_32f_A21 )(const Fw32f* pSrc1, const Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPowx_32f_A24 )(const Fw32f* pSrc1, const Fw32f val, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPowx_64f_A50 )(const Fw64f* pSrc1, const Fw64f val, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsPowx_64f_A53 )(const Fw64f* pSrc1, const Fw64f val, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsExp_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLn_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLog10_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLog10_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLog10_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLog10_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsLog10_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCos_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCos_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCos_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCos_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCos_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSin_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSin_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSin_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSin_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSin_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);

#if BUILD_NUM_AT_LEAST( 9999 )
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinCos_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst1, Fw32f* pDst2, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinCos_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst1, Fw32f* pDst2, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinCos_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst1, Fw32f* pDst2, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinCos_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst1, Fw64f* pDst2, int len);
OREFR       FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinCos_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst1, Fw64f* pDst2, int len);
#endif

OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTan_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTan_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTan_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTan_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTan_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcos_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcos_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcos_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcos_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcos_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsin_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsin_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsin_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsin_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsin_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan2_32f_A11 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan2_32f_A21 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan2_32f_A24 )(const Fw32f* pSrc1, const Fw32f* pSrc2, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan2_64f_A50 )(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtan2_64f_A53 )(const Fw64f* pSrc1, const Fw64f* pSrc2, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCosh_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCosh_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCosh_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCosh_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCosh_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinh_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinh_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinh_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinh_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSinh_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTanh_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTanh_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTanh_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTanh_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsTanh_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcosh_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcosh_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcosh_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcosh_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAcosh_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsinh_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsinh_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsinh_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsinh_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAsinh_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtanh_32f_A11 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtanh_32f_A21 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtanh_32f_A24 )(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtanh_64f_A50 )(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR             FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAtanh_64f_A53 )(const Fw64f* pSrc, Fw64f* pDst, int len);

OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCopy_8u)(const Fw8u* pSrc, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCopy_16s)(const Fw16s* pSrc, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCopy_16sc)(const Fw16sc* pSrc, Fw16sc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCopy_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCopy_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCopy_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsCopy_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMove_8u)(const Fw8u* pSrc, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMove_16s)(const Fw16s* pSrc, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMove_16sc)(const Fw16sc* pSrc, Fw16sc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMove_32f)(const Fw32f* pSrc, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMove_32fc)(const Fw32fc* pSrc, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMove_64f)(const Fw64f* pSrc, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMove_64fc)(const Fw64fc* pSrc, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_8u)(Fw8u val, Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_16s)(Fw16s val, Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_16sc)(Fw16sc val, Fw16sc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_32s)(Fw32s val, Fw32s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_32f)(Fw32f val, Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_32sc)(Fw32sc val, Fw32sc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_32fc)(Fw32fc val, Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_64s)(Fw64s val, Fw64s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_64f)(Fw64f val, Fw64f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_64sc)(Fw64sc val, Fw64sc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsSet_64fc)(Fw64fc val, Fw64fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsZero_8u)(Fw8u* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsZero_16s)(Fw16s* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsZero_16sc)(Fw16sc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsZero_32f)(Fw32f* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsZero_32fc)(Fw32fc* pDst, int len);
OREFR OSSE2 OF10H FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsZero_64f)(Fw64f* pDst, int len);

OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFind_8u)(const Fw8u* pSrc, int len, const Fw8u* pFind, int lenFind, int* pIndex);
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFind_16u)(const Fw16u* pSrc, int len, const Fw16u* pFind, int lenFind, int* pIndex);
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFindRev_8u)(const Fw8u* pSrc, int len, const Fw8u* pFind, int lenFind, int* pIndex);
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFindRev_16u)(const Fw16u* pSrc, int len, const Fw16u* pFind, int lenFind, int* pIndex);
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFindC_8u)(const Fw8u* pSrc, int len, Fw8u valFind, int* pIndex);
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFindC_16u)(const Fw16u* pSrc, int len, Fw16u valFind, int* pIndex);
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFindRevC_8u)(const Fw8u* pSrc, int len, Fw8u valFind, int* pIndex);
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsFindRevC_16u)(const Fw16u* pSrc, int len, Fw16u valFind, int* pIndex);
OREFR OSSE2     FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMin_8s)( const Fw8s  *pSrc, int len, Fw8s  *pMin );
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMin_64u)( const Fw64u *pSrc, int len, Fw64u *pMin );
OREFR OSSE2     FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMax_8s)( const Fw8s  *pSrc, int len, Fw8s  *pMax );
OREFR FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsMax_64u)( const Fw64u *pSrc, int len, Fw64u *pMax );

//AutoCorrelation Functions
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_32f)(const  Fw32f*  pSrc,  int  srcLen,  Fw32f*  pDst,  int  dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormA_32f)(const  Fw32f*  pSrc,  int  srcLen,  Fw32f*  pDst,  int  dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormB_32f)(const  Fw32f*  pSrc,  int  srcLen,  Fw32f*  pDst,  int  dstLen);

OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_32fc)(const Fw32fc* pSrc, int srcLen, Fw32fc* pDst, int dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormA_32fc)(const  Fw32fc*  pSrc,  int  srcLen,  Fw32fc*  pDst,  int  dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormB_32fc)(const  Fw32fc*  pSrc,  int  srcLen,  Fw32fc*  pDst,  int  dstLen);

OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_64f)(const  Fw64f*  pSrc,  int  srcLen,  Fw64f*  pDst,  int  dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormA_64f)(const  Fw64f*  pSrc,  int  srcLen,  Fw64f*  pDst,  int  dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormB_64f)(const  Fw64f*  pSrc,  int  srcLen,  Fw64f*  pDst,  int  dstLen);

OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_64fc)(const  Fw64fc*  pSrc,  int  srcLen,  Fw64fc*  pDst,  int  dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormA_64fc)(const  Fw64fc*  pSrc,  int  srcLen,  Fw64fc*  pDst,  int  dstLen);
OREFR OSSE2 FwStatus STDCALL PREFIX_OPT(OPT_PREFIX, fwsAutoCorr_NormB_64fc)(const  Fw64fc*  pSrc,  int  srcLen,  Fw64fc*  pDst,  int  dstLen);

#endif // __FWSIGNAL_OPT_H__
