/**
 *  Copyright (C) 2002-2007  The FreeCol Team
 *
 *  This file is part of FreeCol.
 *
 *  FreeCol is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  FreeCol is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with FreeCol.  If not, see <http://www.gnu.org/licenses/>.
 */

package net.sf.freecol.client.gui.action;

import java.awt.event.ActionEvent;
import java.util.logging.Logger;

import javax.swing.KeyStroke;

import net.sf.freecol.client.FreeColClient;

/**
 * An action for displaying the
 * {@link net.sf.freecol.client.gui.panel.EuropePanel}.
 */
public class EuropeAction extends MapboardAction {
    @SuppressWarnings("unused")
    private static final Logger logger = Logger.getLogger(EuropeAction.class.getName());




    public static final String id = "europeAction";


    /**
     * Creates a new <code>EuropeAction</code>.
     * 
     * @param freeColClient The main controller object for the client.
     */
    EuropeAction(FreeColClient freeColClient) {
        super(freeColClient, "menuBar.view.europe", null, KeyStroke.getKeyStroke('E', 0));
    }

    /**
     * Returns the id of this <code>Option</code>.
     * 
     * @return "europeAction"
     */
    public String getId() {
        return id;
    }

    /**
     * Checks if this action should be enabled.
     * 
     * @return <code>true</code> if the player has access to Europe.
     */
    protected boolean shouldBeEnabled() {
        return super.shouldBeEnabled() && getFreeColClient().getMyPlayer() != null
                && getFreeColClient().getMyPlayer().getEurope() != null;
    }

    /**
     * Applies this action.
     * 
     * @param e The <code>ActionEvent</code>.
     */
    public void actionPerformed(ActionEvent e) {
        getFreeColClient().getCanvas().showEuropePanel();
    }
}
