/***************************************************************************
 *   Copyright (C) 2004 by Predrag Viceic                                  *
 *   viceic@net2000.ch                                            *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "potentiometerwidget.h"
#include "pics/acidknob/acidknob.h"
#include <qpainter.h>

PotentiometerWidget::PotentiometerWidget(QWidget *parent, const char *name)
 : QDial(parent, name)
{
    init=TRUE;
    setMinValue(0);
    setMaxValue(100);
    setValue(0);

}


PotentiometerWidget::~PotentiometerWidget()
{
}

void PotentiometerWidget::repaintScreen ( const QRect * /*_rect*/){
    static QPixmap pixmap;
    if(rect().size().isValid()){
        pixmap.resize(rect().size());
        QPainter p(&pixmap);
        p.fillRect(rect(),colorGroup().background());
        int image_num=maxValue()==minValue()?0:((value()-minValue())*99)/(maxValue()-minValue());
        image_num=image_num<0?0:image_num>99?99:image_num;
        p.drawImage(rect(),getKnobImage(image_num).smoothScale(size()));
        bitBlt(this,0,0,&pixmap);
    }
}

QImage PotentiometerWidget::getKnobImage(int i) const
{
    QByteArray baunzip;
    baunzip = qUncompress( acidknob_embed_image_vec[i].data,
                           acidknob_embed_image_vec[i].compressed );
    QImage img((uchar*)baunzip.data(),
                acidknob_embed_image_vec[i].width,
                acidknob_embed_image_vec[i].height,
                acidknob_embed_image_vec[i].depth,
                (QRgb*)acidknob_embed_image_vec[i].colorTable,
                acidknob_embed_image_vec[i].numColors,
                QImage::BigEndian
              );
    img = img.copy();
    if ( acidknob_embed_image_vec[i].alpha )
        img.setAlphaBuffer(TRUE);
    return img;
}

void PotentiometerWidget::setValue ( int val){
    //disable min->max and max->min value jumping
    if (init==TRUE){
        QDial::setValue(val);
        init=false;
    }else if(abs(value()-val)<abs(maxValue()-minValue())/4){
        QDial::setValue(val);
    }
}
