//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003, 2004 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: ObjectTransformer.cpp,v 1.1 2004/04/25 20:03:16 delpinux Exp $

#include <ObjectTransformer.hpp>
#include <Object.hpp>

#include <Sphere.hpp>
#include <Cylinder.hpp>
#include <Cone.hpp>
#include <Cube.hpp>
#include <Plane.hpp>
#include <Torus.hpp>

#include <Union.hpp>
#include <Difference.hpp>
#include <Intersection.hpp>
#include <Not.hpp>

#include <InfiniteCylinder.hpp>
#include <InfiniteCone.hpp>

ReferenceCounting<Object>
ObjectTransformer::operator()(const Object& o) const
{
  const Shape& s = *o.shape();

  Shape* newShape = 0;
  switch (s.type()) {
  case Shape::sphere: {
    newShape = new Sphere(static_cast<const Sphere&>(s));
    break;
  }
  case Shape::cylinder: {
    newShape = new Cylinder(static_cast<const Cylinder&>(s));
    break;
  }
  case Shape::cone: {
    newShape = new Cone(static_cast<const Cone&>(s));
    break;
  }
  case Shape::cube: {
    newShape = new Cube(static_cast<const Cube&>(s));
    break;
  }
  case Shape::plane: {
    newShape = new Plane(static_cast<const Plane&>(s));
    break;
  }
  case Shape::torus: {
    newShape = new Torus(static_cast<const Torus&>(s));
    break;
  }
  case Shape::union_: {
    newShape = new Union(static_cast<const Union&>(s));
    break;
  }
  case Shape::difference: {
    newShape = new Difference(static_cast<const Difference&>(s));
    break;
  }
  case Shape::intersection: {
    newShape = new Intersection(static_cast<const Intersection&>(s));
    break;
  }
  case Shape::not_: {
    newShape = new Not(static_cast<const Not&>(s));
    break;
  }
  case Shape::infiniteCylinder: {
    newShape = new InfiniteCylinder(static_cast<const InfiniteCylinder&>(s));
    break;
  }
  case Shape::infiniteCone: {
    newShape = new InfiniteCone(static_cast<const InfiniteCone&>(s));
    break;
  }
  }

  Shape::TransformationsList transformations(__addedTransformations.size()
					     + s.transformationsList().size());

  for (size_t i=0; i<s.transformationsList().size(); ++i) {
    transformations[i+__addedTransformations.size()]
      = s.transformationsList()[i];
  }
  for (size_t i=0; i<__addedTransformations.size(); ++i) {
    transformations[i] = __addedTransformations[i];
  }
  assert(newShape != 0);

  newShape->setTransformationsList(transformations);
  return new Object(newShape);
}
