//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Translation.cpp,v 1.2 2003/05/04 18:09:01 delpinux Exp $

#include <Translation.hpp>
#include <TinyVector.hpp>

#include <sstream>

//! Applies the Translation to the vector \a v.
TinyVector<3>& Translation::operator()(TinyVector<3>& v) const
{
  for (int i=0; i<3; i++)
    v[i] += __vect[i];

  return v;
}

//! Applies the inverse Translation to the vector \a v.
TinyVector<3>& Translation::inverse(TinyVector<3>& v) const
{
  for (int i=0; i<3; i++)
    v[i] -= __vect[i];

  return v;
}

//! Constructs a Translation by vector \a v.
Translation::Translation(const TinyVector<3>& v)
{
  __type = translation;
  __vect = v;
}

//! Default constructor.
Translation::Translation()
{
  __type = translation;
  __vect = 0;
}

//! Copy constructor.
Translation::Translation(const Translation& T)
{
  __type = translation;
  __vect = T.__vect;
}

//! Prints Translation informations to a std::string.
std::string Translation::povWrite() const
{
  std::stringstream povs;
  povs << "translation <"
       << __vect[0]
       << ", "
       << __vect[1]
       << ", "
       << __vect[2]
       << ">";
  povs << std::ends;
  return povs.str();
}

