//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: PDESolution.cpp,v 1.1.1.1 2003/02/17 16:32:51 delpinux Exp $

#include <PDESolution.hpp>
#include <UserFunction.hpp>

void PDESolution::
setUserFunction (const std::vector<ReferenceCounting<FEMUserFunction> >& U)
{
  Vector<real_t>& v = static_cast<Vector<real_t>& >(*pValue);
  for (size_t i=0; i<__degreeOfFreedomSet.numberOfVariables(); ++i)
    for(size_t j=0; j<__degreeOfFreedomSet.numberOfVertices(); ++j) {
      v[__degreeOfFreedomSet(i,j)]=(*U[i])[j];
    }
}

void PDESolution::
getUserFunction (std::vector<ReferenceCounting<FEMUserFunction> >& U) const
{
  Vector<real_t>& v = static_cast<Vector<real_t>& >(*pValue);
  for (size_t i=0; i<__degreeOfFreedomSet.numberOfVariables(); ++i)
    for(size_t j=0; j<__degreeOfFreedomSet.numberOfVertices(); ++j)
      (*U[i])[j] =  v[__degreeOfFreedomSet(i,j)];
}

PDESolution::PDESolution(const DegreeOfFreedomSet& d)
  : __degreeOfFreedomSet(d)
{
  pValue = new Vector<real_t>(__degreeOfFreedomSet.size());
}

