//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: VerticesSet.hpp,v 1.2 2003/09/14 17:16:17 delpinux Exp $

#ifndef VERTICESSET_HPP
#define VERTICESSET_HPP

#include <Vertex.hpp>
#include <Vector.hpp>

class VerticesSet
{
private:
    Vector<Vertex> __vertices;
public:
    //! Returns the number of the vertex V in the list
  inline const size_t number(const Vertex& V) const
  {
    return __vertices.number(V);
  }

  //! Read-only access to the number of vertices.
  inline const size_t& numberOfVertices() const
  {
    return __vertices.size();
  }

  //! Change the size of the vertices container.
  inline void setNumberOfVertices(const size_t size)
  {
    return __vertices.resize(size);
  }

  inline const Vertex& operator[](const size_t& i) const
  {
    assert (i<__vertices.size());
    return __vertices[i];
  }

  inline Vertex& operator[](const size_t& i)
  {
    assert (i<__vertices.size());
    return __vertices[i];
  }

  VerticesSet(const size_t& s)
    : __vertices(s)
  {
    ;
  }

  VerticesSet(const VerticesSet& v)
    : __vertices(v.__vertices)
  {
    ;
  }

  ~VerticesSet()
  {
    ;
  }
};

#endif // VERTICESSET_HPP
