//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: StaticCenter.cpp,v 1.2 2003/12/26 18:38:02 uid68082 Exp $

#include <StaticCenter.hpp>
#include <iostream>

#include <StreamCenter.hpp>
#include <Information.hpp>
#include <ReferenceCounting.hpp>

#include <Q1FiniteElement.hpp>
#include <P1FiniteElement.hpp>

#include <QuadratureFormula.hpp>

#include <ParameterCenter.hpp>

bool StaticCenter::__instanciated(false);

StaticCenter::StaticCenter()
{
  if (__instanciated==true) {
    std::cerr << "Cannot use more than one StaticCenter\n";
    std::exit(1);
  }

  /// utils
  StreamCenter::create();
  ReferenceCountingCenter::create();

  /// Language utils
  Information::create();
  ParameterCenter::create();

  /// Quadrature formulae
  QuadratureFormulaQ1Hexahedron::create();
  QuadratureFormulaP1Tetrahedron::create();

  QuadratureFormulaP1Triangle3D::create();
  QuadratureFormulaQ1Quadrangle3D::create();

  /// Finite elements
  Q1FiniteElement::create();
  P1FiniteElement::create();
}

StaticCenter::~StaticCenter()
{
  /// Finite elements
  Q1FiniteElement::destroy();
  P1FiniteElement::destroy();

  /// Quadrature formulae
  QuadratureFormulaP1Tetrahedron::destroy();
  QuadratureFormulaQ1Hexahedron::destroy();

  QuadratureFormulaP1Triangle3D::destroy();
  QuadratureFormulaQ1Quadrangle3D::destroy();

  /// Language utils
  ParameterCenter::destroy();
  Information::destroy();

  /// utils
  ReferenceCountingCenter::destroy();
  StreamCenter::destroy();
}
