//  This file is part of ff3d - http://www.freefem.org/ff3d
//  Copyright (C) 2001, 2002, 2003 Stphane Del Pino

//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2, or (at your option)
//  any later version.

//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.

//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software Foundation,
//  Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.  

//  $Id: Difference.cpp,v 1.2 2003/09/02 16:03:21 delpinux Exp $


// This class provides a toolkit to manipulate Differences. It
// inherits from the Shape class.


#include <Difference.hpp>

//! Prints the Difference informations using the stream \a os.
std::ostream& Difference::put(std::ostream& os) const
{
  os << "difference {\n";
  for (Difference::const_iterator i = __objects.begin();
       i != __objects.end(); i++) {
    os << *(*i);
  }

  for (size_t i=0; i<nbTransform(); i++) {
    os << (*__trans[i]).povWrite() << '\n';
  }
  os << "}\n";

  return os;
}


