/* 
   extension.c: freehoo extensions to guile
   
   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License as
   published by the Free Software Foundation; either version 2, or (at
   your option) any later version.

   This program is distributed in the hope that it will be useful, but
   WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA. */


#include <guile/gh.h>
#include "extension.h"
#include "freehoo.h"
#include "scm-procedures.h"

SCM ex_message_send_hook;
SCM ex_message_receive_hook;
SCM ex_contact_added_hook;
SCM ex_message_receive_offline_hook;
SCM ex_login_post_hook;
int hook_return = 0;

int
get_hook_return (void)
{
  return hook_return;
}

void
set_hook_return (int hook_return_value)
{
  hook_return = hook_return_value;
}

SCM
get_message_send_hook ()
{
  return (ex_message_send_hook);
}

SCM
get_message_receive_hook ()
{
  return (ex_message_receive_hook);
}

SCM
get_contact_added_hook ()
{
 return (ex_contact_added_hook);
}

SCM
get_message_receive_offline_hook ()
{
  return (ex_message_receive_offline_hook);
}

SCM
get_login_post_hook ()
{
  return (ex_login_post_hook);
}

void
install_new_variables (void)
{
  // This is this is the place to install new variables
}

void
install_new_hooks (void)
{
  /* 
     ;; sample eqivalent code in scheme

     (define hook-test (make-hook 2))
     (define hook-proc (lambda (frm message)
     (display frm)
     (newline)
     (display message)
     (newline)))
     (add-hook! hook-test hook-proc)
     (run-hook hook-test "hi" "test")
   */

  /* scm_create_hook creates a hook with name, which is
     interned. This is only really useful from c, since in scheme, you
     can (define name (make-hook n_args))
   */

  ex_message_send_hook =
    scm_create_hook ("fh-message-send-hook", 2);
  /* hook: fh-message-send-hook

     is called from
     file: yahoo-wrapper.c
     function: send_message (...)

     with arguments
     "message-to" and "message-data"

     set the hook like this
     (add-hook! fh-message-send-hook (lambda (to message) (do-something)))
   */

  ex_message_receive_hook =
    scm_create_hook ("fh-message-receive-hook", 2);
  /* hook: fh-message-receive-offline-hook
     is called from
     file: yafh-wrapper.c
     function: send_message (...)
     with arguments
     "message-from" and "message-data"

     set the hook like this
     (add-hook! fh-message-receive-hook (lambda (from message) (do-something)))
   */
  ex_contact_added_hook =
    scm_create_hook ("fh-contact-added-hook", 2);
  /*
    set the hook like this
    (add-hook! fh-contact-added-hook (lambda (from message)  (do-something)))
   */

  ex_message_receive_offline_hook = 
    scm_create_hook ("fh-message-receive-offline-hook", 3);
  /* hook: fh-message-receive-offline-hook

     is called from
     file: yahoo-wrapper.c
     function: process_offline_message (...)
     with arguments
     "message-from" "message-data" "message-time"
     
     set the hook like this
     (add-hook! fh-message-send-hook (lambda (from message time) (do-something)))
   */

  ex_login_post_hook = scm_create_hook ("fh-login-post-hook", 0);
  /* hook: fh-login-post-hook
     is called from
     file: messenger.c
     function: send_message (...)
     with arguments
     "message-from" and "message-data"

     set the hook like this
     (add-hook! fh-login-post-hook (lambda () (do-something)))
   */
}

void
install_new_procedures (void)
{
  /* installing general procedures */
  gh_new_procedure ("fh-load", ex_load, 1, 0, 0);
  /* this way you call me
     (fh-load "aliases.scm")
  */

  gh_new_procedure ("fh-send-message", ex_send_message, 2, 0, 0);
  /* this way you call me
     (fh-send-message "hello gnu")
  */

  gh_new_procedure ("fh-send-message-no-hook", 
		    ex_send_message_no_hook, 2, 0, 0);
  /* this way you call me
     (fh-send-message-no-hook "hello gnu")
  */

  gh_new_procedure ("fh-set-current-target-buddy!",
		    ex_set_current_target_buddy_x, 1, 0, 0);
  /* this way you call me
     (fh-set-current-target-buddy! "my_friend")
  */

  gh_new_procedure ("fh-register-command!",
		    ex_register_command_x, 1, 0, 0);
  /* this way you call me
     (fh-register-command  "?ping")
  */

  gh_new_procedure ("fh-unregister-command!",
		    ex_unregister_command_x, 1, 0, 0);
  /* this way you call me
     (fh-unregister-command  "?ping")
  */

  gh_new_procedure ("fh-version", ex_version, 0, 0, 0);
  /* this way you call me
     (display (fh-version))
  */

  gh_new_procedure ("fh-display", ex_display, 1, 0, 0);
  /* this way you call me
     (fh-display "Hello GNU")
  */

  gh_new_procedure ("fh-get-buddy-list",
		    ex_get_buddy_list, 0, 0, 0);
  /* this way you call me
     (define buddy_list (fh-get-buddy-list))
  */

  gh_new_procedure ("fh-add-buddy",
		    ex_add_buddy, 1, 1, 0);
    
  /* this way you call me
     (fh-add-buddy "balugi" "GNU")
  */

  /* installing configuration procedures */
  gh_new_procedure ("fh-bell!", ex_bell, 0, 0, 0);
  /* this way you call me
     (fh-bell!)
  */

  gh_new_procedure ("fh-toggle!", ex_toggle_x, 1, 0, 0);
  /* this way you call me
     (fh-bell-toggle! 'bell)
  */

  gh_new_procedure ("fh-get-home-dir", ex_get_home_dir, 0, 0, 0);
  /* this way you call me
     (display (fh-get-home-dir))
  */

  gh_new_procedure ("fh-get-config-dir", 
		    ex_get_config_dir, 0, 0, 0);
  /* this way you call me
     (display (fh-get-config-dir))
  */

  gh_new_procedure ("fh-get-config-filename",
		    ex_get_config_filename, 0, 0, 0);
  /* this way you call me
     (display (fh-get-config-filename)
  */

  gh_new_procedure ("fh-get-download-filename",
		    ex_get_download_filename, 0, 0, 0);
  /* this way you call me
     (display (fh-get-downlaod-filename)
  */

  gh_new_procedure ("fh-get-global-extensions-directory",
		    ex_get_global_extensions_directory, 0, 0, 0);
  /* this way you call me
     (display (fh-get-global-extensions-directory))
  */

  gh_new_procedure ("fh-get-local-extensions-directory",
		    ex_get_local_extensions_directory, 0, 0, 0);
  /* this way you call me
     (display (fh-get-local-extensions-directory))
  */

  gh_new_procedure ("fh-get-default-login-id",
		    ex_get_default_login_id, 0, 0, 0);
  /* this way you call me
     (display (fh-get-login-id))
  */

  gh_new_procedure ("fh-set-default-login-id!",
		    ex_set_default_login_id_x, 1, 0, 0);
  /* this way you call me
     (fh-set-login-id! "abindian")
  */

  gh_new_procedure ("fh-set-default-password!",
		    ex_set_default_password_x, 1, 0, 0);
  /* this way you call me
     (fh-set-login-id! "press_enter")
  */

  gh_new_procedure ("fh-set-default-status!",
		    ex_set_default_status_x, 1, 0, 0);
  /* this way you call me
     ;; default to invisible mode
     (fh-set-status! 12)
  */

  gh_new_procedure ("fh-set-prompt!", ex_set_prompt_x, 1, 0, 0);
  /* this way you call me
     ;; set prompt string
     (fh-set-prompt! "~qp~> ")
  */

  /* installing hook related procedures */
  gh_new_procedure ("fh-hook-return", ex_hook_return, 0, 0, 0);
  /* this way you call me
     (fh-hook-return)
  */

  /* installing hook related procedures */
  gh_new_procedure ("fh-quit", ex_fh_quit, 0, 0, 0);
  /* this way you call me
     (fh-quit)
  */

  /* installing hook related procedures */
  gh_new_procedure ("fh-logoff", ex_fh_logoff, 0, 0, 0);
  /* this way you call me
     (fh-logoff)
  */
}

// guile initialization area
void
guile_env_init (void)
{
  install_new_variables ();
  install_new_procedures ();
  install_new_hooks ();
}
