#ifndef __FWEELIN_KEYIO_H
#define __FWEELIN_KEYIO_H

#include <pthread.h>

#include "fweelin_event.h"

class Fweelin;

// Deprecated!
class KeySettings {
 public:
  KeySettings() :
    leftshift(0), rightshift(0), leftctrl(0), rightctrl(0),
    leftalt(0), rightalt(0), upkey(0), downkey(0), spacekey(0) {};

  // Function modifier keys
  char leftshift,
    rightshift,
    leftctrl,
    rightctrl,
    leftalt,
    rightalt,
    upkey,
    downkey,
    spacekey;
};

class SDLKeyList {
 public:
  SDLKeyList (SDLKey k) : k(k), next(0) {};

  SDLKey k;
  SDLKeyList *next;
};

// Keyboard Handler
class KeyIO : public EventProducer, public EventListener {
public:
  KeyIO (Fweelin *app) : app(app), keythreadgo(0) {
    keyheld = new char[SDLK_LAST];
    for (int i = 0; i < SDLK_LAST; i++)
      keyheld[i] = 0;
  };
  virtual ~KeyIO() { 
    delete[] keyheld;
  };

  int activate ();
  void close ();

  char IsActive () { return keythreadgo; };
  char *GetKeysHeld () { return keyheld; };

  KeySettings *getSETS() { return &sets; };

  void ReceiveEvent(Event *ev, EventProducer *from);

  // We use slightly modified keynames for the config system:
  // Gets the SDL keysym that corresponds to key with a given name
  static SDLKey GetSDLKey(char *keyname);
  // And the name corresponding to the keysym..
  static const char *GetSDLName(SDLKey sym);

protected:
  // Core app
  Fweelin *app;

  // Keys currently held down- array for all SDLKeys, nonzero if held
  char *keyheld;

  // Deprecated
  KeySettings sets;

  // Key event handler thread
  static void *run_key_thread (void *ptr);

  void handle_key(int keycode, char press);

  pthread_t key_thread;
  char keythreadgo;
};

#endif
