(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[      2181,         72]*)
(*NotebookOutlinePosition[      2821,         95]*)
(*  CellTagsIndexPosition[      2777,         91]*)
(*WindowFrame->Normal*)



Notebook[{

Cell[CellGroupData[{
Cell[BoxData[{
    \(n = {nx, ny, nz}\), "\n", 
    \(b\  = {bx, by, bz}\)}], "Input"],

Cell[BoxData[
    \({nx, ny, nz}\)], "Output"],

Cell[BoxData[
    \({bx, by, bz}\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Solve[\((k\ n - b)\) . n == 0, k]\)], "Input"],

Cell[BoxData[
    \({{k \[Rule] \(-\(\(\(-bx\)\ nx - by\ ny - bz\ nz\)\/\(nx\^2 + ny\^2 + 
                  nz\^2\)\)\)}}\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for X",
ScreenRectangle->{{0, 1280}, {0, 1024}},
WindowSize->{960, 897},
WindowMargins->{{95, Automatic}, {Automatic, 16}}
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{

Cell[CellGroupData[{
Cell[1739, 51, 86, 2, 43, "Input"],
Cell[1828, 55, 46, 1, 27, "Output"],
Cell[1877, 58, 46, 1, 27, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[1960, 64, 66, 1, 27, "Input"],
Cell[2029, 67, 136, 2, 47, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

